/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.builder.Diff;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class DiffResult<T>
implements Iterable<Diff<?>> {
    public static final String OBJECTS_SAME_STRING = "";
    private final List<Diff<?>> diffList;
    private final T lhs;
    private final T rhs;
    private final ToStringStyle style;
    private final String toStringFormat;

    /*
     * WARNING - void declaration
     */
    DiffResult(T lhs, T rhs, List<Diff<?>> diffList, ToStringStyle style, String toStringFormat) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.diffList = (List)Objects.requireNonNull(var3_3, "diffList");
        this.lhs = Objects.requireNonNull(var1_1, "lhs");
        this.rhs = Objects.requireNonNull(var2_2, "rhs");
        this.style = Objects.requireNonNull(style, "style");
        this.toStringFormat = Objects.requireNonNull(toStringFormat, "toStringFormat");
    }

    public List<Diff<?>> getDiffs() {
        return Collections.unmodifiableList(this.diffList);
    }

    public T getLeft() {
        return this.lhs;
    }

    public int getNumberOfDiffs() {
        return this.diffList.size();
    }

    public T getRight() {
        return this.rhs;
    }

    public ToStringStyle getToStringStyle() {
        return this.style;
    }

    @Override
    public Iterator<Diff<?>> iterator() {
        return this.diffList.iterator();
    }

    public String toString() {
        DiffResult diffResult = this;
        return diffResult.toString(diffResult.style);
    }

    /*
     * WARNING - void declaration
     */
    public String toString(ToStringStyle style) {
        void var1_1;
        void var2_2;
        if (this.diffList.isEmpty()) {
            return OBJECTS_SAME_STRING;
        }
        ToStringBuilder lhsBuilder = new ToStringBuilder(this.lhs, style);
        ToStringBuilder rhsBuilder = new ToStringBuilder(this.rhs, style);
        this.diffList.forEach(diff -> {
            void var2_2;
            void var1_1;
            lhsBuilder.append(diff.getFieldName(), diff.getLeft());
            var1_1.append(diff.getFieldName(), var2_2.getRight());
        });
        return String.format(this.toStringFormat, var2_2.build(), var1_1.build());
    }
}

