/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayFill;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.CharSequenceUtils;
import org.apache.commons.lang3.CharUtils;
import org.apache.commons.lang3.Charsets;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.function.Suppliers;
import org.apache.commons.lang3.function.ToBooleanBiFunction;
import org.apache.commons.lang3.stream.LangCollectors;
import org.apache.commons.lang3.stream.Streams;

public class StringUtils {
    public static final String SPACE = " ";
    public static final String EMPTY = "";
    public static final String LF = "\n";
    public static final String CR = "\r";
    public static final int INDEX_NOT_FOUND = -1;
    private static final int PAD_LIMIT = 8192;
    private static final Pattern STRIP_ACCENTS_PATTERN = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");

    /*
     * WARNING - void declaration
     */
    public static String abbreviate(String str, int maxWidth) {
        void var1_1;
        return StringUtils.abbreviate(str, "...", 0, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String abbreviate(String str, int offset, int maxWidth) {
        void var2_2;
        void var1_1;
        return StringUtils.abbreviate(str, "...", (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String abbreviate(String str, String abbrevMarker, int maxWidth) {
        void var2_2;
        void var1_1;
        return StringUtils.abbreviate(str, (String)var1_1, 0, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String abbreviate(String str, String abbrevMarker, int offset, int maxWidth) {
        void var3_3;
        String string;
        void var1_1;
        if (StringUtils.isNotEmpty(str) && EMPTY.equals(abbrevMarker) && maxWidth > 0) {
            return StringUtils.substring(str, 0, maxWidth);
        }
        if (StringUtils.isAnyEmpty(str, abbrevMarker)) {
            return str;
        }
        int abbrevMarkerLength = abbrevMarker.length();
        int minAbbrevWidth = abbrevMarkerLength + 1;
        int n2 = abbrevMarkerLength;
        int minAbbrevWidthOffset = n2 + n2 + 1;
        if (maxWidth < minAbbrevWidth) {
            throw new IllegalArgumentException(String.format("Minimum abbreviation width is %d", minAbbrevWidth));
        }
        int strLen = str.length();
        if (strLen <= maxWidth) {
            return str;
        }
        if (offset > strLen) {
            offset = strLen;
        }
        if (strLen - offset < maxWidth - abbrevMarkerLength) {
            offset = strLen - (maxWidth - abbrevMarkerLength);
        }
        if (offset <= abbrevMarkerLength + 1) {
            return str.substring(0, maxWidth - abbrevMarkerLength) + abbrevMarker;
        }
        if (maxWidth < minAbbrevWidthOffset) {
            throw new IllegalArgumentException(String.format("Minimum abbreviation width with offset is %d", minAbbrevWidthOffset));
        }
        if (offset + maxWidth - abbrevMarkerLength < strLen) {
            void var2_2;
            return abbrevMarker + StringUtils.abbreviate(str.substring((int)var2_2), abbrevMarker, maxWidth - abbrevMarkerLength);
        }
        return (String)var1_1 + string.substring(strLen - (var3_3 - abbrevMarkerLength));
    }

    /*
     * WARNING - void declaration
     */
    public static String abbreviateMiddle(String str, String middle, int length) {
        void var2_2;
        String string;
        void var1_1;
        void var3_3;
        if (StringUtils.isAnyEmpty(str, middle) || length >= str.length() || length < middle.length() + 2) {
            return str;
        }
        int targetSting = length - middle.length();
        int startOffset = targetSting / 2 + targetSting % 2;
        int endOffset = str.length() - targetSting / 2;
        return str.substring(0, (int)var3_3) + (String)var1_1 + string.substring((int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static String appendIfMissing(String str, CharSequence suffix, boolean ignoreCase, CharSequence ... suffixes) {
        void var1_1;
        String string;
        if (str == null || StringUtils.isEmpty(suffix) || StringUtils.endsWith(str, suffix, ignoreCase)) {
            return str;
        }
        if (ArrayUtils.isNotEmpty(suffixes)) {
            void var3_3;
            for (void s2 : var3_3) {
                if (!StringUtils.endsWith(str, (CharSequence)s2, ignoreCase)) continue;
                return str;
            }
        }
        return string + var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static String appendIfMissing(String str, CharSequence suffix, CharSequence ... suffixes) {
        void var2_2;
        void var1_1;
        return StringUtils.appendIfMissing(str, (CharSequence)var1_1, false, (CharSequence[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String appendIfMissingIgnoreCase(String str, CharSequence suffix, CharSequence ... suffixes) {
        void var2_2;
        void var1_1;
        return StringUtils.appendIfMissing(str, (CharSequence)var1_1, true, (CharSequence[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String capitalize(String str) {
        void var3_3;
        int newCodePoint;
        int strLen = StringUtils.length(str);
        if (strLen == 0) {
            return str;
        }
        int firstCodepoint = str.codePointAt(0);
        if (firstCodepoint == (newCodePoint = Character.toTitleCase(firstCodepoint))) {
            return str;
        }
        int[] newCodePoints = new int[strLen];
        int outOffset = 0;
        ++outOffset;
        newCodePoints[0] = newCodePoint;
        for (int inOffset = Character.charCount(firstCodepoint); inOffset < strLen; inOffset += Character.charCount((int)var3_3)) {
            int codePoint = str.codePointAt(inOffset);
            newCodePoints[outOffset++] = codePoint;
        }
        return new String(newCodePoints, 0, outOffset);
    }

    /*
     * WARNING - void declaration
     */
    public static String center(String str, int size) {
        void var1_1;
        return StringUtils.center(str, (int)var1_1, ' ');
    }

    /*
     * WARNING - void declaration
     */
    public static String center(String str, int size, char padChar) {
        void var2_2;
        void var1_1;
        void var3_3;
        String string;
        if (str == null || size <= 0) {
            return str;
        }
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        string = StringUtils.leftPad(string, (int)(var3_3 + pads / 2), padChar);
        return StringUtils.rightPad(string, (int)var1_1, (char)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String center(String str, int size, String padStr) {
        void var2_2;
        void var1_1;
        void var3_3;
        String string;
        int strLen;
        int pads;
        if (str == null || size <= 0) {
            return str;
        }
        if (StringUtils.isEmpty(padStr)) {
            padStr = SPACE;
        }
        if ((pads = size - (strLen = str.length())) <= 0) {
            return str;
        }
        string = StringUtils.leftPad(string, (int)(var3_3 + pads / 2), padStr);
        return StringUtils.rightPad(string, (int)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String chomp(String str) {
        void var1_2;
        String string;
        void var2_3;
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        if (str.length() == 1) {
            char ch = str.charAt(0);
            if (ch == '\r' || ch == '\n') {
                return EMPTY;
            }
            return str;
        }
        int lastIdx = str.length() - 1;
        char last = str.charAt(lastIdx);
        if (last == '\n') {
            if (str.charAt(lastIdx - 1) == '\r') {
                --lastIdx;
            }
        } else if (var2_3 != 13) {
            ++lastIdx;
        }
        return string.substring(0, (int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String chomp(String str, String separator) {
        void var1_1;
        return StringUtils.removeEnd(str, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String chop(String str) {
        void var2_3;
        String string;
        if (str == null) {
            return null;
        }
        int strLen = str.length();
        if (strLen < 2) {
            return EMPTY;
        }
        int lastIdx = strLen - 1;
        String ret = str.substring(0, lastIdx);
        char c2 = string.charAt(lastIdx);
        if (c2 == '\n' && ret.charAt(lastIdx - 1) == '\r') {
            void var1_2;
            return ret.substring(0, (int)(var1_2 - true));
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public static int compare(String str1, String str2) {
        void var1_1;
        return StringUtils.compare(str1, (String)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public static int compare(String str1, String str2, boolean nullIsLess) {
        void var1_1;
        String string;
        if (str1 == str2) {
            return 0;
        }
        if (str1 == null) {
            if (nullIsLess) {
                return -1;
            }
            return 1;
        }
        if (str2 == null) {
            void var2_2;
            if (var2_2 != false) {
                return 1;
            }
            return -1;
        }
        return string.compareTo((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int compareIgnoreCase(String str1, String str2) {
        void var1_1;
        return StringUtils.compareIgnoreCase(str1, (String)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public static int compareIgnoreCase(String str1, String str2, boolean nullIsLess) {
        void var1_1;
        String string;
        if (str1 == str2) {
            return 0;
        }
        if (str1 == null) {
            if (nullIsLess) {
                return -1;
            }
            return 1;
        }
        if (str2 == null) {
            void var2_2;
            if (var2_2 != false) {
                return 1;
            }
            return -1;
        }
        return string.compareToIgnoreCase((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contains(CharSequence seq, CharSequence searchSeq) {
        void var1_1;
        CharSequence charSequence;
        if (seq == null || searchSeq == null) {
            return false;
        }
        return CharSequenceUtils.indexOf(charSequence, (CharSequence)var1_1, 0) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contains(CharSequence seq, int searchChar) {
        void var1_1;
        CharSequence charSequence;
        if (StringUtils.isEmpty(seq)) {
            return false;
        }
        return CharSequenceUtils.indexOf(charSequence, (int)var1_1, 0) >= 0;
    }

    public static boolean containsAny(CharSequence cs, char ... searchChars) {
        if (StringUtils.isEmpty(cs) || ArrayUtils.isEmpty(searchChars)) {
            return false;
        }
        int csLength = cs.length();
        int searchLength = searchChars.length;
        int csLast = csLength - 1;
        int searchLast = searchLength - 1;
        for (int i2 = 0; i2 < csLength; ++i2) {
            char ch = cs.charAt(i2);
            for (int j2 = 0; j2 < searchLength; ++j2) {
                if (searchChars[j2] != ch) continue;
                if (!Character.isHighSurrogate(ch)) {
                    return true;
                }
                if (j2 == searchLast) {
                    return true;
                }
                if (i2 >= csLast || searchChars[j2 + 1] != cs.charAt(i2 + 1)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean containsAny(CharSequence cs, CharSequence searchChars) {
        void var1_1;
        CharSequence charSequence;
        if (searchChars == null) {
            return false;
        }
        return StringUtils.containsAny(charSequence, CharSequenceUtils.toCharArray((CharSequence)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static boolean containsAny(CharSequence cs, CharSequence ... searchCharSequences) {
        void var1_1;
        CharSequence charSequence;
        return StringUtils.containsAny(StringUtils::contains, charSequence, (CharSequence[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean containsAny(ToBooleanBiFunction<CharSequence, CharSequence> test, CharSequence cs, CharSequence ... searchCharSequences) {
        void var2_2;
        if (StringUtils.isEmpty(cs) || ArrayUtils.isEmpty(searchCharSequences)) {
            return false;
        }
        for (void searchCharSequence : var2_2) {
            if (!test.applyAsBoolean(cs, (CharSequence)searchCharSequence)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean containsAnyIgnoreCase(CharSequence cs, CharSequence ... searchCharSequences) {
        void var1_1;
        CharSequence charSequence;
        return StringUtils.containsAny(StringUtils::containsIgnoreCase, charSequence, (CharSequence[])var1_1);
    }

    public static boolean containsIgnoreCase(CharSequence str, CharSequence searchStr) {
        if (str == null || searchStr == null) {
            return false;
        }
        int len = searchStr.length();
        int max = str.length() - len;
        for (int i2 = 0; i2 <= max; ++i2) {
            if (!CharSequenceUtils.regionMatches(str, true, i2, searchStr, 0, len)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsNone(CharSequence cs, char ... searchChars) {
        if (cs == null || searchChars == null) {
            return true;
        }
        int csLen = cs.length();
        int csLast = csLen - 1;
        int searchLen = searchChars.length;
        int searchLast = searchLen - 1;
        for (int i2 = 0; i2 < csLen; ++i2) {
            char ch = cs.charAt(i2);
            for (int j2 = 0; j2 < searchLen; ++j2) {
                if (searchChars[j2] != ch) continue;
                if (!Character.isHighSurrogate(ch)) {
                    return false;
                }
                if (j2 == searchLast) {
                    return false;
                }
                if (i2 >= csLast || searchChars[j2 + 1] != cs.charAt(i2 + 1)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean containsNone(CharSequence cs, String invalidChars) {
        void var1_1;
        CharSequence charSequence;
        if (invalidChars == null) {
            return true;
        }
        return StringUtils.containsNone(charSequence, var1_1.toCharArray());
    }

    /*
     * WARNING - void declaration
     */
    public static boolean containsOnly(CharSequence cs, char ... valid) {
        void var1_1;
        CharSequence charSequence;
        if (valid == null || cs == null) {
            return false;
        }
        if (cs.length() == 0) {
            return true;
        }
        if (valid.length == 0) {
            return false;
        }
        return StringUtils.indexOfAnyBut(charSequence, (char[])var1_1) == -1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean containsOnly(CharSequence cs, String validChars) {
        void var1_1;
        CharSequence charSequence;
        if (cs == null || validChars == null) {
            return false;
        }
        return StringUtils.containsOnly(charSequence, var1_1.toCharArray());
    }

    public static boolean containsWhitespace(CharSequence seq) {
        if (StringUtils.isEmpty(seq)) {
            return false;
        }
        int strLen = seq.length();
        for (int i2 = 0; i2 < strLen; ++i2) {
            if (!Character.isWhitespace(seq.charAt(i2))) continue;
            return true;
        }
        return false;
    }

    private static void convertRemainingAccentCharacters(StringBuilder decomposed) {
        block17: for (int i2 = 0; i2 < decomposed.length(); ++i2) {
            char c2 = decomposed.charAt(i2);
            switch (c2) {
                case '\u0141': {
                    decomposed.setCharAt(i2, 'L');
                    continue block17;
                }
                case '\u0142': {
                    decomposed.setCharAt(i2, 'l');
                    continue block17;
                }
                case '\u0110': {
                    decomposed.setCharAt(i2, 'D');
                    continue block17;
                }
                case '\u0111': {
                    decomposed.setCharAt(i2, 'd');
                    continue block17;
                }
                case '\u0197': {
                    decomposed.setCharAt(i2, 'I');
                    continue block17;
                }
                case '\u0268': {
                    decomposed.setCharAt(i2, 'i');
                    continue block17;
                }
                case '\u1d7b': {
                    decomposed.setCharAt(i2, 'I');
                    continue block17;
                }
                case '\u1da4': {
                    decomposed.setCharAt(i2, 'i');
                    continue block17;
                }
                case '\u1da7': {
                    decomposed.setCharAt(i2, 'I');
                    continue block17;
                }
                case '\u0244': {
                    decomposed.setCharAt(i2, 'U');
                    continue block17;
                }
                case '\u0289': {
                    decomposed.setCharAt(i2, 'u');
                    continue block17;
                }
                case '\u1d7e': {
                    decomposed.setCharAt(i2, 'U');
                    continue block17;
                }
                case '\u1db6': {
                    decomposed.setCharAt(i2, 'u');
                    continue block17;
                }
                case '\u0166': {
                    decomposed.setCharAt(i2, 'T');
                    continue block17;
                }
                case '\u0167': {
                    decomposed.setCharAt(i2, 't');
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static int countMatches(CharSequence str, char ch) {
        void var2_2;
        if (StringUtils.isEmpty(str)) {
            return 0;
        }
        int count = 0;
        for (int i2 = 0; i2 < str.length(); ++i2) {
            if (ch != str.charAt(i2)) continue;
            ++count;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static int countMatches(CharSequence str, CharSequence sub) {
        void var2_2;
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(sub)) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        while ((idx = CharSequenceUtils.indexOf(str, sub, idx)) != -1) {
            ++count;
            idx += sub.length();
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T defaultIfBlank(T str, T defaultStr) {
        T t2;
        if (StringUtils.isBlank(str)) {
            void var1_1;
            return var1_1;
        }
        return t2;
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T defaultIfEmpty(T str, T defaultStr) {
        T t2;
        if (StringUtils.isEmpty(str)) {
            void var1_1;
            return var1_1;
        }
        return t2;
    }

    public static String defaultString(String str) {
        return Objects.toString(str, EMPTY);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String defaultString(String str, String nullDefault) {
        void var1_1;
        return Objects.toString(str, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String deleteWhitespace(String str) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        int sz = str.length();
        char[] chs = new char[sz];
        int count = 0;
        for (int i2 = 0; i2 < sz; ++i2) {
            if (Character.isWhitespace(str.charAt(i2))) continue;
            chs[count++] = str.charAt(i2);
        }
        if (count == var1_1) {
            String string;
            return string;
        }
        if (count == 0) {
            return EMPTY;
        }
        return new String((char[])var2_2, 0, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static String difference(String str1, String str2) {
        void var0_1;
        void var1_2;
        if (str1 == null) {
            return str2;
        }
        if (str2 == null) {
            return str1;
        }
        int at = StringUtils.indexOfDifference((CharSequence)str1, (CharSequence)str2);
        if (at == -1) {
            return EMPTY;
        }
        return var1_2.substring((int)var0_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean endsWith(CharSequence str, CharSequence suffix) {
        void var1_1;
        return StringUtils.endsWith(str, (CharSequence)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean endsWith(CharSequence str, CharSequence suffix, boolean ignoreCase) {
        void var1_1;
        void var3_3;
        void var2_2;
        CharSequence charSequence;
        if (str == null || suffix == null) {
            return str == suffix;
        }
        if (suffix.length() > str.length()) {
            return false;
        }
        int strOffset = str.length() - suffix.length();
        return CharSequenceUtils.regionMatches(charSequence, (boolean)var2_2, (int)var3_3, suffix, 0, var1_1.length());
    }

    /*
     * WARNING - void declaration
     */
    public static boolean endsWithAny(CharSequence sequence2, CharSequence ... searchStrings) {
        void var1_1;
        if (StringUtils.isEmpty(sequence2) || ArrayUtils.isEmpty(searchStrings)) {
            return false;
        }
        for (void searchString : var1_1) {
            if (!StringUtils.endsWith(sequence2, (CharSequence)searchString)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean endsWithIgnoreCase(CharSequence str, CharSequence suffix) {
        void var1_1;
        return StringUtils.endsWith(str, (CharSequence)var1_1, true);
    }

    public static boolean equals(CharSequence cs1, CharSequence cs2) {
        if (cs1 == cs2) {
            return true;
        }
        if (cs1 == null || cs2 == null) {
            return false;
        }
        if (cs1.length() != cs2.length()) {
            return false;
        }
        if (cs1 instanceof String && cs2 instanceof String) {
            return cs1.equals(cs2);
        }
        int length = cs1.length();
        for (int i2 = 0; i2 < length; ++i2) {
            if (cs1.charAt(i2) == cs2.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean equalsAny(CharSequence string, CharSequence ... searchStrings) {
        if (ArrayUtils.isNotEmpty(searchStrings)) {
            void var1_1;
            for (void next : var1_1) {
                if (!StringUtils.equals(string, (CharSequence)next)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean equalsAnyIgnoreCase(CharSequence string, CharSequence ... searchStrings) {
        if (ArrayUtils.isNotEmpty(searchStrings)) {
            void var1_1;
            for (void next : var1_1) {
                if (!StringUtils.equalsIgnoreCase(string, (CharSequence)next)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean equalsIgnoreCase(CharSequence cs1, CharSequence cs2) {
        CharSequence charSequence;
        void var1_1;
        if (cs1 == cs2) {
            return true;
        }
        if (cs1 == null || cs2 == null) {
            return false;
        }
        if (cs1.length() != cs2.length()) {
            return false;
        }
        return CharSequenceUtils.regionMatches(cs1, true, 0, (CharSequence)var1_1, 0, charSequence.length());
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <T extends CharSequence> T firstNonBlank(T ... values2) {
        if (values2 != null) {
            T[] TArray;
            for (T val : TArray) {
                void var3_3;
                if (!StringUtils.isNotBlank(val)) continue;
                return var3_3;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <T extends CharSequence> T firstNonEmpty(T ... values2) {
        if (values2 != null) {
            T[] TArray;
            for (T val : TArray) {
                void var3_3;
                if (!StringUtils.isNotEmpty(val)) continue;
                return var3_3;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] getBytes(String string, Charset charset) {
        void var1_1;
        String string2;
        if (string == null) {
            return ArrayUtils.EMPTY_BYTE_ARRAY;
        }
        return string2.getBytes(Charsets.toCharset((Charset)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] getBytes(String string, String charset) throws UnsupportedEncodingException {
        void var1_1;
        String string2;
        if (string == null) {
            return ArrayUtils.EMPTY_BYTE_ARRAY;
        }
        return string2.getBytes(Charsets.toCharsetName((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static String getCommonPrefix(String ... strs) {
        void var1_1;
        String[] stringArray;
        if (ArrayUtils.isEmpty(strs)) {
            return EMPTY;
        }
        int smallestIndexOfDiff = StringUtils.indexOfDifference(strs);
        if (smallestIndexOfDiff == -1) {
            if (strs[0] == null) {
                return EMPTY;
            }
            return strs[0];
        }
        if (smallestIndexOfDiff == 0) {
            return EMPTY;
        }
        return stringArray[0].substring(0, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String getDigits(String str) {
        void var2_2;
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        int sz = str.length();
        StringBuilder strDigits = new StringBuilder(sz);
        for (int i2 = 0; i2 < sz; ++i2) {
            char tempChar = str.charAt(i2);
            if (!Character.isDigit(tempChar)) continue;
            strDigits.append(tempChar);
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static int getFuzzyDistance(CharSequence term, CharSequence query, Locale locale) {
        void var2_3;
        if (term == null || query == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        if (locale == null) {
            throw new IllegalArgumentException("Locale must not be null");
        }
        CharSequence termLowerCase = term.toString().toLowerCase(locale);
        String queryLowerCase = query.toString().toLowerCase(locale);
        int score = 0;
        int termIndex = 0;
        int previousMatchingCharacterIndex = Integer.MIN_VALUE;
        for (int queryIndex = 0; queryIndex < queryLowerCase.length(); ++queryIndex) {
            char queryChar = queryLowerCase.charAt(queryIndex);
            boolean termCharacterMatchFound = false;
            while (termIndex < ((String)termLowerCase).length() && !termCharacterMatchFound) {
                char termChar = ((String)termLowerCase).charAt(termIndex);
                if (queryChar == termChar) {
                    ++score;
                    if (previousMatchingCharacterIndex + 1 == termIndex) {
                        score += 2;
                    }
                    previousMatchingCharacterIndex = termIndex;
                    termCharacterMatchFound = true;
                }
                ++termIndex;
            }
        }
        return (int)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T getIfBlank(T str, Supplier<T> defaultSupplier) {
        T t2;
        if (StringUtils.isBlank(str)) {
            void var1_1;
            return (T)((CharSequence)Suppliers.get(var1_1));
        }
        return t2;
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T getIfEmpty(T str, Supplier<T> defaultSupplier) {
        T t2;
        if (StringUtils.isEmpty(str)) {
            void var1_1;
            return (T)((CharSequence)Suppliers.get(var1_1));
        }
        return t2;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static double getJaroWinklerDistance(CharSequence first, CharSequence second) {
        void var2_2;
        double d2;
        void var3_3;
        void var1_1;
        CharSequence charSequence;
        if (first == null || second == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int[] mtp = StringUtils.matches(first, second);
        double m2 = mtp[0];
        if (m2 == 0.0) {
            return 0.0;
        }
        double j2 = (m2 / (double)charSequence.length() + m2 / (double)var1_1.length() + (m2 - (double)mtp[1]) / var3_3) / 3.0;
        double d3 = d2 < 0.7 ? j2 : j2 + Math.min(0.1, 1.0 / (double)mtp[3]) * (double)var2_2[2] * (1.0 - j2);
        return (double)Math.round(d3 * 100.0) / 100.0;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static int getLevenshteinDistance(CharSequence s2, CharSequence t2) {
        void var2_2;
        if (s2 == null || t2 == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int n2 = s2.length();
        int m2 = t2.length();
        if (n2 == 0) {
            return m2;
        }
        if (m2 == 0) {
            return n2;
        }
        if (n2 > m2) {
            CharSequence tmp = s2;
            s2 = t2;
            t2 = tmp;
            n2 = m2;
            m2 = t2.length();
        }
        int[] p2 = new int[n2 + 1];
        int i2 = 0;
        while (i2 <= n2) {
            int n3 = i2++;
            p2[n3] = n3;
        }
        for (int j2 = 1; j2 <= m2; ++j2) {
            int upperleft = p2[0];
            char jOfT = t2.charAt(j2 - 1);
            p2[0] = j2;
            for (i2 = 1; i2 <= n2; ++i2) {
                int upper = p2[i2];
                int cost = s2.charAt(i2 - 1) == jOfT ? 0 : 1;
                p2[i2] = Math.min(Math.min(p2[i2 - 1] + 1, p2[i2] + 1), upperleft + cost);
                upperleft = upper;
            }
        }
        return p2[var2_2];
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static int getLevenshteinDistance(CharSequence s2, CharSequence t2, int threshold) {
        void var2_2;
        if (s2 == null || t2 == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        if (threshold < 0) {
            throw new IllegalArgumentException("Threshold must not be negative");
        }
        int n2 = s2.length();
        int m2 = t2.length();
        if (n2 == 0) {
            if (m2 <= threshold) {
                return m2;
            }
            return -1;
        }
        if (m2 == 0) {
            if (n2 <= threshold) {
                return n2;
            }
            return -1;
        }
        if (Math.abs(n2 - m2) > threshold) {
            return -1;
        }
        if (n2 > m2) {
            CharSequence tmp = s2;
            s2 = t2;
            t2 = tmp;
            n2 = m2;
            m2 = t2.length();
        }
        int[] p2 = new int[n2 + 1];
        int[] d2 = new int[n2 + 1];
        int boundary = Math.min(n2, threshold) + 1;
        int i2 = 0;
        while (i2 < boundary) {
            int n3 = i2++;
            p2[n3] = n3;
        }
        Arrays.fill(p2, boundary, p2.length, Integer.MAX_VALUE);
        Arrays.fill(d2, Integer.MAX_VALUE);
        for (int j2 = 1; j2 <= m2; ++j2) {
            int max;
            char jOfT = t2.charAt(j2 - 1);
            d2[0] = j2;
            int min = Math.max(1, j2 - threshold);
            int n4 = max = j2 > Integer.MAX_VALUE - threshold ? n2 : Math.min(n2, j2 + threshold);
            if (min > max) {
                return -1;
            }
            if (min > 1) {
                d2[min - 1] = Integer.MAX_VALUE;
            }
            for (int i3 = min; i3 <= max; ++i3) {
                d2[i3] = s2.charAt(i3 - 1) == jOfT ? p2[i3 - 1] : 1 + Math.min(Math.min(d2[i3 - 1], p2[i3]), p2[i3 - 1]);
            }
            int[] tmp = p2;
            p2 = d2;
            d2 = tmp;
        }
        if (p2[n2] <= var2_2) {
            void var3_3;
            return p2[var3_3];
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(CharSequence seq, CharSequence searchSeq) {
        void var1_1;
        CharSequence charSequence;
        if (seq == null || searchSeq == null) {
            return -1;
        }
        return CharSequenceUtils.indexOf(charSequence, (CharSequence)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(CharSequence seq, CharSequence searchSeq, int startPos) {
        void var2_2;
        void var1_1;
        CharSequence charSequence;
        if (seq == null || searchSeq == null) {
            return -1;
        }
        return CharSequenceUtils.indexOf(charSequence, (CharSequence)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(CharSequence seq, int searchChar) {
        void var1_1;
        CharSequence charSequence;
        if (StringUtils.isEmpty(seq)) {
            return -1;
        }
        return CharSequenceUtils.indexOf(charSequence, (int)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(CharSequence seq, int searchChar, int startPos) {
        void var2_2;
        void var1_1;
        CharSequence charSequence;
        if (StringUtils.isEmpty(seq)) {
            return -1;
        }
        return CharSequenceUtils.indexOf(charSequence, (int)var1_1, (int)var2_2);
    }

    public static int indexOfAny(CharSequence cs, char ... searchChars) {
        if (StringUtils.isEmpty(cs) || ArrayUtils.isEmpty(searchChars)) {
            return -1;
        }
        int csLen = cs.length();
        int csLast = csLen - 1;
        int searchLen = searchChars.length;
        int searchLast = searchLen - 1;
        for (int i2 = 0; i2 < csLen; ++i2) {
            char ch = cs.charAt(i2);
            for (int j2 = 0; j2 < searchLen; ++j2) {
                if (searchChars[j2] != ch) continue;
                if (i2 >= csLast || j2 >= searchLast || !Character.isHighSurrogate(ch)) {
                    return i2;
                }
                if (searchChars[j2 + 1] != cs.charAt(i2 + 1)) continue;
                return i2;
            }
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOfAny(CharSequence str, CharSequence ... searchStrs) {
        void var2_3;
        if (str == null || searchStrs == null) {
            return -1;
        }
        int ret = Integer.MAX_VALUE;
        CharSequence[] charSequenceArray = searchStrs;
        int n2 = searchStrs.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            void var1_2;
            int tmp;
            CharSequence search = charSequenceArray[i2];
            if (search == null || (tmp = CharSequenceUtils.indexOf(str, search, 0)) == -1 || tmp >= ret) continue;
            ret = var1_2;
        }
        if (ret == Integer.MAX_VALUE) {
            return -1;
        }
        return (int)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOfAny(CharSequence cs, String searchChars) {
        void var1_1;
        CharSequence charSequence;
        if (StringUtils.isEmpty(cs) || StringUtils.isEmpty(searchChars)) {
            return -1;
        }
        return StringUtils.indexOfAny(charSequence, var1_1.toCharArray());
    }

    public static int indexOfAnyBut(CharSequence cs, char ... searchChars) {
        if (StringUtils.isEmpty(cs) || ArrayUtils.isEmpty(searchChars)) {
            return -1;
        }
        int csLen = cs.length();
        int csLast = csLen - 1;
        int searchLen = searchChars.length;
        int searchLast = searchLen - 1;
        block0: for (int i2 = 0; i2 < csLen; ++i2) {
            char ch = cs.charAt(i2);
            for (int j2 = 0; j2 < searchLen; ++j2) {
                if (searchChars[j2] == ch && (i2 >= csLast || j2 >= searchLast || !Character.isHighSurrogate(ch) || searchChars[j2 + 1] == cs.charAt(i2 + 1))) continue block0;
            }
            return i2;
        }
        return -1;
    }

    public static int indexOfAnyBut(CharSequence seq, CharSequence searchChars) {
        if (StringUtils.isEmpty(seq) || StringUtils.isEmpty(searchChars)) {
            return -1;
        }
        int strLen = seq.length();
        for (int i2 = 0; i2 < strLen; ++i2) {
            boolean chFound;
            char ch = seq.charAt(i2);
            boolean bl = chFound = CharSequenceUtils.indexOf(searchChars, ch, 0) >= 0;
            if (i2 + 1 < strLen && Character.isHighSurrogate(ch)) {
                char ch2 = seq.charAt(i2 + 1);
                if (!chFound || CharSequenceUtils.indexOf(searchChars, ch2, 0) >= 0) continue;
                return i2;
            }
            if (chFound) continue;
            return i2;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOfDifference(CharSequence ... css) {
        void var1_1;
        void var2_2;
        if (ArrayUtils.getLength(css) <= 1) {
            return -1;
        }
        boolean anyStringNull = false;
        boolean allStringsNull = true;
        int arrayLen = css.length;
        int shortestStrLen = Integer.MAX_VALUE;
        int longestStrLen = 0;
        CharSequence[] charSequenceArray = css;
        int n2 = css.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            CharSequence cs = charSequenceArray[i2];
            if (cs == null) {
                anyStringNull = true;
                shortestStrLen = 0;
                continue;
            }
            allStringsNull = false;
            shortestStrLen = Math.min(cs.length(), shortestStrLen);
            longestStrLen = Math.max(cs.length(), longestStrLen);
        }
        if (var2_2 != false || longestStrLen == 0 && var1_1 == false) {
            return -1;
        }
        if (shortestStrLen == 0) {
            return 0;
        }
        int firstDiff = -1;
        for (int stringPos = 0; stringPos < shortestStrLen; ++stringPos) {
            char comparisonChar = css[0].charAt(stringPos);
            for (int arrayPos = 1; arrayPos < arrayLen; ++arrayPos) {
                if (css[arrayPos].charAt(stringPos) == comparisonChar) continue;
                firstDiff = stringPos;
                break;
            }
            if (firstDiff != -1) break;
        }
        if (firstDiff == -1 && shortestStrLen != longestStrLen) {
            return shortestStrLen;
        }
        return firstDiff;
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOfDifference(CharSequence cs1, CharSequence cs2) {
        CharSequence charSequence;
        void var1_1;
        int i2;
        if (cs1 == cs2) {
            return -1;
        }
        if (cs1 == null || cs2 == null) {
            return 0;
        }
        for (i2 = 0; i2 < cs1.length() && i2 < cs2.length() && cs1.charAt(i2) == cs2.charAt(i2); ++i2) {
        }
        if (i2 < var1_1.length() || i2 < charSequence.length()) {
            void var2_2;
            return (int)var2_2;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOfIgnoreCase(CharSequence str, CharSequence searchStr) {
        void var1_1;
        return StringUtils.indexOfIgnoreCase(str, (CharSequence)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOfIgnoreCase(CharSequence str, CharSequence searchStr, int startPos) {
        void i2;
        int endLimit;
        if (str == null || searchStr == null) {
            return -1;
        }
        if (startPos < 0) {
            startPos = 0;
        }
        if (startPos > (endLimit = str.length() - searchStr.length() + 1)) {
            return -1;
        }
        if (searchStr.length() == 0) {
            return startPos;
        }
        while (i2 < endLimit) {
            if (CharSequenceUtils.regionMatches(str, true, (int)i2, searchStr, 0, searchStr.length())) {
                return (int)i2;
            }
            ++i2;
        }
        return -1;
    }

    public static boolean isAllBlank(CharSequence ... css) {
        CharSequence[] charSequenceArray;
        if (ArrayUtils.isEmpty(css)) {
            return true;
        }
        for (CharSequence charSequence : charSequenceArray) {
            if (!StringUtils.isNotBlank(charSequence)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllEmpty(CharSequence ... css) {
        CharSequence[] charSequenceArray;
        if (ArrayUtils.isEmpty(css)) {
            return true;
        }
        for (CharSequence charSequence : charSequenceArray) {
            if (!StringUtils.isNotEmpty(charSequence)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllLowerCase(CharSequence cs) {
        if (StringUtils.isEmpty(cs)) {
            return false;
        }
        int sz = cs.length();
        for (int i2 = 0; i2 < sz; ++i2) {
            if (Character.isLowerCase(cs.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllUpperCase(CharSequence cs) {
        if (StringUtils.isEmpty(cs)) {
            return false;
        }
        int sz = cs.length();
        for (int i2 = 0; i2 < sz; ++i2) {
            if (Character.isUpperCase(cs.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlpha(CharSequence cs) {
        if (StringUtils.isEmpty(cs)) {
            return false;
        }
        int sz = cs.length();
        for (int i2 = 0; i2 < sz; ++i2) {
            if (Character.isLetter(cs.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphanumeric(CharSequence cs) {
        if (StringUtils.isEmpty(cs)) {
            return false;
        }
        int sz = cs.length();
        for (int i2 = 0; i2 < sz; ++i2) {
            if (Character.isLetterOrDigit(cs.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isAlphanumericSpace(CharSequence cs) {
        if (cs == null) {
            return false;
        }
        int sz = cs.length();
        for (int i2 = 0; i2 < sz; ++i2) {
            void var3_3;
            char nowChar = cs.charAt(i2);
            if (nowChar == ' ' || Character.isLetterOrDigit((char)var3_3)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isAlphaSpace(CharSequence cs) {
        if (cs == null) {
            return false;
        }
        int sz = cs.length();
        for (int i2 = 0; i2 < sz; ++i2) {
            void var3_3;
            char nowChar = cs.charAt(i2);
            if (nowChar == ' ' || Character.isLetter((char)var3_3)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAnyBlank(CharSequence ... css) {
        CharSequence[] charSequenceArray;
        if (ArrayUtils.isEmpty(css)) {
            return false;
        }
        for (CharSequence charSequence : charSequenceArray) {
            if (!StringUtils.isBlank(charSequence)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnyEmpty(CharSequence ... css) {
        CharSequence[] charSequenceArray;
        if (ArrayUtils.isEmpty(css)) {
            return false;
        }
        for (CharSequence charSequence : charSequenceArray) {
            if (!StringUtils.isEmpty(charSequence)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAsciiPrintable(CharSequence cs) {
        if (cs == null) {
            return false;
        }
        int sz = cs.length();
        for (int i2 = 0; i2 < sz; ++i2) {
            if (CharUtils.isAsciiPrintable(cs.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen = StringUtils.length(cs);
        if (strLen == 0) {
            return true;
        }
        for (int i2 = 0; i2 < strLen; ++i2) {
            if (Character.isWhitespace(cs.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(CharSequence cs) {
        CharSequence charSequence;
        return cs == null || charSequence.length() == 0;
    }

    public static boolean isMixedCase(CharSequence cs) {
        if (StringUtils.isEmpty(cs) || cs.length() == 1) {
            return false;
        }
        boolean containsUppercase = false;
        boolean containsLowercase = false;
        int sz = cs.length();
        for (int i2 = 0; i2 < sz; ++i2) {
            char nowChar = cs.charAt(i2);
            if (Character.isUpperCase(nowChar)) {
                containsUppercase = true;
            } else if (Character.isLowerCase(nowChar)) {
                containsLowercase = true;
            }
            if (!containsUppercase || !containsLowercase) continue;
            return true;
        }
        return false;
    }

    public static boolean isNoneBlank(CharSequence ... css) {
        return !StringUtils.isAnyBlank(css);
    }

    public static boolean isNoneEmpty(CharSequence ... css) {
        return !StringUtils.isAnyEmpty(css);
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !StringUtils.isBlank(cs);
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !StringUtils.isEmpty(cs);
    }

    public static boolean isNumeric(CharSequence cs) {
        if (StringUtils.isEmpty(cs)) {
            return false;
        }
        int sz = cs.length();
        for (int i2 = 0; i2 < sz; ++i2) {
            if (Character.isDigit(cs.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isNumericSpace(CharSequence cs) {
        if (cs == null) {
            return false;
        }
        int sz = cs.length();
        for (int i2 = 0; i2 < sz; ++i2) {
            void var3_3;
            char nowChar = cs.charAt(i2);
            if (nowChar == ' ' || Character.isDigit((char)var3_3)) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhitespace(CharSequence cs) {
        if (cs == null) {
            return false;
        }
        int sz = cs.length();
        for (int i2 = 0; i2 < sz; ++i2) {
            if (Character.isWhitespace(cs.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static String join(boolean[] array, char delimiter) {
        boolean[] blArray;
        void var1_1;
        if (array == null) {
            return null;
        }
        return StringUtils.join(array, (char)var1_1, 0, blArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static String join(boolean[] array, char delimiter, int startIndex, int endIndex) {
        void i2;
        if (array == null) {
            return null;
        }
        if (endIndex - startIndex <= 0) {
            return EMPTY;
        }
        StringBuilder stringBuilder = new StringBuilder(array.length * 5 + array.length - 1);
        while (i2 < endIndex) {
            stringBuilder.append(array[i2]).append(delimiter);
            ++i2;
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    /*
     * WARNING - void declaration
     */
    public static String join(byte[] array, char delimiter) {
        byte[] byArray;
        void var1_1;
        if (array == null) {
            return null;
        }
        return StringUtils.join(array, (char)var1_1, 0, byArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static String join(byte[] array, char delimiter, int startIndex, int endIndex) {
        void i2;
        if (array == null) {
            return null;
        }
        if (endIndex - startIndex <= 0) {
            return EMPTY;
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (i2 < endIndex) {
            stringBuilder.append(array[i2]).append(delimiter);
            ++i2;
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    /*
     * WARNING - void declaration
     */
    public static String join(char[] array, char delimiter) {
        char[] cArray;
        void var1_1;
        if (array == null) {
            return null;
        }
        return StringUtils.join(array, (char)var1_1, 0, cArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static String join(char[] array, char delimiter, int startIndex, int endIndex) {
        void i2;
        if (array == null) {
            return null;
        }
        if (endIndex - startIndex <= 0) {
            return EMPTY;
        }
        StringBuilder stringBuilder = new StringBuilder((array.length << 1) - 1);
        while (i2 < endIndex) {
            stringBuilder.append(array[i2]).append(delimiter);
            ++i2;
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    /*
     * WARNING - void declaration
     */
    public static String join(double[] array, char delimiter) {
        double[] dArray;
        void var1_1;
        if (array == null) {
            return null;
        }
        return StringUtils.join(array, (char)var1_1, 0, dArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static String join(double[] array, char delimiter, int startIndex, int endIndex) {
        void i2;
        if (array == null) {
            return null;
        }
        if (endIndex - startIndex <= 0) {
            return EMPTY;
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (i2 < endIndex) {
            stringBuilder.append(array[i2]).append(delimiter);
            ++i2;
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    /*
     * WARNING - void declaration
     */
    public static String join(float[] array, char delimiter) {
        float[] fArray;
        void var1_1;
        if (array == null) {
            return null;
        }
        return StringUtils.join(array, (char)var1_1, 0, fArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static String join(float[] array, char delimiter, int startIndex, int endIndex) {
        void i2;
        if (array == null) {
            return null;
        }
        if (endIndex - startIndex <= 0) {
            return EMPTY;
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (i2 < endIndex) {
            stringBuilder.append(array[i2]).append(delimiter);
            ++i2;
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    /*
     * WARNING - void declaration
     */
    public static String join(int[] array, char separator) {
        int[] nArray;
        void var1_1;
        if (array == null) {
            return null;
        }
        return StringUtils.join(array, (char)var1_1, 0, nArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static String join(int[] array, char delimiter, int startIndex, int endIndex) {
        void i2;
        if (array == null) {
            return null;
        }
        if (endIndex - startIndex <= 0) {
            return EMPTY;
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (i2 < endIndex) {
            stringBuilder.append(array[i2]).append(delimiter);
            ++i2;
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    /*
     * WARNING - void declaration
     */
    public static String join(Iterable<?> iterable, char separator) {
        if (iterable != null) {
            void var1_1;
            Iterable<?> iterable2;
            return StringUtils.join(iterable2.iterator(), (char)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static String join(Iterable<?> iterable, String separator) {
        if (iterable != null) {
            void var1_1;
            Iterable<?> iterable2;
            return StringUtils.join(iterable2.iterator(), (String)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static String join(Iterator<?> iterator2, char separator) {
        void var1_1;
        Iterator<?> iterator3;
        if (iterator2 == null) {
            return null;
        }
        if (!iterator2.hasNext()) {
            return EMPTY;
        }
        return Streams.of(iterator3).collect(LangCollectors.joining(StringUtils.toStringOrEmpty(String.valueOf((char)var1_1)), EMPTY, EMPTY, StringUtils::toStringOrEmpty));
    }

    /*
     * WARNING - void declaration
     */
    public static String join(Iterator<?> iterator2, String separator) {
        void var1_1;
        Iterator<?> iterator3;
        if (iterator2 == null) {
            return null;
        }
        if (!iterator2.hasNext()) {
            return EMPTY;
        }
        return Streams.of(iterator3).collect(LangCollectors.joining(StringUtils.toStringOrEmpty(var1_1), EMPTY, EMPTY, StringUtils::toStringOrEmpty));
    }

    /*
     * WARNING - void declaration
     */
    public static String join(List<?> list, char separator, int startIndex, int endIndex) {
        void var1_1;
        void var3_3;
        void var2_2;
        List<?> list2;
        if (list == null) {
            return null;
        }
        int n2 = endIndex - startIndex;
        if (n2 <= 0) {
            return EMPTY;
        }
        list2 = list2.subList((int)var2_2, (int)var3_3);
        return StringUtils.join(list2.iterator(), (char)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String join(List<?> list, String separator, int startIndex, int endIndex) {
        void var1_1;
        void var3_3;
        void var2_2;
        List<?> list2;
        if (list == null) {
            return null;
        }
        int n2 = endIndex - startIndex;
        if (n2 <= 0) {
            return EMPTY;
        }
        list2 = list2.subList((int)var2_2, (int)var3_3);
        return StringUtils.join(list2.iterator(), (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String join(long[] array, char separator) {
        long[] lArray;
        void var1_1;
        if (array == null) {
            return null;
        }
        return StringUtils.join(array, (char)var1_1, 0, lArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static String join(long[] array, char delimiter, int startIndex, int endIndex) {
        void i2;
        if (array == null) {
            return null;
        }
        if (endIndex - startIndex <= 0) {
            return EMPTY;
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (i2 < endIndex) {
            stringBuilder.append(array[i2]).append(delimiter);
            ++i2;
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    /*
     * WARNING - void declaration
     */
    public static String join(Object[] array, char delimiter) {
        Object[] objectArray;
        void var1_1;
        if (array == null) {
            return null;
        }
        return StringUtils.join(array, (char)var1_1, 0, objectArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static String join(Object[] array, char delimiter, int startIndex, int endIndex) {
        void var3_3;
        void var2_2;
        void var1_1;
        return StringUtils.join(array, String.valueOf((char)var1_1), (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static String join(Object[] array, String delimiter) {
        if (array != null) {
            Object[] objectArray;
            void var1_1;
            return StringUtils.join(array, StringUtils.toStringOrEmpty(var1_1), 0, objectArray.length);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static String join(Object[] array, String delimiter, int startIndex, int endIndex) {
        if (array != null) {
            void var1_1;
            void var2_2;
            void var3_3;
            Object[] objectArray;
            return Streams.of(objectArray).skip(startIndex).limit(Math.max(0, (int)(var3_3 - var2_2))).collect(LangCollectors.joining((CharSequence)var1_1, EMPTY, EMPTY, StringUtils::toStringOrEmpty));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static String join(short[] array, char delimiter) {
        short[] sArray;
        void var1_1;
        if (array == null) {
            return null;
        }
        return StringUtils.join(array, (char)var1_1, 0, sArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static String join(short[] array, char delimiter, int startIndex, int endIndex) {
        void i2;
        if (array == null) {
            return null;
        }
        if (endIndex - startIndex <= 0) {
            return EMPTY;
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (i2 < endIndex) {
            stringBuilder.append(array[i2]).append(delimiter);
            ++i2;
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    @SafeVarargs
    public static <T> String join(T ... elements) {
        return StringUtils.join((Object[])elements, null);
    }

    /*
     * WARNING - void declaration
     */
    public static String joinWith(String delimiter, Object ... array) {
        String string;
        void var1_1;
        if (array == null) {
            throw new IllegalArgumentException("Object varargs must not be null");
        }
        return StringUtils.join((Object[])var1_1, string);
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(CharSequence seq, CharSequence searchSeq) {
        CharSequence charSequence;
        void var1_1;
        if (seq == null) {
            return -1;
        }
        return CharSequenceUtils.lastIndexOf(seq, (CharSequence)var1_1, charSequence.length());
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(CharSequence seq, CharSequence searchSeq, int startPos) {
        void var2_2;
        void var1_1;
        return CharSequenceUtils.lastIndexOf(seq, (CharSequence)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(CharSequence seq, int searchChar) {
        CharSequence charSequence;
        void var1_1;
        if (StringUtils.isEmpty(seq)) {
            return -1;
        }
        return CharSequenceUtils.lastIndexOf(seq, (int)var1_1, charSequence.length());
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(CharSequence seq, int searchChar, int startPos) {
        void var2_2;
        void var1_1;
        CharSequence charSequence;
        if (StringUtils.isEmpty(seq)) {
            return -1;
        }
        return CharSequenceUtils.lastIndexOf(charSequence, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOfAny(CharSequence str, CharSequence ... searchStrs) {
        void var2_3;
        if (str == null || searchStrs == null) {
            return -1;
        }
        int ret = -1;
        CharSequence[] charSequenceArray = searchStrs;
        int n2 = searchStrs.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            void var1_2;
            int tmp;
            CharSequence search = charSequenceArray[i2];
            if (search == null || (tmp = CharSequenceUtils.lastIndexOf(str, search, str.length())) <= ret) continue;
            ret = var1_2;
        }
        return (int)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOfIgnoreCase(CharSequence str, CharSequence searchStr) {
        CharSequence charSequence;
        void var1_1;
        if (str == null || searchStr == null) {
            return -1;
        }
        return StringUtils.lastIndexOfIgnoreCase(str, (CharSequence)var1_1, charSequence.length());
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOfIgnoreCase(CharSequence str, CharSequence searchStr, int startPos) {
        void i2;
        if (str == null || searchStr == null) {
            return -1;
        }
        int searchStrLength = searchStr.length();
        int strLength = str.length();
        if (startPos > strLength - searchStrLength) {
            startPos = strLength - searchStrLength;
        }
        if (startPos < 0) {
            return -1;
        }
        if (searchStrLength == 0) {
            return startPos;
        }
        while (i2 >= 0) {
            if (CharSequenceUtils.regionMatches(str, true, (int)i2, searchStr, 0, searchStrLength)) {
                return (int)i2;
            }
            --i2;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int lastOrdinalIndexOf(CharSequence str, CharSequence searchStr, int ordinal) {
        void var2_2;
        void var1_1;
        return StringUtils.ordinalIndexOf(str, (CharSequence)var1_1, (int)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    public static String left(String str, int len) {
        void var1_1;
        String string;
        if (str == null) {
            return null;
        }
        if (len < 0) {
            return EMPTY;
        }
        if (str.length() <= len) {
            return str;
        }
        return string.substring(0, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String leftPad(String str, int size) {
        void var1_1;
        return StringUtils.leftPad(str, (int)var1_1, ' ');
    }

    /*
     * WARNING - void declaration
     */
    public static String leftPad(String str, int size, char padChar) {
        String string;
        void var3_3;
        void var2_2;
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        if (pads > 8192) {
            void var1_1;
            return StringUtils.leftPad(str, (int)var1_1, String.valueOf(padChar));
        }
        return StringUtils.repeat((char)var2_2, (int)var3_3).concat(string);
    }

    /*
     * WARNING - void declaration
     */
    public static String leftPad(String str, int size, String padStr) {
        String string;
        void var1_2;
        if (str == null) {
            return null;
        }
        if (StringUtils.isEmpty(padStr)) {
            padStr = SPACE;
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        if (padLen == 1 && pads <= 8192) {
            return StringUtils.leftPad(str, size, padStr.charAt(0));
        }
        if (pads == padLen) {
            return padStr.concat(str);
        }
        if (pads < padLen) {
            return padStr.substring(0, pads).concat(str);
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i2 = 0; i2 < pads; ++i2) {
            padding[i2] = padChars[i2 % padLen];
        }
        return new String((char[])var1_2).concat(string);
    }

    public static int length(CharSequence cs) {
        CharSequence charSequence;
        if (cs == null) {
            return 0;
        }
        return charSequence.length();
    }

    public static String lowerCase(String str) {
        String string;
        if (str == null) {
            return null;
        }
        return string.toLowerCase();
    }

    /*
     * WARNING - void declaration
     */
    public static String lowerCase(String str, Locale locale) {
        void var1_1;
        String string;
        if (str == null) {
            return null;
        }
        return string.toLowerCase(LocaleUtils.toLocale((Locale)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private static int[] matches(CharSequence first, CharSequence second) {
        void var2_2;
        int i2;
        CharSequence min;
        CharSequence max;
        if (first.length() > second.length()) {
            max = first;
            min = second;
        } else {
            max = second;
            min = first;
        }
        int range = Math.max(max.length() / 2 - 1, 0);
        int[] matchIndexes = ArrayFill.fill(new int[min.length()], -1);
        boolean[] matchFlags = new boolean[max.length()];
        int matches = 0;
        block0: for (int mi = 0; mi < min.length(); ++mi) {
            char c1 = min.charAt(mi);
            int xn = Math.min(mi + range + 1, max.length());
            for (int xi = Math.max(mi - range, 0); xi < xn; ++xi) {
                if (matchFlags[xi] || c1 != max.charAt(xi)) continue;
                matchIndexes[mi] = xi;
                matchFlags[xi] = true;
                ++matches;
                continue block0;
            }
        }
        char[] ms1 = new char[matches];
        char[] ms2 = new char[matches];
        int si = 0;
        for (i2 = 0; i2 < min.length(); ++i2) {
            if (matchIndexes[i2] == -1) continue;
            ms1[si] = min.charAt(i2);
            ++si;
        }
        si = 0;
        for (i2 = 0; i2 < max.length(); ++i2) {
            if (!matchFlags[i2]) continue;
            ms2[si] = max.charAt(i2);
            ++si;
        }
        int transpositions = 0;
        for (int mi = 0; mi < ms1.length; ++mi) {
            if (ms1[mi] == ms2[mi]) continue;
            ++transpositions;
        }
        int prefix = 0;
        for (int mi = 0; mi < min.length() && first.charAt(mi) == second.charAt(mi); ++mi) {
            ++prefix;
        }
        return new int[]{matches, transpositions / 2, prefix, var2_2.length()};
    }

    /*
     * WARNING - void declaration
     */
    public static String mid(String str, int pos, int len) {
        void var2_2;
        String string;
        void var1_1;
        if (str == null) {
            return null;
        }
        if (len < 0 || pos > str.length()) {
            return EMPTY;
        }
        if (pos < 0) {
            pos = 0;
        }
        if (str.length() <= pos + len) {
            return str.substring(pos);
        }
        void v0 = var1_1;
        return string.substring((int)v0, (int)(v0 + var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static String normalizeSpace(String str) {
        void var3_3;
        void var2_2;
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        int size = str.length();
        char[] newChars = new char[size];
        int count = 0;
        int whitespacesCount = 0;
        boolean startWhitespaces = true;
        for (int i2 = 0; i2 < size; ++i2) {
            char actualChar = str.charAt(i2);
            boolean bl = Character.isWhitespace(actualChar);
            if (bl) {
                if (whitespacesCount == 0 && !startWhitespaces) {
                    newChars[count++] = SPACE.charAt(0);
                }
                ++whitespacesCount;
                continue;
            }
            startWhitespaces = false;
            newChars[count++] = actualChar == '\u00a0' ? 32 : (int)actualChar;
            whitespacesCount = 0;
        }
        if (startWhitespaces) {
            return EMPTY;
        }
        return new String((char[])var2_2, 0, (int)(var3_3 - (whitespacesCount > 0))).trim();
    }

    /*
     * WARNING - void declaration
     */
    public static int ordinalIndexOf(CharSequence str, CharSequence searchStr, int ordinal) {
        void var2_2;
        void var1_1;
        return StringUtils.ordinalIndexOf(str, (CharSequence)var1_1, (int)var2_2, false);
    }

    private static int ordinalIndexOf(CharSequence str, CharSequence searchStr, int ordinal, boolean lastIndex) {
        if (str == null || searchStr == null || ordinal <= 0) {
            return -1;
        }
        if (searchStr.length() == 0) {
            if (lastIndex) {
                return str.length();
            }
            return 0;
        }
        int found = 0;
        int index = lastIndex ? str.length() : -1;
        do {
            if ((index = lastIndex ? CharSequenceUtils.lastIndexOf(str, searchStr, index - 1) : CharSequenceUtils.indexOf(str, searchStr, index + 1)) >= 0) continue;
            return index;
        } while (++found < ordinal);
        return index;
    }

    /*
     * WARNING - void declaration
     */
    public static String overlay(String str, String overlay, int start, int end) {
        void var3_3;
        String string;
        void var1_1;
        void var2_2;
        if (str == null) {
            return null;
        }
        if (overlay == null) {
            overlay = EMPTY;
        }
        int len = str.length();
        if (start < 0) {
            start = 0;
        }
        if (start > len) {
            start = len;
        }
        if (end < 0) {
            end = 0;
        }
        if (end > len) {
            end = len;
        }
        if (start > end) {
            int temp = start;
            start = end;
            end = temp;
        }
        return str.substring(0, (int)var2_2) + (String)var1_1 + string.substring((int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static String prependIfMissing(String str, CharSequence prefix, boolean ignoreCase, CharSequence ... prefixes) {
        String string;
        void var1_1;
        if (str == null || StringUtils.isEmpty(prefix) || StringUtils.startsWith(str, prefix, ignoreCase)) {
            return str;
        }
        if (ArrayUtils.isNotEmpty(prefixes)) {
            void var3_3;
            for (void p2 : var3_3) {
                if (!StringUtils.startsWith(str, (CharSequence)p2, ignoreCase)) continue;
                return str;
            }
        }
        return var1_1 + string;
    }

    /*
     * WARNING - void declaration
     */
    public static String prependIfMissing(String str, CharSequence prefix, CharSequence ... prefixes) {
        void var2_2;
        void var1_1;
        return StringUtils.prependIfMissing(str, (CharSequence)var1_1, false, (CharSequence[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String prependIfMissingIgnoreCase(String str, CharSequence prefix, CharSequence ... prefixes) {
        void var2_2;
        void var1_1;
        return StringUtils.prependIfMissing(str, (CharSequence)var1_1, true, (CharSequence[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String remove(String str, char remove) {
        void var2_2;
        Object object;
        if (StringUtils.isEmpty(str) || str.indexOf(remove) == -1) {
            return str;
        }
        Object chars = str.toCharArray();
        int pos = 0;
        for (int i2 = 0; i2 < ((Object)chars).length; ++i2) {
            if (chars[i2] == remove) continue;
            chars[pos++] = chars[i2];
        }
        return new String((char[])object, 0, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String remove(String str, String remove) {
        void var1_1;
        String string;
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(remove)) {
            return str;
        }
        return StringUtils.replace(string, (String)var1_1, EMPTY, -1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String removeAll(String text, String regex) {
        void var1_1;
        return RegExUtils.removeAll(text, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String removeEnd(String str, String remove) {
        String string;
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(remove)) {
            return str;
        }
        if (str.endsWith(remove)) {
            void var1_1;
            return str.substring(0, str.length() - var1_1.length());
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static String removeEndIgnoreCase(String str, String remove) {
        String string;
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(remove)) {
            return str;
        }
        if (StringUtils.endsWithIgnoreCase(str, remove)) {
            void var1_1;
            return str.substring(0, str.length() - var1_1.length());
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String removeFirst(String text, String regex) {
        void var1_1;
        return StringUtils.replaceFirst(text, (String)var1_1, EMPTY);
    }

    /*
     * WARNING - void declaration
     */
    public static String removeIgnoreCase(String str, String remove) {
        void var1_1;
        return StringUtils.replaceIgnoreCase(str, (String)var1_1, EMPTY, -1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String removePattern(String source2, String regex) {
        void var1_1;
        return RegExUtils.removePattern(source2, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String removeStart(String str, char remove) {
        String string;
        void var1_1;
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        if (str.charAt(0) == var1_1) {
            return str.substring(1);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static String removeStart(String str, String remove) {
        String string;
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(remove)) {
            return str;
        }
        if (str.startsWith(remove)) {
            void var1_1;
            return str.substring(var1_1.length());
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static String removeStartIgnoreCase(String str, String remove) {
        String string;
        if (str != null && StringUtils.startsWithIgnoreCase(str, remove)) {
            void var1_1;
            return str.substring(StringUtils.length((CharSequence)var1_1));
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static String repeat(char ch, int repeat) {
        char c2;
        void var1_1;
        if (repeat <= 0) {
            return EMPTY;
        }
        return new String(ArrayFill.fill(new char[var1_1], c2));
    }

    /*
     * WARNING - void declaration
     */
    public static String repeat(String str, int repeat) {
        void var3_4;
        if (str == null) {
            return null;
        }
        if (repeat <= 0) {
            return EMPTY;
        }
        int inputLength = str.length();
        if (repeat == 1 || inputLength == 0) {
            return str;
        }
        if (inputLength == 1 && repeat <= 8192) {
            return StringUtils.repeat(str.charAt(0), repeat);
        }
        int outputLength = inputLength * repeat;
        switch (inputLength) {
            case 1: {
                return StringUtils.repeat(str.charAt(0), repeat);
            }
            case 2: {
                void var3_5;
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                char[] output2 = new char[outputLength];
                for (int i2 = (repeat << 1) - 2; i2 >= 0; --i2) {
                    output2[i2] = ch0;
                    output2[i2 + 1] = ch1;
                    --i2;
                }
                return new String((char[])var3_5);
            }
        }
        StringBuilder buf = new StringBuilder((int)var3_4);
        for (int i3 = 0; i3 < repeat; ++i3) {
            String string;
            buf.append(string);
        }
        return buf.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String repeat(String str, String separator, int repeat) {
        void var1_1;
        void var2_2;
        String string;
        if (str == null || separator == null) {
            return StringUtils.repeat(str, repeat);
        }
        string = StringUtils.repeat(string + separator, (int)var2_2);
        return StringUtils.removeEnd(string, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String replace(String text, String searchString, String replacement) {
        void var2_2;
        void var1_1;
        return StringUtils.replace(text, (String)var1_1, (String)var2_2, -1);
    }

    /*
     * WARNING - void declaration
     */
    public static String replace(String text, String searchString, String replacement, int max) {
        void var3_3;
        void var2_2;
        void var1_1;
        return StringUtils.replace(text, (String)var1_1, (String)var2_2, (int)var3_3, false);
    }

    private static String replace(String text, String searchString, String replacement, int max, boolean ignoreCase) {
        String string;
        if (StringUtils.isEmpty(text) || StringUtils.isEmpty(searchString) || replacement == null || max == 0) {
            return text;
        }
        if (ignoreCase) {
            searchString = searchString.toLowerCase();
        }
        int start = 0;
        int end = ignoreCase ? StringUtils.indexOfIgnoreCase(text, searchString, 0) : StringUtils.indexOf((CharSequence)text, searchString, 0);
        if (end == -1) {
            return text;
        }
        int replLength = searchString.length();
        int n2 = Math.max(replacement.length() - replLength, 0);
        int increase = n2 * (max < 0 ? 16 : Math.min(max, 64));
        StringBuilder buf = new StringBuilder(text.length() + increase);
        while (end != -1) {
            buf.append(text, start, end).append(replacement);
            start = end + replLength;
            if (--max == 0) break;
            end = ignoreCase ? StringUtils.indexOfIgnoreCase(text, searchString, start) : StringUtils.indexOf((CharSequence)text, searchString, start);
        }
        buf.append(text, start, string.length());
        return buf.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String replaceAll(String text, String regex, String replacement) {
        void var2_2;
        void var1_1;
        return RegExUtils.replaceAll(text, (String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String replaceChars(String str, char searchChar, char replaceChar) {
        void var2_2;
        void var1_1;
        String string;
        if (str == null) {
            return null;
        }
        return string.replace((char)var1_1, (char)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String replaceChars(String str, String searchChars, String replaceChars) {
        String string;
        void var3_3;
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(searchChars)) {
            return str;
        }
        if (replaceChars == null) {
            replaceChars = EMPTY;
        }
        boolean modified = false;
        int replaceCharsLength = replaceChars.length();
        int strLength = str.length();
        StringBuilder buf = new StringBuilder(strLength);
        for (int i2 = 0; i2 < strLength; ++i2) {
            char ch = str.charAt(i2);
            int index = searchChars.indexOf(ch);
            if (index >= 0) {
                modified = true;
                if (index >= replaceCharsLength) continue;
                buf.append(replaceChars.charAt(index));
                continue;
            }
            buf.append(ch);
        }
        if (var3_3 != false) {
            return buf.toString();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static String replaceEach(String text, String[] searchList, String[] replacementList) {
        void var2_2;
        void var1_1;
        return StringUtils.replaceEach(text, (String[])var1_1, (String[])var2_2, false, 0);
    }

    private static String replaceEach(String text, String[] searchList, String[] replacementList, boolean repeat, int timeToLive) {
        while (true) {
            int tempIndex;
            if (timeToLive < 0) {
                HashSet<String> searchSet = new HashSet<String>(Arrays.asList(searchList));
                HashSet<String> replacementSet = new HashSet<String>(Arrays.asList(replacementList));
                searchSet.retainAll(replacementSet);
                if (!searchSet.isEmpty()) {
                    throw new IllegalStateException("Aborting to protect against StackOverflowError - output of one loop is the input of another");
                }
            }
            if (StringUtils.isEmpty(text) || ArrayUtils.isEmpty(searchList) || ArrayUtils.isEmpty(replacementList) || ArrayUtils.isNotEmpty(searchList) && timeToLive == -1) {
                return text;
            }
            int searchLength = searchList.length;
            int replacementLength = replacementList.length;
            if (searchLength != replacementLength) {
                throw new IllegalArgumentException("Search and Replace array lengths don't match: " + searchLength + " vs " + replacementLength);
            }
            boolean[] noMoreMatchesForReplIndex = new boolean[searchLength];
            int textIndex = -1;
            int replaceIndex = -1;
            for (int i2 = 0; i2 < searchLength; ++i2) {
                if (noMoreMatchesForReplIndex[i2] || StringUtils.isEmpty(searchList[i2]) || replacementList[i2] == null) continue;
                tempIndex = text.indexOf(searchList[i2]);
                if (tempIndex == -1) {
                    noMoreMatchesForReplIndex[i2] = true;
                    continue;
                }
                if (textIndex != -1 && tempIndex >= textIndex) continue;
                textIndex = tempIndex;
                replaceIndex = i2;
            }
            if (textIndex == -1) {
                return text;
            }
            int start = 0;
            int increase = 0;
            for (int i3 = 0; i3 < searchList.length; ++i3) {
                int greater;
                if (searchList[i3] == null || replacementList[i3] == null || (greater = replacementList[i3].length() - searchList[i3].length()) <= 0) continue;
                increase += 3 * greater;
            }
            increase = Math.min(increase, text.length() / 5);
            StringBuilder buf = new StringBuilder(text.length() + increase);
            while (textIndex != -1) {
                int i4;
                for (i4 = start; i4 < textIndex; ++i4) {
                    buf.append(text.charAt(i4));
                }
                buf.append(replacementList[replaceIndex]);
                start = textIndex + searchList[replaceIndex].length();
                textIndex = -1;
                replaceIndex = -1;
                for (i4 = 0; i4 < searchLength; ++i4) {
                    if (noMoreMatchesForReplIndex[i4] || StringUtils.isEmpty(searchList[i4]) || replacementList[i4] == null) continue;
                    tempIndex = text.indexOf(searchList[i4], start);
                    if (tempIndex == -1) {
                        noMoreMatchesForReplIndex[i4] = true;
                        continue;
                    }
                    if (textIndex != -1 && tempIndex >= textIndex) continue;
                    textIndex = tempIndex;
                    replaceIndex = i4;
                }
            }
            int textLength = text.length();
            for (int i5 = start; i5 < textLength; ++i5) {
                buf.append(text.charAt(i5));
            }
            String result = buf.toString();
            if (!repeat) {
                return result;
            }
            --timeToLive;
            text = result;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String replaceEachRepeatedly(String text, String[] searchList, String[] replacementList) {
        void var1_1;
        void var2_2;
        return StringUtils.replaceEach(text, searchList, (String[])var2_2, true, ArrayUtils.getLength(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String replaceFirst(String text, String regex, String replacement) {
        void var2_2;
        void var1_1;
        return RegExUtils.replaceFirst(text, (String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String replaceIgnoreCase(String text, String searchString, String replacement) {
        void var2_2;
        void var1_1;
        return StringUtils.replaceIgnoreCase(text, (String)var1_1, (String)var2_2, -1);
    }

    /*
     * WARNING - void declaration
     */
    public static String replaceIgnoreCase(String text, String searchString, String replacement, int max) {
        void var3_3;
        void var2_2;
        void var1_1;
        return StringUtils.replace(text, (String)var1_1, (String)var2_2, (int)var3_3, true);
    }

    /*
     * WARNING - void declaration
     */
    public static String replaceOnce(String text, String searchString, String replacement) {
        void var2_2;
        void var1_1;
        return StringUtils.replace(text, (String)var1_1, (String)var2_2, 1);
    }

    /*
     * WARNING - void declaration
     */
    public static String replaceOnceIgnoreCase(String text, String searchString, String replacement) {
        void var2_2;
        void var1_1;
        return StringUtils.replaceIgnoreCase(text, (String)var1_1, (String)var2_2, 1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String replacePattern(String source2, String regex, String replacement) {
        void var2_2;
        void var1_1;
        return RegExUtils.replacePattern(source2, (String)var1_1, (String)var2_2);
    }

    public static String reverse(String str) {
        String string;
        if (str == null) {
            return null;
        }
        return new StringBuilder(string).reverse().toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String reverseDelimited(String str, char separatorChar) {
        void var1_1;
        Object[] objectArray;
        Object[] strs = StringUtils.split(str, separatorChar);
        ArrayUtils.reverse(strs);
        return StringUtils.join(objectArray, (char)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String right(String str, int len) {
        void var1_1;
        String string;
        if (str == null) {
            return null;
        }
        if (len < 0) {
            return EMPTY;
        }
        if (str.length() <= len) {
            return str;
        }
        String string2 = string;
        return string2.substring(string2.length() - var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String rightPad(String str, int size) {
        void var1_1;
        return StringUtils.rightPad(str, (int)var1_1, ' ');
    }

    /*
     * WARNING - void declaration
     */
    public static String rightPad(String str, int size, char padChar) {
        void var3_3;
        void var2_2;
        String string;
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        if (pads > 8192) {
            void var1_1;
            return StringUtils.rightPad(str, (int)var1_1, String.valueOf(padChar));
        }
        return string.concat(StringUtils.repeat((char)var2_2, (int)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public static String rightPad(String str, int size, String padStr) {
        void var1_2;
        String string;
        if (str == null) {
            return null;
        }
        if (StringUtils.isEmpty(padStr)) {
            padStr = SPACE;
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        if (padLen == 1 && pads <= 8192) {
            return StringUtils.rightPad(str, size, padStr.charAt(0));
        }
        if (pads == padLen) {
            return str.concat(padStr);
        }
        if (pads < padLen) {
            return str.concat(padStr.substring(0, pads));
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i2 = 0; i2 < pads; ++i2) {
            padding[i2] = padChars[i2 % padLen];
        }
        return string.concat(new String((char[])var1_2));
    }

    /*
     * WARNING - void declaration
     */
    public static String rotate(String str, int shift) {
        void var3_3;
        void var1_1;
        String string;
        void var2_2;
        if (str == null) {
            return null;
        }
        int strLen = str.length();
        if (shift == 0 || strLen == 0 || shift % strLen == 0) {
            return str;
        }
        StringBuilder builder = new StringBuilder(strLen);
        int offset = -(shift % var2_2);
        builder.append(StringUtils.substring(str, offset));
        builder.append(StringUtils.substring(string, 0, (int)var1_1));
        return var3_3.toString();
    }

    public static String[] split(String str) {
        return StringUtils.split(str, null, -1);
    }

    /*
     * WARNING - void declaration
     */
    public static String[] split(String str, char separatorChar) {
        void var1_1;
        return StringUtils.splitWorker(str, (char)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static String[] split(String str, String separatorChars) {
        void var1_1;
        return StringUtils.splitWorker(str, (String)var1_1, -1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static String[] split(String str, String separatorChars, int max) {
        void var2_2;
        void var1_1;
        return StringUtils.splitWorker(str, (String)var1_1, (int)var2_2, false);
    }

    public static String[] splitByCharacterType(String str) {
        return StringUtils.splitByCharacterType(str, false);
    }

    /*
     * WARNING - void declaration
     */
    private static String[] splitByCharacterType(String str, boolean camelCase) {
        void var2_2;
        void var3_3;
        Object object;
        if (str == null) {
            return null;
        }
        if (str.isEmpty()) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        Object c2 = str.toCharArray();
        ArrayList<String> list = new ArrayList<String>();
        int tokenStart = 0;
        int currentType = Character.getType((char)c2[0]);
        for (int pos = 1; pos < ((Object)c2).length; ++pos) {
            int type = Character.getType((char)c2[pos]);
            if (type == currentType) continue;
            if (camelCase && type == 2 && currentType == 1) {
                int newTokenStart = pos - 1;
                if (newTokenStart != tokenStart) {
                    list.add(new String((char[])c2, tokenStart, newTokenStart - tokenStart));
                    tokenStart = newTokenStart;
                }
            } else {
                list.add(new String((char[])c2, tokenStart, pos - tokenStart));
                tokenStart = pos;
            }
            int n2 = type;
        }
        list.add(new String((char[])c2, tokenStart, ((Object)object).length - var3_3));
        return var2_2.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    public static String[] splitByCharacterTypeCamelCase(String str) {
        return StringUtils.splitByCharacterType(str, true);
    }

    /*
     * WARNING - void declaration
     */
    public static String[] splitByWholeSeparator(String str, String separator) {
        void var1_1;
        return StringUtils.splitByWholeSeparatorWorker(str, (String)var1_1, -1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static String[] splitByWholeSeparator(String str, String separator, int max) {
        void var2_2;
        void var1_1;
        return StringUtils.splitByWholeSeparatorWorker(str, (String)var1_1, (int)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public static String[] splitByWholeSeparatorPreserveAllTokens(String str, String separator) {
        void var1_1;
        return StringUtils.splitByWholeSeparatorWorker(str, (String)var1_1, -1, true);
    }

    /*
     * WARNING - void declaration
     */
    public static String[] splitByWholeSeparatorPreserveAllTokens(String str, String separator, int max) {
        void var2_2;
        void var1_1;
        return StringUtils.splitByWholeSeparatorWorker(str, (String)var1_1, (int)var2_2, true);
    }

    private static String[] splitByWholeSeparatorWorker(String str, String separator, int max, boolean preserveAllTokens) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        if (separator == null || EMPTY.equals(separator)) {
            return StringUtils.splitWorker(str, null, max, preserveAllTokens);
        }
        int separatorLength = separator.length();
        ArrayList<String> substrings = new ArrayList<String>();
        int numberOfSubstrings = 0;
        int beg = 0;
        int end = 0;
        while (end < len) {
            end = str.indexOf(separator, beg);
            if (end >= 0) {
                if (end > beg) {
                    if (++numberOfSubstrings == max) {
                        end = len;
                        substrings.add(str.substring(beg));
                        continue;
                    }
                    substrings.add(str.substring(beg, end));
                    beg = end + separatorLength;
                    continue;
                }
                if (preserveAllTokens) {
                    if (++numberOfSubstrings == max) {
                        end = len;
                        substrings.add(str.substring(beg));
                    } else {
                        substrings.add(EMPTY);
                    }
                }
                beg = end + separatorLength;
                continue;
            }
            substrings.add(str.substring(beg));
            end = len;
        }
        return substrings.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    public static String[] splitPreserveAllTokens(String str) {
        return StringUtils.splitWorker(str, null, -1, true);
    }

    /*
     * WARNING - void declaration
     */
    public static String[] splitPreserveAllTokens(String str, char separatorChar) {
        void var1_1;
        return StringUtils.splitWorker(str, (char)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public static String[] splitPreserveAllTokens(String str, String separatorChars) {
        void var1_1;
        return StringUtils.splitWorker(str, (String)var1_1, -1, true);
    }

    /*
     * WARNING - void declaration
     */
    public static String[] splitPreserveAllTokens(String str, String separatorChars, int max) {
        void var2_2;
        void var1_1;
        return StringUtils.splitWorker(str, (String)var1_1, (int)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    private static String[] splitWorker(String str, char separatorChar, boolean preserveAllTokens) {
        void var2_2;
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        int i2 = 0;
        int start = 0;
        boolean match = false;
        boolean lastMatch = false;
        while (i2 < len) {
            if (str.charAt(i2) == separatorChar) {
                if (match || preserveAllTokens) {
                    list.add(str.substring(start, i2));
                    match = false;
                    lastMatch = true;
                }
                start = ++i2;
                continue;
            }
            lastMatch = false;
            match = true;
            ++i2;
        }
        if (match || var2_2 != false && lastMatch) {
            String string;
            list.add(string.substring(start, i2));
        }
        return list.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    /*
     * WARNING - void declaration
     */
    private static String[] splitWorker(String str, String separatorChars, int max, boolean preserveAllTokens) {
        void var3_4;
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        int sizePlus1 = 1;
        int i2 = 0;
        int start = 0;
        boolean match = false;
        boolean lastMatch = false;
        if (separatorChars == null) {
            while (i2 < len) {
                if (Character.isWhitespace(str.charAt(i2))) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i2 = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i2));
                        match = false;
                    }
                    start = ++i2;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i2;
            }
        } else if (separatorChars.length() == 1) {
            char sep = separatorChars.charAt(0);
            while (i2 < len) {
                if (str.charAt(i2) == sep) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i2 = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i2));
                        match = false;
                    }
                    start = ++i2;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i2;
            }
        } else {
            while (i2 < len) {
                void var1_1;
                if (var1_1.indexOf(str.charAt(i2)) >= 0) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i2 = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i2));
                        match = false;
                    }
                    start = ++i2;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i2;
            }
        }
        if (match || var3_4 != false && lastMatch) {
            String string;
            list.add(string.substring(start, i2));
        }
        return list.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean startsWith(CharSequence str, CharSequence prefix) {
        void var1_1;
        return StringUtils.startsWith(str, (CharSequence)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean startsWith(CharSequence str, CharSequence prefix, boolean ignoreCase) {
        void var3_3;
        void var1_1;
        void var2_2;
        CharSequence charSequence;
        if (str == null || prefix == null) {
            return str == prefix;
        }
        int preLen = prefix.length();
        if (preLen > str.length()) {
            return false;
        }
        return CharSequenceUtils.regionMatches(charSequence, (boolean)var2_2, 0, (CharSequence)var1_1, 0, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean startsWithAny(CharSequence sequence2, CharSequence ... searchStrings) {
        void var1_1;
        if (StringUtils.isEmpty(sequence2) || ArrayUtils.isEmpty(searchStrings)) {
            return false;
        }
        for (void searchString : var1_1) {
            if (!StringUtils.startsWith(sequence2, (CharSequence)searchString)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean startsWithIgnoreCase(CharSequence str, CharSequence prefix) {
        void var1_1;
        return StringUtils.startsWith(str, (CharSequence)var1_1, true);
    }

    public static String strip(String str) {
        return StringUtils.strip(str, null);
    }

    /*
     * WARNING - void declaration
     */
    public static String strip(String str, String stripChars) {
        void var1_1;
        String string = StringUtils.stripStart(str, stripChars);
        return StringUtils.stripEnd(string, (String)var1_1);
    }

    public static String stripAccents(String input) {
        CharSequence charSequence;
        if (StringUtils.isEmpty(input)) {
            return input;
        }
        CharSequence decomposed = new StringBuilder(Normalizer.normalize(input, Normalizer.Form.NFKD));
        StringUtils.convertRemainingAccentCharacters((StringBuilder)decomposed);
        return STRIP_ACCENTS_PATTERN.matcher(charSequence).replaceAll(EMPTY);
    }

    public static String[] stripAll(String ... strs) {
        return StringUtils.stripAll(strs, null);
    }

    /*
     * WARNING - void declaration
     */
    public static String[] stripAll(String[] strs, String stripChars) {
        void var2_3;
        void var1_1;
        String[] stringArray;
        int strsLen = ArrayUtils.getLength(strs);
        if (strsLen == 0) {
            return strs;
        }
        String[] newArr = new String[strsLen];
        Arrays.setAll(newArr, arg_0 -> StringUtils.lambda$stripAll$0(stringArray, (String)var1_1, arg_0));
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public static String stripEnd(String str, String stripChars) {
        void var2_2;
        String string;
        int end = StringUtils.length(str);
        if (end == 0) {
            return str;
        }
        if (stripChars == null) {
            while (end != 0 && Character.isWhitespace(str.charAt(end - 1))) {
                --end;
            }
        } else {
            if (stripChars.isEmpty()) {
                return str;
            }
            while (end != 0 && stripChars.indexOf(str.charAt(end - 1)) != -1) {
                --end;
            }
        }
        return string.substring(0, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String stripStart(String str, String stripChars) {
        void var3_3;
        String string;
        int start;
        int strLen = StringUtils.length(str);
        if (strLen == 0) {
            return str;
        }
        if (stripChars == null) {
            for (start = 0; start != strLen && Character.isWhitespace(str.charAt(start)); ++start) {
            }
        } else {
            if (stripChars.isEmpty()) {
                return str;
            }
            while (start != strLen && stripChars.indexOf(str.charAt(start)) != -1) {
                ++start;
            }
        }
        return string.substring((int)var3_3);
    }

    public static String stripToEmpty(String str) {
        String string;
        if (str == null) {
            return EMPTY;
        }
        return StringUtils.strip(string, null);
    }

    public static String stripToNull(String str) {
        String string;
        if (str == null) {
            return null;
        }
        if ((str = StringUtils.strip(str, null)).isEmpty()) {
            return null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static String substring(String str, int start) {
        void var1_1;
        String string;
        if (str == null) {
            return null;
        }
        if (start < 0) {
            start = str.length() + start;
        }
        if (start < 0) {
            start = 0;
        }
        if (start > str.length()) {
            return EMPTY;
        }
        return string.substring((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String substring(String str, int start, int end) {
        void var2_2;
        void var1_1;
        String string;
        if (str == null) {
            return null;
        }
        if (end < 0) {
            end = str.length() + end;
        }
        if (start < 0) {
            start = str.length() + start;
        }
        if (end > str.length()) {
            end = str.length();
        }
        if (start > end) {
            return EMPTY;
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        return string.substring((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String substringAfter(String str, int separator) {
        void var1_1;
        String string;
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return EMPTY;
        }
        return string.substring((int)(var1_1 + true));
    }

    /*
     * WARNING - void declaration
     */
    public static String substringAfter(String str, String separator) {
        void var1_1;
        void var2_2;
        String string;
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        if (separator == null) {
            return EMPTY;
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return EMPTY;
        }
        return string.substring((int)(var2_2 + var1_1.length()));
    }

    /*
     * WARNING - void declaration
     */
    public static String substringAfterLast(String str, int separator) {
        void var1_1;
        String string;
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1 || pos == str.length() - 1) {
            return EMPTY;
        }
        return string.substring((int)(var1_1 + true));
    }

    /*
     * WARNING - void declaration
     */
    public static String substringAfterLast(String str, String separator) {
        void var1_1;
        void var2_2;
        String string;
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        if (StringUtils.isEmpty(separator)) {
            return EMPTY;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1 || pos == str.length() - separator.length()) {
            return EMPTY;
        }
        return string.substring((int)(var2_2 + var1_1.length()));
    }

    /*
     * WARNING - void declaration
     */
    public static String substringBefore(String str, int separator) {
        void var1_1;
        String string;
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return str;
        }
        return string.substring(0, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String substringBefore(String str, String separator) {
        void var1_2;
        String string;
        if (StringUtils.isEmpty(str) || separator == null) {
            return str;
        }
        if (separator.isEmpty()) {
            return EMPTY;
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return str;
        }
        return string.substring(0, (int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String substringBeforeLast(String str, String separator) {
        void var1_2;
        String string;
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(separator)) {
            return str;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1) {
            return str;
        }
        return string.substring(0, (int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String substringBetween(String str, String tag) {
        void var1_1;
        void v0 = var1_1;
        return StringUtils.substringBetween(str, (String)v0, (String)v0);
    }

    /*
     * WARNING - void declaration
     */
    public static String substringBetween(String str, String open, String close) {
        int end;
        if (!ObjectUtils.allNotNull(str, open, close)) {
            return null;
        }
        int start = str.indexOf(open);
        if (start != -1 && (end = str.indexOf(close, start + open.length())) != -1) {
            void var2_3;
            void var1_1;
            void var3_4;
            String string;
            return string.substring((int)(var3_4 + var1_1.length()), (int)var2_3);
        }
        return null;
    }

    public static String[] substringsBetween(String str, String open, String close) {
        int end;
        int start;
        if (str == null || StringUtils.isEmpty(open) || StringUtils.isEmpty(close)) {
            return null;
        }
        int strLen = str.length();
        if (strLen == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        int closeLen = close.length();
        int openLen = open.length();
        ArrayList<String> list = new ArrayList<String>();
        int pos = 0;
        while (pos < strLen - closeLen && (start = str.indexOf(open, pos)) >= 0 && (end = str.indexOf(close, start += openLen)) >= 0) {
            list.add(str.substring(start, end));
            int n2 = end + closeLen;
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    /*
     * WARNING - void declaration
     */
    public static String swapCase(String str) {
        void var3_3;
        void var2_2;
        int newCodePoint;
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        int strLen = str.length();
        int[] newCodePoints = new int[strLen];
        int outOffset = 0;
        for (int i2 = 0; i2 < strLen; i2 += Character.charCount(newCodePoint)) {
            int oldCodepoint = str.codePointAt(i2);
            if (Character.isUpperCase(oldCodepoint) || Character.isTitleCase(oldCodepoint)) {
                newCodePoint = Character.toLowerCase(oldCodepoint);
            } else if (Character.isLowerCase(newCodePoint)) {
                newCodePoint = Character.toUpperCase(newCodePoint);
            }
            newCodePoints[outOffset++] = newCodePoint;
        }
        return new String((int[])var2_2, 0, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static int[] toCodePoints(CharSequence cs) {
        void var1_1;
        if (cs == null) {
            return null;
        }
        if (cs.length() == 0) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        CharSequence s2 = cs.toString();
        int[] result = new int[((String)s2).codePointCount(0, ((String)s2).length())];
        int index = 0;
        for (int i2 = 0; i2 < result.length; ++i2) {
            result[i2] = ((String)s2).codePointAt(index);
            index += Character.charCount(result[i2]);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static String toEncodedString(byte[] bytes, Charset charset) {
        void var1_1;
        byte[] byArray;
        return new String(byArray, Charsets.toCharset((Charset)var1_1));
    }

    public static String toRootLowerCase(String source2) {
        String string;
        if (source2 == null) {
            return null;
        }
        return string.toLowerCase(Locale.ROOT);
    }

    public static String toRootUpperCase(String source2) {
        String string;
        if (source2 == null) {
            return null;
        }
        return string.toUpperCase(Locale.ROOT);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String toString(byte[] bytes, String charsetName) {
        void var1_1;
        byte[] byArray;
        return new String(byArray, Charsets.toCharset((String)var1_1));
    }

    private static String toStringOrEmpty(Object obj) {
        return Objects.toString(obj, EMPTY);
    }

    public static String trim(String str) {
        String string;
        if (str == null) {
            return null;
        }
        return string.trim();
    }

    public static String trimToEmpty(String str) {
        String string;
        if (str == null) {
            return EMPTY;
        }
        return string.trim();
    }

    public static String trimToNull(String str) {
        String string;
        String ts = StringUtils.trim(str);
        if (StringUtils.isEmpty(ts)) {
            return null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static String truncate(String str, int maxWidth) {
        void var1_1;
        return StringUtils.truncate(str, 0, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String truncate(String str, int offset, int maxWidth) {
        void var1_1;
        String string;
        if (offset < 0) {
            throw new IllegalArgumentException("offset cannot be negative");
        }
        if (maxWidth < 0) {
            throw new IllegalArgumentException("maxWith cannot be negative");
        }
        if (str == null) {
            return null;
        }
        if (offset > str.length()) {
            return EMPTY;
        }
        if (str.length() > maxWidth) {
            void var2_2;
            int ix = Math.min(offset + maxWidth, str.length());
            return str.substring(offset, (int)var2_2);
        }
        return string.substring((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String uncapitalize(String str) {
        void var3_3;
        int newCodePoint;
        int strLen = StringUtils.length(str);
        if (strLen == 0) {
            return str;
        }
        int firstCodePoint = str.codePointAt(0);
        if (firstCodePoint == (newCodePoint = Character.toLowerCase(firstCodePoint))) {
            return str;
        }
        int[] newCodePoints = new int[strLen];
        int outOffset = 0;
        ++outOffset;
        newCodePoints[0] = newCodePoint;
        for (int inOffset = Character.charCount(firstCodePoint); inOffset < strLen; inOffset += Character.charCount((int)var3_3)) {
            int codePoint = str.codePointAt(inOffset);
            newCodePoints[outOffset++] = codePoint;
        }
        return new String(newCodePoints, 0, outOffset);
    }

    /*
     * WARNING - void declaration
     */
    public static String unwrap(String str, char wrapChar) {
        String string;
        if (StringUtils.isEmpty(str) || wrapChar == '\u0000' || str.length() == 1) {
            return str;
        }
        if (str.charAt(0) == wrapChar) {
            String string2 = str;
            if (string2.charAt(string2.length() - 1) == wrapChar) {
                void var1_1;
                int endIndex = str.length() - 1;
                return str.substring(1, (int)var1_1);
            }
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static String unwrap(String str, String wrapToken) {
        String string;
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(wrapToken) || str.length() < 2 * wrapToken.length()) {
            return str;
        }
        if (StringUtils.startsWith(str, wrapToken) && StringUtils.endsWith(str, wrapToken)) {
            void var1_1;
            return str.substring(wrapToken.length(), str.lastIndexOf((String)var1_1));
        }
        return string;
    }

    public static String upperCase(String str) {
        String string;
        if (str == null) {
            return null;
        }
        return string.toUpperCase();
    }

    /*
     * WARNING - void declaration
     */
    public static String upperCase(String str, Locale locale) {
        void var1_1;
        String string;
        if (str == null) {
            return null;
        }
        return string.toUpperCase(LocaleUtils.toLocale((Locale)var1_1));
    }

    public static String valueOf(char[] value) {
        char[] cArray;
        if (value == null) {
            return null;
        }
        return String.valueOf(cArray);
    }

    /*
     * WARNING - void declaration
     */
    public static String wrap(String str, char wrapWith) {
        void var1_1;
        String string;
        if (StringUtils.isEmpty(str) || wrapWith == '\u0000') {
            return str;
        }
        return wrapWith + string + (char)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static String wrap(String str, String wrapWith) {
        void var1_1;
        String string;
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(wrapWith)) {
            return str;
        }
        return wrapWith.concat(string).concat((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String wrapIfMissing(String str, char wrapWith) {
        void var3_3;
        String string;
        void var2_2;
        boolean wrapEnd;
        if (StringUtils.isEmpty(str) || wrapWith == '\u0000') {
            return str;
        }
        boolean wrapStart = str.charAt(0) != wrapWith;
        String string2 = str;
        boolean bl = wrapEnd = string2.charAt(string2.length() - 1) != wrapWith;
        if (!wrapStart && !wrapEnd) {
            return str;
        }
        StringBuilder builder = new StringBuilder(str.length() + 2);
        if (var2_2 != false) {
            builder.append(wrapWith);
        }
        builder.append(string);
        if (var3_3 != false) {
            void var1_1;
            builder.append((char)var1_1);
        }
        return builder.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String wrapIfMissing(String str, String wrapWith) {
        void var3_3;
        String string;
        void var2_2;
        boolean wrapEnd;
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(wrapWith)) {
            return str;
        }
        boolean wrapStart = !str.startsWith(wrapWith);
        boolean bl = wrapEnd = !str.endsWith(wrapWith);
        if (!wrapStart && !wrapEnd) {
            return str;
        }
        StringBuilder builder = new StringBuilder(str.length() + wrapWith.length() + wrapWith.length());
        if (var2_2 != false) {
            builder.append(wrapWith);
        }
        builder.append(string);
        if (var3_3 != false) {
            void var1_1;
            builder.append((String)var1_1);
        }
        return builder.toString();
    }

    @Deprecated
    public StringUtils() {
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ String lambda$stripAll$0(String[] strs, String stripChars, int i2) {
        void var1_1;
        void var2_2;
        return StringUtils.strip(strs[var2_2], (String)var1_1);
    }
}

