/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.Random;
import java.util.function.Supplier;
import org.apache.commons.lang3.CachedRandomBits;
import org.apache.commons.lang3.RandomUtils;

public class RandomStringUtils {
    private static final Supplier<RandomUtils> SECURE_SUPPLIER = RandomUtils::secure;
    private static RandomStringUtils INSECURE = new RandomStringUtils(RandomUtils::insecure);
    private static RandomStringUtils SECURE = new RandomStringUtils(SECURE_SUPPLIER);
    private static RandomStringUtils SECURE_STRONG = new RandomStringUtils(RandomUtils::secureStrong);
    private static final char[] ALPHANUMERICAL_CHARS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private final Supplier<RandomUtils> random;

    public static RandomStringUtils insecure() {
        return INSECURE;
    }

    @Deprecated
    public static String random(int count) {
        int n2;
        return RandomStringUtils.secure().next(n2);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String random(int count, boolean letters, boolean numbers) {
        void var2_2;
        void var1_1;
        int n2;
        return RandomStringUtils.secure().next(n2, (boolean)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String random(int count, char ... chars) {
        void var1_1;
        int n2;
        return RandomStringUtils.secure().next(n2, (char[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String random(int count, int start, int end, boolean letters, boolean numbers) {
        void var3_3;
        void var2_2;
        void var1_1;
        int n2;
        return RandomStringUtils.secure().next(n2, (int)var1_1, (int)var2_2, (boolean)var3_3, numbers);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String random(int count, int start, int end, boolean letters, boolean numbers, char ... chars) {
        void var3_3;
        void var2_2;
        void var1_1;
        int n2;
        return RandomStringUtils.secure().next(n2, (int)var1_1, (int)var2_2, (boolean)var3_3, numbers, chars);
    }

    public static String random(int count, int start, int end, boolean letters, boolean numbers, char[] chars, Random random) {
        while (true) {
            if (count == 0) {
                return "";
            }
            if (count < 0) {
                throw new IllegalArgumentException("Requested random string length " + count + " is less than 0.");
            }
            if (chars != null && chars.length == 0) {
                throw new IllegalArgumentException("The chars array must not be empty");
            }
            if (start == 0 && end == 0) {
                if (chars != null) {
                    end = chars.length;
                } else if (!letters && !numbers) {
                    end = 0x10FFFF;
                } else {
                    end = 123;
                    start = 32;
                }
            } else {
                if (end <= start) {
                    throw new IllegalArgumentException("Parameter end (" + end + ") must be greater than start (" + start + ")");
                }
                if (start < 0 || end < 0) {
                    throw new IllegalArgumentException("Character positions MUST be >= 0");
                }
            }
            if (end > 0x10FFFF) {
                end = 0x10FFFF;
            }
            if (chars != null || !letters || !numbers || start > 48 || end < 123) break;
            chars = ALPHANUMERICAL_CHARS;
            numbers = false;
            letters = false;
            end = 0;
            start = 0;
        }
        if (chars == null) {
            if (letters && numbers) {
                start = Math.max(48, start);
                end = Math.min(123, end);
            } else if (numbers) {
                start = Math.max(48, start);
                end = Math.min(58, end);
            } else if (letters) {
                start = Math.max(65, start);
                end = Math.min(123, end);
            }
        }
        if (chars == null && (numbers && end <= 48 || letters && end <= 65)) {
            throw new IllegalArgumentException("Parameter end (" + end + ") must be greater then (48" + ") for generating digits or greater then (65" + ") for generating letters.");
        }
        StringBuilder builder = new StringBuilder(count);
        int gap = end - start;
        int gapBits = 32 - Integer.numberOfLeadingZeros(gap);
        CachedRandomBits arb = new CachedRandomBits((count * gapBits + 3) / 5 + 10, random);
        block4: while (count-- != 0) {
            int codePoint;
            int randomValue = arb.nextBits(gapBits) + start;
            if (randomValue >= end) {
                ++count;
                continue;
            }
            if (chars == null) {
                codePoint = randomValue;
                switch (Character.getType(codePoint)) {
                    case 0: 
                    case 18: 
                    case 19: {
                        ++count;
                        continue block4;
                    }
                }
            } else {
                codePoint = chars[codePoint];
            }
            int numberOfChars = Character.charCount(codePoint);
            if (count == 0 && numberOfChars > 1) {
                ++count;
                continue;
            }
            if (letters && Character.isLetter(codePoint) || numbers && Character.isDigit(codePoint) || !letters && !numbers) {
                builder.appendCodePoint(codePoint);
                if (numberOfChars != 2) continue;
                --count;
                continue;
            }
            ++count;
        }
        return builder.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String random(int count, String chars) {
        void var1_1;
        int n2;
        return RandomStringUtils.secure().next(n2, (String)var1_1);
    }

    @Deprecated
    public static String randomAlphabetic(int count) {
        int n2;
        return RandomStringUtils.secure().nextAlphabetic(n2);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String randomAlphabetic(int minLengthInclusive, int maxLengthExclusive) {
        void var1_1;
        int n2;
        return RandomStringUtils.secure().nextAlphabetic(n2, (int)var1_1);
    }

    @Deprecated
    public static String randomAlphanumeric(int count) {
        int n2;
        return RandomStringUtils.secure().nextAlphanumeric(n2);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String randomAlphanumeric(int minLengthInclusive, int maxLengthExclusive) {
        void var1_1;
        int n2;
        return RandomStringUtils.secure().nextAlphanumeric(n2, (int)var1_1);
    }

    @Deprecated
    public static String randomAscii(int count) {
        int n2;
        return RandomStringUtils.secure().nextAscii(n2);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String randomAscii(int minLengthInclusive, int maxLengthExclusive) {
        void var1_1;
        int n2;
        return RandomStringUtils.secure().nextAscii(n2, (int)var1_1);
    }

    @Deprecated
    public static String randomGraph(int count) {
        int n2;
        return RandomStringUtils.secure().nextGraph(n2);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String randomGraph(int minLengthInclusive, int maxLengthExclusive) {
        void var1_1;
        int n2;
        return RandomStringUtils.secure().nextGraph(n2, (int)var1_1);
    }

    @Deprecated
    public static String randomNumeric(int count) {
        int n2;
        return RandomStringUtils.secure().nextNumeric(n2);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String randomNumeric(int minLengthInclusive, int maxLengthExclusive) {
        void var1_1;
        int n2;
        return RandomStringUtils.secure().nextNumeric(n2, (int)var1_1);
    }

    @Deprecated
    public static String randomPrint(int count) {
        int n2;
        return RandomStringUtils.secure().nextPrint(n2);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String randomPrint(int minLengthInclusive, int maxLengthExclusive) {
        void var1_1;
        int n2;
        return RandomStringUtils.secure().nextPrint(n2, (int)var1_1);
    }

    public static RandomStringUtils secure() {
        return SECURE;
    }

    public static RandomStringUtils secureStrong() {
        return SECURE_STRONG;
    }

    @Deprecated
    public RandomStringUtils() {
        this(SECURE_SUPPLIER);
    }

    /*
     * WARNING - void declaration
     */
    private RandomStringUtils(Supplier<RandomUtils> random) {
        void var1_1;
        this.random = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public String next(int count) {
        void var1_1;
        return this.next((int)var1_1, false, false);
    }

    /*
     * WARNING - void declaration
     */
    public String next(int count, boolean letters, boolean numbers) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.next((int)var1_1, 0, 0, (boolean)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public String next(int count, char ... chars) {
        void var2_2;
        void var1_1;
        if (chars == null) {
            return RandomStringUtils.random(count, 0, 0, false, false, null, this.random());
        }
        return RandomStringUtils.random((int)var1_1, 0, chars.length, false, false, (char[])var2_2, this.random());
    }

    /*
     * WARNING - void declaration
     */
    public String next(int count, int start, int end, boolean letters, boolean numbers) {
        void var3_3;
        void var2_2;
        return RandomStringUtils.random(count, (int)var2_2, (int)var3_3, letters, numbers, null, this.random());
    }

    /*
     * WARNING - void declaration
     */
    public String next(int count, int start, int end, boolean letters, boolean numbers, char ... chars) {
        void var3_3;
        void var2_2;
        return RandomStringUtils.random(count, (int)var2_2, (int)var3_3, letters, numbers, chars, this.random());
    }

    /*
     * WARNING - void declaration
     */
    public String next(int count, String chars) {
        void var2_2;
        void var1_1;
        if (chars == null) {
            return RandomStringUtils.random(count, 0, 0, false, false, null, this.random());
        }
        return this.next((int)var1_1, var2_2.toCharArray());
    }

    /*
     * WARNING - void declaration
     */
    public String nextAlphabetic(int count) {
        void var1_1;
        return this.next((int)var1_1, true, false);
    }

    /*
     * WARNING - void declaration
     */
    public String nextAlphabetic(int minLengthInclusive, int maxLengthExclusive) {
        void var2_2;
        void var1_1;
        RandomStringUtils randomStringUtils = this;
        return randomStringUtils.nextAlphabetic(randomStringUtils.randomUtils().randomInt((int)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public String nextAlphanumeric(int count) {
        void var1_1;
        return this.next((int)var1_1, true, true);
    }

    /*
     * WARNING - void declaration
     */
    public String nextAlphanumeric(int minLengthInclusive, int maxLengthExclusive) {
        void var2_2;
        void var1_1;
        RandomStringUtils randomStringUtils = this;
        return randomStringUtils.nextAlphanumeric(randomStringUtils.randomUtils().randomInt((int)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public String nextAscii(int count) {
        void var1_1;
        return this.next((int)var1_1, 32, 127, false, false);
    }

    /*
     * WARNING - void declaration
     */
    public String nextAscii(int minLengthInclusive, int maxLengthExclusive) {
        void var2_2;
        void var1_1;
        RandomStringUtils randomStringUtils = this;
        return randomStringUtils.nextAscii(randomStringUtils.randomUtils().randomInt((int)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public String nextGraph(int count) {
        void var1_1;
        return this.next((int)var1_1, 33, 126, false, false);
    }

    /*
     * WARNING - void declaration
     */
    public String nextGraph(int minLengthInclusive, int maxLengthExclusive) {
        void var2_2;
        void var1_1;
        RandomStringUtils randomStringUtils = this;
        return randomStringUtils.nextGraph(randomStringUtils.randomUtils().randomInt((int)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public String nextNumeric(int count) {
        void var1_1;
        return this.next((int)var1_1, false, true);
    }

    /*
     * WARNING - void declaration
     */
    public String nextNumeric(int minLengthInclusive, int maxLengthExclusive) {
        void var2_2;
        void var1_1;
        RandomStringUtils randomStringUtils = this;
        return randomStringUtils.nextNumeric(randomStringUtils.randomUtils().randomInt((int)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public String nextPrint(int count) {
        void var1_1;
        return this.next((int)var1_1, 32, 126, false, false);
    }

    /*
     * WARNING - void declaration
     */
    public String nextPrint(int minLengthInclusive, int maxLengthExclusive) {
        void var2_2;
        void var1_1;
        RandomStringUtils randomStringUtils = this;
        return randomStringUtils.nextPrint(randomStringUtils.randomUtils().randomInt((int)var1_1, (int)var2_2));
    }

    private Random random() {
        return this.randomUtils().random();
    }

    private RandomUtils randomUtils() {
        return this.random.get();
    }

    public String toString() {
        return "RandomStringUtils [random=" + this.random() + "]";
    }
}

