/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;

public class EnumUtils {
    private static final String CANNOT_STORE_S_S_VALUES_IN_S_BITS = "Cannot store %s %s values in %s bits";
    private static final String ENUM_CLASS_MUST_BE_DEFINED = "EnumClass must be defined.";
    private static final String NULL_ELEMENTS_NOT_PERMITTED = "null elements not permitted";
    private static final String S_DOES_NOT_SEEM_TO_BE_AN_ENUM_TYPE = "%s does not seem to be an Enum type";

    private static <E extends Enum<E>> Class<E> asEnum(Class<E> enumClass) {
        Class<E> clazz;
        Objects.requireNonNull(enumClass, ENUM_CLASS_MUST_BE_DEFINED);
        Validate.isTrue(enumClass.isEnum(), S_DOES_NOT_SEEM_TO_BE_AN_ENUM_TYPE, enumClass);
        return clazz;
    }

    /*
     * WARNING - void declaration
     */
    private static <E extends Enum<E>> Class<E> checkBitVectorable(Class<E> enumClass) {
        Class<E> clazz;
        void var1_1;
        Enum[] constants = (Enum[])EnumUtils.asEnum(enumClass).getEnumConstants();
        Validate.isTrue(constants.length <= 64, CANNOT_STORE_S_S_VALUES_IN_S_BITS, ((void)var1_1).length, enumClass.getSimpleName(), 64);
        return clazz;
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <E extends Enum<E>> long generateBitVector(Class<E> enumClass, E ... values2) {
        void var1_1;
        Class<E> clazz;
        Validate.noNullElements(values2);
        return EnumUtils.generateBitVector(clazz, Arrays.asList(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Enum<E>> long generateBitVector(Class<E> enumClass, Iterable<? extends E> values2) {
        void var2_2;
        EnumUtils.checkBitVectorable(enumClass);
        Objects.requireNonNull(values2, "values");
        long total = 0L;
        for (Enum constant : values2) {
            void var1_1;
            Objects.requireNonNull(constant, NULL_ELEMENTS_NOT_PERMITTED);
            total |= 1L << var1_1.ordinal();
        }
        return (long)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <E extends Enum<E>> long[] generateBitVectors(Class<E> enumClass, E ... values2) {
        Object object;
        Iterator iterator2;
        EnumUtils.asEnum(enumClass);
        Validate.noNullElements(values2);
        EnumSet<Enum> condensed = EnumSet.noneOf(enumClass);
        Collections.addAll(condensed, iterator2);
        Object result = new long[(((Enum[])enumClass.getEnumConstants()).length - 1) / 64 + 1];
        for (Enum value : condensed) {
            void var2_2;
            Object object2 = result;
            int n2 = value.ordinal() / 64;
            object2[n2] = object2[n2] | 1L << var2_2.ordinal() % 64;
        }
        ArrayUtils.reverse((long[])result);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Enum<E>> long[] generateBitVectors(Class<E> enumClass, Iterable<? extends E> values2) {
        Object object;
        Iterator iterator2;
        EnumUtils.asEnum(enumClass);
        Objects.requireNonNull(values2, "values");
        EnumSet<Enum> condensed = EnumSet.noneOf(enumClass);
        iterator2.forEach(constant -> {
            void var1_1;
            condensed.add((Enum)Objects.requireNonNull(var1_1, NULL_ELEMENTS_NOT_PERMITTED));
        });
        Object result = new long[(((Enum[])enumClass.getEnumConstants()).length - 1) / 64 + 1];
        for (Enum value : condensed) {
            void var2_2;
            Object object2 = result;
            int n2 = value.ordinal() / 64;
            object2[n2] = object2[n2] | 1L << var2_2.ordinal() % 64;
        }
        ArrayUtils.reverse((long[])result);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Enum<E>> E getEnum(Class<E> enumClass, String enumName) {
        void var1_1;
        return EnumUtils.getEnum(enumClass, (String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Enum<E>> E getEnum(Class<E> enumClass, String enumName, E defaultEnum) {
        if (enumName == null) {
            return defaultEnum;
        }
        try {
            void var1_1;
            Class<E> clazz;
            return Enum.valueOf(clazz, (String)var1_1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            void var2_2;
            return var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Enum<E>> E getEnumIgnoreCase(Class<E> enumClass, String enumName) {
        void var1_1;
        return EnumUtils.getEnumIgnoreCase(enumClass, (String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Enum<E>> E getEnumIgnoreCase(Class<E> enumClass, String enumName, E defaultEnum) {
        void var2_2;
        void var1_1;
        return EnumUtils.getFirstEnumIgnoreCase(enumClass, (String)var1_1, Enum::name, var2_2);
    }

    public static <E extends Enum<E>> List<E> getEnumList(Class<E> enumClass) {
        Class<E> clazz;
        return new ArrayList<Enum>(Arrays.asList((Enum[])clazz.getEnumConstants()));
    }

    public static <E extends Enum<E>> Map<String, E> getEnumMap(Class<E> enumClass) {
        return EnumUtils.getEnumMap(enumClass, Enum::name);
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Enum<E>, K> Map<K, E> getEnumMap(Class<E> enumClass, Function<E, K> keyFunction) {
        void var1_1;
        return Stream.of((Enum[])enumClass.getEnumConstants()).collect(Collectors.toMap(((Function)var1_1)::apply, Function.identity()));
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Enum<E>> E getEnumSystemProperty(Class<E> enumClass, String propName, E defaultEnum) {
        void var2_2;
        void var1_1;
        Class<E> clazz;
        if (enumClass == null || propName == null) {
            return defaultEnum;
        }
        return EnumUtils.getEnum(clazz, System.getProperty((String)var1_1), var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Enum<E>> E getFirstEnumIgnoreCase(Class<E> enumClass, String enumName, Function<E, String> stringFunction, E defaultEnum) {
        void var3_3;
        void var2_2;
        void var1_1;
        Class<E> clazz;
        if (enumName == null || !enumClass.isEnum()) {
            return defaultEnum;
        }
        return (E)Stream.of((Enum[])clazz.getEnumConstants()).filter(arg_0 -> EnumUtils.lambda$getFirstEnumIgnoreCase$1((String)var1_1, (Function)var2_2, arg_0)).findFirst().orElse((Enum)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Enum<E>> boolean isValidEnum(Class<E> enumClass, String enumName) {
        void var1_1;
        return EnumUtils.getEnum(enumClass, (String)var1_1) != null;
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Enum<E>> boolean isValidEnumIgnoreCase(Class<E> enumClass, String enumName) {
        void var1_1;
        return EnumUtils.getEnumIgnoreCase(enumClass, (String)var1_1) != null;
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Enum<E>> EnumSet<E> processBitVector(Class<E> enumClass, long value) {
        void var1_1;
        Class<E> clazz;
        EnumUtils.checkBitVectorable(enumClass).getEnumConstants();
        return EnumUtils.processBitVectors(clazz, new long[]{var1_1});
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Enum<E>> EnumSet<E> processBitVectors(Class<E> enumClass, long ... values2) {
        void var2_2;
        Enum[] enumArray;
        EnumSet<Enum> results = EnumSet.noneOf(EnumUtils.asEnum(enumClass));
        long[] lvalues = ArrayUtils.clone(Objects.requireNonNull(values2, "values"));
        ArrayUtils.reverse(lvalues);
        for (Enum constant : (Enum[])enumArray.getEnumConstants()) {
            int block = constant.ordinal() / 64;
            if (block >= lvalues.length || (lvalues[block] & 1L << constant.ordinal() % 64) == 0L) continue;
            results.add(constant);
        }
        return var2_2;
    }

    @Deprecated
    public EnumUtils() {
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ boolean lambda$getFirstEnumIgnoreCase$1(String enumName, Function stringFunction, Enum e2) {
        void var2_2;
        void var1_1;
        return enumName.equalsIgnoreCase((String)var1_1.apply(var2_2));
    }
}

