/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableObject;

public class ClassUtils {
    private static final Comparator<Class<?>> COMPARATOR;
    public static final char PACKAGE_SEPARATOR_CHAR = '.';
    public static final String PACKAGE_SEPARATOR;
    public static final char INNER_CLASS_SEPARATOR_CHAR = '$';
    public static final String INNER_CLASS_SEPARATOR;
    private static final Map<String, Class<?>> namePrimitiveMap;
    private static final Map<Class<?>, Class<?>> primitiveWrapperMap;
    private static final Map<Class<?>, Class<?>> wrapperPrimitiveMap;
    private static final Map<String, String> abbreviationMap;
    private static final Map<String, String> reverseAbbreviationMap;

    public static Comparator<Class<?>> comparator() {
        return COMPARATOR;
    }

    public static List<String> convertClassesToClassNames(List<Class<?>> classes) {
        List<Class<?>> list;
        if (classes == null) {
            return null;
        }
        return list.stream().map(e2 -> ClassUtils.getName(e2, null)).collect(Collectors.toList());
    }

    /*
     * WARNING - void declaration
     */
    public static List<Class<?>> convertClassNamesToClasses(List<String> classNames) {
        void var1_1;
        List<String> list;
        if (classNames == null) {
            return null;
        }
        ArrayList classes = new ArrayList(classNames.size());
        list.forEach(className -> {
            try {
                void var1_1;
                classes.add(Class.forName((String)var1_1));
                return;
            }
            catch (Exception exception) {
                List list;
                list.add(null);
                return;
            }
        });
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static String getAbbreviatedName(Class<?> cls, int lengthHint) {
        void var1_1;
        Class<?> clazz;
        if (cls == null) {
            return "";
        }
        return ClassUtils.getAbbreviatedName(clazz.getName(), (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String getAbbreviatedName(String className, int lengthHint) {
        void var2_2;
        Object object;
        if (lengthHint <= 0) {
            throw new IllegalArgumentException("len must be > 0");
        }
        if (className == null) {
            return "";
        }
        if (className.length() <= lengthHint) {
            return className;
        }
        Object abbreviated = className.toCharArray();
        int target = 0;
        int source2 = 0;
        while (source2 < ((Object)abbreviated).length) {
            int runAheadTarget = target;
            while (source2 < ((Object)abbreviated).length && abbreviated[source2] != 46) {
                abbreviated[runAheadTarget++] = abbreviated[source2++];
            }
            if (ClassUtils.useFull(runAheadTarget, source2, ((Object)abbreviated).length, lengthHint) || ++target > runAheadTarget) {
                target = runAheadTarget;
            }
            if (source2 >= ((Object)abbreviated).length) continue;
            abbreviated[target++] = abbreviated[source2++];
        }
        return new String((char[])object, 0, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static List<Class<?>> getAllInterfaces(Class<?> cls) {
        void var1_1;
        Class<?> clazz;
        if (cls == null) {
            return null;
        }
        LinkedHashSet interfacesFound = new LinkedHashSet();
        ClassUtils.getAllInterfaces(clazz, interfacesFound);
        return new ArrayList((Collection<Class<?>>)var1_1);
    }

    private static void getAllInterfaces(Class<?> cls, HashSet<Class<?>> interfacesFound) {
        while (cls != null) {
            Class<?>[] classArray = cls.getInterfaces();
            Class<?>[] classArray2 = classArray;
            classArray2 = classArray;
            int n2 = classArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Class<?> i3 = classArray2[i2];
                if (!interfacesFound.add(i3)) continue;
                ClassUtils.getAllInterfaces(i3, interfacesFound);
            }
            cls = cls.getSuperclass();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static List<Class<?>> getAllSuperclasses(Class<?> cls) {
        void var1_1;
        if (cls == null) {
            return null;
        }
        ArrayList classes = new ArrayList();
        for (Class<?> superclass = cls.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            classes.add(superclass);
        }
        return var1_1;
    }

    public static String getCanonicalName(Class<?> cls) {
        return ClassUtils.getCanonicalName(cls, "");
    }

    /*
     * WARNING - void declaration
     */
    public static String getCanonicalName(Class<?> cls, String valueIfNull) {
        String string;
        if (cls == null) {
            return valueIfNull;
        }
        String canonicalName = cls.getCanonicalName();
        if (canonicalName == null) {
            void var1_1;
            return var1_1;
        }
        return string;
    }

    public static String getCanonicalName(Object object) {
        return ClassUtils.getCanonicalName(object, "");
    }

    /*
     * WARNING - void declaration
     */
    public static String getCanonicalName(Object object, String valueIfNull) {
        Object object2;
        if (object == null) {
            return valueIfNull;
        }
        Object canonicalName = object.getClass().getCanonicalName();
        if (canonicalName == null) {
            void var1_1;
            return var1_1;
        }
        return object2;
    }

    private static String getCanonicalName(String className) {
        CharSequence charSequence;
        if ((className = StringUtils.deleteWhitespace(className)) == null) {
            return null;
        }
        int dim = 0;
        while (className.startsWith("[")) {
            ++dim;
            className = className.substring(1);
        }
        if (dim <= 0) {
            return className;
        }
        if (className.startsWith("L")) {
            className = className.substring(1, className.endsWith(";") ? className.length() - 1 : className.length());
        } else if (!className.isEmpty()) {
            className = reverseAbbreviationMap.get(className.substring(0, 1));
        }
        CharSequence canonicalClassNameBuffer = new StringBuilder(className);
        for (int i2 = 0; i2 < dim; ++i2) {
            ((StringBuilder)canonicalClassNameBuffer).append("[]");
        }
        return ((StringBuilder)charSequence).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static Class<?> getClass(ClassLoader classLoader, String className) throws ClassNotFoundException {
        void var1_1;
        return ClassUtils.getClass(classLoader, (String)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public static Class<?> getClass(ClassLoader classLoader, String className, boolean initialize) throws ClassNotFoundException {
        try {
            Class<?> clazz = ClassUtils.getPrimitiveClass(className);
            if (clazz != null) {
                return clazz;
            }
            return Class.forName(ClassUtils.toCanonicalName(className), initialize, classLoader);
        }
        catch (ClassNotFoundException ex) {
            void var3_4;
            int lastDotIndex = className.lastIndexOf(46);
            if (lastDotIndex != -1) {
                try {
                    void var2_2;
                    void var1_1;
                    ClassLoader classLoader2;
                    return ClassUtils.getClass(classLoader2, className.substring(0, lastDotIndex) + '$' + var1_1.substring(lastDotIndex + 1), (boolean)var2_2);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            throw var3_4;
        }
    }

    public static Class<?> getClass(String className) throws ClassNotFoundException {
        return ClassUtils.getClass(className, true);
    }

    /*
     * WARNING - void declaration
     */
    public static Class<?> getClass(String className, boolean initialize) throws ClassNotFoundException {
        void var1_1;
        String string;
        ClassLoader classLoader;
        ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
        classLoader = contextCL == null ? ClassUtils.class.getClassLoader() : classLoader;
        return ClassUtils.getClass(classLoader, string, (boolean)var1_1);
    }

    public static <T> Class<T> getComponentType(Class<T[]> cls) {
        Class<T[]> clazz;
        if (cls == null) {
            return null;
        }
        return clazz.getComponentType();
    }

    public static String getName(Class<?> cls) {
        return ClassUtils.getName(cls, "");
    }

    /*
     * WARNING - void declaration
     */
    public static String getName(Class<?> cls, String valueIfNull) {
        Class<?> clazz;
        if (cls == null) {
            void var1_1;
            return var1_1;
        }
        return clazz.getName();
    }

    public static String getName(Object object) {
        return ClassUtils.getName(object, "");
    }

    /*
     * WARNING - void declaration
     */
    public static String getName(Object object, String valueIfNull) {
        Object object2;
        if (object == null) {
            void var1_1;
            return var1_1;
        }
        return object2.getClass().getName();
    }

    public static String getPackageCanonicalName(Class<?> cls) {
        Class<?> clazz;
        if (cls == null) {
            return "";
        }
        return ClassUtils.getPackageCanonicalName(clazz.getName());
    }

    /*
     * WARNING - void declaration
     */
    public static String getPackageCanonicalName(Object object, String valueIfNull) {
        Object object2;
        if (object == null) {
            void var1_1;
            return var1_1;
        }
        return ClassUtils.getPackageCanonicalName(object2.getClass().getName());
    }

    public static String getPackageCanonicalName(String name) {
        return ClassUtils.getPackageName(ClassUtils.getCanonicalName(name));
    }

    public static String getPackageName(Class<?> cls) {
        Class<?> clazz;
        if (cls == null) {
            return "";
        }
        return ClassUtils.getPackageName(clazz.getName());
    }

    /*
     * WARNING - void declaration
     */
    public static String getPackageName(Object object, String valueIfNull) {
        Object object2;
        if (object == null) {
            void var1_1;
            return var1_1;
        }
        return ClassUtils.getPackageName(object2.getClass());
    }

    /*
     * WARNING - void declaration
     */
    public static String getPackageName(String className) {
        void var1_1;
        String string;
        int i2;
        if (StringUtils.isEmpty(className)) {
            return "";
        }
        while (className.charAt(0) == '[') {
            className = className.substring(1);
        }
        if (className.charAt(0) == 'L') {
            String string2 = className;
            if (string2.charAt(string2.length() - 1) == ';') {
                className = className.substring(1);
            }
        }
        if ((i2 = className.lastIndexOf(46)) == -1) {
            return "";
        }
        return string.substring(0, (int)var1_1);
    }

    static Class<?> getPrimitiveClass(String className) {
        String string;
        return namePrimitiveMap.get(string);
    }

    /*
     * WARNING - void declaration
     */
    public static Method getPublicMethod(Class<?> cls, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        void var2_2;
        void var1_1;
        Object object;
        Method method = cls.getMethod(methodName, parameterTypes);
        if (ClassUtils.isPublic(method.getDeclaringClass())) {
            return method;
        }
        ArrayList arrayList = new ArrayList(ClassUtils.getAllInterfaces(cls));
        arrayList.addAll(ClassUtils.getAllSuperclasses(object));
        for (Class clazz : arrayList) {
            Method method2;
            if (!ClassUtils.isPublic(clazz)) continue;
            try {
                method2 = clazz.getMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
            if (!Modifier.isPublic(method2.getDeclaringClass().getModifiers())) continue;
            return method2;
        }
        throw new NoSuchMethodException("Can't find a public method for " + (String)var1_1 + " " + ArrayUtils.toString(var2_2));
    }

    public static String getShortCanonicalName(Class<?> cls) {
        Class<?> clazz;
        if (cls == null) {
            return "";
        }
        return ClassUtils.getShortCanonicalName(clazz.getCanonicalName());
    }

    /*
     * WARNING - void declaration
     */
    public static String getShortCanonicalName(Object object, String valueIfNull) {
        Object object2;
        if (object == null) {
            void var1_1;
            return var1_1;
        }
        return ClassUtils.getShortCanonicalName(object2.getClass().getCanonicalName());
    }

    public static String getShortCanonicalName(String canonicalName) {
        return ClassUtils.getShortClassName(ClassUtils.getCanonicalName(canonicalName));
    }

    public static String getShortClassName(Class<?> cls) {
        Class<?> clazz;
        if (cls == null) {
            return "";
        }
        return ClassUtils.getShortClassName(clazz.getName());
    }

    /*
     * WARNING - void declaration
     */
    public static String getShortClassName(Object object, String valueIfNull) {
        Object object2;
        if (object == null) {
            void var1_1;
            return var1_1;
        }
        return ClassUtils.getShortClassName(object2.getClass());
    }

    /*
     * WARNING - void declaration
     */
    public static String getShortClassName(String className) {
        void var1_1;
        String string;
        void var3_3;
        void var2_2;
        int lastDotIdx;
        if (StringUtils.isEmpty(className)) {
            return "";
        }
        StringBuilder arrayPrefix = new StringBuilder();
        if (className.startsWith("[")) {
            while (className.charAt(0) == '[') {
                className = className.substring(1);
                arrayPrefix.append("[]");
            }
            if (className.charAt(0) == 'L') {
                String string2 = className;
                if (string2.charAt(string2.length() - 1) == ';') {
                    className = className.substring(1, className.length() - 1);
                }
            }
            if (reverseAbbreviationMap.containsKey(className)) {
                className = reverseAbbreviationMap.get(className);
            }
        }
        int innerIdx = className.indexOf(36, (lastDotIdx = className.lastIndexOf(46)) == -1 ? 0 : lastDotIdx + 1);
        String out = className.substring((int)(var2_2 + true));
        if (var3_3 != -1) {
            out = out.replace('$', '.');
        }
        return string + var1_1;
    }

    public static String getSimpleName(Class<?> cls) {
        return ClassUtils.getSimpleName(cls, "");
    }

    /*
     * WARNING - void declaration
     */
    public static String getSimpleName(Class<?> cls, String valueIfNull) {
        Class<?> clazz;
        if (cls == null) {
            void var1_1;
            return var1_1;
        }
        return clazz.getSimpleName();
    }

    public static String getSimpleName(Object object) {
        return ClassUtils.getSimpleName(object, "");
    }

    /*
     * WARNING - void declaration
     */
    public static String getSimpleName(Object object, String valueIfNull) {
        Object object2;
        if (object == null) {
            void var1_1;
            return var1_1;
        }
        return object2.getClass().getSimpleName();
    }

    public static Iterable<Class<?>> hierarchy(Class<?> type) {
        return ClassUtils.hierarchy(type, Interfaces.EXCLUDE);
    }

    /*
     * WARNING - void declaration
     */
    public static Iterable<Class<?>> hierarchy(Class<?> type, Interfaces interfacesBehavior) {
        Iterable iterable;
        void var1_1;
        Iterable classes = () -> {
            Serializable serializable;
            Serializable next = new MutableObject<Class>(type);
            return new Iterator<Class<?>>((MutableObject)serializable){
                final /* synthetic */ MutableObject val$next;
                {
                    this.val$next = mutableObject;
                }

                @Override
                public boolean hasNext() {
                    return this.val$next.getValue() != null;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public Class<?> next() {
                    void var1_1;
                    Class result = (Class)this.val$next.getValue();
                    this.val$next.setValue(result.getSuperclass());
                    return var1_1;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        };
        if (var1_1 != Interfaces.INCLUDE) {
            return classes;
        }
        return () -> {
            void var1_1;
            Iterator iterator2;
            HashSet seenInterfaces = new HashSet();
            Iterator wrapped = iterable.iterator();
            return new Iterator<Class<?>>(){
                Iterator<Class<?>> interfaces = Collections.emptyIterator();
                final /* synthetic */ Set val$seenInterfaces;
                {
                    this.val$seenInterfaces = set;
                }

                @Override
                public boolean hasNext() {
                    return this.interfaces.hasNext() || iterator2.hasNext();
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public Class<?> next() {
                    void var1_2;
                    void var2_3;
                    if (this.interfaces.hasNext()) {
                        Class<?> nextInterface = this.interfaces.next();
                        this.val$seenInterfaces.add(nextInterface);
                        return nextInterface;
                    }
                    Class nextSuperclass = (Class)iterator2.next();
                    LinkedHashSet currentInterfaces = new LinkedHashSet();
                    this.walkInterfaces(currentInterfaces, nextSuperclass);
                    this.interfaces = var2_3.iterator();
                    return var1_2;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                private void walkInterfaces(Set<Class<?>> addTo, Class<?> c2) {
                    for (Class<?> iface : c2.getInterfaces()) {
                        if (!this.val$seenInterfaces.contains(iface)) {
                            addTo.add(iface);
                        }
                        this.walkInterfaces(addTo, iface);
                    }
                }
            };
        };
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isAssignable(Class<?> cls, Class<?> toClass) {
        void var1_1;
        return ClassUtils.isAssignable(cls, var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isAssignable(Class<?> cls, Class<?> toClass, boolean autoboxing) {
        Class<?> clazz;
        void var1_1;
        void var2_2;
        if (toClass == null) {
            return false;
        }
        if (cls == null) {
            return !toClass.isPrimitive();
        }
        if (var2_2 != false) {
            if (cls.isPrimitive() && !toClass.isPrimitive() && (cls = ClassUtils.primitiveToWrapper(cls)) == null) {
                return false;
            }
            if (toClass.isPrimitive() && !cls.isPrimitive() && (cls = ClassUtils.wrapperToPrimitive(cls)) == null) {
                return false;
            }
        }
        if (cls.equals(toClass)) {
            return true;
        }
        if (cls.isPrimitive()) {
            if (!toClass.isPrimitive()) {
                return false;
            }
            if (Integer.TYPE.equals(cls)) {
                return Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Long.TYPE.equals(cls)) {
                return Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Boolean.TYPE.equals(cls)) {
                return false;
            }
            if (Double.TYPE.equals(cls)) {
                return false;
            }
            if (Float.TYPE.equals(cls)) {
                return Double.TYPE.equals(toClass);
            }
            if (Character.TYPE.equals(cls) || Short.TYPE.equals(cls)) {
                return Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Byte.TYPE.equals(cls)) {
                return Short.TYPE.equals(toClass) || Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            return false;
        }
        return var1_1.isAssignableFrom(clazz);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isAssignable(Class<?>[] classArray, Class<?> ... toClassArray) {
        void var1_1;
        return ClassUtils.isAssignable(classArray, var1_1, true);
    }

    public static boolean isAssignable(Class<?>[] classArray, Class<?>[] toClassArray, boolean autoboxing) {
        if (!ArrayUtils.isSameLength(classArray, toClassArray)) {
            return false;
        }
        classArray = ArrayUtils.nullToEmpty(classArray);
        toClassArray = ArrayUtils.nullToEmpty(toClassArray);
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            if (ClassUtils.isAssignable(classArray[i2], toClassArray[i2], autoboxing)) continue;
            return false;
        }
        return true;
    }

    public static boolean isInnerClass(Class<?> cls) {
        Class<?> clazz;
        return cls != null && clazz.getEnclosingClass() != null;
    }

    public static boolean isPrimitiveOrWrapper(Class<?> type) {
        Class<?> clazz;
        if (type == null) {
            return false;
        }
        return type.isPrimitive() || ClassUtils.isPrimitiveWrapper(clazz);
    }

    public static boolean isPrimitiveWrapper(Class<?> type) {
        Class<?> clazz;
        return wrapperPrimitiveMap.containsKey(clazz);
    }

    public static boolean isPublic(Class<?> cls) {
        return Modifier.isPublic(cls.getModifiers());
    }

    /*
     * WARNING - void declaration
     */
    public static Class<?>[] primitivesToWrappers(Class<?> ... classes) {
        void var1_1;
        Class<?>[] classArray;
        if (classes == null) {
            return null;
        }
        if (classes.length == 0) {
            return classes;
        }
        Class[] convertedClasses = new Class[classes.length];
        Arrays.setAll(convertedClasses, i2 -> {
            void var1_1;
            return ClassUtils.primitiveToWrapper(classArray[var1_1]);
        });
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static Class<?> primitiveToWrapper(Class<?> cls) {
        void var1_1;
        Class<?> convertedClass = cls;
        if (cls != null && cls.isPrimitive()) {
            Class<?> clazz;
            convertedClass = primitiveWrapperMap.get(clazz);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static String toCanonicalName(String className) {
        String string;
        String canonicalName = StringUtils.deleteWhitespace(className);
        Objects.requireNonNull(canonicalName, "className");
        if (canonicalName.endsWith("[]")) {
            void var1_1;
            StringBuilder classNameBuffer = new StringBuilder();
            while (canonicalName.endsWith("[]")) {
                canonicalName = canonicalName.substring(0, canonicalName.length() - 2);
                classNameBuffer.append("[");
            }
            String abbreviation = abbreviationMap.get(canonicalName);
            if (abbreviation != null) {
                void var2_2;
                classNameBuffer.append((String)var2_2);
            } else {
                classNameBuffer.append("L").append(canonicalName).append(";");
            }
            canonicalName = var1_1.toString();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static Class<?>[] toClass(Object ... array) {
        void var1_1;
        Object[] objectArray;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        Class[] classes = new Class[array.length];
        Arrays.setAll(classes, i2 -> {
            void var1_1;
            Object[] objectArray;
            if (objectArray[i2] == null) {
                return null;
            }
            return objectArray[var1_1].getClass();
        });
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean useFull(int runAheadTarget, int source2, int originalLength, int desiredLength) {
        void var3_3;
        void var1_1;
        void var2_2;
        int n2;
        return source2 >= originalLength || n2 + var2_2 - var1_1 <= var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static Class<?>[] wrappersToPrimitives(Class<?> ... classes) {
        void var1_1;
        Class<?>[] classArray;
        if (classes == null) {
            return null;
        }
        if (classes.length == 0) {
            return classes;
        }
        Class[] convertedClasses = new Class[classes.length];
        Arrays.setAll(convertedClasses, i2 -> {
            void var1_1;
            return ClassUtils.wrapperToPrimitive(classArray[var1_1]);
        });
        return var1_1;
    }

    public static Class<?> wrapperToPrimitive(Class<?> cls) {
        Class<?> clazz;
        return wrapperPrimitiveMap.get(clazz);
    }

    @Deprecated
    public ClassUtils() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        COMPARATOR = (o1, o2) -> {
            void var1_1;
            return Objects.compare(ClassUtils.getName(o1), ClassUtils.getName(var1_1), String::compareTo);
        };
        PACKAGE_SEPARATOR = ".";
        INNER_CLASS_SEPARATOR = "$";
        namePrimitiveMap = new HashMap();
        namePrimitiveMap.put(Boolean.TYPE.getSimpleName(), Boolean.TYPE);
        namePrimitiveMap.put(Byte.TYPE.getSimpleName(), Byte.TYPE);
        namePrimitiveMap.put(Character.TYPE.getSimpleName(), Character.TYPE);
        namePrimitiveMap.put(Double.TYPE.getSimpleName(), Double.TYPE);
        namePrimitiveMap.put(Float.TYPE.getSimpleName(), Float.TYPE);
        namePrimitiveMap.put(Integer.TYPE.getSimpleName(), Integer.TYPE);
        namePrimitiveMap.put(Long.TYPE.getSimpleName(), Long.TYPE);
        namePrimitiveMap.put(Short.TYPE.getSimpleName(), Short.TYPE);
        namePrimitiveMap.put(Void.TYPE.getSimpleName(), Void.TYPE);
        primitiveWrapperMap = new HashMap();
        primitiveWrapperMap.put(Boolean.TYPE, Boolean.class);
        primitiveWrapperMap.put(Byte.TYPE, Byte.class);
        primitiveWrapperMap.put(Character.TYPE, Character.class);
        primitiveWrapperMap.put(Short.TYPE, Short.class);
        primitiveWrapperMap.put(Integer.TYPE, Integer.class);
        primitiveWrapperMap.put(Long.TYPE, Long.class);
        primitiveWrapperMap.put(Double.TYPE, Double.class);
        primitiveWrapperMap.put(Float.TYPE, Float.class);
        Class<Void> clazz = Void.TYPE;
        primitiveWrapperMap.put(clazz, clazz);
        wrapperPrimitiveMap = new HashMap();
        primitiveWrapperMap.forEach((primitiveClass, wrapperClass) -> {
            if (!primitiveClass.equals(wrapperClass)) {
                Class clazz;
                void var1_1;
                wrapperPrimitiveMap.put((Class<?>)var1_1, clazz);
            }
        });
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("int", "I");
        map.put("boolean", "Z");
        map.put("float", "F");
        map.put("long", "J");
        map.put("short", "S");
        map.put("byte", "B");
        map.put("double", "D");
        map.put("char", "C");
        abbreviationMap = Collections.unmodifiableMap(map);
        reverseAbbreviationMap = Collections.unmodifiableMap(var0.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey)));
    }

    public static enum Interfaces {
        INCLUDE,
        EXCLUDE;

    }
}

