/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Objects;

public class ClassLoaderUtils {
    private static final URL[] EMPTY_URL_ARRAY = new URL[0];

    public static URL[] getSystemURLs() {
        return ClassLoaderUtils.getURLs(ClassLoader.getSystemClassLoader());
    }

    public static URL[] getThreadURLs() {
        return ClassLoaderUtils.getURLs(Thread.currentThread().getContextClassLoader());
    }

    private static URL[] getURLs(ClassLoader cl) {
        if (cl instanceof URLClassLoader) {
            ClassLoader classLoader;
            return ((URLClassLoader)classLoader).getURLs();
        }
        return EMPTY_URL_ARRAY;
    }

    public static String toString(ClassLoader classLoader) {
        ClassLoader classLoader2;
        if (classLoader instanceof URLClassLoader) {
            return ClassLoaderUtils.toString((URLClassLoader)classLoader);
        }
        return Objects.toString(classLoader2);
    }

    public static String toString(URLClassLoader classLoader) {
        if (classLoader != null) {
            URLClassLoader uRLClassLoader;
            return classLoader + Arrays.toString(uRLClassLoader.getURLs());
        }
        return "null";
    }

    @Deprecated
    public ClassLoaderUtils() {
    }
}

