/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import org.apache.commons.lang3.ArraySorter;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.CharUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.stream.Streams;

public class ArrayUtils {
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    public static final Boolean[] EMPTY_BOOLEAN_OBJECT_ARRAY = new Boolean[0];
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final Byte[] EMPTY_BYTE_OBJECT_ARRAY = new Byte[0];
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final Character[] EMPTY_CHARACTER_OBJECT_ARRAY = new Character[0];
    public static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    public static final Double[] EMPTY_DOUBLE_OBJECT_ARRAY = new Double[0];
    public static final Field[] EMPTY_FIELD_ARRAY = new Field[0];
    public static final float[] EMPTY_FLOAT_ARRAY = new float[0];
    public static final Float[] EMPTY_FLOAT_OBJECT_ARRAY = new Float[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final Integer[] EMPTY_INTEGER_OBJECT_ARRAY = new Integer[0];
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    public static final Long[] EMPTY_LONG_OBJECT_ARRAY = new Long[0];
    public static final Method[] EMPTY_METHOD_ARRAY = new Method[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final short[] EMPTY_SHORT_ARRAY = new short[0];
    public static final Short[] EMPTY_SHORT_OBJECT_ARRAY = new Short[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final Throwable[] EMPTY_THROWABLE_ARRAY = new Throwable[0];
    public static final Type[] EMPTY_TYPE_ARRAY = new Type[0];
    public static final int INDEX_NOT_FOUND = -1;

    /*
     * WARNING - void declaration
     */
    public static boolean[] add(boolean[] array, boolean element) {
        boolean[] blArray;
        void var1_1;
        boolean[] blArray2 = (boolean[])ArrayUtils.copyArrayGrow1(array, Boolean.TYPE);
        boolean[] newArray = blArray2;
        blArray2[newArray.length - 1] = var1_1;
        return blArray;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static boolean[] add(boolean[] array, int index, boolean element) {
        void var2_2;
        void var1_1;
        return (boolean[])ArrayUtils.add(array, (int)var1_1, (boolean)var2_2, Boolean.TYPE);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] add(byte[] array, byte element) {
        byte[] byArray;
        void var1_1;
        byte[] byArray2 = (byte[])ArrayUtils.copyArrayGrow1(array, Byte.TYPE);
        byte[] newArray = byArray2;
        byArray2[newArray.length - 1] = var1_1;
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static byte[] add(byte[] array, int index, byte element) {
        void var2_2;
        void var1_1;
        return (byte[])ArrayUtils.add(array, (int)var1_1, (byte)var2_2, Byte.TYPE);
    }

    /*
     * WARNING - void declaration
     */
    public static char[] add(char[] array, char element) {
        char[] cArray;
        void var1_1;
        char[] cArray2 = (char[])ArrayUtils.copyArrayGrow1(array, Character.TYPE);
        char[] newArray = cArray2;
        cArray2[newArray.length - 1] = var1_1;
        return cArray;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static char[] add(char[] array, int index, char element) {
        void var2_2;
        void var1_1;
        return (char[])ArrayUtils.add(array, (int)var1_1, Character.valueOf((char)var2_2), Character.TYPE);
    }

    /*
     * WARNING - void declaration
     */
    public static double[] add(double[] array, double element) {
        double[] dArray;
        void var1_1;
        double[] dArray2 = (double[])ArrayUtils.copyArrayGrow1(array, Double.TYPE);
        double[] newArray = dArray2;
        dArray2[newArray.length - 1] = var1_1;
        return dArray;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static double[] add(double[] array, int index, double element) {
        void var2_2;
        void var1_1;
        return (double[])ArrayUtils.add(array, (int)var1_1, (double)var2_2, Double.TYPE);
    }

    /*
     * WARNING - void declaration
     */
    public static float[] add(float[] array, float element) {
        float[] fArray;
        void var1_1;
        float[] fArray2 = (float[])ArrayUtils.copyArrayGrow1(array, Float.TYPE);
        float[] newArray = fArray2;
        fArray2[newArray.length - 1] = var1_1;
        return fArray;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static float[] add(float[] array, int index, float element) {
        void var2_2;
        void var1_1;
        return (float[])ArrayUtils.add(array, (int)var1_1, Float.valueOf((float)var2_2), Float.TYPE);
    }

    /*
     * WARNING - void declaration
     */
    public static int[] add(int[] array, int element) {
        int[] nArray;
        void var1_1;
        int[] nArray2 = (int[])ArrayUtils.copyArrayGrow1(array, Integer.TYPE);
        int[] newArray = nArray2;
        nArray2[newArray.length - 1] = var1_1;
        return nArray;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static int[] add(int[] array, int index, int element) {
        void var2_2;
        void var1_1;
        return (int[])ArrayUtils.add(array, (int)var1_1, (int)var2_2, Integer.TYPE);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static long[] add(long[] array, int index, long element) {
        void var2_2;
        void var1_1;
        return (long[])ArrayUtils.add(array, (int)var1_1, (long)var2_2, Long.TYPE);
    }

    /*
     * WARNING - void declaration
     */
    public static long[] add(long[] array, long element) {
        long[] lArray;
        void var1_1;
        long[] lArray2 = (long[])ArrayUtils.copyArrayGrow1(array, Long.TYPE);
        long[] newArray = lArray2;
        lArray2[newArray.length - 1] = var1_1;
        return lArray;
    }

    /*
     * WARNING - void declaration
     */
    private static Object add(Object array, int index, Object element, Class<?> clazz) {
        void var3_3;
        void var2_2;
        if (array == null) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Length: 0");
            }
            Object joinedArray = Array.newInstance(clazz, 1);
            Array.set(joinedArray, 0, element);
            return joinedArray;
        }
        int length = Array.getLength(array);
        if (index > length || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + length);
        }
        Object result = ArrayUtils.arraycopy(array, 0, 0, index, () -> {
            void var1_1;
            return Array.newInstance(clazz, (int)(var1_1 + true));
        });
        Array.set(result, index, var2_2);
        if (index < length) {
            void var1_1;
            Object object;
            System.arraycopy(object, index, result, index + 1, length - var1_1);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static short[] add(short[] array, int index, short element) {
        void var2_2;
        void var1_1;
        return (short[])ArrayUtils.add(array, (int)var1_1, (short)var2_2, Short.TYPE);
    }

    /*
     * WARNING - void declaration
     */
    public static short[] add(short[] array, short element) {
        short[] sArray;
        void var1_1;
        short[] sArray2 = (short[])ArrayUtils.copyArrayGrow1(array, Short.TYPE);
        short[] newArray = sArray2;
        sArray2[newArray.length - 1] = var1_1;
        return sArray;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static <T> T[] add(T[] array, int index, T element) {
        void var3_3;
        void var2_2;
        void var1_1;
        T[] TArray;
        Class<T> clazz;
        if (array != null) {
            clazz = ArrayUtils.getComponentType(array);
        } else if (element != null) {
            clazz = ObjectUtils.getClass(element);
        } else {
            throw new IllegalArgumentException("Array and element cannot both be null");
        }
        return (Object[])ArrayUtils.add(TArray, (int)var1_1, var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] add(T[] array, T element) {
        Object[] objectArray;
        void var1_1;
        void var2_2;
        Class<?> type;
        if (array != null) {
            type = array.getClass().getComponentType();
        } else if (element != null) {
            type = element.getClass();
        } else {
            throw new IllegalArgumentException("Arguments cannot both be null");
        }
        Object[] objectArray2 = (Object[])ArrayUtils.copyArrayGrow1(array, var2_2);
        Object[] newArray = objectArray2;
        objectArray2[newArray.length - 1] = var1_1;
        return objectArray;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean[] addAll(boolean[] array1, boolean ... array2) {
        void var2_2;
        void var1_1;
        boolean[] blArray;
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        boolean[] joinedArray = new boolean[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, blArray.length, ((void)var1_1).length);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] addAll(byte[] array1, byte ... array2) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        byte[] joinedArray = new byte[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, byArray.length, ((void)var1_1).length);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static char[] addAll(char[] array1, char ... array2) {
        void var2_2;
        void var1_1;
        char[] cArray;
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        char[] joinedArray = new char[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, cArray.length, ((void)var1_1).length);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static double[] addAll(double[] array1, double ... array2) {
        void var2_2;
        void var1_1;
        double[] dArray;
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        double[] joinedArray = new double[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, dArray.length, ((void)var1_1).length);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static float[] addAll(float[] array1, float ... array2) {
        void var2_2;
        void var1_1;
        float[] fArray;
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        float[] joinedArray = new float[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, fArray.length, ((void)var1_1).length);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static int[] addAll(int[] array1, int ... array2) {
        void var2_2;
        void var1_1;
        int[] nArray;
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        int[] joinedArray = new int[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, nArray.length, ((void)var1_1).length);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static long[] addAll(long[] array1, long ... array2) {
        void var2_2;
        void var1_1;
        long[] lArray;
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        long[] joinedArray = new long[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, lArray.length, ((void)var1_1).length);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static short[] addAll(short[] array1, short ... array2) {
        void var2_2;
        void var1_1;
        short[] sArray;
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        short[] joinedArray = new short[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, sArray.length, ((void)var1_1).length);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] addAll(T[] array1, T ... array2) {
        void var3_4;
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        Class type1 = ArrayUtils.getComponentType(array1);
        Object[] joinedArray = ArrayUtils.arraycopy(array1, 0, 0, array1.length, () -> {
            void var2_2;
            void var1_1;
            return ArrayUtils.newInstance(type1, ((void)var1_1).length + ((void)var2_2).length);
        });
        try {
            System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        }
        catch (ArrayStoreException ase) {
            void var0_1;
            Class<?> type2 = array2.getClass().getComponentType();
            if (!type1.isAssignableFrom(type2)) {
                void var2_3;
                void var1_2;
                throw new IllegalArgumentException("Cannot store " + var1_2.getName() + " in an array of " + var2_3.getName(), ase);
            }
            throw var0_1;
        }
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean[] addFirst(boolean[] array, boolean element) {
        void var1_1;
        boolean[] blArray;
        if (array == null) {
            return ArrayUtils.add(array, element);
        }
        return ArrayUtils.insert(0, blArray, new boolean[]{var1_1});
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] addFirst(byte[] array, byte element) {
        void var1_1;
        byte[] byArray;
        if (array == null) {
            return ArrayUtils.add(array, element);
        }
        return ArrayUtils.insert(0, byArray, new byte[]{var1_1});
    }

    /*
     * WARNING - void declaration
     */
    public static char[] addFirst(char[] array, char element) {
        void var1_1;
        char[] cArray;
        if (array == null) {
            return ArrayUtils.add(array, element);
        }
        return ArrayUtils.insert(0, cArray, new char[]{var1_1});
    }

    /*
     * WARNING - void declaration
     */
    public static double[] addFirst(double[] array, double element) {
        void var1_1;
        double[] dArray;
        if (array == null) {
            return ArrayUtils.add(array, element);
        }
        return ArrayUtils.insert(0, dArray, new double[]{var1_1});
    }

    /*
     * WARNING - void declaration
     */
    public static float[] addFirst(float[] array, float element) {
        void var1_1;
        float[] fArray;
        if (array == null) {
            return ArrayUtils.add(array, element);
        }
        return ArrayUtils.insert(0, fArray, new float[]{var1_1});
    }

    /*
     * WARNING - void declaration
     */
    public static int[] addFirst(int[] array, int element) {
        void var1_1;
        int[] nArray;
        if (array == null) {
            return ArrayUtils.add(array, element);
        }
        return ArrayUtils.insert(0, nArray, new int[]{var1_1});
    }

    /*
     * WARNING - void declaration
     */
    public static long[] addFirst(long[] array, long element) {
        void var1_1;
        long[] lArray;
        if (array == null) {
            return ArrayUtils.add(array, element);
        }
        return ArrayUtils.insert(0, lArray, new long[]{var1_1});
    }

    /*
     * WARNING - void declaration
     */
    public static short[] addFirst(short[] array, short element) {
        void var1_1;
        short[] sArray;
        if (array == null) {
            return ArrayUtils.add(array, element);
        }
        return ArrayUtils.insert(0, sArray, new short[]{var1_1});
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] addFirst(T[] array, T element) {
        void var1_1;
        T[] TArray;
        if (array == null) {
            return ArrayUtils.add(array, element);
        }
        return ArrayUtils.insert(0, TArray, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T arraycopy(T source2, int sourcePos, int destPos, int length, Function<Integer, T> allocator) {
        void var3_3;
        void var2_2;
        void var1_1;
        return ArrayUtils.arraycopy(source2, (int)var1_1, allocator.apply(length), (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T arraycopy(T source2, int sourcePos, int destPos, int length, Supplier<T> allocator) {
        void var3_3;
        void var2_2;
        void var1_1;
        return ArrayUtils.arraycopy(source2, (int)var1_1, allocator.get(), (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T arraycopy(T source2, int sourcePos, T dest, int destPos, int length) {
        void var2_2;
        void var3_3;
        void var1_1;
        System.arraycopy(source2, (int)var1_1, dest, (int)var3_3, length);
        return var2_2;
    }

    public static boolean[] clone(boolean[] array) {
        if (array != null) {
            boolean[] blArray;
            return (boolean[])blArray.clone();
        }
        return null;
    }

    public static byte[] clone(byte[] array) {
        if (array != null) {
            byte[] byArray;
            return (byte[])byArray.clone();
        }
        return null;
    }

    public static char[] clone(char[] array) {
        if (array != null) {
            char[] cArray;
            return (char[])cArray.clone();
        }
        return null;
    }

    public static double[] clone(double[] array) {
        if (array != null) {
            double[] dArray;
            return (double[])dArray.clone();
        }
        return null;
    }

    public static float[] clone(float[] array) {
        if (array != null) {
            float[] fArray;
            return (float[])fArray.clone();
        }
        return null;
    }

    public static int[] clone(int[] array) {
        if (array != null) {
            int[] nArray;
            return (int[])nArray.clone();
        }
        return null;
    }

    public static long[] clone(long[] array) {
        if (array != null) {
            long[] lArray;
            return (long[])lArray.clone();
        }
        return null;
    }

    public static short[] clone(short[] array) {
        if (array != null) {
            short[] sArray;
            return (short[])sArray.clone();
        }
        return null;
    }

    public static <T> T[] clone(T[] array) {
        if (array != null) {
            T[] TArray;
            return (Object[])TArray.clone();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contains(boolean[] array, boolean valueToFind) {
        void var1_1;
        return ArrayUtils.indexOf(array, (boolean)var1_1) != -1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contains(byte[] array, byte valueToFind) {
        void var1_1;
        return ArrayUtils.indexOf(array, (byte)var1_1) != -1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contains(char[] array, char valueToFind) {
        void var1_1;
        return ArrayUtils.indexOf(array, (char)var1_1) != -1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contains(double[] array, double valueToFind) {
        void var1_1;
        return ArrayUtils.indexOf(array, (double)var1_1) != -1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contains(double[] array, double valueToFind, double tolerance) {
        void var3_2;
        void var1_1;
        return ArrayUtils.indexOf(array, (double)var1_1, 0, (double)var3_2) != -1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contains(float[] array, float valueToFind) {
        void var1_1;
        return ArrayUtils.indexOf(array, (float)var1_1) != -1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contains(int[] array, int valueToFind) {
        void var1_1;
        return ArrayUtils.indexOf(array, (int)var1_1) != -1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contains(long[] array, long valueToFind) {
        void var1_1;
        return ArrayUtils.indexOf(array, (long)var1_1) != -1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contains(Object[] array, Object objectToFind) {
        void var1_1;
        return ArrayUtils.indexOf(array, var1_1) != -1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contains(short[] array, short valueToFind) {
        void var1_1;
        return ArrayUtils.indexOf(array, (short)var1_1) != -1;
    }

    public static boolean containsAny(Object[] array, Object ... objectsToFind) {
        Object[] objectArray;
        return Streams.of(objectsToFind).anyMatch(e2 -> {
            void var1_1;
            return ArrayUtils.contains(objectArray, var1_1);
        });
    }

    /*
     * WARNING - void declaration
     */
    private static Object copyArrayGrow1(Object array, Class<?> newArrayComponentType) {
        void var1_1;
        if (array != null) {
            void var2_3;
            void var1_2;
            Object object;
            int arrayLength = Array.getLength(array);
            Object newArray = Array.newInstance(array.getClass().getComponentType(), arrayLength + 1);
            System.arraycopy(object, 0, newArray, 0, (int)var1_2);
            return var2_3;
        }
        return Array.newInstance(var1_1, 1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T get(T[] array, int index) {
        void var1_1;
        return ArrayUtils.get(array, (int)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T get(T[] array, int index, T defaultValue) {
        void var2_2;
        if (ArrayUtils.isArrayIndexValid(array, index)) {
            void var1_1;
            T[] TArray;
            return TArray[var1_1];
        }
        return var2_2;
    }

    public static <T> Class<T> getComponentType(T[] array) {
        return ClassUtils.getComponentType(ObjectUtils.getClass(array));
    }

    public static int getLength(Object array) {
        if (array != null) {
            Object object;
            return Array.getLength(object);
        }
        return 0;
    }

    public static int hashCode(Object array) {
        Object object;
        return new HashCodeBuilder().append(object).toHashCode();
    }

    /*
     * WARNING - void declaration
     */
    public static BitSet indexesOf(boolean[] array, boolean valueToFind) {
        void var1_1;
        return ArrayUtils.indexesOf(array, (boolean)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static BitSet indexesOf(boolean[] array, boolean valueToFind, int startIndex) {
        void var3_3;
        BitSet bitSet = new BitSet();
        if (array == null) {
            return bitSet;
        }
        while (startIndex < array.length && (startIndex = ArrayUtils.indexOf(array, valueToFind, startIndex)) != -1) {
            bitSet.set(startIndex);
            ++startIndex;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static BitSet indexesOf(byte[] array, byte valueToFind) {
        void var1_1;
        return ArrayUtils.indexesOf(array, (byte)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static BitSet indexesOf(byte[] array, byte valueToFind, int startIndex) {
        void var3_3;
        BitSet bitSet = new BitSet();
        if (array == null) {
            return bitSet;
        }
        while (startIndex < array.length && (startIndex = ArrayUtils.indexOf(array, valueToFind, startIndex)) != -1) {
            bitSet.set(startIndex);
            ++startIndex;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static BitSet indexesOf(char[] array, char valueToFind) {
        void var1_1;
        return ArrayUtils.indexesOf(array, (char)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static BitSet indexesOf(char[] array, char valueToFind, int startIndex) {
        void var3_3;
        BitSet bitSet = new BitSet();
        if (array == null) {
            return bitSet;
        }
        while (startIndex < array.length && (startIndex = ArrayUtils.indexOf(array, valueToFind, startIndex)) != -1) {
            bitSet.set(startIndex);
            ++startIndex;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static BitSet indexesOf(double[] array, double valueToFind) {
        void var1_1;
        return ArrayUtils.indexesOf(array, (double)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static BitSet indexesOf(double[] array, double valueToFind, double tolerance) {
        void var3_2;
        void var1_1;
        return ArrayUtils.indexesOf(array, (double)var1_1, 0, (double)var3_2);
    }

    public static BitSet indexesOf(double[] array, double valueToFind, int startIndex) {
        BitSet bitSet = new BitSet();
        if (array == null) {
            return bitSet;
        }
        while (startIndex < array.length && (startIndex = ArrayUtils.indexOf(array, valueToFind, startIndex)) != -1) {
            bitSet.set(startIndex);
            ++startIndex;
        }
        return bitSet;
    }

    public static BitSet indexesOf(double[] array, double valueToFind, int startIndex, double tolerance) {
        BitSet bitSet = new BitSet();
        if (array == null) {
            return bitSet;
        }
        while (startIndex < array.length && (startIndex = ArrayUtils.indexOf(array, valueToFind, startIndex, tolerance)) != -1) {
            bitSet.set(startIndex);
            ++startIndex;
        }
        return bitSet;
    }

    /*
     * WARNING - void declaration
     */
    public static BitSet indexesOf(float[] array, float valueToFind) {
        void var1_1;
        return ArrayUtils.indexesOf(array, (float)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static BitSet indexesOf(float[] array, float valueToFind, int startIndex) {
        void var3_3;
        BitSet bitSet = new BitSet();
        if (array == null) {
            return bitSet;
        }
        while (startIndex < array.length && (startIndex = ArrayUtils.indexOf(array, valueToFind, startIndex)) != -1) {
            bitSet.set(startIndex);
            ++startIndex;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static BitSet indexesOf(int[] array, int valueToFind) {
        void var1_1;
        return ArrayUtils.indexesOf(array, (int)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static BitSet indexesOf(int[] array, int valueToFind, int startIndex) {
        void var3_3;
        BitSet bitSet = new BitSet();
        if (array == null) {
            return bitSet;
        }
        while (startIndex < array.length && (startIndex = ArrayUtils.indexOf(array, valueToFind, startIndex)) != -1) {
            bitSet.set(startIndex);
            ++startIndex;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static BitSet indexesOf(long[] array, long valueToFind) {
        void var1_1;
        return ArrayUtils.indexesOf(array, (long)var1_1, 0);
    }

    public static BitSet indexesOf(long[] array, long valueToFind, int startIndex) {
        BitSet bitSet = new BitSet();
        if (array == null) {
            return bitSet;
        }
        while (startIndex < array.length && (startIndex = ArrayUtils.indexOf(array, valueToFind, startIndex)) != -1) {
            bitSet.set(startIndex);
            ++startIndex;
        }
        return bitSet;
    }

    /*
     * WARNING - void declaration
     */
    public static BitSet indexesOf(Object[] array, Object objectToFind) {
        void var1_1;
        return ArrayUtils.indexesOf(array, var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static BitSet indexesOf(Object[] array, Object objectToFind, int startIndex) {
        void var3_3;
        BitSet bitSet = new BitSet();
        if (array == null) {
            return bitSet;
        }
        while (startIndex < array.length && (startIndex = ArrayUtils.indexOf(array, objectToFind, startIndex)) != -1) {
            bitSet.set(startIndex);
            ++startIndex;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static BitSet indexesOf(short[] array, short valueToFind) {
        void var1_1;
        return ArrayUtils.indexesOf(array, (short)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static BitSet indexesOf(short[] array, short valueToFind, int startIndex) {
        void var3_3;
        BitSet bitSet = new BitSet();
        if (array == null) {
            return bitSet;
        }
        while (startIndex < array.length && (startIndex = ArrayUtils.indexOf(array, valueToFind, startIndex)) != -1) {
            bitSet.set(startIndex);
            ++startIndex;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(boolean[] array, boolean valueToFind) {
        void var1_1;
        return ArrayUtils.indexOf(array, (boolean)var1_1, 0);
    }

    public static int indexOf(boolean[] array, boolean valueToFind, int startIndex) {
        if (ArrayUtils.isEmpty(array)) {
            return -1;
        }
        for (int i2 = ArrayUtils.max0(startIndex); i2 < array.length; ++i2) {
            if (valueToFind != array[i2]) continue;
            return i2;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(byte[] array, byte valueToFind) {
        void var1_1;
        return ArrayUtils.indexOf(array, (byte)var1_1, 0);
    }

    public static int indexOf(byte[] array, byte valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        for (int i2 = ArrayUtils.max0(startIndex); i2 < array.length; ++i2) {
            if (valueToFind != array[i2]) continue;
            return i2;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(char[] array, char valueToFind) {
        void var1_1;
        return ArrayUtils.indexOf(array, (char)var1_1, 0);
    }

    public static int indexOf(char[] array, char valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        for (int i2 = ArrayUtils.max0(startIndex); i2 < array.length; ++i2) {
            if (valueToFind != array[i2]) continue;
            return i2;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(double[] array, double valueToFind) {
        void var1_1;
        return ArrayUtils.indexOf(array, (double)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(double[] array, double valueToFind, double tolerance) {
        void var3_2;
        void var1_1;
        return ArrayUtils.indexOf(array, (double)var1_1, 0, (double)var3_2);
    }

    public static int indexOf(double[] array, double valueToFind, int startIndex) {
        if (ArrayUtils.isEmpty(array)) {
            return -1;
        }
        boolean searchNaN = Double.isNaN(valueToFind);
        for (int i2 = ArrayUtils.max0(startIndex); i2 < array.length; ++i2) {
            double element = array[i2];
            if (valueToFind != element && (!searchNaN || !Double.isNaN(element))) continue;
            return i2;
        }
        return -1;
    }

    public static int indexOf(double[] array, double valueToFind, int startIndex, double tolerance) {
        if (ArrayUtils.isEmpty(array)) {
            return -1;
        }
        double min = valueToFind - tolerance;
        double max = valueToFind + tolerance;
        for (int i2 = ArrayUtils.max0((int)var3_3); i2 < array.length; ++i2) {
            if (!(array[i2] >= min) || !(array[i2] <= max)) continue;
            return i2;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(float[] array, float valueToFind) {
        void var1_1;
        return ArrayUtils.indexOf(array, (float)var1_1, 0);
    }

    public static int indexOf(float[] array, float valueToFind, int startIndex) {
        if (ArrayUtils.isEmpty(array)) {
            return -1;
        }
        boolean searchNaN = Float.isNaN(valueToFind);
        for (int i2 = ArrayUtils.max0(startIndex); i2 < array.length; ++i2) {
            float element = array[i2];
            if (valueToFind != element && (!searchNaN || !Float.isNaN(element))) continue;
            return i2;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(int[] array, int valueToFind) {
        void var1_1;
        return ArrayUtils.indexOf(array, (int)var1_1, 0);
    }

    public static int indexOf(int[] array, int valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        for (int i2 = ArrayUtils.max0(startIndex); i2 < array.length; ++i2) {
            if (valueToFind != array[i2]) continue;
            return i2;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(long[] array, long valueToFind) {
        void var1_1;
        return ArrayUtils.indexOf(array, (long)var1_1, 0);
    }

    public static int indexOf(long[] array, long valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        for (int i2 = ArrayUtils.max0(startIndex); i2 < array.length; ++i2) {
            if (valueToFind != array[i2]) continue;
            return i2;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(Object[] array, Object objectToFind) {
        void var1_1;
        return ArrayUtils.indexOf(array, var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(Object[] array, Object objectToFind, int startIndex) {
        void i2;
        if (array == null) {
            return -1;
        }
        startIndex = ArrayUtils.max0(startIndex);
        if (objectToFind == null) {
            while (i2 < array.length) {
                if (array[i2] == null) {
                    return (int)i2;
                }
                ++i2;
            }
        } else {
            while (i2 < array.length) {
                if (objectToFind.equals(array[i2])) {
                    return (int)i2;
                }
                ++i2;
            }
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int indexOf(short[] array, short valueToFind) {
        void var1_1;
        return ArrayUtils.indexOf(array, (short)var1_1, 0);
    }

    public static int indexOf(short[] array, short valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        for (int i2 = ArrayUtils.max0(startIndex); i2 < array.length; ++i2) {
            if (valueToFind != array[i2]) continue;
            return i2;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean[] insert(int index, boolean[] array, boolean ... values2) {
        void var3_3;
        if (array == null) {
            return null;
        }
        if (ArrayUtils.isEmpty(values2)) {
            return ArrayUtils.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        boolean[] result = new boolean[array.length + values2.length];
        System.arraycopy(values2, 0, result, index, values2.length);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if (index < array.length) {
            int n2;
            void var1_1;
            void var2_2;
            System.arraycopy(array, index, result, index + ((void)var2_2).length, ((void)var1_1).length - n2);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] insert(int index, byte[] array, byte ... values2) {
        void var3_3;
        if (array == null) {
            return null;
        }
        if (ArrayUtils.isEmpty(values2)) {
            return ArrayUtils.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        byte[] result = new byte[array.length + values2.length];
        System.arraycopy(values2, 0, result, index, values2.length);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if (index < array.length) {
            int n2;
            void var1_1;
            void var2_2;
            System.arraycopy(array, index, result, index + ((void)var2_2).length, ((void)var1_1).length - n2);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static char[] insert(int index, char[] array, char ... values2) {
        void var3_3;
        if (array == null) {
            return null;
        }
        if (ArrayUtils.isEmpty(values2)) {
            return ArrayUtils.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        char[] result = new char[array.length + values2.length];
        System.arraycopy(values2, 0, result, index, values2.length);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if (index < array.length) {
            int n2;
            void var1_1;
            void var2_2;
            System.arraycopy(array, index, result, index + ((void)var2_2).length, ((void)var1_1).length - n2);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static double[] insert(int index, double[] array, double ... values2) {
        void var3_3;
        if (array == null) {
            return null;
        }
        if (ArrayUtils.isEmpty(values2)) {
            return ArrayUtils.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        double[] result = new double[array.length + values2.length];
        System.arraycopy(values2, 0, result, index, values2.length);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if (index < array.length) {
            int n2;
            void var1_1;
            void var2_2;
            System.arraycopy(array, index, result, index + ((void)var2_2).length, ((void)var1_1).length - n2);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static float[] insert(int index, float[] array, float ... values2) {
        void var3_3;
        if (array == null) {
            return null;
        }
        if (ArrayUtils.isEmpty(values2)) {
            return ArrayUtils.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        float[] result = new float[array.length + values2.length];
        System.arraycopy(values2, 0, result, index, values2.length);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if (index < array.length) {
            int n2;
            void var1_1;
            void var2_2;
            System.arraycopy(array, index, result, index + ((void)var2_2).length, ((void)var1_1).length - n2);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static int[] insert(int index, int[] array, int ... values2) {
        void var3_3;
        if (array == null) {
            return null;
        }
        if (ArrayUtils.isEmpty(values2)) {
            return ArrayUtils.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        int[] result = new int[array.length + values2.length];
        System.arraycopy(values2, 0, result, index, values2.length);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if (index < array.length) {
            int n2;
            void var1_1;
            void var2_2;
            System.arraycopy(array, index, result, index + ((void)var2_2).length, ((void)var1_1).length - n2);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static long[] insert(int index, long[] array, long ... values2) {
        void var3_3;
        if (array == null) {
            return null;
        }
        if (ArrayUtils.isEmpty(values2)) {
            return ArrayUtils.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        long[] result = new long[array.length + values2.length];
        System.arraycopy(values2, 0, result, index, values2.length);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if (index < array.length) {
            int n2;
            void var1_1;
            void var2_2;
            System.arraycopy(array, index, result, index + ((void)var2_2).length, ((void)var1_1).length - n2);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static short[] insert(int index, short[] array, short ... values2) {
        void var3_3;
        if (array == null) {
            return null;
        }
        if (ArrayUtils.isEmpty(values2)) {
            return ArrayUtils.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        short[] result = new short[array.length + values2.length];
        System.arraycopy(values2, 0, result, index, values2.length);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if (index < array.length) {
            int n2;
            void var1_1;
            void var2_2;
            System.arraycopy(array, index, result, index + ((void)var2_2).length, ((void)var1_1).length - n2);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <T> T[] insert(int index, T[] array, T ... values2) {
        void var3_3;
        if (array == null) {
            return null;
        }
        if (ArrayUtils.isEmpty(values2)) {
            return ArrayUtils.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        Class<T> type = ArrayUtils.getComponentType(array);
        int length = array.length + values2.length;
        T[] result = ArrayUtils.newInstance(type, length);
        System.arraycopy(values2, 0, result, index, values2.length);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if (index < array.length) {
            int n2;
            void var1_1;
            void var2_2;
            System.arraycopy(array, index, result, index + ((void)var2_2).length, ((void)var1_1).length - n2);
        }
        return var3_3;
    }

    private static boolean isArrayEmpty(Object array) {
        return ArrayUtils.getLength(array) == 0;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> boolean isArrayIndexValid(T[] array, int index) {
        void var1_1;
        T[] TArray;
        return index >= 0 && ArrayUtils.getLength(TArray) > var1_1;
    }

    public static boolean isEmpty(boolean[] array) {
        return ArrayUtils.isArrayEmpty(array);
    }

    public static boolean isEmpty(byte[] array) {
        return ArrayUtils.isArrayEmpty(array);
    }

    public static boolean isEmpty(char[] array) {
        return ArrayUtils.isArrayEmpty(array);
    }

    public static boolean isEmpty(double[] array) {
        return ArrayUtils.isArrayEmpty(array);
    }

    public static boolean isEmpty(float[] array) {
        return ArrayUtils.isArrayEmpty(array);
    }

    public static boolean isEmpty(int[] array) {
        return ArrayUtils.isArrayEmpty(array);
    }

    public static boolean isEmpty(long[] array) {
        return ArrayUtils.isArrayEmpty(array);
    }

    public static boolean isEmpty(Object[] array) {
        return ArrayUtils.isArrayEmpty(array);
    }

    public static boolean isEmpty(short[] array) {
        return ArrayUtils.isArrayEmpty(array);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static boolean isEquals(Object array1, Object array2) {
        void var1_1;
        Object object;
        return new EqualsBuilder().append(object, var1_1).isEquals();
    }

    public static boolean isNotEmpty(boolean[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static boolean isNotEmpty(byte[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static boolean isNotEmpty(char[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static boolean isNotEmpty(double[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static boolean isNotEmpty(float[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static boolean isNotEmpty(int[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static boolean isNotEmpty(long[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static boolean isNotEmpty(short[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static <T> boolean isNotEmpty(T[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSameLength(boolean[] array1, boolean[] array2) {
        void var1_1;
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSameLength(byte[] array1, byte[] array2) {
        void var1_1;
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSameLength(char[] array1, char[] array2) {
        void var1_1;
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSameLength(double[] array1, double[] array2) {
        void var1_1;
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSameLength(float[] array1, float[] array2) {
        void var1_1;
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSameLength(int[] array1, int[] array2) {
        void var1_1;
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSameLength(long[] array1, long[] array2) {
        void var1_1;
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSameLength(Object array1, Object array2) {
        void var1_1;
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSameLength(Object[] array1, Object[] array2) {
        void var1_1;
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSameLength(short[] array1, short[] array2) {
        void var1_1;
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSameType(Object array1, Object array2) {
        void var1_1;
        Object object;
        if (array1 == null || array2 == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        return object.getClass().getName().equals(var1_1.getClass().getName());
    }

    public static boolean isSorted(boolean[] array) {
        if (ArrayUtils.getLength(array) < 2) {
            return true;
        }
        boolean previous = array[0];
        int n2 = array.length;
        for (int i2 = 1; i2 < n2; ++i2) {
            boolean current = array[i2];
            if (BooleanUtils.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    public static boolean isSorted(byte[] array) {
        if (ArrayUtils.getLength(array) < 2) {
            return true;
        }
        byte previous = array[0];
        int n2 = array.length;
        for (int i2 = 1; i2 < n2; ++i2) {
            byte current = array[i2];
            if (NumberUtils.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    public static boolean isSorted(char[] array) {
        if (ArrayUtils.getLength(array) < 2) {
            return true;
        }
        char previous = array[0];
        int n2 = array.length;
        for (int i2 = 1; i2 < n2; ++i2) {
            char current = array[i2];
            if (CharUtils.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    public static boolean isSorted(double[] array) {
        if (ArrayUtils.getLength(array) < 2) {
            return true;
        }
        double previous = array[0];
        int n2 = array.length;
        for (int i2 = 1; i2 < n2; ++i2) {
            double current = array[i2];
            if (Double.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    public static boolean isSorted(float[] array) {
        if (ArrayUtils.getLength(array) < 2) {
            return true;
        }
        float previous = array[0];
        int n2 = array.length;
        for (int i2 = 1; i2 < n2; ++i2) {
            float current = array[i2];
            if (Float.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    public static boolean isSorted(int[] array) {
        if (ArrayUtils.getLength(array) < 2) {
            return true;
        }
        int previous = array[0];
        int n2 = array.length;
        for (int i2 = 1; i2 < n2; ++i2) {
            int current = array[i2];
            if (NumberUtils.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    public static boolean isSorted(long[] array) {
        if (ArrayUtils.getLength(array) < 2) {
            return true;
        }
        long previous = array[0];
        int n2 = array.length;
        for (int i2 = 1; i2 < n2; ++i2) {
            long current = array[i2];
            if (NumberUtils.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    public static boolean isSorted(short[] array) {
        if (ArrayUtils.getLength(array) < 2) {
            return true;
        }
        short previous = array[0];
        int n2 = array.length;
        for (int i2 = 1; i2 < n2; ++i2) {
            short current = array[i2];
            if (NumberUtils.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    public static <T extends Comparable<? super T>> boolean isSorted(T[] array) {
        return ArrayUtils.isSorted(array, Comparable::compareTo);
    }

    public static <T> boolean isSorted(T[] array, Comparator<T> comparator) {
        Objects.requireNonNull(comparator, "comparator");
        if (ArrayUtils.getLength(array) < 2) {
            return true;
        }
        T previous = array[0];
        int n2 = array.length;
        for (int i2 = 1; i2 < n2; ++i2) {
            T current = array[i2];
            if (comparator.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(boolean[] array, boolean valueToFind) {
        void var1_1;
        return ArrayUtils.lastIndexOf(array, (boolean)var1_1, Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(boolean[] array, boolean valueToFind, int startIndex) {
        void i2;
        if (ArrayUtils.isEmpty(array) || startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        while (i2 >= 0) {
            if (valueToFind == array[i2]) {
                return (int)i2;
            }
            --i2;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(byte[] array, byte valueToFind) {
        void var1_1;
        return ArrayUtils.lastIndexOf(array, (byte)var1_1, Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(byte[] array, byte valueToFind, int startIndex) {
        void i2;
        if (array == null || startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        while (i2 >= 0) {
            if (valueToFind == array[i2]) {
                return (int)i2;
            }
            --i2;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(char[] array, char valueToFind) {
        void var1_1;
        return ArrayUtils.lastIndexOf(array, (char)var1_1, Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(char[] array, char valueToFind, int startIndex) {
        void i2;
        if (array == null || startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        while (i2 >= 0) {
            if (valueToFind == array[i2]) {
                return (int)i2;
            }
            --i2;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(double[] array, double valueToFind) {
        void var1_1;
        return ArrayUtils.lastIndexOf(array, (double)var1_1, Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(double[] array, double valueToFind, double tolerance) {
        void var3_2;
        void var1_1;
        return ArrayUtils.lastIndexOf(array, (double)var1_1, Integer.MAX_VALUE, (double)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(double[] array, double valueToFind, int startIndex) {
        void i2;
        if (ArrayUtils.isEmpty(array) || startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        while (i2 >= 0) {
            if (valueToFind == array[i2]) {
                return (int)i2;
            }
            --i2;
        }
        return -1;
    }

    public static int lastIndexOf(double[] array, double valueToFind, int startIndex, double tolerance) {
        if (ArrayUtils.isEmpty(array) || startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        double min = valueToFind - tolerance;
        double max = valueToFind + tolerance;
        for (void i2 = var3_3; i2 >= 0; --i2) {
            if (!(array[i2] >= min) || !(array[i2] <= max)) continue;
            return (int)i2;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(float[] array, float valueToFind) {
        void var1_1;
        return ArrayUtils.lastIndexOf(array, (float)var1_1, Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(float[] array, float valueToFind, int startIndex) {
        void i2;
        if (ArrayUtils.isEmpty(array) || startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        while (i2 >= 0) {
            if (valueToFind == array[i2]) {
                return (int)i2;
            }
            --i2;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(int[] array, int valueToFind) {
        void var1_1;
        return ArrayUtils.lastIndexOf(array, (int)var1_1, Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(int[] array, int valueToFind, int startIndex) {
        void i2;
        if (array == null || startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        while (i2 >= 0) {
            if (valueToFind == array[i2]) {
                return (int)i2;
            }
            --i2;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(long[] array, long valueToFind) {
        void var1_1;
        return ArrayUtils.lastIndexOf(array, (long)var1_1, Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(long[] array, long valueToFind, int startIndex) {
        void i2;
        if (array == null || startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        while (i2 >= 0) {
            if (valueToFind == array[i2]) {
                return (int)i2;
            }
            --i2;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(Object[] array, Object objectToFind) {
        void var1_1;
        return ArrayUtils.lastIndexOf(array, var1_1, Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(Object[] array, Object objectToFind, int startIndex) {
        block7: {
            void i2;
            block6: {
                if (array == null || startIndex < 0) {
                    return -1;
                }
                if (startIndex >= array.length) {
                    startIndex = array.length - 1;
                }
                if (objectToFind != null) break block6;
                while (i2 >= 0) {
                    if (array[i2] == null) {
                        return (int)i2;
                    }
                    --i2;
                }
                break block7;
            }
            if (!array.getClass().getComponentType().isInstance(objectToFind)) break block7;
            while (i2 >= 0) {
                if (objectToFind.equals(array[i2])) {
                    return (int)i2;
                }
                --i2;
            }
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(short[] array, short valueToFind) {
        void var1_1;
        return ArrayUtils.lastIndexOf(array, (short)var1_1, Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexOf(short[] array, short valueToFind, int startIndex) {
        void i2;
        if (array == null || startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        while (i2 >= 0) {
            if (valueToFind == array[i2]) {
                return (int)i2;
            }
            --i2;
        }
        return -1;
    }

    private static int max0(int other) {
        int n2;
        return Math.max(0, n2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] newInstance(Class<T> componentType, int length) {
        void var1_1;
        return (Object[])Array.newInstance(componentType, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] nullTo(T[] array, T[] defaultArray) {
        T[] TArray;
        if (ArrayUtils.isEmpty(array)) {
            void var1_1;
            return var1_1;
        }
        return TArray;
    }

    public static boolean[] nullToEmpty(boolean[] array) {
        boolean[] blArray;
        if (ArrayUtils.isEmpty(array)) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        return blArray;
    }

    public static Boolean[] nullToEmpty(Boolean[] array) {
        return ArrayUtils.nullTo(array, EMPTY_BOOLEAN_OBJECT_ARRAY);
    }

    public static byte[] nullToEmpty(byte[] array) {
        byte[] byArray;
        if (ArrayUtils.isEmpty(array)) {
            return EMPTY_BYTE_ARRAY;
        }
        return byArray;
    }

    public static Byte[] nullToEmpty(Byte[] array) {
        return ArrayUtils.nullTo(array, EMPTY_BYTE_OBJECT_ARRAY);
    }

    public static char[] nullToEmpty(char[] array) {
        char[] cArray;
        if (ArrayUtils.isEmpty(array)) {
            return EMPTY_CHAR_ARRAY;
        }
        return cArray;
    }

    public static Character[] nullToEmpty(Character[] array) {
        return ArrayUtils.nullTo(array, EMPTY_CHARACTER_OBJECT_ARRAY);
    }

    public static Class<?>[] nullToEmpty(Class<?>[] array) {
        return ArrayUtils.nullTo(array, EMPTY_CLASS_ARRAY);
    }

    public static double[] nullToEmpty(double[] array) {
        double[] dArray;
        if (ArrayUtils.isEmpty(array)) {
            return EMPTY_DOUBLE_ARRAY;
        }
        return dArray;
    }

    public static Double[] nullToEmpty(Double[] array) {
        return ArrayUtils.nullTo(array, EMPTY_DOUBLE_OBJECT_ARRAY);
    }

    public static float[] nullToEmpty(float[] array) {
        float[] fArray;
        if (ArrayUtils.isEmpty(array)) {
            return EMPTY_FLOAT_ARRAY;
        }
        return fArray;
    }

    public static Float[] nullToEmpty(Float[] array) {
        return ArrayUtils.nullTo(array, EMPTY_FLOAT_OBJECT_ARRAY);
    }

    public static int[] nullToEmpty(int[] array) {
        int[] nArray;
        if (ArrayUtils.isEmpty(array)) {
            return EMPTY_INT_ARRAY;
        }
        return nArray;
    }

    public static Integer[] nullToEmpty(Integer[] array) {
        return ArrayUtils.nullTo(array, EMPTY_INTEGER_OBJECT_ARRAY);
    }

    public static long[] nullToEmpty(long[] array) {
        long[] lArray;
        if (ArrayUtils.isEmpty(array)) {
            return EMPTY_LONG_ARRAY;
        }
        return lArray;
    }

    public static Long[] nullToEmpty(Long[] array) {
        return ArrayUtils.nullTo(array, EMPTY_LONG_OBJECT_ARRAY);
    }

    public static Object[] nullToEmpty(Object[] array) {
        return ArrayUtils.nullTo(array, EMPTY_OBJECT_ARRAY);
    }

    public static short[] nullToEmpty(short[] array) {
        short[] sArray;
        if (ArrayUtils.isEmpty(array)) {
            return EMPTY_SHORT_ARRAY;
        }
        return sArray;
    }

    public static Short[] nullToEmpty(Short[] array) {
        return ArrayUtils.nullTo(array, EMPTY_SHORT_OBJECT_ARRAY);
    }

    public static String[] nullToEmpty(String[] array) {
        return ArrayUtils.nullTo(array, EMPTY_STRING_ARRAY);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] nullToEmpty(T[] array, Class<T[]> type) {
        T[] TArray;
        if (type == null) {
            throw new IllegalArgumentException("The type must not be null");
        }
        if (array == null) {
            void var1_1;
            void v0 = var1_1;
            return (Object[])v0.cast(Array.newInstance(v0.getComponentType(), 0));
        }
        return TArray;
    }

    private static ThreadLocalRandom random() {
        return ThreadLocalRandom.current();
    }

    /*
     * WARNING - void declaration
     */
    public static boolean[] remove(boolean[] array, int index) {
        void var1_1;
        return (boolean[])ArrayUtils.remove((Object)array, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] remove(byte[] array, int index) {
        void var1_1;
        return (byte[])ArrayUtils.remove((Object)array, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static char[] remove(char[] array, int index) {
        void var1_1;
        return (char[])ArrayUtils.remove((Object)array, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static double[] remove(double[] array, int index) {
        void var1_1;
        return (double[])ArrayUtils.remove((Object)array, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static float[] remove(float[] array, int index) {
        void var1_1;
        return (float[])ArrayUtils.remove((Object)array, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int[] remove(int[] array, int index) {
        void var1_1;
        return (int[])ArrayUtils.remove((Object)array, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static long[] remove(long[] array, int index) {
        void var1_1;
        return (long[])ArrayUtils.remove((Object)array, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static Object remove(Object array, int index) {
        void var3_3;
        int length = ArrayUtils.getLength(array);
        if (index < 0 || index >= length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + length);
        }
        Object result = Array.newInstance(array.getClass().getComponentType(), length - 1);
        System.arraycopy(array, 0, result, 0, index);
        if (index < length - 1) {
            void var1_1;
            void var2_2;
            Object object;
            System.arraycopy(object, index + 1, result, index, (int)(var2_2 - var1_1 - true));
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static short[] remove(short[] array, int index) {
        void var1_1;
        return (short[])ArrayUtils.remove((Object)array, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] remove(T[] array, int index) {
        void var1_1;
        return (Object[])ArrayUtils.remove(array, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean[] removeAll(boolean[] array, int ... indices) {
        void var1_1;
        return (boolean[])ArrayUtils.removeAll((Object)array, (int[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] removeAll(byte[] array, int ... indices) {
        void var1_1;
        return (byte[])ArrayUtils.removeAll((Object)array, (int[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static char[] removeAll(char[] array, int ... indices) {
        void var1_1;
        return (char[])ArrayUtils.removeAll((Object)array, (int[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static double[] removeAll(double[] array, int ... indices) {
        void var1_1;
        return (double[])ArrayUtils.removeAll((Object)array, (int[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static float[] removeAll(float[] array, int ... indices) {
        void var1_1;
        return (float[])ArrayUtils.removeAll((Object)array, (int[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int[] removeAll(int[] array, int ... indices) {
        void var1_1;
        return (int[])ArrayUtils.removeAll((Object)array, (int[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static long[] removeAll(long[] array, int ... indices) {
        void var1_1;
        return (long[])ArrayUtils.removeAll((Object)array, (int[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static Object removeAll(Object array, BitSet indices) {
        void var3_4;
        void var2_2;
        int count;
        int set;
        if (array == null) {
            return null;
        }
        int srcLength = ArrayUtils.getLength(array);
        int removals = indices.cardinality();
        Object result = Array.newInstance(array.getClass().getComponentType(), srcLength - removals);
        int srcIndex = 0;
        int destIndex = 0;
        while ((set = indices.nextSetBit(srcIndex)) != -1) {
            count = set - srcIndex;
            if (count > 0) {
                System.arraycopy(array, srcIndex, result, destIndex, count);
                destIndex += count;
            }
            srcIndex = indices.nextClearBit(set);
        }
        count = var2_2 - srcIndex;
        if (count > 0) {
            Object object;
            System.arraycopy(object, srcIndex, result, destIndex, count);
        }
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    static Object removeAll(Object array, int ... indices) {
        if (array == null) {
            return null;
        }
        int length = ArrayUtils.getLength(array);
        int diff = 0;
        int[] clonedIndices = ArraySorter.sort(ArrayUtils.clone(indices));
        if (ArrayUtils.isNotEmpty(clonedIndices)) {
            int i2 = clonedIndices.length;
            int prevIndex = length;
            while (--i2 >= 0) {
                int index = clonedIndices[i2];
                if (index < 0 || index >= length) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + length);
                }
                if (index >= prevIndex) continue;
                ++diff;
                prevIndex = index;
            }
        }
        Object result = Array.newInstance(array.getClass().getComponentType(), length - diff);
        if (diff < length && clonedIndices != null) {
            void var5_6;
            int end = length;
            int dest = length - diff;
            for (int i3 = clonedIndices.length - 1; i3 >= 0; --i3) {
                void var3_3;
                int index = clonedIndices[i3];
                if (end - index > 1) {
                    int cp = end - index - 1;
                    System.arraycopy(array, index + 1, result, dest -= cp, cp);
                }
                var5_6 = var3_3;
            }
            if (var5_6 > 0) {
                Object object;
                System.arraycopy(object, 0, result, 0, (int)var5_6);
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static short[] removeAll(short[] array, int ... indices) {
        void var1_1;
        return (short[])ArrayUtils.removeAll((Object)array, (int[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] removeAll(T[] array, int ... indices) {
        void var1_1;
        return (Object[])ArrayUtils.removeAll(array, (int[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static boolean[] removeAllOccurences(boolean[] array, boolean element) {
        void var1_1;
        return (boolean[])ArrayUtils.removeAll((Object)array, ArrayUtils.indexesOf(array, (boolean)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static byte[] removeAllOccurences(byte[] array, byte element) {
        void var1_1;
        return (byte[])ArrayUtils.removeAll((Object)array, ArrayUtils.indexesOf(array, (byte)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static char[] removeAllOccurences(char[] array, char element) {
        void var1_1;
        return (char[])ArrayUtils.removeAll((Object)array, ArrayUtils.indexesOf(array, (char)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static double[] removeAllOccurences(double[] array, double element) {
        void var1_1;
        return (double[])ArrayUtils.removeAll((Object)array, ArrayUtils.indexesOf(array, (double)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static float[] removeAllOccurences(float[] array, float element) {
        void var1_1;
        return (float[])ArrayUtils.removeAll((Object)array, ArrayUtils.indexesOf(array, (float)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static int[] removeAllOccurences(int[] array, int element) {
        void var1_1;
        return (int[])ArrayUtils.removeAll((Object)array, ArrayUtils.indexesOf(array, (int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static long[] removeAllOccurences(long[] array, long element) {
        void var1_1;
        return (long[])ArrayUtils.removeAll((Object)array, ArrayUtils.indexesOf(array, (long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static short[] removeAllOccurences(short[] array, short element) {
        void var1_1;
        return (short[])ArrayUtils.removeAll((Object)array, ArrayUtils.indexesOf(array, (short)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static <T> T[] removeAllOccurences(T[] array, T element) {
        void var1_1;
        return (Object[])ArrayUtils.removeAll((Object)array, ArrayUtils.indexesOf(array, var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static boolean[] removeAllOccurrences(boolean[] array, boolean element) {
        void var1_1;
        return (boolean[])ArrayUtils.removeAll((Object)array, ArrayUtils.indexesOf(array, (boolean)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] removeAllOccurrences(byte[] array, byte element) {
        void var1_1;
        return (byte[])ArrayUtils.removeAll((Object)array, ArrayUtils.indexesOf(array, (byte)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static char[] removeAllOccurrences(char[] array, char element) {
        void var1_1;
        return (char[])ArrayUtils.removeAll((Object)array, ArrayUtils.indexesOf(array, (char)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static double[] removeAllOccurrences(double[] array, double element) {
        void var1_1;
        return (double[])ArrayUtils.removeAll((Object)array, ArrayUtils.indexesOf(array, (double)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static float[] removeAllOccurrences(float[] array, float element) {
        void var1_1;
        return (float[])ArrayUtils.removeAll((Object)array, ArrayUtils.indexesOf(array, (float)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static int[] removeAllOccurrences(int[] array, int element) {
        void var1_1;
        return (int[])ArrayUtils.removeAll((Object)array, ArrayUtils.indexesOf(array, (int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static long[] removeAllOccurrences(long[] array, long element) {
        void var1_1;
        return (long[])ArrayUtils.removeAll((Object)array, ArrayUtils.indexesOf(array, (long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static short[] removeAllOccurrences(short[] array, short element) {
        void var1_1;
        return (short[])ArrayUtils.removeAll((Object)array, ArrayUtils.indexesOf(array, (short)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] removeAllOccurrences(T[] array, T element) {
        void var1_1;
        return (Object[])ArrayUtils.removeAll((Object)array, ArrayUtils.indexesOf(array, var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static boolean[] removeElement(boolean[] array, boolean element) {
        void var1_1;
        boolean[] blArray;
        int index = ArrayUtils.indexOf(array, element);
        if (index == -1) {
            return ArrayUtils.clone(array);
        }
        return ArrayUtils.remove(blArray, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] removeElement(byte[] array, byte element) {
        void var1_1;
        byte[] byArray;
        int index = ArrayUtils.indexOf(array, element);
        if (index == -1) {
            return ArrayUtils.clone(array);
        }
        return ArrayUtils.remove(byArray, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static char[] removeElement(char[] array, char element) {
        void var1_1;
        char[] cArray;
        int index = ArrayUtils.indexOf(array, element);
        if (index == -1) {
            return ArrayUtils.clone(array);
        }
        return ArrayUtils.remove(cArray, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static double[] removeElement(double[] array, double element) {
        void var1_2;
        double[] dArray;
        int index = ArrayUtils.indexOf(array, element);
        if (index == -1) {
            return ArrayUtils.clone(array);
        }
        return ArrayUtils.remove(dArray, (int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public static float[] removeElement(float[] array, float element) {
        void var1_2;
        float[] fArray;
        int index = ArrayUtils.indexOf(array, element);
        if (index == -1) {
            return ArrayUtils.clone(array);
        }
        return ArrayUtils.remove(fArray, (int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public static int[] removeElement(int[] array, int element) {
        void var1_1;
        int[] nArray;
        int index = ArrayUtils.indexOf(array, element);
        if (index == -1) {
            return ArrayUtils.clone(array);
        }
        return ArrayUtils.remove(nArray, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static long[] removeElement(long[] array, long element) {
        void var1_2;
        long[] lArray;
        int index = ArrayUtils.indexOf(array, element);
        if (index == -1) {
            return ArrayUtils.clone(array);
        }
        return ArrayUtils.remove(lArray, (int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public static short[] removeElement(short[] array, short element) {
        void var1_1;
        short[] sArray;
        int index = ArrayUtils.indexOf(array, element);
        if (index == -1) {
            return ArrayUtils.clone(array);
        }
        return ArrayUtils.remove(sArray, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] removeElement(T[] array, Object element) {
        void var1_2;
        T[] TArray;
        int index = ArrayUtils.indexOf(array, element);
        if (index == -1) {
            return ArrayUtils.clone(array);
        }
        return ArrayUtils.remove(TArray, (int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean[] removeElements(boolean[] array, boolean ... values2) {
        void var1_1;
        boolean[] blArray;
        if (ArrayUtils.isEmpty(array) || ArrayUtils.isEmpty(values2)) {
            return ArrayUtils.clone(array);
        }
        HashMap<Boolean, MutableInt> occurrences = new HashMap<Boolean, MutableInt>(2);
        for (boolean bl : values2) {
            Boolean boxed = bl;
            MutableInt count = (MutableInt)occurrences.get(boxed);
            if (count == null) {
                occurrences.put(boxed, new MutableInt(1));
                continue;
            }
            count.increment();
        }
        BitSet toRemove = new BitSet();
        for (int i2 = 0; i2 < array.length; ++i2) {
            boolean key = array[i2];
            MutableInt count = (MutableInt)occurrences.get(key);
            if (count == null) continue;
            if (count.decrementAndGet() == 0) {
                occurrences.remove(key);
            }
            toRemove.set(i2);
        }
        return (boolean[])ArrayUtils.removeAll((Object)blArray, (BitSet)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] removeElements(byte[] array, byte ... values2) {
        void var1_1;
        byte[] byArray;
        if (ArrayUtils.isEmpty(array) || ArrayUtils.isEmpty(values2)) {
            return ArrayUtils.clone(array);
        }
        HashMap<Byte, MutableInt> occurrences = new HashMap<Byte, MutableInt>(values2.length);
        for (byte by : values2) {
            Byte boxed = by;
            MutableInt count = (MutableInt)occurrences.get(boxed);
            if (count == null) {
                occurrences.put(boxed, new MutableInt(1));
                continue;
            }
            count.increment();
        }
        BitSet toRemove = new BitSet();
        for (int i2 = 0; i2 < array.length; ++i2) {
            byte key = array[i2];
            MutableInt count = (MutableInt)occurrences.get(key);
            if (count == null) continue;
            if (count.decrementAndGet() == 0) {
                occurrences.remove(key);
            }
            toRemove.set(i2);
        }
        return (byte[])ArrayUtils.removeAll((Object)byArray, (BitSet)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static char[] removeElements(char[] array, char ... values2) {
        void var1_1;
        char[] cArray;
        if (ArrayUtils.isEmpty(array) || ArrayUtils.isEmpty(values2)) {
            return ArrayUtils.clone(array);
        }
        HashMap<Character, MutableInt> occurrences = new HashMap<Character, MutableInt>(values2.length);
        for (char c2 : values2) {
            Character boxed = Character.valueOf(c2);
            MutableInt count = (MutableInt)occurrences.get(boxed);
            if (count == null) {
                occurrences.put(boxed, new MutableInt(1));
                continue;
            }
            count.increment();
        }
        BitSet toRemove = new BitSet();
        for (int i2 = 0; i2 < array.length; ++i2) {
            char key = array[i2];
            MutableInt count = (MutableInt)occurrences.get(Character.valueOf(key));
            if (count == null) continue;
            if (count.decrementAndGet() == 0) {
                occurrences.remove(Character.valueOf(key));
            }
            toRemove.set(i2);
        }
        return (char[])ArrayUtils.removeAll((Object)cArray, (BitSet)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static double[] removeElements(double[] array, double ... values2) {
        void var1_1;
        double[] dArray;
        if (ArrayUtils.isEmpty(array) || ArrayUtils.isEmpty(values2)) {
            return ArrayUtils.clone(array);
        }
        HashMap<Double, MutableInt> occurrences = new HashMap<Double, MutableInt>(values2.length);
        for (double d2 : values2) {
            Double boxed = d2;
            MutableInt count = (MutableInt)occurrences.get(boxed);
            if (count == null) {
                occurrences.put(boxed, new MutableInt(1));
                continue;
            }
            count.increment();
        }
        BitSet toRemove = new BitSet();
        for (int i2 = 0; i2 < array.length; ++i2) {
            double key = array[i2];
            MutableInt count = (MutableInt)occurrences.get(key);
            if (count == null) continue;
            if (count.decrementAndGet() == 0) {
                occurrences.remove(key);
            }
            toRemove.set(i2);
        }
        return (double[])ArrayUtils.removeAll((Object)dArray, (BitSet)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static float[] removeElements(float[] array, float ... values2) {
        void var1_1;
        float[] fArray;
        if (ArrayUtils.isEmpty(array) || ArrayUtils.isEmpty(values2)) {
            return ArrayUtils.clone(array);
        }
        HashMap<Float, MutableInt> occurrences = new HashMap<Float, MutableInt>(values2.length);
        for (float f2 : values2) {
            Float boxed = Float.valueOf(f2);
            MutableInt count = (MutableInt)occurrences.get(boxed);
            if (count == null) {
                occurrences.put(boxed, new MutableInt(1));
                continue;
            }
            count.increment();
        }
        BitSet toRemove = new BitSet();
        for (int i2 = 0; i2 < array.length; ++i2) {
            float key = array[i2];
            MutableInt count = (MutableInt)occurrences.get(Float.valueOf(key));
            if (count == null) continue;
            if (count.decrementAndGet() == 0) {
                occurrences.remove(Float.valueOf(key));
            }
            toRemove.set(i2);
        }
        return (float[])ArrayUtils.removeAll((Object)fArray, (BitSet)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int[] removeElements(int[] array, int ... values2) {
        void var1_1;
        int[] nArray;
        if (ArrayUtils.isEmpty(array) || ArrayUtils.isEmpty(values2)) {
            return ArrayUtils.clone(array);
        }
        HashMap<Integer, MutableInt> occurrences = new HashMap<Integer, MutableInt>(values2.length);
        for (int n2 : values2) {
            Integer boxed = n2;
            MutableInt count = (MutableInt)occurrences.get(boxed);
            if (count == null) {
                occurrences.put(boxed, new MutableInt(1));
                continue;
            }
            count.increment();
        }
        BitSet toRemove = new BitSet();
        for (int i2 = 0; i2 < array.length; ++i2) {
            int key = array[i2];
            MutableInt count = (MutableInt)occurrences.get(key);
            if (count == null) continue;
            if (count.decrementAndGet() == 0) {
                occurrences.remove(key);
            }
            toRemove.set(i2);
        }
        return (int[])ArrayUtils.removeAll((Object)nArray, (BitSet)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static long[] removeElements(long[] array, long ... values2) {
        void var1_1;
        long[] lArray;
        if (ArrayUtils.isEmpty(array) || ArrayUtils.isEmpty(values2)) {
            return ArrayUtils.clone(array);
        }
        HashMap<Long, MutableInt> occurrences = new HashMap<Long, MutableInt>(values2.length);
        for (long l2 : values2) {
            Long boxed = l2;
            MutableInt count = (MutableInt)occurrences.get(boxed);
            if (count == null) {
                occurrences.put(boxed, new MutableInt(1));
                continue;
            }
            count.increment();
        }
        BitSet toRemove = new BitSet();
        for (int i2 = 0; i2 < array.length; ++i2) {
            long key = array[i2];
            MutableInt count = (MutableInt)occurrences.get(key);
            if (count == null) continue;
            if (count.decrementAndGet() == 0) {
                occurrences.remove(key);
            }
            toRemove.set(i2);
        }
        return (long[])ArrayUtils.removeAll((Object)lArray, (BitSet)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static short[] removeElements(short[] array, short ... values2) {
        void var1_1;
        short[] sArray;
        if (ArrayUtils.isEmpty(array) || ArrayUtils.isEmpty(values2)) {
            return ArrayUtils.clone(array);
        }
        HashMap<Short, MutableInt> occurrences = new HashMap<Short, MutableInt>(values2.length);
        for (short s2 : values2) {
            Short boxed = s2;
            MutableInt count = (MutableInt)occurrences.get(boxed);
            if (count == null) {
                occurrences.put(boxed, new MutableInt(1));
                continue;
            }
            count.increment();
        }
        BitSet toRemove = new BitSet();
        for (int i2 = 0; i2 < array.length; ++i2) {
            short key = array[i2];
            MutableInt count = (MutableInt)occurrences.get(key);
            if (count == null) continue;
            if (count.decrementAndGet() == 0) {
                occurrences.remove(key);
            }
            toRemove.set(i2);
        }
        return (short[])ArrayUtils.removeAll((Object)sArray, (BitSet)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <T> T[] removeElements(T[] array, T ... values2) {
        void var1_1;
        T[] TArray;
        if (ArrayUtils.isEmpty(array) || ArrayUtils.isEmpty(values2)) {
            return ArrayUtils.clone(array);
        }
        HashMap<T, MutableInt> occurrences = new HashMap<T, MutableInt>(values2.length);
        for (T v2 : values2) {
            MutableInt count = (MutableInt)occurrences.get(v2);
            if (count == null) {
                occurrences.put(v2, new MutableInt(1));
                continue;
            }
            count.increment();
        }
        BitSet toRemove = new BitSet();
        for (int i2 = 0; i2 < array.length; ++i2) {
            T key = array[i2];
            MutableInt count = (MutableInt)occurrences.get(key);
            if (count == null) continue;
            if (count.decrementAndGet() == 0) {
                occurrences.remove(key);
            }
            toRemove.set(i2);
        }
        Object[] objectArray = (Object[])ArrayUtils.removeAll(TArray, (BitSet)var1_1);
        return objectArray;
    }

    public static void reverse(boolean[] array) {
        boolean[] blArray;
        if (array == null) {
            return;
        }
        ArrayUtils.reverse(array, 0, blArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static void reverse(boolean[] array, int startIndexInclusive, int endIndexExclusive) {
        if (array == null) {
            return;
        }
        int i2 = Math.max(startIndexInclusive, 0);
        for (int j2 = Math.min(array.length, endIndexExclusive) - 1; j2 > i2; --j2, ++i2) {
            void var3_3;
            boolean tmp = array[j2];
            array[j2] = array[i2];
            array[i2] = var3_3;
        }
    }

    public static void reverse(byte[] array) {
        if (array != null) {
            byte[] byArray;
            ArrayUtils.reverse(array, 0, byArray.length);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void reverse(byte[] array, int startIndexInclusive, int endIndexExclusive) {
        if (array == null) {
            return;
        }
        int i2 = Math.max(startIndexInclusive, 0);
        for (int j2 = Math.min(array.length, endIndexExclusive) - 1; j2 > i2; --j2, ++i2) {
            void var3_3;
            byte tmp = array[j2];
            array[j2] = array[i2];
            array[i2] = var3_3;
        }
    }

    public static void reverse(char[] array) {
        if (array != null) {
            char[] cArray;
            ArrayUtils.reverse(array, 0, cArray.length);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void reverse(char[] array, int startIndexInclusive, int endIndexExclusive) {
        if (array == null) {
            return;
        }
        int i2 = Math.max(startIndexInclusive, 0);
        for (int j2 = Math.min(array.length, endIndexExclusive) - 1; j2 > i2; --j2, ++i2) {
            void var3_3;
            char tmp = array[j2];
            array[j2] = array[i2];
            array[i2] = var3_3;
        }
    }

    public static void reverse(double[] array) {
        if (array != null) {
            double[] dArray;
            ArrayUtils.reverse(array, 0, dArray.length);
        }
    }

    public static void reverse(double[] array, int startIndexInclusive, int endIndexExclusive) {
        if (array == null) {
            return;
        }
        int i2 = Math.max(startIndexInclusive, 0);
        for (int j2 = Math.min(array.length, endIndexExclusive) - 1; j2 > i2; --j2, ++i2) {
            double tmp = array[j2];
            array[j2] = array[i2];
            array[i2] = tmp;
        }
    }

    public static void reverse(float[] array) {
        if (array != null) {
            float[] fArray;
            ArrayUtils.reverse(array, 0, fArray.length);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void reverse(float[] array, int startIndexInclusive, int endIndexExclusive) {
        if (array == null) {
            return;
        }
        int i2 = Math.max(startIndexInclusive, 0);
        for (int j2 = Math.min(array.length, endIndexExclusive) - 1; j2 > i2; --j2, ++i2) {
            void var3_3;
            float tmp = array[j2];
            array[j2] = array[i2];
            array[i2] = var3_3;
        }
    }

    public static void reverse(int[] array) {
        if (array != null) {
            int[] nArray;
            ArrayUtils.reverse(array, 0, nArray.length);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void reverse(int[] array, int startIndexInclusive, int endIndexExclusive) {
        if (array == null) {
            return;
        }
        int i2 = Math.max(startIndexInclusive, 0);
        for (int j2 = Math.min(array.length, endIndexExclusive) - 1; j2 > i2; --j2, ++i2) {
            void var3_3;
            int tmp = array[j2];
            array[j2] = array[i2];
            array[i2] = var3_3;
        }
    }

    public static void reverse(long[] array) {
        if (array != null) {
            long[] lArray;
            ArrayUtils.reverse(array, 0, lArray.length);
        }
    }

    public static void reverse(long[] array, int startIndexInclusive, int endIndexExclusive) {
        if (array == null) {
            return;
        }
        int i2 = Math.max(startIndexInclusive, 0);
        for (int j2 = Math.min(array.length, endIndexExclusive) - 1; j2 > i2; --j2, ++i2) {
            long tmp = array[j2];
            array[j2] = array[i2];
            array[i2] = tmp;
        }
    }

    public static void reverse(Object[] array) {
        if (array != null) {
            Object[] objectArray;
            ArrayUtils.reverse(array, 0, objectArray.length);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void reverse(Object[] array, int startIndexInclusive, int endIndexExclusive) {
        if (array == null) {
            return;
        }
        int i2 = Math.max(startIndexInclusive, 0);
        for (int j2 = Math.min(array.length, endIndexExclusive) - 1; j2 > i2; --j2, ++i2) {
            void var3_3;
            Object tmp = array[j2];
            array[j2] = array[i2];
            array[i2] = var3_3;
        }
    }

    public static void reverse(short[] array) {
        if (array != null) {
            short[] sArray;
            ArrayUtils.reverse(array, 0, sArray.length);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void reverse(short[] array, int startIndexInclusive, int endIndexExclusive) {
        if (array == null) {
            return;
        }
        int i2 = Math.max(startIndexInclusive, 0);
        for (int j2 = Math.min(array.length, endIndexExclusive) - 1; j2 > i2; --j2, ++i2) {
            void var3_3;
            short tmp = array[j2];
            array[j2] = array[i2];
            array[i2] = var3_3;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] setAll(T[] array, IntFunction<? extends T> generator) {
        T[] TArray;
        if (array != null && generator != null) {
            void var1_1;
            Arrays.setAll(array, var1_1);
        }
        return TArray;
    }

    public static <T> T[] setAll(T[] array, Supplier<? extends T> generator) {
        T[] TArray;
        if (array != null && generator != null) {
            for (int i2 = 0; i2 < array.length; ++i2) {
                array[i2] = generator.get();
            }
        }
        return TArray;
    }

    /*
     * WARNING - void declaration
     */
    public static void shift(boolean[] array, int offset) {
        if (array != null) {
            void var1_1;
            boolean[] blArray;
            ArrayUtils.shift(array, 0, blArray.length, (int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void shift(boolean[] array, int startIndexInclusive, int endIndexExclusive, int offset) {
        if (array == null || startIndexInclusive >= array.length - 1 || endIndexExclusive <= 0) {
            return;
        }
        startIndexInclusive = ArrayUtils.max0(startIndexInclusive);
        int n2 = (endIndexExclusive = Math.min(endIndexExclusive, array.length)) - startIndexInclusive;
        if (n2 <= 1) {
            return;
        }
        if ((offset %= n2) < 0) {
            offset += n2;
        }
        while (n2 > 1 && offset > 0) {
            void var3_3;
            boolean[] blArray;
            void var1_1;
            int nOffset = n2 - offset;
            if (offset > nOffset) {
                int n3 = startIndexInclusive;
                ArrayUtils.swap(array, n3, n3 + n2 - nOffset, nOffset);
                n2 = offset;
                offset -= nOffset;
                continue;
            }
            if (offset < nOffset) {
                int n4 = startIndexInclusive;
                ArrayUtils.swap(array, n4, n4 + nOffset, offset);
                startIndexInclusive += offset;
                n2 = nOffset;
                continue;
            }
            void v2 = var1_1;
            ArrayUtils.swap(blArray, (int)v2, (int)(v2 + nOffset), (int)var3_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void shift(byte[] array, int offset) {
        if (array != null) {
            void var1_1;
            byte[] byArray;
            ArrayUtils.shift(array, 0, byArray.length, (int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void shift(byte[] array, int startIndexInclusive, int endIndexExclusive, int offset) {
        if (array == null || startIndexInclusive >= array.length - 1 || endIndexExclusive <= 0) {
            return;
        }
        startIndexInclusive = ArrayUtils.max0(startIndexInclusive);
        int n2 = (endIndexExclusive = Math.min(endIndexExclusive, array.length)) - startIndexInclusive;
        if (n2 <= 1) {
            return;
        }
        if ((offset %= n2) < 0) {
            offset += n2;
        }
        while (n2 > 1 && offset > 0) {
            void var3_3;
            byte[] byArray;
            void var1_1;
            int nOffset = n2 - offset;
            if (offset > nOffset) {
                int n3 = startIndexInclusive;
                ArrayUtils.swap(array, n3, n3 + n2 - nOffset, nOffset);
                n2 = offset;
                offset -= nOffset;
                continue;
            }
            if (offset < nOffset) {
                int n4 = startIndexInclusive;
                ArrayUtils.swap(array, n4, n4 + nOffset, offset);
                startIndexInclusive += offset;
                n2 = nOffset;
                continue;
            }
            void v2 = var1_1;
            ArrayUtils.swap(byArray, (int)v2, (int)(v2 + nOffset), (int)var3_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void shift(char[] array, int offset) {
        if (array != null) {
            void var1_1;
            char[] cArray;
            ArrayUtils.shift(array, 0, cArray.length, (int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void shift(char[] array, int startIndexInclusive, int endIndexExclusive, int offset) {
        if (array == null || startIndexInclusive >= array.length - 1 || endIndexExclusive <= 0) {
            return;
        }
        startIndexInclusive = ArrayUtils.max0(startIndexInclusive);
        int n2 = (endIndexExclusive = Math.min(endIndexExclusive, array.length)) - startIndexInclusive;
        if (n2 <= 1) {
            return;
        }
        if ((offset %= n2) < 0) {
            offset += n2;
        }
        while (n2 > 1 && offset > 0) {
            void var3_3;
            char[] cArray;
            void var1_1;
            int nOffset = n2 - offset;
            if (offset > nOffset) {
                int n3 = startIndexInclusive;
                ArrayUtils.swap(array, n3, n3 + n2 - nOffset, nOffset);
                n2 = offset;
                offset -= nOffset;
                continue;
            }
            if (offset < nOffset) {
                int n4 = startIndexInclusive;
                ArrayUtils.swap(array, n4, n4 + nOffset, offset);
                startIndexInclusive += offset;
                n2 = nOffset;
                continue;
            }
            void v2 = var1_1;
            ArrayUtils.swap(cArray, (int)v2, (int)(v2 + nOffset), (int)var3_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void shift(double[] array, int offset) {
        if (array != null) {
            void var1_1;
            double[] dArray;
            ArrayUtils.shift(array, 0, dArray.length, (int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void shift(double[] array, int startIndexInclusive, int endIndexExclusive, int offset) {
        if (array == null || startIndexInclusive >= array.length - 1 || endIndexExclusive <= 0) {
            return;
        }
        startIndexInclusive = ArrayUtils.max0(startIndexInclusive);
        int n2 = (endIndexExclusive = Math.min(endIndexExclusive, array.length)) - startIndexInclusive;
        if (n2 <= 1) {
            return;
        }
        if ((offset %= n2) < 0) {
            offset += n2;
        }
        while (n2 > 1 && offset > 0) {
            void var3_3;
            double[] dArray;
            void var1_1;
            int nOffset = n2 - offset;
            if (offset > nOffset) {
                int n3 = startIndexInclusive;
                ArrayUtils.swap(array, n3, n3 + n2 - nOffset, nOffset);
                n2 = offset;
                offset -= nOffset;
                continue;
            }
            if (offset < nOffset) {
                int n4 = startIndexInclusive;
                ArrayUtils.swap(array, n4, n4 + nOffset, offset);
                startIndexInclusive += offset;
                n2 = nOffset;
                continue;
            }
            void v2 = var1_1;
            ArrayUtils.swap(dArray, (int)v2, (int)(v2 + nOffset), (int)var3_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void shift(float[] array, int offset) {
        if (array != null) {
            void var1_1;
            float[] fArray;
            ArrayUtils.shift(array, 0, fArray.length, (int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void shift(float[] array, int startIndexInclusive, int endIndexExclusive, int offset) {
        if (array == null || startIndexInclusive >= array.length - 1 || endIndexExclusive <= 0) {
            return;
        }
        startIndexInclusive = ArrayUtils.max0(startIndexInclusive);
        int n2 = (endIndexExclusive = Math.min(endIndexExclusive, array.length)) - startIndexInclusive;
        if (n2 <= 1) {
            return;
        }
        if ((offset %= n2) < 0) {
            offset += n2;
        }
        while (n2 > 1 && offset > 0) {
            void var3_3;
            float[] fArray;
            void var1_1;
            int nOffset = n2 - offset;
            if (offset > nOffset) {
                int n3 = startIndexInclusive;
                ArrayUtils.swap(array, n3, n3 + n2 - nOffset, nOffset);
                n2 = offset;
                offset -= nOffset;
                continue;
            }
            if (offset < nOffset) {
                int n4 = startIndexInclusive;
                ArrayUtils.swap(array, n4, n4 + nOffset, offset);
                startIndexInclusive += offset;
                n2 = nOffset;
                continue;
            }
            void v2 = var1_1;
            ArrayUtils.swap(fArray, (int)v2, (int)(v2 + nOffset), (int)var3_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void shift(int[] array, int offset) {
        if (array != null) {
            void var1_1;
            int[] nArray;
            ArrayUtils.shift(array, 0, nArray.length, (int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void shift(int[] array, int startIndexInclusive, int endIndexExclusive, int offset) {
        if (array == null || startIndexInclusive >= array.length - 1 || endIndexExclusive <= 0) {
            return;
        }
        startIndexInclusive = ArrayUtils.max0(startIndexInclusive);
        int n2 = (endIndexExclusive = Math.min(endIndexExclusive, array.length)) - startIndexInclusive;
        if (n2 <= 1) {
            return;
        }
        if ((offset %= n2) < 0) {
            offset += n2;
        }
        while (n2 > 1 && offset > 0) {
            void var3_3;
            int[] nArray;
            void var1_1;
            int nOffset = n2 - offset;
            if (offset > nOffset) {
                int n3 = startIndexInclusive;
                ArrayUtils.swap(array, n3, n3 + n2 - nOffset, nOffset);
                n2 = offset;
                offset -= nOffset;
                continue;
            }
            if (offset < nOffset) {
                int n4 = startIndexInclusive;
                ArrayUtils.swap(array, n4, n4 + nOffset, offset);
                startIndexInclusive += offset;
                n2 = nOffset;
                continue;
            }
            void v2 = var1_1;
            ArrayUtils.swap(nArray, (int)v2, (int)(v2 + nOffset), (int)var3_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void shift(long[] array, int offset) {
        if (array != null) {
            void var1_1;
            long[] lArray;
            ArrayUtils.shift(array, 0, lArray.length, (int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void shift(long[] array, int startIndexInclusive, int endIndexExclusive, int offset) {
        if (array == null || startIndexInclusive >= array.length - 1 || endIndexExclusive <= 0) {
            return;
        }
        startIndexInclusive = ArrayUtils.max0(startIndexInclusive);
        int n2 = (endIndexExclusive = Math.min(endIndexExclusive, array.length)) - startIndexInclusive;
        if (n2 <= 1) {
            return;
        }
        if ((offset %= n2) < 0) {
            offset += n2;
        }
        while (n2 > 1 && offset > 0) {
            void var3_3;
            long[] lArray;
            void var1_1;
            int nOffset = n2 - offset;
            if (offset > nOffset) {
                int n3 = startIndexInclusive;
                ArrayUtils.swap(array, n3, n3 + n2 - nOffset, nOffset);
                n2 = offset;
                offset -= nOffset;
                continue;
            }
            if (offset < nOffset) {
                int n4 = startIndexInclusive;
                ArrayUtils.swap(array, n4, n4 + nOffset, offset);
                startIndexInclusive += offset;
                n2 = nOffset;
                continue;
            }
            void v2 = var1_1;
            ArrayUtils.swap(lArray, (int)v2, (int)(v2 + nOffset), (int)var3_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void shift(Object[] array, int offset) {
        if (array != null) {
            void var1_1;
            Object[] objectArray;
            ArrayUtils.shift(array, 0, objectArray.length, (int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void shift(Object[] array, int startIndexInclusive, int endIndexExclusive, int offset) {
        if (array == null || startIndexInclusive >= array.length - 1 || endIndexExclusive <= 0) {
            return;
        }
        startIndexInclusive = ArrayUtils.max0(startIndexInclusive);
        int n2 = (endIndexExclusive = Math.min(endIndexExclusive, array.length)) - startIndexInclusive;
        if (n2 <= 1) {
            return;
        }
        if ((offset %= n2) < 0) {
            offset += n2;
        }
        while (n2 > 1 && offset > 0) {
            void var3_3;
            Object[] objectArray;
            void var1_1;
            int nOffset = n2 - offset;
            if (offset > nOffset) {
                int n3 = startIndexInclusive;
                ArrayUtils.swap(array, n3, n3 + n2 - nOffset, nOffset);
                n2 = offset;
                offset -= nOffset;
                continue;
            }
            if (offset < nOffset) {
                int n4 = startIndexInclusive;
                ArrayUtils.swap(array, n4, n4 + nOffset, offset);
                startIndexInclusive += offset;
                n2 = nOffset;
                continue;
            }
            void v2 = var1_1;
            ArrayUtils.swap(objectArray, (int)v2, (int)(v2 + nOffset), (int)var3_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void shift(short[] array, int offset) {
        if (array != null) {
            void var1_1;
            short[] sArray;
            ArrayUtils.shift(array, 0, sArray.length, (int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void shift(short[] array, int startIndexInclusive, int endIndexExclusive, int offset) {
        if (array == null || startIndexInclusive >= array.length - 1 || endIndexExclusive <= 0) {
            return;
        }
        startIndexInclusive = ArrayUtils.max0(startIndexInclusive);
        int n2 = (endIndexExclusive = Math.min(endIndexExclusive, array.length)) - startIndexInclusive;
        if (n2 <= 1) {
            return;
        }
        if ((offset %= n2) < 0) {
            offset += n2;
        }
        while (n2 > 1 && offset > 0) {
            void var3_3;
            short[] sArray;
            void var1_1;
            int nOffset = n2 - offset;
            if (offset > nOffset) {
                int n3 = startIndexInclusive;
                ArrayUtils.swap(array, n3, n3 + n2 - nOffset, nOffset);
                n2 = offset;
                offset -= nOffset;
                continue;
            }
            if (offset < nOffset) {
                int n4 = startIndexInclusive;
                ArrayUtils.swap(array, n4, n4 + nOffset, offset);
                startIndexInclusive += offset;
                n2 = nOffset;
                continue;
            }
            void v2 = var1_1;
            ArrayUtils.swap(sArray, (int)v2, (int)(v2 + nOffset), (int)var3_3);
            return;
        }
    }

    public static void shuffle(boolean[] array) {
        ArrayUtils.shuffle(array, (Random)ArrayUtils.random());
    }

    public static void shuffle(boolean[] array, Random random) {
        for (int i2 = array.length; i2 > 1; --i2) {
            ArrayUtils.swap(array, i2 - 1, random.nextInt(i2), 1);
        }
    }

    public static void shuffle(byte[] array) {
        ArrayUtils.shuffle(array, (Random)ArrayUtils.random());
    }

    public static void shuffle(byte[] array, Random random) {
        for (int i2 = array.length; i2 > 1; --i2) {
            ArrayUtils.swap(array, i2 - 1, random.nextInt(i2), 1);
        }
    }

    public static void shuffle(char[] array) {
        ArrayUtils.shuffle(array, (Random)ArrayUtils.random());
    }

    public static void shuffle(char[] array, Random random) {
        for (int i2 = array.length; i2 > 1; --i2) {
            ArrayUtils.swap(array, i2 - 1, random.nextInt(i2), 1);
        }
    }

    public static void shuffle(double[] array) {
        ArrayUtils.shuffle(array, (Random)ArrayUtils.random());
    }

    public static void shuffle(double[] array, Random random) {
        for (int i2 = array.length; i2 > 1; --i2) {
            ArrayUtils.swap(array, i2 - 1, random.nextInt(i2), 1);
        }
    }

    public static void shuffle(float[] array) {
        ArrayUtils.shuffle(array, (Random)ArrayUtils.random());
    }

    public static void shuffle(float[] array, Random random) {
        for (int i2 = array.length; i2 > 1; --i2) {
            ArrayUtils.swap(array, i2 - 1, random.nextInt(i2), 1);
        }
    }

    public static void shuffle(int[] array) {
        ArrayUtils.shuffle(array, (Random)ArrayUtils.random());
    }

    public static void shuffle(int[] array, Random random) {
        for (int i2 = array.length; i2 > 1; --i2) {
            ArrayUtils.swap(array, i2 - 1, random.nextInt(i2), 1);
        }
    }

    public static void shuffle(long[] array) {
        ArrayUtils.shuffle(array, (Random)ArrayUtils.random());
    }

    public static void shuffle(long[] array, Random random) {
        for (int i2 = array.length; i2 > 1; --i2) {
            ArrayUtils.swap(array, i2 - 1, random.nextInt(i2), 1);
        }
    }

    public static void shuffle(Object[] array) {
        ArrayUtils.shuffle(array, (Random)ArrayUtils.random());
    }

    public static void shuffle(Object[] array, Random random) {
        for (int i2 = array.length; i2 > 1; --i2) {
            ArrayUtils.swap(array, i2 - 1, random.nextInt(i2), 1);
        }
    }

    public static void shuffle(short[] array) {
        ArrayUtils.shuffle(array, (Random)ArrayUtils.random());
    }

    public static void shuffle(short[] array, Random random) {
        for (int i2 = array.length; i2 > 1; --i2) {
            ArrayUtils.swap(array, i2 - 1, random.nextInt(i2), 1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean[] subarray(boolean[] array, int startIndexInclusive, int endIndexExclusive) {
        void var2_2;
        void var1_1;
        boolean[] blArray;
        if (array == null) {
            return null;
        }
        startIndexInclusive = ArrayUtils.max0(startIndexInclusive);
        int newSize = (endIndexExclusive = Math.min(endIndexExclusive, array.length)) - startIndexInclusive;
        if (newSize <= 0) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        return ArrayUtils.arraycopy(blArray, (int)var1_1, 0, (int)var2_2, boolean[]::new);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] subarray(byte[] array, int startIndexInclusive, int endIndexExclusive) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        if (array == null) {
            return null;
        }
        startIndexInclusive = ArrayUtils.max0(startIndexInclusive);
        int newSize = (endIndexExclusive = Math.min(endIndexExclusive, array.length)) - startIndexInclusive;
        if (newSize <= 0) {
            return EMPTY_BYTE_ARRAY;
        }
        return ArrayUtils.arraycopy(byArray, (int)var1_1, 0, (int)var2_2, byte[]::new);
    }

    /*
     * WARNING - void declaration
     */
    public static char[] subarray(char[] array, int startIndexInclusive, int endIndexExclusive) {
        void var2_2;
        void var1_1;
        char[] cArray;
        if (array == null) {
            return null;
        }
        startIndexInclusive = ArrayUtils.max0(startIndexInclusive);
        int newSize = (endIndexExclusive = Math.min(endIndexExclusive, array.length)) - startIndexInclusive;
        if (newSize <= 0) {
            return EMPTY_CHAR_ARRAY;
        }
        return ArrayUtils.arraycopy(cArray, (int)var1_1, 0, (int)var2_2, char[]::new);
    }

    /*
     * WARNING - void declaration
     */
    public static double[] subarray(double[] array, int startIndexInclusive, int endIndexExclusive) {
        void var2_2;
        void var1_1;
        double[] dArray;
        if (array == null) {
            return null;
        }
        startIndexInclusive = ArrayUtils.max0(startIndexInclusive);
        int newSize = (endIndexExclusive = Math.min(endIndexExclusive, array.length)) - startIndexInclusive;
        if (newSize <= 0) {
            return EMPTY_DOUBLE_ARRAY;
        }
        return ArrayUtils.arraycopy(dArray, (int)var1_1, 0, (int)var2_2, double[]::new);
    }

    /*
     * WARNING - void declaration
     */
    public static float[] subarray(float[] array, int startIndexInclusive, int endIndexExclusive) {
        void var2_2;
        void var1_1;
        float[] fArray;
        if (array == null) {
            return null;
        }
        startIndexInclusive = ArrayUtils.max0(startIndexInclusive);
        int newSize = (endIndexExclusive = Math.min(endIndexExclusive, array.length)) - startIndexInclusive;
        if (newSize <= 0) {
            return EMPTY_FLOAT_ARRAY;
        }
        return ArrayUtils.arraycopy(fArray, (int)var1_1, 0, (int)var2_2, float[]::new);
    }

    /*
     * WARNING - void declaration
     */
    public static int[] subarray(int[] array, int startIndexInclusive, int endIndexExclusive) {
        void var2_2;
        void var1_1;
        int[] nArray;
        if (array == null) {
            return null;
        }
        startIndexInclusive = ArrayUtils.max0(startIndexInclusive);
        int newSize = (endIndexExclusive = Math.min(endIndexExclusive, array.length)) - startIndexInclusive;
        if (newSize <= 0) {
            return EMPTY_INT_ARRAY;
        }
        return ArrayUtils.arraycopy(nArray, (int)var1_1, 0, (int)var2_2, int[]::new);
    }

    /*
     * WARNING - void declaration
     */
    public static long[] subarray(long[] array, int startIndexInclusive, int endIndexExclusive) {
        void var2_2;
        void var1_1;
        long[] lArray;
        if (array == null) {
            return null;
        }
        startIndexInclusive = ArrayUtils.max0(startIndexInclusive);
        int newSize = (endIndexExclusive = Math.min(endIndexExclusive, array.length)) - startIndexInclusive;
        if (newSize <= 0) {
            return EMPTY_LONG_ARRAY;
        }
        return ArrayUtils.arraycopy(lArray, (int)var1_1, 0, (int)var2_2, long[]::new);
    }

    /*
     * WARNING - void declaration
     */
    public static short[] subarray(short[] array, int startIndexInclusive, int endIndexExclusive) {
        void var2_2;
        void var1_1;
        short[] sArray;
        if (array == null) {
            return null;
        }
        startIndexInclusive = ArrayUtils.max0(startIndexInclusive);
        int newSize = (endIndexExclusive = Math.min(endIndexExclusive, array.length)) - startIndexInclusive;
        if (newSize <= 0) {
            return EMPTY_SHORT_ARRAY;
        }
        return ArrayUtils.arraycopy(sArray, (int)var1_1, 0, (int)var2_2, short[]::new);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] subarray(T[] array, int startIndexInclusive, int endIndexExclusive) {
        void var2_2;
        void var3_3;
        void var1_1;
        T[] TArray;
        if (array == null) {
            return null;
        }
        startIndexInclusive = ArrayUtils.max0(startIndexInclusive);
        endIndexExclusive = Math.min(endIndexExclusive, array.length);
        int newSize = endIndexExclusive - startIndexInclusive;
        Class<T> type = ArrayUtils.getComponentType(array);
        if (newSize <= 0) {
            return ArrayUtils.newInstance(type, 0);
        }
        return ArrayUtils.arraycopy(TArray, (int)var1_1, 0, newSize, () -> ArrayUtils.lambda$subarray$11((Class)var3_3, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static void swap(boolean[] array, int offset1, int offset2) {
        void var2_2;
        void var1_1;
        ArrayUtils.swap(array, (int)var1_1, (int)var2_2, 1);
    }

    public static void swap(boolean[] array, int offset1, int offset2, int len) {
        if (ArrayUtils.isEmpty(array) || offset1 >= array.length || offset2 >= array.length) {
            return;
        }
        offset1 = ArrayUtils.max0(offset1);
        offset2 = ArrayUtils.max0(offset2);
        len = Math.min(Math.min(len, array.length - offset1), array.length - offset2);
        int i2 = 0;
        while (i2 < len) {
            boolean aux = array[offset1];
            array[offset1] = array[offset2];
            array[offset2] = aux;
            ++i2;
            ++offset1;
            ++offset2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void swap(byte[] array, int offset1, int offset2) {
        void var2_2;
        void var1_1;
        ArrayUtils.swap(array, (int)var1_1, (int)var2_2, 1);
    }

    public static void swap(byte[] array, int offset1, int offset2, int len) {
        if (ArrayUtils.isEmpty(array) || offset1 >= array.length || offset2 >= array.length) {
            return;
        }
        offset1 = ArrayUtils.max0(offset1);
        offset2 = ArrayUtils.max0(offset2);
        len = Math.min(Math.min(len, array.length - offset1), array.length - offset2);
        int i2 = 0;
        while (i2 < len) {
            byte aux = array[offset1];
            array[offset1] = array[offset2];
            array[offset2] = aux;
            ++i2;
            ++offset1;
            ++offset2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void swap(char[] array, int offset1, int offset2) {
        void var2_2;
        void var1_1;
        ArrayUtils.swap(array, (int)var1_1, (int)var2_2, 1);
    }

    public static void swap(char[] array, int offset1, int offset2, int len) {
        if (ArrayUtils.isEmpty(array) || offset1 >= array.length || offset2 >= array.length) {
            return;
        }
        offset1 = ArrayUtils.max0(offset1);
        offset2 = ArrayUtils.max0(offset2);
        len = Math.min(Math.min(len, array.length - offset1), array.length - offset2);
        int i2 = 0;
        while (i2 < len) {
            char aux = array[offset1];
            array[offset1] = array[offset2];
            array[offset2] = aux;
            ++i2;
            ++offset1;
            ++offset2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void swap(double[] array, int offset1, int offset2) {
        void var2_2;
        void var1_1;
        ArrayUtils.swap(array, (int)var1_1, (int)var2_2, 1);
    }

    public static void swap(double[] array, int offset1, int offset2, int len) {
        if (ArrayUtils.isEmpty(array) || offset1 >= array.length || offset2 >= array.length) {
            return;
        }
        offset1 = ArrayUtils.max0(offset1);
        offset2 = ArrayUtils.max0(offset2);
        len = Math.min(Math.min(len, array.length - offset1), array.length - offset2);
        int i2 = 0;
        while (i2 < len) {
            double aux = array[offset1];
            array[offset1] = array[offset2];
            array[offset2] = aux;
            ++i2;
            ++offset1;
            ++offset2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void swap(float[] array, int offset1, int offset2) {
        void var2_2;
        void var1_1;
        ArrayUtils.swap(array, (int)var1_1, (int)var2_2, 1);
    }

    public static void swap(float[] array, int offset1, int offset2, int len) {
        if (ArrayUtils.isEmpty(array) || offset1 >= array.length || offset2 >= array.length) {
            return;
        }
        offset1 = ArrayUtils.max0(offset1);
        offset2 = ArrayUtils.max0(offset2);
        len = Math.min(Math.min(len, array.length - offset1), array.length - offset2);
        int i2 = 0;
        while (i2 < len) {
            float aux = array[offset1];
            array[offset1] = array[offset2];
            array[offset2] = aux;
            ++i2;
            ++offset1;
            ++offset2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void swap(int[] array, int offset1, int offset2) {
        void var2_2;
        void var1_1;
        ArrayUtils.swap(array, (int)var1_1, (int)var2_2, 1);
    }

    public static void swap(int[] array, int offset1, int offset2, int len) {
        if (ArrayUtils.isEmpty(array) || offset1 >= array.length || offset2 >= array.length) {
            return;
        }
        offset1 = ArrayUtils.max0(offset1);
        offset2 = ArrayUtils.max0(offset2);
        len = Math.min(Math.min(len, array.length - offset1), array.length - offset2);
        int i2 = 0;
        while (i2 < len) {
            int aux = array[offset1];
            array[offset1] = array[offset2];
            array[offset2] = aux;
            ++i2;
            ++offset1;
            ++offset2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void swap(long[] array, int offset1, int offset2) {
        void var2_2;
        void var1_1;
        ArrayUtils.swap(array, (int)var1_1, (int)var2_2, 1);
    }

    public static void swap(long[] array, int offset1, int offset2, int len) {
        if (ArrayUtils.isEmpty(array) || offset1 >= array.length || offset2 >= array.length) {
            return;
        }
        offset1 = ArrayUtils.max0(offset1);
        offset2 = ArrayUtils.max0(offset2);
        len = Math.min(Math.min(len, array.length - offset1), array.length - offset2);
        int i2 = 0;
        while (i2 < len) {
            long aux = array[offset1];
            array[offset1] = array[offset2];
            array[offset2] = aux;
            ++i2;
            ++offset1;
            ++offset2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void swap(Object[] array, int offset1, int offset2) {
        void var2_2;
        void var1_1;
        ArrayUtils.swap(array, (int)var1_1, (int)var2_2, 1);
    }

    public static void swap(Object[] array, int offset1, int offset2, int len) {
        if (ArrayUtils.isEmpty(array) || offset1 >= array.length || offset2 >= array.length) {
            return;
        }
        offset1 = ArrayUtils.max0(offset1);
        offset2 = ArrayUtils.max0(offset2);
        len = Math.min(Math.min(len, array.length - offset1), array.length - offset2);
        int i2 = 0;
        while (i2 < len) {
            Object aux = array[offset1];
            array[offset1] = array[offset2];
            array[offset2] = aux;
            ++i2;
            ++offset1;
            ++offset2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void swap(short[] array, int offset1, int offset2) {
        void var2_2;
        void var1_1;
        ArrayUtils.swap(array, (int)var1_1, (int)var2_2, 1);
    }

    public static void swap(short[] array, int offset1, int offset2, int len) {
        if (ArrayUtils.isEmpty(array) || offset1 >= array.length || offset2 >= array.length) {
            return;
        }
        if ((offset1 = ArrayUtils.max0(offset1)) == (offset2 = ArrayUtils.max0(offset2))) {
            return;
        }
        len = Math.min(Math.min(len, array.length - offset1), array.length - offset2);
        int i2 = 0;
        while (i2 < len) {
            short aux = array[offset1];
            array[offset1] = array[offset2];
            array[offset2] = aux;
            ++i2;
            ++offset1;
            ++offset2;
        }
    }

    public static <T> T[] toArray(T ... items) {
        return items;
    }

    /*
     * WARNING - void declaration
     */
    public static Map<Object, Object> toMap(Object[] array) {
        void var1_1;
        if (array == null) {
            return null;
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>((int)((double)array.length * 1.5));
        for (int i2 = 0; i2 < array.length; ++i2) {
            void var3_3;
            Object[] entry;
            Object object = array[i2];
            if (object instanceof Map.Entry) {
                entry = (Object[])object;
                map.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (object instanceof Object[]) {
                entry = (Object[])object;
                if (entry.length < 2) {
                    throw new IllegalArgumentException("Array element " + i2 + ", '" + object + "', has a length less than 2");
                }
                map.put(entry[0], entry[1]);
                continue;
            }
            throw new IllegalArgumentException("Array element " + i2 + ", '" + var3_3 + "', is neither of type Map.Entry nor an Array");
        }
        return var1_1;
    }

    public static Boolean[] toObject(boolean[] array) {
        boolean[] blArray;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_BOOLEAN_OBJECT_ARRAY;
        }
        Boolean[] booleanArray = new Boolean[array.length];
        return ArrayUtils.setAll(booleanArray, (int i2) -> {
            void var1_1;
            if (blArray[var1_1]) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        });
    }

    public static Byte[] toObject(byte[] array) {
        byte[] byArray;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_BYTE_OBJECT_ARRAY;
        }
        return ArrayUtils.setAll(new Byte[array.length], (int i2) -> {
            void var1_1;
            return byArray[var1_1];
        });
    }

    public static Character[] toObject(char[] array) {
        char[] cArray;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_CHARACTER_OBJECT_ARRAY;
        }
        return ArrayUtils.setAll(new Character[array.length], (int i2) -> {
            void var1_1;
            return Character.valueOf(cArray[var1_1]);
        });
    }

    public static Double[] toObject(double[] array) {
        double[] dArray;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_DOUBLE_OBJECT_ARRAY;
        }
        return ArrayUtils.setAll(new Double[array.length], (int i2) -> {
            void var1_1;
            return dArray[var1_1];
        });
    }

    public static Float[] toObject(float[] array) {
        float[] fArray;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_FLOAT_OBJECT_ARRAY;
        }
        return ArrayUtils.setAll(new Float[array.length], (int i2) -> {
            void var1_1;
            return Float.valueOf(fArray[var1_1]);
        });
    }

    public static Integer[] toObject(int[] array) {
        int[] nArray;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_INTEGER_OBJECT_ARRAY;
        }
        return ArrayUtils.setAll(new Integer[array.length], (int i2) -> {
            void var1_1;
            return nArray[var1_1];
        });
    }

    public static Long[] toObject(long[] array) {
        long[] lArray;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_LONG_OBJECT_ARRAY;
        }
        return ArrayUtils.setAll(new Long[array.length], (int i2) -> {
            void var1_1;
            return lArray[var1_1];
        });
    }

    public static Short[] toObject(short[] array) {
        short[] sArray;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_SHORT_OBJECT_ARRAY;
        }
        return ArrayUtils.setAll(new Short[array.length], (int i2) -> {
            void var1_1;
            return sArray[var1_1];
        });
    }

    public static boolean[] toPrimitive(Boolean[] array) {
        return ArrayUtils.toPrimitive(array, false);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean[] toPrimitive(Boolean[] array, boolean valueForNull) {
        void var2_2;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        boolean[] result = new boolean[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            Boolean b2 = array[i2];
            result[i2] = b2 == null ? valueForNull : b2;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] toPrimitive(Byte[] array) {
        void var1_1;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] result = new byte[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            result[i2] = array[i2];
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] toPrimitive(Byte[] array, byte valueForNull) {
        void var2_2;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] result = new byte[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            Byte b2 = array[i2];
            result[i2] = b2 == null ? valueForNull : b2;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static char[] toPrimitive(Character[] array) {
        void var1_1;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        char[] result = new char[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            result[i2] = array[i2].charValue();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static char[] toPrimitive(Character[] array, char valueForNull) {
        void var2_2;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        char[] result = new char[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            Character b2 = array[i2];
            result[i2] = b2 == null ? valueForNull : b2.charValue();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static double[] toPrimitive(Double[] array) {
        void var1_1;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_DOUBLE_ARRAY;
        }
        double[] result = new double[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            result[i2] = array[i2];
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static double[] toPrimitive(Double[] array, double valueForNull) {
        void var3_2;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_DOUBLE_ARRAY;
        }
        double[] result = new double[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            Double b2 = array[i2];
            result[i2] = b2 == null ? valueForNull : b2;
        }
        return var3_2;
    }

    /*
     * WARNING - void declaration
     */
    public static float[] toPrimitive(Float[] array) {
        void var1_1;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_FLOAT_ARRAY;
        }
        float[] result = new float[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            result[i2] = array[i2].floatValue();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static float[] toPrimitive(Float[] array, float valueForNull) {
        void var2_2;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_FLOAT_ARRAY;
        }
        float[] result = new float[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            Float b2 = array[i2];
            result[i2] = b2 == null ? valueForNull : b2.floatValue();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static int[] toPrimitive(Integer[] array) {
        void var1_1;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] result = new int[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            result[i2] = array[i2];
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static int[] toPrimitive(Integer[] array, int valueForNull) {
        void var2_2;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] result = new int[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            Integer b2 = array[i2];
            result[i2] = b2 == null ? valueForNull : b2;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static long[] toPrimitive(Long[] array) {
        void var1_1;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_LONG_ARRAY;
        }
        long[] result = new long[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            result[i2] = array[i2];
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static long[] toPrimitive(Long[] array, long valueForNull) {
        void var3_2;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_LONG_ARRAY;
        }
        long[] result = new long[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            Long b2 = array[i2];
            result[i2] = b2 == null ? valueForNull : b2;
        }
        return var3_2;
    }

    public static Object toPrimitive(Object array) {
        Object object;
        if (array == null) {
            return null;
        }
        Class<?> clazz = array.getClass().getComponentType();
        Class<?> pt = ClassUtils.wrapperToPrimitive(clazz);
        if (Boolean.TYPE.equals(pt)) {
            return ArrayUtils.toPrimitive((Boolean[])array);
        }
        if (Character.TYPE.equals(pt)) {
            return ArrayUtils.toPrimitive((Character[])array);
        }
        if (Byte.TYPE.equals(pt)) {
            return ArrayUtils.toPrimitive((Byte[])array);
        }
        if (Integer.TYPE.equals(pt)) {
            return ArrayUtils.toPrimitive((Integer[])array);
        }
        if (Long.TYPE.equals(pt)) {
            return ArrayUtils.toPrimitive((Long[])array);
        }
        if (Short.TYPE.equals(pt)) {
            return ArrayUtils.toPrimitive((Short[])array);
        }
        if (Double.TYPE.equals(pt)) {
            return ArrayUtils.toPrimitive((Double[])array);
        }
        if (Float.TYPE.equals(clazz)) {
            return ArrayUtils.toPrimitive((Float[])array);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static short[] toPrimitive(Short[] array) {
        void var1_1;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_SHORT_ARRAY;
        }
        short[] result = new short[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            result[i2] = array[i2];
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static short[] toPrimitive(Short[] array, short valueForNull) {
        void var2_2;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_SHORT_ARRAY;
        }
        short[] result = new short[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            Short b2 = array[i2];
            result[i2] = b2 == null ? valueForNull : b2;
        }
        return var2_2;
    }

    public static String toString(Object array) {
        return ArrayUtils.toString(array, "{}");
    }

    /*
     * WARNING - void declaration
     */
    public static String toString(Object array, String stringIfNull) {
        Object object;
        if (array == null) {
            void var1_1;
            return var1_1;
        }
        return new ToStringBuilder(array, ToStringStyle.SIMPLE_STYLE).append(object).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String[] toStringArray(Object[] array) {
        void var1_1;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_STRING_ARRAY;
        }
        String[] result = new String[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            result[i2] = array[i2].toString();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static String[] toStringArray(Object[] array, String valueForNullElements) {
        void var2_2;
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_STRING_ARRAY;
        }
        String[] result = new String[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            result[i2] = Objects.toString(array[i2], valueForNullElements);
        }
        return var2_2;
    }

    @Deprecated
    public ArrayUtils() {
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ Object[] lambda$subarray$11(Class type, int newSize) {
        void var1_1;
        return ArrayUtils.newInstance(type, (int)var1_1);
    }
}

