/*
 * Decompiled with CFR 0.152.
 */
package okio.internal;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.FileHandle;
import okio.FileMetadata;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import okio.Source;
import okio.internal.ResourceFileSystem;
import okio.internal.ZipFilesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 /2\u00020\u0001:\u0001/B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000bH\u0016J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000bH\u0016J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000bH\u0002J\u0018\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u0005H\u0016J\u0018\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000bH\u0016J\u0018\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\u001c\u001a\u00020\u000bH\u0016J\u0018\u0010!\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\t2\u0006\u0010\u001c\u001a\u00020\u000bH\u0016J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0019\u001a\u00020\u000bH\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u0012\u001a\u00020\u000bH\u0016J \u0010&\u001a\u00020%2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J\u0018\u0010'\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u0005H\u0016J\u0010\u0010\u0016\u001a\u00020(2\u0006\u0010\u0012\u001a\u00020\u000bH\u0016J\u001e\u0010)\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000b0\n0\t*\u00020\u0003H\u0002J\u001a\u0010*\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n*\u00020+H\u0002J\u001a\u0010,\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n*\u00020+H\u0002J\f\u0010-\u001a\u00020.*\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000b0\n0\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lokio/internal/ResourceFileSystem;", "Lokio/FileSystem;", "classLoader", "Ljava/lang/ClassLoader;", "indexEagerly", "", "systemFileSystem", "(Ljava/lang/ClassLoader;ZLokio/FileSystem;)V", "roots", "", "Lkotlin/Pair;", "Lokio/Path;", "getRoots", "()Ljava/util/List;", "roots$delegate", "Lkotlin/Lazy;", "appendingSink", "Lokio/Sink;", "file", "mustExist", "atomicMove", "", "source", "target", "canonicalize", "path", "canonicalizeInternal", "createDirectory", "dir", "mustCreate", "createSymlink", "delete", "list", "listOrNull", "metadataOrNull", "Lokio/FileMetadata;", "openReadOnly", "Lokio/FileHandle;", "openReadWrite", "sink", "Lokio/Source;", "toClasspathRoots", "toFileRoot", "Ljava/net/URL;", "toJarRoot", "toRelativePath", "", "Companion", "okio"})
@SourceDebugExtension(value={"SMAP\nResourceFileSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceFileSystem.kt\nokio/internal/ResourceFileSystem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,210:1\n766#2:211\n857#2,2:212\n1549#2:214\n1620#2,3:215\n766#2:218\n857#2,2:219\n1549#2:221\n1620#2,3:222\n1603#2,9:225\n1855#2:234\n1856#2:236\n1612#2:237\n1603#2,9:238\n1855#2:247\n1856#2:249\n1612#2:250\n1#3:235\n1#3:248\n*S KotlinDebug\n*F\n+ 1 ResourceFileSystem.kt\nokio/internal/ResourceFileSystem\n*L\n74#1:211\n74#1:212,2\n75#1:214\n75#1:215,3\n90#1:218\n90#1:219,2\n91#1:221\n91#1:222,3\n173#1:225,9\n173#1:234\n173#1:236\n173#1:237\n174#1:238,9\n174#1:247\n174#1:249\n174#1:250\n173#1:235\n174#1:248\n*E\n"})
public final class ResourceFileSystem
extends FileSystem {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ClassLoader classLoader;
    @NotNull
    private final FileSystem systemFileSystem;
    @NotNull
    private final Lazy roots$delegate;
    @NotNull
    private static final Path ROOT = Path.Companion.get$default(Path.Companion, "/", false, 1, null);

    /*
     * WARNING - void declaration
     */
    public ResourceFileSystem(@NotNull ClassLoader classLoader, boolean indexEagerly, @NotNull FileSystem systemFileSystem) {
        void var2_2;
        void var3_3;
        void var1_1;
        Intrinsics.checkNotNullParameter(classLoader, "");
        Intrinsics.checkNotNullParameter(systemFileSystem, "");
        this.classLoader = var1_1;
        this.systemFileSystem = var3_3;
        this.roots$delegate = LazyKt.lazy((Function0)new Function0<List<? extends Pair<? extends FileSystem, ? extends Path>>>(this){
            final /* synthetic */ ResourceFileSystem this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                super(0);
            }

            @NotNull
            public final List<Pair<FileSystem, Path>> invoke() {
                return ResourceFileSystem.access$toClasspathRoots(this.this$0, ResourceFileSystem.access$getClassLoader$p(this.this$0));
            }
        });
        if (var2_2 != false) {
            this.getRoots().size();
        }
    }

    public /* synthetic */ ResourceFileSystem(ClassLoader classLoader, boolean bl, FileSystem fileSystem, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            fileSystem = FileSystem.SYSTEM;
        }
        this(classLoader, bl, fileSystem);
    }

    private final List<Pair<FileSystem, Path>> getRoots() {
        Lazy lazy = this.roots$delegate;
        return (List)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public final Path canonicalize(@NotNull Path path) {
        void var1_1;
        Intrinsics.checkNotNullParameter(path, "");
        return this.canonicalizeInternal((Path)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final Path canonicalizeInternal(Path path) {
        void var1_1;
        return ROOT.resolve((Path)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public final List<Path> list(@NotNull Path dir) {
        void var3_3;
        Intrinsics.checkNotNullParameter(dir, "");
        String relativePath = this.toRelativePath(dir);
        Set result = new LinkedHashSet();
        boolean foundAny = false;
        for (Pair<FileSystem, Path> pair : this.getRoots()) {
            Object fileSystem = pair.component1();
            Path base = pair.component2();
            try {
                void $this$mapTo$iv$iv;
                Path it;
                Object $this$filterTo$iv$iv;
                Collection collection = result;
                Object object = fileSystem = (Iterable)((FileSystem)fileSystem).list(base.resolve(relativePath));
                Collection destination$iv$iv = new ArrayList();
                $this$filterTo$iv$iv = $this$filterTo$iv$iv.iterator();
                while ($this$filterTo$iv$iv.hasNext()) {
                    Object element$iv$iv = $this$filterTo$iv$iv.next();
                    it = (Path)element$iv$iv;
                    if (!okio.internal.ResourceFileSystem$Companion.access$keepPath(Companion, it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$map$iv = (List)destination$iv$iv;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (Path)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    collection2.add(Companion.removeBase(it, base));
                }
                Iterable iterable = (List)destination$iv$iv;
                CollectionsKt.addAll(collection, iterable);
                foundAny = true;
            }
            catch (IOException iOException) {}
        }
        if (!foundAny) {
            void var1_1;
            throw new FileNotFoundException("file not found: " + var1_1);
        }
        return CollectionsKt.toList((Iterable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public final List<Path> listOrNull(@NotNull Path dir) {
        void var3_3;
        Intrinsics.checkNotNullParameter(dir, "");
        String relativePath = this.toRelativePath(dir);
        Set result = new LinkedHashSet();
        boolean foundAny = false;
        for (Pair<FileSystem, Path> pair : this.getRoots()) {
            List baseResult;
            List list;
            Object fileSystem = pair.component1();
            Path base = pair.component2();
            if ((fileSystem = ((FileSystem)fileSystem).listOrNull(base.resolve(relativePath))) != null) {
                void $this$mapTo$iv$iv;
                Path it;
                Object $this$filterTo$iv$iv;
                Object object = fileSystem = (Iterable)fileSystem;
                Collection destination$iv$iv = new ArrayList();
                $this$filterTo$iv$iv = $this$filterTo$iv$iv.iterator();
                while ($this$filterTo$iv$iv.hasNext()) {
                    Object element$iv$iv = $this$filterTo$iv$iv.next();
                    it = (Path)element$iv$iv;
                    if (!okio.internal.ResourceFileSystem$Companion.access$keepPath(Companion, it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$map$iv = (List)destination$iv$iv;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (Path)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    collection.add(Companion.removeBase(it, base));
                }
                list = (List)destination$iv$iv;
            } else {
                list = baseResult = null;
            }
            if (list == null) continue;
            CollectionsKt.addAll((Collection)result, baseResult);
            foundAny = true;
        }
        if (var3_3 != false) {
            void var2_2;
            return CollectionsKt.toList((Iterable)var2_2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public final FileHandle openReadOnly(@NotNull Path file) {
        void var1_1;
        Intrinsics.checkNotNullParameter(file, "");
        if (!okio.internal.ResourceFileSystem$Companion.access$keepPath(Companion, file)) {
            throw new FileNotFoundException("file not found: " + file);
        }
        String relativePath = this.toRelativePath(file);
        for (Pair<FileSystem, Path> pair : this.getRoots()) {
            FileSystem fileSystem = pair.component1();
            Path base = pair.component2();
            try {
                return fileSystem.openReadOnly(base.resolve(relativePath));
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
        }
        throw new FileNotFoundException("file not found: " + var1_1);
    }

    @Override
    @NotNull
    public final FileHandle openReadWrite(@NotNull Path file, boolean mustCreate, boolean mustExist) {
        Intrinsics.checkNotNullParameter(file, "");
        throw new IOException("resources are not writable");
    }

    @Override
    @Nullable
    public final FileMetadata metadataOrNull(@NotNull Path path) {
        Intrinsics.checkNotNullParameter(path, "");
        if (!okio.internal.ResourceFileSystem$Companion.access$keepPath(Companion, path)) {
            return null;
        }
        String relativePath = this.toRelativePath(path);
        for (Pair<FileSystem, Path> pair : this.getRoots()) {
            FileSystem fileSystem = pair.component1();
            Path base = pair.component2();
            FileMetadata fileMetadata = fileSystem.metadataOrNull(((Path)((Object)pair)).resolve(relativePath));
            if (fileMetadata == null) continue;
            return fileMetadata;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public final Source source(@NotNull Path file) {
        void var2_2;
        Intrinsics.checkNotNullParameter(file, "");
        if (!okio.internal.ResourceFileSystem$Companion.access$keepPath(Companion, file)) {
            throw new FileNotFoundException("file not found: " + file);
        }
        Path relativePath = Path.resolve$default(ROOT, file, false, 2, null).relativeTo(ROOT);
        Closeable closeable = this.classLoader.getResourceAsStream(var2_2.toString());
        if (closeable == null || (closeable = Okio.source(closeable)) == null) {
            void var1_1;
            throw new FileNotFoundException("file not found: " + var1_1);
        }
        return closeable;
    }

    @Override
    @NotNull
    public final Sink sink(@NotNull Path file, boolean mustCreate) {
        Intrinsics.checkNotNullParameter(file, "");
        throw new IOException(this + " is read-only");
    }

    @Override
    @NotNull
    public final Sink appendingSink(@NotNull Path file, boolean mustExist) {
        Intrinsics.checkNotNullParameter(file, "");
        throw new IOException(this + " is read-only");
    }

    @Override
    public final void createDirectory(@NotNull Path dir, boolean mustCreate) {
        Intrinsics.checkNotNullParameter(dir, "");
        throw new IOException(this + " is read-only");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void atomicMove(@NotNull Path source2, @NotNull Path target) {
        void var2_2;
        Intrinsics.checkNotNullParameter(source2, "");
        Intrinsics.checkNotNullParameter(var2_2, "");
        throw new IOException(this + " is read-only");
    }

    @Override
    public final void delete(@NotNull Path path, boolean mustExist) {
        Intrinsics.checkNotNullParameter(path, "");
        throw new IOException(this + " is read-only");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void createSymlink(@NotNull Path source2, @NotNull Path target) {
        void var2_2;
        Intrinsics.checkNotNullParameter(source2, "");
        Intrinsics.checkNotNullParameter(var2_2, "");
        throw new IOException(this + " is read-only");
    }

    private final String toRelativePath(Path $this$toRelativePath) {
        Path path;
        path = this.canonicalizeInternal(path);
        return path.relativeTo(ROOT).toString();
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<FileSystem, Path>> toClasspathRoots(ClassLoader $this$toClasspathRoots) {
        void var3_3;
        Collection collection;
        Pair<FileSystem, Path> it$iv$iv;
        URL it;
        Iterator $this$mapNotNullTo$iv$iv;
        Enumeration<URL> enumeration = $this$toClasspathRoots.getResources("");
        Intrinsics.checkNotNullExpressionValue(enumeration, "");
        ArrayList<URL> arrayList = Collections.list(enumeration);
        Intrinsics.checkNotNullExpressionValue(arrayList, "");
        Object object = arrayList;
        Collection destination$iv$iv = new ArrayList();
        $this$mapNotNullTo$iv$iv = $this$mapNotNullTo$iv$iv.iterator();
        while ($this$mapNotNullTo$iv$iv.hasNext()) {
            Object t2 = $this$mapNotNullTo$iv$iv.next();
            Object t3 = t2;
            t3 = t2;
            it = (URL)t2;
            Intrinsics.checkNotNull(it);
            if (this.toFileRoot(it) == null) continue;
            destination$iv$iv.add(it$iv$iv);
        }
        Collection collection2 = (List)destination$iv$iv;
        Enumeration<URL> enumeration2 = ((ClassLoader)((Object)collection)).getResources("META-INF/MANIFEST.MF");
        Intrinsics.checkNotNullExpressionValue(enumeration2, "");
        ArrayList<URL> arrayList2 = Collections.list(enumeration2);
        Intrinsics.checkNotNullExpressionValue(arrayList2, "");
        Iterable $this$mapNotNull$iv = arrayList2;
        collection = collection2;
        destination$iv$iv = new ArrayList();
        object = object.iterator();
        while (object.hasNext()) {
            Object e2 = object.next();
            it$iv$iv = e2;
            it$iv$iv = e2;
            it = (URL)e2;
            Intrinsics.checkNotNull(it);
            Pair<FileSystem, Path> pair = this.toJarRoot(it);
            if (pair == null) continue;
            it$iv$iv = pair;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.plus(collection, (Iterable)((List)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<FileSystem, Path> toFileRoot(URL $this$toFileRoot) {
        void var1_1;
        if (!Intrinsics.areEqual($this$toFileRoot.getProtocol(), "file")) {
            return null;
        }
        return TuplesKt.to(this.systemFileSystem, Path.Companion.get$default(Path.Companion, new File(var1_1.toURI()), false, 1, null));
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<FileSystem, Path> toJarRoot(URL $this$toJarRoot) {
        void var2_2;
        Object object;
        String string = $this$toJarRoot.toString();
        Intrinsics.checkNotNullExpressionValue(string, "");
        String urlString = string;
        if (!StringsKt.startsWith$default(string, "jar:file:", false, 2, null)) {
            return null;
        }
        int suffixStart = StringsKt.lastIndexOf$default((CharSequence)urlString, "!", 0, false, 6, null);
        if (suffixStart == -1) {
            return null;
        }
        String string2 = ((String)object).substring(4, (int)var2_2);
        Intrinsics.checkNotNullExpressionValue(string2, "");
        object = Path.Companion.get$default(Path.Companion, new File(URI.create(string2)), false, 1, null);
        object = ZipFilesKt.openZip((Path)object, this.systemFileSystem, toJarRoot.zip.1.INSTANCE);
        return TuplesKt.to(object, ROOT);
    }

    public static final /* synthetic */ Companion access$getCompanion$p() {
        return Companion;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ List access$toClasspathRoots(ResourceFileSystem $this, ClassLoader $receiver) {
        void var1_1;
        return $this.toClasspathRoots((ClassLoader)var1_1);
    }

    public static final /* synthetic */ ClassLoader access$getClassLoader$p(ResourceFileSystem $this) {
        return $this.classLoader;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0002J\u0012\u0010\n\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lokio/internal/ResourceFileSystem$Companion;", "", "()V", "ROOT", "Lokio/Path;", "getROOT", "()Lokio/Path;", "keepPath", "", "path", "removeBase", "base", "okio"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Path getROOT() {
            return ROOT;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Path removeBase(@NotNull Path $this$removeBase, @NotNull Path base) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter($this$removeBase, "");
            Intrinsics.checkNotNullParameter(base, "");
            String prefix = base.toString();
            return this.getROOT().resolve(StringsKt.replace$default(StringsKt.removePrefix(var1_1.toString(), (CharSequence)var2_2), '\\', '/', false, 4, null));
        }

        private final boolean keepPath(Path path) {
            return !StringsKt.endsWith(path.name(), ".class", true);
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ boolean access$keepPath(Companion $this, Path path) {
            void var1_1;
            return $this.keepPath((Path)var1_1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

