/*
 * Decompiled with CFR 0.152.
 */
package okio.internal;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.-Base64;
import okio.-SegmentedByteString;
import okio.Buffer;
import okio.ByteString;
import okio._JvmPlatformKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002\u001a\u0011\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0080\b\u001a\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\r\u0010\u0011\u001a\u00020\u0012*\u00020\fH\u0080\b\u001a\r\u0010\u0013\u001a\u00020\u0012*\u00020\fH\u0080\b\u001a\u0015\u0010\u0014\u001a\u00020\u0007*\u00020\f2\u0006\u0010\u0015\u001a\u00020\fH\u0080\b\u001a-\u0010\u0016\u001a\u00020\u0017*\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0007H\u0080\b\u001a\u000f\u0010\u001c\u001a\u0004\u0018\u00010\f*\u00020\u0012H\u0080\b\u001a\r\u0010\u001d\u001a\u00020\f*\u00020\u0012H\u0080\b\u001a\r\u0010\u001e\u001a\u00020\f*\u00020\u0012H\u0080\b\u001a\u0015\u0010\u001f\u001a\u00020 *\u00020\f2\u0006\u0010!\u001a\u00020\tH\u0080\b\u001a\u0015\u0010\u001f\u001a\u00020 *\u00020\f2\u0006\u0010!\u001a\u00020\fH\u0080\b\u001a\u0017\u0010\"\u001a\u00020 *\u00020\f2\b\u0010\u0015\u001a\u0004\u0018\u00010#H\u0080\b\u001a\u0015\u0010$\u001a\u00020%*\u00020\f2\u0006\u0010&\u001a\u00020\u0007H\u0080\b\u001a\r\u0010'\u001a\u00020\u0007*\u00020\fH\u0080\b\u001a\r\u0010(\u001a\u00020\u0007*\u00020\fH\u0080\b\u001a\r\u0010)\u001a\u00020\u0012*\u00020\fH\u0080\b\u001a\u001d\u0010*\u001a\u00020\u0007*\u00020\f2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010+\u001a\u00020\u0007H\u0080\b\u001a\r\u0010,\u001a\u00020\t*\u00020\fH\u0080\b\u001a\u001d\u0010-\u001a\u00020\u0007*\u00020\f2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010+\u001a\u00020\u0007H\u0080\b\u001a\u001d\u0010-\u001a\u00020\u0007*\u00020\f2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010+\u001a\u00020\u0007H\u0080\b\u001a-\u0010.\u001a\u00020 *\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010/\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0007H\u0080\b\u001a-\u0010.\u001a\u00020 *\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010/\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0007H\u0080\b\u001a\u0015\u00100\u001a\u00020 *\u00020\f2\u0006\u00101\u001a\u00020\tH\u0080\b\u001a\u0015\u00100\u001a\u00020 *\u00020\f2\u0006\u00101\u001a\u00020\fH\u0080\b\u001a\u001d\u00102\u001a\u00020\f*\u00020\f2\u0006\u00103\u001a\u00020\u00072\u0006\u00104\u001a\u00020\u0007H\u0080\b\u001a\r\u00105\u001a\u00020\f*\u00020\fH\u0080\b\u001a\r\u00106\u001a\u00020\f*\u00020\fH\u0080\b\u001a\r\u00107\u001a\u00020\t*\u00020\fH\u0080\b\u001a\u001d\u00108\u001a\u00020\f*\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0007H\u0080\b\u001a\r\u00109\u001a\u00020\u0012*\u00020\fH\u0080\b\u001a\r\u0010:\u001a\u00020\u0012*\u00020\fH\u0080\b\u001a$\u0010;\u001a\u00020\u0017*\u00020\f2\u0006\u0010<\u001a\u00020=2\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0007H\u0000\"\u001c\u0010\u0000\u001a\u00020\u00018\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0002\u0010\u0003\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006>"}, d2={"HEX_DIGIT_CHARS", "", "getHEX_DIGIT_CHARS$annotations", "()V", "getHEX_DIGIT_CHARS", "()[C", "codePointIndexToCharIndex", "", "s", "", "codePointCount", "commonOf", "Lokio/ByteString;", "data", "decodeHexDigit", "c", "", "commonBase64", "", "commonBase64Url", "commonCompareTo", "other", "commonCopyInto", "", "offset", "target", "targetOffset", "byteCount", "commonDecodeBase64", "commonDecodeHex", "commonEncodeUtf8", "commonEndsWith", "", "suffix", "commonEquals", "", "commonGetByte", "", "pos", "commonGetSize", "commonHashCode", "commonHex", "commonIndexOf", "fromIndex", "commonInternalArray", "commonLastIndexOf", "commonRangeEquals", "otherOffset", "commonStartsWith", "prefix", "commonSubstring", "beginIndex", "endIndex", "commonToAsciiLowercase", "commonToAsciiUppercase", "commonToByteArray", "commonToByteString", "commonToString", "commonUtf8", "commonWrite", "buffer", "Lokio/Buffer;", "okio"})
@JvmName(name="-ByteString")
@SourceDebugExtension(value={"SMAP\nByteString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteString.kt\nokio/internal/-ByteString\n+ 2 Util.kt\nokio/-SegmentedByteString\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Utf8.kt\nokio/Utf8\n*L\n1#1,363:1\n131#1,2:369\n133#1,9:372\n68#2:364\n74#2:365\n74#2:367\n74#2:368\n68#2:396\n74#2:408\n1#3:366\n1#3:371\n212#4,7:381\n122#4:388\n219#4,5:389\n122#4:394\n226#4:395\n228#4:397\n397#4,2:398\n122#4:400\n400#4,6:401\n127#4:407\n406#4:409\n122#4:410\n407#4,13:411\n122#4:424\n422#4:425\n122#4:426\n425#4:427\n230#4,3:428\n440#4,3:431\n122#4:434\n443#4:435\n127#4:436\n446#4,10:437\n127#4:447\n456#4:448\n122#4:449\n457#4,4:450\n127#4:454\n461#4:455\n122#4:456\n462#4,14:457\n122#4:471\n477#4,2:472\n122#4:474\n481#4:475\n122#4:476\n484#4:477\n234#4,3:478\n500#4,3:481\n122#4:484\n503#4:485\n127#4:486\n506#4,2:487\n127#4:489\n510#4,10:490\n127#4:500\n520#4:501\n122#4:502\n521#4,4:503\n127#4:507\n525#4:508\n122#4:509\n526#4,4:510\n127#4:514\n530#4:515\n122#4:516\n531#4,15:517\n122#4:532\n547#4,2:533\n122#4:535\n550#4,2:536\n122#4:538\n554#4:539\n122#4:540\n557#4:541\n241#4:542\n122#4:543\n242#4,5:544\n*S KotlinDebug\n*F\n+ 1 ByteString.kt\nokio/internal/-ByteString\n*L\n329#1:369,2\n329#1:372,9\n67#1:364\n68#1:365\n258#1:367\n259#1:368\n348#1:396\n348#1:408\n329#1:371\n348#1:381,7\n353#1:388\n348#1:389,5\n353#1:394\n348#1:395\n348#1:397\n348#1:398,2\n353#1:400\n348#1:401,6\n348#1:407\n348#1:409\n353#1:410\n348#1:411,13\n353#1:424\n348#1:425\n353#1:426\n348#1:427\n348#1:428,3\n348#1:431,3\n353#1:434\n348#1:435\n348#1:436\n348#1:437,10\n348#1:447\n348#1:448\n353#1:449\n348#1:450,4\n348#1:454\n348#1:455\n353#1:456\n348#1:457,14\n353#1:471\n348#1:472,2\n353#1:474\n348#1:475\n353#1:476\n348#1:477\n348#1:478,3\n348#1:481,3\n353#1:484\n348#1:485\n348#1:486\n348#1:487,2\n348#1:489\n348#1:490,10\n348#1:500\n348#1:501\n353#1:502\n348#1:503,4\n348#1:507\n348#1:508\n353#1:509\n348#1:510,4\n348#1:514\n348#1:515\n353#1:516\n348#1:517,15\n353#1:532\n348#1:533,2\n353#1:535\n348#1:536,2\n353#1:538\n348#1:539\n353#1:540\n348#1:541\n348#1:542\n353#1:543\n348#1:544,5\n*E\n"})
public final class -ByteString {
    @NotNull
    private static final char[] HEX_DIGIT_CHARS;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String commonUtf8(@NotNull ByteString $this$commonUtf8) {
        void var1_1;
        Intrinsics.checkNotNullParameter($this$commonUtf8, "");
        String result = $this$commonUtf8.getUtf8$okio();
        if (result == null) {
            ByteString byteString;
            result = _JvmPlatformKt.toUtf8String($this$commonUtf8.internalArray$okio());
            byteString.setUtf8$okio(result);
        }
        return var1_1;
    }

    @NotNull
    public static final String commonBase64(@NotNull ByteString $this$commonBase64) {
        ByteString byteString;
        Intrinsics.checkNotNullParameter($this$commonBase64, "");
        return -Base64.encodeBase64$default(byteString.getData$okio(), null, 1, null);
    }

    @NotNull
    public static final String commonBase64Url(@NotNull ByteString $this$commonBase64Url) {
        ByteString byteString;
        Intrinsics.checkNotNullParameter($this$commonBase64Url, "");
        return -Base64.encodeBase64(byteString.getData$okio(), -Base64.getBASE64_URL_SAFE());
    }

    @NotNull
    public static final char[] getHEX_DIGIT_CHARS() {
        return HEX_DIGIT_CHARS;
    }

    public static /* synthetic */ void getHEX_DIGIT_CHARS$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String commonHex(@NotNull ByteString $this$commonHex) {
        void var1_1;
        Object object;
        Intrinsics.checkNotNullParameter($this$commonHex, "");
        char[] result = new char[$this$commonHex.getData$okio().length << 1];
        int c2 = 0;
        for (Object b2 : (Object)((ByteString)object).getData$okio()) {
            int n2 = c2++;
            Object object2 = b2;
            result[n2] = -ByteString.getHEX_DIGIT_CHARS()[object2 >> 4 & 0xF];
            int n3 = c2++;
            object2 = b2;
            result[n3] = -ByteString.getHEX_DIGIT_CHARS()[object2 & 0xF];
        }
        return StringsKt.concatToString((char[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ByteString commonToAsciiLowercase(@NotNull ByteString $this$commonToAsciiLowercase) {
        Object object;
        Intrinsics.checkNotNullParameter($this$commonToAsciiLowercase, "");
        for (int i2 = 0; i2 < $this$commonToAsciiLowercase.getData$okio().length; ++i2) {
            Object c2 = $this$commonToAsciiLowercase.getData$okio()[i2];
            if (c2 < 65 || c2 > 90) {
                continue;
            }
            byte[] byArray = $this$commonToAsciiLowercase.getData$okio();
            byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
            Intrinsics.checkNotNullExpressionValue(byArray2, "");
            Object lowercase = byArray2;
            byArray2[i2++] = (byte)(c2 - -32);
            while (i2 < ((Object)lowercase).length) {
                void var2_2;
                Object object2 = lowercase[i2];
                c2 = object2;
                if (object2 < 65 || c2 > 90) {
                    ++i2;
                    continue;
                }
                lowercase[i2] = (byte)(var2_2 - -32);
                ++i2;
            }
            return new ByteString((byte[])object);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ByteString commonToAsciiUppercase(@NotNull ByteString $this$commonToAsciiUppercase) {
        Object object;
        Intrinsics.checkNotNullParameter($this$commonToAsciiUppercase, "");
        for (int i2 = 0; i2 < $this$commonToAsciiUppercase.getData$okio().length; ++i2) {
            Object c2 = $this$commonToAsciiUppercase.getData$okio()[i2];
            if (c2 < 97 || c2 > 122) {
                continue;
            }
            byte[] byArray = $this$commonToAsciiUppercase.getData$okio();
            byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
            Intrinsics.checkNotNullExpressionValue(byArray2, "");
            Object lowercase = byArray2;
            byArray2[i2++] = (byte)(c2 - 32);
            while (i2 < ((Object)lowercase).length) {
                void var2_2;
                Object object2 = lowercase[i2];
                c2 = object2;
                if (object2 < 97 || c2 > 122) {
                    ++i2;
                    continue;
                }
                lowercase[i2] = (byte)(var2_2 - 32);
                ++i2;
            }
            return new ByteString((byte[])object);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ByteString commonSubstring(@NotNull ByteString $this$commonSubstring, int beginIndex, int endIndex) {
        void var2_2;
        void var1_1;
        Object object;
        Intrinsics.checkNotNullParameter($this$commonSubstring, "");
        endIndex = -SegmentedByteString.resolveDefaultParameter((ByteString)$this$commonSubstring, endIndex);
        if (!(beginIndex >= 0)) {
            $this$commonSubstring = "beginIndex < 0";
            throw new IllegalArgumentException($this$commonSubstring.toString());
        }
        if (!(endIndex <= ((ByteString)$this$commonSubstring).getData$okio().length)) {
            $this$commonSubstring = "endIndex > length(" + ((ByteString)$this$commonSubstring).getData$okio().length + ')';
            throw new IllegalArgumentException($this$commonSubstring.toString());
        }
        int n2 = endIndex - beginIndex;
        if (!(n2 >= 0)) {
            $this$commonSubstring = "endIndex < beginIndex";
            throw new IllegalArgumentException($this$commonSubstring.toString());
        }
        if (beginIndex == 0 && endIndex == ((ByteString)$this$commonSubstring).getData$okio().length) {
            return $this$commonSubstring;
        }
        byte[] byArray = ((ByteString)object).getData$okio();
        object = byArray;
        return new ByteString(ArraysKt.copyOfRange(byArray, (int)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static final byte commonGetByte(@NotNull ByteString $this$commonGetByte, int pos) {
        void var1_1;
        ByteString byteString;
        Intrinsics.checkNotNullParameter($this$commonGetByte, "");
        return byteString.getData$okio()[var1_1];
    }

    public static final int commonGetSize(@NotNull ByteString $this$commonGetSize) {
        ByteString byteString;
        Intrinsics.checkNotNullParameter($this$commonGetSize, "");
        return byteString.getData$okio().length;
    }

    @NotNull
    public static final byte[] commonToByteArray(@NotNull ByteString $this$commonToByteArray) {
        ByteString byteString;
        Intrinsics.checkNotNullParameter($this$commonToByteArray, "");
        byte[] byArray = byteString.getData$okio();
        byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
        Intrinsics.checkNotNullExpressionValue(byArray2, "");
        return byArray2;
    }

    @NotNull
    public static final byte[] commonInternalArray(@NotNull ByteString $this$commonInternalArray) {
        ByteString byteString;
        Intrinsics.checkNotNullParameter($this$commonInternalArray, "");
        return byteString.getData$okio();
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean commonRangeEquals(@NotNull ByteString $this$commonRangeEquals, int offset, @NotNull ByteString other, int otherOffset, int byteCount) {
        void var1_1;
        ByteString byteString;
        void var3_3;
        void var2_2;
        Intrinsics.checkNotNullParameter($this$commonRangeEquals, "");
        Intrinsics.checkNotNullParameter(other, "");
        return var2_2.rangeEquals((int)var3_3, byteString.getData$okio(), (int)var1_1, byteCount);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean commonRangeEquals(@NotNull ByteString $this$commonRangeEquals, int offset, @NotNull byte[] other, int otherOffset, int byteCount) {
        void var3_3;
        void var2_2;
        void var1_1;
        ByteString byteString;
        Intrinsics.checkNotNullParameter($this$commonRangeEquals, "");
        Intrinsics.checkNotNullParameter(other, "");
        return offset >= 0 && offset <= $this$commonRangeEquals.getData$okio().length - byteCount && otherOffset >= 0 && otherOffset <= other.length - byteCount && -SegmentedByteString.arrayRangeEquals(byteString.getData$okio(), (int)var1_1, (byte[])var2_2, (int)var3_3, byteCount);
    }

    /*
     * WARNING - void declaration
     */
    public static final void commonCopyInto(@NotNull ByteString $this$commonCopyInto, int offset, @NotNull byte[] target, int targetOffset, int byteCount) {
        void var3_3;
        void var2_2;
        ByteString byteString;
        void var1_1;
        Intrinsics.checkNotNullParameter($this$commonCopyInto, "");
        Intrinsics.checkNotNullParameter(target, "");
        void v0 = var1_1;
        ArraysKt.copyInto(byteString.getData$okio(), (byte[])var2_2, (int)var3_3, (int)v0, (int)(v0 + byteCount));
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean commonStartsWith(@NotNull ByteString $this$commonStartsWith, @NotNull ByteString prefix) {
        void var1_1;
        ByteString byteString;
        Intrinsics.checkNotNullParameter($this$commonStartsWith, "");
        Intrinsics.checkNotNullParameter(prefix, "");
        return byteString.rangeEquals(0, prefix, 0, var1_1.size());
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean commonStartsWith(@NotNull ByteString $this$commonStartsWith, @NotNull byte[] prefix) {
        void var1_1;
        ByteString byteString;
        Intrinsics.checkNotNullParameter($this$commonStartsWith, "");
        Intrinsics.checkNotNullParameter(prefix, "");
        return byteString.rangeEquals(0, prefix, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean commonEndsWith(@NotNull ByteString $this$commonEndsWith, @NotNull ByteString suffix) {
        void var1_1;
        ByteString byteString;
        Intrinsics.checkNotNullParameter($this$commonEndsWith, "");
        Intrinsics.checkNotNullParameter(suffix, "");
        ByteString byteString2 = byteString;
        return byteString2.rangeEquals(byteString2.size() - suffix.size(), suffix, 0, var1_1.size());
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean commonEndsWith(@NotNull ByteString $this$commonEndsWith, @NotNull byte[] suffix) {
        void var1_1;
        ByteString byteString;
        Intrinsics.checkNotNullParameter($this$commonEndsWith, "");
        Intrinsics.checkNotNullParameter(suffix, "");
        ByteString byteString2 = byteString;
        return byteString2.rangeEquals(byteString2.size() - suffix.length, suffix, 0, ((void)var1_1).length);
    }

    public static final int commonIndexOf(@NotNull ByteString $this$commonIndexOf, @NotNull byte[] other, int fromIndex) {
        Intrinsics.checkNotNullParameter($this$commonIndexOf, "");
        Intrinsics.checkNotNullParameter(other, "");
        int limit = $this$commonIndexOf.getData$okio().length - other.length;
        int i2 = Math.max(fromIndex, 0);
        if (i2 <= limit) {
            while (true) {
                if (-SegmentedByteString.arrayRangeEquals($this$commonIndexOf.getData$okio(), i2, other, 0, other.length)) {
                    return i2;
                }
                if (i2 == limit) break;
                ++i2;
            }
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static final int commonLastIndexOf(@NotNull ByteString $this$commonLastIndexOf, @NotNull ByteString other, int fromIndex) {
        void var2_2;
        void var1_1;
        ByteString byteString;
        Intrinsics.checkNotNullParameter($this$commonLastIndexOf, "");
        Intrinsics.checkNotNullParameter(other, "");
        return byteString.lastIndexOf(var1_1.internalArray$okio(), (int)var2_2);
    }

    public static final int commonLastIndexOf(@NotNull ByteString $this$commonLastIndexOf, @NotNull byte[] other, int fromIndex) {
        Intrinsics.checkNotNullParameter($this$commonLastIndexOf, "");
        Intrinsics.checkNotNullParameter(other, "");
        fromIndex = -SegmentedByteString.resolveDefaultParameter($this$commonLastIndexOf, fromIndex);
        int limit = $this$commonLastIndexOf.getData$okio().length - other.length;
        for (int i2 = Math.min(fromIndex, (int)var3_3); i2 >= 0; --i2) {
            if (!-SegmentedByteString.arrayRangeEquals($this$commonLastIndexOf.getData$okio(), i2, other, 0, other.length)) continue;
            return i2;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean commonEquals(@NotNull ByteString $this$commonEquals, @Nullable Object other) {
        Intrinsics.checkNotNullParameter($this$commonEquals, "");
        if (other == $this$commonEquals) {
            return true;
        }
        if (other instanceof ByteString) {
            ByteString byteString;
            void var1_1;
            return ((ByteString)other).size() == $this$commonEquals.getData$okio().length && ((ByteString)var1_1).rangeEquals(0, $this$commonEquals.getData$okio(), 0, byteString.getData$okio().length);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static final int commonHashCode(@NotNull ByteString $this$commonHashCode) {
        void var2_2;
        ByteString byteString;
        int n2;
        Intrinsics.checkNotNullParameter($this$commonHashCode, "");
        int result = $this$commonHashCode.getHashCode$okio();
        if (result != 0) {
            return n2;
        }
        int it = n2 = Arrays.hashCode($this$commonHashCode.getData$okio());
        byteString.setHashCode$okio((int)var2_2);
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    public static final int commonCompareTo(@NotNull ByteString $this$commonCompareTo, @NotNull ByteString other) {
        void var3_3;
        void var2_2;
        Intrinsics.checkNotNullParameter($this$commonCompareTo, "");
        Intrinsics.checkNotNullParameter(other, "");
        int sizeA = $this$commonCompareTo.size();
        int sizeB = other.size();
        int size = Math.min(sizeA, sizeB);
        for (int i2 = 0; i2 < size; ++i2) {
            byte by = $this$commonCompareTo.getByte(i2);
            int byteA = by & 0xFF;
            int byteB = (by = other.getByte(i2)) & 0xFF;
            if (byteA == byteB) {
                continue;
            }
            if (byteA < byteB) {
                return -1;
            }
            return 1;
        }
        if (sizeA == sizeB) {
            return 0;
        }
        if (var2_2 < var3_3) {
            return -1;
        }
        return 1;
    }

    @NotNull
    public static final ByteString commonOf(@NotNull byte[] data) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter(data, "");
        byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
        Intrinsics.checkNotNullExpressionValue(byArray2, "");
        return new ByteString(byArray2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ByteString commonToByteString(@NotNull byte[] $this$commonToByteString, int offset, int byteCount) {
        void var1_1;
        byte[] byArray;
        int n2;
        Intrinsics.checkNotNullParameter($this$commonToByteString, "");
        byteCount = -SegmentedByteString.resolveDefaultParameter($this$commonToByteString, byteCount);
        -SegmentedByteString.checkOffsetAndCount($this$commonToByteString.length, offset, byteCount);
        n2 = offset + n2;
        return new ByteString(ArraysKt.copyOfRange(byArray, (int)var1_1, n2));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ByteString commonEncodeUtf8(@NotNull String $this$commonEncodeUtf8) {
        void var1_1;
        String string;
        Intrinsics.checkNotNullParameter($this$commonEncodeUtf8, "");
        ByteString byteString = new ByteString(_JvmPlatformKt.asUtf8ToByteArray($this$commonEncodeUtf8));
        byteString.setUtf8$okio(string);
        return var1_1;
    }

    @Nullable
    public static final ByteString commonDecodeBase64(@NotNull String $this$commonDecodeBase64) {
        Intrinsics.checkNotNullParameter($this$commonDecodeBase64, "");
        byte[] byArray = -Base64.decodeBase64ToArray($this$commonDecodeBase64);
        Object decoded = byArray;
        if (byArray != null) {
            Object object;
            return new ByteString((byte[])object);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ByteString commonDecodeHex(@NotNull String $this$commonDecodeHex) {
        void var1_3;
        Intrinsics.checkNotNullParameter($this$commonDecodeHex, "");
        if (!($this$commonDecodeHex.length() % 2 == 0)) {
            String string = "Unexpected hex string: " + $this$commonDecodeHex;
            throw new IllegalArgumentException(string.toString());
        }
        byte[] result = new byte[$this$commonDecodeHex.length() / 2];
        int n2 = result.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int d1 = -ByteString.decodeHexDigit($this$commonDecodeHex.charAt(i2 << 1)) << 4;
            int d2 = -ByteString.decodeHexDigit($this$commonDecodeHex.charAt((i2 << 1) + 1));
            result[i2] = (byte)(d1 + d2);
        }
        return new ByteString((byte[])var1_3);
    }

    /*
     * WARNING - void declaration
     */
    public static final void commonWrite(@NotNull ByteString $this$commonWrite, @NotNull Buffer buffer, int offset, int byteCount) {
        void var3_3;
        void var2_2;
        ByteString byteString;
        void var1_1;
        Intrinsics.checkNotNullParameter($this$commonWrite, "");
        Intrinsics.checkNotNullParameter(buffer, "");
        var1_1.write(byteString.getData$okio(), (int)var2_2, (int)var3_3);
    }

    private static final int decodeHexDigit(char c2) {
        char c3;
        char c4 = c2;
        boolean bl = '0' <= c4 ? c4 < ':' : false;
        if (bl) {
            return c2 - 48;
        }
        boolean bl2 = 'a' <= c4 ? c4 < 'g' : false;
        if (bl2) {
            return c2 - 97 + 10;
        }
        boolean bl3 = 'A' <= c4 ? c4 < 'G' : false;
        if (bl3) {
            return c2 - 65 + 10;
        }
        throw new IllegalArgumentException("Unexpected hex digit: " + c3);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String commonToString(@NotNull ByteString $this$commonToString) {
        void var3_8;
        void var2_7;
        void var1_3;
        ByteString byteString;
        Intrinsics.checkNotNullParameter($this$commonToString, "");
        if ($this$commonToString.getData$okio().length == 0) {
            return "[size=0]";
        }
        int i22 = -ByteString.access$codePointIndexToCharIndex($this$commonToString.getData$okio(), 64);
        if (i22 == -1) {
            ByteString byteString2;
            if ($this$commonToString.getData$okio().length <= 64) {
                return "[hex=" + $this$commonToString.hex() + ']';
            }
            StringBuilder stringBuilder = new StringBuilder("[size=").append($this$commonToString.getData$okio().length).append(" hex=");
            ByteString $this$commonSubstring$iv = $this$commonToString;
            int endIndex$iv2 = -SegmentedByteString.resolveDefaultParameter($this$commonSubstring$iv, 64);
            if (!(endIndex$iv2 <= $this$commonSubstring$iv.getData$okio().length)) {
                String i22 = "endIndex > length(" + $this$commonSubstring$iv.getData$okio().length + ')';
                throw new IllegalArgumentException(i22.toString());
            }
            i22 = endIndex$iv2;
            if (!(i22 >= 0)) {
                String endIndex$iv2 = "endIndex < beginIndex";
                throw new IllegalArgumentException(endIndex$iv2.toString());
            }
            if (endIndex$iv2 == $this$commonSubstring$iv.getData$okio().length) {
                byteString2 = $this$commonSubstring$iv;
            } else {
                void var0_1;
                byte[] i22 = $this$commonSubstring$iv.getData$okio();
                ByteString byteString3 = new ByteString(ArraysKt.copyOfRange(i22, 0, (int)var0_1));
                byteString2 = byteString3;
            }
            return stringBuilder.append(byteString2.hex()).append("\u2026]").toString();
        }
        String text = byteString.utf8();
        String string = text.substring(0, i22);
        Intrinsics.checkNotNullExpressionValue(string, "");
        String safeText = StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(string, "\\", "\\\\", false, 4, null), "\n", "\\n", false, 4, null), "\r", "\\r", false, 4, null);
        if (var1_3 < var2_7.length()) {
            return "[size=" + byteString.getData$okio().length + " text=" + safeText + "\u2026]";
        }
        return "[text=" + (String)var3_8 + ']';
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final int codePointIndexToCharIndex(byte[] s2, int codePointCount) {
        void var1_2;
        void var3_4;
        int n2;
        int charCount;
        block71: {
            void var2_3;
            charCount = 0;
            int j2 = 0;
            byte[] byArray = s2;
            int endIndex$iv = s2.length;
            int index$iv = 0;
            block0: while (index$iv < endIndex$iv) {
                int $this$process3Utf8Bytes$iv$iv22;
                int codePoint$iv$iv;
                void b2$iv$iv;
                int $this$process2Utf8Bytes$iv$iv22;
                int it$iv;
                void var10_29;
                int b1$iv$iv;
                void b0$iv$iv;
                int c2;
                void $this$processUtf8CodePoints$iv;
                void b0$iv = $this$processUtf8CodePoints$iv[index$iv];
                if (b0$iv >= 0) {
                    c2 = b0$iv;
                    n2 = j2;
                    j2 = n2 + 1;
                    if (n2 == codePointCount) {
                        return charCount;
                    }
                    if (c2 != 10 && c2 != 13) {
                        boolean bl;
                        boolean bl2;
                        if (c2 >= 0) {
                            if (c2 < 32) {
                                return -1;
                            }
                            bl2 = false;
                        } else {
                            bl2 = false;
                        }
                        if (bl2) return -1;
                        if (127 <= c2) {
                            if (c2 < 160) {
                                return -1;
                            }
                            bl = false;
                        } else {
                            bl = false;
                        }
                        if (bl) {
                            return -1;
                        }
                        boolean bl3 = false;
                        if (bl3) return -1;
                    }
                    if (c2 == 65533) {
                        return -1;
                    }
                    charCount += c2 < 65536 ? 1 : 2;
                    ++index$iv;
                    while (true) {
                        if (index$iv >= endIndex$iv || $this$processUtf8CodePoints$iv[index$iv] < 0) continue block0;
                        c2 = $this$processUtf8CodePoints$iv[index$iv++];
                        n2 = j2;
                        j2 = n2 + 1;
                        if (n2 == codePointCount) {
                            return charCount;
                        }
                        if (c2 != 10 && c2 != 13) {
                            boolean bl;
                            boolean bl4;
                            if (c2 >= 0) {
                                if (c2 < 32) {
                                    return -1;
                                }
                                bl4 = false;
                            } else {
                                bl4 = false;
                            }
                            if (bl4) return -1;
                            if (127 <= c2) {
                                if (c2 < 160) {
                                    return -1;
                                }
                                bl = false;
                            } else {
                                bl = false;
                            }
                            if (bl) {
                                return -1;
                            }
                            boolean bl5 = false;
                            if (bl5) return -1;
                        }
                        if (c2 == 65533) {
                            return -1;
                        }
                        charCount += c2 < 65536 ? 1 : 2;
                    }
                }
                n2 = c2;
                if (n2 >> 5 == -2) {
                    int n3 = index$iv;
                    void $this$process2Utf8Bytes$iv$iv22 = $this$processUtf8CodePoints$iv;
                    if (endIndex$iv <= index$iv + 1) {
                        int $this$process2Utf8Bytes$iv$iv22 = j2;
                        if ($this$process2Utf8Bytes$iv$iv22 != codePointCount) return -1;
                        return charCount;
                    }
                    b0$iv$iv = $this$process2Utf8Bytes$iv$iv22[index$iv];
                    b1$iv$iv = $this$process2Utf8Bytes$iv$iv22[index$iv + 1];
                    var10_29 = b1$iv$iv;
                    if (!((b1$iv$iv & 0xC0) == 128)) {
                        int $this$process2Utf8Bytes$iv$iv22 = j2;
                        if ($this$process2Utf8Bytes$iv$iv22 != codePointCount) return -1;
                        return charCount;
                    }
                    int codePoint$iv$iv2 = 0xF80 ^ b1$iv$iv ^ b0$iv$iv << 6;
                    if (codePoint$iv$iv2 < 128) {
                        int $this$process2Utf8Bytes$iv$iv22 = j2;
                        if ($this$process2Utf8Bytes$iv$iv22 != codePointCount) return -1;
                        return charCount;
                    }
                    index$iv = codePoint$iv$iv2;
                    b1$iv$iv = n3;
                    c2 = it$iv;
                    $this$process2Utf8Bytes$iv$iv22 = j2;
                    j2 = $this$process2Utf8Bytes$iv$iv22 + 1;
                    if ($this$process2Utf8Bytes$iv$iv22 == codePointCount) {
                        return charCount;
                    }
                    if (c2 != 10 && c2 != 13) {
                        boolean bl;
                        boolean bl6;
                        if (c2 >= 0) {
                            if (c2 < 32) {
                                return -1;
                            }
                            bl6 = false;
                        } else {
                            bl6 = false;
                        }
                        if (bl6) return -1;
                        if (127 <= c2) {
                            if (c2 < 160) {
                                return -1;
                            }
                            bl = false;
                        } else {
                            bl = false;
                        }
                        if (bl) {
                            return -1;
                        }
                        boolean bl7 = false;
                        if (bl7) return -1;
                    }
                    if (c2 == 65533) {
                        return -1;
                    }
                    charCount += c2 < 65536 ? 1 : 2;
                    it$iv = b1$iv$iv + 2;
                    continue;
                }
                $this$process2Utf8Bytes$iv$iv22 = c2;
                if ($this$process2Utf8Bytes$iv$iv22 >> 4 == -2) {
                    void v10 = it$iv;
                    void $this$process3Utf8Bytes$iv$iv22 = $this$processUtf8CodePoints$iv;
                    if (endIndex$iv <= it$iv + 2) {
                        int $this$process3Utf8Bytes$iv$iv22 = j2;
                        if ($this$process3Utf8Bytes$iv$iv22 != codePointCount) return -1;
                        return charCount;
                    }
                    b0$iv$iv = $this$process3Utf8Bytes$iv$iv22[it$iv];
                    b1$iv$iv = $this$process3Utf8Bytes$iv$iv22[it$iv + true];
                    var10_29 = b1$iv$iv;
                    if (!((b1$iv$iv & 0xC0) == 128)) {
                        int $this$process3Utf8Bytes$iv$iv22 = j2;
                        if ($this$process3Utf8Bytes$iv$iv22 != codePointCount) return -1;
                        return charCount;
                    }
                    var10_29 = b2$iv$iv = $this$process3Utf8Bytes$iv$iv22[it$iv + 2];
                    if (!((b2$iv$iv & 0xC0) == 128)) {
                        int $this$process3Utf8Bytes$iv$iv22 = j2;
                        if ($this$process3Utf8Bytes$iv$iv22 != codePointCount) return -1;
                        return charCount;
                    }
                    codePoint$iv$iv = 0xFFFE1F80 ^ b2$iv$iv ^ b1$iv$iv << 6 ^ b0$iv$iv << 12;
                    if (codePoint$iv$iv < 2048) {
                        int $this$process3Utf8Bytes$iv$iv22 = j2;
                        if ($this$process3Utf8Bytes$iv$iv22 != codePointCount) return -1;
                        return charCount;
                    }
                    boolean bl = 55296 <= codePoint$iv$iv ? codePoint$iv$iv < 57344 : false;
                    if (bl) {
                        int $this$process3Utf8Bytes$iv$iv22 = j2;
                        if ($this$process3Utf8Bytes$iv$iv22 != codePointCount) return -1;
                        return charCount;
                    }
                    it$iv = codePoint$iv$iv;
                    b1$iv$iv = v10;
                    c2 = it$iv;
                    $this$process3Utf8Bytes$iv$iv22 = j2;
                    j2 = $this$process3Utf8Bytes$iv$iv22 + 1;
                    if ($this$process3Utf8Bytes$iv$iv22 == codePointCount) {
                        return charCount;
                    }
                    if (c2 != 10 && c2 != 13) {
                        boolean bl8;
                        boolean bl9;
                        if (c2 >= 0) {
                            if (c2 < 32) {
                                return -1;
                            }
                            bl9 = false;
                        } else {
                            bl9 = false;
                        }
                        if (bl9) return -1;
                        if (127 <= c2) {
                            if (c2 < 160) {
                                return -1;
                            }
                            bl8 = false;
                        } else {
                            bl8 = false;
                        }
                        if (bl8) {
                            return -1;
                        }
                        boolean bl10 = false;
                        if (bl10) return -1;
                    }
                    if (c2 == 65533) {
                        return -1;
                    }
                    charCount += c2 < 65536 ? 1 : 2;
                    it$iv = b1$iv$iv + 3;
                    continue;
                }
                $this$process3Utf8Bytes$iv$iv22 = c2;
                if ($this$process3Utf8Bytes$iv$iv22 >> 3 == -2) {
                    void var8_27;
                    void $this$process4Utf8Bytes$iv$iv2 = $this$processUtf8CodePoints$iv;
                    if (endIndex$iv <= it$iv + 3) {
                        int $this$process4Utf8Bytes$iv$iv2 = j2;
                        if ($this$process4Utf8Bytes$iv$iv2 != codePointCount) return -1;
                        return charCount;
                    }
                    b0$iv$iv = $this$process4Utf8Bytes$iv$iv2[it$iv];
                    codePoint$iv$iv = b1$iv$iv = $this$process4Utf8Bytes$iv$iv2[it$iv + true];
                    if (!((b1$iv$iv & 0xC0) == 128)) {
                        int $this$process4Utf8Bytes$iv$iv2 = j2;
                        if ($this$process4Utf8Bytes$iv$iv2 != codePointCount) return -1;
                        return charCount;
                    }
                    b2$iv$iv = $this$process4Utf8Bytes$iv$iv2[it$iv + 2];
                    codePoint$iv$iv = b2$iv$iv;
                    if (!((b2$iv$iv & 0xC0) == 128)) {
                        int $this$process4Utf8Bytes$iv$iv2 = j2;
                        if ($this$process4Utf8Bytes$iv$iv2 != codePointCount) return -1;
                        return charCount;
                    }
                    void b3$iv$iv = $this$process4Utf8Bytes$iv$iv2[it$iv + 3];
                    it$iv = b3$iv$iv;
                    if (!((b3$iv$iv & 0xC0) == 128)) {
                        int n4 = j2;
                        if (n4 != codePointCount) return -1;
                        return charCount;
                    }
                    codePoint$iv$iv = 0x381F80 ^ b3$iv$iv ^ b2$iv$iv << 6 ^ b1$iv$iv << 12 ^ b0$iv$iv << 18;
                    if (codePoint$iv$iv > 0x10FFFF) {
                        int n5 = j2;
                        if (n5 != codePointCount) return -1;
                        return charCount;
                    }
                    boolean bl = 55296 <= codePoint$iv$iv ? codePoint$iv$iv < 57344 : false;
                    if (bl) {
                        int n6 = j2;
                        if (n6 != codePointCount) return -1;
                        return charCount;
                    }
                    if (codePoint$iv$iv < 65536) {
                        int n7 = j2;
                        if (n7 != codePointCount) return -1;
                        return charCount;
                    }
                    c2 = it$iv = codePoint$iv$iv;
                    n2 = j2;
                    j2 = n2 + 1;
                    if (n2 == codePointCount) {
                        return charCount;
                    }
                    if (c2 != 10 && c2 != 13) {
                        boolean bl11;
                        boolean bl12;
                        if (c2 >= 0) {
                            if (c2 < 32) {
                                return -1;
                            }
                            bl12 = false;
                        } else {
                            bl12 = false;
                        }
                        if (bl12) return -1;
                        if (127 <= c2) {
                            if (c2 < 160) {
                                return -1;
                            }
                            bl11 = false;
                        } else {
                            bl11 = false;
                        }
                        if (bl11) {
                            return -1;
                        }
                        boolean bl13 = false;
                        if (bl13) return -1;
                    }
                    if (c2 == 65533) {
                        return -1;
                    }
                    charCount += c2 < 65536 ? 1 : 2;
                    void var5_6 = var8_27 + 4;
                    continue;
                }
                break block71;
            }
            return (int)var2_3;
        }
        n2 = var3_4;
        if (n2 != var1_2) return -1;
        return charCount;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ int access$codePointIndexToCharIndex(byte[] s2, int codePointCount) {
        void var1_1;
        return -ByteString.codePointIndexToCharIndex(s2, (int)var1_1);
    }

    static {
        char[] cArray = new char[16];
        char[] cArray2 = cArray;
        cArray[0] = 48;
        cArray2[1] = 49;
        cArray2[2] = 50;
        cArray2[3] = 51;
        cArray2[4] = 52;
        cArray2[5] = 53;
        cArray2[6] = 54;
        cArray2[7] = 55;
        cArray2[8] = 56;
        cArray2[9] = 57;
        cArray2[10] = 97;
        cArray2[11] = 98;
        cArray2[12] = 99;
        cArray2[13] = 100;
        cArray2[14] = 101;
        cArray2[15] = 102;
        HEX_DIGIT_CHARS = cArray2;
    }
}

