/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import kotlin.Metadata;
import kotlin.collections.AbstractList;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Buffer;
import okio.ByteString;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u00012\u00060\u0003j\u0002`\u0004:\u0001\u0015B\u001f\b\u0002\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0011\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u000eH\u0096\u0002R\u001e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0006X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lokio/Options;", "Lkotlin/collections/AbstractList;", "Lokio/ByteString;", "Ljava/util/RandomAccess;", "Lkotlin/collections/RandomAccess;", "byteStrings", "", "trie", "", "([Lokio/ByteString;[I)V", "getByteStrings$okio", "()[Lokio/ByteString;", "[Lokio/ByteString;", "size", "", "getSize", "()I", "getTrie$okio", "()[I", "get", "index", "Companion", "okio"})
public final class Options
extends AbstractList<ByteString>
implements RandomAccess {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteString[] byteStrings;
    @NotNull
    private final int[] trie;

    /*
     * WARNING - void declaration
     */
    private Options(ByteString[] byteStrings, int[] trie) {
        void var2_2;
        void var1_1;
        this.byteStrings = var1_1;
        this.trie = var2_2;
    }

    @NotNull
    public final ByteString[] getByteStrings$okio() {
        return this.byteStrings;
    }

    @NotNull
    public final int[] getTrie$okio() {
        return this.trie;
    }

    @Override
    public final int getSize() {
        return this.byteStrings.length;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public final ByteString get(int index) {
        void var1_1;
        return this.byteStrings[var1_1];
    }

    @JvmStatic
    @NotNull
    public static final Options of(ByteString ... byteStrings) {
        ByteString[] byteStringArray;
        return Companion.of(byteStringArray);
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ Options(ByteString[] byteStrings, int[] trie, DefaultConstructorMarker $constructor_marker) {
        this((ByteString[])var1_1, (int[])var2_2);
        void var2_2;
        void var1_1;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JT\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00052\b\b\u0002\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\r2\b\b\u0002\u0010\u0012\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0002J!\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u0016\"\u00020\u0010H\u0007\u00a2\u0006\u0002\u0010\u0017R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lokio/Options$Companion;", "", "()V", "intCount", "", "Lokio/Buffer;", "getIntCount", "(Lokio/Buffer;)J", "buildTrieRecursive", "", "nodeOffset", "node", "byteStringOffset", "", "byteStrings", "", "Lokio/ByteString;", "fromIndex", "toIndex", "indexes", "of", "Lokio/Options;", "", "([Lokio/ByteString;)Lokio/Options;", "okio"})
    @SourceDebugExtension(value={"SMAP\nOptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Options.kt\nokio/Options$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Util.kt\nokio/-SegmentedByteString\n*L\n1#1,236:1\n11065#2:237\n11400#2,3:238\n13374#2,3:243\n37#3,2:241\n1#4:246\n74#5:247\n74#5:248\n*S KotlinDebug\n*F\n+ 1 Options.kt\nokio/Options$Companion\n*L\n43#1:237\n43#1:238,3\n44#1:243,3\n43#1:241,2\n151#1:247\n208#1:248\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final Options of(ByteString ... byteStrings) {
            void var1_1;
            void var2_3;
            Collection collection;
            Collection $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(byteStrings, "");
            if (byteStrings.length == 0) {
                int[] nArray = new int[2];
                int[] nArray2 = nArray;
                nArray[0] = 0;
                nArray2[1] = -1;
                return new Options(new ByteString[0], nArray2, null);
            }
            List<ByteString> list = ArraysKt.toMutableList(byteStrings);
            CollectionsKt.sort(list);
            ByteString[] $this$map$iv = byteStrings;
            ByteString[] byteStringArray = byteStrings;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv.length);
            int n2 = ((void)$this$mapTo$iv$iv).length;
            for (int i2 = 0; i2 < n2; ++i2) {
                void cfr_ignored_0 = $this$mapTo$iv$iv[i2];
                collection = destination$iv$iv2;
                collection.add(-1);
            }
            $this$mapTo$iv$iv = destination$iv$iv2 = (Collection)((List)destination$iv$iv2);
            Integer[] integerArray = destination$iv$iv2.toArray(new Integer[0]);
            List<Integer> indexes = CollectionsKt.mutableListOf(Arrays.copyOf(integerArray, integerArray.length));
            ByteString[] $this$forEachIndexed$iv = byteStrings;
            int index$iv = 0;
            for (ByteString item$iv : $this$forEachIndexed$iv) {
                void byteString;
                int callerIndex = index$iv++;
                int sortedIndex = CollectionsKt.binarySearch$default(list, (Comparable)byteString, 0, 0, 6, null);
                indexes.set(sortedIndex, callerIndex);
            }
            if (!(list.get(0).size() > 0)) {
                String destination$iv$iv2 = "the empty byte string is not a supported option";
                throw new IllegalArgumentException(destination$iv$iv2.toString());
            }
            for (int a2 = 0; a2 < list.size(); ++a2) {
                ByteString byteString;
                ByteString prefix = list.get(a2);
                int b2 = a2 + 1;
                while (b2 < list.size() && (byteString = list.get(b2)).startsWith(prefix)) {
                    if (!(byteString.size() != prefix.size())) {
                        String string = "duplicate option: " + byteString;
                        throw new IllegalArgumentException(string.toString());
                    }
                    if (((Number)indexes.get(b2)).intValue() > ((Number)indexes.get(a2)).intValue()) {
                        list.remove(b2);
                        indexes.remove(b2);
                        continue;
                    }
                    ++b2;
                }
            }
            Buffer trieBytes = new Buffer();
            okio.Options$Companion.buildTrieRecursive$default(this, 0L, trieBytes, 0, (List)var2_3, 0, 0, (List)collection, 53, null);
            int[] trie = new int[(int)this.getIntCount(trieBytes)];
            int i3 = 0;
            while (!trieBytes.exhausted()) {
                trie[i3++] = trieBytes.readInt();
            }
            void v1 = var1_1;
            T[] TArray = Arrays.copyOf(v1, ((void)v1).length);
            Intrinsics.checkNotNullExpressionValue(TArray, "");
            return new Options((ByteString[])TArray, trie, null);
        }

        /*
         * WARNING - void declaration
         */
        private final void buildTrieRecursive(long nodeOffset, Buffer node, int byteStringOffset, List<? extends ByteString> byteStrings, int fromIndex22, int toIndex, List<Integer> indexes) {
            void var1_5;
            void var3_6;
            void var9_15;
            void childNodes2;
            void var10_17;
            void var6_11;
            int fromIndex22;
            int i2;
            if (!(fromIndex22 < toIndex)) {
                String fromIndex22 = "Failed requirement.";
                throw new IllegalArgumentException(fromIndex22.toString());
            }
            for (i2 = fromIndex22; i2 < toIndex; ++i2) {
                if (byteStrings.get(i2).size() >= byteStringOffset) continue;
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            int fromIndex3 = fromIndex22;
            ByteString from = byteStrings.get(fromIndex3);
            ByteString to2 = byteStrings.get(toIndex - 1);
            int prefixIndex = -1;
            if (byteStringOffset == from.size()) {
                prefixIndex = ((Number)indexes.get(fromIndex3)).intValue();
                from = byteStrings.get(++fromIndex3);
            }
            if (from.getByte(byteStringOffset) != to2.getByte(byteStringOffset)) {
                int selectChoiceCount = 1;
                for (int i3 = fromIndex3 + 1; i3 < toIndex; ++i3) {
                    if (byteStrings.get(i3 - 1).getByte(byteStringOffset) == byteStrings.get(i3).getByte(byteStringOffset)) continue;
                    ++selectChoiceCount;
                }
                long childNodesOffset = nodeOffset + this.getIntCount(node) + 2L + (long)(selectChoiceCount << 1);
                node.writeInt(selectChoiceCount);
                node.writeInt(prefixIndex);
                for (int i4 = fromIndex3; i4 < toIndex; ++i4) {
                    byte rangeByte = byteStrings.get(i4).getByte(byteStringOffset);
                    if (i4 != fromIndex3 && rangeByte == byteStrings.get(i4 - 1).getByte(byteStringOffset)) continue;
                    byte to2 = rangeByte;
                    node.writeInt(to2 & 0xFF);
                }
                Buffer childNodes2 = new Buffer();
                int rangeStart = fromIndex3;
                while (rangeStart < toIndex) {
                    byte rangeByte = byteStrings.get(rangeStart).getByte(byteStringOffset);
                    int rangeEnd = toIndex;
                    for (i2 = rangeStart + 1; i2 < toIndex; ++i2) {
                        if (rangeByte == byteStrings.get(i2).getByte(byteStringOffset)) continue;
                        rangeEnd = i2;
                        break;
                    }
                    if (rangeStart + 1 == rangeEnd && byteStringOffset + 1 == byteStrings.get(rangeStart).size()) {
                        node.writeInt(((Number)indexes.get(rangeStart)).intValue());
                    } else {
                        node.writeInt(-1 * (int)(childNodesOffset + this.getIntCount(childNodes2)));
                        this.buildTrieRecursive(childNodesOffset, childNodes2, byteStringOffset + 1, byteStrings, rangeStart, rangeEnd, indexes);
                    }
                    rangeStart = rangeEnd;
                }
                node.writeAll(childNodes2);
                return;
            }
            int scanByteCount = 0;
            int n2 = Math.min(var6_11.size(), var10_17.size());
            for (int i5 = byteStringOffset; i5 < n2 && var6_11.getByte(i5) == var10_17.getByte(i5); ++i5) {
                ++scanByteCount;
            }
            void childNodesOffset = childNodes2 + this.getIntCount(node) + 2L + (long)scanByteCount + 1L;
            node.writeInt(-scanByteCount);
            node.writeInt(prefixIndex);
            int n3 = byteStringOffset + scanByteCount;
            for (int i6 = byteStringOffset; i6 < n3; ++i6) {
                byte by = var6_11.getByte(i6);
                node.writeInt(by & 0xFF);
            }
            if (var9_15 + true == toIndex) {
                if (!(byteStringOffset + scanByteCount == byteStrings.get((int)var9_15).size())) {
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
                node.writeInt(((Number)indexes.get((int)var9_15)).intValue());
                return;
            }
            Buffer childNodes2 = new Buffer();
            node.writeInt(-1 * (int)(childNodesOffset + this.getIntCount(childNodes2)));
            this.buildTrieRecursive((long)childNodesOffset, childNodes2, byteStringOffset + scanByteCount, byteStrings, (int)var9_15, toIndex, indexes);
            var3_6.writeAll((Source)var1_5);
        }

        static /* synthetic */ void buildTrieRecursive$default(Companion companion, long l2, Buffer buffer, int n2, List list, int n3, int n4, List list2, int n5, Object object) {
            if ((n5 & 1) != 0) {
                l2 = 0L;
            }
            if ((n5 & 4) != 0) {
                n2 = 0;
            }
            if ((n5 & 0x10) != 0) {
                n3 = 0;
            }
            if ((n5 & 0x20) != 0) {
                n4 = list.size();
            }
            companion.buildTrieRecursive(l2, buffer, n2, list, n3, n4, list2);
        }

        private final long getIntCount(Buffer $this$intCount) {
            return $this$intCount.size() / 4L;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

