/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import java.util.zip.CRC32;
import java.util.zip.Inflater;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Buffer;
import okio.InflaterSource;
import okio.RealBufferedSource;
import okio.Segment;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\b\u0010\u0014\u001a\u00020\u000eH\u0016J\b\u0010\u0015\u001a\u00020\u000eH\u0002J\b\u0010\u0016\u001a\u00020\u000eH\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0018H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J \u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0018H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lokio/GzipSource;", "Lokio/Source;", "source", "(Lokio/Source;)V", "crc", "Ljava/util/zip/CRC32;", "inflater", "Ljava/util/zip/Inflater;", "inflaterSource", "Lokio/InflaterSource;", "section", "", "Lokio/RealBufferedSource;", "checkEqual", "", "name", "", "expected", "", "actual", "close", "consumeHeader", "consumeTrailer", "read", "", "sink", "Lokio/Buffer;", "byteCount", "timeout", "Lokio/Timeout;", "updateCrc", "buffer", "offset", "okio"})
@SourceDebugExtension(value={"SMAP\nGzipSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GzipSource.kt\nokio/GzipSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 RealBufferedSource.kt\nokio/RealBufferedSource\n+ 4 GzipSource.kt\nokio/-GzipSourceExtensions\n+ 5 Util.kt\nokio/-SegmentedByteString\n*L\n1#1,220:1\n1#2:221\n62#3:222\n62#3:224\n62#3:226\n62#3:227\n62#3:228\n62#3:230\n62#3:232\n202#4:223\n202#4:225\n202#4:229\n202#4:231\n89#5:233\n*S KotlinDebug\n*F\n+ 1 GzipSource.kt\nokio/GzipSource\n*L\n105#1:222\n107#1:224\n119#1:226\n120#1:227\n122#1:228\n133#1:230\n144#1:232\n106#1:223\n117#1:225\n130#1:229\n141#1:231\n187#1:233\n*E\n"})
public final class GzipSource
implements Source {
    private byte section;
    @NotNull
    private final RealBufferedSource source;
    @NotNull
    private final Inflater inflater;
    @NotNull
    private final InflaterSource inflaterSource;
    @NotNull
    private final CRC32 crc;

    /*
     * WARNING - void declaration
     */
    public GzipSource(@NotNull Source source2) {
        void var1_1;
        Intrinsics.checkNotNullParameter(source2, "");
        this.source = new RealBufferedSource((Source)var1_1);
        this.inflater = new Inflater(true);
        this.inflaterSource = new InflaterSource(this.source, this.inflater);
        this.crc = new CRC32();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long read(@NotNull Buffer sink2, long byteCount) throws IOException {
        Intrinsics.checkNotNullParameter(sink2, "");
        if (!(byteCount >= 0L)) {
            String string = "byteCount < 0: " + byteCount;
            throw new IllegalArgumentException(string.toString());
        }
        if (byteCount == 0L) {
            return 0L;
        }
        if (this.section == 0) {
            this.consumeHeader();
            this.section = 1;
        }
        if (this.section == 1) {
            void var2_2;
            long offset = sink2.size();
            long result = this.inflaterSource.read(sink2, (long)var2_2);
            if (result != -1L) {
                void var1_1;
                this.updateCrc((Buffer)var1_1, offset, result);
                return result;
            }
            this.section = (byte)2;
        }
        if (this.section == 2) {
            this.consumeTrailer();
            this.section = (byte)3;
            if (!this.source.exhausted()) {
                throw new IOException("gzip finished without exhausting source");
            }
        }
        return -1L;
    }

    /*
     * WARNING - void declaration
     */
    private final void consumeHeader() throws IOException {
        void var2_2;
        void var1_3;
        void index2;
        byte xlen2;
        byte flags;
        this.source.require(10L);
        RealBufferedSource realBufferedSource = this.source;
        byte by = flags = realBufferedSource.bufferField.getByte(3L);
        boolean fhcrc = (flags >> 1 & 1) == 1;
        if (fhcrc) {
            GzipSource gzipSource = this;
            RealBufferedSource realBufferedSource2 = gzipSource.source;
            gzipSource.updateCrc(realBufferedSource2.bufferField, 0L, 10L);
        }
        short id1id2 = this.source.readShort();
        this.checkEqual("ID1ID2", 8075, by);
        this.source.skip(8L);
        byte by2 = flags;
        if ((by2 >> 2 & 1) == 1) {
            this.source.require(2L);
            if (fhcrc) {
                GzipSource gzipSource = this;
                RealBufferedSource realBufferedSource3 = gzipSource.source;
                gzipSource.updateCrc(realBufferedSource3.bufferField, 0L, 2L);
            }
            RealBufferedSource realBufferedSource4 = this.source;
            long xlen2 = realBufferedSource4.bufferField.readShortLe() & 0xFFFF;
            this.source.require(xlen2);
            if (fhcrc) {
                GzipSource gzipSource = this;
                realBufferedSource4 = gzipSource.source;
                gzipSource.updateCrc(realBufferedSource4.bufferField, 0L, xlen2);
            }
            this.source.skip(xlen2);
        }
        if (((xlen2 = flags) >> 3 & 1) == 1) {
            long index2 = this.source.indexOf((byte)0);
            if (index2 == -1L) {
                throw new EOFException();
            }
            if (fhcrc) {
                GzipSource gzipSource = this;
                RealBufferedSource realBufferedSource5 = gzipSource.source;
                gzipSource.updateCrc(realBufferedSource5.bufferField, 0L, index2 + 1L);
            }
            this.source.skip(index2 + 1L);
        }
        if (((index2 = var1_3) >> 4 & 1) == 1) {
            long index3 = this.source.indexOf((byte)0);
            if (index3 == -1L) {
                throw new EOFException();
            }
            if (fhcrc) {
                GzipSource gzipSource = this;
                RealBufferedSource realBufferedSource6 = gzipSource.source;
                gzipSource.updateCrc(realBufferedSource6.bufferField, 0L, index3 + 1L);
            }
            this.source.skip(index3 + 1L);
        }
        if (var2_2 != false) {
            this.checkEqual("FHCRC", this.source.readShortLe(), (short)this.crc.getValue());
            this.crc.reset();
        }
    }

    private final void consumeTrailer() throws IOException {
        this.checkEqual("CRC", this.source.readIntLe(), (int)this.crc.getValue());
        this.checkEqual("ISIZE", this.source.readIntLe(), (int)this.inflater.getBytesWritten());
    }

    @Override
    @NotNull
    public final Timeout timeout() {
        return this.source.timeout();
    }

    @Override
    public final void close() throws IOException {
        this.inflaterSource.close();
    }

    /*
     * WARNING - void declaration
     */
    private final void updateCrc(Buffer buffer, long offset, long byteCount) {
        long offset2;
        long byteCount2 = byteCount;
        Segment segment = buffer.head;
        Intrinsics.checkNotNull(segment);
        Segment s2 = segment;
        for (offset2 = offset; offset2 >= (long)(s2.limit - s2.pos); offset2 -= (long)(s2.limit - s2.pos)) {
            Intrinsics.checkNotNull(s2.next);
        }
        while (byteCount2 > 0L) {
            void var2_3;
            int pos = (int)((long)s2.pos + offset2);
            int n2 = s2.limit - pos;
            int toUpdate = (int)Math.min((long)n2, byteCount2);
            this.crc.update(s2.data, (int)var2_3, toUpdate);
            byteCount2 -= (long)n2;
            offset2 = 0L;
            Intrinsics.checkNotNull(s2.next);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkEqual(String name, int expected, int actual) {
        if (actual != expected) {
            void var2_2;
            void var3_3;
            void var1_1;
            String string = "%s: actual 0x%08x != expected 0x%08x";
            Object[] objectArray = new Object[3];
            Object[] objectArray2 = objectArray;
            objectArray[0] = var1_1;
            objectArray2[1] = (int)var3_3;
            objectArray2[2] = (int)var2_2;
            String string2 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkNotNullExpressionValue(string2, "");
            throw new IOException(string2);
        }
    }
}

