/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.ws;

import java.io.Closeable;
import java.io.IOException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.EventListener;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okhttp3.internal.Util;
import okhttp3.internal.concurrent.Task;
import okhttp3.internal.concurrent.TaskQueue;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.connection.Exchange;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.ws.WebSocketExtensions;
import okhttp3.internal.ws.WebSocketProtocol;
import okhttp3.internal.ws.WebSocketReader;
import okhttp3.internal.ws.WebSocketWriter;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u001c\u0018\u0000 `2\u00020\u00012\u00020\u0002:\u0005_`abcB?\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\u0006\u0010\u000f\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0010J\u0016\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\f2\u0006\u00105\u001a\u000206J\b\u00107\u001a\u000203H\u0016J\u001f\u00108\u001a\u0002032\u0006\u00109\u001a\u00020:2\b\u0010;\u001a\u0004\u0018\u00010<H\u0000\u00a2\u0006\u0002\b=J\u001a\u0010>\u001a\u00020\u00122\u0006\u0010?\u001a\u00020%2\b\u0010@\u001a\u0004\u0018\u00010\u0018H\u0016J \u0010>\u001a\u00020\u00122\u0006\u0010?\u001a\u00020%2\b\u0010@\u001a\u0004\u0018\u00010\u00182\u0006\u0010A\u001a\u00020\fJ\u000e\u0010B\u001a\u0002032\u0006\u0010C\u001a\u00020DJ\u001c\u0010E\u001a\u0002032\n\u0010F\u001a\u00060Gj\u0002`H2\b\u00109\u001a\u0004\u0018\u00010:J\u0016\u0010I\u001a\u0002032\u0006\u0010\u001e\u001a\u00020\u00182\u0006\u0010*\u001a\u00020+J\u0006\u0010J\u001a\u000203J\u0018\u0010K\u001a\u0002032\u0006\u0010?\u001a\u00020%2\u0006\u0010@\u001a\u00020\u0018H\u0016J\u0010\u0010L\u001a\u0002032\u0006\u0010M\u001a\u00020\u0018H\u0016J\u0010\u0010L\u001a\u0002032\u0006\u0010N\u001a\u00020 H\u0016J\u0010\u0010O\u001a\u0002032\u0006\u0010P\u001a\u00020 H\u0016J\u0010\u0010Q\u001a\u0002032\u0006\u0010P\u001a\u00020 H\u0016J\u000e\u0010R\u001a\u00020\u00122\u0006\u0010P\u001a\u00020 J\u0006\u0010S\u001a\u00020\u0012J\b\u0010!\u001a\u00020\fH\u0016J\u0006\u0010'\u001a\u00020%J\u0006\u0010(\u001a\u00020%J\b\u0010T\u001a\u00020\u0006H\u0016J\b\u0010U\u001a\u000203H\u0002J\u0010\u0010V\u001a\u00020\u00122\u0006\u0010M\u001a\u00020\u0018H\u0016J\u0010\u0010V\u001a\u00020\u00122\u0006\u0010N\u001a\u00020 H\u0016J\u0018\u0010V\u001a\u00020\u00122\u0006\u0010W\u001a\u00020 2\u0006\u0010X\u001a\u00020%H\u0002J\u0006\u0010)\u001a\u00020%J\u0006\u0010Y\u001a\u000203J\r\u0010Z\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b[J\r\u0010\\\u001a\u000203H\u0000\u00a2\u0006\u0002\b]J\f\u0010^\u001a\u00020\u0012*\u00020\u000eH\u0002R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010*\u001a\u0004\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010.\u001a\u0004\u0018\u00010/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00100\u001a\u0004\u0018\u000101X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006d"}, d2={"Lokhttp3/internal/ws/RealWebSocket;", "Lokhttp3/WebSocket;", "Lokhttp3/internal/ws/WebSocketReader$FrameCallback;", "taskRunner", "Lokhttp3/internal/concurrent/TaskRunner;", "originalRequest", "Lokhttp3/Request;", "listener", "Lokhttp3/WebSocketListener;", "random", "Ljava/util/Random;", "pingIntervalMillis", "", "extensions", "Lokhttp3/internal/ws/WebSocketExtensions;", "minimumDeflateSize", "(Lokhttp3/internal/concurrent/TaskRunner;Lokhttp3/Request;Lokhttp3/WebSocketListener;Ljava/util/Random;JLokhttp3/internal/ws/WebSocketExtensions;J)V", "awaitingPong", "", "call", "Lokhttp3/Call;", "enqueuedClose", "failed", "key", "", "getListener$okhttp", "()Lokhttp3/WebSocketListener;", "messageAndCloseQueue", "Ljava/util/ArrayDeque;", "", "name", "pongQueue", "Lokio/ByteString;", "queueSize", "reader", "Lokhttp3/internal/ws/WebSocketReader;", "receivedCloseCode", "", "receivedCloseReason", "receivedPingCount", "receivedPongCount", "sentPingCount", "streams", "Lokhttp3/internal/ws/RealWebSocket$Streams;", "taskQueue", "Lokhttp3/internal/concurrent/TaskQueue;", "writer", "Lokhttp3/internal/ws/WebSocketWriter;", "writerTask", "Lokhttp3/internal/concurrent/Task;", "awaitTermination", "", "timeout", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "cancel", "checkUpgradeSuccess", "response", "Lokhttp3/Response;", "exchange", "Lokhttp3/internal/connection/Exchange;", "checkUpgradeSuccess$okhttp", "close", "code", "reason", "cancelAfterCloseMillis", "connect", "client", "Lokhttp3/OkHttpClient;", "failWebSocket", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "initReaderAndWriter", "loopReader", "onReadClose", "onReadMessage", "text", "bytes", "onReadPing", "payload", "onReadPong", "pong", "processNextFrame", "request", "runWriter", "send", "data", "formatOpcode", "tearDown", "writeOneFrame", "writeOneFrame$okhttp", "writePingFrame", "writePingFrame$okhttp", "isValid", "Close", "Companion", "Message", "Streams", "WriterTask", "okhttp"})
@SourceDebugExtension(value={"SMAP\nRealWebSocket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealWebSocket.kt\nokhttp3/internal/ws/RealWebSocket\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 TaskQueue.kt\nokhttp3/internal/concurrent/TaskQueue\n+ 4 Util.kt\nokhttp3/internal/Util\n*L\n1#1,654:1\n1#2:655\n84#3,4:656\n90#3,13:664\n608#4,4:660\n*S KotlinDebug\n*F\n+ 1 RealWebSocket.kt\nokhttp3/internal/ws/RealWebSocket\n*L\n269#1:656,4\n512#1:664,13\n457#1:660,4\n*E\n"})
public final class RealWebSocket
implements WebSocket,
WebSocketReader.FrameCallback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Request originalRequest;
    @NotNull
    private final WebSocketListener listener;
    @NotNull
    private final Random random;
    private final long pingIntervalMillis;
    @Nullable
    private WebSocketExtensions extensions;
    private long minimumDeflateSize;
    @NotNull
    private final String key;
    @Nullable
    private Call call;
    @Nullable
    private Task writerTask;
    @Nullable
    private WebSocketReader reader;
    @Nullable
    private WebSocketWriter writer;
    @NotNull
    private TaskQueue taskQueue;
    @Nullable
    private String name;
    @Nullable
    private Streams streams;
    @NotNull
    private final ArrayDeque<ByteString> pongQueue;
    @NotNull
    private final ArrayDeque<Object> messageAndCloseQueue;
    private long queueSize;
    private boolean enqueuedClose;
    private int receivedCloseCode;
    @Nullable
    private String receivedCloseReason;
    private boolean failed;
    private int sentPingCount;
    private int receivedPingCount;
    private int receivedPongCount;
    private boolean awaitingPong;
    @NotNull
    private static final List<Protocol> ONLY_HTTP1 = CollectionsKt.listOf(Protocol.HTTP_1_1);
    private static final long MAX_QUEUE_SIZE = 0x1000000L;
    private static final long CANCEL_AFTER_CLOSE_MILLIS = 60000L;
    public static final long DEFAULT_MINIMUM_DEFLATE_SIZE = 1024L;

    /*
     * WARNING - void declaration
     */
    public RealWebSocket(@NotNull TaskRunner taskRunner, @NotNull Request originalRequest, @NotNull WebSocketListener listener, @NotNull Random random, long pingIntervalMillis, @Nullable WebSocketExtensions extensions, long minimumDeflateSize) {
        void var2_2;
        byte[] byArray;
        RealWebSocket realWebSocket;
        Intrinsics.checkNotNullParameter(taskRunner, "");
        Intrinsics.checkNotNullParameter(originalRequest, "");
        Intrinsics.checkNotNullParameter(listener, "");
        Intrinsics.checkNotNullParameter(random, "");
        this.originalRequest = originalRequest;
        this.listener = realWebSocket;
        this.random = random;
        this.pingIntervalMillis = pingIntervalMillis;
        this.extensions = extensions;
        this.minimumDeflateSize = minimumDeflateSize;
        this.taskQueue = byArray.newQueue();
        this.pongQueue = new ArrayDeque();
        this.messageAndCloseQueue = new ArrayDeque();
        this.receivedCloseCode = -1;
        if (!Intrinsics.areEqual("GET", this.originalRequest.method())) {
            originalRequest = "Request must be GET: " + this.originalRequest.method();
            throw new IllegalArgumentException(originalRequest.toString());
        }
        byArray = new byte[16];
        originalRequest = byArray;
        ByteString.Companion companion = ByteString.Companion;
        realWebSocket = this;
        this.random.nextBytes((byte[])var2_2);
        realWebSocket.key = ByteString.Companion.of$default(companion, byArray, 0, 0, 3, null).base64();
    }

    @NotNull
    public final WebSocketListener getListener$okhttp() {
        return this.listener;
    }

    @Override
    @NotNull
    public final Request request() {
        return this.originalRequest;
    }

    @Override
    public final synchronized long queueSize() {
        return this.queueSize;
    }

    @Override
    public final void cancel() {
        Call call = this.call;
        Intrinsics.checkNotNull(call);
        call.cancel();
    }

    /*
     * WARNING - void declaration
     */
    public final void connect(@NotNull OkHttpClient client) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(client, "");
        if (this.originalRequest.header("Sec-WebSocket-Extensions") != null) {
            this.failWebSocket(new ProtocolException("Request header not permitted: 'Sec-WebSocket-Extensions'"), null);
            return;
        }
        OkHttpClient webSocketClient = client.newBuilder().eventListener(EventListener.NONE).protocols(ONLY_HTTP1).build();
        Request request = this.originalRequest.newBuilder().header("Upgrade", "websocket").header("Connection", "Upgrade").header("Sec-WebSocket-Key", this.key).header("Sec-WebSocket-Version", "13").header("Sec-WebSocket-Extensions", "permessage-deflate").build();
        Call call = this.call = (Call)new RealCall((OkHttpClient)var1_1, request, true);
        Intrinsics.checkNotNull(call);
        call.enqueue(new Callback(this, (Request)var2_2){
            final /* synthetic */ RealWebSocket this$0;
            final /* synthetic */ Request $request;
            {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.$request = var2_2;
            }

            /*
             * WARNING - void declaration
             */
            public final void onResponse(@NotNull Call call, @NotNull Response response) {
                Intrinsics.checkNotNullParameter(call, "");
                Intrinsics.checkNotNullParameter(response, "");
                Object exchange = response.exchange();
                try {
                    this.this$0.checkUpgradeSuccess$okhttp(response, (Exchange)exchange);
                    Exchange exchange2 = exchange;
                    Intrinsics.checkNotNull(exchange2);
                    Streams streams = exchange2.newWebSocketStreams();
                }
                catch (IOException e2) {
                    this.this$0.failWebSocket(e2, response);
                    Util.closeQuietly(response);
                    Exchange exchange3 = exchange;
                    if (exchange3 != null) {
                        exchange3.webSocketUpgradeFailed();
                        return;
                    }
                    return;
                }
                WebSocketExtensions extensions = WebSocketExtensions.Companion.parse(response.headers());
                RealWebSocket.access$setExtensions$p(this.this$0, extensions);
                if (!RealWebSocket.access$isValid(this.this$0, extensions)) {
                    exchange = this.this$0;
                    RealWebSocket realWebSocket = this.this$0;
                    synchronized (exchange) {
                        RealWebSocket.access$getMessageAndCloseQueue$p(realWebSocket).clear();
                        realWebSocket.close(1010, "unexpected Sec-WebSocket-Extensions in response header");
                    }
                }
                try {
                    void var2_3;
                    void var3_5;
                    String name = Util.okHttpName + " WebSocket " + this.$request.url().redact();
                    this.this$0.initReaderAndWriter(name, (Streams)var3_5);
                    this.this$0.getListener$okhttp().onOpen(this.this$0, (Response)var2_3);
                    this.this$0.loopReader();
                    return;
                }
                catch (Exception e3) {
                    void var1_2;
                    this.this$0.failWebSocket((Exception)var1_2, null);
                    return;
                }
            }

            /*
             * WARNING - void declaration
             */
            public final void onFailure(@NotNull Call call, @NotNull IOException e2) {
                void var2_2;
                Intrinsics.checkNotNullParameter(call, "");
                Intrinsics.checkNotNullParameter(e2, "");
                this.this$0.failWebSocket((Exception)var2_2, null);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isValid(WebSocketExtensions $this$isValid) {
        void var1_1;
        if ($this$isValid.unknownValues) {
            return false;
        }
        if ($this$isValid.clientMaxWindowBits != null) {
            return false;
        }
        return $this$isValid.serverMaxWindowBits == null || new IntRange(8, 15).contains(var1_1.serverMaxWindowBits);
    }

    /*
     * WARNING - void declaration
     */
    public final void checkUpgradeSuccess$okhttp(@NotNull Response response, @Nullable Exchange exchange) throws IOException {
        void var2_2;
        Intrinsics.checkNotNullParameter(response, "");
        if (response.code() != 101) {
            throw new ProtocolException("Expected HTTP 101 response but was '" + response.code() + ' ' + response.message() + '\'');
        }
        String headerConnection = Response.header$default(response, "Connection", null, 2, null);
        if (!StringsKt.equals("Upgrade", headerConnection, true)) {
            throw new ProtocolException("Expected 'Connection' header value 'Upgrade' but was '" + headerConnection + '\'');
        }
        String headerUpgrade = Response.header$default(response, "Upgrade", null, 2, null);
        if (!StringsKt.equals("websocket", headerUpgrade, true)) {
            throw new ProtocolException("Expected 'Upgrade' header value 'websocket' but was '" + headerUpgrade + '\'');
        }
        String headerAccept = Response.header$default(response, "Sec-WebSocket-Accept", null, 2, null);
        String acceptExpected = ByteString.Companion.encodeUtf8(this.key + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11").sha1().base64();
        if (!Intrinsics.areEqual(acceptExpected, headerAccept)) {
            void var1_1;
            void var3_3;
            throw new ProtocolException("Expected 'Sec-WebSocket-Accept' header value '" + (String)var3_3 + "' but was '" + (String)var1_1 + '\'');
        }
        if (var2_2 == null) {
            throw new ProtocolException("Web Socket exchange missing: bad interceptor?");
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void initReaderAndWriter(@NotNull String name, @NotNull Streams streams) throws IOException {
        void var2_3;
        void var3_4;
        Intrinsics.checkNotNullParameter(name, "");
        Intrinsics.checkNotNullParameter(streams, "");
        WebSocketExtensions webSocketExtensions = this.extensions;
        Intrinsics.checkNotNull(webSocketExtensions);
        WebSocketExtensions extensions = webSocketExtensions;
        RealWebSocket realWebSocket = this;
        synchronized (realWebSocket) {
            this.name = name;
            this.streams = streams;
            this.writer = new WebSocketWriter(streams.getClient(), streams.getSink(), this.random, extensions.perMessageDeflate, extensions.noContextTakeover(streams.getClient()), this.minimumDeflateSize);
            this.writerTask = new WriterTask();
            if (this.pingIntervalMillis != 0L) {
                void var1_1;
                void this_$iv;
                long pingIntervalNanos = TimeUnit.MILLISECONDS.toNanos(this.pingIntervalMillis);
                TaskQueue taskQueue = this.taskQueue;
                String name$iv = name + " ping";
                this_$iv.schedule(new Task((String)var1_1, this, pingIntervalNanos){
                    final /* synthetic */ RealWebSocket this$0;
                    final /* synthetic */ long $pingIntervalNanos$inlined;
                    {
                        void var1_1;
                        this.this$0 = realWebSocket;
                        this.$pingIntervalNanos$inlined = l2;
                        super((String)var1_1, false, 2, null);
                    }

                    public final long runOnce() {
                        this.this$0.writePingFrame$okhttp();
                        return this.$pingIntervalNanos$inlined;
                    }
                }, pingIntervalNanos);
            }
            if (!((Collection)this.messageAndCloseQueue).isEmpty()) {
                this.runWriter();
            }
        }
        this.reader = new WebSocketReader(streams.getClient(), streams.getSource(), this, extensions.perMessageDeflate, var3_4.noContextTakeover(!var2_3.getClient()));
    }

    public final void loopReader() throws IOException {
        while (this.receivedCloseCode == -1) {
            WebSocketReader webSocketReader = this.reader;
            Intrinsics.checkNotNull(webSocketReader);
            webSocketReader.processNextFrame();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean processNextFrame() throws IOException {
        boolean bl;
        try {
            WebSocketReader webSocketReader = this.reader;
            Intrinsics.checkNotNull(webSocketReader);
            webSocketReader.processNextFrame();
            bl = this.receivedCloseCode == -1;
        }
        catch (Exception e2) {
            void var1_2;
            this.failWebSocket((Exception)var1_2, null);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final void awaitTermination(long timeout2, @NotNull TimeUnit timeUnit) throws InterruptedException {
        void var3_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)timeUnit, "");
        this.taskQueue.idleLatch().await((long)var1_1, (TimeUnit)var3_2);
    }

    public final void tearDown() throws InterruptedException {
        this.taskQueue.shutdown();
        this.taskQueue.idleLatch().await(10L, TimeUnit.SECONDS);
    }

    public final synchronized int sentPingCount() {
        return this.sentPingCount;
    }

    public final synchronized int receivedPingCount() {
        return this.receivedPingCount;
    }

    public final synchronized int receivedPongCount() {
        return this.receivedPongCount;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void onReadMessage(@NotNull String text) throws IOException {
        void var1_1;
        Intrinsics.checkNotNullParameter(text, "");
        this.listener.onMessage((WebSocket)this, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void onReadMessage(@NotNull ByteString bytes) throws IOException {
        void var1_1;
        Intrinsics.checkNotNullParameter(bytes, "");
        this.listener.onMessage((WebSocket)this, (ByteString)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized void onReadPing(@NotNull ByteString payload) {
        void var1_1;
        Intrinsics.checkNotNullParameter(payload, "");
        if (this.failed || this.enqueuedClose && this.messageAndCloseQueue.isEmpty()) {
            return;
        }
        this.pongQueue.add((ByteString)var1_1);
        this.runWriter();
        int n2 = this.receivedPingCount;
        this.receivedPingCount = n2 + 1;
    }

    @Override
    public final synchronized void onReadPong(@NotNull ByteString payload) {
        Intrinsics.checkNotNullParameter(payload, "");
        int n2 = this.receivedPongCount;
        this.receivedPongCount = n2 + 1;
        this.awaitingPong = false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void onReadClose(int code22, @NotNull String reason) {
        Streams streams;
        int code22;
        Intrinsics.checkNotNullParameter(reason, "");
        if (!(code22 != -1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Streams toClose = null;
        WebSocketReader readerToClose = null;
        WebSocketWriter writerToClose = null;
        RealWebSocket realWebSocket = this;
        synchronized (realWebSocket) {
            if (!(this.receivedCloseCode == -1)) {
                String code22 = "already closed";
                throw new IllegalStateException(code22.toString());
            }
            this.receivedCloseCode = code22;
            this.receivedCloseReason = reason;
            if (this.enqueuedClose && this.messageAndCloseQueue.isEmpty()) {
                toClose = this.streams;
                this.streams = null;
                readerToClose = this.reader;
                this.reader = null;
                writerToClose = this.writer;
                this.writer = null;
                this.taskQueue.shutdown();
            }
        }
        try {
            this.listener.onClosing(this, code22, reason);
            if (toClose != null) {
                void var2_4;
                void var1_1;
                this.listener.onClosed(this, (int)var1_1, (String)var2_4);
            }
            streams = toClose;
        }
        catch (Throwable throwable) {
            void var3_7;
            Streams streams2 = (Streams)var3_7;
            if (streams2 != null) {
                Util.closeQuietly(streams2);
            }
            WebSocketReader webSocketReader = readerToClose;
            if (webSocketReader != null) {
                Util.closeQuietly(webSocketReader);
            }
            WebSocketWriter webSocketWriter = writerToClose;
            if (webSocketWriter != null) {
                Util.closeQuietly(webSocketWriter);
            }
            throw throwable;
        }
        if (streams != null) {
            Util.closeQuietly(streams);
        }
        WebSocketReader webSocketReader = readerToClose;
        if (webSocketReader != null) {
            Util.closeQuietly(webSocketReader);
        }
        WebSocketWriter webSocketWriter = writerToClose;
        if (webSocketWriter == null) {
            return;
        }
        Util.closeQuietly(webSocketWriter);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean send(@NotNull String text) {
        void var1_1;
        Intrinsics.checkNotNullParameter(text, "");
        return this.send(ByteString.Companion.encodeUtf8((String)var1_1), 1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean send(@NotNull ByteString bytes) {
        void var1_1;
        Intrinsics.checkNotNullParameter(bytes, "");
        return this.send((ByteString)var1_1, 2);
    }

    /*
     * WARNING - void declaration
     */
    private final synchronized boolean send(ByteString data, int formatOpcode) {
        void var1_1;
        void var2_2;
        if (this.failed || this.enqueuedClose) {
            return false;
        }
        if (this.queueSize + (long)data.size() > 0x1000000L) {
            this.close(1001, null);
            return false;
        }
        this.queueSize += (long)data.size();
        this.messageAndCloseQueue.add(new Message((int)var2_2, (ByteString)var1_1));
        this.runWriter();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized boolean pong(@NotNull ByteString payload) {
        void var1_1;
        Intrinsics.checkNotNullParameter(payload, "");
        if (this.failed || this.enqueuedClose && this.messageAndCloseQueue.isEmpty()) {
            return false;
        }
        this.pongQueue.add((ByteString)var1_1);
        this.runWriter();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean close(int code, @Nullable String reason) {
        void var2_2;
        void var1_1;
        return this.close((int)var1_1, (String)var2_2, 60000L);
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized boolean close(int code2, @Nullable String reason, long cancelAfterCloseMillis) {
        void var3_4;
        void var1_1;
        WebSocketProtocol.INSTANCE.validateCloseCode(code2);
        ByteString reasonBytes = null;
        if (reason != null && !((long)(reasonBytes = ByteString.Companion.encodeUtf8(reason)).size() <= 123L)) {
            void var2_3;
            String code2 = "reason.size() > 123: " + (String)var2_3;
            throw new IllegalArgumentException(code2.toString());
        }
        if (this.failed || this.enqueuedClose) {
            return false;
        }
        this.enqueuedClose = true;
        this.messageAndCloseQueue.add(new Close((int)var1_1, reasonBytes, (long)var3_4));
        this.runWriter();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void runWriter() {
        RealWebSocket $this$assertThreadHoldsLock$iv = this;
        if (Util.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertThreadHoldsLock$iv));
        }
        Task writerTask = this.writerTask;
        if (writerTask != null) {
            void var1_1;
            TaskQueue.schedule$default(this.taskQueue, (Task)var1_1, 0L, 2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean writeOneFrame$okhttp() throws IOException {
        Streams streams;
        ByteString pong;
        Object writer;
        Object messageOrClose = null;
        int receivedCloseCode = 0;
        String receivedCloseReason = null;
        Streams streamsToClose = null;
        WebSocketReader readerToClose = null;
        WebSocketWriter writerToClose = null;
        RealWebSocket realWebSocket = this;
        synchronized (realWebSocket) {
            block26: {
                block25: {
                    if (!this.failed) break block25;
                    return false;
                }
                writer = this.writer;
                pong = this.pongQueue.poll();
                if (pong != null) break block26;
                messageOrClose = this.messageAndCloseQueue.poll();
                if (messageOrClose instanceof Close) {
                    receivedCloseCode = this.receivedCloseCode;
                    receivedCloseReason = this.receivedCloseReason;
                    if (receivedCloseCode != -1) {
                        streamsToClose = this.streams;
                        this.streams = null;
                        readerToClose = this.reader;
                        this.reader = null;
                        writerToClose = this.writer;
                        this.writer = null;
                        this.taskQueue.shutdown();
                    } else {
                        void name$iv;
                        void $this$iv;
                        long cancelAfterCloseMillis = ((Close)messageOrClose).getCancelAfterCloseMillis();
                        TaskQueue taskQueue = this.taskQueue;
                        String string = this.name + " cancel";
                        long delayNanos$iv = TimeUnit.MILLISECONDS.toNanos(cancelAfterCloseMillis);
                        $this$iv.schedule(new Task((String)name$iv, true, this){
                            final /* synthetic */ RealWebSocket this$0;
                            {
                                void var2_2;
                                void var1_1;
                                this.this$0 = realWebSocket;
                                super((String)var1_1, (boolean)var2_2);
                            }

                            public final long runOnce() {
                                this.this$0.cancel();
                                return -1L;
                            }
                        }, delayNanos$iv);
                    }
                    break block26;
                }
                if (messageOrClose != null) break block26;
                return false;
            }
        }
        try {
            if (pong != null) {
                void var2_11;
                WebSocketWriter webSocketWriter = writer;
                Intrinsics.checkNotNull(webSocketWriter);
                webSocketWriter.writePong((ByteString)var2_11);
            } else if (messageOrClose instanceof Message) {
                Message message = (Message)messageOrClose;
                WebSocketWriter webSocketWriter = writer;
                Intrinsics.checkNotNull(webSocketWriter);
                webSocketWriter.writeMessageFrame(message.getFormatOpcode(), message.getData());
                writer = this;
                synchronized (writer) {
                    this.queueSize -= (long)message.getData().size();
                }
            } else if (messageOrClose instanceof Close) {
                void var1_9;
                void var3_1;
                Close close = (Close)var3_1;
                void v2 = var1_9;
                Intrinsics.checkNotNull(v2);
                v2.writeClose(close.getCode(), close.getReason());
                if (streamsToClose != null) {
                    WebSocket webSocket = this;
                    String string = receivedCloseReason;
                    Intrinsics.checkNotNull(string);
                    this.listener.onClosed(webSocket, receivedCloseCode, string);
                }
            } else {
                throw new AssertionError();
            }
            streams = streamsToClose;
        }
        catch (Throwable throwable) {
            block27: {
                Streams streams2 = streamsToClose;
                if (streams2 != null) {
                    Util.closeQuietly(streams2);
                }
                WebSocketReader webSocketReader = readerToClose;
                if (webSocketReader != null) {
                    Util.closeQuietly(webSocketReader);
                }
                WebSocketWriter webSocketWriter = writerToClose;
                if (webSocketWriter == null) break block27;
                Util.closeQuietly(webSocketWriter);
            }
            throw throwable;
        }
        if (streams != null) {
            Util.closeQuietly(streams);
        }
        WebSocketReader webSocketReader = readerToClose;
        if (webSocketReader != null) {
            Util.closeQuietly(webSocketReader);
        }
        WebSocketWriter webSocketWriter = writerToClose;
        if (webSocketWriter != null) {
            Util.closeQuietly(webSocketWriter);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void writePingFrame$okhttp() {
        int failedPing;
        RealWebSocket realWebSocket = this;
        synchronized (realWebSocket) {
            if (this.failed) {
                return;
            }
            WebSocketWriter webSocketWriter = this.writer;
            if (webSocketWriter == null) {
                return;
            }
            WebSocketWriter writer = webSocketWriter;
            failedPing = this.awaitingPong ? this.sentPingCount : -1;
            int n2 = this.sentPingCount;
            this.sentPingCount = n2 + 1;
            this.awaitingPong = true;
        }
        if (failedPing != -1) {
            void var2_5;
            this.failWebSocket(new SocketTimeoutException("sent ping but didn't receive pong within " + this.pingIntervalMillis + "ms (after " + (int)(var2_5 - true) + " successful ping/pongs)"), null);
            return;
        }
        try {
            void var1_3;
            var1_3.writePing(ByteString.EMPTY);
            return;
        }
        catch (IOException e2) {
            void var3_2;
            this.failWebSocket((Exception)var3_2, null);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void failWebSocket(@NotNull Exception e2, @Nullable Response response) {
        Streams streams;
        WebSocketWriter writerToClose;
        WebSocketReader readerToClose;
        Streams streamsToClose;
        Intrinsics.checkNotNullParameter(e2, "");
        RealWebSocket realWebSocket = this;
        synchronized (realWebSocket) {
            if (this.failed) {
                return;
            }
            this.failed = true;
            streamsToClose = this.streams;
            this.streams = null;
            readerToClose = this.reader;
            this.reader = null;
            writerToClose = this.writer;
            this.writer = null;
            this.taskQueue.shutdown();
        }
        try {
            void var2_3;
            void var1_1;
            this.listener.onFailure(this, (Throwable)var1_1, (Response)var2_3);
            streams = streamsToClose;
        }
        catch (Throwable throwable) {
            void var3_6;
            Streams streams2 = (Streams)var3_6;
            if (streams2 != null) {
                Util.closeQuietly(streams2);
            }
            WebSocketReader webSocketReader = readerToClose;
            if (webSocketReader != null) {
                Util.closeQuietly(webSocketReader);
            }
            WebSocketWriter webSocketWriter = writerToClose;
            if (webSocketWriter != null) {
                Util.closeQuietly(webSocketWriter);
            }
            throw throwable;
        }
        if (streams != null) {
            Util.closeQuietly(streams);
        }
        WebSocketReader webSocketReader = readerToClose;
        if (webSocketReader != null) {
            Util.closeQuietly(webSocketReader);
        }
        WebSocketWriter webSocketWriter = writerToClose;
        if (webSocketWriter == null) {
            return;
        }
        Util.closeQuietly(webSocketWriter);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setExtensions$p(RealWebSocket $this, WebSocketExtensions webSocketExtensions) {
        void var1_1;
        $this.extensions = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean access$isValid(RealWebSocket $this, WebSocketExtensions $receiver) {
        void var1_1;
        return $this.isValid((WebSocketExtensions)var1_1);
    }

    public static final /* synthetic */ ArrayDeque access$getMessageAndCloseQueue$p(RealWebSocket $this) {
        return $this.messageAndCloseQueue;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lokhttp3/internal/ws/RealWebSocket$Close;", "", "code", "", "reason", "Lokio/ByteString;", "cancelAfterCloseMillis", "", "(ILokio/ByteString;J)V", "getCancelAfterCloseMillis", "()J", "getCode", "()I", "getReason", "()Lokio/ByteString;", "okhttp"})
    public static final class Close {
        private final int code;
        @Nullable
        private final ByteString reason;
        private final long cancelAfterCloseMillis;

        /*
         * WARNING - void declaration
         */
        public Close(int code, @Nullable ByteString reason, long cancelAfterCloseMillis) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.code = var1_1;
            this.reason = var2_2;
            this.cancelAfterCloseMillis = var3_3;
        }

        public final int getCode() {
            return this.code;
        }

        @Nullable
        public final ByteString getReason() {
            return this.reason;
        }

        public final long getCancelAfterCloseMillis() {
            return this.cancelAfterCloseMillis;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lokhttp3/internal/ws/RealWebSocket$Companion;", "", "()V", "CANCEL_AFTER_CLOSE_MILLIS", "", "DEFAULT_MINIMUM_DEFLATE_SIZE", "MAX_QUEUE_SIZE", "ONLY_HTTP1", "", "Lokhttp3/Protocol;", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lokhttp3/internal/ws/RealWebSocket$Message;", "", "formatOpcode", "", "data", "Lokio/ByteString;", "(ILokio/ByteString;)V", "getData", "()Lokio/ByteString;", "getFormatOpcode", "()I", "okhttp"})
    public static final class Message {
        private final int formatOpcode;
        @NotNull
        private final ByteString data;

        /*
         * WARNING - void declaration
         */
        public Message(int formatOpcode, @NotNull ByteString data) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter(data, "");
            this.formatOpcode = var1_1;
            this.data = var2_2;
        }

        public final int getFormatOpcode() {
            return this.formatOpcode;
        }

        @NotNull
        public final ByteString getData() {
            return this.data;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lokhttp3/internal/ws/RealWebSocket$Streams;", "Ljava/io/Closeable;", "client", "", "source", "Lokio/BufferedSource;", "sink", "Lokio/BufferedSink;", "(ZLokio/BufferedSource;Lokio/BufferedSink;)V", "getClient", "()Z", "getSink", "()Lokio/BufferedSink;", "getSource", "()Lokio/BufferedSource;", "okhttp"})
    public static abstract class Streams
    implements Closeable {
        private final boolean client;
        @NotNull
        private final BufferedSource source;
        @NotNull
        private final BufferedSink sink;

        /*
         * WARNING - void declaration
         */
        public Streams(boolean client, @NotNull BufferedSource source2, @NotNull BufferedSink sink2) {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter(source2, "");
            Intrinsics.checkNotNullParameter(sink2, "");
            this.client = var1_1;
            this.source = var2_2;
            this.sink = var3_3;
        }

        public final boolean getClient() {
            return this.client;
        }

        @NotNull
        public final BufferedSource getSource() {
            return this.source;
        }

        @NotNull
        public final BufferedSink getSink() {
            return this.sink;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lokhttp3/internal/ws/RealWebSocket$WriterTask;", "Lokhttp3/internal/concurrent/Task;", "(Lokhttp3/internal/ws/RealWebSocket;)V", "runOnce", "", "okhttp"})
    private final class WriterTask
    extends Task {
        /*
         * WARNING - void declaration
         */
        public WriterTask() {
            void var1_1;
            super(((RealWebSocket)var1_1).name + " writer", false, 2, null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final long runOnce() {
            try {
                if (RealWebSocket.this.writeOneFrame$okhttp()) {
                    return 0L;
                }
            }
            catch (IOException e2) {
                void var1_1;
                RealWebSocket.this.failWebSocket((Exception)var1_1, null);
            }
            return -1L;
        }
    }
}

