/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.tls;

import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.internal.HostnamesKt;
import okhttp3.internal.Util;
import okio.Utf8;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u0012\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\bH\u0002J\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\f\u0010\u0017\u001a\u00020\b*\u00020\bH\u0002J\f\u0010\u0018\u001a\u00020\u000e*\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lokhttp3/internal/tls/OkHostnameVerifier;", "Ljavax/net/ssl/HostnameVerifier;", "()V", "ALT_DNS_NAME", "", "ALT_IPA_NAME", "allSubjectAltNames", "", "", "certificate", "Ljava/security/cert/X509Certificate;", "getSubjectAltNames", "type", "verify", "", "host", "session", "Ljavax/net/ssl/SSLSession;", "verifyHostname", "hostname", "pattern", "verifyIpAddress", "ipAddress", "asciiToLowercase", "isAscii", "okhttp"})
@SourceDebugExtension(value={"SMAP\nOkHostnameVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OkHostnameVerifier.kt\nokhttp3/internal/tls/OkHostnameVerifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,208:1\n1747#2,3:209\n1747#2,3:212\n*S KotlinDebug\n*F\n+ 1 OkHostnameVerifier.kt\nokhttp3/internal/tls/OkHostnameVerifier\n*L\n63#1:209,3\n71#1:212,3\n*E\n"})
public final class OkHostnameVerifier
implements HostnameVerifier {
    @NotNull
    public static final OkHostnameVerifier INSTANCE = new OkHostnameVerifier();
    private static final int ALT_DNS_NAME = 2;
    private static final int ALT_IPA_NAME = 7;

    private OkHostnameVerifier() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean verify(@NotNull String host, @NotNull SSLSession session) {
        boolean bl;
        Intrinsics.checkNotNullParameter(host, "");
        Intrinsics.checkNotNullParameter(session, "");
        if (!this.isAscii(host)) {
            return false;
        }
        try {
            void var1_1;
            void var2_3;
            Certificate certificate = var2_3.getPeerCertificates()[0];
            Intrinsics.checkNotNull(certificate);
            bl = this.verify((String)var1_1, (X509Certificate)certificate);
        }
        catch (SSLException sSLException) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean verify(@NotNull String host, @NotNull X509Certificate certificate) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(host, "");
        Intrinsics.checkNotNullParameter(certificate, "");
        if (Util.canParseAsIpAddress(host)) {
            return this.verifyIpAddress(host, certificate);
        }
        return this.verifyHostname((String)var1_1, (X509Certificate)var2_2);
    }

    private final boolean verifyIpAddress(String ipAddress, X509Certificate certificate) {
        String canonicalIpAddress = HostnamesKt.toCanonicalHost(ipAddress);
        Iterable $this$any$iv = this.getSubjectAltNames(certificate, 7);
        if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) {
            Iterator iterator2;
            iterator2 = iterator2.iterator();
            while (iterator2.hasNext()) {
                Object t2 = iterator2.next();
                String it = (String)t2;
                if (!Intrinsics.areEqual(canonicalIpAddress, HostnamesKt.toCanonicalHost(t2))) continue;
                return true;
            }
        }
        return false;
    }

    private final boolean verifyHostname(String hostname, X509Certificate certificate) {
        hostname = this.asciiToLowercase(hostname);
        Iterable $this$any$iv = this.getSubjectAltNames(certificate, 2);
        if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) {
            Iterator iterator2;
            iterator2 = iterator2.iterator();
            while (iterator2.hasNext()) {
                Object t2 = iterator2.next();
                String it = (String)t2;
                if (!INSTANCE.verifyHostname(hostname, (String)t2)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final String asciiToLowercase(String $this$asciiToLowercase) {
        void var1_1;
        if (this.isAscii($this$asciiToLowercase)) {
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue(locale, "");
            String string = $this$asciiToLowercase.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue(string, "");
            return string;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isAscii(String $this$isAscii) {
        void var1_1;
        return $this$isAscii.length() == (int)Utf8.size$default((String)var1_1, 0, 0, 3, null);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean verifyHostname(String hostname, String pattern) {
        void var2_3;
        void var1_1;
        CharSequence charSequence = hostname;
        if (charSequence == null || charSequence.length() == 0 || StringsKt.startsWith$default(hostname, ".", false, 2, null) || StringsKt.endsWith$default(hostname, "..", false, 2, null)) {
            return false;
        }
        charSequence = pattern;
        if (charSequence == null || charSequence.length() == 0 || StringsKt.startsWith$default(pattern, ".", false, 2, null) || StringsKt.endsWith$default(pattern, "..", false, 2, null)) {
            return false;
        }
        if (!StringsKt.endsWith$default(hostname, ".", false, 2, null)) {
            hostname = hostname + '.';
        }
        if (!StringsKt.endsWith$default(pattern, ".", false, 2, null)) {
            pattern = pattern + '.';
        }
        if (!StringsKt.contains$default((CharSequence)(pattern = this.asciiToLowercase(pattern)), "*", false, 2, null)) {
            return Intrinsics.areEqual(hostname, pattern);
        }
        if (!StringsKt.startsWith$default(pattern, "*.", false, 2, null) || StringsKt.indexOf$default((CharSequence)pattern, '*', 1, false, 4, null) != -1) {
            return false;
        }
        if (hostname.length() < pattern.length()) {
            return false;
        }
        if (Intrinsics.areEqual("*.", pattern)) {
            return false;
        }
        String string = pattern.substring(1);
        Intrinsics.checkNotNullExpressionValue(string, "");
        String suffix = string;
        if (!StringsKt.endsWith$default(hostname, suffix, false, 2, null)) {
            return false;
        }
        int suffixStartIndexInHostname = hostname.length() - ((String)charSequence).length();
        return suffixStartIndexInHostname <= 0 || StringsKt.lastIndexOf$default((CharSequence)var1_1, '.', (int)(var2_3 - true), false, 4, null) == -1;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> allSubjectAltNames(@NotNull X509Certificate certificate) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter(certificate, "");
        List<String> altIpaNames = this.getSubjectAltNames(certificate, 7);
        List<String> altDnsNames = this.getSubjectAltNames(certificate, 2);
        return CollectionsKt.plus((Collection)var2_2, (Iterable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getSubjectAltNames(X509Certificate certificate, int type) {
        try {
            void var3_3;
            Iterator iterator2;
            Collection<List<?>> collection = certificate.getSubjectAlternativeNames();
            if (collection == null) {
                return CollectionsKt.emptyList();
            }
            Collection<List<?>> subjectAltNames = collection;
            List result = new ArrayList();
            iterator2 = iterator2.iterator();
            while (iterator2.hasNext()) {
                Object altName;
                List subjectAltName = (List)iterator2.next();
                if (subjectAltName == null || subjectAltName.size() < 2 || !Intrinsics.areEqual(subjectAltName.get(0), (Object)type) || subjectAltName.get(1) == null) continue;
                result.add((String)altName);
            }
            return var3_3;
        }
        catch (CertificateParsingException certificateParsingException) {
            return CollectionsKt.emptyList();
        }
    }
}

