/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Headers;
import okhttp3.internal.Util;
import okhttp3.internal.concurrent.Task;
import okhttp3.internal.concurrent.TaskQueue;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.http2.ConnectionShutdownException;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Http2Reader;
import okhttp3.internal.http2.Http2Stream;
import okhttp3.internal.http2.Http2Writer;
import okhttp3.internal.http2.PushObserver;
import okhttp3.internal.http2.Settings;
import okhttp3.internal.platform.Platform;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0018\u0002\n\u0002\b\u0014\u0018\u0000 \u0099\u00012\u00020\u0001:\b\u0098\u0001\u0099\u0001\u009a\u0001\u009b\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010P\u001a\u00020QJ\b\u0010R\u001a\u00020QH\u0016J'\u0010R\u001a\u00020Q2\u0006\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020T2\b\u0010V\u001a\u0004\u0018\u00010WH\u0000\u00a2\u0006\u0002\bXJ\u0012\u0010Y\u001a\u00020Q2\b\u0010Z\u001a\u0004\u0018\u00010WH\u0002J\u0006\u0010[\u001a\u00020QJ\u0010\u0010\\\u001a\u0004\u0018\u00010B2\u0006\u0010]\u001a\u00020\u0012J\u000e\u0010^\u001a\u00020\t2\u0006\u0010_\u001a\u00020\u0006J&\u0010`\u001a\u00020B2\u0006\u0010a\u001a\u00020\u00122\f\u0010b\u001a\b\u0012\u0004\u0012\u00020d0c2\u0006\u0010e\u001a\u00020\tH\u0002J\u001c\u0010`\u001a\u00020B2\f\u0010b\u001a\b\u0012\u0004\u0012\u00020d0c2\u0006\u0010e\u001a\u00020\tJ\u0006\u0010f\u001a\u00020\u0012J-\u0010g\u001a\u00020Q2\u0006\u0010h\u001a\u00020\u00122\u0006\u0010i\u001a\u00020j2\u0006\u0010k\u001a\u00020\u00122\u0006\u0010l\u001a\u00020\tH\u0000\u00a2\u0006\u0002\bmJ+\u0010n\u001a\u00020Q2\u0006\u0010h\u001a\u00020\u00122\f\u0010b\u001a\b\u0012\u0004\u0012\u00020d0c2\u0006\u0010l\u001a\u00020\tH\u0000\u00a2\u0006\u0002\boJ#\u0010p\u001a\u00020Q2\u0006\u0010h\u001a\u00020\u00122\f\u0010b\u001a\b\u0012\u0004\u0012\u00020d0cH\u0000\u00a2\u0006\u0002\bqJ\u001d\u0010r\u001a\u00020Q2\u0006\u0010h\u001a\u00020\u00122\u0006\u0010s\u001a\u00020TH\u0000\u00a2\u0006\u0002\btJ$\u0010u\u001a\u00020B2\u0006\u0010a\u001a\u00020\u00122\f\u0010b\u001a\b\u0012\u0004\u0012\u00020d0c2\u0006\u0010e\u001a\u00020\tJ\u0015\u0010v\u001a\u00020\t2\u0006\u0010h\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\bwJ\u0017\u0010x\u001a\u0004\u0018\u00010B2\u0006\u0010h\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\byJ\r\u0010z\u001a\u00020QH\u0000\u00a2\u0006\u0002\b{J\u000e\u0010|\u001a\u00020Q2\u0006\u0010}\u001a\u00020&J\u000e\u0010~\u001a\u00020Q2\u0006\u0010\u007f\u001a\u00020TJ\u001e\u0010\u0080\u0001\u001a\u00020Q2\t\b\u0002\u0010\u0081\u0001\u001a\u00020\t2\b\b\u0002\u0010E\u001a\u00020FH\u0007J\u0018\u0010\u0082\u0001\u001a\u00020Q2\u0007\u0010\u0083\u0001\u001a\u00020\u0006H\u0000\u00a2\u0006\u0003\b\u0084\u0001J,\u0010\u0085\u0001\u001a\u00020Q2\u0006\u0010h\u001a\u00020\u00122\u0007\u0010\u0086\u0001\u001a\u00020\t2\n\u0010\u0087\u0001\u001a\u0005\u0018\u00010\u0088\u00012\u0006\u0010k\u001a\u00020\u0006J/\u0010\u0089\u0001\u001a\u00020Q2\u0006\u0010h\u001a\u00020\u00122\u0007\u0010\u0086\u0001\u001a\u00020\t2\r\u0010\u008a\u0001\u001a\b\u0012\u0004\u0012\u00020d0cH\u0000\u00a2\u0006\u0003\b\u008b\u0001J\u0007\u0010\u008c\u0001\u001a\u00020QJ\"\u0010\u008c\u0001\u001a\u00020Q2\u0007\u0010\u008d\u0001\u001a\u00020\t2\u0007\u0010\u008e\u0001\u001a\u00020\u00122\u0007\u0010\u008f\u0001\u001a\u00020\u0012J\u0007\u0010\u0090\u0001\u001a\u00020QJ\u001f\u0010\u0091\u0001\u001a\u00020Q2\u0006\u0010h\u001a\u00020\u00122\u0006\u0010\u007f\u001a\u00020TH\u0000\u00a2\u0006\u0003\b\u0092\u0001J\u001f\u0010\u0093\u0001\u001a\u00020Q2\u0006\u0010h\u001a\u00020\u00122\u0006\u0010s\u001a\u00020TH\u0000\u00a2\u0006\u0003\b\u0094\u0001J \u0010\u0095\u0001\u001a\u00020Q2\u0006\u0010h\u001a\u00020\u00122\u0007\u0010\u0096\u0001\u001a\u00020\u0006H\u0000\u00a2\u0006\u0003\b\u0097\u0001R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u0012X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u0012X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001b\"\u0004\b$\u0010\u001dR\u0011\u0010%\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010(\"\u0004\b+\u0010,R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u00102\u001a\u00020\u00062\u0006\u00101\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u001e\u00105\u001a\u00020\u00062\u0006\u00101\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00104R\u0015\u00107\u001a\u000608R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u000e\u0010;\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010<\u001a\u00020=X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R \u0010@\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020B0AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010DR\u000e\u0010E\u001a\u00020FX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010G\u001a\u00020\u00062\u0006\u00101\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u00104R\u001e\u0010I\u001a\u00020\u00062\u0006\u00101\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u00104R\u0011\u0010K\u001a\u00020L\u00a2\u0006\b\n\u0000\u001a\u0004\bM\u0010NR\u000e\u0010O\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u009c\u0001"}, d2={"Lokhttp3/internal/http2/Http2Connection;", "Ljava/io/Closeable;", "builder", "Lokhttp3/internal/http2/Http2Connection$Builder;", "(Lokhttp3/internal/http2/Http2Connection$Builder;)V", "awaitPingsSent", "", "awaitPongsReceived", "client", "", "getClient$okhttp", "()Z", "connectionName", "", "getConnectionName$okhttp", "()Ljava/lang/String;", "currentPushRequests", "", "", "degradedPingsSent", "degradedPongDeadlineNs", "degradedPongsReceived", "intervalPingsSent", "intervalPongsReceived", "isShutdown", "lastGoodStreamId", "getLastGoodStreamId$okhttp", "()I", "setLastGoodStreamId$okhttp", "(I)V", "listener", "Lokhttp3/internal/http2/Http2Connection$Listener;", "getListener$okhttp", "()Lokhttp3/internal/http2/Http2Connection$Listener;", "nextStreamId", "getNextStreamId$okhttp", "setNextStreamId$okhttp", "okHttpSettings", "Lokhttp3/internal/http2/Settings;", "getOkHttpSettings", "()Lokhttp3/internal/http2/Settings;", "peerSettings", "getPeerSettings", "setPeerSettings", "(Lokhttp3/internal/http2/Settings;)V", "pushObserver", "Lokhttp3/internal/http2/PushObserver;", "pushQueue", "Lokhttp3/internal/concurrent/TaskQueue;", "<set-?>", "readBytesAcknowledged", "getReadBytesAcknowledged", "()J", "readBytesTotal", "getReadBytesTotal", "readerRunnable", "Lokhttp3/internal/http2/Http2Connection$ReaderRunnable;", "getReaderRunnable", "()Lokhttp3/internal/http2/Http2Connection$ReaderRunnable;", "settingsListenerQueue", "socket", "Ljava/net/Socket;", "getSocket$okhttp", "()Ljava/net/Socket;", "streams", "", "Lokhttp3/internal/http2/Http2Stream;", "getStreams$okhttp", "()Ljava/util/Map;", "taskRunner", "Lokhttp3/internal/concurrent/TaskRunner;", "writeBytesMaximum", "getWriteBytesMaximum", "writeBytesTotal", "getWriteBytesTotal", "writer", "Lokhttp3/internal/http2/Http2Writer;", "getWriter", "()Lokhttp3/internal/http2/Http2Writer;", "writerQueue", "awaitPong", "", "close", "connectionCode", "Lokhttp3/internal/http2/ErrorCode;", "streamCode", "cause", "Ljava/io/IOException;", "close$okhttp", "failConnection", "e", "flush", "getStream", "id", "isHealthy", "nowNs", "newStream", "associatedStreamId", "requestHeaders", "", "Lokhttp3/internal/http2/Header;", "out", "openStreamCount", "pushDataLater", "streamId", "source", "Lokio/BufferedSource;", "byteCount", "inFinished", "pushDataLater$okhttp", "pushHeadersLater", "pushHeadersLater$okhttp", "pushRequestLater", "pushRequestLater$okhttp", "pushResetLater", "errorCode", "pushResetLater$okhttp", "pushStream", "pushedStream", "pushedStream$okhttp", "removeStream", "removeStream$okhttp", "sendDegradedPingLater", "sendDegradedPingLater$okhttp", "setSettings", "settings", "shutdown", "statusCode", "start", "sendConnectionPreface", "updateConnectionFlowControl", "read", "updateConnectionFlowControl$okhttp", "writeData", "outFinished", "buffer", "Lokio/Buffer;", "writeHeaders", "alternating", "writeHeaders$okhttp", "writePing", "reply", "payload1", "payload2", "writePingAndAwaitPong", "writeSynReset", "writeSynReset$okhttp", "writeSynResetLater", "writeSynResetLater$okhttp", "writeWindowUpdateLater", "unacknowledgedBytesRead", "writeWindowUpdateLater$okhttp", "Builder", "Companion", "Listener", "ReaderRunnable", "okhttp"})
@SourceDebugExtension(value={"SMAP\nHttp2Connection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http2Connection.kt\nokhttp3/internal/http2/Http2Connection\n+ 2 TaskQueue.kt\nokhttp3/internal/concurrent/TaskQueue\n+ 3 Util.kt\nokhttp3/internal/Util\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1006:1\n84#2,4:1007\n90#2,13:1014\n90#2,13:1027\n90#2,13:1069\n90#2,13:1082\n90#2,13:1095\n90#2,13:1108\n90#2,13:1121\n90#2,13:1134\n563#3:1011\n557#3:1013\n557#3:1040\n615#3,4:1041\n402#3,5:1045\n402#3,5:1053\n402#3,5:1059\n402#3,5:1064\n1#4:1012\n37#5,2:1050\n13309#6:1052\n13310#6:1058\n*S KotlinDebug\n*F\n+ 1 Http2Connection.kt\nokhttp3/internal/http2/Http2Connection\n*L\n152#1:1007,4\n340#1:1014,13\n361#1:1027,13\n506#1:1069,13\n554#1:1082,13\n893#1:1095,13\n911#1:1108,13\n938#1:1121,13\n952#1:1134,13\n183#1:1011\n319#1:1013\n402#1:1040\n446#1:1041,4\n448#1:1045,5\n461#1:1053,5\n467#1:1059,5\n472#1:1064,5\n455#1:1050,2\n460#1:1052\n460#1:1058\n*E\n"})
public final class Http2Connection
implements Closeable {
    @NotNull
    public static final Companion Companion;
    private final boolean client;
    @NotNull
    private final Listener listener;
    @NotNull
    private final Map<Integer, Http2Stream> streams;
    @NotNull
    private final String connectionName;
    private int lastGoodStreamId;
    private int nextStreamId;
    private boolean isShutdown;
    @NotNull
    private final TaskRunner taskRunner;
    @NotNull
    private final TaskQueue writerQueue;
    @NotNull
    private final TaskQueue pushQueue;
    @NotNull
    private final TaskQueue settingsListenerQueue;
    @NotNull
    private final PushObserver pushObserver;
    private long intervalPingsSent;
    private long intervalPongsReceived;
    private long degradedPingsSent;
    private long degradedPongsReceived;
    private long awaitPingsSent;
    private long awaitPongsReceived;
    private long degradedPongDeadlineNs;
    @NotNull
    private final Settings okHttpSettings;
    @NotNull
    private Settings peerSettings;
    private long readBytesTotal;
    private long readBytesAcknowledged;
    private long writeBytesTotal;
    private long writeBytesMaximum;
    @NotNull
    private final Socket socket;
    @NotNull
    private final Http2Writer writer;
    @NotNull
    private final ReaderRunnable readerRunnable;
    @NotNull
    private final Set<Integer> currentPushRequests;
    public static final int OKHTTP_CLIENT_WINDOW_SIZE = 0x1000000;
    @NotNull
    private static final Settings DEFAULT_SETTINGS;
    public static final int INTERVAL_PING = 1;
    public static final int DEGRADED_PING = 2;
    public static final int AWAIT_PING = 3;
    public static final int DEGRADED_PONG_TIMEOUT_NS = 1000000000;

    /*
     * WARNING - void declaration
     */
    public Http2Connection(@NotNull Builder builder) {
        Settings settings;
        Intrinsics.checkNotNullParameter(builder, "");
        this.client = ((Builder)builder).getClient$okhttp();
        this.listener = ((Builder)builder).getListener$okhttp();
        this.streams = new LinkedHashMap();
        this.connectionName = ((Builder)builder).getConnectionName$okhttp();
        this.nextStreamId = ((Builder)builder).getClient$okhttp() ? 3 : 2;
        this.taskRunner = ((Builder)builder).getTaskRunner$okhttp();
        this.writerQueue = this.taskRunner.newQueue();
        this.pushQueue = this.taskRunner.newQueue();
        this.settingsListenerQueue = this.taskRunner.newQueue();
        this.pushObserver = ((Builder)builder).getPushObserver$okhttp();
        Settings settings2 = settings = new Settings();
        Http2Connection http2Connection = this;
        if (((Builder)builder).getClient$okhttp()) {
            settings2.set(7, 0x1000000);
        }
        http2Connection.okHttpSettings = settings;
        this.peerSettings = DEFAULT_SETTINGS;
        this.writeBytesMaximum = this.peerSettings.getInitialWindowSize();
        this.socket = ((Builder)builder).getSocket$okhttp();
        this.writer = new Http2Writer(((Builder)builder).getSink$okhttp(), this.client);
        this.readerRunnable = new ReaderRunnable(this, new Http2Reader(((Builder)builder).getSource$okhttp(), this.client));
        this.currentPushRequests = new LinkedHashSet();
        if (((Builder)builder).getPingIntervalMillis$okhttp() != 0) {
            void var2_3;
            void var1_1;
            long pingIntervalNanos = TimeUnit.MILLISECONDS.toNanos(((Builder)builder).getPingIntervalMillis$okhttp());
            builder = this.writerQueue;
            String name$iv = this.connectionName + " ping";
            var1_1.schedule(new Task(name$iv, this, pingIntervalNanos){
                final /* synthetic */ Http2Connection this$0;
                final /* synthetic */ long $pingIntervalNanos$inlined;
                {
                    void var1_1;
                    this.this$0 = http2Connection;
                    this.$pingIntervalNanos$inlined = l2;
                    super((String)var1_1, false, 2, null);
                }

                public final long runOnce() {
                    boolean bl;
                    Http2Connection http2Connection = this.this$0;
                    synchronized (http2Connection) {
                        boolean bl2;
                        if (Http2Connection.access$getIntervalPongsReceived$p(this.this$0) < Http2Connection.access$getIntervalPingsSent$p(this.this$0)) {
                            bl2 = true;
                        } else {
                            long l2 = Http2Connection.access$getIntervalPingsSent$p(this.this$0);
                            Http2Connection.access$setIntervalPingsSent$p(this.this$0, l2 + 1L);
                            bl2 = false;
                        }
                        bl = bl2;
                    }
                    boolean bl3 = bl;
                    if (bl3) {
                        Http2Connection.access$failConnection(this.this$0, null);
                        return -1L;
                    }
                    this.this$0.writePing(false, 1, 0);
                    return this.$pingIntervalNanos$inlined;
                }
            }, (long)var2_3);
        }
    }

    public final boolean getClient$okhttp() {
        return this.client;
    }

    @NotNull
    public final Listener getListener$okhttp() {
        return this.listener;
    }

    @NotNull
    public final Map<Integer, Http2Stream> getStreams$okhttp() {
        return this.streams;
    }

    @NotNull
    public final String getConnectionName$okhttp() {
        return this.connectionName;
    }

    public final int getLastGoodStreamId$okhttp() {
        return this.lastGoodStreamId;
    }

    /*
     * WARNING - void declaration
     */
    public final void setLastGoodStreamId$okhttp(int n2) {
        void var1_1;
        this.lastGoodStreamId = var1_1;
    }

    public final int getNextStreamId$okhttp() {
        return this.nextStreamId;
    }

    /*
     * WARNING - void declaration
     */
    public final void setNextStreamId$okhttp(int n2) {
        void var1_1;
        this.nextStreamId = var1_1;
    }

    @NotNull
    public final Settings getOkHttpSettings() {
        return this.okHttpSettings;
    }

    @NotNull
    public final Settings getPeerSettings() {
        return this.peerSettings;
    }

    /*
     * WARNING - void declaration
     */
    public final void setPeerSettings(@NotNull Settings settings) {
        void var1_1;
        Intrinsics.checkNotNullParameter(settings, "");
        this.peerSettings = var1_1;
    }

    public final long getReadBytesTotal() {
        return this.readBytesTotal;
    }

    public final long getReadBytesAcknowledged() {
        return this.readBytesAcknowledged;
    }

    public final long getWriteBytesTotal() {
        return this.writeBytesTotal;
    }

    public final long getWriteBytesMaximum() {
        return this.writeBytesMaximum;
    }

    @NotNull
    public final Socket getSocket$okhttp() {
        return this.socket;
    }

    @NotNull
    public final Http2Writer getWriter() {
        return this.writer;
    }

    @NotNull
    public final ReaderRunnable getReaderRunnable() {
        return this.readerRunnable;
    }

    public final synchronized int openStreamCount() {
        return this.streams.size();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final synchronized Http2Stream getStream(int id) {
        void var1_1;
        return this.streams.get((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final synchronized Http2Stream removeStream$okhttp(int streamId) {
        void var1_2;
        void var2_3;
        Http2Stream stream = this.streams.remove(streamId);
        Http2Connection $this$notifyAll$iv = this;
        Intrinsics.checkNotNull($this$notifyAll$iv);
        ((Object)var2_3).notifyAll();
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void updateConnectionFlowControl$okhttp(long read) {
        void var1_1;
        this.readBytesTotal += var1_1;
        long readBytesToAcknowledge = this.readBytesTotal - this.readBytesAcknowledged;
        if (readBytesToAcknowledge >= (long)(this.okHttpSettings.getInitialWindowSize() / 2)) {
            void var3_2;
            this.writeWindowUpdateLater$okhttp(0, readBytesToAcknowledge);
            this.readBytesAcknowledged += var3_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Http2Stream pushStream(int associatedStreamId2, @NotNull List<Header> requestHeaders, boolean out) throws IOException {
        void var3_4;
        void var2_3;
        void var1_1;
        Intrinsics.checkNotNullParameter(requestHeaders, "");
        if (!(!this.client)) {
            String associatedStreamId2 = "Client cannot push requests.";
            throw new IllegalStateException(associatedStreamId2.toString());
        }
        return this.newStream((int)var1_1, (List<Header>)var2_3, (boolean)var3_4);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Http2Stream newStream(@NotNull List<Header> requestHeaders, boolean out) throws IOException {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(requestHeaders, "");
        return this.newStream(0, (List<Header>)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private final Http2Stream newStream(int associatedStreamId2, List<Header> requestHeaders, boolean out) throws IOException {
        void var3_6;
        Http2Stream stream;
        boolean outFinished = !out;
        Http2Writer http2Writer = this.writer;
        synchronized (http2Writer) {
            int streamId;
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                boolean flushHeaders;
                if (this.nextStreamId > 0x3FFFFFFF) {
                    this.shutdown(ErrorCode.REFUSED_STREAM);
                }
                if (this.isShutdown) {
                    throw new ConnectionShutdownException();
                }
                streamId = this.nextStreamId;
                this.nextStreamId += 2;
                stream = new Http2Stream(streamId, this, outFinished, false, null);
                boolean bl = flushHeaders = !out || this.writeBytesTotal >= this.writeBytesMaximum || stream.getWriteBytesTotal() >= stream.getWriteBytesMaximum();
                if (stream.isOpen()) {
                    this.streams.put(streamId, stream);
                }
            }
            if (associatedStreamId2 == 0) {
                this.writer.headers(outFinished, streamId, requestHeaders);
            } else {
                void var2_5;
                void var1_1;
                if (!(!this.client)) {
                    String associatedStreamId2 = "client streams shouldn't have associated stream IDs";
                    throw new IllegalArgumentException(associatedStreamId2.toString());
                }
                this.writer.pushPromise((int)var1_1, streamId, (List<Header>)var2_5);
            }
        }
        if (var3_6 != false) {
            this.writer.flush();
        }
        return stream;
    }

    /*
     * WARNING - void declaration
     */
    public final void writeHeaders$okhttp(int streamId, boolean outFinished, @NotNull List<Header> alternating) throws IOException {
        void var3_3;
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter(alternating, "");
        this.writer.headers((boolean)var2_2, (int)var1_1, (List<Header>)var3_3);
    }

    public final void writeData(int streamId, boolean outFinished, @Nullable Buffer buffer, long byteCount) throws IOException {
        if (byteCount == 0L) {
            this.writer.data(outFinished, streamId, buffer, 0);
            return;
        }
        long byteCount2 = byteCount;
        while (byteCount2 > 0L) {
            int toWrite;
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                try {
                    while (this.writeBytesTotal >= this.writeBytesMaximum) {
                        if (!this.streams.containsKey(streamId)) {
                            throw new IOException("stream closed");
                        }
                        Http2Connection $this$wait$iv = this;
                        Intrinsics.checkNotNull($this$wait$iv);
                        ((Object)$this$wait$iv).wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
                int $this$wait$iv = (int)Math.min(byteCount2, this.writeBytesMaximum - this.writeBytesTotal);
                toWrite = Math.min($this$wait$iv, this.writer.maxDataLength());
                this.writeBytesTotal += (long)toWrite;
            }
            this.writer.data(outFinished && (byteCount2 -= (long)toWrite) == 0L, streamId, buffer, toWrite);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void writeSynResetLater$okhttp(int streamId, @NotNull ErrorCode errorCode) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)errorCode, "");
        TaskQueue taskQueue = this.writerQueue;
        String name$iv = this.connectionName + '[' + streamId + "] writeSynReset";
        taskQueue.schedule(new Task(name$iv, true, this, (int)var1_1, (ErrorCode)var2_2){
            final /* synthetic */ Http2Connection this$0;
            final /* synthetic */ int $streamId$inlined;
            final /* synthetic */ ErrorCode $errorCode$inlined;
            {
                void var2_2;
                void var1_1;
                this.this$0 = http2Connection;
                this.$streamId$inlined = n2;
                this.$errorCode$inlined = errorCode;
                super((String)var1_1, (boolean)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            public final long runOnce() {
                try {
                    this.this$0.writeSynReset$okhttp(this.$streamId$inlined, this.$errorCode$inlined);
                }
                catch (IOException e2) {
                    void var1_1;
                    Http2Connection.access$failConnection(this.this$0, (IOException)var1_1);
                }
                return -1L;
            }
        }, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeSynReset$okhttp(int streamId, @NotNull ErrorCode statusCode) throws IOException {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)statusCode, "");
        this.writer.rstStream((int)var1_1, (ErrorCode)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeWindowUpdateLater$okhttp(int streamId, long unacknowledgedBytesRead) {
        void var2_2;
        void var1_1;
        void $this$iv;
        TaskQueue taskQueue = this.writerQueue;
        String name$iv = this.connectionName + '[' + streamId + "] windowUpdate";
        $this$iv.schedule(new Task(name$iv, true, this, (int)var1_1, (long)var2_2){
            final /* synthetic */ Http2Connection this$0;
            final /* synthetic */ int $streamId$inlined;
            final /* synthetic */ long $unacknowledgedBytesRead$inlined;
            {
                void var2_2;
                void var1_1;
                this.this$0 = http2Connection;
                this.$streamId$inlined = n2;
                this.$unacknowledgedBytesRead$inlined = l2;
                super((String)var1_1, (boolean)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            public final long runOnce() {
                try {
                    this.this$0.getWriter().windowUpdate(this.$streamId$inlined, this.$unacknowledgedBytesRead$inlined);
                }
                catch (IOException e2) {
                    void var1_1;
                    Http2Connection.access$failConnection(this.this$0, (IOException)var1_1);
                }
                return -1L;
            }
        }, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public final void writePing(boolean reply, int payload1, int payload2) {
        try {
            void var3_4;
            void var2_3;
            this.writer.ping(reply, (int)var2_3, (int)var3_4);
            return;
        }
        catch (IOException e2) {
            void var1_2;
            this.failConnection((IOException)var1_2);
            return;
        }
    }

    public final void writePingAndAwaitPong() throws InterruptedException {
        this.writePing();
        this.awaitPong();
    }

    public final void writePing() throws InterruptedException {
        Http2Connection http2Connection = this;
        synchronized (http2Connection) {
            long l2 = this.awaitPingsSent;
            this.awaitPingsSent = l2 + 1L;
        }
        this.writePing(false, 3, 1330343787);
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void awaitPong() throws InterruptedException {
        while (this.awaitPongsReceived < this.awaitPingsSent) {
            void var1_1;
            Http2Connection $this$wait$iv = this;
            Intrinsics.checkNotNull($this$wait$iv);
            ((Object)var1_1).wait();
        }
    }

    public final void flush() throws IOException {
        this.writer.flush();
    }

    /*
     * WARNING - void declaration
     */
    public final void shutdown(@NotNull ErrorCode statusCode) throws IOException {
        Intrinsics.checkNotNullParameter((Object)statusCode, "");
        Http2Writer http2Writer = this.writer;
        synchronized (http2Writer) {
            void var1_1;
            void var3_5;
            Ref.IntRef lastGoodStreamId = new Ref.IntRef();
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                if (this.isShutdown) {
                    return;
                }
                this.isShutdown = true;
                lastGoodStreamId.element = this.lastGoodStreamId;
            }
            this.writer.goAway(var3_5.element, (ErrorCode)var1_1, Util.EMPTY_BYTE_ARRAY);
            return;
        }
    }

    @Override
    public final void close() {
        this.close$okhttp(ErrorCode.NO_ERROR, ErrorCode.CANCEL, null);
    }

    public final void close$okhttp(@NotNull ErrorCode connectionCode, @NotNull ErrorCode streamCode, @Nullable IOException cause) {
        Http2Connection http2Connection;
        Intrinsics.checkNotNullParameter((Object)connectionCode, "");
        Intrinsics.checkNotNullParameter((Object)streamCode, "");
        Http2Connection $this$assertThreadDoesntHoldLock$iv = this;
        if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertThreadDoesntHoldLock$iv));
        }
        try {
            this.shutdown((ErrorCode)((Object)http2Connection));
        }
        catch (IOException iOException) {}
        Http2Stream[] streamsToClose = null;
        http2Connection = this;
        synchronized (http2Connection) {
            if (!this.streams.isEmpty()) {
                Http2Stream[] http2StreamArray = streamsToClose = this.streams.values();
                streamsToClose = streamsToClose.toArray(new Http2Stream[0]);
                this.streams.clear();
            }
        }
        Http2Stream[] http2StreamArray = streamsToClose;
        if (http2StreamArray != null) {
            Http2Stream[] $this$forEach$iv = http2StreamArray;
            int n2 = $this$forEach$iv.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Http2Stream http2Stream;
                Http2Stream stream = http2Stream = $this$forEach$iv[i2];
                try {
                    stream.close(streamCode, cause);
                    continue;
                }
                catch (IOException iOException) {}
            }
        }
        try {
            this.writer.close();
        }
        catch (IOException iOException) {}
        try {
            this.socket.close();
        }
        catch (IOException iOException) {}
        this.writerQueue.shutdown();
        this.pushQueue.shutdown();
        this.settingsListenerQueue.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    private final void failConnection(IOException e2) {
        void var1_1;
        ErrorCode errorCode = ErrorCode.PROTOCOL_ERROR;
        this.close$okhttp(errorCode, errorCode, (IOException)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public final void start(boolean sendConnectionPreface, @NotNull TaskRunner taskRunner) throws IOException {
        void var3_4;
        void var2_3;
        void var1_2;
        Intrinsics.checkNotNullParameter(taskRunner, "");
        if (sendConnectionPreface) {
            this.writer.connectionPreface();
            this.writer.settings(this.okHttpSettings);
            int windowSize = this.okHttpSettings.getInitialWindowSize();
            if (windowSize != 65535) {
                this.writer.windowUpdate(0, windowSize - 65535);
            }
        }
        TaskQueue windowSize = ((TaskRunner)taskRunner).newQueue();
        taskRunner = this.connectionName;
        Function0 block$iv = this.readerRunnable;
        var1_2.schedule(new Task((String)var2_3, true, (Function0<Unit>)var3_4){
            final /* synthetic */ Function0<Unit> $block;
            {
                void var2_2;
                void var1_1;
                void var3_3;
                this.$block = var3_3;
                super((String)var1_1, (boolean)var2_2);
            }

            public final long runOnce() {
                this.$block.invoke();
                return -1L;
            }
        }, 0L);
    }

    public static /* synthetic */ void start$default(Http2Connection http2Connection, boolean bl, TaskRunner taskRunner, int n2, Object object) throws IOException {
        if ((n2 & 1) != 0) {
            bl = true;
        }
        if ((n2 & 2) != 0) {
            taskRunner = TaskRunner.INSTANCE;
        }
        http2Connection.start(bl, taskRunner);
    }

    /*
     * WARNING - void declaration
     */
    public final void setSettings(@NotNull Settings settings) throws IOException {
        Intrinsics.checkNotNullParameter(settings, "");
        Http2Writer http2Writer = this.writer;
        synchronized (http2Writer) {
            void var1_1;
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                if (this.isShutdown) {
                    throw new ConnectionShutdownException();
                }
                this.okHttpSettings.merge(settings);
            }
            this.writer.settings((Settings)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized boolean isHealthy(long nowNs) {
        void var1_1;
        if (this.isShutdown) {
            return false;
        }
        return this.degradedPongsReceived >= this.degradedPingsSent || var1_1 < this.degradedPongDeadlineNs;
    }

    /*
     * WARNING - void declaration
     */
    public final void sendDegradedPingLater$okhttp() {
        void var2_4;
        Object object = this;
        synchronized (object) {
            if (this.degradedPongsReceived < this.degradedPingsSent) {
                return;
            }
            long l2 = this.degradedPingsSent;
            this.degradedPingsSent = l2 + 1L;
            this.degradedPongDeadlineNs = System.nanoTime() + 1000000000L;
        }
        object = this.writerQueue;
        String name$iv = this.connectionName + " ping";
        ((TaskQueue)object).schedule(new Task((String)var2_4, true, this){
            final /* synthetic */ Http2Connection this$0;
            {
                void var2_2;
                void var1_1;
                this.this$0 = http2Connection;
                super((String)var1_1, (boolean)var2_2);
            }

            public final long runOnce() {
                this.this$0.writePing(false, 2, 0);
                return -1L;
            }
        }, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean pushedStream$okhttp(int streamId) {
        void var1_1;
        return streamId != 0 && (var1_1 & 1) == 0;
    }

    /*
     * WARNING - void declaration
     */
    public final void pushRequestLater$okhttp(int streamId, @NotNull List<Header> requestHeaders) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(requestHeaders, "");
        Object object = this;
        synchronized (object) {
            if (this.currentPushRequests.contains(streamId)) {
                this.writeSynResetLater$okhttp(streamId, ErrorCode.PROTOCOL_ERROR);
                return;
            }
            this.currentPushRequests.add(streamId);
        }
        object = this.pushQueue;
        String name$iv = this.connectionName + '[' + streamId + "] onRequest";
        ((TaskQueue)object).schedule(new Task(name$iv, true, this, (int)var1_1, (List)var2_2){
            final /* synthetic */ Http2Connection this$0;
            final /* synthetic */ int $streamId$inlined;
            final /* synthetic */ List $requestHeaders$inlined;
            {
                void var2_2;
                void var1_1;
                this.this$0 = http2Connection;
                this.$streamId$inlined = n2;
                this.$requestHeaders$inlined = list;
                super((String)var1_1, (boolean)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            public final long runOnce() {
                block5: {
                    boolean cancel = Http2Connection.access$getPushObserver$p(this.this$0).onRequest(this.$streamId$inlined, this.$requestHeaders$inlined);
                    try {
                        void var1_1;
                        if (var1_1 == false) break block5;
                        this.this$0.getWriter().rstStream(this.$streamId$inlined, ErrorCode.CANCEL);
                        Http2Connection http2Connection = this.this$0;
                        synchronized (http2Connection) {
                            Http2Connection.access$getCurrentPushRequests$p(this.this$0).remove(this.$streamId$inlined);
                        }
                    }
                    catch (IOException iOException) {}
                }
                return -1L;
            }
        }, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public final void pushHeadersLater$okhttp(int streamId, @NotNull List<Header> requestHeaders, boolean inFinished) {
        void var3_3;
        void var2_2;
        void var1_1;
        void $this$iv;
        Intrinsics.checkNotNullParameter(requestHeaders, "");
        TaskQueue taskQueue = this.pushQueue;
        String name$iv = this.connectionName + '[' + streamId + "] onHeaders";
        $this$iv.schedule(new Task(name$iv, true, this, (int)var1_1, (List)var2_2, (boolean)var3_3){
            final /* synthetic */ Http2Connection this$0;
            final /* synthetic */ int $streamId$inlined;
            final /* synthetic */ List $requestHeaders$inlined;
            final /* synthetic */ boolean $inFinished$inlined;
            {
                void var2_2;
                void var1_1;
                this.this$0 = http2Connection;
                this.$streamId$inlined = n2;
                this.$requestHeaders$inlined = list;
                this.$inFinished$inlined = bl;
                super((String)var1_1, (boolean)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            public final long runOnce() {
                block6: {
                    boolean cancel = Http2Connection.access$getPushObserver$p(this.this$0).onHeaders(this.$streamId$inlined, this.$requestHeaders$inlined, this.$inFinished$inlined);
                    try {
                        void var1_1;
                        if (cancel) {
                            this.this$0.getWriter().rstStream(this.$streamId$inlined, ErrorCode.CANCEL);
                        }
                        if (var1_1 == false && !this.$inFinished$inlined) break block6;
                        Http2Connection http2Connection = this.this$0;
                        synchronized (http2Connection) {
                            Http2Connection.access$getCurrentPushRequests$p(this.this$0).remove(this.$streamId$inlined);
                        }
                    }
                    catch (IOException iOException) {}
                }
                return -1L;
            }
        }, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public final void pushDataLater$okhttp(int streamId, @NotNull BufferedSource source2, int byteCount, boolean inFinished) throws IOException {
        void var3_3;
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter(source2, "");
        Buffer buffer = new Buffer();
        source2.require(byteCount);
        source2.read(buffer, byteCount);
        source2 = this.pushQueue;
        String name$iv = this.connectionName + '[' + streamId + "] onData";
        var2_2.schedule(new Task(name$iv, true, this, (int)var1_1, buffer, (int)var3_3, inFinished){
            final /* synthetic */ Http2Connection this$0;
            final /* synthetic */ int $streamId$inlined;
            final /* synthetic */ Buffer $buffer$inlined;
            final /* synthetic */ int $byteCount$inlined;
            final /* synthetic */ boolean $inFinished$inlined;
            {
                void var2_2;
                void var1_1;
                this.this$0 = http2Connection;
                this.$streamId$inlined = n2;
                this.$buffer$inlined = buffer;
                this.$byteCount$inlined = n3;
                this.$inFinished$inlined = bl;
                super((String)var1_1, (boolean)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            public final long runOnce() {
                block6: {
                    try {
                        void var1_1;
                        boolean cancel = Http2Connection.access$getPushObserver$p(this.this$0).onData(this.$streamId$inlined, this.$buffer$inlined, this.$byteCount$inlined, this.$inFinished$inlined);
                        if (cancel) {
                            this.this$0.getWriter().rstStream(this.$streamId$inlined, ErrorCode.CANCEL);
                        }
                        if (var1_1 == false && !this.$inFinished$inlined) break block6;
                        Http2Connection http2Connection = this.this$0;
                        synchronized (http2Connection) {
                            Http2Connection.access$getCurrentPushRequests$p(this.this$0).remove(this.$streamId$inlined);
                        }
                    }
                    catch (IOException iOException) {}
                }
                return -1L;
            }
        }, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public final void pushResetLater$okhttp(int streamId, @NotNull ErrorCode errorCode) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)errorCode, "");
        TaskQueue taskQueue = this.pushQueue;
        String name$iv = this.connectionName + '[' + streamId + "] onReset";
        taskQueue.schedule(new Task(name$iv, true, this, (int)var1_1, (ErrorCode)var2_2){
            final /* synthetic */ Http2Connection this$0;
            final /* synthetic */ int $streamId$inlined;
            final /* synthetic */ ErrorCode $errorCode$inlined;
            {
                void var2_2;
                void var1_1;
                this.this$0 = http2Connection;
                this.$streamId$inlined = n2;
                this.$errorCode$inlined = errorCode;
                super((String)var1_1, (boolean)var2_2);
            }

            public final long runOnce() {
                Http2Connection.access$getPushObserver$p(this.this$0).onReset(this.$streamId$inlined, this.$errorCode$inlined);
                Http2Connection http2Connection = this.this$0;
                synchronized (http2Connection) {
                    Http2Connection.access$getCurrentPushRequests$p(this.this$0).remove(this.$streamId$inlined);
                }
                return -1L;
            }
        }, 0L);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public final void start(boolean sendConnectionPreface) throws IOException {
        void var1_1;
        Http2Connection.start$default(this, (boolean)var1_1, null, 2, null);
    }

    @JvmOverloads
    public final void start() throws IOException {
        Http2Connection.start$default(this, false, null, 3, null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$failConnection(Http2Connection $this, IOException e2) {
        void var1_1;
        $this.failConnection((IOException)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setIntervalPongsReceived$p(Http2Connection $this, long l2) {
        void var1_1;
        $this.intervalPongsReceived = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setDegradedPongsReceived$p(Http2Connection $this, long l2) {
        void var1_1;
        $this.degradedPongsReceived = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setAwaitPongsReceived$p(Http2Connection $this, long l2) {
        void var1_1;
        $this.awaitPongsReceived = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setShutdown$p(Http2Connection $this, boolean bl) {
        void var1_1;
        $this.isShutdown = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setWriteBytesMaximum$p(Http2Connection $this, long l2) {
        void var1_1;
        $this.writeBytesMaximum = var1_1;
    }

    public static final /* synthetic */ long access$getIntervalPingsSent$p(Http2Connection $this) {
        return $this.intervalPingsSent;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setIntervalPingsSent$p(Http2Connection $this, long l2) {
        void var1_1;
        $this.intervalPingsSent = var1_1;
    }

    public static final /* synthetic */ Set access$getCurrentPushRequests$p(Http2Connection $this) {
        return $this.currentPushRequests;
    }

    public static final /* synthetic */ PushObserver access$getPushObserver$p(Http2Connection $this) {
        return $this.pushObserver;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var1_1;
        Settings settings;
        Companion = new Companion(null);
        Settings $this$DEFAULT_SETTINGS_u24lambda_u2435 = settings = new Settings();
        settings.set(7, 65535);
        var1_1.set(5, 16384);
        DEFAULT_SETTINGS = settings;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u00107\u001a\u000208J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001eJ.\u0010)\u001a\u00020\u00002\u0006\u0010)\u001a\u00020*2\b\b\u0002\u00109\u001a\u00020\f2\b\b\u0002\u0010/\u001a\u0002002\b\b\u0002\u0010#\u001a\u00020$H\u0007R\u001a\u0010\u0002\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020$X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020*X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001a\u0010/\u001a\u000200X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106\u00a8\u0006:"}, d2={"Lokhttp3/internal/http2/Http2Connection$Builder;", "", "client", "", "taskRunner", "Lokhttp3/internal/concurrent/TaskRunner;", "(ZLokhttp3/internal/concurrent/TaskRunner;)V", "getClient$okhttp", "()Z", "setClient$okhttp", "(Z)V", "connectionName", "", "getConnectionName$okhttp", "()Ljava/lang/String;", "setConnectionName$okhttp", "(Ljava/lang/String;)V", "listener", "Lokhttp3/internal/http2/Http2Connection$Listener;", "getListener$okhttp", "()Lokhttp3/internal/http2/Http2Connection$Listener;", "setListener$okhttp", "(Lokhttp3/internal/http2/Http2Connection$Listener;)V", "pingIntervalMillis", "", "getPingIntervalMillis$okhttp", "()I", "setPingIntervalMillis$okhttp", "(I)V", "pushObserver", "Lokhttp3/internal/http2/PushObserver;", "getPushObserver$okhttp", "()Lokhttp3/internal/http2/PushObserver;", "setPushObserver$okhttp", "(Lokhttp3/internal/http2/PushObserver;)V", "sink", "Lokio/BufferedSink;", "getSink$okhttp", "()Lokio/BufferedSink;", "setSink$okhttp", "(Lokio/BufferedSink;)V", "socket", "Ljava/net/Socket;", "getSocket$okhttp", "()Ljava/net/Socket;", "setSocket$okhttp", "(Ljava/net/Socket;)V", "source", "Lokio/BufferedSource;", "getSource$okhttp", "()Lokio/BufferedSource;", "setSource$okhttp", "(Lokio/BufferedSource;)V", "getTaskRunner$okhttp", "()Lokhttp3/internal/concurrent/TaskRunner;", "build", "Lokhttp3/internal/http2/Http2Connection;", "peerName", "okhttp"})
    public static final class Builder {
        private boolean client;
        @NotNull
        private final TaskRunner taskRunner;
        public Socket socket;
        public String connectionName;
        public BufferedSource source;
        public BufferedSink sink;
        @NotNull
        private Listener listener;
        @NotNull
        private PushObserver pushObserver;
        private int pingIntervalMillis;

        /*
         * WARNING - void declaration
         */
        public Builder(boolean client, @NotNull TaskRunner taskRunner) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter(taskRunner, "");
            this.client = var1_1;
            this.taskRunner = var2_2;
            this.listener = Listener.REFUSE_INCOMING_STREAMS;
            this.pushObserver = PushObserver.CANCEL;
        }

        public final boolean getClient$okhttp() {
            return this.client;
        }

        /*
         * WARNING - void declaration
         */
        public final void setClient$okhttp(boolean bl) {
            void var1_1;
            this.client = var1_1;
        }

        @NotNull
        public final TaskRunner getTaskRunner$okhttp() {
            return this.taskRunner;
        }

        @NotNull
        public final Socket getSocket$okhttp() {
            Socket socket = this.socket;
            if (socket != null) {
                return socket;
            }
            Intrinsics.throwUninitializedPropertyAccessException("");
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public final void setSocket$okhttp(@NotNull Socket socket) {
            void var1_1;
            Intrinsics.checkNotNullParameter(socket, "");
            this.socket = var1_1;
        }

        @NotNull
        public final String getConnectionName$okhttp() {
            String string = this.connectionName;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException("");
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public final void setConnectionName$okhttp(@NotNull String string) {
            void var1_1;
            Intrinsics.checkNotNullParameter(string, "");
            this.connectionName = var1_1;
        }

        @NotNull
        public final BufferedSource getSource$okhttp() {
            BufferedSource bufferedSource = this.source;
            if (bufferedSource != null) {
                return bufferedSource;
            }
            Intrinsics.throwUninitializedPropertyAccessException("");
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public final void setSource$okhttp(@NotNull BufferedSource bufferedSource) {
            void var1_1;
            Intrinsics.checkNotNullParameter(bufferedSource, "");
            this.source = var1_1;
        }

        @NotNull
        public final BufferedSink getSink$okhttp() {
            BufferedSink bufferedSink = this.sink;
            if (bufferedSink != null) {
                return bufferedSink;
            }
            Intrinsics.throwUninitializedPropertyAccessException("");
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public final void setSink$okhttp(@NotNull BufferedSink bufferedSink) {
            void var1_1;
            Intrinsics.checkNotNullParameter(bufferedSink, "");
            this.sink = var1_1;
        }

        @NotNull
        public final Listener getListener$okhttp() {
            return this.listener;
        }

        /*
         * WARNING - void declaration
         */
        public final void setListener$okhttp(@NotNull Listener listener) {
            void var1_1;
            Intrinsics.checkNotNullParameter(listener, "");
            this.listener = var1_1;
        }

        @NotNull
        public final PushObserver getPushObserver$okhttp() {
            return this.pushObserver;
        }

        /*
         * WARNING - void declaration
         */
        public final void setPushObserver$okhttp(@NotNull PushObserver pushObserver) {
            void var1_1;
            Intrinsics.checkNotNullParameter(pushObserver, "");
            this.pushObserver = var1_1;
        }

        public final int getPingIntervalMillis$okhttp() {
            return this.pingIntervalMillis;
        }

        /*
         * WARNING - void declaration
         */
        public final void setPingIntervalMillis$okhttp(int n2) {
            void var1_1;
            this.pingIntervalMillis = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @JvmOverloads
        @NotNull
        public final Builder socket(@NotNull Socket socket, @NotNull String peerName, @NotNull BufferedSource source2, @NotNull BufferedSink sink2) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter(socket, "");
            Intrinsics.checkNotNullParameter(peerName, "");
            Intrinsics.checkNotNullParameter(source2, "");
            Intrinsics.checkNotNullParameter(sink2, "");
            Builder $this$socket_u24lambda_u240 = builder = this;
            builder.setSocket$okhttp((Socket)var1_1);
            Builder builder2 = $this$socket_u24lambda_u240;
            builder2.setConnectionName$okhttp(builder2.client ? Util.okHttpName + ' ' + peerName : "MockWebServer " + (String)var2_2);
            $this$socket_u24lambda_u240.setSource$okhttp((BufferedSource)var3_3);
            $this$socket_u24lambda_u240.setSink$okhttp(sink2);
            return builder;
        }

        public static /* synthetic */ Builder socket$default(Builder builder, Socket socket, String string, BufferedSource bufferedSource, BufferedSink bufferedSink, int n2, Object object) throws IOException {
            if ((n2 & 2) != 0) {
                string = Util.peerName(socket);
            }
            if ((n2 & 4) != 0) {
                bufferedSource = Okio.buffer(Okio.source(socket));
            }
            if ((n2 & 8) != 0) {
                bufferedSink = Okio.buffer(Okio.sink(socket));
            }
            return builder.socket(socket, string, bufferedSource, bufferedSink);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Builder listener(@NotNull Listener listener) {
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter(listener, "");
            Builder builder2 = builder = this;
            builder.listener = var1_1;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Builder pushObserver(@NotNull PushObserver pushObserver) {
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter(pushObserver, "");
            Builder builder2 = builder = this;
            builder.pushObserver = var1_1;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Builder pingIntervalMillis(int pingIntervalMillis) {
            void var1_1;
            Builder builder;
            Builder builder2 = builder = this;
            builder.pingIntervalMillis = var1_1;
            return builder;
        }

        @NotNull
        public final Http2Connection build() {
            return new Http2Connection(this);
        }

        /*
         * WARNING - void declaration
         */
        @JvmOverloads
        @NotNull
        public final Builder socket(@NotNull Socket socket, @NotNull String peerName, @NotNull BufferedSource source2) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter(socket, "");
            Intrinsics.checkNotNullParameter(peerName, "");
            Intrinsics.checkNotNullParameter(source2, "");
            return Builder.socket$default(this, (Socket)var1_1, (String)var2_2, (BufferedSource)var3_3, null, 8, null);
        }

        /*
         * WARNING - void declaration
         */
        @JvmOverloads
        @NotNull
        public final Builder socket(@NotNull Socket socket, @NotNull String peerName) throws IOException {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter(socket, "");
            Intrinsics.checkNotNullParameter(peerName, "");
            return Builder.socket$default(this, (Socket)var1_1, (String)var2_2, null, null, 12, null);
        }

        /*
         * WARNING - void declaration
         */
        @JvmOverloads
        @NotNull
        public final Builder socket(@NotNull Socket socket) throws IOException {
            void var1_1;
            Intrinsics.checkNotNullParameter(socket, "");
            return Builder.socket$default(this, (Socket)var1_1, null, null, null, 14, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lokhttp3/internal/http2/Http2Connection$Companion;", "", "()V", "AWAIT_PING", "", "DEFAULT_SETTINGS", "Lokhttp3/internal/http2/Settings;", "getDEFAULT_SETTINGS", "()Lokhttp3/internal/http2/Settings;", "DEGRADED_PING", "DEGRADED_PONG_TIMEOUT_NS", "INTERVAL_PING", "OKHTTP_CLIENT_WINDOW_SIZE", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Settings getDEFAULT_SETTINGS() {
            return DEFAULT_SETTINGS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH&\u00a8\u0006\r"}, d2={"Lokhttp3/internal/http2/Http2Connection$Listener;", "", "()V", "onSettings", "", "connection", "Lokhttp3/internal/http2/Http2Connection;", "settings", "Lokhttp3/internal/http2/Settings;", "onStream", "stream", "Lokhttp3/internal/http2/Http2Stream;", "Companion", "okhttp"})
    public static abstract class Listener {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @JvmField
        @NotNull
        public static final Listener REFUSE_INCOMING_STREAMS = new Listener(){

            /*
             * WARNING - void declaration
             */
            public final void onStream(@NotNull Http2Stream stream) throws IOException {
                void var1_1;
                Intrinsics.checkNotNullParameter(stream, "");
                var1_1.close(ErrorCode.REFUSED_STREAM, null);
            }
        };

        public abstract void onStream(@NotNull Http2Stream var1) throws IOException;

        /*
         * WARNING - void declaration
         */
        public void onSettings(@NotNull Http2Connection connection, @NotNull Settings settings) {
            void var2_2;
            Intrinsics.checkNotNullParameter(connection, "");
            Intrinsics.checkNotNullParameter(var2_2, "");
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lokhttp3/internal/http2/Http2Connection$Listener$Companion;", "", "()V", "REFUSE_INCOMING_STREAMS", "Lokhttp3/internal/http2/Http2Connection$Listener;", "okhttp"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0086\u0004\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u000f\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\u0003H\u0016J8\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J(\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\fH\u0016J \u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0010H\u0016J.\u0010$\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010%\u001a\u00020\f2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0016J\t\u0010)\u001a\u00020\u0003H\u0096\u0002J \u0010*\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\u00172\u0006\u0010,\u001a\u00020\f2\u0006\u0010-\u001a\u00020\fH\u0016J(\u0010.\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010/\u001a\u00020\f2\u0006\u00100\u001a\u00020\f2\u0006\u00101\u001a\u00020\u0017H\u0016J&\u00102\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00103\u001a\u00020\f2\f\u00104\u001a\b\u0012\u0004\u0012\u00020(0'H\u0016J\u0018\u00105\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u00106\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00107\u001a\u00020\u0014H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u00068"}, d2={"Lokhttp3/internal/http2/Http2Connection$ReaderRunnable;", "Lokhttp3/internal/http2/Http2Reader$Handler;", "Lkotlin/Function0;", "", "reader", "Lokhttp3/internal/http2/Http2Reader;", "(Lokhttp3/internal/http2/Http2Connection;Lokhttp3/internal/http2/Http2Reader;)V", "getReader$okhttp", "()Lokhttp3/internal/http2/Http2Reader;", "ackSettings", "alternateService", "streamId", "", "origin", "", "protocol", "Lokio/ByteString;", "host", "port", "maxAge", "", "applyAndAckSettings", "clearPrevious", "", "settings", "Lokhttp3/internal/http2/Settings;", "data", "inFinished", "source", "Lokio/BufferedSource;", "length", "goAway", "lastGoodStreamId", "errorCode", "Lokhttp3/internal/http2/ErrorCode;", "debugData", "headers", "associatedStreamId", "headerBlock", "", "Lokhttp3/internal/http2/Header;", "invoke", "ping", "ack", "payload1", "payload2", "priority", "streamDependency", "weight", "exclusive", "pushPromise", "promisedStreamId", "requestHeaders", "rstStream", "windowUpdate", "windowSizeIncrement", "okhttp"})
    @SourceDebugExtension(value={"SMAP\nHttp2Connection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http2Connection.kt\nokhttp3/internal/http2/Http2Connection$ReaderRunnable\n+ 2 TaskQueue.kt\nokhttp3/internal/concurrent/TaskQueue\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 Util.kt\nokhttp3/internal/Util\n*L\n1#1,1006:1\n90#2,13:1007\n90#2,13:1020\n90#2,13:1035\n90#2,13:1049\n37#3,2:1033\n37#3,2:1062\n563#4:1048\n563#4:1064\n*S KotlinDebug\n*F\n+ 1 Http2Connection.kt\nokhttp3/internal/http2/Http2Connection$ReaderRunnable\n*L\n687#1:1007,13\n715#1:1020,13\n758#1:1035,13\n806#1:1049,13\n753#1:1033,2\n824#1:1062,2\n797#1:1048\n841#1:1064\n*E\n"})
    public final class ReaderRunnable
    implements Function0<Unit>,
    Http2Reader.Handler {
        @NotNull
        private final Http2Reader reader;
        final /* synthetic */ Http2Connection this$0;

        /*
         * WARNING - void declaration
         */
        public ReaderRunnable(@NotNull Http2Connection this$0, Http2Reader reader) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter(reader, "");
            this.this$0 = var1_1;
            this.reader = var2_2;
        }

        @NotNull
        public final Http2Reader getReader$okhttp() {
            return this.reader;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void invoke() {
            ErrorCode connectionErrorCode = ErrorCode.INTERNAL_ERROR;
            ErrorCode streamErrorCode = ErrorCode.INTERNAL_ERROR;
            IOException errorException = null;
            try {
                this.reader.readConnectionPreface(this);
                while (this.reader.nextFrame(false, this)) {
                }
                connectionErrorCode = ErrorCode.NO_ERROR;
                streamErrorCode = ErrorCode.CANCEL;
                this.this$0.close$okhttp(connectionErrorCode, streamErrorCode, null);
            }
            catch (IOException iOException) {
                try {
                    IOException iOException2 = iOException;
                    errorException = iOException;
                    connectionErrorCode = ErrorCode.PROTOCOL_ERROR;
                    streamErrorCode = ErrorCode.PROTOCOL_ERROR;
                    this.this$0.close$okhttp(connectionErrorCode, streamErrorCode, errorException);
                }
                catch (Throwable throwable) {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.this$0.close$okhttp((ErrorCode)var1_1, (ErrorCode)var2_2, (IOException)var3_3);
                    Util.closeQuietly(this.reader);
                    throw throwable;
                }
                Util.closeQuietly(this.reader);
                return;
            }
            Util.closeQuietly(this.reader);
            return;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void data(boolean inFinished, int streamId, @NotNull BufferedSource source2, int length) throws IOException {
            void var1_1;
            void var3_3;
            Intrinsics.checkNotNullParameter(source2, "");
            if (this.this$0.pushedStream$okhttp(streamId)) {
                this.this$0.pushDataLater$okhttp(streamId, source2, length, inFinished);
                return;
            }
            Http2Stream dataStream = this.this$0.getStream(streamId);
            if (dataStream == null) {
                void var2_2;
                this.this$0.writeSynResetLater$okhttp((int)var2_2, ErrorCode.PROTOCOL_ERROR);
                this.this$0.updateConnectionFlowControl$okhttp(length);
                source2.skip(length);
                return;
            }
            dataStream.receiveData((BufferedSource)var3_3, length);
            if (var1_1 != false) {
                dataStream.receiveHeaders(Util.EMPTY_HEADERS, true);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void headers(boolean inFinished, int streamId, int associatedStreamId2, @NotNull List<Header> headerBlock) {
            void var1_1;
            void var4_7;
            void var3_6;
            Intrinsics.checkNotNullParameter(headerBlock, "");
            if (this.this$0.pushedStream$okhttp(streamId)) {
                this.this$0.pushHeadersLater$okhttp(streamId, (List<Header>)headerBlock, inFinished);
                return;
            }
            Http2Connection associatedStreamId2 = this.this$0;
            Http2Connection http2Connection = this.this$0;
            Http2Connection http2Connection2 = associatedStreamId2;
            synchronized (http2Connection2) {
                Http2Stream stream = http2Connection.getStream(streamId);
                if (stream == null) {
                    void var1_2;
                    void $this$iv;
                    void var2_4;
                    if (http2Connection.isShutdown) {
                        return;
                    }
                    if (streamId <= http2Connection.getLastGoodStreamId$okhttp()) {
                        return;
                    }
                    if (streamId % 2 == http2Connection.getNextStreamId$okhttp() % 2) {
                        return;
                    }
                    Object headers = Util.toHeaders(headerBlock);
                    Http2Stream newStream = new Http2Stream(streamId, http2Connection, false, inFinished, (Headers)headers);
                    http2Connection.setLastGoodStreamId$okhttp(streamId);
                    headers = streamId;
                    http2Connection.getStreams$okhttp().put((Integer)headers, newStream);
                    headerBlock = http2Connection.taskRunner.newQueue();
                    String name$iv = http2Connection.getConnectionName$okhttp() + '[' + (int)var2_4 + "] onStream";
                    $this$iv.schedule(new Task((String)var3_6, true, http2Connection, (Http2Stream)var1_2){
                        final /* synthetic */ Http2Connection this$0;
                        final /* synthetic */ Http2Stream $newStream$inlined;
                        {
                            void var2_2;
                            void var1_1;
                            this.this$0 = http2Connection;
                            this.$newStream$inlined = http2Stream;
                            super((String)var1_1, (boolean)var2_2);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final long runOnce() {
                            try {
                                this.this$0.getListener$okhttp().onStream(this.$newStream$inlined);
                            }
                            catch (IOException e2) {
                                Platform.Companion.get().log("Http2Connection.Listener failure for " + this.this$0.getConnectionName$okhttp(), 4, e2);
                                try {
                                    void var1_1;
                                    this.$newStream$inlined.close(ErrorCode.PROTOCOL_ERROR, (IOException)var1_1);
                                }
                                catch (IOException iOException) {}
                            }
                            return -1L;
                        }
                    }, 0L);
                    return;
                }
            }
            var3_6.receiveHeaders(Util.toHeaders((List<Header>)var4_7), (boolean)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void rstStream(int streamId, @NotNull ErrorCode errorCode) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)errorCode, "");
            if (this.this$0.pushedStream$okhttp(streamId)) {
                this.this$0.pushResetLater$okhttp(streamId, errorCode);
                return;
            }
            Http2Stream http2Stream = this.this$0.removeStream$okhttp((int)var1_1);
            if (http2Stream != null) {
                void var2_3;
                http2Stream.receiveRstStream((ErrorCode)var2_3);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void settings(boolean clearPrevious, @NotNull Settings settings) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter(settings, "");
            TaskQueue taskQueue = this.this$0.writerQueue;
            String name$iv = this.this$0.getConnectionName$okhttp() + " applyAndAckSettings";
            taskQueue.schedule(new Task(name$iv, true, this, (boolean)var1_1, (Settings)var2_2){
                final /* synthetic */ ReaderRunnable this$0;
                final /* synthetic */ boolean $clearPrevious$inlined;
                final /* synthetic */ Settings $settings$inlined;
                {
                    void var2_2;
                    void var1_1;
                    this.this$0 = readerRunnable;
                    this.$clearPrevious$inlined = bl;
                    this.$settings$inlined = settings;
                    super((String)var1_1, (boolean)var2_2);
                }

                public final long runOnce() {
                    this.this$0.applyAndAckSettings(this.$clearPrevious$inlined, this.$settings$inlined);
                    return -1L;
                }
            }, 0L);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public final void applyAndAckSettings(boolean clearPrevious2, @NotNull Settings settings) {
            void var2_4;
            Http2Stream[] http2StreamArray;
            Settings settings2;
            Intrinsics.checkNotNullParameter(settings, "");
            Ref.ObjectRef newPeerSettings = new Ref.ObjectRef();
            Http2Stream[] http2StreamArray2 = this.this$0.getWriter();
            Http2Connection http2Connection = this.this$0;
            Http2Stream[] http2StreamArray3 = http2StreamArray2;
            // MONITORENTER : http2StreamArray2
            Object object = http2Connection;
            // MONITORENTER : object
            Settings previousPeerSettings = http2Connection.getPeerSettings();
            Ref.ObjectRef objectRef = newPeerSettings;
            if (clearPrevious2) {
                settings2 = settings;
            } else {
                void $this$applyAndAckSettings_u24lambda_u247_u24lambda_u246_u24lambda_u244;
                Settings settings3 = clearPrevious2 = new Settings();
                Ref.ObjectRef objectRef2 = objectRef;
                $this$applyAndAckSettings_u24lambda_u247_u24lambda_u246_u24lambda_u244.merge(previousPeerSettings);
                $this$applyAndAckSettings_u24lambda_u247_u24lambda_u246_u24lambda_u244.merge((Settings)settings);
                objectRef = objectRef2;
                settings2 = clearPrevious2;
            }
            objectRef.element = settings2;
            long l2 = ((Settings)newPeerSettings.element).getInitialWindowSize();
            long delta = l2 - (long)previousPeerSettings.getInitialWindowSize();
            if (delta == 0L || http2Connection.getStreams$okhttp().isEmpty()) {
                http2StreamArray = null;
            } else {
                settings = http2Connection.getStreams$okhttp().values();
                Collection<Http2Stream> clearPrevious2 = settings;
                http2StreamArray = settings.toArray(new Http2Stream[0]);
            }
            Http2Stream[] streamsToNotify = http2StreamArray;
            http2Connection.setPeerSettings((Settings)newPeerSettings.element);
            settings = http2Connection.settingsListenerQueue;
            String name$iv = http2Connection.getConnectionName$okhttp() + " onSettings";
            var2_4.schedule(new Task(name$iv, true, http2Connection, newPeerSettings){
                final /* synthetic */ Http2Connection this$0;
                final /* synthetic */ Ref.ObjectRef $newPeerSettings$inlined;
                {
                    void var2_2;
                    void var1_1;
                    this.this$0 = http2Connection;
                    this.$newPeerSettings$inlined = objectRef;
                    super((String)var1_1, (boolean)var2_2);
                }

                public final long runOnce() {
                    this.this$0.getListener$okhttp().onSettings(this.this$0, (Settings)this.$newPeerSettings$inlined.element);
                    return -1L;
                }
            }, 0L);
            // MONITOREXIT : object
            try {
                void var3_5;
                http2Connection.getWriter().applyAndAckSettings((Settings)var3_5.element);
            }
            catch (IOException e2) {
                Http2Connection.access$failConnection(http2Connection, e2);
            }
            // MONITOREXIT : http2StreamArray3
            if (streamsToNotify == null) return;
            http2StreamArray2 = streamsToNotify;
            int n2 = 0;
            int n3 = http2StreamArray2.length;
            while (n2 < n3) {
                void var1_3;
                Http2Stream stream = http2StreamArray2[n2];
                object = stream;
                // MONITORENTER : stream
                var1_3.addBytesToWriteWindow(delta);
                // MONITOREXIT : object
                ++n2;
            }
        }

        @Override
        public final void ackSettings() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void ping(boolean ack2, int payload1, int payload2) {
            void var3_7;
            void var2_4;
            void name$iv;
            void var1_3;
            if (ack2) {
                Http2Connection ack2 = this.this$0;
                Http2Connection http2Connection = this.this$0;
                synchronized (ack2) {
                    switch (payload1) {
                        case 1: {
                            long l2 = http2Connection.intervalPongsReceived;
                            Http2Connection.access$setIntervalPongsReceived$p(http2Connection, l2 + 1L);
                            Long.valueOf(l2);
                            break;
                        }
                        case 2: {
                            long l3 = http2Connection.degradedPongsReceived;
                            Http2Connection.access$setDegradedPongsReceived$p(http2Connection, l3 + 1L);
                            Long.valueOf(l3);
                            break;
                        }
                        case 3: {
                            void var2_5;
                            long l4 = http2Connection.awaitPongsReceived;
                            Http2Connection.access$setAwaitPongsReceived$p(http2Connection, l4 + 1L);
                            Http2Connection $this$notifyAll$iv = http2Connection;
                            Intrinsics.checkNotNull($this$notifyAll$iv);
                            ((Object)var2_5).notifyAll();
                            break;
                        }
                    }
                    return;
                }
            }
            TaskQueue ack2 = this.this$0.writerQueue;
            String string = this.this$0.getConnectionName$okhttp() + " ping";
            Http2Connection http2Connection = this.this$0;
            var1_3.schedule(new Task((String)name$iv, true, http2Connection, (int)var2_4, (int)var3_7){
                final /* synthetic */ Http2Connection this$0;
                final /* synthetic */ int $payload1$inlined;
                final /* synthetic */ int $payload2$inlined;
                {
                    void var2_2;
                    void var1_1;
                    this.this$0 = http2Connection;
                    this.$payload1$inlined = n2;
                    this.$payload2$inlined = n3;
                    super((String)var1_1, (boolean)var2_2);
                }

                public final long runOnce() {
                    this.this$0.writePing(true, this.$payload1$inlined, this.$payload2$inlined);
                    return -1L;
                }
            }, 0L);
        }

        @Override
        public final void goAway(int lastGoodStreamId, @NotNull ErrorCode errorCode, @NotNull ByteString debugData) {
            Http2Stream[] http2StreamArray;
            Http2Connection http2Connection;
            Intrinsics.checkNotNullParameter(errorCode, "");
            Intrinsics.checkNotNullParameter(debugData, "");
            ((ByteString)((Object)http2Connection)).size();
            errorCode = this.this$0;
            http2Connection = this.this$0;
            Object object = errorCode;
            synchronized (object) {
                Collection<Http2Stream> collection = http2Connection.getStreams$okhttp().values();
                errorCode = collection;
                errorCode = collection;
                Http2Stream[] streamsCopy = collection.toArray(new Http2Stream[0]);
                Http2Connection.access$setShutdown$p(http2Connection, true);
            }
            for (Http2Stream http2Stream : (Http2Stream[])http2StreamArray) {
                if (http2Stream.getId() <= lastGoodStreamId || !http2Stream.isLocallyInitiated()) continue;
                http2Stream.receiveRstStream(ErrorCode.REFUSED_STREAM);
                this.this$0.removeStream$okhttp(http2Stream.getId());
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void windowUpdate(int streamId22, long windowSizeIncrement) {
            int streamId22;
            if (streamId22 == 0) {
                Http2Connection streamId22 = this.this$0;
                Http2Connection http2Connection = this.this$0;
                synchronized (streamId22) {
                    void var2_6;
                    Http2Connection http2Connection2 = http2Connection;
                    Http2Connection.access$setWriteBytesMaximum$p(http2Connection2, http2Connection2.getWriteBytesMaximum() + windowSizeIncrement);
                    Http2Connection $this$notifyAll$iv = http2Connection;
                    Intrinsics.checkNotNull($this$notifyAll$iv);
                    ((Object)var2_6).notifyAll();
                    return;
                }
            }
            Http2Stream stream = this.this$0.getStream(streamId22);
            if (stream != null) {
                Http2Stream http2Stream = stream;
                synchronized (http2Stream) {
                    void var2_5;
                    void var1_3;
                    var1_3.addBytesToWriteWindow((long)var2_5);
                    return;
                }
            }
        }

        @Override
        public final void priority(int streamId, int streamDependency, int weight, boolean exclusive) {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void pushPromise(int streamId, int promisedStreamId, @NotNull List<Header> requestHeaders) {
            void var3_3;
            void var2_2;
            Intrinsics.checkNotNullParameter(requestHeaders, "");
            this.this$0.pushRequestLater$okhttp((int)var2_2, (List<Header>)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void alternateService(int streamId, @NotNull String origin, @NotNull ByteString protocol, @NotNull String host, int port, long maxAge) {
            void var3_3;
            Intrinsics.checkNotNullParameter(origin, "");
            Intrinsics.checkNotNullParameter(var3_3, "");
            Intrinsics.checkNotNullParameter(host, "");
        }
    }
}

