/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.Route;
import okhttp3.internal.Util;
import okhttp3.internal.connection.Exchange;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.http.HttpMethod;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J(\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J\u0018\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0006H\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lokhttp3/internal/http/RetryAndFollowUpInterceptor;", "Lokhttp3/Interceptor;", "client", "Lokhttp3/OkHttpClient;", "(Lokhttp3/OkHttpClient;)V", "buildRedirectRequest", "Lokhttp3/Request;", "userResponse", "Lokhttp3/Response;", "method", "", "followUpRequest", "exchange", "Lokhttp3/internal/connection/Exchange;", "intercept", "chain", "Lokhttp3/Interceptor$Chain;", "isRecoverable", "", "e", "Ljava/io/IOException;", "requestSendStarted", "recover", "call", "Lokhttp3/internal/connection/RealCall;", "userRequest", "requestIsOneShot", "retryAfter", "", "defaultDelay", "Companion", "okhttp"})
public final class RetryAndFollowUpInterceptor
implements Interceptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OkHttpClient client;
    private static final int MAX_FOLLOW_UPS = 20;

    /*
     * WARNING - void declaration
     */
    public RetryAndFollowUpInterceptor(@NotNull OkHttpClient client) {
        void var1_1;
        Intrinsics.checkNotNullParameter(client, "");
        this.client = var1_1;
    }

    /*
     * Exception decompiling
     */
    @Override
    @NotNull
    public final Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - void declaration
     */
    private final boolean recover(IOException e2, RealCall call, Request userRequest, boolean requestSendStarted) {
        void var2_2;
        void var1_1;
        void var3_3;
        if (!this.client.retryOnConnectionFailure()) {
            return false;
        }
        if (requestSendStarted && this.requestIsOneShot(e2, (Request)var3_3)) {
            return false;
        }
        if (!this.isRecoverable((IOException)var1_1, requestSendStarted)) {
            return false;
        }
        return var2_2.retryAfterFailure();
    }

    /*
     * WARNING - void declaration
     */
    private final boolean requestIsOneShot(IOException e2, Request userRequest) {
        void var1_1;
        void var2_2;
        RequestBody requestBody = userRequest.body();
        return requestBody != null && var2_2.isOneShot() || var1_1 instanceof FileNotFoundException;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isRecoverable(IOException e2, boolean requestSendStarted) {
        void var1_1;
        if (e2 instanceof ProtocolException) {
            return false;
        }
        if (e2 instanceof InterruptedIOException) {
            void var2_2;
            return e2 instanceof SocketTimeoutException && var2_2 == false;
        }
        if (e2 instanceof SSLHandshakeException && e2.getCause() instanceof CertificateException) {
            return false;
        }
        return !(var1_1 instanceof SSLPeerUnverifiedException);
    }

    /*
     * WARNING - void declaration
     */
    private final Request followUpRequest(Response userResponse, Exchange exchange) throws IOException {
        Object object = exchange;
        Route route = object != null && (object = ((Exchange)object).getConnection$okhttp()) != null ? ((RealConnection)object).route() : null;
        int responseCode2 = userResponse.code();
        String method = userResponse.request().method();
        switch (responseCode2) {
            case 407: {
                Route route2 = route;
                Intrinsics.checkNotNull(route2);
                Proxy responseCode2 = route2.proxy();
                if (responseCode2.type() != Proxy.Type.HTTP) {
                    throw new ProtocolException("Received HTTP_PROXY_AUTH (407) code while not using proxy");
                }
                return this.client.proxyAuthenticator().authenticate(route, userResponse);
            }
            case 401: {
                void var3_3;
                return this.client.authenticator().authenticate((Route)var3_3, userResponse);
            }
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 308: {
                return this.buildRedirectRequest(userResponse, method);
            }
            case 408: {
                void var2_2;
                if (!this.client.retryOnConnectionFailure()) {
                    return null;
                }
                RequestBody requestBody = userResponse.request().body();
                if (requestBody != null && requestBody.isOneShot()) {
                    return null;
                }
                Response priorResponse = userResponse.priorResponse();
                if (priorResponse != null && var2_2.code() == 408) {
                    return null;
                }
                if (this.retryAfter(userResponse, 0) > 0) {
                    return null;
                }
                return userResponse.request();
            }
            case 503: {
                Response priorResponse = userResponse.priorResponse();
                if (priorResponse != null && priorResponse.code() == 503) {
                    return null;
                }
                if (this.retryAfter(userResponse, Integer.MAX_VALUE) == 0) {
                    return userResponse.request();
                }
                return null;
            }
            case 421: {
                void var1_1;
                void var2_2;
                RequestBody requestBody = userResponse.request().body();
                if (requestBody != null && requestBody.isOneShot()) {
                    return null;
                }
                if (var2_2 == null || !var2_2.isCoalescedConnection$okhttp()) {
                    return null;
                }
                var2_2.getConnection$okhttp().noCoalescedConnections$okhttp();
                return var1_1.request();
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final Request buildRedirectRequest(Response userResponse, String method) {
        void var3_3;
        void var1_1;
        if (!this.client.followRedirects()) {
            return null;
        }
        String string = Response.header$default(userResponse, "Location", null, 2, null);
        if (string == null) {
            return null;
        }
        String location = string;
        HttpUrl httpUrl = userResponse.request().url().resolve(location);
        if (httpUrl == null) {
            return null;
        }
        HttpUrl url = httpUrl;
        boolean bl = Intrinsics.areEqual(httpUrl.scheme(), userResponse.request().url().scheme());
        if (!bl && !this.client.followSslRedirects()) {
            return null;
        }
        Request.Builder requestBuilder = userResponse.request().newBuilder();
        if (HttpMethod.permitsRequestBody(method)) {
            boolean maintainBody;
            int responseCode = userResponse.code();
            boolean bl2 = maintainBody = HttpMethod.INSTANCE.redirectsWithBody(method) || responseCode == 308 || responseCode == 307;
            if (HttpMethod.INSTANCE.redirectsToGet(method) && responseCode != 308 && responseCode != 307) {
                requestBuilder.method("GET", null);
            } else {
                void var2_2;
                RequestBody requestBody = maintainBody ? userResponse.request().body() : null;
                requestBuilder.method((String)var2_2, requestBody);
            }
            if (!maintainBody) {
                requestBuilder.removeHeader("Transfer-Encoding");
                requestBuilder.removeHeader("Content-Length");
                requestBuilder.removeHeader("Content-Type");
            }
        }
        if (!Util.canReuseConnectionFor(var1_1.request().url(), url)) {
            requestBuilder.removeHeader("Authorization");
        }
        return requestBuilder.url((HttpUrl)var3_3).build();
    }

    /*
     * WARNING - void declaration
     */
    private final int retryAfter(Response userResponse, int defaultDelay) {
        String string = Response.header$default(userResponse, "Retry-After", null, 2, null);
        if (string == null) {
            void var2_2;
            return (int)var2_2;
        }
        String header = string;
        CharSequence charSequence = string;
        if (new Regex("\\d+").matches(charSequence)) {
            void var1_1;
            Integer n2 = Integer.valueOf((String)var1_1);
            Intrinsics.checkNotNullExpressionValue(n2, "");
            return ((Number)n2).intValue();
        }
        return Integer.MAX_VALUE;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lokhttp3/internal/http/RetryAndFollowUpInterceptor$Companion;", "", "()V", "MAX_FOLLOW_UPS", "", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

