/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.concurrent;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.concurrent.Task;
import okhttp3.internal.concurrent.TaskQueue;
import okhttp3.internal.concurrent.TaskRunner;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001H\u0002\u001a5\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000eH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000f\u001a*\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u000eH\u0080\b\u00f8\u0001\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0012"}, d2={"formatDuration", "", "ns", "", "log", "", "task", "Lokhttp3/internal/concurrent/Task;", "queue", "Lokhttp3/internal/concurrent/TaskQueue;", "message", "logElapsed", "T", "block", "Lkotlin/Function0;", "(Lokhttp3/internal/concurrent/Task;Lokhttp3/internal/concurrent/TaskQueue;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "taskLog", "messageBlock", "okhttp"})
public final class TaskLoggerKt {
    /*
     * WARNING - void declaration
     */
    public static final void taskLog(@NotNull Task task, @NotNull TaskQueue queue, @NotNull Function0<String> messageBlock) {
        Intrinsics.checkNotNullParameter(task, "");
        Intrinsics.checkNotNullParameter(queue, "");
        Intrinsics.checkNotNullParameter(messageBlock, "");
        if (TaskRunner.Companion.getLogger().isLoggable(Level.FINE)) {
            void var2_2;
            void var1_1;
            Task task2;
            TaskLoggerKt.access$log(task2, (TaskQueue)var1_1, (String)var2_2.invoke());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final <T> T logElapsed(@NotNull Task task, @NotNull TaskQueue queue, @NotNull Function0<? extends T> block) {
        void var8_7;
        Intrinsics.checkNotNullParameter(task, "");
        Intrinsics.checkNotNullParameter(queue, "");
        Intrinsics.checkNotNullParameter(block, "");
        long startNs = -1L;
        boolean loggingEnabled = TaskRunner.Companion.getLogger().isLoggable(Level.FINE);
        if (loggingEnabled) {
            startNs = queue.getTaskRunner$okhttp().getBackend().nanoTime();
            TaskLoggerKt.access$log(task, queue, "starting");
        }
        boolean completedNormally = false;
        try {
            void var2_2;
            T result = block.invoke();
            completedNormally = true;
            var8_7 = var2_2;
        }
        catch (Throwable throwable) {
            InlineMarker.finallyStart(1);
            if (loggingEnabled) {
                void var3_4;
                long elapsedNs = queue.getTaskRunner$okhttp().getBackend().nanoTime() - var3_4;
                if (completedNormally) {
                    TaskLoggerKt.access$log(task, queue, "finished run in " + TaskLoggerKt.formatDuration(elapsedNs));
                } else {
                    void var1_1;
                    Task task2;
                    TaskLoggerKt.access$log(task2, (TaskQueue)var1_1, "failed a run in " + TaskLoggerKt.formatDuration(elapsedNs));
                }
            }
            InlineMarker.finallyEnd(1);
            throw throwable;
        }
        InlineMarker.finallyStart(1);
        if (loggingEnabled) {
            long elapsedNs = queue.getTaskRunner$okhttp().getBackend().nanoTime() - startNs;
            TaskLoggerKt.access$log(task, queue, "finished run in " + TaskLoggerKt.formatDuration(elapsedNs));
        }
        InlineMarker.finallyEnd(1);
        return var8_7;
    }

    /*
     * WARNING - void declaration
     */
    private static final void log(Task task, TaskQueue queue, String message) {
        Task task2;
        void var2_2;
        String string;
        Logger logger = TaskRunner.Companion.getLogger();
        StringBuilder stringBuilder = new StringBuilder().append(((TaskQueue)((Object)string)).getName$okhttp()).append(' ');
        string = "%-22s";
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = var2_2;
        String string2 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue(string2, "");
        logger.fine(stringBuilder.append(string2).append(": ").append(task2.getName()).toString());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String formatDuration(long ns) {
        void var0_1;
        String s2 = ns <= -999500000L ? (ns - 500000000L) / 1000000000L + " s " : (ns <= -999500L ? (ns - 500000L) / 1000000L + " ms" : (ns <= 0L ? (ns - 500L) / 1000L + " \u00b5s" : (ns < 999500L ? (ns + 500L) / 1000L + " \u00b5s" : (ns < 999500000L ? (ns + 500000L) / 1000000L + " ms" : (ns + 500000000L) / 1000000000L + " s "))));
        String string = "%6s";
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = var0_1;
        String string2 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue(string2, "");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$log(Task task, TaskQueue queue, String message) {
        void var2_2;
        void var1_1;
        TaskLoggerKt.log(task, (TaskQueue)var1_1, (String)var2_2);
    }
}

