/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.cache2;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.internal.Util;
import okhttp3.internal.cache2.FileOperator;
import okio.Buffer;
import okio.ByteString;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u0000 :2\u00020\u0001:\u0002:;B3\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\u000e\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\tJ\b\u00105\u001a\u0004\u0018\u00010\u0005J \u00106\u001a\u0002032\u0006\u00107\u001a\u00020\t2\u0006\u00104\u001a\u00020\u00072\u0006\u00108\u001a\u00020\u0007H\u0002J\u0010\u00109\u001a\u0002032\u0006\u00104\u001a\u00020\u0007H\u0002R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0015R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u000fR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0011\"\u0004\b*\u0010+R\u001c\u0010,\u001a\u0004\u0018\u00010-X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101\u00a8\u0006<"}, d2={"Lokhttp3/internal/cache2/Relay;", "", "file", "Ljava/io/RandomAccessFile;", "upstream", "Lokio/Source;", "upstreamPos", "", "metadata", "Lokio/ByteString;", "bufferMaxSize", "(Ljava/io/RandomAccessFile;Lokio/Source;JLokio/ByteString;J)V", "buffer", "Lokio/Buffer;", "getBuffer", "()Lokio/Buffer;", "getBufferMaxSize", "()J", "complete", "", "getComplete", "()Z", "setComplete", "(Z)V", "getFile", "()Ljava/io/RandomAccessFile;", "setFile", "(Ljava/io/RandomAccessFile;)V", "isClosed", "sourceCount", "", "getSourceCount", "()I", "setSourceCount", "(I)V", "getUpstream", "()Lokio/Source;", "setUpstream", "(Lokio/Source;)V", "upstreamBuffer", "getUpstreamBuffer", "getUpstreamPos", "setUpstreamPos", "(J)V", "upstreamReader", "Ljava/lang/Thread;", "getUpstreamReader", "()Ljava/lang/Thread;", "setUpstreamReader", "(Ljava/lang/Thread;)V", "commit", "", "upstreamSize", "newSource", "writeHeader", "prefix", "metadataSize", "writeMetadata", "Companion", "RelaySource", "okhttp"})
public final class Relay {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private RandomAccessFile file;
    @Nullable
    private Source upstream;
    private long upstreamPos;
    @NotNull
    private final ByteString metadata;
    private final long bufferMaxSize;
    @Nullable
    private Thread upstreamReader;
    @NotNull
    private final Buffer upstreamBuffer;
    private boolean complete;
    @NotNull
    private final Buffer buffer;
    private int sourceCount;
    private static final int SOURCE_UPSTREAM = 1;
    private static final int SOURCE_FILE = 2;
    @JvmField
    @NotNull
    public static final ByteString PREFIX_CLEAN = ByteString.Companion.encodeUtf8("OkHttp cache v1\n");
    @JvmField
    @NotNull
    public static final ByteString PREFIX_DIRTY = ByteString.Companion.encodeUtf8("OkHttp DIRTY :(\n");
    private static final long FILE_HEADER_SIZE = 32L;

    /*
     * WARNING - void declaration
     */
    private Relay(RandomAccessFile file, Source upstream, long upstreamPos, ByteString metadata, long bufferMaxSize) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.file = var1_1;
        this.upstream = var2_2;
        this.upstreamPos = var3_3;
        this.metadata = metadata;
        this.bufferMaxSize = bufferMaxSize;
        this.upstreamBuffer = new Buffer();
        this.complete = this.upstream == null;
        this.buffer = new Buffer();
    }

    @Nullable
    public final RandomAccessFile getFile() {
        return this.file;
    }

    /*
     * WARNING - void declaration
     */
    public final void setFile(@Nullable RandomAccessFile randomAccessFile) {
        void var1_1;
        this.file = var1_1;
    }

    @Nullable
    public final Source getUpstream() {
        return this.upstream;
    }

    /*
     * WARNING - void declaration
     */
    public final void setUpstream(@Nullable Source source2) {
        void var1_1;
        this.upstream = var1_1;
    }

    public final long getUpstreamPos() {
        return this.upstreamPos;
    }

    /*
     * WARNING - void declaration
     */
    public final void setUpstreamPos(long l2) {
        void var1_1;
        this.upstreamPos = var1_1;
    }

    public final long getBufferMaxSize() {
        return this.bufferMaxSize;
    }

    @Nullable
    public final Thread getUpstreamReader() {
        return this.upstreamReader;
    }

    /*
     * WARNING - void declaration
     */
    public final void setUpstreamReader(@Nullable Thread thread2) {
        void var1_1;
        this.upstreamReader = var1_1;
    }

    @NotNull
    public final Buffer getUpstreamBuffer() {
        return this.upstreamBuffer;
    }

    public final boolean getComplete() {
        return this.complete;
    }

    /*
     * WARNING - void declaration
     */
    public final void setComplete(boolean bl) {
        void var1_1;
        this.complete = var1_1;
    }

    @NotNull
    public final Buffer getBuffer() {
        return this.buffer;
    }

    public final int getSourceCount() {
        return this.sourceCount;
    }

    /*
     * WARNING - void declaration
     */
    public final void setSourceCount(int n2) {
        void var1_1;
        this.sourceCount = var1_1;
    }

    public final boolean isClosed() {
        return this.file == null;
    }

    /*
     * WARNING - void declaration
     */
    private final void writeHeader(ByteString prefix, long upstreamSize, long metadataSize) throws IOException {
        void var1_1;
        void var2_2;
        Object object = new Buffer();
        Buffer $this$writeHeader_u24lambda_u240 = object;
        ((Buffer)object).write((ByteString)prefix);
        $this$writeHeader_u24lambda_u240.writeLong((long)var2_2);
        $this$writeHeader_u24lambda_u240.writeLong(metadataSize);
        if (!($this$writeHeader_u24lambda_u240.size() == 32L)) {
            prefix = "Failed requirement.";
            throw new IllegalArgumentException(prefix.toString());
        }
        Buffer header = object;
        RandomAccessFile randomAccessFile = this.file;
        Intrinsics.checkNotNull(randomAccessFile);
        FileChannel fileChannel = randomAccessFile.getChannel();
        Intrinsics.checkNotNullExpressionValue(fileChannel, "");
        object = new FileOperator(fileChannel);
        ((FileOperator)object).write(0L, (Buffer)var1_1, 32L);
    }

    /*
     * WARNING - void declaration
     */
    private final void writeMetadata(long upstreamSize) throws IOException {
        void var3_2;
        void var1_1;
        Buffer metadataBuffer = new Buffer();
        metadataBuffer.write(this.metadata);
        RandomAccessFile randomAccessFile = this.file;
        Intrinsics.checkNotNull(randomAccessFile);
        FileChannel fileChannel = randomAccessFile.getChannel();
        Intrinsics.checkNotNullExpressionValue(fileChannel, "");
        FileOperator fileOperator = new FileOperator(fileChannel);
        fileOperator.write((long)(var1_1 + 32L), (Buffer)var3_2, this.metadata.size());
    }

    /*
     * WARNING - void declaration
     */
    public final void commit(long upstreamSize) throws IOException {
        void var1_1;
        this.writeMetadata(upstreamSize);
        RandomAccessFile randomAccessFile = this.file;
        Intrinsics.checkNotNull(randomAccessFile);
        randomAccessFile.getChannel().force(false);
        this.writeHeader(PREFIX_CLEAN, (long)var1_1, this.metadata.size());
        RandomAccessFile randomAccessFile2 = this.file;
        Intrinsics.checkNotNull(randomAccessFile2);
        randomAccessFile2.getChannel().force(false);
        Relay relay = this;
        synchronized (relay) {
            this.complete = true;
        }
        Source source2 = this.upstream;
        if (source2 != null) {
            Util.closeQuietly(source2);
        }
        this.upstream = null;
    }

    @NotNull
    public final ByteString metadata() {
        return this.metadata;
    }

    @Nullable
    public final Source newSource() {
        Relay relay = this;
        synchronized (relay) {
            block4: {
                if (this.file != null) break block4;
                return null;
            }
            int n2 = this.sourceCount;
            this.sourceCount = n2 + 1;
        }
        return new RelaySource(this);
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ Relay(RandomAccessFile file, Source upstream, long upstreamPos, ByteString metadata, long bufferMaxSize, DefaultConstructorMarker $constructor_marker) {
        this((RandomAccessFile)var1_1, (Source)var2_2, (long)var3_3, metadata, bufferMaxSize);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$writeHeader(Relay $this, ByteString prefix, long upstreamSize, long metadataSize) {
        void var2_2;
        void var1_1;
        $this.writeHeader((ByteString)var1_1, (long)var2_2, metadataSize);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0004J\u000e\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lokhttp3/internal/cache2/Relay$Companion;", "", "()V", "FILE_HEADER_SIZE", "", "PREFIX_CLEAN", "Lokio/ByteString;", "PREFIX_DIRTY", "SOURCE_FILE", "", "SOURCE_UPSTREAM", "edit", "Lokhttp3/internal/cache2/Relay;", "file", "Ljava/io/File;", "upstream", "Lokio/Source;", "metadata", "bufferMaxSize", "read", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Relay edit(@NotNull File file, @NotNull Source upstream, @NotNull ByteString metadata, long bufferMaxSize) throws IOException {
            void var2_2;
            void var1_1;
            void var3_3;
            Intrinsics.checkNotNullParameter(file, "");
            Intrinsics.checkNotNullParameter(upstream, "");
            Intrinsics.checkNotNullParameter(metadata, "");
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            Relay result = new Relay(randomAccessFile, upstream, 0L, (ByteString)var3_3, bufferMaxSize, null);
            var1_1.setLength(0L);
            Relay.access$writeHeader(result, PREFIX_DIRTY, -1L, -1L);
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Relay read(@NotNull File file) throws IOException {
            void var2_2;
            void var1_1;
            void var3_3;
            Intrinsics.checkNotNullParameter(file, "");
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            FileChannel fileChannel = randomAccessFile.getChannel();
            Intrinsics.checkNotNullExpressionValue(fileChannel, "");
            FileOperator fileOperator = new FileOperator(fileChannel);
            Buffer header = new Buffer();
            fileOperator.read(0L, header, 32L);
            ByteString byteString = header.readByteString(PREFIX_CLEAN.size());
            if (!Intrinsics.areEqual(byteString, PREFIX_CLEAN)) {
                throw new IOException("unreadable cache file");
            }
            long upstreamSize = header.readLong();
            long metadataSize = header.readLong();
            Buffer metadataBuffer = new Buffer();
            fileOperator.read(upstreamSize + 32L, metadataBuffer, metadataSize);
            ByteString metadata = var3_3.readByteString();
            return new Relay((RandomAccessFile)var1_1, null, upstreamSize, (ByteString)var2_2, 0L, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lokhttp3/internal/cache2/Relay$RelaySource;", "Lokio/Source;", "(Lokhttp3/internal/cache2/Relay;)V", "fileOperator", "Lokhttp3/internal/cache2/FileOperator;", "sourcePos", "", "timeout", "Lokio/Timeout;", "close", "", "read", "sink", "Lokio/Buffer;", "byteCount", "okhttp"})
    @SourceDebugExtension(value={"SMAP\nRelay.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Relay.kt\nokhttp3/internal/cache2/Relay$RelaySource\n+ 2 Util.kt\nokhttp3/internal/Util\n*L\n1#1,356:1\n563#2:357\n*S KotlinDebug\n*F\n+ 1 Relay.kt\nokhttp3/internal/cache2/Relay$RelaySource\n*L\n267#1:357\n*E\n"})
    public final class RelaySource
    implements Source {
        @NotNull
        private final Timeout timeout = new Timeout();
        @Nullable
        private FileOperator fileOperator;
        private long sourcePos;
        final /* synthetic */ Relay this$0;

        /*
         * WARNING - void declaration
         */
        public RelaySource(Relay this$0) {
            void var1_1;
            this.this$0 = var1_1;
            RandomAccessFile randomAccessFile = this.this$0.getFile();
            Intrinsics.checkNotNull(randomAccessFile);
            FileChannel fileChannel = randomAccessFile.getChannel();
            Intrinsics.checkNotNullExpressionValue(fileChannel, "");
            this.fileOperator = new FileOperator(fileChannel);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public final long read(@NotNull Buffer sink2, long byteCount) throws IOException {
            void var2_2;
            long upstreamBytesRead;
            block21: {
                Relay relay;
                Relay relay2;
                int n2;
                Intrinsics.checkNotNullParameter(sink2, "");
                if (!(this.fileOperator != null)) {
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
                Relay relay3 = this.this$0;
                Relay relay4 = this.this$0;
                Relay relay5 = relay3;
                synchronized (relay5) {
                    int n3;
                    block20: {
                        long upstreamPos;
                        while (this.sourcePos == (upstreamPos = relay4.getUpstreamPos())) {
                            if (relay4.getComplete()) {
                                return -1L;
                            }
                            if (relay4.getUpstreamReader() != null) {
                                this.timeout.waitUntilNotified(relay4);
                                continue;
                            }
                            relay4.setUpstreamReader(Thread.currentThread());
                            n3 = 1;
                            break block20;
                        }
                        long bufferPos = relay4.getUpstreamPos() - relay4.getBuffer().size();
                        if (this.sourcePos >= bufferPos) {
                            long bytesToRead = Math.min(byteCount, relay4.getUpstreamPos() - this.sourcePos);
                            relay4.getBuffer().copyTo(sink2, this.sourcePos - bufferPos, bytesToRead);
                            this.sourcePos += bytesToRead;
                            return bytesToRead;
                        }
                        n3 = 2;
                    }
                    n2 = n3;
                }
                int n4 = n2;
                if (n4 == 2) {
                    long bytesToRead = Math.min(byteCount, this.this$0.getUpstreamPos() - this.sourcePos);
                    FileOperator fileOperator = this.fileOperator;
                    Intrinsics.checkNotNull(fileOperator);
                    fileOperator.read(32L + this.sourcePos, sink2, bytesToRead);
                    this.sourcePos += bytesToRead;
                    return bytesToRead;
                }
                try {
                    Source source2 = this.this$0.getUpstream();
                    Intrinsics.checkNotNull(source2);
                    upstreamBytesRead = source2.read(this.this$0.getUpstreamBuffer(), this.this$0.getBufferMaxSize());
                    if (upstreamBytesRead != -1L) break block21;
                    this.this$0.commit(this.this$0.getUpstreamPos());
                    Relay relay6 = this.this$0;
                    relay2 = this.this$0;
                    relay = relay6;
                }
                catch (Throwable throwable) {
                    relay4 = this.this$0;
                    relay5 = this.this$0;
                    Relay relay7 = relay4;
                    synchronized (relay7) {
                        relay5.setUpstreamReader(null);
                        Relay $this$notifyAll$iv = relay5;
                        Intrinsics.checkNotNull($this$notifyAll$iv);
                        $this$notifyAll$iv.notifyAll();
                        throw throwable;
                    }
                }
                synchronized (relay) {
                    relay2.setUpstreamReader(null);
                    Relay $this$notifyAll$iv = relay2;
                    Intrinsics.checkNotNull($this$notifyAll$iv);
                    ((Object)$this$notifyAll$iv).notifyAll();
                    return -1L;
                }
            }
            long bytesRead = Math.min(upstreamBytesRead, (long)var2_2);
            this.this$0.getUpstreamBuffer().copyTo(sink2, 0L, bytesRead);
            this.sourcePos += bytesRead;
            FileOperator fileOperator = this.fileOperator;
            Intrinsics.checkNotNull(fileOperator);
            fileOperator.write(32L + this.this$0.getUpstreamPos(), this.this$0.getUpstreamBuffer().clone(), upstreamBytesRead);
            Relay relay = this.this$0;
            Relay relay8 = this.this$0;
            Relay relay9 = relay;
            synchronized (relay9) {
                relay8.getBuffer().write(relay8.getUpstreamBuffer(), upstreamBytesRead);
                if (relay8.getBuffer().size() > relay8.getBufferMaxSize()) {
                    relay8.getBuffer().skip(relay8.getBuffer().size() - relay8.getBufferMaxSize());
                }
                Relay relay10 = relay8;
                relay10.setUpstreamPos(relay10.getUpstreamPos() + upstreamBytesRead);
            }
            long l2 = bytesRead;
            relay9 = this.this$0;
            Relay relay11 = this.this$0;
            Relay relay12 = relay9;
            synchronized (relay12) {
                void var1_1;
                relay11.setUpstreamReader(null);
                Relay $this$notifyAll$iv = relay11;
                Intrinsics.checkNotNull($this$notifyAll$iv);
                ((Object)var1_1).notifyAll();
                return l2;
            }
        }

        @Override
        @NotNull
        public final Timeout timeout() {
            return this.timeout;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void close() throws IOException {
            void var1_1;
            if (this.fileOperator == null) {
                return;
            }
            this.fileOperator = null;
            RandomAccessFile fileToClose = null;
            Relay relay = this.this$0;
            Relay relay2 = this.this$0;
            synchronized (relay) {
                int n2 = relay2.getSourceCount();
                relay2.setSourceCount(n2 + -1);
                if (relay2.getSourceCount() == 0) {
                    fileToClose = relay2.getFile();
                    relay2.setFile(null);
                }
            }
            void v0 = var1_1;
            if (v0 != null) {
                Util.closeQuietly((Closeable)v0);
                return;
            }
        }
    }
}

