/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.Call;
import okhttp3.EventListener;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http2.Header;
import okhttp3.internal.io.FileSystem;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Options;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u00b8\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\b\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u001a\u001e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u0017\u001a'\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u00112\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\"0!\"\u00020\"\u00a2\u0006\u0002\u0010#\u001a\u001a\u0010$\u001a\u00020\u001b2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001b0&H\u0086\b\u00f8\u0001\u0000\u001a-\u0010'\u001a\b\u0012\u0004\u0012\u0002H)0(\"\u0004\b\u0000\u0010)2\u0012\u0010*\u001a\n\u0012\u0006\b\u0001\u0012\u0002H)0!\"\u0002H)H\u0007\u00a2\u0006\u0002\u0010+\u001a\u000e\u0010,\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0011\u001a1\u0010-\u001a\u0004\u0018\u0001H)\"\u0004\b\u0000\u0010)2\u0006\u0010.\u001a\u00020\"2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H)002\u0006\u00101\u001a\u00020\u0011\u00a2\u0006\u0002\u00102\u001a\u0016\u00103\u001a\u0002042\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u00105\u001a\u00020\u000f\u001a\"\u00106\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00112\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001b0&H\u0086\b\u00f8\u0001\u0000\u001a%\u00107\u001a\u00020\u001b\"\u0004\b\u0000\u00108*\b\u0012\u0004\u0012\u0002H8092\u0006\u0010:\u001a\u0002H8H\u0000\u00a2\u0006\u0002\u0010;\u001a\u0015\u0010<\u001a\u00020\u0014*\u00020=2\u0006\u0010>\u001a\u00020\u0014H\u0086\u0004\u001a\u0015\u0010<\u001a\u00020\u0017*\u00020\u00142\u0006\u0010>\u001a\u00020\u0017H\u0086\u0004\u001a\u0015\u0010<\u001a\u00020\u0014*\u00020?2\u0006\u0010>\u001a\u00020\u0014H\u0086\u0004\u001a\n\u0010@\u001a\u00020A*\u00020B\u001a\r\u0010C\u001a\u00020\u001b*\u00020\"H\u0080\b\u001a\r\u0010D\u001a\u00020\u001b*\u00020\"H\u0080\b\u001a\n\u0010E\u001a\u00020\u000f*\u00020\u0011\u001a\u0012\u0010F\u001a\u00020\u000f*\u00020G2\u0006\u0010H\u001a\u00020G\u001a\n\u0010I\u001a\u00020\u001b*\u00020J\u001a\n\u0010I\u001a\u00020\u001b*\u00020K\u001a\n\u0010I\u001a\u00020\u001b*\u00020L\u001a#\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00110!*\b\u0012\u0004\u0012\u00020\u00110!2\u0006\u0010N\u001a\u00020\u0011\u00a2\u0006\u0002\u0010O\u001a&\u0010P\u001a\u00020\u0014*\u00020\u00112\u0006\u0010Q\u001a\u00020R2\b\b\u0002\u0010S\u001a\u00020\u00142\b\b\u0002\u0010T\u001a\u00020\u0014\u001a&\u0010P\u001a\u00020\u0014*\u00020\u00112\u0006\u0010U\u001a\u00020\u00112\b\b\u0002\u0010S\u001a\u00020\u00142\b\b\u0002\u0010T\u001a\u00020\u0014\u001a\u001a\u0010V\u001a\u00020\u000f*\u00020W2\u0006\u0010X\u001a\u00020\u00142\u0006\u0010Y\u001a\u00020\u0019\u001a;\u0010Z\u001a\b\u0012\u0004\u0012\u0002H)0(\"\u0004\b\u0000\u0010)*\b\u0012\u0004\u0012\u0002H)0[2\u0017\u0010\\\u001a\u0013\u0012\u0004\u0012\u0002H)\u0012\u0004\u0012\u00020\u000f0]\u00a2\u0006\u0002\b^H\u0086\b\u00f8\u0001\u0000\u001a5\u0010_\u001a\u00020\u000f*\b\u0012\u0004\u0012\u00020\u00110!2\u000e\u0010H\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010!2\u000e\u0010`\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00110a\u00a2\u0006\u0002\u0010b\u001a\n\u0010c\u001a\u00020\u0017*\u00020d\u001a+\u0010e\u001a\u00020\u0014*\b\u0012\u0004\u0012\u00020\u00110!2\u0006\u0010N\u001a\u00020\u00112\f\u0010`\u001a\b\u0012\u0004\u0012\u00020\u00110a\u00a2\u0006\u0002\u0010f\u001a\n\u0010g\u001a\u00020\u0014*\u00020\u0011\u001a\u001e\u0010h\u001a\u00020\u0014*\u00020\u00112\b\b\u0002\u0010S\u001a\u00020\u00142\b\b\u0002\u0010T\u001a\u00020\u0014\u001a\u001e\u0010i\u001a\u00020\u0014*\u00020\u00112\b\b\u0002\u0010S\u001a\u00020\u00142\b\b\u0002\u0010T\u001a\u00020\u0014\u001a\u0014\u0010j\u001a\u00020\u0014*\u00020\u00112\b\b\u0002\u0010S\u001a\u00020\u0014\u001a9\u0010k\u001a\b\u0012\u0004\u0012\u00020\u00110!*\b\u0012\u0004\u0012\u00020\u00110!2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00110!2\u000e\u0010`\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00110a\u00a2\u0006\u0002\u0010l\u001a\u0012\u0010m\u001a\u00020\u000f*\u00020n2\u0006\u0010o\u001a\u00020p\u001a\u0012\u0010q\u001a\u00020\u000f*\u00020L2\u0006\u0010r\u001a\u00020s\u001a\r\u0010t\u001a\u00020\u001b*\u00020\"H\u0086\b\u001a\r\u0010u\u001a\u00020\u001b*\u00020\"H\u0086\b\u001a\n\u0010v\u001a\u00020\u0014*\u00020R\u001a\n\u0010w\u001a\u00020\u0011*\u00020L\u001a\u0012\u0010x\u001a\u00020y*\u00020s2\u0006\u0010z\u001a\u00020y\u001a\n\u0010{\u001a\u00020\u0014*\u00020s\u001a\u0012\u0010|\u001a\u00020\u0014*\u00020}2\u0006\u0010~\u001a\u00020=\u001a\u001a\u0010|\u001a\u00020\u000f*\u00020W2\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010Y\u001a\u00020\u0019\u001a\u0011\u0010\u007f\u001a\t\u0012\u0005\u0012\u00030\u0080\u00010(*\u00020\u0003\u001a\u0012\u0010\u0081\u0001\u001a\u00020\u0003*\t\u0012\u0005\u0012\u00030\u0080\u00010(\u001a\u000b\u0010\u0082\u0001\u001a\u00020\u0011*\u00020\u0014\u001a\u000b\u0010\u0082\u0001\u001a\u00020\u0011*\u00020\u0017\u001a\u0016\u0010\u0083\u0001\u001a\u00020\u0011*\u00020G2\t\b\u0002\u0010\u0084\u0001\u001a\u00020\u000f\u001a\u001d\u0010\u0085\u0001\u001a\b\u0012\u0004\u0012\u0002H)0(\"\u0004\b\u0000\u0010)*\b\u0012\u0004\u0012\u0002H)0(\u001a7\u0010\u0086\u0001\u001a\u0011\u0012\u0005\u0012\u0003H\u0088\u0001\u0012\u0005\u0012\u0003H\u0089\u00010\u0087\u0001\"\u0005\b\u0000\u0010\u0088\u0001\"\u0005\b\u0001\u0010\u0089\u0001*\u0011\u0012\u0005\u0012\u0003H\u0088\u0001\u0012\u0005\u0012\u0003H\u0089\u00010\u0087\u0001\u001a\u0014\u0010\u008a\u0001\u001a\u00020\u0017*\u00020\u00112\u0007\u0010\u008b\u0001\u001a\u00020\u0017\u001a\u0016\u0010\u008c\u0001\u001a\u00020\u0014*\u0004\u0018\u00010\u00112\u0007\u0010\u008b\u0001\u001a\u00020\u0014\u001a\u001f\u0010\u008d\u0001\u001a\u00020\u0011*\u00020\u00112\b\b\u0002\u0010S\u001a\u00020\u00142\b\b\u0002\u0010T\u001a\u00020\u0014\u001a\u000e\u0010\u008e\u0001\u001a\u00020\u001b*\u00020\"H\u0086\b\u001a'\u0010\u008f\u0001\u001a\u00030\u0090\u0001*\b0\u0091\u0001j\u0003`\u0092\u00012\u0013\u0010\u0093\u0001\u001a\u000e\u0012\n\u0012\b0\u0091\u0001j\u0003`\u0092\u00010(\u001a\u0015\u0010\u0094\u0001\u001a\u00020\u001b*\u00030\u0095\u00012\u0007\u0010\u0096\u0001\u001a\u00020\u0014\"\u0010\u0010\u0000\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u000e\u001a\u00020\u000f8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0010\u001a\u00020\u00118\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0012\u001a\u00020\u0011X\u0086T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0097\u0001"}, d2={"EMPTY_BYTE_ARRAY", "", "EMPTY_HEADERS", "Lokhttp3/Headers;", "EMPTY_REQUEST", "Lokhttp3/RequestBody;", "EMPTY_RESPONSE", "Lokhttp3/ResponseBody;", "UNICODE_BOMS", "Lokio/Options;", "UTC", "Ljava/util/TimeZone;", "VERIFY_AS_IP_ADDRESS", "Lkotlin/text/Regex;", "assertionsEnabled", "", "okHttpName", "", "userAgent", "checkDuration", "", "name", "duration", "", "unit", "Ljava/util/concurrent/TimeUnit;", "checkOffsetAndCount", "", "arrayLength", "offset", "count", "format", "args", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "ignoreIoExceptions", "block", "Lkotlin/Function0;", "immutableListOf", "", "T", "elements", "([Ljava/lang/Object;)Ljava/util/List;", "isSensitiveHeader", "readFieldOrNull", "instance", "fieldType", "Ljava/lang/Class;", "fieldName", "(Ljava/lang/Object;Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Object;", "threadFactory", "Ljava/util/concurrent/ThreadFactory;", "daemon", "threadName", "addIfAbsent", "E", "", "element", "(Ljava/util/List;Ljava/lang/Object;)V", "and", "", "mask", "", "asFactory", "Lokhttp3/EventListener$Factory;", "Lokhttp3/EventListener;", "assertThreadDoesntHoldLock", "assertThreadHoldsLock", "canParseAsIpAddress", "canReuseConnectionFor", "Lokhttp3/HttpUrl;", "other", "closeQuietly", "Ljava/io/Closeable;", "Ljava/net/ServerSocket;", "Ljava/net/Socket;", "concat", "value", "([Ljava/lang/String;Ljava/lang/String;)[Ljava/lang/String;", "delimiterOffset", "delimiter", "", "startIndex", "endIndex", "delimiters", "discard", "Lokio/Source;", "timeout", "timeUnit", "filterList", "", "predicate", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "hasIntersection", "comparator", "Ljava/util/Comparator;", "([Ljava/lang/String;[Ljava/lang/String;Ljava/util/Comparator;)Z", "headersContentLength", "Lokhttp3/Response;", "indexOf", "([Ljava/lang/String;Ljava/lang/String;Ljava/util/Comparator;)I", "indexOfControlOrNonAscii", "indexOfFirstNonAsciiWhitespace", "indexOfLastNonAsciiWhitespace", "indexOfNonWhitespace", "intersect", "([Ljava/lang/String;[Ljava/lang/String;Ljava/util/Comparator;)[Ljava/lang/String;", "isCivilized", "Lokhttp3/internal/io/FileSystem;", "file", "Ljava/io/File;", "isHealthy", "source", "Lokio/BufferedSource;", "notify", "notifyAll", "parseHexDigit", "peerName", "readBomAsCharset", "Ljava/nio/charset/Charset;", "default", "readMedium", "skipAll", "Lokio/Buffer;", "b", "toHeaderList", "Lokhttp3/internal/http2/Header;", "toHeaders", "toHexString", "toHostHeader", "includeDefaultPort", "toImmutableList", "toImmutableMap", "", "K", "V", "toLongOrDefault", "defaultValue", "toNonNegativeInt", "trimSubstring", "wait", "withSuppressed", "", "Ljava/lang/Exception;", "Lkotlin/Exception;", "suppressed", "writeMedium", "Lokio/BufferedSink;", "medium", "okhttp"})
@JvmName(name="Util")
@SourceDebugExtension(value={"SMAP\nUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Util.kt\nokhttp3/internal/Util\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,636:1\n37#2,2:637\n1627#3,6:639\n1#4:645\n1549#5:646\n1620#5,3:647\n*S KotlinDebug\n*F\n+ 1 Util.kt\nokhttp3/internal/Util\n*L\n127#1:637,2\n167#1:639,6\n300#1:646\n300#1:647,3\n*E\n"})
public final class Util {
    @JvmField
    @NotNull
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    @JvmField
    @NotNull
    public static final Headers EMPTY_HEADERS = Headers.Companion.of(new String[0]);
    @JvmField
    @NotNull
    public static final ResponseBody EMPTY_RESPONSE = ResponseBody.Companion.create$default(ResponseBody.Companion, EMPTY_BYTE_ARRAY, null, 1, null);
    @JvmField
    @NotNull
    public static final RequestBody EMPTY_REQUEST = RequestBody.Companion.create$default(RequestBody.Companion, EMPTY_BYTE_ARRAY, null, 0, 0, 7, null);
    @NotNull
    private static final Options UNICODE_BOMS;
    @JvmField
    @NotNull
    public static final TimeZone UTC;
    @NotNull
    private static final Regex VERIFY_AS_IP_ADDRESS;
    @JvmField
    public static final boolean assertionsEnabled;
    @JvmField
    @NotNull
    public static final String okHttpName;
    @NotNull
    public static final String userAgent = "okhttp/4.12.0";

    /*
     * WARNING - void declaration
     */
    public static final void checkOffsetAndCount(long arrayLength, long offset, long count) {
        void var2_2;
        long l2;
        if ((offset | count) < 0L || offset > arrayLength || l2 - var2_2 < count) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ThreadFactory threadFactory(@NotNull String name, boolean daemon) {
        void var1_1;
        String string;
        Intrinsics.checkNotNullParameter(name, "");
        return arg_0 -> Util.threadFactory$lambda$1(string, (boolean)var1_1, arg_0);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String[] intersect(@NotNull String[] $this$intersect, @NotNull String[] other, @NotNull Comparator<? super String> comparator) {
        void var3_3;
        Collection collection;
        Intrinsics.checkNotNullParameter($this$intersect, "");
        Intrinsics.checkNotNullParameter(other, "");
        Intrinsics.checkNotNullParameter(comparator, "");
        List result = new ArrayList();
        block0: for (String a2 : $this$intersect) {
            for (String b2 : other) {
                if (comparator.compare(a2, b2) != 0) continue;
                result.add(a2);
                continue block0;
            }
        }
        Collection collection2 = collection = (Collection)var3_3;
        return collection.toArray(new String[0]);
    }

    public static final boolean hasIntersection(@NotNull String[] $this$hasIntersection, @Nullable String[] other, @NotNull Comparator<? super String> comparator) {
        Intrinsics.checkNotNullParameter($this$hasIntersection, "");
        Intrinsics.checkNotNullParameter(comparator, "");
        if ($this$hasIntersection.length == 0 || other == null || other.length == 0) {
            return false;
        }
        for (String a2 : $this$hasIntersection) {
            Iterator<String> iterator2 = ArrayIteratorKt.iterator(other);
            while (iterator2.hasNext()) {
                String b2 = iterator2.next();
                if (comparator.compare(a2, b2) != 0) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String toHostHeader(@NotNull HttpUrl $this$toHostHeader, boolean includeDefaultPort) {
        void var2_2;
        void var1_1;
        String host;
        Intrinsics.checkNotNullParameter($this$toHostHeader, "");
        String string = host = StringsKt.contains$default((CharSequence)$this$toHostHeader.host(), ":", false, 2, null) ? "[" + $this$toHostHeader.host() + ']' : $this$toHostHeader.host();
        if (var1_1 != false || $this$toHostHeader.port() != HttpUrl.Companion.defaultPort($this$toHostHeader.scheme())) {
            HttpUrl httpUrl;
            return host + ':' + httpUrl.port();
        }
        return var2_2;
    }

    public static /* synthetic */ String toHostHeader$default(HttpUrl httpUrl, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            bl = false;
        }
        return Util.toHostHeader(httpUrl, bl);
    }

    public static final int indexOf(@NotNull String[] $this$indexOf, @NotNull String value, @NotNull Comparator<String> comparator) {
        String[] $this$indexOfFirst$iv;
        Intrinsics.checkNotNullParameter($this$indexOf, "");
        Intrinsics.checkNotNullParameter(value, "");
        Intrinsics.checkNotNullParameter(comparator, "");
        int n2 = $this$indexOfFirst$iv.length;
        for (int index$iv = 0; index$iv < n2; ++index$iv) {
            String it = $this$indexOfFirst$iv[index$iv];
            if (!(comparator.compare(it, value) == 0)) continue;
            return index$iv;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String[] concat(@NotNull String[] $this$concat, @NotNull String value) {
        String[] stringArray;
        void var1_1;
        Intrinsics.checkNotNullParameter($this$concat, "");
        Intrinsics.checkNotNullParameter(value, "");
        String[] stringArray2 = Arrays.copyOf($this$concat, $this$concat.length + 1);
        Intrinsics.checkNotNullExpressionValue(stringArray2, "");
        String[] result = stringArray2;
        stringArray2[ArraysKt.getLastIndex(result)] = var1_1;
        return stringArray;
    }

    /*
     * WARNING - void declaration
     */
    public static final int indexOfFirstNonAsciiWhitespace(@NotNull String $this$indexOfFirstNonAsciiWhitespace, int startIndex, int endIndex) {
        void var2_2;
        void i2;
        Intrinsics.checkNotNullParameter($this$indexOfFirstNonAsciiWhitespace, "");
        while (i2 < endIndex) {
            char c2 = $this$indexOfFirstNonAsciiWhitespace.charAt((int)i2);
            if (!((((c2 == '\t' ? true : c2 == '\n') ? true : c2 == '\f') ? true : c2 == '\r') ? true : c2 == ' ')) {
                return (int)i2;
            }
            ++i2;
        }
        return (int)var2_2;
    }

    public static /* synthetic */ int indexOfFirstNonAsciiWhitespace$default(String string, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n2 = 0;
        }
        if ((n4 & 2) != 0) {
            n3 = string.length();
        }
        return Util.indexOfFirstNonAsciiWhitespace(string, n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    public static final int indexOfLastNonAsciiWhitespace(@NotNull String $this$indexOfLastNonAsciiWhitespace, int startIndex, int endIndex) {
        void var1_1;
        Intrinsics.checkNotNullParameter($this$indexOfLastNonAsciiWhitespace, "");
        int i2 = endIndex - 1;
        if (startIndex <= i2) {
            while (true) {
                char c2;
                if (!(((((c2 = $this$indexOfLastNonAsciiWhitespace.charAt(i2)) == '\t' ? true : c2 == '\n') ? true : c2 == '\f') ? true : c2 == '\r') ? true : c2 == ' ')) {
                    return i2 + 1;
                }
                if (i2 == startIndex) break;
                --i2;
            }
        }
        return (int)var1_1;
    }

    public static /* synthetic */ int indexOfLastNonAsciiWhitespace$default(String string, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n2 = 0;
        }
        if ((n4 & 2) != 0) {
            n3 = string.length();
        }
        return Util.indexOfLastNonAsciiWhitespace(string, n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String trimSubstring(@NotNull String $this$trimSubstring, int startIndex, int endIndex) {
        void var2_2;
        void var1_1;
        String string;
        Intrinsics.checkNotNullParameter($this$trimSubstring, "");
        int start = Util.indexOfFirstNonAsciiWhitespace($this$trimSubstring, startIndex, endIndex);
        int end = Util.indexOfLastNonAsciiWhitespace($this$trimSubstring, start, endIndex);
        String string2 = string.substring((int)var1_1, (int)var2_2);
        Intrinsics.checkNotNullExpressionValue(string2, "");
        return string2;
    }

    public static /* synthetic */ String trimSubstring$default(String string, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n2 = 0;
        }
        if ((n4 & 2) != 0) {
            n3 = string.length();
        }
        return Util.trimSubstring(string, n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    public static final int delimiterOffset(@NotNull String $this$delimiterOffset, @NotNull String delimiters, int startIndex, int endIndex) {
        void var3_3;
        void i2;
        Intrinsics.checkNotNullParameter($this$delimiterOffset, "");
        Intrinsics.checkNotNullParameter(delimiters, "");
        while (i2 < endIndex) {
            if (StringsKt.contains$default((CharSequence)delimiters, $this$delimiterOffset.charAt((int)i2), false, 2, null)) {
                return (int)i2;
            }
            ++i2;
        }
        return (int)var3_3;
    }

    public static /* synthetic */ int delimiterOffset$default(String string, String string2, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n2 = 0;
        }
        if ((n4 & 4) != 0) {
            n3 = string.length();
        }
        return Util.delimiterOffset(string, string2, n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    public static final int delimiterOffset(@NotNull String $this$delimiterOffset, char delimiter, int startIndex, int endIndex) {
        void var3_3;
        void i2;
        Intrinsics.checkNotNullParameter($this$delimiterOffset, "");
        while (i2 < endIndex) {
            if ($this$delimiterOffset.charAt((int)i2) == delimiter) {
                return (int)i2;
            }
            ++i2;
        }
        return (int)var3_3;
    }

    public static /* synthetic */ int delimiterOffset$default(String string, char c2, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n2 = 0;
        }
        if ((n4 & 4) != 0) {
            n3 = string.length();
        }
        return Util.delimiterOffset(string, c2, n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    public static final int indexOfControlOrNonAscii(@NotNull String $this$indexOfControlOrNonAscii) {
        Intrinsics.checkNotNullParameter($this$indexOfControlOrNonAscii, "");
        int n2 = $this$indexOfControlOrNonAscii.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            void var3_3;
            char c2 = $this$indexOfControlOrNonAscii.charAt(i2);
            if (Intrinsics.compare(c2, 31) > 0 && Intrinsics.compare((int)var3_3, 127) < 0) continue;
            return i2;
        }
        return -1;
    }

    public static final boolean canParseAsIpAddress(@NotNull String $this$canParseAsIpAddress) {
        String string;
        Intrinsics.checkNotNullParameter($this$canParseAsIpAddress, "");
        return VERIFY_AS_IP_ADDRESS.matches(string);
    }

    public static final boolean isSensitiveHeader(@NotNull String name) {
        String string;
        Intrinsics.checkNotNullParameter(name, "");
        return StringsKt.equals(name, "Authorization", true) || StringsKt.equals(name, "Cookie", true) || StringsKt.equals(name, "Proxy-Authorization", true) || StringsKt.equals(string, "Set-Cookie", true);
    }

    @NotNull
    public static final String format(@NotNull String format, Object ... args2) {
        String string;
        T[] TArray;
        Intrinsics.checkNotNullParameter(format, "");
        Intrinsics.checkNotNullParameter(args2, "");
        Locale locale = Locale.US;
        void v0 = TArray;
        TArray = Arrays.copyOf(v0, ((void)v0).length);
        String string2 = String.format(locale, string, (Object[])Arrays.copyOf(TArray, TArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Charset readBomAsCharset(@NotNull BufferedSource $this$readBomAsCharset, @NotNull Charset charset) throws IOException {
        BufferedSource bufferedSource;
        Intrinsics.checkNotNullParameter($this$readBomAsCharset, "");
        Intrinsics.checkNotNullParameter(charset, "");
        switch (bufferedSource.select(UNICODE_BOMS)) {
            case 0: {
                Charset charset2 = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue(charset2, "");
                return charset2;
            }
            case 1: {
                Charset charset3 = StandardCharsets.UTF_16BE;
                Intrinsics.checkNotNullExpressionValue(charset3, "");
                return charset3;
            }
            case 2: {
                Charset charset4 = StandardCharsets.UTF_16LE;
                Intrinsics.checkNotNullExpressionValue(charset4, "");
                return charset4;
            }
            case 3: {
                return Charsets.INSTANCE.UTF32_BE();
            }
            case 4: {
                return Charsets.INSTANCE.UTF32_LE();
            }
            case -1: {
                void var1_1;
                return var1_1;
            }
        }
        throw new AssertionError();
    }

    /*
     * WARNING - void declaration
     */
    public static final int checkDuration(@NotNull String name, long duration, @Nullable TimeUnit unit) {
        void var1_1;
        void var3_2;
        Intrinsics.checkNotNullParameter(name, "");
        if (!(duration >= 0L)) {
            String string = name + " < 0";
            throw new IllegalStateException(string.toString());
        }
        if (!(unit != null)) {
            String string = "unit == null";
            throw new IllegalStateException(string.toString());
        }
        long millis = var3_2.toMillis(duration);
        if (!(millis <= Integer.MAX_VALUE)) {
            name = name + " too large.";
            throw new IllegalArgumentException(name.toString());
        }
        if (!(millis != 0L || var1_1 <= 0L)) {
            String string;
            string = string + " too small.";
            throw new IllegalArgumentException(string.toString());
        }
        return (int)millis;
    }

    public static final int parseHexDigit(char $this$parseHexDigit) {
        char c2 = $this$parseHexDigit;
        boolean bl = '0' <= c2 ? c2 < ':' : false;
        if (bl) {
            return $this$parseHexDigit - 48;
        }
        boolean bl2 = 'a' <= c2 ? c2 < 'g' : false;
        if (bl2) {
            return $this$parseHexDigit - 97 + 10;
        }
        boolean bl3 = 'A' <= c2 ? c2 < 'G' : false;
        if (bl3) {
            char c3;
            return c3 - 65 + 10;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Headers toHeaders(@NotNull List<Header> $this$toHeaders) {
        void var1_1;
        Iterator<Header> iterator2;
        Intrinsics.checkNotNullParameter($this$toHeaders, "");
        Headers.Builder builder = new Headers.Builder();
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            void var3_3;
            Header header = (Header)iterator2.next();
            ByteString name = header.component1();
            ByteString value = header.component2();
            builder.addLenient$okhttp(var3_3.utf8(), ((ByteString)((Object)header)).utf8());
        }
        return var1_1.build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Header> toHeaderList(@NotNull Headers $this$toHeaderList) {
        void var1_1;
        Intrinsics.checkNotNullParameter($this$toHeaderList, "");
        Iterable $this$map$iv = RangesKt.until(0, $this$toHeaderList.size());
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        object = object.iterator();
        while (object.hasNext()) {
            void var3_3;
            void it;
            int item$iv$iv = ((IntIterator)object).nextInt();
            Collection collection = destination$iv$iv;
            collection.add(new Header($this$toHeaderList.name((int)it), $this$toHeaderList.value((int)var3_3)));
        }
        return (List)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean canReuseConnectionFor(@NotNull HttpUrl $this$canReuseConnectionFor, @NotNull HttpUrl other) {
        void var1_1;
        HttpUrl httpUrl;
        Intrinsics.checkNotNullParameter($this$canReuseConnectionFor, "");
        Intrinsics.checkNotNullParameter(other, "");
        return Intrinsics.areEqual($this$canReuseConnectionFor.host(), other.host()) && $this$canReuseConnectionFor.port() == other.port() && Intrinsics.areEqual(httpUrl.scheme(), var1_1.scheme());
    }

    @NotNull
    public static final EventListener.Factory asFactory(@NotNull EventListener $this$asFactory) {
        EventListener eventListener;
        Intrinsics.checkNotNullParameter($this$asFactory, "");
        return arg_0 -> Util.asFactory$lambda$8(eventListener, arg_0);
    }

    /*
     * WARNING - void declaration
     */
    public static final int and(byte $this$and, int mask) {
        void var1_1;
        return $this$and & var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final int and(short $this$and, int mask) {
        void var1_1;
        return $this$and & var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final long and(int $this$and, long mask) {
        void var1_1;
        return (long)$this$and & var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final void writeMedium(@NotNull BufferedSink $this$writeMedium, int medium) throws IOException {
        void var1_1;
        BufferedSink bufferedSink;
        Intrinsics.checkNotNullParameter($this$writeMedium, "");
        $this$writeMedium.writeByte(medium >>> 16 & 0xFF);
        $this$writeMedium.writeByte(medium >>> 8 & 0xFF);
        bufferedSink.writeByte((int)(var1_1 & 0xFF));
    }

    public static final int readMedium(@NotNull BufferedSource $this$readMedium) throws IOException {
        BufferedSource bufferedSource;
        Intrinsics.checkNotNullParameter($this$readMedium, "");
        return Util.and($this$readMedium.readByte(), 255) << 16 | Util.and($this$readMedium.readByte(), 255) << 8 | Util.and(bufferedSource.readByte(), 255);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean skipAll(@NotNull Source $this$skipAll, int duration, @NotNull TimeUnit timeUnit) throws IOException {
        boolean bl;
        block9: {
            long originalDurationNs;
            long nowNs;
            block8: {
                void var2_4;
                Intrinsics.checkNotNullParameter($this$skipAll, "");
                Intrinsics.checkNotNullParameter((Object)timeUnit, "");
                nowNs = System.nanoTime();
                originalDurationNs = $this$skipAll.timeout().hasDeadline() ? $this$skipAll.timeout().deadlineNanoTime() - nowNs : Long.MAX_VALUE;
                $this$skipAll.timeout().deadlineNanoTime(nowNs + Math.min(originalDurationNs, var2_4.toNanos(duration)));
                try {
                    Buffer skipBuffer = new Buffer();
                    while ($this$skipAll.read(skipBuffer, 8192L) != -1L) {
                        skipBuffer.clear();
                    }
                    bl = true;
                    if (originalDurationNs != Long.MAX_VALUE) break block8;
                    $this$skipAll.timeout().clearDeadline();
                }
                catch (InterruptedIOException interruptedIOException) {
                    bl = false;
                    if (originalDurationNs == Long.MAX_VALUE) {
                        $this$skipAll.timeout().clearDeadline();
                    } else {
                        $this$skipAll.timeout().deadlineNanoTime(nowNs + originalDurationNs);
                    }
                }
                catch (Throwable throwable) {
                    if (originalDurationNs == Long.MAX_VALUE) {
                        $this$skipAll.timeout().clearDeadline();
                    } else {
                        void var3_5;
                        Source source2;
                        source2.timeout().deadlineNanoTime((long)(var3_5 + originalDurationNs));
                    }
                    throw throwable;
                }
                break block9;
            }
            $this$skipAll.timeout().deadlineNanoTime(nowNs + originalDurationNs);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean discard(@NotNull Source $this$discard, int timeout2, @NotNull TimeUnit timeUnit) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$discard, "");
        Intrinsics.checkNotNullParameter((Object)timeUnit, "");
        try {
            void var2_3;
            void var1_2;
            Source source2;
            bl = Util.skipAll(source2, (int)var1_2, (TimeUnit)var2_3);
        }
        catch (IOException iOException) {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public static final String peerName(@NotNull Socket $this$peerName) {
        SocketAddress socketAddress;
        Intrinsics.checkNotNullParameter($this$peerName, "");
        SocketAddress address = $this$peerName.getRemoteSocketAddress();
        if (address instanceof InetSocketAddress) {
            String string = ((InetSocketAddress)address).getHostName();
            Intrinsics.checkNotNullExpressionValue(string, "");
            return string;
        }
        return socketAddress.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isHealthy(@NotNull Socket $this$isHealthy, @NotNull BufferedSource source2) {
        int n2;
        Intrinsics.checkNotNullParameter($this$isHealthy, "");
        Intrinsics.checkNotNullParameter(source2, "");
        try {
            int n3;
            int readTimeout = $this$isHealthy.getSoTimeout();
            try {
                void var1_1;
                $this$isHealthy.setSoTimeout(1);
                n3 = !var1_1.exhausted() ? 1 : 0;
            }
            catch (Throwable throwable) {
                Socket socket;
                socket.setSoTimeout(n2);
                throw throwable;
            }
            $this$isHealthy.setSoTimeout(readTimeout);
            n2 = n3;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            n2 = 1;
        }
        catch (IOException iOException) {
            n2 = 0;
        }
        return n2 != 0;
    }

    public static final void ignoreIoExceptions(@NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, "");
        try {
            Function0<Unit> function0;
            function0.invoke();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void threadName(@NotNull String name, @NotNull Function0<Unit> block) {
        String string;
        Intrinsics.checkNotNullParameter(name, "");
        Intrinsics.checkNotNullParameter(block, "");
        Thread currentThread = Thread.currentThread();
        String oldName = currentThread.getName();
        currentThread.setName(string);
        try {
            void var1_2;
            var1_2.invoke();
        }
        catch (Throwable throwable) {
            void var3_4;
            void var2_3;
            InlineMarker.finallyStart(1);
            var2_3.setName((String)var3_4);
            InlineMarker.finallyEnd(1);
            throw throwable;
        }
        InlineMarker.finallyStart(1);
        currentThread.setName(oldName);
        InlineMarker.finallyEnd(1);
    }

    /*
     * WARNING - void declaration
     */
    public static final int skipAll(@NotNull Buffer $this$skipAll, byte b2) {
        void var2_2;
        Intrinsics.checkNotNullParameter($this$skipAll, "");
        int count = 0;
        while (!$this$skipAll.exhausted() && $this$skipAll.getByte(0L) == b2) {
            ++count;
            $this$skipAll.readByte();
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static final int indexOfNonWhitespace(@NotNull String $this$indexOfNonWhitespace, int startIndex) {
        String string;
        void i2;
        Intrinsics.checkNotNullParameter($this$indexOfNonWhitespace, "");
        int n2 = $this$indexOfNonWhitespace.length();
        while (i2 < n2) {
            void var3_3;
            char c2 = $this$indexOfNonWhitespace.charAt((int)i2);
            if (c2 != ' ' && var3_3 != 9) {
                return (int)i2;
            }
            ++i2;
        }
        return string.length();
    }

    public static /* synthetic */ int indexOfNonWhitespace$default(String string, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n2 = 0;
        }
        return Util.indexOfNonWhitespace(string, n2);
    }

    public static final long headersContentLength(@NotNull Response $this$headersContentLength) {
        Response response;
        Intrinsics.checkNotNullParameter($this$headersContentLength, "");
        String string = response.headers().get("Content-Length");
        if (string != null) {
            return Util.toLongOrDefault(string, -1L);
        }
        return -1L;
    }

    /*
     * WARNING - void declaration
     */
    public static final long toLongOrDefault(@NotNull String $this$toLongOrDefault, long defaultValue) {
        long l2;
        Intrinsics.checkNotNullParameter($this$toLongOrDefault, "");
        try {
            String string;
            l2 = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            void var1_1;
            l2 = var1_1;
        }
        return l2;
    }

    /*
     * WARNING - void declaration
     */
    public static final int toNonNegativeInt(@Nullable String $this$toNonNegativeInt, int defaultValue) {
        try {
            void var2_2;
            String string = $this$toNonNegativeInt;
            if (string == null) {
                return defaultValue;
            }
            long value = Long.parseLong(string);
            if (value > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            if (value < 0L) {
                return 0;
            }
            return (int)var2_2;
        }
        catch (NumberFormatException numberFormatException) {
            void var1_1;
            return (int)var1_1;
        }
    }

    @NotNull
    public static final <T> List<T> toImmutableList(@NotNull List<? extends T> $this$toImmutableList) {
        List<? extends T> list;
        Intrinsics.checkNotNullParameter($this$toImmutableList, "");
        List list2 = Collections.unmodifiableList(CollectionsKt.toMutableList((Collection)list));
        Intrinsics.checkNotNullExpressionValue(list2, "");
        return list2;
    }

    @SafeVarargs
    @NotNull
    public static final <T> List<T> immutableListOf(T ... elements) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter(elements, "");
        objectArray = (Object[])objectArray.clone();
        List<Object> list = Collections.unmodifiableList(CollectionsKt.listOf(Arrays.copyOf(objectArray, objectArray.length)));
        Intrinsics.checkNotNullExpressionValue(list, "");
        return list;
    }

    @NotNull
    public static final <K, V> Map<K, V> toImmutableMap(@NotNull Map<K, ? extends V> $this$toImmutableMap) {
        Map<K, ? extends V> map;
        Intrinsics.checkNotNullParameter($this$toImmutableMap, "");
        if ($this$toImmutableMap.isEmpty()) {
            return MapsKt.emptyMap();
        }
        Map map2 = Collections.unmodifiableMap((Map)new LinkedHashMap<K, V>(map));
        Intrinsics.checkNotNullExpressionValue(map2, "");
        return map2;
    }

    public static final void closeQuietly(@NotNull Closeable $this$closeQuietly) {
        RuntimeException runtimeException;
        Intrinsics.checkNotNullParameter($this$closeQuietly, "");
        try {
            runtimeException.close();
            return;
        }
        catch (RuntimeException runtimeException2) {
            runtimeException = runtimeException2;
            throw runtimeException2;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static final void closeQuietly(@NotNull Socket $this$closeQuietly) {
        Intrinsics.checkNotNullParameter($this$closeQuietly, "");
        try {
            ((Socket)$this$closeQuietly).close();
            return;
        }
        catch (AssertionError assertionError) {
            $this$closeQuietly = assertionError;
            throw assertionError;
        }
        catch (RuntimeException runtimeException) {
            RuntimeException runtimeException2;
            RuntimeException rethrown = runtimeException;
            if (Intrinsics.areEqual(runtimeException.getMessage(), "bio == null")) {
                return;
            }
            throw runtimeException2;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static final void closeQuietly(@NotNull ServerSocket $this$closeQuietly) {
        RuntimeException runtimeException;
        Intrinsics.checkNotNullParameter($this$closeQuietly, "");
        try {
            ((ServerSocket)((Object)runtimeException)).close();
            return;
        }
        catch (RuntimeException runtimeException2) {
            runtimeException = runtimeException2;
            throw runtimeException2;
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public static final boolean isCivilized(@NotNull FileSystem $this$isCivilized2222, @NotNull File file) {
        void var1_2;
        FileSystem fileSystem;
        Intrinsics.checkNotNullParameter($this$isCivilized2222, "");
        Intrinsics.checkNotNullParameter(file, "");
        Closeable closeable = $this$isCivilized2222.sink(file);
        Throwable throwable = null;
        Sink cfr_ignored_0 = (Sink)closeable;
        $this$isCivilized2222.delete(file);
        CloseableKt.closeFinally(closeable, null);
        return true;
        {
            catch (IOException iOException) {
                try {
                }
                catch (Throwable throwable2) {
                    try {
                        $this$isCivilized2222 = throwable2;
                        throwable = throwable2;
                        throw $this$isCivilized2222;
                    }
                    catch (Throwable $this$isCivilized2222) {
                        CloseableKt.closeFinally(closeable, throwable);
                        throw $this$isCivilized2222;
                    }
                }
                CloseableKt.closeFinally(closeable, null);
            }
        }
        fileSystem.delete((File)var1_2);
        return false;
    }

    @NotNull
    public static final String toHexString(long $this$toHexString) {
        String string = Long.toHexString($this$toHexString);
        Intrinsics.checkNotNullExpressionValue(string, "");
        return string;
    }

    @NotNull
    public static final String toHexString(int $this$toHexString) {
        String string = Integer.toHexString($this$toHexString);
        Intrinsics.checkNotNullExpressionValue(string, "");
        return string;
    }

    public static final void wait(@NotNull Object $this$wait) {
        Object object;
        Intrinsics.checkNotNullParameter($this$wait, "");
        object.wait();
    }

    public static final void notify(@NotNull Object $this$notify) {
        Object object;
        Intrinsics.checkNotNullParameter($this$notify, "");
        object.notify();
    }

    public static final void notifyAll(@NotNull Object $this$notifyAll) {
        Object object;
        Intrinsics.checkNotNullParameter($this$notifyAll, "");
        object.notifyAll();
    }

    @Nullable
    public static final <T> T readFieldOrNull(@NotNull Object instance, @NotNull Class<T> fieldType, @NotNull String fieldName) {
        while (true) {
            Object delegate;
            Intrinsics.checkNotNullParameter(instance, "");
            Intrinsics.checkNotNullParameter(fieldType, "");
            Intrinsics.checkNotNullParameter(fieldName, "");
            Class<?> c2 = instance.getClass();
            while (!Intrinsics.areEqual(c2, Object.class)) {
                try {
                    Field field = c2.getDeclaredField(fieldName);
                    field.setAccessible(true);
                    Object value = field.get(instance);
                    if (!fieldType.isInstance(value)) {
                        return null;
                    }
                    return fieldType.cast(value);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    Intrinsics.checkNotNullExpressionValue(c2.getSuperclass(), "");
                }
            }
            if (Intrinsics.areEqual(fieldName, "delegate") || (delegate = Util.readFieldOrNull(instance, Object.class, "delegate")) == null) break;
            instance = delegate;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static final <E> void addIfAbsent(@NotNull List<E> $this$addIfAbsent, E element) {
        Intrinsics.checkNotNullParameter($this$addIfAbsent, "");
        if (!$this$addIfAbsent.contains(element)) {
            void var1_1;
            List<void> list;
            list.add(var1_1);
        }
    }

    public static final void assertThreadHoldsLock(@NotNull Object $this$assertThreadHoldsLock) {
        Intrinsics.checkNotNullParameter($this$assertThreadHoldsLock, "");
        if (assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock)) {
            Object object;
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + object));
        }
    }

    public static final void assertThreadDoesntHoldLock(@NotNull Object $this$assertThreadDoesntHoldLock) {
        Intrinsics.checkNotNullParameter($this$assertThreadDoesntHoldLock, "");
        if (assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock)) {
            Object object;
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + object));
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Throwable withSuppressed(@NotNull Exception $this$withSuppressed, @NotNull List<? extends Exception> suppressed) {
        Iterator iterator2;
        Exception exception;
        Intrinsics.checkNotNullParameter($this$withSuppressed, "");
        Intrinsics.checkNotNullParameter(suppressed, "");
        Exception $this$withSuppressed_u24lambda_u2410 = exception;
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            void var3_3;
            Exception e2 = (Exception)iterator2.next();
            ExceptionsKt.addSuppressed($this$withSuppressed_u24lambda_u2410, (Throwable)var3_3);
        }
        return exception;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> List<T> filterList(@NotNull Iterable<? extends T> $this$filterList, @NotNull Function1<? super T, Boolean> predicate) {
        void var2_2;
        Iterator<? extends T> iterator2;
        Intrinsics.checkNotNullParameter($this$filterList, "");
        Intrinsics.checkNotNullParameter(predicate, "");
        List result = CollectionsKt.emptyList();
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            void var3_3;
            Object i2 = iterator2.next();
            if (!predicate.invoke(i2).booleanValue()) continue;
            if (result.isEmpty()) {
                result = new ArrayList();
            }
            List list = result;
            Intrinsics.checkNotNull(list);
            TypeIntrinsics.asMutableList(list).add(var3_3);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static final Thread threadFactory$lambda$1(String $name, boolean $daemon, Runnable runnable2) {
        void var1_1;
        Thread thread2;
        Thread thread3;
        Intrinsics.checkNotNullParameter($name, "");
        thread2 = new Thread((Runnable)thread3, (String)((Object)thread2));
        thread3 = thread2;
        thread2.setDaemon((boolean)var1_1);
        return thread2;
    }

    /*
     * WARNING - void declaration
     */
    private static final EventListener asFactory$lambda$8(EventListener $this_asFactory, Call it) {
        EventListener eventListener;
        void var1_1;
        Intrinsics.checkNotNullParameter($this_asFactory, "");
        Intrinsics.checkNotNullParameter(var1_1, "");
        return eventListener;
    }

    static {
        ByteString[] byteStringArray = new ByteString[5];
        ByteString[] byteStringArray2 = byteStringArray;
        byteStringArray[0] = ByteString.Companion.decodeHex("efbbbf");
        byteStringArray2[1] = ByteString.Companion.decodeHex("feff");
        byteStringArray2[2] = ByteString.Companion.decodeHex("fffe");
        byteStringArray2[3] = ByteString.Companion.decodeHex("0000ffff");
        byteStringArray2[4] = ByteString.Companion.decodeHex("ffff0000");
        UNICODE_BOMS = Options.Companion.of(byteStringArray2);
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        Intrinsics.checkNotNull(timeZone);
        UTC = timeZone;
        VERIFY_AS_IP_ADDRESS = new Regex("([0-9a-fA-F]*:[0-9a-fA-F:.]*)|([\\d.]+)");
        assertionsEnabled = OkHttpClient.class.desiredAssertionStatus();
        String string = OkHttpClient.class.getName();
        Intrinsics.checkNotNullExpressionValue(string, "");
        okHttpName = StringsKt.removeSuffix(StringsKt.removePrefix(string, (CharSequence)"okhttp3."), (CharSequence)"Client");
    }
}

