/*
 * Decompiled with CFR 0.152.
 */
package kotlin.random;

import java.io.Serializable;
import kotlin.Metadata;
import kotlin.SinceKotlin;
import kotlin.internal.PlatformImplementationsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.PlatformRandomKt;
import kotlin.random.RandomKt;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b'\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H&J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J$\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\u00042\b\b\u0002\u0010\f\u001a\u00020\u0004H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0004H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0004H\u0016J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0016J\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0016H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0016H\u0016\u00a8\u0006\u0018"}, d2={"Lkotlin/random/Random;", "", "()V", "nextBits", "", "bitCount", "nextBoolean", "", "nextBytes", "", "array", "fromIndex", "toIndex", "size", "nextDouble", "", "until", "from", "nextFloat", "", "nextInt", "nextLong", "", "Default", "kotlin-stdlib"})
@SinceKotlin(version="1.3")
@SourceDebugExtension(value={"SMAP\nRandom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Random.kt\nkotlin/random/Random\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,383:1\n1#2:384\n*E\n"})
public abstract class Random {
    @NotNull
    public static final Default Default = new Default(null);
    @NotNull
    private static final Random defaultRandom = PlatformImplementationsKt.IMPLEMENTATIONS.defaultPlatformRandom();

    public abstract int nextBits(int var1);

    public int nextInt() {
        return this.nextBits(32);
    }

    /*
     * WARNING - void declaration
     */
    public int nextInt(int until) {
        void var1_1;
        return this.nextInt(0, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public int nextInt(int from, int until) {
        void var3_3;
        boolean bl;
        int rnd;
        void var2_2;
        RandomKt.checkRangeBounds(from, until);
        int n2 = until - from;
        if (n2 > 0 || n2 == Integer.MIN_VALUE) {
            int n3;
            int n4 = n2;
            if ((n4 & -n4) == n2) {
                int bitCount = RandomKt.fastLog2(n2);
                n3 = this.nextBits(bitCount);
            } else {
                int v2;
                int bits;
                while ((bits = this.nextInt() >>> 1) - (v2 = bits % n2) + (n2 - 1) < 0) {
                }
                n3 = var2_2;
            }
            rnd = n3;
            return from + rnd;
        }
        do {
            if (from <= (rnd = this.nextInt())) {
                if (rnd < var2_2) {
                    bl = true;
                    continue;
                }
                bl = false;
                continue;
            }
            bl = false;
        } while (!bl);
        return (int)var3_3;
    }

    public long nextLong() {
        return ((long)this.nextInt() << 32) + (long)this.nextInt();
    }

    /*
     * WARNING - void declaration
     */
    public long nextLong(long until) {
        void var1_1;
        return this.nextLong(0L, (long)var1_1);
    }

    public long nextLong(long from, long until) {
        long rnd;
        boolean bl;
        RandomKt.checkRangeBounds(from, until);
        long n2 = until - from;
        if (n2 > 0L) {
            long rnd2;
            long l2 = n2;
            if ((l2 & -l2) == n2) {
                long l3;
                int bitCount;
                int nLow = (int)n2;
                int nHigh = (int)(n2 >>> 32);
                if (nLow != 0) {
                    bitCount = RandomKt.fastLog2(nLow);
                    l3 = (long)this.nextBits(bitCount) & 0xFFFFFFFFL;
                } else if (nHigh == 1) {
                    l3 = (long)this.nextInt() & 0xFFFFFFFFL;
                } else {
                    bitCount = RandomKt.fastLog2(nHigh);
                    l3 = ((long)this.nextBits(bitCount) << 32) + ((long)this.nextInt() & 0xFFFFFFFFL);
                }
                rnd2 = l3;
            } else {
                long v2;
                long bits;
                while ((bits = this.nextLong() >>> 1) - (v2 = bits % n2) + (n2 - 1L) < 0L) {
                }
                rnd2 = v2;
            }
            return from + rnd2;
        }
        do {
            if (from <= (rnd = this.nextLong())) {
                if (rnd < until) {
                    bl = true;
                    continue;
                }
                bl = false;
                continue;
            }
            bl = false;
        } while (!bl);
        return rnd;
    }

    public boolean nextBoolean() {
        return this.nextBits(1) != 0;
    }

    public double nextDouble() {
        return PlatformRandomKt.doubleFromParts(this.nextBits(26), this.nextBits(27));
    }

    /*
     * WARNING - void declaration
     */
    public double nextDouble(double until) {
        void var1_1;
        return this.nextDouble(0.0, (double)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public double nextDouble(double from, double until) {
        void r2;
        double d2;
        double d3;
        RandomKt.checkRangeBounds(from, until);
        double size = until - from;
        if (Double.isInfinite(size) && !Double.isInfinite(d3 = from) && !Double.isNaN(d3) && !Double.isInfinite(d3 = until) && !Double.isNaN(d3)) {
            double r1 = this.nextDouble() * (until / 2.0 - from / 2.0);
            d2 = from + r1 + r1;
        } else {
            void var1_1;
            d2 = r2 = var1_1 + this.nextDouble() * size;
        }
        if (d2 >= until) {
            void var3_2;
            return Math.nextAfter((double)var3_2, Double.NEGATIVE_INFINITY);
        }
        return (double)r2;
    }

    public float nextFloat() {
        return (float)this.nextBits(24) / 1.6777216E7f;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public byte[] nextBytes(@NotNull byte[] array, int fromIndex22, int toIndex) {
        void var1_1;
        void position;
        int fromIndex22;
        Intrinsics.checkNotNullParameter(array, "");
        boolean bl = new IntRange(0, array.length).contains(fromIndex22) && new IntRange(0, array.length).contains(toIndex);
        if (!bl) {
            String fromIndex22 = "fromIndex (" + fromIndex22 + ") or toIndex (" + toIndex + ") are out of range: 0.." + array.length + '.';
            throw new IllegalArgumentException(fromIndex22.toString());
        }
        bl = fromIndex22 <= toIndex;
        if (!bl) {
            String fromIndex22 = "fromIndex (" + fromIndex22 + ") must be not greater than toIndex (" + toIndex + ").";
            throw new IllegalArgumentException(fromIndex22.toString());
        }
        int steps = (toIndex - fromIndex22) / 4;
        for (int i2 = 0; i2 < steps; ++i2) {
            int v2 = this.nextInt();
            array[position] = (byte)v2;
            array[position + true] = (byte)(v2 >>> 8);
            array[position + 2] = (byte)(v2 >>> 16);
            array[position + 3] = (byte)(v2 >>> 24);
            position += 4;
        }
        int remainder = toIndex - position;
        int vr = this.nextBits(remainder << 3);
        for (int i3 = 0; i3 < remainder; ++i3) {
            array[position + i3] = (byte)(vr >>> (i3 << 3));
        }
        return var1_1;
    }

    public static /* synthetic */ byte[] nextBytes$default(Random random, byte[] byArray, int n2, int n3, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: nextBytes");
        }
        if ((n4 & 2) != 0) {
            n2 = 0;
        }
        if ((n4 & 4) != 0) {
            n3 = byArray.length;
        }
        return random.nextBytes(byArray, n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public byte[] nextBytes(@NotNull byte[] array) {
        void var1_1;
        Intrinsics.checkNotNullParameter(array, "");
        return this.nextBytes(array, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public byte[] nextBytes(int size) {
        void var1_1;
        return this.nextBytes(new byte[var1_1]);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u00012\u00060\u0002j\u0002`\u0003:\u0001\u001cB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0007H\u0016J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J\u0018\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0019H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lkotlin/random/Random$Default;", "Lkotlin/random/Random;", "Ljava/io/Serializable;", "Lkotlin/io/Serializable;", "()V", "defaultRandom", "nextBits", "", "bitCount", "nextBoolean", "", "nextBytes", "", "array", "fromIndex", "toIndex", "size", "nextDouble", "", "until", "from", "nextFloat", "", "nextInt", "nextLong", "", "writeReplace", "", "Serialized", "kotlin-stdlib"})
    public static final class Default
    extends Random
    implements Serializable {
        private Default() {
        }

        private final Object writeReplace() {
            return Serialized.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int nextBits(int bitCount) {
            void var1_1;
            return defaultRandom.nextBits((int)var1_1);
        }

        @Override
        public final int nextInt() {
            return defaultRandom.nextInt();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int nextInt(int until) {
            void var1_1;
            return defaultRandom.nextInt((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int nextInt(int from, int until) {
            void var2_2;
            void var1_1;
            return defaultRandom.nextInt((int)var1_1, (int)var2_2);
        }

        @Override
        public final long nextLong() {
            return defaultRandom.nextLong();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final long nextLong(long until) {
            void var1_1;
            return defaultRandom.nextLong((long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final long nextLong(long from, long until) {
            void var3_2;
            void var1_1;
            return defaultRandom.nextLong((long)var1_1, (long)var3_2);
        }

        @Override
        public final boolean nextBoolean() {
            return defaultRandom.nextBoolean();
        }

        @Override
        public final double nextDouble() {
            return defaultRandom.nextDouble();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final double nextDouble(double until) {
            void var1_1;
            return defaultRandom.nextDouble((double)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final double nextDouble(double from, double until) {
            void var3_2;
            void var1_1;
            return defaultRandom.nextDouble((double)var1_1, (double)var3_2);
        }

        @Override
        public final float nextFloat() {
            return defaultRandom.nextFloat();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public final byte[] nextBytes(@NotNull byte[] array) {
            void var1_1;
            Intrinsics.checkNotNullParameter(array, "");
            return defaultRandom.nextBytes((byte[])var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public final byte[] nextBytes(int size) {
            void var1_1;
            return defaultRandom.nextBytes((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public final byte[] nextBytes(@NotNull byte[] array, int fromIndex, int toIndex) {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter(array, "");
            return defaultRandom.nextBytes((byte[])var1_1, (int)var2_2, (int)var3_3);
        }

        public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u00c2\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lkotlin/random/Random$Default$Serialized;", "Ljava/io/Serializable;", "Lkotlin/io/Serializable;", "()V", "serialVersionUID", "", "readResolve", "", "kotlin-stdlib"})
        private static final class Serialized
        implements Serializable {
            @NotNull
            public static final Serialized INSTANCE = new Serialized();
            private static final long serialVersionUID = 0L;

            private Serialized() {
            }

            private final Object readResolve() {
                return Default;
            }
        }
    }
}

