/*
 * Decompiled with CFR 0.152.
 */
package kotlin.jvm.internal;

import kotlin.SinceKotlin;
import kotlin.jvm.internal.CallableReference;
import kotlin.jvm.internal.FunctionBase;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KCallable;
import kotlin.reflect.KFunction;

public class FunctionReference
extends CallableReference
implements FunctionBase,
KFunction {
    private final int arity;
    @SinceKotlin(version="1.4")
    private final int flags;

    /*
     * WARNING - void declaration
     */
    public FunctionReference(int arity) {
        this((int)var1_1, NO_RECEIVER, null, null, null, 0);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.1")
    public FunctionReference(int arity, Object receiver) {
        this((int)var1_1, var2_2, null, null, null, 0);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.4")
    public FunctionReference(int arity, Object receiver, Class owner, String name, String signature, int flags) {
        super(var2_2, (Class)var3_3, name, signature, (flags & 1) == 1);
        void var1_1;
        void var3_3;
        void var2_2;
        this.arity = var1_1;
        this.flags = flags >> 1;
    }

    @Override
    public int getArity() {
        return this.arity;
    }

    @Override
    @SinceKotlin(version="1.1")
    protected KFunction getReflected() {
        return (KFunction)super.getReflected();
    }

    @Override
    @SinceKotlin(version="1.1")
    protected KCallable computeReflected() {
        return Reflection.function(this);
    }

    @Override
    @SinceKotlin(version="1.1")
    public boolean isInline() {
        return this.getReflected().isInline();
    }

    @Override
    @SinceKotlin(version="1.1")
    public boolean isExternal() {
        return this.getReflected().isExternal();
    }

    @Override
    @SinceKotlin(version="1.1")
    public boolean isOperator() {
        return this.getReflected().isOperator();
    }

    @Override
    @SinceKotlin(version="1.1")
    public boolean isInfix() {
        return this.getReflected().isInfix();
    }

    @Override
    @SinceKotlin(version="1.1")
    public boolean isSuspend() {
        return this.getReflected().isSuspend();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        void var1_1;
        if (obj == this) {
            return true;
        }
        if (obj instanceof FunctionReference) {
            FunctionReference other = (FunctionReference)obj;
            return this.getName().equals(other.getName()) && this.getSignature().equals(other.getSignature()) && this.flags == other.flags && this.arity == other.arity && Intrinsics.areEqual(this.getBoundReceiver(), other.getBoundReceiver()) && Intrinsics.areEqual(this.getOwner(), var1_1.getOwner());
        }
        if (var1_1 instanceof KFunction) {
            return var1_1.equals(this.compute());
        }
        return false;
    }

    public int hashCode() {
        return ((this.getOwner() == null ? 0 : this.getOwner().hashCode() * 31) + this.getName().hashCode()) * 31 + this.getSignature().hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        KCallable reflected = this.compute();
        if (reflected != this) {
            void var1_1;
            return var1_1.toString();
        }
        if ("<init>".equals(this.getName())) {
            return "constructor (Kotlin reflection is not available)";
        }
        return "function " + this.getName() + " (Kotlin reflection is not available)";
    }
}

