/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io.path;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.ReplaceWith;
import kotlin.SinceKotlin;
import kotlin.Unit;
import kotlin.WasExperimental;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.internal.InlineOnly;
import kotlin.internal.PlatformImplementationsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.ExperimentalPathApi;
import kotlin.io.path.FileVisitorBuilder;
import kotlin.io.path.FileVisitorBuilderImpl;
import kotlin.io.path.PathRelativizer;
import kotlin.io.path.PathTreeWalk;
import kotlin.io.path.PathWalkOption;
import kotlin.io.path.PathsKt;
import kotlin.io.path.PathsKt__PathRecursiveFunctionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=5, xi=49, d1={"\u0000\u00cc\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0011\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0001H\u0087\b\u001a*\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00012\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u001a\"\u00020\u0001H\u0087\b\u00a2\u0006\u0002\u0010\u001b\u001a?\u0010\u001c\u001a\u00020\u00022\b\u0010\u001d\u001a\u0004\u0018\u00010\u00022\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u00012\u001a\u0010\u001f\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030 0\u001a\"\u0006\u0012\u0002\b\u00030 H\u0007\u00a2\u0006\u0002\u0010!\u001a6\u0010\u001c\u001a\u00020\u00022\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u00012\u001a\u0010\u001f\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030 0\u001a\"\u0006\u0012\u0002\b\u00030 H\u0087\b\u00a2\u0006\u0002\u0010\"\u001aK\u0010#\u001a\u00020\u00022\b\u0010\u001d\u001a\u0004\u0018\u00010\u00022\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\u00012\u001a\u0010\u001f\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030 0\u001a\"\u0006\u0012\u0002\b\u00030 H\u0007\u00a2\u0006\u0002\u0010%\u001aB\u0010#\u001a\u00020\u00022\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\u00012\u001a\u0010\u001f\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030 0\u001a\"\u0006\u0012\u0002\b\u00030 H\u0087\b\u00a2\u0006\u0002\u0010&\u001a\u001c\u0010'\u001a\u00020(2\u0006\u0010\u0017\u001a\u00020\u00022\n\u0010)\u001a\u0006\u0012\u0002\b\u00030*H\u0001\u001a4\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00020,2\u0017\u0010-\u001a\u0013\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u0002000.\u00a2\u0006\u0002\b1H\u0007\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0001\u001a\r\u00102\u001a\u00020\u0002*\u00020\u0002H\u0087\b\u001a\r\u00103\u001a\u00020\u0001*\u00020\u0002H\u0087\b\u001a.\u00104\u001a\u00020\u0002*\u00020\u00022\u0006\u00105\u001a\u00020\u00022\u0012\u00106\u001a\n\u0012\u0006\b\u0001\u0012\u0002070\u001a\"\u000207H\u0087\b\u00a2\u0006\u0002\u00108\u001a\u001f\u00104\u001a\u00020\u0002*\u00020\u00022\u0006\u00105\u001a\u00020\u00022\b\b\u0002\u00109\u001a\u00020:H\u0087\b\u001a.\u0010;\u001a\u00020\u0002*\u00020\u00022\u001a\u0010\u001f\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030 0\u001a\"\u0006\u0012\u0002\b\u00030 H\u0087\b\u00a2\u0006\u0002\u0010<\u001a.\u0010=\u001a\u00020\u0002*\u00020\u00022\u001a\u0010\u001f\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030 0\u001a\"\u0006\u0012\u0002\b\u00030 H\u0087\b\u00a2\u0006\u0002\u0010<\u001a.\u0010>\u001a\u00020\u0002*\u00020\u00022\u001a\u0010\u001f\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030 0\u001a\"\u0006\u0012\u0002\b\u00030 H\u0087\b\u00a2\u0006\u0002\u0010<\u001a\u0015\u0010?\u001a\u00020\u0002*\u00020\u00022\u0006\u00105\u001a\u00020\u0002H\u0087\b\u001a-\u0010@\u001a\u00020\u0002*\u00020\u00022\u001a\u0010\u001f\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030 0\u001a\"\u0006\u0012\u0002\b\u00030 H\u0007\u00a2\u0006\u0002\u0010<\u001a6\u0010A\u001a\u00020\u0002*\u00020\u00022\u0006\u00105\u001a\u00020\u00022\u001a\u0010\u001f\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030 0\u001a\"\u0006\u0012\u0002\b\u00030 H\u0087\b\u00a2\u0006\u0002\u0010B\u001a\r\u0010C\u001a\u000200*\u00020\u0002H\u0087\b\u001a\r\u0010D\u001a\u00020:*\u00020\u0002H\u0087\b\u001a\u0015\u0010E\u001a\u00020\u0002*\u00020\u00022\u0006\u0010F\u001a\u00020\u0002H\u0087\n\u001a\u0015\u0010E\u001a\u00020\u0002*\u00020\u00022\u0006\u0010F\u001a\u00020\u0001H\u0087\n\u001a&\u0010G\u001a\u00020:*\u00020\u00022\u0012\u00106\u001a\n\u0012\u0006\b\u0001\u0012\u00020H0\u001a\"\u00020HH\u0087\b\u00a2\u0006\u0002\u0010I\u001a2\u0010J\u001a\u0002HK\"\n\b\u0000\u0010K\u0018\u0001*\u00020L*\u00020\u00022\u0012\u00106\u001a\n\u0012\u0006\b\u0001\u0012\u00020H0\u001a\"\u00020HH\u0087\b\u00a2\u0006\u0002\u0010M\u001a4\u0010N\u001a\u0004\u0018\u0001HK\"\n\b\u0000\u0010K\u0018\u0001*\u00020L*\u00020\u00022\u0012\u00106\u001a\n\u0012\u0006\b\u0001\u0012\u00020H0\u001a\"\u00020HH\u0087\b\u00a2\u0006\u0002\u0010M\u001a\r\u0010O\u001a\u00020P*\u00020\u0002H\u0087\b\u001a\r\u0010Q\u001a\u00020R*\u00020\u0002H\u0087\b\u001a.\u0010S\u001a\u000200*\u00020\u00022\b\b\u0002\u0010T\u001a\u00020\u00012\u0012\u0010U\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002000.H\u0087\b\u00f8\u0001\u0000\u001a0\u0010V\u001a\u0004\u0018\u00010W*\u00020\u00022\u0006\u0010X\u001a\u00020\u00012\u0012\u00106\u001a\n\u0012\u0006\b\u0001\u0012\u00020H0\u001a\"\u00020HH\u0087\b\u00a2\u0006\u0002\u0010Y\u001a&\u0010Z\u001a\u00020[*\u00020\u00022\u0012\u00106\u001a\n\u0012\u0006\b\u0001\u0012\u00020H0\u001a\"\u00020HH\u0087\b\u00a2\u0006\u0002\u0010\\\u001a(\u0010]\u001a\u0004\u0018\u00010^*\u00020\u00022\u0012\u00106\u001a\n\u0012\u0006\b\u0001\u0012\u00020H0\u001a\"\u00020HH\u0087\b\u00a2\u0006\u0002\u0010_\u001a,\u0010`\u001a\b\u0012\u0004\u0012\u00020b0a*\u00020\u00022\u0012\u00106\u001a\n\u0012\u0006\b\u0001\u0012\u00020H0\u001a\"\u00020HH\u0087\b\u00a2\u0006\u0002\u0010c\u001a&\u0010d\u001a\u00020:*\u00020\u00022\u0012\u00106\u001a\n\u0012\u0006\b\u0001\u0012\u00020H0\u001a\"\u00020HH\u0087\b\u00a2\u0006\u0002\u0010I\u001a\r\u0010e\u001a\u00020:*\u00020\u0002H\u0087\b\u001a\r\u0010f\u001a\u00020:*\u00020\u0002H\u0087\b\u001a\r\u0010g\u001a\u00020:*\u00020\u0002H\u0087\b\u001a&\u0010h\u001a\u00020:*\u00020\u00022\u0012\u00106\u001a\n\u0012\u0006\b\u0001\u0012\u00020H0\u001a\"\u00020HH\u0087\b\u00a2\u0006\u0002\u0010I\u001a\u0015\u0010i\u001a\u00020:*\u00020\u00022\u0006\u0010F\u001a\u00020\u0002H\u0087\b\u001a\r\u0010j\u001a\u00020:*\u00020\u0002H\u0087\b\u001a\r\u0010k\u001a\u00020:*\u00020\u0002H\u0087\b\u001a\u001c\u0010l\u001a\b\u0012\u0004\u0012\u00020\u00020m*\u00020\u00022\b\b\u0002\u0010T\u001a\u00020\u0001H\u0007\u001a.\u0010n\u001a\u00020\u0002*\u00020\u00022\u0006\u00105\u001a\u00020\u00022\u0012\u00106\u001a\n\u0012\u0006\b\u0001\u0012\u0002070\u001a\"\u000207H\u0087\b\u00a2\u0006\u0002\u00108\u001a\u001f\u0010n\u001a\u00020\u0002*\u00020\u00022\u0006\u00105\u001a\u00020\u00022\b\b\u0002\u00109\u001a\u00020:H\u0087\b\u001a&\u0010o\u001a\u00020:*\u00020\u00022\u0012\u00106\u001a\n\u0012\u0006\b\u0001\u0012\u00020H0\u001a\"\u00020HH\u0087\b\u00a2\u0006\u0002\u0010I\u001a2\u0010p\u001a\u0002Hq\"\n\b\u0000\u0010q\u0018\u0001*\u00020r*\u00020\u00022\u0012\u00106\u001a\n\u0012\u0006\b\u0001\u0012\u00020H0\u001a\"\u00020HH\u0087\b\u00a2\u0006\u0002\u0010s\u001a<\u0010p\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u00010W0t*\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u00012\u0012\u00106\u001a\n\u0012\u0006\b\u0001\u0012\u00020H0\u001a\"\u00020HH\u0087\b\u00a2\u0006\u0002\u0010u\u001a\r\u0010v\u001a\u00020\u0002*\u00020\u0002H\u0087\b\u001a\u0014\u0010w\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0002H\u0007\u001a\u0016\u0010x\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0002H\u0007\u001a\u0014\u0010y\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0002H\u0007\u001a8\u0010z\u001a\u00020\u0002*\u00020\u00022\u0006\u0010X\u001a\u00020\u00012\b\u0010{\u001a\u0004\u0018\u00010W2\u0012\u00106\u001a\n\u0012\u0006\b\u0001\u0012\u00020H0\u001a\"\u00020HH\u0087\b\u00a2\u0006\u0002\u0010|\u001a\u0015\u0010}\u001a\u00020\u0002*\u00020\u00022\u0006\u0010{\u001a\u00020[H\u0087\b\u001a\u0015\u0010~\u001a\u00020\u0002*\u00020\u00022\u0006\u0010{\u001a\u00020^H\u0087\b\u001a\u001b\u0010\u007f\u001a\u00020\u0002*\u00020\u00022\f\u0010{\u001a\b\u0012\u0004\u0012\u00020b0aH\u0087\b\u001a\u000f\u0010\u0080\u0001\u001a\u00020\u0002*\u00030\u0081\u0001H\u0087\b\u001aF\u0010\u0082\u0001\u001a\u0003H\u0083\u0001\"\u0005\b\u0000\u0010\u0083\u0001*\u00020\u00022\b\b\u0002\u0010T\u001a\u00020\u00012\u001b\u0010\u0084\u0001\u001a\u0016\u0012\u000b\u0012\t\u0012\u0004\u0012\u00020\u00020\u0085\u0001\u0012\u0005\u0012\u0003H\u0083\u00010.H\u0087\b\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u0086\u0001\u001a3\u0010\u0087\u0001\u001a\u000200*\u00020\u00022\r\u0010\u0088\u0001\u001a\b\u0012\u0004\u0012\u00020\u00020,2\n\b\u0002\u0010\u0089\u0001\u001a\u00030\u008a\u00012\t\b\u0002\u0010\u008b\u0001\u001a\u00020:H\u0007\u001aJ\u0010\u0087\u0001\u001a\u000200*\u00020\u00022\n\b\u0002\u0010\u0089\u0001\u001a\u00030\u008a\u00012\t\b\u0002\u0010\u008b\u0001\u001a\u00020:2\u0017\u0010-\u001a\u0013\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u0002000.\u00a2\u0006\u0002\b1H\u0007\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0003 \u0001\u001a0\u0010\u008c\u0001\u001a\t\u0012\u0004\u0012\u00020\u00020\u0085\u0001*\u00020\u00022\u0014\u00106\u001a\u000b\u0012\u0007\b\u0001\u0012\u00030\u008d\u00010\u001a\"\u00030\u008d\u0001H\u0007\u00a2\u0006\u0003\u0010\u008e\u0001\"\u001e\u0010\u0000\u001a\u00020\u0001*\u00020\u00028FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006\"\u001f\u0010\u0007\u001a\u00020\u0001*\u00020\u00028\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\b\u0010\u0004\u001a\u0004\b\t\u0010\u0006\"\u001e\u0010\n\u001a\u00020\u0001*\u00020\u00028FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000b\u0010\u0004\u001a\u0004\b\f\u0010\u0006\"\u001e\u0010\r\u001a\u00020\u0001*\u00020\u00028FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000e\u0010\u0004\u001a\u0004\b\u000f\u0010\u0006\"\u001e\u0010\u0010\u001a\u00020\u0001*\u00020\u00028FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0011\u0010\u0004\u001a\u0004\b\u0012\u0010\u0006\"\u001f\u0010\u0013\u001a\u00020\u0001*\u00020\u00028\u00c6\u0002X\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0014\u0010\u0004\u001a\u0004\b\u0015\u0010\u0006\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u008f\u0001"}, d2={"extension", "", "Ljava/nio/file/Path;", "getExtension$annotations", "(Ljava/nio/file/Path;)V", "getExtension", "(Ljava/nio/file/Path;)Ljava/lang/String;", "invariantSeparatorsPath", "getInvariantSeparatorsPath$annotations", "getInvariantSeparatorsPath", "invariantSeparatorsPathString", "getInvariantSeparatorsPathString$annotations", "getInvariantSeparatorsPathString", "name", "getName$annotations", "getName", "nameWithoutExtension", "getNameWithoutExtension$annotations", "getNameWithoutExtension", "pathString", "getPathString$annotations", "getPathString", "Path", "path", "base", "subpaths", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/nio/file/Path;", "createTempDirectory", "directory", "prefix", "attributes", "Ljava/nio/file/attribute/FileAttribute;", "(Ljava/nio/file/Path;Ljava/lang/String;[Ljava/nio/file/attribute/FileAttribute;)Ljava/nio/file/Path;", "(Ljava/lang/String;[Ljava/nio/file/attribute/FileAttribute;)Ljava/nio/file/Path;", "createTempFile", "suffix", "(Ljava/nio/file/Path;Ljava/lang/String;Ljava/lang/String;[Ljava/nio/file/attribute/FileAttribute;)Ljava/nio/file/Path;", "(Ljava/lang/String;Ljava/lang/String;[Ljava/nio/file/attribute/FileAttribute;)Ljava/nio/file/Path;", "fileAttributeViewNotAvailable", "", "attributeViewClass", "Ljava/lang/Class;", "fileVisitor", "Ljava/nio/file/FileVisitor;", "builderAction", "Lkotlin/Function1;", "Lkotlin/io/path/FileVisitorBuilder;", "", "Lkotlin/ExtensionFunctionType;", "absolute", "absolutePathString", "copyTo", "target", "options", "Ljava/nio/file/CopyOption;", "(Ljava/nio/file/Path;Ljava/nio/file/Path;[Ljava/nio/file/CopyOption;)Ljava/nio/file/Path;", "overwrite", "", "createDirectories", "(Ljava/nio/file/Path;[Ljava/nio/file/attribute/FileAttribute;)Ljava/nio/file/Path;", "createDirectory", "createFile", "createLinkPointingTo", "createParentDirectories", "createSymbolicLinkPointingTo", "(Ljava/nio/file/Path;Ljava/nio/file/Path;[Ljava/nio/file/attribute/FileAttribute;)Ljava/nio/file/Path;", "deleteExisting", "deleteIfExists", "div", "other", "exists", "Ljava/nio/file/LinkOption;", "(Ljava/nio/file/Path;[Ljava/nio/file/LinkOption;)Z", "fileAttributesView", "V", "Ljava/nio/file/attribute/FileAttributeView;", "(Ljava/nio/file/Path;[Ljava/nio/file/LinkOption;)Ljava/nio/file/attribute/FileAttributeView;", "fileAttributesViewOrNull", "fileSize", "", "fileStore", "Ljava/nio/file/FileStore;", "forEachDirectoryEntry", "glob", "action", "getAttribute", "", "attribute", "(Ljava/nio/file/Path;Ljava/lang/String;[Ljava/nio/file/LinkOption;)Ljava/lang/Object;", "getLastModifiedTime", "Ljava/nio/file/attribute/FileTime;", "(Ljava/nio/file/Path;[Ljava/nio/file/LinkOption;)Ljava/nio/file/attribute/FileTime;", "getOwner", "Ljava/nio/file/attribute/UserPrincipal;", "(Ljava/nio/file/Path;[Ljava/nio/file/LinkOption;)Ljava/nio/file/attribute/UserPrincipal;", "getPosixFilePermissions", "", "Ljava/nio/file/attribute/PosixFilePermission;", "(Ljava/nio/file/Path;[Ljava/nio/file/LinkOption;)Ljava/util/Set;", "isDirectory", "isExecutable", "isHidden", "isReadable", "isRegularFile", "isSameFileAs", "isSymbolicLink", "isWritable", "listDirectoryEntries", "", "moveTo", "notExists", "readAttributes", "A", "Ljava/nio/file/attribute/BasicFileAttributes;", "(Ljava/nio/file/Path;[Ljava/nio/file/LinkOption;)Ljava/nio/file/attribute/BasicFileAttributes;", "", "(Ljava/nio/file/Path;Ljava/lang/String;[Ljava/nio/file/LinkOption;)Ljava/util/Map;", "readSymbolicLink", "relativeTo", "relativeToOrNull", "relativeToOrSelf", "setAttribute", "value", "(Ljava/nio/file/Path;Ljava/lang/String;Ljava/lang/Object;[Ljava/nio/file/LinkOption;)Ljava/nio/file/Path;", "setLastModifiedTime", "setOwner", "setPosixFilePermissions", "toPath", "Ljava/net/URI;", "useDirectoryEntries", "T", "block", "Lkotlin/sequences/Sequence;", "(Ljava/nio/file/Path;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "visitFileTree", "visitor", "maxDepth", "", "followLinks", "walk", "Lkotlin/io/path/PathWalkOption;", "(Ljava/nio/file/Path;[Lkotlin/io/path/PathWalkOption;)Lkotlin/sequences/Sequence;", "kotlin-stdlib-jdk7"}, xs="kotlin/io/path/PathsKt")
@SourceDebugExtension(value={"SMAP\nPathUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathUtils.kt\nkotlin/io/path/PathsKt__PathUtilsKt\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1174:1\n26#2:1175\n26#2:1179\n1#3:1176\n1855#4,2:1177\n*S KotlinDebug\n*F\n+ 1 PathUtils.kt\nkotlin/io/path/PathsKt__PathUtilsKt\n*L\n221#1:1175\n616#1:1179\n440#1:1177,2\n*E\n"})
class PathsKt__PathUtilsKt
extends PathsKt__PathRecursiveFunctionsKt {
    @NotNull
    public static final String getName(@NotNull Path $this$name) {
        Path path;
        Intrinsics.checkNotNullParameter($this$name, "");
        Path path2 = path.getFileName();
        String string = path2 != null ? ((Object)path2).toString() : null;
        if (string == null) {
            string = "";
        }
        return string;
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    public static /* synthetic */ void getName$annotations(Path path) {
    }

    @NotNull
    public static final String getNameWithoutExtension(@NotNull Path $this$nameWithoutExtension) {
        Path path;
        Intrinsics.checkNotNullParameter($this$nameWithoutExtension, "");
        Object object = path.getFileName();
        if (object == null || (object = object.toString()) == null || (object = StringsKt.substringBeforeLast$default((String)object, ".", null, 2, null)) == null) {
            object = "";
        }
        return object;
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    public static /* synthetic */ void getNameWithoutExtension$annotations(Path path) {
    }

    @NotNull
    public static final String getExtension(@NotNull Path $this$extension) {
        Path path;
        Intrinsics.checkNotNullParameter($this$extension, "");
        Object object = path.getFileName();
        if (object == null || (object = object.toString()) == null || (object = StringsKt.substringAfterLast((String)object, '.', "")) == null) {
            object = "";
        }
        return object;
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    public static /* synthetic */ void getExtension$annotations(Path path) {
    }

    private static final String getPathString(Path $this$pathString) {
        Path path;
        Intrinsics.checkNotNullParameter($this$pathString, "");
        return ((Object)path).toString();
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    public static /* synthetic */ void getPathString$annotations(Path path) {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String getInvariantSeparatorsPathString(@NotNull Path $this$invariantSeparatorsPathString) {
        Path path;
        Intrinsics.checkNotNullParameter($this$invariantSeparatorsPathString, "");
        String separator = $this$invariantSeparatorsPathString.getFileSystem().getSeparator();
        if (!Intrinsics.areEqual(separator, "/")) {
            void var1_1;
            String string = ((Object)$this$invariantSeparatorsPathString).toString();
            Intrinsics.checkNotNull(separator);
            return StringsKt.replace$default(string, (String)var1_1, "/", false, 4, null);
        }
        return ((Object)path).toString();
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    public static /* synthetic */ void getInvariantSeparatorsPathString$annotations(Path path) {
    }

    private static final String getInvariantSeparatorsPath(Path $this$invariantSeparatorsPath) {
        Path path;
        Intrinsics.checkNotNullParameter($this$invariantSeparatorsPath, "");
        return PathsKt.getInvariantSeparatorsPathString(path);
    }

    @Deprecated(message="Use invariantSeparatorsPathString property instead.", replaceWith=@ReplaceWith(expression="invariantSeparatorsPathString", imports={}), level=DeprecationLevel.ERROR)
    @SinceKotlin(version="1.4")
    @ExperimentalPathApi
    @InlineOnly
    public static /* synthetic */ void getInvariantSeparatorsPath$annotations(Path path) {
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Path absolute(Path $this$absolute) {
        Path path;
        Intrinsics.checkNotNullParameter($this$absolute, "");
        Path path2 = path.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue(path2, "");
        return path2;
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final String absolutePathString(Path $this$absolutePathString) {
        Path path;
        Intrinsics.checkNotNullParameter($this$absolutePathString, "");
        return ((Object)path.toAbsolutePath()).toString();
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @NotNull
    public static final Path relativeTo(@NotNull Path $this$relativeTo, @NotNull Path base) {
        Path path;
        Intrinsics.checkNotNullParameter($this$relativeTo, "");
        Intrinsics.checkNotNullParameter(base, "");
        try {
            path = PathRelativizer.INSTANCE.tryRelativeTo($this$relativeTo, base);
        }
        catch (IllegalArgumentException e2) {
            void var2_3;
            void var1_1;
            Path path2;
            throw new IllegalArgumentException(e2.getMessage() + "\nthis path: " + path2 + "\nbase path: " + var1_1, (Throwable)var2_3);
        }
        return path;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @NotNull
    public static final Path relativeToOrSelf(@NotNull Path $this$relativeToOrSelf, @NotNull Path base) {
        void var1_1;
        Intrinsics.checkNotNullParameter($this$relativeToOrSelf, "");
        Intrinsics.checkNotNullParameter(base, "");
        Path path = PathsKt.relativeToOrNull($this$relativeToOrSelf, (Path)var1_1);
        if (path == null) {
            Path path2;
            path = path2;
        }
        return path;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @Nullable
    public static final Path relativeToOrNull(@NotNull Path $this$relativeToOrNull, @NotNull Path base) {
        Path path;
        Intrinsics.checkNotNullParameter($this$relativeToOrNull, "");
        Intrinsics.checkNotNullParameter(base, "");
        try {
            void var1_1;
            path = PathRelativizer.INSTANCE.tryRelativeTo(path, (Path)var1_1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            path = null;
        }
        return path;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Path copyTo(Path $this$copyTo, Path target, boolean overwrite2) throws IOException {
        void var1_1;
        Path path;
        void var2_3;
        CopyOption[] copyOptionArray;
        Intrinsics.checkNotNullParameter($this$copyTo, "");
        Intrinsics.checkNotNullParameter(target, "");
        if (overwrite2) {
            CopyOption[] copyOptionArray2 = new CopyOption[1];
            CopyOption[] overwrite2 = copyOptionArray2;
            copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
            copyOptionArray = overwrite2;
        } else {
            copyOptionArray = new CopyOption[]{};
        }
        CopyOption[] options = copyOptionArray;
        void v2 = var2_3;
        Path path2 = Files.copy(path, (Path)var1_1, (CopyOption[])Arrays.copyOf(v2, ((void)v2).length));
        Intrinsics.checkNotNullExpressionValue(path2, "");
        return path2;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Path copyTo$default(Path $this$copyTo_u24default, Path target, boolean overwrite, int n2, Object copyOptionArray) throws IOException {
        void var1_1;
        Path path;
        void var3_4;
        CopyOption[] copyOptionArray2;
        void var2_2;
        if ((n2 & 2) != 0) {
            overwrite = false;
        }
        Intrinsics.checkNotNullParameter($this$copyTo_u24default, "");
        Intrinsics.checkNotNullParameter(target, "");
        if (var2_2 != false) {
            CopyOption[] copyOptionArray3 = new CopyOption[1];
            copyOptionArray = copyOptionArray3;
            copyOptionArray3[0] = StandardCopyOption.REPLACE_EXISTING;
            copyOptionArray2 = copyOptionArray;
        } else {
            copyOptionArray2 = new CopyOption[]{};
        }
        CopyOption[] options = copyOptionArray2;
        void v2 = var3_4;
        Path path2 = Files.copy(path, (Path)var1_1, (CopyOption[])Arrays.copyOf(v2, ((void)v2).length));
        Intrinsics.checkNotNullExpressionValue(path2, "");
        return path2;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Path copyTo(Path $this$copyTo, Path target, CopyOption ... options) throws IOException {
        void var1_1;
        Path path;
        void var2_2;
        Intrinsics.checkNotNullParameter($this$copyTo, "");
        Intrinsics.checkNotNullParameter(target, "");
        Intrinsics.checkNotNullParameter(options, "");
        void v0 = var2_2;
        Path path2 = Files.copy(path, (Path)var1_1, (CopyOption[])Arrays.copyOf(v0, ((void)v0).length));
        Intrinsics.checkNotNullExpressionValue(path2, "");
        return path2;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final boolean exists(Path $this$exists, LinkOption ... options) {
        Path path;
        void var1_1;
        Intrinsics.checkNotNullParameter($this$exists, "");
        Intrinsics.checkNotNullParameter(options, "");
        void v0 = var1_1;
        return Files.exists(path, (LinkOption[])Arrays.copyOf(v0, ((void)v0).length));
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final boolean notExists(Path $this$notExists, LinkOption ... options) {
        Path path;
        void var1_1;
        Intrinsics.checkNotNullParameter($this$notExists, "");
        Intrinsics.checkNotNullParameter(options, "");
        void v0 = var1_1;
        return Files.notExists(path, (LinkOption[])Arrays.copyOf(v0, ((void)v0).length));
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final boolean isRegularFile(Path $this$isRegularFile, LinkOption ... options) {
        Path path;
        void var1_1;
        Intrinsics.checkNotNullParameter($this$isRegularFile, "");
        Intrinsics.checkNotNullParameter(options, "");
        void v0 = var1_1;
        return Files.isRegularFile(path, (LinkOption[])Arrays.copyOf(v0, ((void)v0).length));
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final boolean isDirectory(Path $this$isDirectory, LinkOption ... options) {
        Path path;
        void var1_1;
        Intrinsics.checkNotNullParameter($this$isDirectory, "");
        Intrinsics.checkNotNullParameter(options, "");
        void v0 = var1_1;
        return Files.isDirectory(path, (LinkOption[])Arrays.copyOf(v0, ((void)v0).length));
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final boolean isSymbolicLink(Path $this$isSymbolicLink) {
        Path path;
        Intrinsics.checkNotNullParameter($this$isSymbolicLink, "");
        return Files.isSymbolicLink(path);
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final boolean isExecutable(Path $this$isExecutable) {
        Path path;
        Intrinsics.checkNotNullParameter($this$isExecutable, "");
        return Files.isExecutable(path);
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final boolean isHidden(Path $this$isHidden) throws IOException {
        Path path;
        Intrinsics.checkNotNullParameter($this$isHidden, "");
        return Files.isHidden(path);
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final boolean isReadable(Path $this$isReadable) {
        Path path;
        Intrinsics.checkNotNullParameter($this$isReadable, "");
        return Files.isReadable(path);
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final boolean isWritable(Path $this$isWritable) {
        Path path;
        Intrinsics.checkNotNullParameter($this$isWritable, "");
        return Files.isWritable(path);
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final boolean isSameFileAs(Path $this$isSameFileAs, Path other) throws IOException {
        void var1_1;
        Path path;
        Intrinsics.checkNotNullParameter($this$isSameFileAs, "");
        Intrinsics.checkNotNullParameter(other, "");
        return Files.isSameFile(path, (Path)var1_1);
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @NotNull
    public static final List<Path> listDirectoryEntries(@NotNull Path $this$listDirectoryEntries, @NotNull String glob) throws IOException {
        List<Path> list;
        Throwable throwable;
        Closeable closeable;
        Intrinsics.checkNotNullParameter($this$listDirectoryEntries, "");
        Intrinsics.checkNotNullParameter(glob, "");
        closeable = Files.newDirectoryStream((Path)((Object)closeable), (String)((Object)throwable));
        throwable = null;
        try {
            DirectoryStream it = (DirectoryStream)closeable;
            Intrinsics.checkNotNull(it);
            list = CollectionsKt.toList((Iterable)list);
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                CloseableKt.closeFinally(closeable, throwable);
                throw throwable4;
            }
        }
        CloseableKt.closeFinally(closeable, null);
        return list;
    }

    public static /* synthetic */ List listDirectoryEntries$default(Path path, String string, int n2, Object object) throws IOException {
        if ((n2 & 1) != 0) {
            string = "*";
        }
        return PathsKt.listDirectoryEntries(path, string);
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final <T> T useDirectoryEntries(Path $this$useDirectoryEntries, String glob, Function1<? super Sequence<? extends Path>, ? extends T> block) throws IOException {
        Object r2;
        Throwable throwable;
        Closeable closeable;
        Intrinsics.checkNotNullParameter($this$useDirectoryEntries, "");
        Intrinsics.checkNotNullParameter(glob, "");
        Intrinsics.checkNotNullParameter(block, "");
        closeable = Files.newDirectoryStream((Path)((Object)closeable), (String)((Object)throwable));
        throwable = null;
        try {
            void var2_2;
            DirectoryStream it = (DirectoryStream)closeable;
            Intrinsics.checkNotNull(it);
            r2 = var2_2.invoke(CollectionsKt.asSequence((Iterable)r2));
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                InlineMarker.finallyStart(1);
                if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
                    CloseableKt.closeFinally(closeable, throwable);
                } else if (closeable != null) {
                    if (throwable == null) {
                        closeable.close();
                    } else {
                        try {
                            closeable.close();
                        }
                        catch (Throwable throwable5) {}
                    }
                }
                InlineMarker.finallyEnd(1);
                throw throwable4;
            }
        }
        InlineMarker.finallyStart(1);
        if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
            CloseableKt.closeFinally(closeable, null);
        } else if (closeable != null) {
            closeable.close();
        }
        InlineMarker.finallyEnd(1);
        return (T)r2;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Object useDirectoryEntries$default(Path $this$useDirectoryEntries_u24default, String glob, Function1 block, int n2, Object object) throws IOException {
        DirectoryStream directoryStream;
        void var1_2;
        if ((n2 & 1) != 0) {
            glob = "*";
        }
        Intrinsics.checkNotNullParameter($this$useDirectoryEntries_u24default, "");
        Intrinsics.checkNotNullParameter(glob, "");
        Intrinsics.checkNotNullParameter(block, "");
        Closeable closeable = Files.newDirectoryStream($this$useDirectoryEntries_u24default, (String)var1_2);
        object = null;
        try {
            void var2_3;
            DirectoryStream it = (DirectoryStream)closeable;
            Intrinsics.checkNotNull(it);
            directoryStream = var2_3.invoke(CollectionsKt.asSequence(directoryStream));
        }
        catch (Throwable throwable) {
            try {
                directoryStream = throwable;
                object = throwable;
                throw directoryStream;
            }
            catch (Throwable throwable2) {
                InlineMarker.finallyStart(1);
                if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
                    CloseableKt.closeFinally(closeable, (Throwable)object);
                } else if (closeable != null) {
                    if (object == null) {
                        closeable.close();
                    } else {
                        try {
                            closeable.close();
                        }
                        catch (Throwable throwable3) {}
                    }
                }
                InlineMarker.finallyEnd(1);
                throw throwable2;
            }
        }
        InlineMarker.finallyStart(1);
        if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
            CloseableKt.closeFinally(closeable, null);
        } else if (closeable != null) {
            closeable.close();
        }
        InlineMarker.finallyEnd(1);
        return directoryStream;
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final void forEachDirectoryEntry(Path $this$forEachDirectoryEntry, String glob, Function1<? super Path, Unit> action) throws IOException {
        Throwable throwable;
        Closeable closeable;
        Intrinsics.checkNotNullParameter($this$forEachDirectoryEntry, "");
        Intrinsics.checkNotNullParameter(glob, "");
        Intrinsics.checkNotNullParameter(action, "");
        closeable = Files.newDirectoryStream((Path)((Object)closeable), (String)((Object)throwable));
        throwable = null;
        try {
            Object object;
            DirectoryStream it = (DirectoryStream)closeable;
            Intrinsics.checkNotNull(it);
            object = (Iterable)object;
            object = object.iterator();
            while (object.hasNext()) {
                Object element$iv = object.next();
                action.invoke((Path)element$iv);
            }
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                InlineMarker.finallyStart(1);
                if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
                    CloseableKt.closeFinally(closeable, throwable);
                } else if (closeable != null) {
                    if (throwable == null) {
                        closeable.close();
                    } else {
                        try {
                            closeable.close();
                        }
                        catch (Throwable throwable5) {}
                    }
                }
                InlineMarker.finallyEnd(1);
                throw throwable4;
            }
        }
        InlineMarker.finallyStart(1);
        if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
            CloseableKt.closeFinally(closeable, null);
        } else if (closeable != null) {
            closeable.close();
        }
        InlineMarker.finallyEnd(1);
        return;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void forEachDirectoryEntry$default(Path $this$forEachDirectoryEntry_u24default, String glob, Function1 action, int n2, Object object) throws IOException {
        Iterator iterator2;
        if ((n2 & 1) != 0) {
            glob = "*";
        }
        Intrinsics.checkNotNullParameter($this$forEachDirectoryEntry_u24default, "");
        Intrinsics.checkNotNullParameter(glob, "");
        Intrinsics.checkNotNullParameter(action, "");
        Closeable closeable = Files.newDirectoryStream($this$forEachDirectoryEntry_u24default, glob);
        object = null;
        try {
            Iterator it = (DirectoryStream)closeable;
            Intrinsics.checkNotNull(it);
            iterator2 = (Iterable)((Object)iterator2);
            iterator2 = iterator2.iterator();
            while (iterator2.hasNext()) {
                void var1_2;
                Object element$iv = iterator2.next();
                action.invoke(var1_2);
            }
        }
        catch (Throwable throwable) {
            try {
                iterator2 = throwable;
                object = throwable;
                throw iterator2;
            }
            catch (Throwable throwable2) {
                InlineMarker.finallyStart(1);
                if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
                    CloseableKt.closeFinally(closeable, (Throwable)object);
                } else if (closeable != null) {
                    if (object == null) {
                        closeable.close();
                    } else {
                        try {
                            closeable.close();
                        }
                        catch (Throwable throwable3) {}
                    }
                }
                InlineMarker.finallyEnd(1);
                throw throwable2;
            }
        }
        InlineMarker.finallyStart(1);
        if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
            CloseableKt.closeFinally(closeable, null);
        } else if (closeable != null) {
            closeable.close();
        }
        InlineMarker.finallyEnd(1);
        return;
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final long fileSize(Path $this$fileSize) throws IOException {
        Path path;
        Intrinsics.checkNotNullParameter($this$fileSize, "");
        return Files.size(path);
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final void deleteExisting(Path $this$deleteExisting) throws IOException {
        Path path;
        Intrinsics.checkNotNullParameter($this$deleteExisting, "");
        Files.delete(path);
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final boolean deleteIfExists(Path $this$deleteIfExists) throws IOException {
        Path path;
        Intrinsics.checkNotNullParameter($this$deleteIfExists, "");
        return Files.deleteIfExists(path);
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Path createDirectory(Path $this$createDirectory, FileAttribute<?> ... attributes) throws IOException {
        Path path;
        void var1_1;
        Intrinsics.checkNotNullParameter($this$createDirectory, "");
        Intrinsics.checkNotNullParameter(attributes, "");
        void v0 = var1_1;
        Path path2 = Files.createDirectory(path, (FileAttribute[])Arrays.copyOf(v0, ((void)v0).length));
        Intrinsics.checkNotNullExpressionValue(path2, "");
        return path2;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Path createDirectories(Path $this$createDirectories, FileAttribute<?> ... attributes) throws IOException {
        Path path;
        void var1_1;
        Intrinsics.checkNotNullParameter($this$createDirectories, "");
        Intrinsics.checkNotNullParameter(attributes, "");
        void v0 = var1_1;
        Path path2 = Files.createDirectories(path, (FileAttribute[])Arrays.copyOf(v0, ((void)v0).length));
        Intrinsics.checkNotNullExpressionValue(path2, "");
        return path2;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.9")
    @NotNull
    public static final Path createParentDirectories(@NotNull Path $this$createParentDirectories, FileAttribute<?> ... attributes) throws IOException {
        Path path;
        block4: {
            Intrinsics.checkNotNullParameter($this$createParentDirectories, "");
            Intrinsics.checkNotNullParameter(attributes, "");
            Path path2 = path;
            Path parent = path.getParent();
            if (parent != null) {
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.isDirectory(parent, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    try {
                        FileAttribute<?>[] fileAttributeArray = Arrays.copyOf(attributes, attributes.length);
                        Intrinsics.checkNotNullExpressionValue(Files.createDirectories(parent, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), "");
                    }
                    catch (FileAlreadyExistsException e2) {
                        void var1_2;
                        LinkOption[] linkOptionArray2 = new LinkOption[]{};
                        if (Files.isDirectory(path2, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) break block4;
                        throw var1_2;
                    }
                }
            }
        }
        return path;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Path moveTo(Path $this$moveTo, Path target, CopyOption ... options) throws IOException {
        void var1_1;
        Path path;
        void var2_2;
        Intrinsics.checkNotNullParameter($this$moveTo, "");
        Intrinsics.checkNotNullParameter(target, "");
        Intrinsics.checkNotNullParameter(options, "");
        void v0 = var2_2;
        Path path2 = Files.move(path, (Path)var1_1, (CopyOption[])Arrays.copyOf(v0, ((void)v0).length));
        Intrinsics.checkNotNullExpressionValue(path2, "");
        return path2;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Path moveTo(Path $this$moveTo, Path target, boolean overwrite2) throws IOException {
        void var1_1;
        Path path;
        void var2_3;
        CopyOption[] copyOptionArray;
        Intrinsics.checkNotNullParameter($this$moveTo, "");
        Intrinsics.checkNotNullParameter(target, "");
        if (overwrite2) {
            CopyOption[] copyOptionArray2 = new CopyOption[1];
            CopyOption[] overwrite2 = copyOptionArray2;
            copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
            copyOptionArray = overwrite2;
        } else {
            copyOptionArray = new CopyOption[]{};
        }
        CopyOption[] options = copyOptionArray;
        void v2 = var2_3;
        Path path2 = Files.move(path, (Path)var1_1, (CopyOption[])Arrays.copyOf(v2, ((void)v2).length));
        Intrinsics.checkNotNullExpressionValue(path2, "");
        return path2;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Path moveTo$default(Path $this$moveTo_u24default, Path target, boolean overwrite, int n2, Object copyOptionArray) throws IOException {
        void var1_1;
        Path path;
        void var3_4;
        CopyOption[] copyOptionArray2;
        void var2_2;
        if ((n2 & 2) != 0) {
            overwrite = false;
        }
        Intrinsics.checkNotNullParameter($this$moveTo_u24default, "");
        Intrinsics.checkNotNullParameter(target, "");
        if (var2_2 != false) {
            CopyOption[] copyOptionArray3 = new CopyOption[1];
            copyOptionArray = copyOptionArray3;
            copyOptionArray3[0] = StandardCopyOption.REPLACE_EXISTING;
            copyOptionArray2 = copyOptionArray;
        } else {
            copyOptionArray2 = new CopyOption[]{};
        }
        CopyOption[] options = copyOptionArray2;
        void v2 = var3_4;
        Path path2 = Files.move(path, (Path)var1_1, (CopyOption[])Arrays.copyOf(v2, ((void)v2).length));
        Intrinsics.checkNotNullExpressionValue(path2, "");
        return path2;
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final FileStore fileStore(Path $this$fileStore) throws IOException {
        Path path;
        Intrinsics.checkNotNullParameter($this$fileStore, "");
        FileStore fileStore = Files.getFileStore(path);
        Intrinsics.checkNotNullExpressionValue(fileStore, "");
        return fileStore;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Object getAttribute(Path $this$getAttribute, String attribute, LinkOption ... options) throws IOException {
        void var1_1;
        Path path;
        void var2_2;
        Intrinsics.checkNotNullParameter($this$getAttribute, "");
        Intrinsics.checkNotNullParameter(attribute, "");
        Intrinsics.checkNotNullParameter(options, "");
        void v0 = var2_2;
        return Files.getAttribute(path, (String)var1_1, (LinkOption[])Arrays.copyOf(v0, ((void)v0).length));
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Path setAttribute(Path $this$setAttribute, String attribute, Object value, LinkOption ... options) throws IOException {
        void var2_2;
        void var1_1;
        Path path;
        void var3_3;
        Intrinsics.checkNotNullParameter($this$setAttribute, "");
        Intrinsics.checkNotNullParameter(attribute, "");
        Intrinsics.checkNotNullParameter(options, "");
        void v0 = var3_3;
        Path path2 = Files.setAttribute(path, (String)var1_1, var2_2, (LinkOption[])Arrays.copyOf(v0, ((void)v0).length));
        Intrinsics.checkNotNullExpressionValue(path2, "");
        return path2;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final /* synthetic */ <V extends FileAttributeView> V fileAttributesViewOrNull(Path $this$fileAttributesViewOrNull, LinkOption ... options) {
        Path path;
        void var1_1;
        Intrinsics.checkNotNullParameter($this$fileAttributesViewOrNull, "");
        Intrinsics.checkNotNullParameter(options, "");
        Intrinsics.reifiedOperationMarker(4, "V");
        void v0 = var1_1;
        return (V)Files.getFileAttributeView(path, FileAttributeView.class, (LinkOption[])Arrays.copyOf(v0, ((void)v0).length));
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final /* synthetic */ <V extends FileAttributeView> V fileAttributesView(Path $this$fileAttributesView, LinkOption ... options) {
        void var1_1;
        Intrinsics.checkNotNullParameter($this$fileAttributesView, "");
        Intrinsics.checkNotNullParameter(options, "");
        Intrinsics.reifiedOperationMarker(4, "V");
        void v0 = var1_1;
        FileAttributeView fileAttributeView = Files.getFileAttributeView($this$fileAttributesView, FileAttributeView.class, (LinkOption[])Arrays.copyOf(v0, ((void)v0).length));
        if (fileAttributeView == null) {
            Path path;
            Intrinsics.reifiedOperationMarker(4, "V");
            PathsKt.fileAttributeViewNotAvailable(path, FileAttributeView.class);
            throw new KotlinNothingValueException();
        }
        return (V)fileAttributeView;
    }

    /*
     * WARNING - void declaration
     */
    @PublishedApi
    @NotNull
    public static final Void fileAttributeViewNotAvailable(@NotNull Path path, @NotNull Class<?> attributeViewClass) {
        Path path2;
        void var1_1;
        Intrinsics.checkNotNullParameter(path, "");
        Intrinsics.checkNotNullParameter(attributeViewClass, "");
        throw new UnsupportedOperationException("The desired attribute view type " + var1_1 + " is not available for the file " + path2 + '.');
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final /* synthetic */ <A extends BasicFileAttributes> A readAttributes(Path $this$readAttributes, LinkOption ... options) throws IOException {
        Path path;
        void var1_1;
        Intrinsics.checkNotNullParameter($this$readAttributes, "");
        Intrinsics.checkNotNullParameter(options, "");
        Intrinsics.reifiedOperationMarker(4, "A");
        void v0 = var1_1;
        BasicFileAttributes basicFileAttributes = Files.readAttributes(path, BasicFileAttributes.class, (LinkOption[])Arrays.copyOf(v0, ((void)v0).length));
        Intrinsics.checkNotNullExpressionValue(basicFileAttributes, "");
        return (A)basicFileAttributes;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Map<String, Object> readAttributes(Path $this$readAttributes, String attributes, LinkOption ... options) throws IOException {
        void var1_1;
        Path path;
        void var2_2;
        Intrinsics.checkNotNullParameter($this$readAttributes, "");
        Intrinsics.checkNotNullParameter(attributes, "");
        Intrinsics.checkNotNullParameter(options, "");
        void v0 = var2_2;
        Map<String, Object> map = Files.readAttributes(path, (String)var1_1, (LinkOption[])Arrays.copyOf(v0, ((void)v0).length));
        Intrinsics.checkNotNullExpressionValue(map, "");
        return map;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final FileTime getLastModifiedTime(Path $this$getLastModifiedTime, LinkOption ... options) throws IOException {
        Path path;
        void var1_1;
        Intrinsics.checkNotNullParameter($this$getLastModifiedTime, "");
        Intrinsics.checkNotNullParameter(options, "");
        void v0 = var1_1;
        FileTime fileTime = Files.getLastModifiedTime(path, (LinkOption[])Arrays.copyOf(v0, ((void)v0).length));
        Intrinsics.checkNotNullExpressionValue(fileTime, "");
        return fileTime;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Path setLastModifiedTime(Path $this$setLastModifiedTime, FileTime value) throws IOException {
        void var1_1;
        Path path;
        Intrinsics.checkNotNullParameter($this$setLastModifiedTime, "");
        Intrinsics.checkNotNullParameter(value, "");
        Path path2 = Files.setLastModifiedTime(path, (FileTime)var1_1);
        Intrinsics.checkNotNullExpressionValue(path2, "");
        return path2;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final UserPrincipal getOwner(Path $this$getOwner, LinkOption ... options) throws IOException {
        Path path;
        void var1_1;
        Intrinsics.checkNotNullParameter($this$getOwner, "");
        Intrinsics.checkNotNullParameter(options, "");
        void v0 = var1_1;
        return Files.getOwner(path, (LinkOption[])Arrays.copyOf(v0, ((void)v0).length));
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Path setOwner(Path $this$setOwner, UserPrincipal value) throws IOException {
        void var1_1;
        Path path;
        Intrinsics.checkNotNullParameter($this$setOwner, "");
        Intrinsics.checkNotNullParameter(value, "");
        Path path2 = Files.setOwner(path, (UserPrincipal)var1_1);
        Intrinsics.checkNotNullExpressionValue(path2, "");
        return path2;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Set<PosixFilePermission> getPosixFilePermissions(Path $this$getPosixFilePermissions, LinkOption ... options) throws IOException {
        Path path;
        void var1_1;
        Intrinsics.checkNotNullParameter($this$getPosixFilePermissions, "");
        Intrinsics.checkNotNullParameter(options, "");
        void v0 = var1_1;
        Set<PosixFilePermission> set = Files.getPosixFilePermissions(path, (LinkOption[])Arrays.copyOf(v0, ((void)v0).length));
        Intrinsics.checkNotNullExpressionValue(set, "");
        return set;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Path setPosixFilePermissions(Path $this$setPosixFilePermissions, Set<? extends PosixFilePermission> value) throws IOException {
        void var1_1;
        Path path;
        Intrinsics.checkNotNullParameter($this$setPosixFilePermissions, "");
        Intrinsics.checkNotNullParameter(value, "");
        Path path2 = Files.setPosixFilePermissions(path, (Set<PosixFilePermission>)var1_1);
        Intrinsics.checkNotNullExpressionValue(path2, "");
        return path2;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Path createLinkPointingTo(Path $this$createLinkPointingTo, Path target) throws IOException {
        void var1_1;
        Path path;
        Intrinsics.checkNotNullParameter($this$createLinkPointingTo, "");
        Intrinsics.checkNotNullParameter(target, "");
        Path path2 = Files.createLink(path, (Path)var1_1);
        Intrinsics.checkNotNullExpressionValue(path2, "");
        return path2;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Path createSymbolicLinkPointingTo(Path $this$createSymbolicLinkPointingTo, Path target, FileAttribute<?> ... attributes) throws IOException {
        void var1_1;
        Path path;
        void var2_2;
        Intrinsics.checkNotNullParameter($this$createSymbolicLinkPointingTo, "");
        Intrinsics.checkNotNullParameter(target, "");
        Intrinsics.checkNotNullParameter(attributes, "");
        void v0 = var2_2;
        Path path2 = Files.createSymbolicLink(path, (Path)var1_1, (FileAttribute[])Arrays.copyOf(v0, ((void)v0).length));
        Intrinsics.checkNotNullExpressionValue(path2, "");
        return path2;
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Path readSymbolicLink(Path $this$readSymbolicLink) throws IOException {
        Path path;
        Intrinsics.checkNotNullParameter($this$readSymbolicLink, "");
        Path path2 = Files.readSymbolicLink(path);
        Intrinsics.checkNotNullExpressionValue(path2, "");
        return path2;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Path createFile(Path $this$createFile, FileAttribute<?> ... attributes) throws IOException {
        Path path;
        void var1_1;
        Intrinsics.checkNotNullParameter($this$createFile, "");
        Intrinsics.checkNotNullParameter(attributes, "");
        void v0 = var1_1;
        Path path2 = Files.createFile(path, (FileAttribute[])Arrays.copyOf(v0, ((void)v0).length));
        Intrinsics.checkNotNullExpressionValue(path2, "");
        return path2;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Path createTempFile(String prefix, String suffix, FileAttribute<?> ... attributes) throws IOException {
        void var1_1;
        String string;
        void var2_2;
        Intrinsics.checkNotNullParameter(attributes, "");
        void v0 = var2_2;
        Path path = Files.createTempFile(string, (String)var1_1, (FileAttribute[])Arrays.copyOf(v0, ((void)v0).length));
        Intrinsics.checkNotNullExpressionValue(path, "");
        return path;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Path createTempFile$default(String prefix, String suffix, FileAttribute[] attributes, int n2, Object object) throws IOException {
        void var1_1;
        String string;
        void var2_2;
        if ((n2 & 1) != 0) {
            prefix = null;
        }
        if ((n2 & 2) != 0) {
            suffix = null;
        }
        Intrinsics.checkNotNullParameter(attributes, "");
        void v0 = var2_2;
        Path path = Files.createTempFile(string, (String)var1_1, (FileAttribute[])Arrays.copyOf(v0, ((void)v0).length));
        Intrinsics.checkNotNullExpressionValue(path, "");
        return path;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @NotNull
    public static final Path createTempFile(@Nullable Path directory, @Nullable String prefix, @Nullable String suffix, FileAttribute<?> ... attributes) throws IOException {
        void var2_2;
        void var1_1;
        void var3_3;
        Intrinsics.checkNotNullParameter(attributes, "");
        if (directory != null) {
            Path path;
            Path path2 = Files.createTempFile(path, prefix, suffix, Arrays.copyOf(attributes, attributes.length));
            Intrinsics.checkNotNullExpressionValue(path2, "");
            return path2;
        }
        void v1 = var3_3;
        Path path = Files.createTempFile((String)var1_1, (String)var2_2, (FileAttribute[])Arrays.copyOf(v1, ((void)v1).length));
        Intrinsics.checkNotNullExpressionValue(path, "");
        return path;
    }

    public static /* synthetic */ Path createTempFile$default(Path path, String string, String string2, FileAttribute[] fileAttributeArray, int n2, Object object) throws IOException {
        if ((n2 & 2) != 0) {
            string = null;
        }
        if ((n2 & 4) != 0) {
            string2 = null;
        }
        return PathsKt.createTempFile(path, string, string2, fileAttributeArray);
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Path createTempDirectory(String prefix, FileAttribute<?> ... attributes) throws IOException {
        String string;
        void var1_1;
        Intrinsics.checkNotNullParameter(attributes, "");
        void v0 = var1_1;
        Path path = Files.createTempDirectory(string, (FileAttribute[])Arrays.copyOf(v0, ((void)v0).length));
        Intrinsics.checkNotNullExpressionValue(path, "");
        return path;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Path createTempDirectory$default(String prefix, FileAttribute[] attributes, int n2, Object object) throws IOException {
        String string;
        void var1_1;
        if ((n2 & 1) != 0) {
            prefix = null;
        }
        Intrinsics.checkNotNullParameter(attributes, "");
        void v0 = var1_1;
        Path path = Files.createTempDirectory(string, (FileAttribute[])Arrays.copyOf(v0, ((void)v0).length));
        Intrinsics.checkNotNullExpressionValue(path, "");
        return path;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @NotNull
    public static final Path createTempDirectory(@Nullable Path directory, @Nullable String prefix, FileAttribute<?> ... attributes) throws IOException {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter(attributes, "");
        if (directory != null) {
            Path path;
            Path path2 = Files.createTempDirectory(path, prefix, Arrays.copyOf(attributes, attributes.length));
            Intrinsics.checkNotNullExpressionValue(path2, "");
            return path2;
        }
        void v1 = var2_2;
        Path path = Files.createTempDirectory((String)var1_1, (FileAttribute[])Arrays.copyOf(v1, ((void)v1).length));
        Intrinsics.checkNotNullExpressionValue(path, "");
        return path;
    }

    public static /* synthetic */ Path createTempDirectory$default(Path path, String string, FileAttribute[] fileAttributeArray, int n2, Object object) throws IOException {
        if ((n2 & 2) != 0) {
            string = null;
        }
        return PathsKt.createTempDirectory(path, string, fileAttributeArray);
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Path div(Path $this$div, Path other) {
        void var1_1;
        Path path;
        Intrinsics.checkNotNullParameter($this$div, "");
        Intrinsics.checkNotNullParameter(other, "");
        Path path2 = path.resolve((Path)var1_1);
        Intrinsics.checkNotNullExpressionValue(path2, "");
        return path2;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Path div(Path $this$div, String other) {
        void var1_1;
        Path path;
        Intrinsics.checkNotNullParameter($this$div, "");
        Intrinsics.checkNotNullParameter(other, "");
        Path path2 = path.resolve((String)var1_1);
        Intrinsics.checkNotNullExpressionValue(path2, "");
        return path2;
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Path Path(String path) {
        String string;
        Intrinsics.checkNotNullParameter(path, "");
        Path path2 = Paths.get(string, new String[0]);
        Intrinsics.checkNotNullExpressionValue(path2, "");
        return path2;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Path Path(String base, String ... subpaths) {
        String string;
        void var1_1;
        Intrinsics.checkNotNullParameter(base, "");
        Intrinsics.checkNotNullParameter(subpaths, "");
        void v0 = var1_1;
        Path path = Paths.get(string, (String[])Arrays.copyOf(v0, ((void)v0).length));
        Intrinsics.checkNotNullExpressionValue(path, "");
        return path;
    }

    @SinceKotlin(version="1.5")
    @WasExperimental(markerClass={ExperimentalPathApi.class})
    @InlineOnly
    private static final Path toPath(URI $this$toPath) {
        URI uRI;
        Intrinsics.checkNotNullParameter($this$toPath, "");
        Path path = Paths.get(uRI);
        Intrinsics.checkNotNullExpressionValue(path, "");
        return path;
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalPathApi
    @SinceKotlin(version="1.7")
    @NotNull
    public static final Sequence<Path> walk(@NotNull Path $this$walk, PathWalkOption ... options) {
        void var1_1;
        Path path;
        Intrinsics.checkNotNullParameter($this$walk, "");
        Intrinsics.checkNotNullParameter(options, "");
        return new PathTreeWalk(path, (PathWalkOption[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalPathApi
    @SinceKotlin(version="1.7")
    public static final void visitFileTree(@NotNull Path $this$visitFileTree, @NotNull FileVisitor<Path> visitor, int maxDepth, boolean followLinks) {
        void var1_1;
        void var2_2;
        void var3_4;
        Path path;
        Intrinsics.checkNotNullParameter($this$visitFileTree, "");
        Intrinsics.checkNotNullParameter(visitor, "");
        Set<Object> options = followLinks ? SetsKt.setOf(FileVisitOption.FOLLOW_LINKS) : SetsKt.emptySet();
        Files.walkFileTree(path, (Set<FileVisitOption>)var3_4, (int)var2_2, (FileVisitor<? super Path>)var1_1);
    }

    public static /* synthetic */ void visitFileTree$default(Path path, FileVisitor fileVisitor, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = Integer.MAX_VALUE;
        }
        if ((n3 & 4) != 0) {
            bl = false;
        }
        PathsKt.visitFileTree(path, fileVisitor, n2, bl);
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalPathApi
    @SinceKotlin(version="1.7")
    public static final void visitFileTree(@NotNull Path $this$visitFileTree, int maxDepth, boolean followLinks, @NotNull Function1<? super FileVisitorBuilder, Unit> builderAction) {
        void var2_2;
        void var1_1;
        void var3_3;
        Path path;
        Intrinsics.checkNotNullParameter($this$visitFileTree, "");
        Intrinsics.checkNotNullParameter(builderAction, "");
        PathsKt.visitFileTree(path, PathsKt.fileVisitor((Function1<? super FileVisitorBuilder, Unit>)var3_3), (int)var1_1, (boolean)var2_2);
    }

    public static /* synthetic */ void visitFileTree$default(Path path, int n2, boolean bl, Function1 function1, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n2 = Integer.MAX_VALUE;
        }
        if ((n3 & 2) != 0) {
            bl = false;
        }
        PathsKt.visitFileTree(path, n2, bl, function1);
    }

    @ExperimentalPathApi
    @SinceKotlin(version="1.7")
    @NotNull
    public static final FileVisitor<Path> fileVisitor(@NotNull Function1<? super FileVisitorBuilder, Unit> builderAction) {
        Function1<? super FileVisitorBuilder, Unit> function1;
        Intrinsics.checkNotNullParameter(builderAction, "");
        FileVisitorBuilderImpl fileVisitorBuilderImpl = new FileVisitorBuilderImpl();
        function1.invoke(fileVisitorBuilderImpl);
        return fileVisitorBuilderImpl.build();
    }
}

