/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.internal.InlineOnly;
import kotlin.internal.PlatformImplementationsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.LinesSequence;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0017\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u0087\b\u001a\u0017\u0010\u0000\u001a\u00020\u0005*\u00020\u00062\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u0087\b\u001a\u001c\u0010\u0007\u001a\u00020\b*\u00020\u00022\u0006\u0010\t\u001a\u00020\u00062\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u001a\u001e\u0010\n\u001a\u00020\u000b*\u00020\u00022\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000b0\r\u001a\u0010\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010*\u00020\u0001\u001a\n\u0010\u0011\u001a\u00020\u0012*\u00020\u0013\u001a\u0010\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0015*\u00020\u0002\u001a\n\u0010\u0016\u001a\u00020\u000e*\u00020\u0002\u001a\u0017\u0010\u0016\u001a\u00020\u000e*\u00020\u00132\b\b\u0002\u0010\u0017\u001a\u00020\u0018H\u0087\b\u001a\r\u0010\u0019\u001a\u00020\u001a*\u00020\u000eH\u0087\b\u001a5\u0010\u001b\u001a\u0002H\u001c\"\u0004\b\u0000\u0010\u001c*\u00020\u00022\u0018\u0010\u001d\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u0010\u0012\u0004\u0012\u0002H\u001c0\rH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001e\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001f"}, d2={"buffered", "Ljava/io/BufferedReader;", "Ljava/io/Reader;", "bufferSize", "", "Ljava/io/BufferedWriter;", "Ljava/io/Writer;", "copyTo", "", "out", "forEachLine", "", "action", "Lkotlin/Function1;", "", "lineSequence", "Lkotlin/sequences/Sequence;", "readBytes", "", "Ljava/net/URL;", "readLines", "", "readText", "charset", "Ljava/nio/charset/Charset;", "reader", "Ljava/io/StringReader;", "useLines", "T", "block", "(Ljava/io/Reader;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "kotlin-stdlib"})
@JvmName(name="TextStreamsKt")
@SourceDebugExtension(value={"SMAP\nReadWrite.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReadWrite.kt\nkotlin/io/TextStreamsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,151:1\n52#1:152\n1#2:153\n1#2:156\n1313#3,2:154\n*S KotlinDebug\n*F\n+ 1 ReadWrite.kt\nkotlin/io/TextStreamsKt\n*L\n33#1:152\n33#1:153\n33#1:154,2\n*E\n"})
public final class TextStreamsKt {
    /*
     * WARNING - void declaration
     */
    @InlineOnly
    private static final BufferedReader buffered(Reader $this$buffered, int bufferSize) {
        void var1_1;
        Reader reader;
        Intrinsics.checkNotNullParameter($this$buffered, "");
        if ($this$buffered instanceof BufferedReader) {
            return (BufferedReader)$this$buffered;
        }
        return new BufferedReader(reader, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ BufferedReader buffered$default(Reader $this$buffered_u24default, int bufferSize, int n2, Object object) {
        void var1_1;
        Reader reader;
        if ((n2 & 1) != 0) {
            bufferSize = 8192;
        }
        Intrinsics.checkNotNullParameter($this$buffered_u24default, "");
        if ($this$buffered_u24default instanceof BufferedReader) {
            return (BufferedReader)$this$buffered_u24default;
        }
        return new BufferedReader(reader, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @InlineOnly
    private static final BufferedWriter buffered(Writer $this$buffered, int bufferSize) {
        void var1_1;
        Writer writer;
        Intrinsics.checkNotNullParameter($this$buffered, "");
        if ($this$buffered instanceof BufferedWriter) {
            return (BufferedWriter)$this$buffered;
        }
        return new BufferedWriter(writer, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ BufferedWriter buffered$default(Writer $this$buffered_u24default, int bufferSize, int n2, Object object) {
        void var1_1;
        Writer writer;
        if ((n2 & 1) != 0) {
            bufferSize = 8192;
        }
        Intrinsics.checkNotNullParameter($this$buffered_u24default, "");
        if ($this$buffered_u24default instanceof BufferedWriter) {
            return (BufferedWriter)$this$buffered_u24default;
        }
        return new BufferedWriter(writer, (int)var1_1);
    }

    public static final void forEachLine(@NotNull Reader $this$forEachLine, @NotNull Function1<? super String, Unit> action) {
        Closeable closeable;
        Intrinsics.checkNotNullParameter($this$forEachLine, "");
        Intrinsics.checkNotNullParameter(action, "");
        Reader reader = closeable;
        closeable = reader;
        closeable = reader;
        closeable = reader instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, 8192);
        Throwable throwable = null;
        try {
            Object object = (BufferedReader)closeable;
            Sequence<String> sequence2 = TextStreamsKt.lineSequence((BufferedReader)object);
            object = sequence2;
            object = sequence2;
            object = sequence2.iterator();
            while (object.hasNext()) {
                Object element$iv = object.next();
                action.invoke((String)element$iv);
            }
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                CloseableKt.closeFinally(closeable, throwable);
                throw throwable4;
            }
        }
        CloseableKt.closeFinally(closeable, null);
        return;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> readLines(@NotNull Reader $this$readLines) {
        void var1_1;
        Reader reader;
        Intrinsics.checkNotNullParameter($this$readLines, "");
        ArrayList<String> result = new ArrayList<String>();
        TextStreamsKt.forEachLine(reader, (Function1<? super String, Unit>)new Function1<String, Unit>(result){
            final /* synthetic */ ArrayList<String> $result;
            {
                void var1_1;
                this.$result = var1_1;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull String it) {
                void var1_1;
                Intrinsics.checkNotNullParameter(it, "");
                this.$result.add((String)var1_1);
            }
        });
        return (List)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final <T> T useLines(@NotNull Reader $this$useLines, @NotNull Function1<? super Sequence<String>, ? extends T> block) {
        Object r2;
        Closeable closeable;
        Intrinsics.checkNotNullParameter($this$useLines, "");
        Intrinsics.checkNotNullParameter(block, "");
        closeable = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, 8192);
        Throwable throwable = null;
        try {
            void var1_1;
            BufferedReader it = (BufferedReader)closeable;
            r2 = var1_1.invoke(TextStreamsKt.lineSequence((BufferedReader)r2));
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                InlineMarker.finallyStart(1);
                if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
                    CloseableKt.closeFinally(closeable, throwable);
                } else if (throwable == null) {
                    closeable.close();
                } else {
                    try {
                        closeable.close();
                    }
                    catch (Throwable throwable5) {}
                }
                InlineMarker.finallyEnd(1);
                throw throwable4;
            }
        }
        InlineMarker.finallyStart(1);
        if (PlatformImplementationsKt.apiVersionIsAtLeast(1, 1, 0)) {
            CloseableKt.closeFinally(closeable, null);
        } else {
            closeable.close();
        }
        InlineMarker.finallyEnd(1);
        return (T)r2;
    }

    @InlineOnly
    private static final StringReader reader(String $this$reader) {
        String string;
        Intrinsics.checkNotNullParameter($this$reader, "");
        return new StringReader(string);
    }

    @NotNull
    public static final Sequence<String> lineSequence(@NotNull BufferedReader $this$lineSequence) {
        BufferedReader bufferedReader;
        Intrinsics.checkNotNullParameter($this$lineSequence, "");
        return SequencesKt.constrainOnce(new LinesSequence(bufferedReader));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String readText(@NotNull Reader $this$readText) {
        void var1_1;
        Reader reader;
        Intrinsics.checkNotNullParameter($this$readText, "");
        StringWriter buffer = new StringWriter();
        TextStreamsKt.copyTo$default(reader, buffer, 0, 2, null);
        String string = var1_1.toString();
        Intrinsics.checkNotNullExpressionValue(string, "");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static final long copyTo(@NotNull Reader $this$copyTo, @NotNull Writer out, int bufferSize) {
        void var3_4;
        Intrinsics.checkNotNullParameter($this$copyTo, "");
        Intrinsics.checkNotNullParameter(out, "");
        long charsCopied = 0L;
        char[] buffer = new char[bufferSize];
        int chars = $this$copyTo.read(buffer);
        while (chars >= 0) {
            out.write(buffer, 0, chars);
            charsCopied += (long)chars;
            chars = $this$copyTo.read(buffer);
        }
        return (long)var3_4;
    }

    public static /* synthetic */ long copyTo$default(Reader reader, Writer writer, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 8192;
        }
        return TextStreamsKt.copyTo(reader, writer, n2);
    }

    /*
     * WARNING - void declaration
     */
    @InlineOnly
    private static final String readText(URL $this$readText, Charset charset) {
        void var1_1;
        Object object;
        Intrinsics.checkNotNullParameter($this$readText, "");
        Intrinsics.checkNotNullParameter(charset, "");
        object = TextStreamsKt.readBytes((URL)object);
        return new String((byte[])object, (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String readText$default(URL $this$readText_u24default, Charset charset, int n2, Object object) {
        void var1_1;
        URL uRL;
        if ((n2 & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        Intrinsics.checkNotNullParameter($this$readText_u24default, "");
        Intrinsics.checkNotNullParameter(charset, "");
        byte[] byArray = TextStreamsKt.readBytes(uRL);
        return new String(byArray, (Charset)var1_1);
    }

    @NotNull
    public static final byte[] readBytes(@NotNull URL $this$readBytes) {
        byte[] byArray;
        Closeable closeable;
        Intrinsics.checkNotNullParameter($this$readBytes, "");
        closeable = ((URL)((Object)closeable)).openStream();
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            Intrinsics.checkNotNull(it);
            byArray = ByteStreamsKt.readBytes((InputStream)byArray);
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                CloseableKt.closeFinally(closeable, throwable);
                throw throwable4;
            }
        }
        CloseableKt.closeFinally(closeable, null);
        return byArray;
    }
}

