/*
 * Decompiled with CFR 0.152.
 */
package com.sztech.gateway.shared.service.info;

import java.time.Duration;
import java.util.Collections;
import java.util.Map;

public class GatewayRequest<T> {
    private final String resourceCode;
    private final String method;
    private final Map<String, String> headers;
    private final T body;
    private final String contentType;
    private final String requestSecret;
    private final Map<String, ?> urlParams;
    private final Duration timeout;

    /*
     * WARNING - void declaration
     */
    private GatewayRequest(Builder<T> builder) {
        void var1_1;
        this.resourceCode = ((Builder)builder).resourceCode;
        this.method = ((Builder)builder).method;
        this.headers = ((Builder)builder).headers;
        this.body = ((Builder)builder).body;
        this.contentType = ((Builder)builder).contentType;
        this.requestSecret = ((Builder)builder).requestSecret;
        this.urlParams = ((Builder)builder).urlParams;
        this.timeout = ((Builder)var1_1).timeout;
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public Map<String, ?> getUrlParams() {
        return this.urlParams;
    }

    public String getResourceCode() {
        return this.resourceCode;
    }

    public String getMethod() {
        return this.method;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public T getBody() {
        return this.body;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getRequestSecret() {
        return this.requestSecret;
    }

    public Duration timeout() {
        return this.timeout;
    }

    public static class Builder<T> {
        private String resourceCode;
        private String method = "POST";
        private Map<String, String> headers = Collections.emptyMap();
        private T body;
        private String contentType = "json";
        private String requestSecret;
        private Map<String, ?> urlParams = Collections.emptyMap();
        private Duration timeout = Duration.ofSeconds(15L);

        /*
         * WARNING - void declaration
         */
        public Builder<T> urlParams(Map<String, ?> urlParams) {
            void var1_1;
            this.urlParams = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder<T> resourceCode(String resourceCode) {
            void var1_1;
            this.resourceCode = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder<T> method(String method) {
            void var1_1;
            this.method = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder<T> headers(Map<String, String> headers) {
            void var1_1;
            this.headers = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder<T> body(T body) {
            void var1_1;
            this.body = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder<T> contentType(String contentType) {
            void var1_1;
            this.contentType = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder<T> requestSecret(String requestSecret) {
            void var1_1;
            this.requestSecret = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder<T> timeout(Duration timeout2) {
            void var1_1;
            this.timeout = var1_1;
            return this;
        }

        public GatewayRequest<T> build() {
            return new GatewayRequest(this);
        }
    }
}

