/*
 * Decompiled with CFR 0.152.
 */
package com.sztech.gateway.shared.service.core;

import com.sztech.gateway.shared.OkHttps;
import com.sztech.gateway.shared.b;
import com.sztech.gateway.shared.c;
import com.sztech.gateway.shared.core.TypeRef;
import com.sztech.gateway.shared.f;
import com.sztech.gateway.shared.gateway.AppConfig;
import com.sztech.gateway.shared.gateway.BizException;
import com.sztech.gateway.shared.gateway.GatewayExceptionEnum;
import com.sztech.gateway.shared.gateway.GatewayResource;
import com.sztech.gateway.shared.j;
import com.sztech.gateway.shared.m;
import com.sztech.gateway.shared.s;
import com.sztech.gateway.shared.service.core.x.a;
import com.sztech.gateway.shared.service.info.GatewayRequest;
import com.sztech.gateway.shared.service.info.GatewayResult;
import com.sztech.gateway.shared.service.info.RefreshSecretResponse;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenServiceClient
implements b {
    private static final Logger logger = LoggerFactory.getLogger(OpenServiceClient.class);
    private final AppConfig appConfig = c.a().b();

    /*
     * WARNING - void declaration
     */
    public <T, R> GatewayResult<R> callGatewayService(GatewayRequest<T> request, TypeRef<GatewayResult<R>> typeRef) {
        if (request == null || request.getResourceCode() == null) {
            throw new BizException(GatewayExceptionEnum.CALL_API_REQUEST_DATA_NOT_FOUND.getCode(), GatewayExceptionEnum.CALL_API_REQUEST_DATA_NOT_FOUND.getDescription());
        }
        try {
            void var2_2;
            void var1_1;
            s sHttpTask = (s)((s)((s)this.buildHttpClient().a(chain -> {
                void var2_2;
                void var1_1;
                void var3_3;
                OpenServiceClient openServiceClient = this;
                GatewayResource gatewayResource = openServiceClient.a(openServiceClient.appConfig.getBaseUrl(), this.appConfig.getAccessKey(), request.getResourceCode());
                m<?> httpTask = chain.getTask();
                httpTask.b(gatewayResource.getFullResourceUri());
                httpTask.a("X-Gateway-Auth-ResourceCode", Optional.ofNullable(var3_3.getResourceCode()).orElse(var1_1.getResourceCode()));
                this.addCommonAuthHeaders(httpTask);
                var2_2.proceed();
            }).a(new a(this.appConfig.getAccessKey(), request.getRequestSecret())).p().sync("").a(request.getHeaders())).c(request.getContentType())).b(request.getUrlParams());
            if (StringUtils.equalsIgnoreCase("json", request.getContentType())) {
                sHttpTask.a(request.getBody());
            } else {
                if (!(request.getBody() instanceof Map)) {
                    throw new BizException(GatewayExceptionEnum.API_REQUEST_PARAM_ERROR.getCode(), "\u8868\u5355\u7c7b\u578b\u8bf7\u6c42\u5fc5\u987b\u63d0\u4f9b Map \u7c7b\u578b\u7684 body \u53c2\u6570");
                }
                sHttpTask.c((Map)request.getBody());
            }
            if (Objects.nonNull(request.timeout())) {
                sHttpTask.a(request.timeout());
            }
            return (GatewayResult)sHttpTask.a(var1_1.getMethod()).getBody().toBean(var2_2);
        }
        catch (Exception e2) {
            void var3_4;
            throw this.handleException(GatewayExceptionEnum.REMOTE_CALL_GATEWAY_FAIL, (Exception)var3_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    public GatewayResult<RefreshSecretResponse> refreshSecret(String secret, boolean isAppSecret) {
        if (secret == null || secret.isEmpty()) {
            throw new BizException(GatewayExceptionEnum.REFRESH_SECRET_DATA_NOT_FOUND.getCode(), GatewayExceptionEnum.REFRESH_SECRET_DATA_NOT_FOUND.getDescription());
        }
        try {
            void var1_1;
            String uri = isAppSecret ? this.appConfig.getSecretByKeyUri() : this.appConfig.getSecretBySecUri();
            return ((s)this.buildHttpClient().a(chain -> {
                void var1_1;
                void var2_2;
                m<?> httpTask = chain.getTask();
                this.addCommonAuthHeaders((m<?>)var2_2);
                var1_1.proceed();
            }).a(new com.sztech.gateway.shared.service.core.x.b(this.appConfig.getAccessKey(), (String)var1_1)).p().sync(uri).c("form")).a("POST").getBody().toBean(new TypeRef<GatewayResult<RefreshSecretResponse>>(this){
                private /* synthetic */ OpenServiceClient a;
                {
                    void var1_1;
                    this.a = var1_1;
                }
            });
        }
        catch (Exception e2) {
            void var2_4;
            throw this.handleException(GatewayExceptionEnum.REMOTE_CALL_SECRET_FAIL, (Exception)var2_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addCommonAuthHeaders(m<?> task) {
        void var1_1;
        task.a("X-Gateway-Auth-EncryptText", this.appConfig.getEncryptText());
        task.a("X-Gateway-Auth-AccessKey", this.appConfig.getAccessKey());
        task.a("X-Gateway-Auth-SdkId", this.appConfig.getSdkId());
        var1_1.a("X-Gateway-Call-AppContext", f.a());
    }

    /*
     * WARNING - void declaration
     */
    public GatewayResult<RefreshSecretResponse> refreshSecretByKey(String appSecret) {
        void var1_1;
        return this.refreshSecret((String)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public GatewayResult<RefreshSecretResponse> refreshSecretBySec(String refreshSecret) {
        void var1_1;
        return this.refreshSecret((String)var1_1, false);
    }

    private j.a buildHttpClient() {
        return OkHttps.newBuilder();
    }

    /*
     * WARNING - void declaration
     */
    private BizException handleException(GatewayExceptionEnum exceptionEnum, Exception e2) {
        void var1_1;
        block2: {
            try {
                logger.error("{}\u5f02\u5e38: {}", new Object[]{exceptionEnum != null ? exceptionEnum.getDescription() : "\u672a\u77e5\u5f02\u5e38\u7c7b\u578b", e2 != null ? e2.getMessage() : "null", e2});
            }
            catch (Exception logEx) {
                void var2_2;
                void var3_3;
                System.err.println("\u5931\u8d25: " + var3_3.getMessage());
                if (e2 == null) break block2;
                var2_2.printStackTrace();
            }
        }
        return new BizException(exceptionEnum != null ? exceptionEnum.getCode() : "UNKNOWN", exceptionEnum != null ? var1_1.getDescription() : "\u7cfb\u7edf\u5f02\u5e38");
    }
}

