/*
 * Decompiled with CFR 0.152.
 */
package com.sztech.gateway.shared.core.eventbus;

import com.sztech.gateway.shared.core.AnnotationUtils;
import com.sztech.gateway.shared.core.common.SafeConcurrentHashMap;
import com.sztech.gateway.shared.core.eventbus.Event;
import com.sztech.gateway.shared.core.eventbus.EventBus;
import com.sztech.gateway.shared.core.eventbus.EventHandler;
import com.sztech.gateway.shared.core.eventbus.SubscriberMethod;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.exception.ExceptionUtils;

public final class SimpleEventBus
implements EventBus {
    private static final SimpleEventBus DEFAULT_INSTANCE = new SimpleEventBus();
    private final ExecutorService executorService;
    private final Map<Class<?>, Set<SubscriberMethod>> subscribers = new SafeConcurrentHashMap();

    public static SimpleEventBus instance() {
        return DEFAULT_INSTANCE;
    }

    public SimpleEventBus() {
        this(Executors.newCachedThreadPool(new ThreadFactory(){
            private final AtomicLong threadCount = new AtomicLong(0L);

            /*
             * WARNING - void declaration
             */
            @Override
            public Thread newThread(Runnable r2) {
                void var1_1;
                Thread thread2 = new Thread(r2);
                thread2.setName("event-bus-simple-" + this.threadCount.incrementAndGet());
                return var1_1;
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    public SimpleEventBus(ExecutorService executorService) {
        void var1_1;
        this.executorService = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void registerSubscriber(Object subscriber) {
        Iterator iterator2;
        Class<?> subscriberClass = subscriber.getClass();
        Method[] methods = subscriberClass.getMethods();
        HashMap<void, EventHandler> map = new HashMap<void, EventHandler>(methods.length);
        for (void m2 : iterator2) {
            EventHandler annotation = AnnotationUtils.findAnnotation((Method)m2, EventHandler.class);
            if (annotation == null || m2.getParameterCount() != 1) continue;
            map.put(m2, annotation);
        }
        if (map.isEmpty()) {
            void var2_2;
            throw new RuntimeException("Subscriber " + var2_2.getName() + " has no valid event handlers");
        }
        for (Map.Entry entry : map.entrySet()) {
            Method method = (Method)entry.getKey();
            EventHandler eventHandler = (EventHandler)entry.getValue();
            Class<?> eventType = method.getParameters()[0].getType();
            this.subscribers.computeIfAbsent(eventType, k2 -> ConcurrentHashMap.newKeySet()).add(new SubscriberMethod(subscriber, method, eventHandler.async()));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void unregisterSubscriber(Object subscriber) {
        void var1_1;
        this.subscribers.values().forEach(methods -> {
            Object object;
            methods.removeIf(sm -> {
                Object object;
                return sm.getSubscriber() == object;
            });
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void postEvent(Event event) {
        void var1_1;
        this.dispatchEvent((Event)var1_1);
    }

    private void dispatchEvent(Event event) {
        Set<SubscriberMethod> handlers = this.subscribers.get(event.getClass());
        if (handlers != null) {
            Iterator<Object> iterator2;
            iterator2 = iterator2.iterator();
            while (iterator2.hasNext()) {
                SubscriberMethod iterator3 = (SubscriberMethod)iterator2.next();
                this.invokeHandler(iterator3, event);
            }
        }
        for (Map.Entry entry : this.subscribers.entrySet()) {
            if (!((Class)entry.getKey()).isAssignableFrom(event.getClass()) || ((Class)entry.getKey()).equals(event.getClass())) continue;
            for (SubscriberMethod sm : (Set)entry.getValue()) {
                this.invokeHandler(sm, event);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void invokeHandler(SubscriberMethod sm, Event event) {
        void var2_2;
        void var1_1;
        if (sm.isAsync()) {
            this.executorService.submit(() -> {
                void var2_2;
                void var1_1;
                this.safeInvoke((SubscriberMethod)var1_1, (Event)var2_2);
            });
            return;
        }
        this.safeInvoke((SubscriberMethod)var1_1, (Event)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void safeInvoke(SubscriberMethod sm, Event event) {
        try {
            void var2_2;
            sm.getMethod().invoke(sm.getSubscriber(), var2_2);
            return;
        }
        catch (Exception exception) {
            void var1_1;
            Exception ex = exception;
            exception.printStackTrace();
            ExceptionUtils.rethrow((Throwable)var1_1);
            return;
        }
    }
}

