/*
 * Decompiled with CFR 0.152.
 */
package com.sztech.gateway.shared.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;

public class AnnotationUtils {
    private AnnotationUtils() {
    }

    public static <A extends Annotation> A findAnnotation(Class<?> clazz, Class<A> annotationType) {
        Class<?>[] classArray;
        A a2;
        if (clazz == null || annotationType == null) {
            return null;
        }
        A object2 = clazz.getAnnotation(annotationType);
        if (object2 != null) {
            return object2;
        }
        Class<?> clazz2 = clazz.getSuperclass();
        if (clazz2 != null && (a2 = AnnotationUtils.findAnnotation(clazz2, annotationType)) != null) {
            return a2;
        }
        for (Class<?> clazz3 : classArray.getInterfaces()) {
            A a3 = AnnotationUtils.findAnnotation(clazz3, annotationType);
            if (a3 == null) continue;
            return a3;
        }
        return null;
    }

    public static <A extends Annotation> A findMethodAnnotation(Class<?> clazz, String methodName, Class<A> annotationType) {
        if (clazz == null || methodName == null || annotationType == null) {
            return null;
        }
        try {
            Class<?>[] classArray;
            Method method = clazz.getMethod(methodName, new Class[0]);
            A annotation = method.getAnnotation(annotationType);
            if (annotation != null) {
                return annotation;
            }
            GenericDeclaration superclass = clazz.getSuperclass();
            if (superclass != null) {
                try {
                    superclass = superclass.getMethod(methodName, new Class[0]);
                    superclass = ((Method)superclass).getAnnotation(annotationType);
                    if (superclass != null) {
                        return (A)superclass;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
            for (Class<?> iface : classArray.getInterfaces()) {
                try {
                    method = ((Class)((Object)method)).getMethod(methodName, new Class[0]);
                    method = method.getAnnotation(annotationType);
                    if (method == null) continue;
                    return (A)method;
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static <A extends Annotation> A findAnnotation(Method method, Class<A> annotationType) {
        void var3_3;
        if (method == null || annotationType == null) {
            return null;
        }
        A annotation = method.getAnnotation(annotationType);
        if (annotation != null) {
            return annotation;
        }
        Class<?> declaringClass = method.getDeclaringClass();
        Class<Object> superclass = declaringClass.getSuperclass();
        if (superclass != null) {
            try {
                Method object = superclass.getDeclaredMethod(method.getName(), method.getParameterTypes());
                superclass = object.getAnnotation(annotationType);
                if (superclass != null) {
                    return (A)superclass;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        for (Class<?> iface : var3_3.getInterfaces()) {
            try {
                Method method2;
                method2 = ((Class)((Object)method2)).getMethod(method.getName(), method.getParameterTypes());
                method2 = method2.getAnnotation(annotationType);
                if (method2 == null) continue;
                return (A)method2;
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        return null;
    }
}

