/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.transformlet.impl;

import com.alibaba.ttl.TransmittableThreadLocal;
import com.alibaba.ttl.TtlCallable;
import com.alibaba.ttl.TtlRunnable;
import com.alibaba.ttl.spi.TtlAttachments;
import com.alibaba.ttl.spi.TtlEnhanced;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CannotCompileException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtBehavior;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtClass;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtMember;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtMethod;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtNewMethod;
import com.alibaba.ttl.threadpool.agent.internal.javassist.NotFoundException;
import com.alibaba.ttl.threadpool.agent.internal.logging.Logger;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.lang.reflect.Modifier;
import java.util.concurrent.Callable;

public class Utils {
    private static final Logger logger = Logger.getLogger(Utils.class);

    /*
     * WARNING - void declaration
     */
    @NonNull
    static String signatureOfMethod(@NonNull CtBehavior method) throws NotFoundException {
        void var1_2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Modifier.toString(((CtMember)method).getModifiers()));
        if (method instanceof CtMethod) {
            String returnType = ((CtMethod)method).getReturnType().getSimpleName();
            stringBuilder.append(" ").append(returnType);
        }
        stringBuilder.append(" ").append(method.getName()).append("(");
        CtClass[] parameterTypes = method.getParameterTypes();
        for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
            void var3_4;
            CtClass parameterType = parameterTypes[i2];
            if (i2 != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(var3_4.getSimpleName());
        }
        stringBuilder.append(")");
        return var1_2.toString();
    }

    @NonNull
    static String renamedMethodNameByTtl(@NonNull CtMethod method) {
        CtMethod ctMethod;
        return "original$" + ((CtMember)ctMethod).getName() + "$method$renamed$by$ttl";
    }

    /*
     * WARNING - void declaration
     */
    static void doTryFinallyForMethod(@NonNull CtMethod method, @NonNull String beforeCode, @NonNull String finallyCode) throws CannotCompileException, NotFoundException {
        void var2_2;
        void var1_1;
        CtMethod ctMethod = method;
        Utils.doTryFinallyForMethod(ctMethod, Utils.renamedMethodNameByTtl(ctMethod), (String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static void doTryFinallyForMethod(@NonNull CtMethod method, @NonNull String renamedMethodName, @NonNull String beforeCode, @NonNull String finallyCode) throws CannotCompileException, NotFoundException {
        String string;
        void var3_3;
        void var1_1;
        void var2_2;
        CtClass clazz = method.getDeclaringClass();
        CtMethod newMethod = CtNewMethod.copy(method, clazz, null);
        method.setName(renamedMethodName);
        CtMethod ctMethod = method;
        ((CtMember)ctMethod).setModifiers(((CtMember)ctMethod).getModifiers() & 0xFFFFFFFE & 0xFFFFFFFB | 2);
        String returnOp = method.getReturnType() == CtClass.voidType ? "" : "return ";
        String code = "{\n" + (String)var2_2 + "\ntry {\n    " + (String)returnOp + (String)var1_1 + "($$);\n} finally {\n    " + (String)var3_3 + "\n} }";
        newMethod.setBody(code);
        clazz.addMethod(newMethod);
        logger.info("insert code around method " + Utils.signatureOfMethod(newMethod) + " of class " + clazz.getName() + ": " + (String)string);
    }

    @Nullable
    public static Object doCaptureWhenNotTtlEnhanced(@Nullable Object obj) {
        if (obj instanceof TtlEnhanced) {
            return null;
        }
        return TransmittableThreadLocal.Transmitter.capture();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static Runnable doAutoWrap(@Nullable Runnable runnable2) {
        void var1_1;
        Runnable runnable3;
        if (runnable2 == null) {
            return null;
        }
        TtlRunnable ret = TtlRunnable.get(runnable2, false, true);
        if (ret != runnable3) {
            Utils.setAutoWrapperAttachment(ret);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static <T> Callable<T> doAutoWrap(@Nullable Callable<T> callable) {
        void var1_1;
        Callable<T> callable2;
        if (callable == null) {
            return null;
        }
        TtlCallable<T> ret = TtlCallable.get(callable, false, true);
        if (ret != callable2) {
            Utils.setAutoWrapperAttachment(ret);
        }
        return var1_1;
    }

    private static void setAutoWrapperAttachment(@Nullable Object ttlAttachment) {
        Object object;
        if (!(ttlAttachment instanceof TtlAttachments)) {
            return;
        }
        ((TtlAttachments)object).setTtlAttachment("ttl.is.auto.wrapper", Boolean.TRUE);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static Runnable doUnwrapIfIsAutoWrapper(@Nullable Runnable runnable2) {
        Runnable runnable3;
        void var1_1;
        if (!(runnable2 instanceof TtlAttachments)) {
            return runnable2;
        }
        Boolean isAutoWrapper = (Boolean)((TtlAttachments)((Object)runnable2)).getTtlAttachment("ttl.is.auto.wrapper");
        if (!Boolean.TRUE.equals(var1_1)) {
            return runnable2;
        }
        return TtlRunnable.unwrap(runnable3);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static String getPackageName(@NonNull String className) {
        void var1_1;
        String string;
        int idx = className.lastIndexOf(46);
        if (-1 == idx) {
            return "";
        }
        return string.substring(0, (int)var1_1);
    }

    public static boolean isClassAtPackage(@NonNull String className, @NonNull String packageName) {
        String string;
        return packageName.equals(Utils.getPackageName(string));
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isClassUnderPackage(@NonNull String className, @NonNull String packageName) {
        void var1_1;
        String string;
        String packageOfClass = Utils.getPackageName(className);
        return packageOfClass.equals(packageName) || string.startsWith((String)var1_1 + ".");
    }

    public static boolean isClassAtPackageJavaUtil(@NonNull String className) {
        return Utils.isClassAtPackage(className, "java.util");
    }
}

