/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.transformlet.impl;

import com.alibaba.ttl.threadpool.agent.internal.javassist.CannotCompileException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtClass;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtField;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtMethod;
import com.alibaba.ttl.threadpool.agent.internal.javassist.NotFoundException;
import com.alibaba.ttl.threadpool.agent.internal.logging.Logger;
import com.alibaba.ttl.threadpool.agent.internal.transformlet.ClassInfo;
import com.alibaba.ttl.threadpool.agent.internal.transformlet.JavassistTransformlet;
import com.alibaba.ttl.threadpool.agent.internal.transformlet.impl.Utils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public class TtlTimerTaskTransformlet
implements JavassistTransformlet {
    private static final Logger logger = Logger.getLogger(TtlTimerTaskTransformlet.class);
    private static final String TIMER_TASK_CLASS_NAME = "java.util.TimerTask";
    private static final String RUN_METHOD_NAME = "run";

    /*
     * WARNING - void declaration
     */
    @Override
    public void doTransform(@NonNull ClassInfo classInfo) throws IOException, NotFoundException, CannotCompileException {
        void var1_1;
        void var2_2;
        if (Utils.isClassAtPackageJavaUtil(classInfo.getClassName())) {
            return;
        }
        CtClass clazz = classInfo.getCtClass();
        if (clazz.isPrimitive() || clazz.isArray() || clazz.isInterface() || clazz.isAnnotation()) {
            return;
        }
        try {
            void var3_3;
            CtMethod runMethod = clazz.getDeclaredMethod(RUN_METHOD_NAME, new CtClass[0]);
            if (!CtClass.voidType.equals(var3_3.getReturnType())) {
                return;
            }
        }
        catch (NotFoundException notFoundException) {
            return;
        }
        CtClass ctClass = clazz;
        if (!ctClass.subclassOf(ctClass.getClassPool().get(TIMER_TASK_CLASS_NAME))) {
            return;
        }
        logger.info("Transforming class " + classInfo.getClassName());
        this.updateTimerTaskClass((CtClass)var2_2);
        var1_1.setModified();
    }

    /*
     * WARNING - void declaration
     */
    private void updateTimerTaskClass(@NonNull CtClass clazz) throws CannotCompileException, NotFoundException {
        CtMethod ctMethod;
        void var2_2;
        void var3_3;
        String className = clazz.getName();
        CtField capturedField = CtField.make("private final Object captured$field$added$by$ttl;", clazz);
        clazz.addField((CtField)var3_3, "com.alibaba.ttl.threadpool.agent.internal.transformlet.impl.Utils.doCaptureWhenNotTtlEnhanced(this);");
        logger.info("add new field captured$field$added$by$ttl to class " + (String)var2_2);
        ctMethod = ((CtClass)((Object)ctMethod)).getDeclaredMethod(RUN_METHOD_NAME, new CtClass[0]);
        Utils.doTryFinallyForMethod(ctMethod, "Object backup = com.alibaba.ttl.TransmittableThreadLocal.Transmitter.replay(captured$field$added$by$ttl);", "com.alibaba.ttl.TransmittableThreadLocal.Transmitter.restore(backup);");
    }
}

