/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.transformlet.impl;

import com.alibaba.ttl.threadpool.agent.internal.javassist.CannotCompileException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtClass;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtConstructor;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtMember;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtMethod;
import com.alibaba.ttl.threadpool.agent.internal.javassist.NotFoundException;
import com.alibaba.ttl.threadpool.agent.internal.logging.Logger;
import com.alibaba.ttl.threadpool.agent.internal.transformlet.ClassInfo;
import com.alibaba.ttl.threadpool.agent.internal.transformlet.JavassistTransformlet;
import com.alibaba.ttl.threadpool.agent.internal.transformlet.impl.Utils;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TtlExecutorTransformlet
implements JavassistTransformlet {
    private static final Logger logger = Logger.getLogger(TtlExecutorTransformlet.class);
    private static final Set<String> EXECUTOR_CLASS_NAMES = new HashSet<String>();
    private static final Map<String, String> PARAM_TYPE_NAME_TO_DECORATE_METHOD_CLASS = new HashMap<String, String>();
    private static final String THREAD_POOL_EXECUTOR_CLASS_NAME = "java.util.concurrent.ThreadPoolExecutor";
    private static final String RUNNABLE_CLASS_NAME = "java.lang.Runnable";
    private static final String THREAD_FACTORY_CLASS_NAME = "java.util.concurrent.ThreadFactory";
    private final boolean disableInheritableForThreadPool;

    /*
     * WARNING - void declaration
     */
    public TtlExecutorTransformlet(boolean disableInheritableForThreadPool) {
        void var1_1;
        this.disableInheritableForThreadPool = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doTransform(@NonNull ClassInfo classInfo) throws IOException, NotFoundException, CannotCompileException {
        void var2_2;
        if (Utils.isClassAtPackageJavaUtil(classInfo.getClassName())) {
            return;
        }
        CtClass clazz = classInfo.getCtClass();
        if (EXECUTOR_CLASS_NAMES.contains(classInfo.getClassName())) {
            for (CtMethod method : clazz.getDeclaredMethods()) {
                this.updateSubmitMethodsOfExecutorClass_decorateToTtlWrapperAndSetAutoWrapperAttachment(method);
            }
            if (this.disableInheritableForThreadPool) {
                this.updateConstructorDisableInheritable(clazz);
            }
            classInfo.setModified();
            return;
        }
        if (clazz.isPrimitive() || clazz.isArray() || clazz.isInterface() || clazz.isAnnotation()) {
            return;
        }
        CtClass ctClass = clazz;
        if (!ctClass.subclassOf(ctClass.getClassPool().get(THREAD_POOL_EXECUTOR_CLASS_NAME))) {
            return;
        }
        logger.info("Transforming class " + classInfo.getClassName());
        boolean bl = this.updateBeforeAndAfterExecuteMethodOfExecutorSubclass((CtClass)var2_2);
        if (bl) {
            void var1_1;
            var1_1.setModified();
        }
    }

    /*
     * WARNING - void declaration
     */
    @SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"})
    private void updateSubmitMethodsOfExecutorClass_decorateToTtlWrapperAndSetAutoWrapperAttachment(@NonNull CtMethod method) throws NotFoundException, CannotCompileException {
        int modifiers = ((CtMember)method).getModifiers();
        if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers)) {
            return;
        }
        CtClass[] parameterTypes = method.getParameterTypes();
        StringBuilder insertCode = new StringBuilder();
        for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
            String paramTypeName = parameterTypes[i2].getName();
            if (!PARAM_TYPE_NAME_TO_DECORATE_METHOD_CLASS.containsKey(paramTypeName)) continue;
            String code = String.format("$%d = com.alibaba.ttl.threadpool.agent.internal.transformlet.impl.Utils.doAutoWrap($%<d);", i2 + 1);
            insertCode.append(code);
        }
        if (insertCode.length() > 0) {
            void var3_4;
            void var1_1;
            logger.info("insert code before method " + Utils.signatureOfMethod(method) + " of class " + method.getDeclaringClass().getName() + ":\n" + insertCode);
            var1_1.insertBefore(var3_4.toString());
        }
    }

    private void updateConstructorDisableInheritable(@NonNull CtClass clazz) throws NotFoundException, CannotCompileException {
        for (CtConstructor constructor : clazz.getDeclaredConstructors()) {
            CtClass[] parameterTypes = constructor.getParameterTypes();
            StringBuilder insertCode = new StringBuilder();
            for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
                String paramTypeName = parameterTypes[i2].getName();
                if (!THREAD_FACTORY_CLASS_NAME.equals(paramTypeName)) continue;
                String code = String.format("$%d = com.alibaba.ttl.threadpool.TtlExecutors.getDisableInheritableThreadFactory($%<d);", i2 + 1);
                insertCode.append(code);
            }
            if (insertCode.length() <= 0) continue;
            logger.info("insert code before constructor " + Utils.signatureOfMethod(constructor) + " of class " + constructor.getDeclaringClass().getName() + ": " + insertCode);
            constructor.insertBefore(insertCode.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean updateBeforeAndAfterExecuteMethodOfExecutorSubclass(@NonNull CtClass clazz) throws NotFoundException, CannotCompileException {
        String code;
        CtClass runnableClass = clazz.getClassPool().get(RUNNABLE_CLASS_NAME);
        CtClass threadClass = clazz.getClassPool().get("java.lang.Thread");
        CtClass throwableClass = clazz.getClassPool().get("java.lang.Throwable");
        boolean modified = false;
        try {
            CtMethod beforeExecute = clazz.getDeclaredMethod("beforeExecute", new CtClass[]{threadClass, runnableClass});
            code = "$2 = com.alibaba.ttl.threadpool.agent.internal.transformlet.impl.Utils.doUnwrapIfIsAutoWrapper($2);";
            logger.info("insert code before method " + Utils.signatureOfMethod(beforeExecute) + " of class " + beforeExecute.getDeclaringClass().getName() + ": " + code);
            beforeExecute.insertBefore(code);
            modified = true;
        }
        catch (NotFoundException notFoundException) {}
        try {
            void var3_3;
            void var2_2;
            void var1_1;
            CtMethod afterExecute = var1_1.getDeclaredMethod("afterExecute", new CtClass[]{var2_2, throwableClass});
            code = "$1 = com.alibaba.ttl.threadpool.agent.internal.transformlet.impl.Utils.doUnwrapIfIsAutoWrapper($1);";
            logger.info("insert code before method " + Utils.signatureOfMethod(afterExecute) + " of class " + afterExecute.getDeclaringClass().getName() + ": " + code);
            var3_3.insertBefore(code);
            modified = true;
        }
        catch (NotFoundException notFoundException) {}
        return modified;
    }

    static {
        EXECUTOR_CLASS_NAMES.add(THREAD_POOL_EXECUTOR_CLASS_NAME);
        EXECUTOR_CLASS_NAMES.add("java.util.concurrent.ScheduledThreadPoolExecutor");
        PARAM_TYPE_NAME_TO_DECORATE_METHOD_CLASS.put(RUNNABLE_CLASS_NAME, "com.alibaba.ttl.TtlRunnable");
        PARAM_TYPE_NAME_TO_DECORATE_METHOD_CLASS.put("java.util.concurrent.Callable", "com.alibaba.ttl.TtlCallable");
    }
}

