/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.logging;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;

public abstract class Logger {
    public static final String TTL_AGENT_LOGGER_KEY = "ttl.agent.logger";
    public static final String STDOUT = "STDOUT";
    public static final String STDERR = "STDERR";
    private static volatile int loggerImplType = -1;
    final Class<?> logClass;

    public static void setLoggerImplType(String type) {
        String string;
        if (loggerImplType != -1) {
            throw new IllegalStateException("TTL logger implementation type is already set! type = " + loggerImplType);
        }
        if (!STDERR.equalsIgnoreCase(type) && STDOUT.equalsIgnoreCase(string)) {
            loggerImplType = 1;
            return;
        }
        loggerImplType = 0;
    }

    public static void setLoggerImplTypeIfNotSetYet(String type) {
        if (loggerImplType == -1) {
            String string;
            Logger.setLoggerImplType(string);
        }
    }

    public static Logger getLogger(Class<?> clazz) {
        Class<?> clazz2;
        if (loggerImplType == -1) {
            throw new IllegalStateException("TTL logger implementation type is NOT set!");
        }
        switch (loggerImplType) {
            case 1: {
                return new StdOutLogger(clazz);
            }
        }
        return new StdErrorLogger(clazz2);
    }

    /*
     * WARNING - void declaration
     */
    private Logger(Class<?> logClass) {
        void var1_1;
        this.logClass = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void info(String msg) {
        void var1_1;
        this.log(Level.INFO, (String)var1_1, null);
    }

    public abstract void log(Level var1, String var2, Throwable var3);

    private static class StdOutLogger
    extends Logger {
        /*
         * WARNING - void declaration
         */
        StdOutLogger(Class<?> clazz) {
            super((Class)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void log(Level level, String msg, Throwable thrown) {
            void var2_2;
            void var1_1;
            String time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date());
            System.out.printf("%s %s [%s] %s: %s%n", time, var1_1, Thread.currentThread().getName(), this.logClass.getSimpleName(), var2_2);
            if (thrown != null) {
                void var3_3;
                var3_3.printStackTrace(System.out);
            }
        }
    }

    private static class StdErrorLogger
    extends Logger {
        /*
         * WARNING - void declaration
         */
        StdErrorLogger(Class<?> clazz) {
            super((Class)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void log(Level level, String msg, Throwable thrown) {
            if (level == Level.SEVERE) {
                void var2_2;
                void var1_1;
                String time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date());
                System.err.printf("%s %s [%s] %s: %s%n", time, var1_1, Thread.currentThread().getName(), this.logClass.getSimpleName(), var2_2);
                if (thrown != null) {
                    void var3_3;
                    var3_3.printStackTrace();
                }
            }
        }
    }
}

