/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.util;

import com.alibaba.ttl.threadpool.agent.internal.javassist.CannotCompileException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.ClassPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtClass;
import com.alibaba.ttl.threadpool.agent.internal.javassist.NotFoundException;
import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.management.ManagementFactory;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class HotSwapAgent {
    private static Instrumentation instrumentation = null;

    public Instrumentation instrumentation() {
        return instrumentation;
    }

    /*
     * WARNING - void declaration
     */
    public static void premain(String agentArgs, Instrumentation inst) throws Throwable {
        void var1_1;
        HotSwapAgent.agentmain(agentArgs, (Instrumentation)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void agentmain(String agentArgs, Instrumentation inst) throws Throwable {
        void var1_1;
        if (!inst.isRedefineClassesSupported()) {
            throw new RuntimeException("this JVM does not support redefinition of classes");
        }
        instrumentation = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static void redefine(Class<?> oldClass, CtClass newClass) throws NotFoundException, IOException, CannotCompileException {
        void var1_1;
        Class[] classArray;
        Class[] old = new Class[]{oldClass};
        CtClass[] newClasses = new CtClass[]{newClass};
        HotSwapAgent.redefine(classArray, (CtClass[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void redefine(Class<?>[] oldClasses, CtClass[] newClasses) throws NotFoundException, IOException, CannotCompileException {
        HotSwapAgent.startAgent();
        ClassDefinition[] defs = new ClassDefinition[oldClasses.length];
        for (int i2 = 0; i2 < oldClasses.length; ++i2) {
            defs[i2] = new ClassDefinition(oldClasses[i2], newClasses[i2].toBytecode());
        }
        try {
            void var2_2;
            instrumentation.redefineClasses((ClassDefinition[])var2_2);
            return;
        }
        catch (ClassNotFoundException e2) {
            throw new NotFoundException(e2.getMessage(), e2);
        }
        catch (UnmodifiableClassException e3) {
            void var3_5;
            throw new CannotCompileException(e3.getMessage(), (Throwable)var3_5);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void startAgent() throws NotFoundException {
        if (instrumentation != null) {
            return;
        }
        try {
            void var1_3;
            File agentJar = HotSwapAgent.createJarFile();
            String nameOfRunningVM = ManagementFactory.getRuntimeMXBean().getName();
            nameOfRunningVM = nameOfRunningVM.substring(0, nameOfRunningVM.indexOf(64));
            VirtualMachine vm = VirtualMachine.attach(nameOfRunningVM);
            vm.loadAgent(agentJar.getAbsolutePath(), null);
            var1_3.detach();
        }
        catch (Exception e2) {
            throw new NotFoundException("hotswap agent", e2);
        }
        for (int sec = 0; sec < 10; ++sec) {
            if (instrumentation != null) {
                return;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        throw new NotFoundException("hotswap agent (timeout)");
    }

    public static File createAgentJarFile(String fileName) throws IOException, CannotCompileException, NotFoundException {
        String string;
        return HotSwapAgent.createJarFile(new File(string));
    }

    /*
     * WARNING - void declaration
     */
    private static File createJarFile() throws IOException, CannotCompileException, NotFoundException {
        void var0;
        File jar = File.createTempFile("agent", ".jar");
        jar.deleteOnExit();
        return HotSwapAgent.createJarFile((File)var0);
    }

    /*
     * WARNING - void declaration
     */
    private static File createJarFile(File jar2) throws IOException, CannotCompileException, NotFoundException {
        File file;
        Manifest manifest = new Manifest();
        Attributes attrs = manifest.getMainAttributes();
        attrs.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        attrs.put(new Attributes.Name("Premain-Class"), HotSwapAgent.class.getName());
        attrs.put(new Attributes.Name("Agent-Class"), HotSwapAgent.class.getName());
        attrs.put(new Attributes.Name("Can-Retransform-Classes"), "true");
        attrs.put(new Attributes.Name("Can-Redefine-Classes"), "true");
        JarOutputStream jos = null;
        try {
            void var1_2;
            ClassPool classPool;
            jos = new JarOutputStream((OutputStream)new FileOutputStream(jar2), manifest);
            String cname = HotSwapAgent.class.getName();
            JarEntry e2 = new JarEntry(cname.replace('.', '/') + ".class");
            jos.putNextEntry((ZipEntry)((Object)classPool));
            classPool = ClassPool.getDefault();
            CtClass clazz = classPool.get(cname);
            jos.write(var1_2.toBytecode());
            jos.closeEntry();
        }
        catch (Throwable jar2) {
            if (jos != null) {
                void var2_3;
                var2_3.close();
            }
            throw jar2;
        }
        jos.close();
        return file;
    }
}

