/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.tools.reflect;

import com.alibaba.ttl.threadpool.agent.internal.javassist.CannotCompileException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.ClassPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CodeConverter;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtClass;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtField;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtMember;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtMethod;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtNewMethod;
import com.alibaba.ttl.threadpool.agent.internal.javassist.Modifier;
import com.alibaba.ttl.threadpool.agent.internal.javassist.NotFoundException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.Translator;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.BadBytecode;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ClassFile;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.MethodInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.tools.reflect.CannotReflectException;
import java.util.Iterator;

public class Reflection
implements Translator {
    static final String classobjectField = "_classobject";
    static final String classobjectAccessor = "_getClass";
    static final String metaobjectField = "_metaobject";
    static final String metaobjectGetter = "_getMetaobject";
    static final String metaobjectSetter = "_setMetaobject";
    static final String readPrefix = "_r_";
    static final String writePrefix = "_w_";
    static final String metaobjectClassName = "com.alibaba.ttl.threadpool.agent.internal.javassist.tools.reflect.Metaobject";
    static final String classMetaobjectClassName = "com.alibaba.ttl.threadpool.agent.internal.javassist.tools.reflect.ClassMetaobject";
    protected CtMethod trapMethod;
    protected CtMethod trapStaticMethod;
    protected CtMethod trapRead;
    protected CtMethod trapWrite;
    protected CtClass[] readParam;
    protected ClassPool classPool = null;
    protected CodeConverter converter = new CodeConverter();

    /*
     * WARNING - void declaration
     */
    private boolean isExcluded(String name) {
        void var1_1;
        return name.startsWith("_m_") || name.equals(classobjectAccessor) || name.equals(metaobjectSetter) || name.equals(metaobjectGetter) || name.startsWith(readPrefix) || var1_1.startsWith(writePrefix);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void start(ClassPool pool) throws NotFoundException {
        this.classPool = pool;
        try {
            void var1_1;
            CtClass c2 = this.classPool.get("com.alibaba.ttl.threadpool.agent.internal.javassist.tools.reflect.Sample");
            this.rebuildClassFile(c2.getClassFile());
            this.trapMethod = c2.getDeclaredMethod("trap");
            this.trapStaticMethod = c2.getDeclaredMethod("trapStatic");
            this.trapRead = c2.getDeclaredMethod("trapRead");
            this.trapWrite = var1_1.getDeclaredMethod("trapWrite");
            this.readParam = new CtClass[]{this.classPool.get("java.lang.Object")};
            return;
        }
        catch (NotFoundException notFoundException) {
            throw new RuntimeException("com.alibaba.ttl.threadpool.agent.internal.javassist.tools.reflect.Sample is not found or broken.");
        }
        catch (BadBytecode badBytecode) {
            throw new RuntimeException("com.alibaba.ttl.threadpool.agent.internal.javassist.tools.reflect.Sample is not found or broken.");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onLoad(ClassPool pool, String classname) throws CannotCompileException, NotFoundException {
        void var2_2;
        CtClass ctClass = pool.get((String)var2_2);
        ctClass.instrument(this.converter);
    }

    /*
     * WARNING - void declaration
     */
    public boolean makeReflective(String classname, String metaobject, String metaclass) throws CannotCompileException, NotFoundException {
        void var3_3;
        void var2_2;
        void var1_1;
        Reflection reflection = this;
        return reflection.makeReflective(reflection.classPool.get((String)var1_1), this.classPool.get((String)var2_2), this.classPool.get((String)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public boolean makeReflective(Class<?> clazz, Class<?> metaobject, Class<?> metaclass) throws CannotCompileException, NotFoundException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.makeReflective(var1_1.getName(), var2_2.getName(), var3_3.getName());
    }

    /*
     * WARNING - void declaration
     */
    public boolean makeReflective(CtClass clazz, CtClass metaobject, CtClass metaclass) throws CannotCompileException, CannotReflectException, NotFoundException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (clazz.isInterface()) {
            throw new CannotReflectException("Cannot reflect an interface: " + clazz.getName());
        }
        if (clazz.subclassOf(this.classPool.get(classMetaobjectClassName))) {
            throw new CannotReflectException("Cannot reflect a subclass of ClassMetaobject: " + clazz.getName());
        }
        if (clazz.subclassOf(this.classPool.get(metaobjectClassName))) {
            throw new CannotReflectException("Cannot reflect a subclass of Metaobject: " + clazz.getName());
        }
        this.registerReflectiveClass(clazz);
        return this.modifyClassfile((CtClass)var1_1, (CtClass)var2_2, (CtClass)var3_3);
    }

    private void registerReflectiveClass(CtClass clazz) {
        CtField[] fs = clazz.getDeclaredFields();
        for (int i2 = 0; i2 < fs.length; ++i2) {
            CtField f2 = fs[i2];
            int mod = ((CtMember)f2).getModifiers();
            if ((mod & 1) == 0 || (mod & 0x10) != 0) continue;
            String name = ((CtMember)f2).getName();
            this.converter.replaceFieldRead(f2, clazz, readPrefix + name);
            this.converter.replaceFieldWrite(f2, clazz, writePrefix + name);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean modifyClassfile(CtClass clazz, CtClass metaobject, CtClass metaclass) throws CannotCompileException, NotFoundException {
        void var1_1;
        void var3_3;
        CtField f2;
        if (clazz.getAttribute("Reflective") != null) {
            return false;
        }
        clazz.setAttribute("Reflective", new byte[0]);
        CtClass mlevel = this.classPool.get("com.alibaba.ttl.threadpool.agent.internal.javassist.tools.reflect.Metalevel");
        boolean addMeta = !clazz.subtypeOf(mlevel);
        if (addMeta) {
            clazz.addInterface(mlevel);
        }
        this.processMethods(clazz, addMeta);
        this.processFields(clazz);
        if (addMeta) {
            void var2_2;
            f2 = new CtField(this.classPool.get(metaobjectClassName), metaobjectField, clazz);
            ((CtMember)f2).setModifiers(4);
            clazz.addField(f2, CtField.Initializer.byNewWithParams((CtClass)var2_2));
            clazz.addMethod(CtNewMethod.getter(metaobjectGetter, f2));
            clazz.addMethod(CtNewMethod.setter(metaobjectSetter, f2));
        }
        f2 = new CtField(this.classPool.get(classMetaobjectClassName), classobjectField, clazz);
        ((CtMember)f2).setModifiers(10);
        clazz.addField(f2, CtField.Initializer.byNew((CtClass)var3_3, new String[]{clazz.getName()}));
        var1_1.addMethod(CtNewMethod.getter(classobjectAccessor, f2));
        return true;
    }

    private void processMethods(CtClass clazz, boolean dontSearch) throws CannotCompileException, NotFoundException {
        CtMethod[] ms = clazz.getMethods();
        for (int i2 = 0; i2 < ms.length; ++i2) {
            CtMethod m2 = ms[i2];
            int mod = ((CtMember)m2).getModifiers();
            if (!Modifier.isPublic(mod) || Modifier.isAbstract(mod)) continue;
            this.processMethods0(mod, clazz, m2, i2, dontSearch);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processMethods0(int mod, CtClass clazz, CtMethod m2, int identifier, boolean dontSearch) throws CannotCompileException, NotFoundException {
        void var3_3;
        void var2_2;
        void var1_1;
        CtMethod m32;
        String name = ((CtMember)m2).getName();
        if (this.isExcluded(name)) {
            return;
        }
        if (m2.getDeclaringClass() == clazz) {
            if (Modifier.isNative(mod)) {
                return;
            }
            m32 = m2;
            if (Modifier.isFinal(mod)) {
                ((CtMember)m32).setModifiers(mod &= 0xFFFFFFEF);
            }
        } else {
            void m32;
            if (Modifier.isFinal(mod)) {
                return;
            }
            m32 = CtNewMethod.delegator(this.findOriginal(m2, (boolean)m32), clazz);
            ((CtMember)m32).setModifiers(mod &= 0xFFFFFEFF);
            clazz.addMethod(m32);
        }
        m32.setName("_m_" + identifier + "_" + name);
        CtMethod body = Modifier.isStatic(mod) ? this.trapStaticMethod : this.trapMethod;
        CtMethod wmethod = CtNewMethod.wrapped(m2.getReturnType(), name, m2.getParameterTypes(), m2.getExceptionTypes(), body, CtMethod.ConstParameter.integer(identifier), clazz);
        ((CtMember)wmethod).setModifiers((int)var1_1);
        var2_2.addMethod((CtMethod)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private CtMethod findOriginal(CtMethod m2, boolean dontSearch) throws NotFoundException {
        void var1_1;
        if (dontSearch) {
            return m2;
        }
        String name = ((CtMember)m2).getName();
        CtMethod[] ms = m2.getDeclaringClass().getDeclaredMethods();
        for (int i2 = 0; i2 < ms.length; ++i2) {
            String orgName = ((CtMember)ms[i2]).getName();
            if (!orgName.endsWith(name) || !orgName.startsWith("_m_") || !((CtMember)ms[i2]).getSignature().equals(((CtMember)m2).getSignature())) continue;
            return ms[i2];
        }
        return var1_1;
    }

    private void processFields(CtClass clazz) throws CannotCompileException, NotFoundException {
        CtField[] fs = clazz.getDeclaredFields();
        for (int i2 = 0; i2 < fs.length; ++i2) {
            CtField f2 = fs[i2];
            int mod = ((CtMember)f2).getModifiers();
            if ((mod & 1) == 0 || (mod & 0x10) != 0) continue;
            String name = ((CtMember)f2).getName();
            CtClass ftype = f2.getType();
            CtMethod wmethod = CtNewMethod.wrapped(ftype, readPrefix + name, this.readParam, null, this.trapRead, CtMethod.ConstParameter.string(name), clazz);
            ((CtMember)wmethod).setModifiers(mod |= 8);
            clazz.addMethod(wmethod);
            CtClass[] ctClassArray = new CtClass[2];
            CtClass[] writeParam = ctClassArray;
            ctClassArray[0] = this.classPool.get("java.lang.Object");
            writeParam[1] = ftype;
            CtMethod ctMethod = CtNewMethod.wrapped(CtClass.voidType, writePrefix + name, writeParam, null, this.trapWrite, CtMethod.ConstParameter.string(name), clazz);
            ((CtMember)ctMethod).setModifiers(mod);
            clazz.addMethod(ctMethod);
        }
    }

    public void rebuildClassFile(ClassFile cf) throws BadBytecode {
        Iterator<MethodInfo> iterator2;
        if (ClassFile.MAJOR_VERSION < 50) {
            return;
        }
        for (MethodInfo methodInfo : ((ClassFile)((Object)iterator2)).getMethods()) {
            methodInfo.rebuildStackMap(this.classPool);
        }
    }
}

