/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.tools.reflect;

import com.alibaba.ttl.threadpool.agent.internal.javassist.tools.reflect.CannotCreateException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.tools.reflect.CannotInvokeException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;

public class ClassMetaobject
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final String methodPrefix = "_m_";
    static final int methodPrefixLen = 3;
    private Class<?> javaClass;
    private Constructor<?>[] constructors;
    private Method[] methods;
    public static boolean useContextClassLoader = false;

    /*
     * WARNING - void declaration
     */
    public ClassMetaobject(String[] params) {
        try {
            this.javaClass = this.getClassObject(params[0]);
        }
        catch (ClassNotFoundException e2) {
            void var2_2;
            void var1_1;
            throw new RuntimeException("not found: " + (String)var1_1[0] + ", useContextClassLoader: " + Boolean.toString(useContextClassLoader), (Throwable)var2_2);
        }
        this.constructors = this.javaClass.getConstructors();
        this.methods = null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.javaClass.getName());
    }

    /*
     * WARNING - void declaration
     */
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        void var1_1;
        this.javaClass = this.getClassObject(var1_1.readUTF());
        this.constructors = this.javaClass.getConstructors();
        this.methods = null;
    }

    /*
     * WARNING - void declaration
     */
    private Class<?> getClassObject(String name) throws ClassNotFoundException {
        void var1_1;
        if (useContextClassLoader) {
            return Thread.currentThread().getContextClassLoader().loadClass(name);
        }
        return Class.forName((String)var1_1);
    }

    public final Class<?> getJavaClass() {
        return this.javaClass;
    }

    public final String getName() {
        return this.javaClass.getName();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isInstance(Object obj) {
        void var1_1;
        return this.javaClass.isInstance(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final Object newInstance(Object[] args2) throws CannotCreateException {
        int n2 = this.constructors.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                return this.constructors[i2].newInstance(args2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            catch (InstantiationException e2) {
                throw new CannotCreateException(e2);
            }
            catch (IllegalAccessException e3) {
                throw new CannotCreateException(e3);
            }
            catch (InvocationTargetException e4) {
                void var1_4;
                throw new CannotCreateException((Exception)var1_4);
            }
        }
        throw new CannotCreateException("no constructor matches");
    }

    /*
     * WARNING - void declaration
     */
    public Object trapFieldRead(String name) {
        Class<?> jc = this.getJavaClass();
        try {
            void var2_4;
            return var2_4.getField(name).get(null);
        }
        catch (NoSuchFieldException e2) {
            throw new RuntimeException(e2.toString());
        }
        catch (IllegalAccessException e3) {
            void var1_3;
            throw new RuntimeException(var1_3.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void trapFieldWrite(String name, Object value) {
        Class<?> jc = this.getJavaClass();
        try {
            void var2_4;
            void var3_5;
            var3_5.getField(name).set(null, var2_4);
            return;
        }
        catch (NoSuchFieldException e2) {
            throw new RuntimeException(e2.toString());
        }
        catch (IllegalAccessException e3) {
            void var1_3;
            throw new RuntimeException(var1_3.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Object invoke(Object target, int identifier, Object[] args2) throws Throwable {
        Method[] allmethods = target.getClass().getMethods();
        int n2 = allmethods.length;
        String head = methodPrefix + identifier;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!allmethods[i2].getName().startsWith(head)) continue;
            try {
                return allmethods[i2].invoke(target, args2);
            }
            catch (InvocationTargetException invocationTargetException) {
                target = invocationTargetException;
                throw invocationTargetException.getTargetException();
            }
            catch (IllegalAccessException e2) {
                void var0_1;
                throw new CannotInvokeException((IllegalAccessException)var0_1);
            }
        }
        throw new CannotInvokeException("cannot find a method");
    }

    /*
     * WARNING - void declaration
     */
    public Object trapMethodcall(int identifier, Object[] args2) throws Throwable {
        try {
            void var2_2;
            void var1_1;
            Method[] methodArray = this.getReflectiveMethods();
            return methodArray[var1_1].invoke(null, (Object[])var2_2);
        }
        catch (InvocationTargetException invocationTargetException) {
            InvocationTargetException invocationTargetException2 = invocationTargetException;
            throw invocationTargetException.getTargetException();
        }
        catch (IllegalAccessException e2) {
            void var3_5;
            throw new CannotInvokeException((IllegalAccessException)var3_5);
        }
    }

    public final Method[] getReflectiveMethods() {
        int i2;
        if (this.methods != null) {
            return this.methods;
        }
        Class<?> clazz = this.getJavaClass();
        Method[] allmethods = clazz.getDeclaredMethods();
        int n2 = allmethods.length;
        int[] index = new int[n2];
        int max = 0;
        for (i2 = 0; i2 < n2; ++i2) {
            char c2;
            Method method = allmethods[i2];
            String mname = method.getName();
            if (!mname.startsWith(methodPrefix)) continue;
            int k2 = 0;
            int j2 = 3;
            while ('0' <= (c2 = mname.charAt(j2)) && c2 <= '9') {
                k2 = k2 * 10 + c2 - 48;
                ++j2;
            }
            index[i2] = ++k2;
            if (k2 <= max) continue;
            max = k2;
        }
        this.methods = new Method[max];
        for (i2 = 0; i2 < n2; ++i2) {
            if (index[i2] <= 0) continue;
            this.methods[index[i2] - 1] = allmethods[i2];
        }
        return this.methods;
    }

    /*
     * WARNING - void declaration
     */
    public final Method getMethod(int identifier) {
        void var1_1;
        return this.getReflectiveMethods()[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public final String getMethodName(int identifier) {
        void var2_3;
        void var1_2;
        void var3_4;
        char c2;
        String mname = this.getReflectiveMethods()[identifier].getName();
        int j2 = 3;
        while ((c2 = mname.charAt(j2++)) >= '0' && 57 >= var3_4) {
        }
        return var1_2.substring((int)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    public final Class<?>[] getParameterTypes(int identifier) {
        void var1_1;
        return this.getReflectiveMethods()[var1_1].getParameterTypes();
    }

    /*
     * WARNING - void declaration
     */
    public final Class<?> getReturnType(int identifier) {
        void var1_1;
        return this.getReflectiveMethods()[var1_1].getReturnType();
    }

    /*
     * WARNING - void declaration
     */
    public final int getMethodIndex(String originalName, Class<?>[] argTypes) throws NoSuchMethodException {
        void var1_1;
        Method[] mthds = this.getReflectiveMethods();
        for (int i2 = 0; i2 < mthds.length; ++i2) {
            if (mthds[i2] == null || !this.getMethodName(i2).equals(originalName) || !Arrays.equals(argTypes, mthds[i2].getParameterTypes())) continue;
            return i2;
        }
        throw new NoSuchMethodException("Method " + (String)var1_1 + " not found");
    }
}

