/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.expr;

import com.alibaba.ttl.threadpool.agent.internal.javassist.CannotCompileException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtBehavior;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtClass;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtPrimitiveType;
import com.alibaba.ttl.threadpool.agent.internal.javassist.NotFoundException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.BadBytecode;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.Bytecode;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.CodeAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.CodeIterator;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ConstPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.Descriptor;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.MethodInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.CompileError;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.Javac;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.JvstCodeGen;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.JvstTypeChecker;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.MemberCodeGen;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ProceedHandler;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.ASTList;
import com.alibaba.ttl.threadpool.agent.internal.javassist.expr.Expr;

public class NewArray
extends Expr {
    int opcode;

    /*
     * WARNING - void declaration
     */
    protected NewArray(int pos, CodeIterator i2, CtClass declaring, MethodInfo m2, int op) {
        super((int)var1_1, (CodeIterator)var2_2, (CtClass)var3_3, m2);
        void var3_3;
        void var2_2;
        void var1_1;
        this.opcode = op;
    }

    @Override
    public CtBehavior where() {
        return super.where();
    }

    @Override
    public int getLineNumber() {
        return super.getLineNumber();
    }

    @Override
    public String getFileName() {
        return super.getFileName();
    }

    @Override
    public CtClass[] mayThrow() {
        return super.mayThrow();
    }

    /*
     * WARNING - void declaration
     */
    public CtClass getComponentType() throws NotFoundException {
        if (this.opcode == 188) {
            int atype = this.iterator.byteAt(this.currentPos + 1);
            return this.getPrimitiveType(atype);
        }
        if (this.opcode == 189 || this.opcode == 197) {
            void var2_4;
            String string;
            int index = this.iterator.u16bitAt(this.currentPos + 1);
            String desc = this.getConstPool().getClassInfo(index);
            int dim = Descriptor.arrayDimension(desc);
            string = Descriptor.toArrayComponent(string, (int)var2_4);
            return Descriptor.toCtClass(string, this.thisClass.getClassPool());
        }
        throw new RuntimeException("bad opcode: " + this.opcode);
    }

    /*
     * WARNING - void declaration
     */
    CtClass getPrimitiveType(int atype) {
        void var1_1;
        switch (atype) {
            case 4: {
                return CtClass.booleanType;
            }
            case 5: {
                return CtClass.charType;
            }
            case 6: {
                return CtClass.floatType;
            }
            case 7: {
                return CtClass.doubleType;
            }
            case 8: {
                return CtClass.byteType;
            }
            case 9: {
                return CtClass.shortType;
            }
            case 10: {
                return CtClass.intType;
            }
            case 11: {
                return CtClass.longType;
            }
        }
        throw new RuntimeException("bad atype: " + (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public int getDimension() {
        if (this.opcode == 188) {
            return 1;
        }
        if (this.opcode == 189 || this.opcode == 197) {
            void var1_1;
            int index = this.iterator.u16bitAt(this.currentPos + 1);
            String string = this.getConstPool().getClassInfo((int)var1_1);
            return Descriptor.arrayDimension(string) + (this.opcode == 189 ? 1 : 0);
        }
        throw new RuntimeException("bad opcode: " + this.opcode);
    }

    public int getCreatedDimensions() {
        if (this.opcode == 197) {
            return this.iterator.byteAt(this.currentPos + 3);
        }
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void replace(String statement) throws CannotCompileException {
        try {
            this.replace2(statement);
            return;
        }
        catch (CompileError e2) {
            throw new CannotCompileException(e2);
        }
        catch (NotFoundException e3) {
            void var1_3;
            throw new CannotCompileException((NotFoundException)var1_3);
        }
        catch (BadBytecode badBytecode) {
            throw new CannotCompileException("broken method");
        }
    }

    /*
     * WARNING - void declaration
     */
    private void replace2(String statement) throws CompileError, NotFoundException, BadBytecode, CannotCompileException {
        void var2_2;
        void var3_3;
        void var1_1;
        int codeLength;
        String desc;
        int index;
        this.thisClass.getClassFile();
        ConstPool constPool = this.getConstPool();
        int pos = this.currentPos;
        int dim = 1;
        if (this.opcode == 188) {
            index = this.iterator.byteAt(this.currentPos + 1);
            CtPrimitiveType cpt = (CtPrimitiveType)this.getPrimitiveType(index);
            desc = "[" + cpt.getDescriptor();
            codeLength = 2;
        } else if (this.opcode == 189) {
            index = this.iterator.u16bitAt(pos + 1);
            desc = (desc = ((ConstPool)((Object)desc)).getClassInfo(index)).startsWith("[") ? "[" + desc : "[L" + desc + ";";
            codeLength = 3;
        } else if (this.opcode == 197) {
            index = this.iterator.u16bitAt(this.currentPos + 1);
            desc = ((ConstPool)((Object)desc)).getClassInfo(index);
            dim = this.iterator.byteAt(this.currentPos + 3);
            codeLength = 4;
        } else {
            throw new RuntimeException("bad opcode: " + this.opcode);
        }
        CtClass retType = Descriptor.toCtClass(desc, this.thisClass.getClassPool());
        Javac jc = new Javac(this.thisClass);
        CodeAttribute ca = this.iterator.get();
        CtClass[] params = new CtClass[dim];
        for (int i2 = 0; i2 < dim; ++i2) {
            params[i2] = CtClass.intType;
        }
        int paramVar = ca.getMaxLocals();
        jc.recordParams("java.lang.Object", params, true, paramVar, this.withinStatic());
        NewArray.checkResultValue(retType, statement);
        int retVar = jc.recordReturnType(retType, true);
        jc.recordProceed(new ProceedForArray(retType, this.opcode, index, dim));
        Bytecode bytecode = jc.getBytecode();
        NewArray.storeStack(params, true, paramVar, bytecode);
        jc.recordLocalVariables(ca, pos);
        bytecode.addOpcode(1);
        bytecode.addAstore(retVar);
        jc.compileStmnt((String)var1_1);
        bytecode.addAload(retVar);
        this.replace0((int)var3_3, (Bytecode)var2_2, codeLength);
    }

    static class ProceedForArray
    implements ProceedHandler {
        CtClass arrayType;
        int opcode;
        int index;
        int dimension;

        /*
         * WARNING - void declaration
         */
        ProceedForArray(CtClass type, int op, int i2, int dim) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.arrayType = var1_1;
            this.opcode = var2_2;
            this.index = var3_3;
            this.dimension = dim;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void doit(JvstCodeGen gen, Bytecode bytecode, ASTList args2) throws CompileError {
            void var1_1;
            void var3_3;
            int num = ((MemberCodeGen)gen).getMethodArgsLength(args2);
            if (num != this.dimension) {
                throw new CompileError("$proceed() with a wrong number of parameters");
            }
            ((MemberCodeGen)gen).atMethodArgs((ASTList)var3_3, new int[num], new int[num], new String[num]);
            bytecode.addOpcode(this.opcode);
            if (this.opcode == 189) {
                bytecode.addIndex(this.index);
            } else if (this.opcode == 188) {
                bytecode.add(this.index);
            } else {
                void var2_2;
                bytecode.addIndex(this.index);
                bytecode.add(this.dimension);
                var2_2.growStack(1 - this.dimension);
            }
            var1_1.setType(this.arrayType);
        }

        @Override
        public void setReturnType(JvstTypeChecker c2, ASTList args2) throws CompileError {
            c2.setType(this.arrayType);
        }
    }
}

