/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.expr;

import com.alibaba.ttl.threadpool.agent.internal.javassist.CannotCompileException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.ClassPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtBehavior;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtClass;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtConstructor;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtPrimitiveType;
import com.alibaba.ttl.threadpool.agent.internal.javassist.NotFoundException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.BadBytecode;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.Bytecode;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ClassFile;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.CodeAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.CodeIterator;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ConstPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ExceptionTable;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ExceptionsAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.MethodInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.Opcode;
import com.alibaba.ttl.threadpool.agent.internal.javassist.expr.ExprEditor;
import java.util.LinkedList;
import java.util.List;

public abstract class Expr
implements Opcode {
    int currentPos;
    CodeIterator iterator;
    CtClass thisClass;
    MethodInfo thisMethod;
    boolean edited;
    int maxLocals;
    int maxStack;
    static final String javaLangObject = "java.lang.Object";

    /*
     * WARNING - void declaration
     */
    protected Expr(int pos, CodeIterator i2, CtClass declaring, MethodInfo m2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.currentPos = var1_1;
        this.iterator = var2_2;
        this.thisClass = var3_3;
        this.thisMethod = m2;
    }

    public CtClass getEnclosingClass() {
        return this.thisClass;
    }

    protected final ConstPool getConstPool() {
        return this.thisMethod.getConstPool();
    }

    protected final boolean edited() {
        return this.edited;
    }

    protected final int locals() {
        return this.maxLocals;
    }

    protected final int stack() {
        return this.maxStack;
    }

    protected final boolean withinStatic() {
        return (this.thisMethod.getAccessFlags() & 8) != 0;
    }

    /*
     * WARNING - void declaration
     */
    public CtBehavior where() {
        MethodInfo mi = this.thisMethod;
        CtBehavior[] cb = this.thisClass.getDeclaredBehaviors();
        for (int i2 = cb.length - 1; i2 >= 0; --i2) {
            if (cb[i2].getMethodInfo2() != mi) continue;
            return cb[i2];
        }
        CtConstructor init = this.thisClass.getClassInitializer();
        if (init != null && init.getMethodInfo2() == mi) {
            void var3_5;
            return var3_5;
        }
        for (int i3 = cb.length - 1; i3 >= 0; --i3) {
            if (!this.thisMethod.getName().equals(cb[i3].getMethodInfo2().getName()) || !this.thisMethod.getDescriptor().equals(cb[i3].getMethodInfo2().getDescriptor())) continue;
            return cb[i3];
        }
        throw new RuntimeException("fatal: not found");
    }

    /*
     * WARNING - void declaration
     */
    public CtClass[] mayThrow() {
        void var3_3;
        String[] exceptions;
        ExceptionsAttribute ea;
        ClassPool pool = this.thisClass.getClassPool();
        ConstPool cp = this.thisMethod.getConstPool();
        LinkedList<CtClass> list = new LinkedList<CtClass>();
        try {
            CodeAttribute codeAttribute = this.thisMethod.getCodeAttribute();
            ExceptionTable et = codeAttribute.getExceptionTable();
            int pos = this.currentPos;
            int n2 = et.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                int t2;
                if (et.startPc(i2) > pos || pos >= et.endPc(i2) || (t2 = et.catchType(i2)) <= 0) continue;
                try {
                    Expr.addClass(list, pool.get(cp.getClassInfo(t2)));
                    continue;
                }
                catch (NotFoundException notFoundException) {}
            }
        }
        catch (NullPointerException nullPointerException) {}
        if ((ea = this.thisMethod.getExceptionsAttribute()) != null && (exceptions = ea.getExceptions()) != null) {
            int n3 = exceptions.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                try {
                    Expr.addClass(list, pool.get(exceptions[i3]));
                    continue;
                }
                catch (NotFoundException notFoundException) {}
            }
        }
        void v3 = var3_3;
        return v3.toArray(new CtClass[v3.size()]);
    }

    /*
     * WARNING - void declaration
     */
    private static void addClass(List<CtClass> list, CtClass c2) {
        void var1_1;
        List<CtClass> list2;
        if (list.contains(c2)) {
            return;
        }
        list2.add((CtClass)var1_1);
    }

    public int indexOfBytecode() {
        return this.currentPos;
    }

    public int getLineNumber() {
        return this.thisMethod.getLineNumber(this.currentPos);
    }

    /*
     * WARNING - void declaration
     */
    public String getFileName() {
        void var1_1;
        ClassFile cf = this.thisClass.getClassFile2();
        if (cf == null) {
            return null;
        }
        return var1_1.getSourceFile();
    }

    /*
     * WARNING - void declaration
     */
    static final boolean checkResultValue(CtClass retType, String prog) throws CannotCompileException {
        void var1_2;
        CtClass ctClass;
        boolean hasIt = prog.indexOf("$_") >= 0;
        if (!hasIt && ctClass != CtClass.voidType) {
            throw new CannotCompileException("the resulting value is not stored in $_");
        }
        return (boolean)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    static final void storeStack(CtClass[] params, boolean isStaticCall, int regno, Bytecode bytecode) {
        void var2_2;
        void var3_3;
        void var1_1;
        CtClass[] ctClassArray;
        Expr.storeStack0(0, params.length, ctClassArray, regno + 1, bytecode);
        if (var1_1 != false) {
            bytecode.addOpcode(1);
        }
        var3_3.addAstore((int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static void storeStack0(int i2, int n2, CtClass[] params, int regno, Bytecode bytecode) {
        void var3_3;
        void var2_2;
        void var1_1;
        int n3;
        if (i2 >= n2) {
            return;
        }
        CtClass c2 = params[i2];
        int size = c2 instanceof CtPrimitiveType ? ((CtPrimitiveType)c2).getDataSize() : 1;
        Expr.storeStack0(n3 + 1, (int)var1_1, (CtClass[])var2_2, regno + size, bytecode);
        bytecode.addStore((int)var3_3, c2);
    }

    public abstract void replace(String var1) throws CannotCompileException;

    /*
     * WARNING - void declaration
     */
    public void replace(String statement, ExprEditor recursive) throws CannotCompileException {
        void var1_1;
        this.replace((String)var1_1);
        if (recursive != null) {
            void var2_2;
            this.runEditor((ExprEditor)var2_2, this.iterator);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void replace0(int pos, Bytecode bytecode, int size) throws BadBytecode {
        void var2_2;
        void var1_1;
        byte[] code = bytecode.get();
        this.edited = true;
        int gap = code.length - size;
        for (int i2 = 0; i2 < size; ++i2) {
            this.iterator.writeByte(0, pos + i2);
        }
        if (gap > 0) {
            pos = this.iterator.insertGapAt((int)pos, (int)gap, (boolean)false).position;
        }
        this.iterator.write(code, pos);
        this.iterator.insert(bytecode.getExceptionTable(), (int)var1_1);
        this.maxLocals = bytecode.getMaxLocals();
        this.maxStack = var2_2.getMaxStack();
    }

    /*
     * WARNING - void declaration
     */
    protected void runEditor(ExprEditor ed, CodeIterator oldIterator) throws CannotCompileException {
        void var3_3;
        void var2_2;
        void var1_1;
        CodeAttribute codeAttr = oldIterator.get();
        int orgLocals = codeAttr.getMaxLocals();
        int orgStack = codeAttr.getMaxStack();
        int newLocals = this.locals();
        codeAttr.setMaxStack(this.stack());
        codeAttr.setMaxLocals(newLocals);
        ExprEditor.LoopContext context = new ExprEditor.LoopContext(newLocals);
        int size = oldIterator.getCodeLength();
        int endPos = oldIterator.lookAhead();
        oldIterator.move(this.currentPos);
        if (var1_1.doit(this.thisClass, this.thisMethod, context, oldIterator, endPos)) {
            this.edited = true;
        }
        oldIterator.move(endPos + var2_2.getCodeLength() - size);
        codeAttr.setMaxLocals(orgLocals);
        var3_3.setMaxStack(orgStack);
        this.maxLocals = context.maxLocals;
        this.maxStack += context.maxStack;
    }
}

