/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.compiler;

import com.alibaba.ttl.threadpool.agent.internal.javassist.ClassPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtClass;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtField;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtMember;
import com.alibaba.ttl.threadpool.agent.internal.javassist.Modifier;
import com.alibaba.ttl.threadpool.agent.internal.javassist.NotFoundException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.FieldInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.MethodInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.Opcode;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.CodeGen;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.CompileError;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.MemberResolver;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.NoFieldException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.TokenId;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.ASTList;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.ASTree;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.ArrayInit;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.AssignExpr;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.BinExpr;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.CallExpr;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.CastExpr;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.CondExpr;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.Declarator;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.DoubleConst;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.Expr;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.InstanceOfExpr;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.IntConst;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.Keyword;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.Member;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.NewExpr;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.StringL;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.Symbol;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.Variable;
import com.alibaba.ttl.threadpool.agent.internal.javassist.compiler.ast.Visitor;

public class TypeChecker
extends Visitor
implements Opcode,
TokenId {
    static final String javaLangObject = "java.lang.Object";
    static final String jvmJavaLangObject = "java/lang/Object";
    static final String jvmJavaLangString = "java/lang/String";
    static final String jvmJavaLangClass = "java/lang/Class";
    protected int exprType;
    protected int arrayDim;
    protected String className;
    protected MemberResolver resolver;
    protected CtClass thisClass;
    protected MethodInfo thisMethod;

    /*
     * WARNING - void declaration
     */
    public TypeChecker(CtClass cc, ClassPool cp) {
        void var1_1;
        void var2_2;
        this.resolver = new MemberResolver((ClassPool)var2_2);
        this.thisClass = var1_1;
        this.thisMethod = null;
    }

    /*
     * WARNING - void declaration
     */
    protected static String argTypesToString(int[] types, int[] dims, String[] cnames) {
        void var3_3;
        StringBuilder sbuf = new StringBuilder();
        sbuf.append('(');
        int n2 = types.length;
        if (n2 > 0) {
            int i2 = 0;
            while (true) {
                TypeChecker.typeToString(sbuf, types[i2], dims[i2], cnames[i2]);
                if (++i2 >= n2) break;
                sbuf.append(',');
            }
        }
        sbuf.append(')');
        return var3_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    protected static StringBuilder typeToString(StringBuilder sbuf, int type, int dim, String cname) {
        StringBuilder stringBuilder;
        void var1_2;
        void s22;
        String s22;
        if (type == 307) {
            void var3_4;
            s22 = MemberResolver.jvmToJavaName((String)var3_4);
        } else if (s22 == 412) {
            s22 = "Object";
        } else {
            try {
                s22 = MemberResolver.getTypeName((int)s22);
            }
            catch (CompileError compileError) {
                s22 = "?";
            }
        }
        sbuf.append((String)var1_2);
        while (dim-- > 0) {
            sbuf.append("[]");
        }
        return stringBuilder;
    }

    /*
     * WARNING - void declaration
     */
    public void setThisMethod(MethodInfo m2) {
        void var1_1;
        this.thisMethod = var1_1;
    }

    protected static void fatal() throws CompileError {
        throw new CompileError("fatal");
    }

    protected String getThisName() {
        return MemberResolver.javaToJvmName(this.thisClass.getName());
    }

    protected String getSuperName() throws CompileError {
        return MemberResolver.javaToJvmName(MemberResolver.getSuperclass(this.thisClass).getName());
    }

    /*
     * WARNING - void declaration
     */
    protected String resolveClassName(ASTList name) throws CompileError {
        void var1_1;
        return this.resolver.resolveClassName((ASTList)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected String resolveClassName(String jvmName) throws CompileError {
        void var1_1;
        return this.resolver.resolveJvmClassName((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void atNewExpr(NewExpr expr) throws CompileError {
        void var3_3;
        void var1_1;
        void var2_2;
        if (expr.isArray()) {
            this.atNewArrayExpr(expr);
            return;
        }
        CtClass clazz = this.resolver.lookupClassByName(expr.getClassName());
        String cname = clazz.getName();
        ASTList args2 = expr.getArguments();
        this.atMethodCallCore((CtClass)var2_2, "<init>", (ASTList)var1_1);
        this.exprType = 307;
        this.arrayDim = 0;
        this.className = MemberResolver.javaToJvmName((String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void atNewArrayExpr(NewExpr expr) throws CompileError {
        void var2_2;
        void var3_3;
        int type = expr.getArrayType();
        ASTList size = expr.getArraySize();
        ASTList classname = expr.getClassName();
        ArrayInit init = expr.getInitializer();
        if (init != null) {
            ((ASTree)init).accept(this);
        }
        if (size.length() > 1) {
            this.atMultiNewArray(type, classname, size);
            return;
        }
        ASTree sizeExpr = var3_3.head();
        if (sizeExpr != null) {
            void var1_1;
            var1_1.accept(this);
        }
        this.exprType = type;
        this.arrayDim = 1;
        if (var2_2 == 307) {
            this.className = this.resolveClassName(classname);
            return;
        }
        this.className = null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void atArrayInit(ArrayInit init) throws CompileError {
        for (ASTList list = init; list != null; list = list.tail()) {
            void var2_2;
            ASTree h2 = list.head();
            if (h2 == null) continue;
            var2_2.accept(this);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void atMultiNewArray(int type, ASTList classname, ASTList size) throws CompileError {
        void var1_1;
        ASTree s2;
        int dim = size.length();
        while (size != null && (s2 = size.head()) != null) {
            s2.accept(this);
            size = size.tail();
        }
        this.exprType = type;
        this.arrayDim = dim;
        if (var1_1 == 307) {
            void var2_2;
            this.className = this.resolveClassName((ASTList)var2_2);
            return;
        }
        this.className = null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void atAssignExpr(AssignExpr expr) throws CompileError {
        void var3_3;
        void var2_2;
        void var1_1;
        Expr expr2;
        int op = expr.getOperator();
        ASTree left = expr.oprand1();
        ASTree right = expr.oprand2();
        if (left instanceof Variable) {
            this.atVariableAssign(expr, op, (Variable)left, ((Variable)left).getDeclarator(), right);
            return;
        }
        if (left instanceof Expr && (expr2 = (Expr)left).getOperator() == 65) {
            this.atArrayAssign(expr, op, (Expr)left, right);
            return;
        }
        this.atFieldAssign((Expr)var1_1, (int)var2_2, (ASTree)var3_3, right);
    }

    /*
     * WARNING - void declaration
     */
    private void atVariableAssign(Expr expr, int op, Variable var, Declarator d2, ASTree right) throws CompileError {
        void var1_2;
        void var2_3;
        int varType = d2.getType();
        int varArray = d2.getArrayDim();
        String varClass = d2.getClassName();
        if (var2_3 != 61) {
            void var3_4;
            ((Visitor)this).atVariable((Variable)var3_4);
        }
        right.accept(this);
        this.exprType = var1_2;
        this.arrayDim = varArray;
        this.className = varClass;
    }

    /*
     * WARNING - void declaration
     */
    private void atArrayAssign(Expr expr, int op, Expr array, ASTree right) throws CompileError {
        void var3_4;
        void var2_3;
        void var1_2;
        this.atArrayRead(array.oprand1(), array.oprand2());
        int aType = this.exprType;
        int aDim = this.arrayDim;
        String cname = this.className;
        right.accept(this);
        this.exprType = var1_2;
        this.arrayDim = var2_3;
        this.className = var3_4;
    }

    /*
     * WARNING - void declaration
     */
    protected void atFieldAssign(Expr expr, int op, ASTree left, ASTree right) throws CompileError {
        void var3_4;
        void var2_3;
        void var1_2;
        CtField f2 = this.fieldAccess(left);
        this.atFieldRead(f2);
        int fType = this.exprType;
        int fDim = this.arrayDim;
        String cname = this.className;
        right.accept(this);
        this.exprType = var1_2;
        this.arrayDim = var2_3;
        this.className = var3_4;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void atCondExpr(CondExpr expr) throws CompileError {
        void var3_3;
        this.booleanExpr(expr.condExpr());
        expr.thenExpr().accept(this);
        int type1 = this.exprType;
        int dim1 = this.arrayDim;
        expr.elseExpr().accept(this);
        if (dim1 == 0 && var3_3 == this.arrayDim) {
            if (CodeGen.rightIsStrong(type1, this.exprType)) {
                expr.setThen(new CastExpr(this.exprType, 0, expr.thenExpr()));
                return;
            }
            if (CodeGen.rightIsStrong(this.exprType, type1)) {
                void var2_2;
                void var1_1;
                expr.setElse(new CastExpr(type1, 0, var1_1.elseExpr()));
                this.exprType = var2_2;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void atBinExpr(BinExpr expr) throws CompileError {
        void var1_1;
        int token = expr.getOperator();
        int n2 = CodeGen.lookupBinOp(token);
        if (n2 >= 0) {
            void var3_5;
            if (token == 43) {
                Expr e2 = this.atPlusExpr(expr);
                if (e2 != null) {
                    e2 = CallExpr.makeCall(Expr.make(46, (ASTree)e2, (ASTree)new Member("toString")), null);
                    expr.setOprand1(e2);
                    expr.setOprand2(null);
                    this.className = jvmJavaLangString;
                }
                return;
            }
            ASTree left = expr.oprand1();
            ASTree right = expr.oprand2();
            left.accept(this);
            int type1 = this.exprType;
            right.accept(this);
            if (!this.isConstant(expr, token, (ASTree)var3_5, right)) {
                void var2_2;
                this.computeBinExprType(expr, (int)var2_2, type1);
            }
            return;
        }
        this.booleanExpr((ASTree)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private Expr atPlusExpr(BinExpr expr) throws CompileError {
        void var1_1;
        ASTree left = expr.oprand1();
        ASTree right = expr.oprand2();
        if (right == null) {
            left.accept(this);
            return null;
        }
        if (TypeChecker.isPlusExpr(left)) {
            Expr newExpr = this.atPlusExpr((BinExpr)left);
            if (newExpr != null) {
                right.accept(this);
                this.exprType = 307;
                this.arrayDim = 0;
                this.className = "java/lang/StringBuffer";
                return TypeChecker.makeAppendCall(newExpr, right);
            }
        } else {
            left.accept(this);
        }
        int type1 = this.exprType;
        int dim1 = this.arrayDim;
        String cname = this.className;
        right.accept(this);
        if (this.isConstant(expr, 43, left, right)) {
            return null;
        }
        if (type1 == 307 && dim1 == 0 && jvmJavaLangString.equals(cname) || this.exprType == 307 && this.arrayDim == 0 && jvmJavaLangString.equals(this.className)) {
            void var3_3;
            void var2_2;
            ASTList sbufClass = ASTList.make(new Symbol("java"), new Symbol("lang"), new Symbol("StringBuffer"));
            NewExpr e2 = new NewExpr(sbufClass, null);
            this.exprType = 307;
            this.arrayDim = 0;
            this.className = "java/lang/StringBuffer";
            return TypeChecker.makeAppendCall(TypeChecker.makeAppendCall((ASTree)var1_1, (ASTree)var2_2), (ASTree)var3_3);
        }
        this.computeBinExprType((BinExpr)var1_1, 43, type1);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isConstant(BinExpr expr, int op, ASTree left, ASTree right) throws CompileError {
        void var1_1;
        left = TypeChecker.stripPlusExpr(left);
        right = TypeChecker.stripPlusExpr(right);
        ASTree newExpr = null;
        if (left instanceof StringL && right instanceof StringL && op == 43) {
            newExpr = new StringL(((StringL)left).get() + ((StringL)right).get());
        } else if (left instanceof IntConst) {
            newExpr = ((IntConst)left).compute(op, right);
        } else if (left instanceof DoubleConst) {
            void var2_2;
            void var3_3;
            newExpr = ((DoubleConst)var3_3).compute((int)var2_2, right);
        }
        if (newExpr == null) {
            return false;
        }
        expr.setOperator(43);
        expr.setOprand1(newExpr);
        var1_1.setOprand2(null);
        newExpr.accept(this);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    static ASTree stripPlusExpr(ASTree expr) {
        ASTree aSTree;
        ASTree cexpr;
        if (expr instanceof BinExpr) {
            BinExpr e2 = (BinExpr)expr;
            if (e2.getOperator() == 43 && e2.oprand2() == null) {
                return ((ASTree)e2).getLeft();
            }
        } else if (expr instanceof Expr) {
            void var2_4;
            ASTree cexpr2;
            Expr e3 = (Expr)expr;
            int op = e3.getOperator();
            if (op == 35) {
                cexpr2 = TypeChecker.getConstantFieldValue((Member)e3.oprand2());
                if (cexpr2 != null) {
                    return cexpr2;
                }
            } else if (var2_4 == 43 && cexpr2.getRight() == null) {
                return cexpr2.getLeft();
            }
        } else if (expr instanceof Member && (cexpr = TypeChecker.getConstantFieldValue((Member)expr)) != null) {
            void var1_3;
            return var1_3;
        }
        return aSTree;
    }

    private static ASTree getConstantFieldValue(Member mem) {
        return TypeChecker.getConstantFieldValue(mem.getField());
    }

    /*
     * WARNING - void declaration
     */
    public static ASTree getConstantFieldValue(CtField f2) {
        if (f2 == null) {
            return null;
        }
        Object value = f2.getConstantValue();
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return new StringL((String)value);
        }
        if (value instanceof Double || value instanceof Float) {
            int token = value instanceof Double ? 405 : 404;
            return new DoubleConst(((Number)value).doubleValue(), token);
        }
        if (value instanceof Number) {
            void var1_2;
            int token = value instanceof Long ? 403 : 402;
            return new IntConst(((Number)value).longValue(), (int)var1_2);
        }
        if (value instanceof Boolean) {
            Object object;
            return new Keyword((Boolean)object != false ? 410 : 411);
        }
        return null;
    }

    private static boolean isPlusExpr(ASTree expr) {
        if (expr instanceof BinExpr) {
            ASTree aSTree;
            int n2 = ((Expr)(aSTree = (BinExpr)aSTree)).getOperator();
            return n2 == 43;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static Expr makeAppendCall(ASTree target, ASTree arg) {
        void var1_1;
        ASTree aSTree;
        return CallExpr.makeCall(Expr.make(46, aSTree, (ASTree)new Member("append")), new ASTList((ASTree)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private void computeBinExprType(BinExpr expr, int token, int type1) throws CompileError {
        void var2_2;
        int type2 = this.exprType;
        if (token == 364 || token == 366 || var2_2 == 370) {
            this.exprType = type1;
        } else {
            void var3_3;
            void var1_1;
            this.insertCast((BinExpr)var1_1, (int)var3_3, type2);
        }
        if (CodeGen.isP_INT(this.exprType) && this.exprType != 301) {
            this.exprType = 324;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void booleanExpr(ASTree expr) throws CompileError {
        void var1_1;
        void var2_2;
        BinExpr bexpr;
        int op = CodeGen.getCompOperator(expr);
        if (op == 358) {
            void var3_3;
            bexpr = (BinExpr)expr;
            bexpr.oprand1().accept(this);
            int type1 = this.exprType;
            int dim1 = this.arrayDim;
            bexpr.oprand2().accept(this);
            if (var3_3 == false && this.arrayDim == 0) {
                this.insertCast(bexpr, (int)var2_2, this.exprType);
            }
        } else if (var2_2 == 33) {
            ((Expr)bexpr).oprand1().accept(this);
        } else if (var2_2 == 369 || var2_2 == 368) {
            bexpr.oprand1().accept(this);
            var1_1.oprand2().accept(this);
        } else {
            var1_1.accept(this);
        }
        this.exprType = 301;
        this.arrayDim = 0;
    }

    /*
     * WARNING - void declaration
     */
    private void insertCast(BinExpr expr, int type1, int type2) throws CompileError {
        void var2_2;
        if (CodeGen.rightIsStrong(type1, type2)) {
            void var1_1;
            void var3_3;
            ((ASTree)expr).setLeft(new CastExpr((int)var3_3, 0, var1_1.oprand1()));
            return;
        }
        this.exprType = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void atCastExpr(CastExpr expr) throws CompileError {
        void var2_2;
        void var1_1;
        String cname = this.resolveClassName(expr.getClassName());
        expr.getOprand().accept(this);
        this.exprType = expr.getType();
        this.arrayDim = var1_1.getArrayDim();
        this.className = var2_2;
    }

    @Override
    public void atInstanceOfExpr(InstanceOfExpr expr) throws CompileError {
        expr.getOprand().accept(this);
        this.exprType = 301;
        this.arrayDim = 0;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void atExpr(Expr expr) throws CompileError {
        void var3_5;
        void var1_1;
        void var2_2;
        int token = expr.getOperator();
        ASTree oprand = expr.oprand1();
        if (token == 46) {
            void var2_3;
            String member = ((Symbol)expr.oprand2()).get();
            if (member.equals("length")) {
                try {
                    this.atArrayLength(expr);
                    return;
                }
                catch (NoFieldException noFieldException) {}
            } else if (var2_3.equals("class")) {
                this.atClassObject(expr);
                return;
            }
            this.atFieldRead(expr);
            return;
        }
        if (var2_2 == 35) {
            String string = ((Symbol)expr.oprand2()).get();
            if (string.equals("class")) {
                this.atClassObject(expr);
                return;
            }
            this.atFieldRead(expr);
            return;
        }
        if (var2_2 == 65) {
            this.atArrayRead(oprand, expr.oprand2());
            return;
        }
        if (var2_2 == 362 || var2_2 == 363) {
            this.atPlusPlus((int)var2_2, oprand, expr);
            return;
        }
        if (var2_2 == 33) {
            this.booleanExpr(expr);
            return;
        }
        if (var2_2 == 67) {
            TypeChecker.fatal();
            return;
        }
        oprand.accept(this);
        if (this.isConstant((Expr)var1_1, (int)var2_2, (ASTree)var3_5)) return;
        if (var2_2 != 45) {
            if (var2_2 != 126) return;
        }
        if (!CodeGen.isP_INT(this.exprType)) return;
        this.exprType = 324;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isConstant(Expr expr, int op, ASTree oprand) {
        void var1_1;
        ASTree c2;
        if ((oprand = TypeChecker.stripPlusExpr(oprand)) instanceof IntConst) {
            c2 = (IntConst)oprand;
            long v2 = ((IntConst)c2).get();
            if (op == 45) {
                v2 = -v2;
            } else {
                if (op != 126) return false;
                v2 ^= 0xFFFFFFFFFFFFFFFFL;
            }
            ((IntConst)c2).set(v2);
        } else {
            void var3_3;
            void var2_2;
            if (!(c2 instanceof DoubleConst)) return false;
            c2 = (DoubleConst)c2;
            if (var2_2 != 45) return false;
            void v0 = var3_3;
            v0.set(-v0.get());
        }
        var1_1.setOperator(43);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void atCallExpr(CallExpr expr) throws CompileError {
        void var1_1;
        void var2_2;
        void var3_3;
        String mname = null;
        CtClass targetClass = null;
        ASTree method = expr.oprand1();
        ASTList args2 = (ASTList)expr.oprand2();
        if (method instanceof Member) {
            mname = ((Member)method).get();
            targetClass = this.thisClass;
        } else if (method instanceof Keyword) {
            mname = "<init>";
            targetClass = ((Keyword)method).get() == 336 ? MemberResolver.getSuperclass(this.thisClass) : this.thisClass;
        } else if (method instanceof Expr) {
            Expr e2 = (Expr)method;
            mname = ((Symbol)e2.oprand2()).get();
            int op = e2.getOperator();
            if (op == 35) {
                targetClass = this.resolver.lookupClass(((Symbol)e2.oprand1()).get(), false);
            } else if (op == 46) {
                ASTree target = e2.oprand1();
                String classFollowedByDotSuper = TypeChecker.isDotSuper(target);
                if (classFollowedByDotSuper != null) {
                    targetClass = MemberResolver.getSuperInterface(this.thisClass, classFollowedByDotSuper);
                } else {
                    try {
                        target.accept(this);
                    }
                    catch (NoFieldException noFieldException) {
                        NoFieldException nfe = noFieldException;
                        if (noFieldException.getExpr() != target) {
                            throw nfe;
                        }
                        this.exprType = 307;
                        this.arrayDim = 0;
                        this.className = nfe.getField();
                        e2.setOperator(35);
                        e2.setOprand1(new Symbol(MemberResolver.jvmToJavaName(this.className)));
                    }
                    if (this.arrayDim > 0) {
                        targetClass = this.resolver.lookupClass(javaLangObject, true);
                    } else if (this.exprType == 307) {
                        targetClass = this.resolver.lookupClassByJvmName(this.className);
                    } else {
                        TypeChecker.badMethod();
                    }
                }
            } else {
                TypeChecker.badMethod();
            }
        } else {
            TypeChecker.fatal();
        }
        MemberResolver.Method minfo = this.atMethodCallCore((CtClass)var3_3, (String)var2_2, args2);
        var1_1.setMethod(minfo);
    }

    private static void badMethod() throws CompileError {
        throw new CompileError("bad method");
    }

    /*
     * WARNING - void declaration
     */
    static String isDotSuper(ASTree target) {
        void var1_1;
        ASTree right;
        ASTree e2;
        if (target instanceof Expr && ((Expr)(e2 = (Expr)target)).getOperator() == 46 && (right = ((Expr)e2).oprand2()) instanceof Keyword && ((Keyword)var1_1).get() == 336) {
            ASTree aSTree;
            return ((Symbol)((Expr)aSTree).oprand1()).get();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public MemberResolver.Method atMethodCallCore(CtClass targetClass, String mname, ASTList args2) throws CompileError {
        void var1_1;
        void var3_3;
        int nargs = this.getMethodArgsLength(args2);
        int[] types = new int[nargs];
        int[] dims = new int[nargs];
        String[] cnames = new String[nargs];
        this.atMethodArgs(args2, types, dims, cnames);
        MemberResolver.Method found = this.resolver.lookupMethod(targetClass, this.thisClass, this.thisMethod, mname, types, dims, cnames);
        if (found == null) {
            String msg;
            void var2_2;
            String clazz = targetClass.getName();
            String signature = TypeChecker.argTypesToString(types, dims, cnames);
            msg = mname.equals("<init>") ? "cannot find constructor " + clazz + signature : (String)var2_2 + (String)var3_3 + " not found in " + msg;
            throw new CompileError(msg);
        }
        String desc = var3_3.info.getDescriptor();
        this.setReturnType((String)var1_1);
        return var3_3;
    }

    public int getMethodArgsLength(ASTList args2) {
        return ASTList.length(args2);
    }

    public void atMethodArgs(ASTList args2, int[] types, int[] dims, String[] cnames) throws CompileError {
        int i2 = 0;
        while (args2 != null) {
            ASTree aSTree = args2.head();
            aSTree.accept(this);
            types[i2] = this.exprType;
            dims[i2] = this.arrayDim;
            cnames[i2] = this.className;
            ++i2;
            args2 = args2.tail();
        }
    }

    /*
     * WARNING - void declaration
     */
    void setReturnType(String desc) throws CompileError {
        void var3_3;
        int i2 = desc.indexOf(41);
        if (i2 < 0) {
            TypeChecker.badMethod();
        }
        char c2 = desc.charAt(++i2);
        int dim = 0;
        while (c2 == '[') {
            ++dim;
            c2 = desc.charAt(++i2);
        }
        this.arrayDim = dim;
        if (c2 == 'L') {
            void var2_2;
            void var1_1;
            int j2 = desc.indexOf(59, i2 + 1);
            if (j2 < 0) {
                TypeChecker.badMethod();
            }
            this.exprType = 307;
            this.className = var1_1.substring((int)(var2_2 + true), (int)var3_3);
            return;
        }
        this.exprType = MemberResolver.descToType((char)var3_3);
        this.className = null;
    }

    /*
     * WARNING - void declaration
     */
    private void atFieldRead(ASTree expr) throws CompileError {
        void var1_1;
        TypeChecker typeChecker = this;
        typeChecker.atFieldRead(typeChecker.fieldAccess((ASTree)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private void atFieldRead(CtField f2) throws CompileError {
        void var3_3;
        f2 = ((CtField)f2).getFieldInfo2();
        String type = ((FieldInfo)f2).getDescriptor();
        int i2 = 0;
        int dim = 0;
        char c2 = type.charAt(0);
        while (c2 == '[') {
            ++dim;
            c2 = type.charAt(++i2);
        }
        this.arrayDim = var3_3;
        this.exprType = MemberResolver.descToType(c2);
        if (c2 == 'L') {
            void var2_2;
            void var1_1;
            this.className = type.substring(i2 + 1, var1_1.indexOf(59, (int)(var2_2 + true)));
            return;
        }
        this.className = null;
    }

    /*
     * WARNING - void declaration
     */
    protected CtField fieldAccess(ASTree expr) throws CompileError {
        if (expr instanceof Member) {
            Member mem = (Member)expr;
            String name = mem.get();
            try {
                CtField f2 = this.thisClass.getField(name);
                if (Modifier.isStatic(((CtMember)f2).getModifiers())) {
                    mem.setField(f2);
                }
                return f2;
            }
            catch (NotFoundException notFoundException) {
                throw new NoFieldException(name, expr);
            }
        }
        if (expr instanceof Expr) {
            void var3_5;
            Object f3;
            Expr e2 = (Expr)expr;
            int op = e2.getOperator();
            if (op == 35) {
                Member mem = (Member)e2.oprand2();
                f3 = this.resolver.lookupField(((Symbol)e2.oprand1()).get(), mem);
                mem.setField((CtField)f3);
                return f3;
            }
            if (var3_5 == 46) {
                try {
                    e2.oprand1().accept(this);
                }
                catch (NoFieldException noFieldException) {
                    NoFieldException nfe = noFieldException;
                    if (noFieldException.getExpr() != e2.oprand1()) {
                        throw nfe;
                    }
                    return this.fieldAccess2(e2, nfe.getField());
                }
                CompileError err = null;
                try {
                    if (this.exprType == 307 && this.arrayDim == 0) {
                        return this.resolver.lookupFieldByJvmName(this.className, (Symbol)e2.oprand2());
                    }
                }
                catch (CompileError compileError) {
                    f3 = compileError;
                    err = compileError;
                }
                ASTree oprnd1 = e2.oprand1();
                if (oprnd1 instanceof Symbol) {
                    void var1_1;
                    void var2_3;
                    return this.fieldAccess2((Expr)var2_3, ((Symbol)var1_1).get());
                }
                if (err != null) {
                    throw err;
                }
            }
        }
        throw new CompileError("bad field access");
    }

    /*
     * WARNING - void declaration
     */
    private CtField fieldAccess2(Expr e2, String jvmClassName) throws CompileError {
        void var3_3;
        void var2_2;
        void var1_1;
        Member fname = (Member)e2.oprand2();
        CtField f2 = this.resolver.lookupFieldByJvmName2(jvmClassName, fname, e2);
        e2.setOperator(35);
        var1_1.setOprand1(new Symbol(MemberResolver.jvmToJavaName((String)var2_2)));
        var3_3.setField(f2);
        return f2;
    }

    public void atClassObject(Expr expr) throws CompileError {
        this.exprType = 307;
        this.arrayDim = 0;
        this.className = jvmJavaLangClass;
    }

    /*
     * WARNING - void declaration
     */
    public void atArrayLength(Expr expr) throws CompileError {
        expr.oprand1().accept(this);
        if (this.arrayDim == 0) {
            void var1_1;
            throw new NoFieldException("length", (ASTree)var1_1);
        }
        this.exprType = 324;
        this.arrayDim = 0;
    }

    /*
     * WARNING - void declaration
     */
    public void atArrayRead(ASTree array, ASTree index) throws CompileError {
        void var3_4;
        void var1_2;
        void var2_3;
        array.accept(this);
        int type = this.exprType;
        int dim = this.arrayDim;
        String cname = this.className;
        var2_3.accept(this);
        this.exprType = var1_2;
        this.arrayDim = var3_4 - true;
        this.className = cname;
    }

    /*
     * WARNING - void declaration
     */
    private void atPlusPlus(int token, ASTree oprand, Expr expr) throws CompileError {
        void var2_5;
        Expr e2;
        token = oprand == null ? 1 : 0;
        if (token != 0) {
            void var3_6;
            oprand = var3_6.oprand2();
        }
        if (oprand instanceof Variable) {
            Declarator d2 = ((Variable)oprand).getDeclarator();
            this.exprType = d2.getType();
            this.arrayDim = d2.getArrayDim();
            return;
        }
        if (oprand instanceof Expr && (e2 = (Expr)oprand).getOperator() == 65) {
            void var1_4;
            this.atArrayRead(e2.oprand1(), e2.oprand2());
            int t2 = this.exprType;
            if (t2 == 324 || t2 == 303 || t2 == 306 || var1_4 == 334) {
                this.exprType = 324;
            }
            return;
        }
        this.atFieldPlusPlus((ASTree)var2_5);
    }

    /*
     * WARNING - void declaration
     */
    protected void atFieldPlusPlus(ASTree oprand) throws CompileError {
        void var1_2;
        CtField f2 = this.fieldAccess(oprand);
        this.atFieldRead(f2);
        int t2 = this.exprType;
        if (t2 == 324 || t2 == 303 || t2 == 306 || var1_2 == 334) {
            this.exprType = 324;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void atMember(Member mem) throws CompileError {
        void var1_1;
        this.atFieldRead((ASTree)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void atVariable(Variable v2) throws CompileError {
        void var1_1;
        Declarator d2 = v2.getDeclarator();
        this.exprType = d2.getType();
        this.arrayDim = d2.getArrayDim();
        this.className = var1_1.getClassName();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void atKeyword(Keyword k2) throws CompileError {
        this.arrayDim = 0;
        int token = k2.get();
        switch (token) {
            case 410: 
            case 411: {
                this.exprType = 301;
                return;
            }
            case 412: {
                this.exprType = 412;
                return;
            }
            case 336: 
            case 339: {
                void var1_2;
                this.exprType = 307;
                if (var1_2 == 339) {
                    this.className = this.getThisName();
                    return;
                }
                this.className = this.getSuperName();
                return;
            }
        }
        TypeChecker.fatal();
    }

    @Override
    public void atStringL(StringL s2) throws CompileError {
        this.exprType = 307;
        this.arrayDim = 0;
        this.className = jvmJavaLangString;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void atIntConst(IntConst i2) throws CompileError {
        this.arrayDim = 0;
        int type = i2.getType();
        if (type == 402 || type == 401) {
            void var1_2;
            this.exprType = var1_2 == 402 ? 324 : 306;
            return;
        }
        this.exprType = 326;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void atDoubleConst(DoubleConst d2) throws CompileError {
        void var1_1;
        this.arrayDim = 0;
        if (var1_1.getType() == 405) {
            this.exprType = 312;
            return;
        }
        this.exprType = 317;
    }
}

