/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.stackmap;

import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.BadBytecode;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.CodeAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ConstPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.MethodInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.stackmap.BasicBlock;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.stackmap.TypeData;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.stackmap.TypeTag;

public class TypedBlock
extends BasicBlock {
    public int stackTop;
    public int numLocals;
    public TypeData[] localsTypes = null;
    public TypeData[] stackTypes;

    /*
     * WARNING - void declaration
     */
    public static TypedBlock[] makeBlocks(MethodInfo minfo, CodeAttribute ca, boolean optimize) throws BadBytecode {
        void var3_4;
        MethodInfo methodInfo;
        void var2_3;
        void var1_1;
        TypedBlock[] blocks = (TypedBlock[])new Maker().make(minfo);
        if (optimize && blocks.length < 2 && (blocks.length == 0 || blocks[0].incoming == 0)) {
            return null;
        }
        ConstPool pool = minfo.getConstPool();
        boolean isStatic = (minfo.getAccessFlags() & 8) != 0;
        blocks[0].initFirstBlock(ca.getMaxStack(), var1_1.getMaxLocals(), var2_3.getClassName(), minfo.getDescriptor(), isStatic, methodInfo.isConstructor());
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    protected TypedBlock(int pos) {
        super((int)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void toString2(StringBuilder sbuf) {
        void var1_1;
        super.toString2(sbuf);
        sbuf.append(",\n stack={");
        this.printTypes(sbuf, this.stackTop, this.stackTypes);
        sbuf.append("}, locals={");
        this.printTypes(sbuf, this.numLocals, this.localsTypes);
        var1_1.append('}');
    }

    private void printTypes(StringBuilder sbuf, int size, TypeData[] types) {
        if (types == null) {
            return;
        }
        for (int i2 = 0; i2 < size; ++i2) {
            TypeData td;
            if (i2 > 0) {
                sbuf.append(", ");
            }
            sbuf.append((td = types[i2]) == null ? "<>" : td.toString());
        }
    }

    public boolean alreadySet() {
        return this.localsTypes != null;
    }

    /*
     * WARNING - void declaration
     */
    public void setStackMap(int st, TypeData[] stack, int nl, TypeData[] locals) throws BadBytecode {
        void var3_3;
        void var2_2;
        void var1_1;
        this.stackTop = var1_1;
        this.stackTypes = var2_2;
        this.numLocals = var3_3;
        this.localsTypes = locals;
    }

    /*
     * WARNING - void declaration
     */
    public void resetNumLocals() {
        if (this.localsTypes != null) {
            void var1_1;
            for (int nl = this.localsTypes.length; !(nl <= 0 || this.localsTypes[nl - 1].isBasicType() != TypeTag.TOP || nl > 1 && this.localsTypes[nl - 2].is2WordType()); --nl) {
            }
            this.numLocals = var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    void initFirstBlock(int maxStack, int maxLocals, String className, String methodDesc, boolean isStatic, boolean isConstructor) throws BadBytecode {
        void var1_2;
        void var2_3;
        if (methodDesc.charAt(0) != '(') {
            throw new BadBytecode("no method descriptor: " + methodDesc);
        }
        this.stackTop = 0;
        this.stackTypes = TypeData.make(maxStack);
        TypeData[] locals = TypeData.make(maxLocals);
        if (isConstructor) {
            locals[0] = new TypeData.UninitThis(className);
        } else if (!isStatic) {
            locals[0] = new TypeData.ClassName(className);
        }
        int n2 = isStatic ? -1 : 0;
        int i2 = 1;
        try {
            while ((i2 = TypedBlock.descToTag(methodDesc, i2, ++n2, locals)) > 0) {
                if (!locals[n2].is2WordType()) continue;
                locals[++n2] = TypeTag.TOP;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new BadBytecode("bad method descriptor: " + methodDesc);
        }
        this.numLocals = var2_3;
        this.localsTypes = var1_2;
    }

    /*
     * WARNING - void declaration
     */
    private static int descToTag(String desc, int i2, int n2, TypeData[] types) throws BadBytecode {
        void var1_1;
        int i22;
        int i0 = i2;
        int arrayDim = 0;
        char c2 = desc.charAt(i2);
        if (c2 == ')') {
            return 0;
        }
        while (c2 == '[') {
            ++arrayDim;
            c2 = desc.charAt(++i2);
        }
        if (c2 == 'L') {
            i22 = desc.indexOf(59, ++i2);
            types[n2] = arrayDim > 0 ? new TypeData.ClassName(desc.substring(i0, ++i22)) : new TypeData.ClassName(desc.substring(i0 + 1, ++i22 - 1).replace('/', '.'));
            return i22;
        }
        if (arrayDim > 0) {
            types[n2] = new TypeData.ClassName(desc.substring(i0, ++i2));
            return i2;
        }
        TypeData t2 = TypedBlock.toPrimitiveTag((char)i22);
        if (t2 == null) {
            String string;
            throw new BadBytecode("bad method descriptor: " + string);
        }
        var3_3[var2_2] = t2;
        return (int)(var1_1 + true);
    }

    private static TypeData toPrimitiveTag(char c2) {
        switch (c2) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return TypeTag.INTEGER;
            }
            case 'J': {
                return TypeTag.LONG;
            }
            case 'F': {
                return TypeTag.FLOAT;
            }
            case 'D': {
                return TypeTag.DOUBLE;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static String getRetType(String desc) {
        void var2_2;
        int i2 = desc.indexOf(41);
        if (i2 < 0) {
            return "java.lang.Object";
        }
        char c2 = desc.charAt(i2 + 1);
        if (c2 == '[') {
            return desc.substring(i2 + 1);
        }
        if (var2_2 == 76) {
            String string;
            void var1_1;
            return desc.substring((int)(var1_1 + 2), string.length() - 1).replace('/', '.');
        }
        return "java.lang.Object";
    }

    public static class Maker
    extends BasicBlock.Maker {
        /*
         * WARNING - void declaration
         */
        @Override
        protected BasicBlock makeBlock(int pos) {
            void var1_1;
            return new TypedBlock((int)var1_1);
        }

        @Override
        protected BasicBlock[] makeArray(int size) {
            return new TypedBlock[size];
        }
    }
}

