/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.stackmap;

import com.alibaba.ttl.threadpool.agent.internal.javassist.ClassPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.BadBytecode;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ByteArray;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ConstPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.Descriptor;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.Opcode;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.stackmap.TypeData;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.stackmap.TypeTag;

public abstract class Tracer
implements TypeTag {
    protected ClassPool classPool;
    protected ConstPool cpool;
    protected String returnType;
    protected int stackTop;
    protected TypeData[] stackTypes;
    protected TypeData[] localsTypes;

    /*
     * WARNING - void declaration
     */
    public Tracer(ClassPool classes, ConstPool cp, int maxStack, int maxLocals, String retType) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.classPool = var1_1;
        this.cpool = var2_2;
        this.returnType = retType;
        this.stackTop = 0;
        this.stackTypes = TypeData.make((int)var3_3);
        this.localsTypes = TypeData.make(maxLocals);
    }

    /*
     * WARNING - void declaration
     */
    public Tracer(Tracer t2) {
        void var1_1;
        this.classPool = t2.classPool;
        this.cpool = t2.cpool;
        this.returnType = t2.returnType;
        this.stackTop = t2.stackTop;
        this.stackTypes = TypeData.make(t2.stackTypes.length);
        this.localsTypes = TypeData.make(var1_1.localsTypes.length);
    }

    /*
     * WARNING - void declaration
     */
    protected int doOpcode(int pos, byte[] code) throws BadBytecode {
        try {
            void var2_2;
            void var1_1;
            int op = code[pos] & 0xFF;
            if (op < 54) {
                return this.doOpcode0_53(pos, code, op);
            }
            if (op < 96) {
                return this.doOpcode54_95(pos, code, op);
            }
            if (op < 148) {
                return this.doOpcode96_147(pos, code, op);
            }
            return this.doOpcode148_201((int)var1_1, (byte[])var2_2, op);
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            void var3_4;
            throw new BadBytecode("inconsistent stack height " + e2.getMessage(), (Throwable)var3_4);
        }
    }

    protected void visitBranch(int pos, byte[] code, int offset) throws BadBytecode {
    }

    protected void visitGoto(int pos, byte[] code, int offset) throws BadBytecode {
    }

    protected void visitReturn(int pos, byte[] code) throws BadBytecode {
    }

    protected void visitThrow(int pos, byte[] code) throws BadBytecode {
    }

    protected void visitTableSwitch(int pos, byte[] code, int n2, int offsetPos, int defaultOffset) throws BadBytecode {
    }

    protected void visitLookupSwitch(int pos, byte[] code, int n2, int pairsPos, int defaultOffset) throws BadBytecode {
    }

    protected void visitJSR(int pos, byte[] code) throws BadBytecode {
    }

    protected void visitRET(int pos, byte[] code) throws BadBytecode {
    }

    /*
     * WARNING - void declaration
     */
    private int doOpcode0_53(int pos, byte[] code, int op) throws BadBytecode {
        TypeData[] stackTypes = this.stackTypes;
        switch (op) {
            case 0: {
                break;
            }
            case 1: {
                stackTypes[this.stackTop++] = new TypeData.NullType();
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                stackTypes[this.stackTop++] = INTEGER;
                break;
            }
            case 9: 
            case 10: {
                stackTypes[this.stackTop++] = LONG;
                stackTypes[this.stackTop++] = TOP;
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                stackTypes[this.stackTop++] = FLOAT;
                break;
            }
            case 14: 
            case 15: {
                stackTypes[this.stackTop++] = DOUBLE;
                stackTypes[this.stackTop++] = TOP;
                break;
            }
            case 16: 
            case 17: {
                stackTypes[this.stackTop++] = INTEGER;
                if (op == 17) {
                    return 3;
                }
                return 2;
            }
            case 18: {
                this.doLDC(code[pos + 1] & 0xFF);
                return 2;
            }
            case 19: 
            case 20: {
                this.doLDC(ByteArray.readU16bit(code, pos + 1));
                return 3;
            }
            case 21: {
                return this.doXLOAD(INTEGER, code, pos);
            }
            case 22: {
                return this.doXLOAD(LONG, code, pos);
            }
            case 23: {
                return this.doXLOAD(FLOAT, code, pos);
            }
            case 24: {
                return this.doXLOAD(DOUBLE, code, pos);
            }
            case 25: {
                return this.doALOAD(code[pos + 1] & 0xFF);
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                stackTypes[this.stackTop++] = INTEGER;
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                stackTypes[this.stackTop++] = LONG;
                stackTypes[this.stackTop++] = TOP;
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                stackTypes[this.stackTop++] = FLOAT;
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                stackTypes[this.stackTop++] = DOUBLE;
                stackTypes[this.stackTop++] = TOP;
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                void var3_3;
                void reg = var3_3 - 42;
                stackTypes[this.stackTop++] = this.localsTypes[reg];
                break;
            }
            case 46: {
                stackTypes[--this.stackTop - 1] = INTEGER;
                break;
            }
            case 47: {
                stackTypes[this.stackTop - 2] = LONG;
                stackTypes[this.stackTop - 1] = TOP;
                break;
            }
            case 48: {
                stackTypes[--this.stackTop - 1] = FLOAT;
                break;
            }
            case 49: {
                stackTypes[this.stackTop - 2] = DOUBLE;
                stackTypes[this.stackTop - 1] = TOP;
                break;
            }
            case 50: {
                void var2_2;
                int s2 = --this.stackTop - 1;
                TypeData data = stackTypes[s2];
                stackTypes[var1_1] = TypeData.ArrayElement.make((TypeData)var2_2);
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                stackTypes[--this.stackTop - 1] = INTEGER;
                break;
            }
            default: {
                throw new RuntimeException("fatal");
            }
        }
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    private void doLDC(int index) {
        void var3_4;
        TypeData[] stackTypes = this.stackTypes;
        int tag = this.cpool.getTag(index);
        if (tag == 8) {
            stackTypes[this.stackTop++] = new TypeData.ClassName("java.lang.String");
            return;
        }
        if (tag == 3) {
            stackTypes[this.stackTop++] = INTEGER;
            return;
        }
        if (tag == 4) {
            stackTypes[this.stackTop++] = FLOAT;
            return;
        }
        if (tag == 5) {
            stackTypes[this.stackTop++] = LONG;
            stackTypes[this.stackTop++] = TOP;
            return;
        }
        if (tag == 6) {
            stackTypes[this.stackTop++] = DOUBLE;
            stackTypes[this.stackTop++] = TOP;
            return;
        }
        if (tag == 7) {
            var2_3[this.stackTop++] = new TypeData.ClassName("java.lang.Class");
            return;
        }
        if (tag == 17) {
            void var1_2;
            String desc = this.cpool.getDynamicType(index);
            this.pushMemberType((String)var1_2);
            return;
        }
        throw new RuntimeException("bad LDC: " + (int)var3_4);
    }

    /*
     * WARNING - void declaration
     */
    private int doXLOAD(TypeData type, byte[] code, int pos) {
        void var1_1;
        void var2_3;
        void var3_4;
        int localVar = code[var3_4 + true] & 0xFF;
        return this.doXLOAD((int)var2_3, (TypeData)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private int doXLOAD(int localVar, TypeData type) {
        void var2_2;
        this.stackTypes[this.stackTop++] = type;
        if (var2_2.is2WordType()) {
            this.stackTypes[this.stackTop++] = TOP;
        }
        return 2;
    }

    /*
     * WARNING - void declaration
     */
    private int doALOAD(int localVar) {
        void var1_1;
        this.stackTypes[this.stackTop++] = this.localsTypes[var1_1];
        return 2;
    }

    /*
     * WARNING - void declaration
     */
    private int doOpcode54_95(int pos, byte[] code, int op) throws BadBytecode {
        switch (op) {
            case 54: {
                return this.doXSTORE(pos, code, INTEGER);
            }
            case 55: {
                return this.doXSTORE(pos, code, LONG);
            }
            case 56: {
                return this.doXSTORE(pos, code, FLOAT);
            }
            case 57: {
                return this.doXSTORE(pos, code, DOUBLE);
            }
            case 58: {
                return this.doASTORE(code[pos + 1] & 0xFF);
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                int var = op - 59;
                this.localsTypes[var] = INTEGER;
                --this.stackTop;
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                int var = op - 63;
                this.localsTypes[var] = LONG;
                this.localsTypes[var + 1] = TOP;
                this.stackTop -= 2;
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                int var = op - 67;
                this.localsTypes[var] = FLOAT;
                --this.stackTop;
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                int var = op - 71;
                this.localsTypes[var] = DOUBLE;
                this.localsTypes[var + 1] = TOP;
                this.stackTop -= 2;
                break;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                int var = op - 75;
                this.doASTORE(var);
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                this.stackTop -= op == 80 || op == 82 ? 4 : 3;
                break;
            }
            case 83: {
                TypeData.ArrayElement.aastore(this.stackTypes[this.stackTop - 3], this.stackTypes[this.stackTop - 1], this.classPool);
                this.stackTop -= 3;
                break;
            }
            case 84: 
            case 85: 
            case 86: {
                this.stackTop -= 3;
                break;
            }
            case 87: {
                --this.stackTop;
                break;
            }
            case 88: {
                this.stackTop -= 2;
                break;
            }
            case 89: {
                int sp = this.stackTop;
                this.stackTypes[sp] = this.stackTypes[sp - 1];
                this.stackTop = sp + 1;
                break;
            }
            case 90: 
            case 91: {
                int len = op - 90 + 2;
                this.doDUP_XX(1, len);
                int sp = this.stackTop;
                this.stackTypes[sp - len] = this.stackTypes[sp];
                this.stackTop = sp + 1;
                break;
            }
            case 92: {
                this.doDUP_XX(2, 2);
                this.stackTop += 2;
                break;
            }
            case 93: 
            case 94: {
                void var3_5;
                int len = var3_5 - 93 + 3;
                this.doDUP_XX(2, len);
                int sp = this.stackTop;
                this.stackTypes[sp - len] = this.stackTypes[sp];
                this.stackTypes[sp - len + 1] = this.stackTypes[sp + 1];
                this.stackTop = sp + 2;
                break;
            }
            case 95: {
                void var2_2;
                int sp = this.stackTop - 1;
                TypeData t2 = this.stackTypes[sp];
                this.stackTypes[sp] = this.stackTypes[sp - 1];
                this.stackTypes[var1_1 - true] = var2_2;
                break;
            }
            default: {
                throw new RuntimeException("fatal");
            }
        }
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    private int doXSTORE(int pos, byte[] code, TypeData type) {
        void var3_3;
        void var1_1;
        int index = code[pos + 1] & 0xFF;
        return this.doXSTORE((int)var1_1, (TypeData)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private int doXSTORE(int index, TypeData type) {
        void var2_2;
        --this.stackTop;
        this.localsTypes[index] = type;
        if (var2_2.is2WordType()) {
            --this.stackTop;
            this.localsTypes[var1_1 + true] = TOP;
        }
        return 2;
    }

    private int doASTORE(int index) {
        --this.stackTop;
        this.localsTypes[var1_1] = this.stackTypes[this.stackTop];
        return 2;
    }

    private void doDUP_XX(int delta, int len) {
        int sp;
        TypeData[] types = this.stackTypes;
        int end = sp - len;
        for (sp = this.stackTop - 1; sp > end; --sp) {
            types[sp + delta] = types[sp];
        }
    }

    /*
     * WARNING - void declaration
     */
    private int doOpcode96_147(int pos, byte[] code, int op) {
        void var3_3;
        if (op <= 131) {
            this.stackTop += Opcode.STACK_GROW[op];
            return 1;
        }
        switch (var3_3) {
            case 132: {
                return 3;
            }
            case 133: {
                this.stackTypes[this.stackTop - 1] = LONG;
                this.stackTypes[this.stackTop] = TOP;
                ++this.stackTop;
                break;
            }
            case 134: {
                this.stackTypes[this.stackTop - 1] = FLOAT;
                break;
            }
            case 135: {
                this.stackTypes[this.stackTop - 1] = DOUBLE;
                this.stackTypes[this.stackTop] = TOP;
                ++this.stackTop;
                break;
            }
            case 136: {
                this.stackTypes[--this.stackTop - 1] = INTEGER;
                break;
            }
            case 137: {
                this.stackTypes[--this.stackTop - 1] = FLOAT;
                break;
            }
            case 138: {
                this.stackTypes[this.stackTop - 2] = DOUBLE;
                break;
            }
            case 139: {
                this.stackTypes[this.stackTop - 1] = INTEGER;
                break;
            }
            case 140: {
                this.stackTypes[this.stackTop - 1] = LONG;
                this.stackTypes[this.stackTop] = TOP;
                ++this.stackTop;
                break;
            }
            case 141: {
                this.stackTypes[this.stackTop - 1] = DOUBLE;
                this.stackTypes[this.stackTop] = TOP;
                ++this.stackTop;
                break;
            }
            case 142: {
                this.stackTypes[--this.stackTop - 1] = INTEGER;
                break;
            }
            case 143: {
                this.stackTypes[this.stackTop - 2] = LONG;
                break;
            }
            case 144: {
                this.stackTypes[--this.stackTop - 1] = FLOAT;
                break;
            }
            case 145: 
            case 146: 
            case 147: {
                break;
            }
            default: {
                throw new RuntimeException("fatal");
            }
        }
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    private int doOpcode148_201(int pos, byte[] code, int op) throws BadBytecode {
        switch (op) {
            case 148: {
                this.stackTypes[this.stackTop - 4] = INTEGER;
                this.stackTop -= 3;
                break;
            }
            case 149: 
            case 150: {
                this.stackTypes[--this.stackTop - 1] = INTEGER;
                break;
            }
            case 151: 
            case 152: {
                this.stackTypes[this.stackTop - 4] = INTEGER;
                this.stackTop -= 3;
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: {
                --this.stackTop;
                this.visitBranch(pos, code, ByteArray.readS16bit(code, pos + 1));
                return 3;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                this.stackTop -= 2;
                this.visitBranch(pos, code, ByteArray.readS16bit(code, pos + 1));
                return 3;
            }
            case 167: {
                this.visitGoto(pos, code, ByteArray.readS16bit(code, pos + 1));
                return 3;
            }
            case 168: {
                this.visitJSR(pos, code);
                return 3;
            }
            case 169: {
                this.visitRET(pos, code);
                return 2;
            }
            case 170: {
                --this.stackTop;
                int pos2 = (pos & 0xFFFFFFFC) + 8;
                int low = ByteArray.read32bit(code, pos2);
                int n2 = ByteArray.read32bit(code, pos2 + 4);
                int n3 = n2 - low + 1;
                this.visitTableSwitch(pos, code, n3, pos2 + 8, ByteArray.read32bit(code, pos2 - 4));
                return (n3 << 2) + 16 - (pos & 3);
            }
            case 171: {
                --this.stackTop;
                int pos2 = (pos & 0xFFFFFFFC) + 8;
                int n4 = ByteArray.read32bit(code, pos2);
                this.visitLookupSwitch(pos, code, n4, pos2 + 4, ByteArray.read32bit(code, pos2 - 4));
                return (n4 << 3) + 12 - (pos & 3);
            }
            case 172: {
                --this.stackTop;
                this.visitReturn(pos, code);
                break;
            }
            case 173: {
                this.stackTop -= 2;
                this.visitReturn(pos, code);
                break;
            }
            case 174: {
                --this.stackTop;
                this.visitReturn(pos, code);
                break;
            }
            case 175: {
                this.stackTop -= 2;
                this.visitReturn(pos, code);
                break;
            }
            case 176: {
                this.stackTypes[--this.stackTop].setType(this.returnType, this.classPool);
                this.visitReturn(pos, code);
                break;
            }
            case 177: {
                this.visitReturn(pos, code);
                break;
            }
            case 178: {
                return this.doGetField(pos, code, false);
            }
            case 179: {
                return this.doPutField(pos, code, false);
            }
            case 180: {
                return this.doGetField(pos, code, true);
            }
            case 181: {
                return this.doPutField(pos, code, true);
            }
            case 182: 
            case 183: {
                return this.doInvokeMethod(pos, code, true);
            }
            case 184: {
                return this.doInvokeMethod(pos, code, false);
            }
            case 185: {
                return this.doInvokeIntfMethod(pos, code);
            }
            case 186: {
                return this.doInvokeDynamic(pos, code);
            }
            case 187: {
                int i2 = ByteArray.readU16bit(code, pos + 1);
                this.stackTypes[this.stackTop++] = new TypeData.UninitData(pos, this.cpool.getClassInfo(i2));
                return 3;
            }
            case 188: {
                return this.doNEWARRAY(pos, code);
            }
            case 189: {
                int i2 = ByteArray.readU16bit(code, pos + 1);
                String type = this.cpool.getClassInfo(i2).replace('.', '/');
                type = type.charAt(0) == '[' ? "[" + type : "[L" + type + ";";
                this.stackTypes[this.stackTop - 1] = new TypeData.ClassName(type);
                return 3;
            }
            case 190: {
                this.stackTypes[this.stackTop - 1].setType("[Ljava.lang.Object;", this.classPool);
                this.stackTypes[this.stackTop - 1] = INTEGER;
                break;
            }
            case 191: {
                this.stackTypes[--this.stackTop].setType("java.lang.Throwable", this.classPool);
                this.visitThrow(pos, code);
                break;
            }
            case 192: {
                void var3_3;
                int i2 = ByteArray.readU16bit(code, pos + 1);
                String type = this.cpool.getClassInfo((int)var3_3);
                if (type.charAt(0) == '[') {
                    type = type.replace('.', '/');
                }
                this.stackTypes[this.stackTop - 1] = new TypeData.ClassName(type);
                return 3;
            }
            case 193: {
                this.stackTypes[this.stackTop - 1] = INTEGER;
                return 3;
            }
            case 194: 
            case 195: {
                --this.stackTop;
                break;
            }
            case 196: {
                return this.doWIDE(pos, code);
            }
            case 197: {
                return this.doMultiANewArray(pos, code);
            }
            case 198: 
            case 199: {
                --this.stackTop;
                this.visitBranch(pos, code, ByteArray.readS16bit(code, pos + 1));
                return 3;
            }
            case 200: {
                this.visitGoto(pos, code, ByteArray.read32bit(code, pos + 1));
                return 5;
            }
            case 201: {
                void var2_2;
                void var1_1;
                this.visitJSR((int)var1_1, (byte[])var2_2);
                return 5;
            }
        }
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    private int doWIDE(int pos, byte[] code) throws BadBytecode {
        int op = code[pos + 1] & 0xFF;
        switch (op) {
            case 21: {
                this.doWIDE_XLOAD(pos, code, INTEGER);
                break;
            }
            case 22: {
                this.doWIDE_XLOAD(pos, code, LONG);
                break;
            }
            case 23: {
                this.doWIDE_XLOAD(pos, code, FLOAT);
                break;
            }
            case 24: {
                this.doWIDE_XLOAD(pos, code, DOUBLE);
                break;
            }
            case 25: {
                int index = ByteArray.readU16bit(code, pos + 2);
                this.doALOAD(index);
                break;
            }
            case 54: {
                int index;
                this.doWIDE_STORE(index, code, INTEGER);
                break;
            }
            case 55: {
                int index;
                this.doWIDE_STORE(index, code, LONG);
                break;
            }
            case 56: {
                int index;
                this.doWIDE_STORE(index, code, FLOAT);
                break;
            }
            case 57: {
                int index;
                this.doWIDE_STORE(index, code, DOUBLE);
                break;
            }
            case 58: {
                void var1_1;
                int index;
                index = ByteArray.readU16bit(code, (int)(index + 2));
                this.doASTORE((int)var1_1);
                break;
            }
            case 132: {
                return 6;
            }
            case 169: {
                void var2_2;
                void var1_1;
                this.visitRET((int)var1_1, (byte[])var2_2);
                break;
            }
            default: {
                void var3_3;
                throw new RuntimeException("bad WIDE instruction: " + (int)var3_3);
            }
        }
        return 4;
    }

    /*
     * WARNING - void declaration
     */
    private void doWIDE_XLOAD(int pos, byte[] code, TypeData type) {
        void var3_3;
        void var1_1;
        int index = ByteArray.readU16bit(code, pos + 2);
        this.doXLOAD((int)var1_1, (TypeData)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void doWIDE_STORE(int pos, byte[] code, TypeData type) {
        void var3_3;
        void var1_1;
        int index = ByteArray.readU16bit(code, pos + 2);
        this.doXSTORE((int)var1_1, (TypeData)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private int doPutField(int pos, byte[] code, boolean notStatic) throws BadBytecode {
        void var1_1;
        void var3_3;
        int index = ByteArray.readU16bit(code, pos + 1);
        String desc = this.cpool.getFieldrefType(index);
        this.stackTop -= Descriptor.dataSize(desc);
        char c2 = desc.charAt(0);
        if (c2 == 'L') {
            this.stackTypes[this.stackTop].setType(Tracer.getFieldClassName(desc, 0), this.classPool);
        } else if (c2 == '[') {
            void var2_2;
            this.stackTypes[this.stackTop].setType((String)var2_2, this.classPool);
        }
        this.setFieldTarget((boolean)var3_3, (int)var1_1);
        return 3;
    }

    /*
     * WARNING - void declaration
     */
    private int doGetField(int pos, byte[] code, boolean notStatic) throws BadBytecode {
        void var1_2;
        void var3_4;
        int index = ByteArray.readU16bit(code, pos + 1);
        this.setFieldTarget((boolean)var3_4, index);
        String desc = this.cpool.getFieldrefType(index);
        this.pushMemberType((String)var1_2);
        return 3;
    }

    /*
     * WARNING - void declaration
     */
    private void setFieldTarget(boolean notStatic, int index) throws BadBytecode {
        if (notStatic) {
            void var1_2;
            void var2_3;
            String className = this.cpool.getFieldrefClassName((int)var2_3);
            this.stackTypes[--this.stackTop].setType((String)var1_2, this.classPool);
        }
    }

    /*
     * WARNING - void declaration
     */
    private int doNEWARRAY(int pos, byte[] code) {
        void var1_2;
        void var2_3;
        int s2 = this.stackTop - 1;
        switch (var2_3[pos + 1] & 0xFF) {
            case 4: {
                String type = "[Z";
                break;
            }
            case 5: {
                String type = "[C";
                break;
            }
            case 6: {
                String type = "[F";
                break;
            }
            case 7: {
                String type = "[D";
                break;
            }
            case 8: {
                String type = "[B";
                break;
            }
            case 9: {
                String type = "[S";
                break;
            }
            case 10: {
                String type = "[I";
                break;
            }
            case 11: {
                String type = "[J";
                break;
            }
            default: {
                throw new RuntimeException("bad newarray");
            }
        }
        this.stackTypes[var3_4] = new TypeData.ClassName((String)var1_2);
        return 2;
    }

    /*
     * WARNING - void declaration
     */
    private int doMultiANewArray(int pos, byte[] code) {
        void var1_2;
        void var3_4;
        void var2_3;
        int i2 = ByteArray.readU16bit(code, pos + 1);
        int dim = var2_3[pos + 3] & 0xFF;
        this.stackTop -= dim - 1;
        String type = this.cpool.getClassInfo((int)var3_4).replace('.', '/');
        this.stackTypes[this.stackTop - 1] = new TypeData.ClassName((String)var1_2);
        return 4;
    }

    /*
     * WARNING - void declaration
     */
    private int doInvokeMethod(int pos, byte[] code, boolean notStatic) throws BadBytecode {
        void var2_3;
        int i2 = ByteArray.readU16bit(code, pos + 1);
        String desc = this.cpool.getMethodrefType(i2);
        this.checkParamTypes(desc, 1);
        if (notStatic) {
            void var1_2;
            void var3_5;
            TypeData target;
            String className = this.cpool.getMethodrefClassName(i2);
            if ((target = this.stackTypes[--this.stackTop]) instanceof TypeData.UninitTypeVar && target.isUninit()) {
                TypeData typeData = target;
                this.constructorCalled(typeData, ((TypeData.UninitTypeVar)typeData).offset());
            } else if (target instanceof TypeData.UninitData) {
                TypeData typeData = target;
                this.constructorCalled(typeData, ((TypeData.UninitData)typeData).offset());
            }
            var3_5.setType((String)var1_2, this.classPool);
        }
        this.pushMemberType((String)var2_3);
        return 3;
    }

    private void constructorCalled(TypeData target, int offset) {
        int i2;
        target.constructorCalled(offset);
        for (i2 = 0; i2 < this.stackTop; ++i2) {
            this.stackTypes[i2].constructorCalled(offset);
        }
        for (i2 = 0; i2 < this.localsTypes.length; ++i2) {
            this.localsTypes[i2].constructorCalled(offset);
        }
    }

    /*
     * WARNING - void declaration
     */
    private int doInvokeIntfMethod(int pos, byte[] code) throws BadBytecode {
        void var2_3;
        void var1_2;
        int i2 = ByteArray.readU16bit(code, pos + 1);
        String desc = this.cpool.getInterfaceMethodrefType(i2);
        this.checkParamTypes(desc, 1);
        String className = this.cpool.getInterfaceMethodrefClassName(i2);
        this.stackTypes[--this.stackTop].setType((String)var1_2, this.classPool);
        this.pushMemberType((String)var2_3);
        return 5;
    }

    /*
     * WARNING - void declaration
     */
    private int doInvokeDynamic(int pos, byte[] code) throws BadBytecode {
        void var1_2;
        int i2 = ByteArray.readU16bit(code, pos + 1);
        String desc = this.cpool.getInvokeDynamicType(i2);
        this.checkParamTypes(desc, 1);
        this.pushMemberType((String)var1_2);
        return 5;
    }

    /*
     * WARNING - void declaration
     */
    private void pushMemberType(String descriptor) {
        int top = 0;
        if (descriptor.charAt(0) == '(' && (top = descriptor.indexOf(41) + 1) <= 0) {
            throw new IndexOutOfBoundsException("bad descriptor: " + descriptor);
        }
        TypeData[] types = this.stackTypes;
        int index = this.stackTop;
        switch (descriptor.charAt(top)) {
            case '[': {
                types[index] = new TypeData.ClassName(descriptor.substring(top));
                break;
            }
            case 'L': {
                void var2_2;
                void var1_1;
                types[index] = new TypeData.ClassName(Tracer.getFieldClassName((String)var1_1, (int)var2_2));
                break;
            }
            case 'J': {
                types[index] = LONG;
                types[index + 1] = TOP;
                this.stackTop += 2;
                return;
            }
            case 'F': {
                types[index] = FLOAT;
                break;
            }
            case 'D': {
                types[index] = DOUBLE;
                types[index + 1] = TOP;
                this.stackTop += 2;
                return;
            }
            case 'V': {
                return;
            }
            default: {
                var3_3[index] = INTEGER;
            }
        }
        ++this.stackTop;
    }

    /*
     * WARNING - void declaration
     */
    private static String getFieldClassName(String desc, int index) {
        String string;
        void var1_1;
        return desc.substring((int)(var1_1 + true), string.length() - 1).replace('/', '.');
    }

    /*
     * WARNING - void declaration
     */
    private void checkParamTypes(String desc, int i2) throws BadBytecode {
        void var3_3;
        char c2 = desc.charAt(i2);
        if (c2 == ')') {
            return;
        }
        int k2 = i2;
        boolean array = false;
        while (c2 == '[') {
            array = true;
            c2 = desc.charAt(++k2);
        }
        if (c2 == 'L') {
            if ((k2 = desc.indexOf(59, k2) + 1) <= 0) {
                throw new IndexOutOfBoundsException("bad descriptor");
            }
        } else {
            ++k2;
        }
        this.checkParamTypes(desc, k2);
        this.stackTop = !(array || c2 != 'J' && c2 != 'D') ? (this.stackTop -= 2) : --this.stackTop;
        if (array) {
            this.stackTypes[this.stackTop].setType(desc.substring(i2, k2), this.classPool);
            return;
        }
        if (var3_3 == 76) {
            void var2_2;
            void var1_1;
            this.stackTypes[this.stackTop].setType(var1_1.substring((int)(var2_2 + true), k2 - 1).replace('/', '.'), this.classPool);
        }
    }
}

