/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation;

import com.alibaba.ttl.threadpool.agent.internal.javassist.ClassPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.BadBytecode;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ConstPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.Descriptor;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.SignatureAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation.AnnotationsWriter;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation.MemberValue;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation.MemberValueVisitor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;

public class ClassMemberValue
extends MemberValue {
    int valueIndex;

    /*
     * WARNING - void declaration
     */
    public ClassMemberValue(int index, ConstPool cp) {
        super('c', (ConstPool)var2_2);
        void var1_1;
        void var2_2;
        this.valueIndex = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ClassMemberValue(String className, ConstPool cp) {
        super('c', (ConstPool)var2_2);
        void var1_1;
        void var2_2;
        this.setValue((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ClassMemberValue(ConstPool cp) {
        super('c', (ConstPool)var1_1);
        void var1_1;
        this.setValue("java.lang.Class");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Object getValue(ClassLoader cl, ClassPool cp, Method m2) throws ClassNotFoundException {
        void var2_2;
        void var1_1;
        String classname = this.getValue();
        if (classname.equals("void")) {
            return Void.TYPE;
        }
        if (classname.equals("int")) {
            return Integer.TYPE;
        }
        if (classname.equals("byte")) {
            return Byte.TYPE;
        }
        if (classname.equals("long")) {
            return Long.TYPE;
        }
        if (classname.equals("double")) {
            return Double.TYPE;
        }
        if (classname.equals("float")) {
            return Float.TYPE;
        }
        if (classname.equals("char")) {
            return Character.TYPE;
        }
        if (classname.equals("short")) {
            return Short.TYPE;
        }
        if (classname.equals("boolean")) {
            return Boolean.TYPE;
        }
        return ClassMemberValue.loadClass((ClassLoader)var1_1, (String)var2_2);
    }

    @Override
    Class<?> getType(ClassLoader cl) throws ClassNotFoundException {
        return ClassMemberValue.loadClass(cl, "java.lang.Class");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void renameClass(String oldname, String newname) {
        void var1_1;
        void var2_2;
        String string = this.cp.getUtf8Info(this.valueIndex);
        String newValue = Descriptor.rename(string, oldname, (String)var2_2);
        this.setValue(Descriptor.toClassName((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void renameClass(Map<String, String> classnames) {
        void var1_1;
        String string = this.cp.getUtf8Info(this.valueIndex);
        String newValue = Descriptor.rename(string, classnames);
        this.setValue(Descriptor.toClassName((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public String getValue() {
        String v2 = this.cp.getUtf8Info(this.valueIndex);
        try {
            return SignatureAttribute.toTypeSignature(v2).jvmTypeName();
        }
        catch (BadBytecode e2) {
            void var1_2;
            throw new RuntimeException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setValue(String newClassName) {
        void var1_1;
        String setTo = Descriptor.of(newClassName);
        this.valueIndex = this.cp.addUtf8Info((String)var1_1);
    }

    public String toString() {
        return this.getValue().replace('$', '.') + ".class";
    }

    @Override
    public void write(AnnotationsWriter writer) throws IOException {
        writer.classInfoIndex(this.cp.getUtf8Info(this.valueIndex));
    }

    @Override
    public void accept(MemberValueVisitor visitor) {
        visitor.visitClassMemberValue(this);
    }
}

