/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation;

import com.alibaba.ttl.threadpool.agent.internal.javassist.ClassPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ConstPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation.AnnotationsWriter;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation.MemberValue;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation.MemberValueVisitor;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Map;

public class ArrayMemberValue
extends MemberValue {
    MemberValue type;
    MemberValue[] values;

    /*
     * WARNING - void declaration
     */
    public ArrayMemberValue(ConstPool cp) {
        super('[', (ConstPool)var1_1);
        void var1_1;
        this.type = null;
        this.values = null;
    }

    /*
     * WARNING - void declaration
     */
    public ArrayMemberValue(MemberValue t2, ConstPool cp) {
        super('[', (ConstPool)var2_2);
        void var1_1;
        void var2_2;
        this.type = var1_1;
        this.values = null;
    }

    @Override
    Object getValue(ClassLoader cl, ClassPool cp, Method method) throws ClassNotFoundException {
        Class<?> clazz;
        if (this.values == null) {
            throw new ClassNotFoundException("no array elements found: " + method.getName());
        }
        int size = this.values.length;
        if (this.type == null) {
            clazz = method.getReturnType().getComponentType();
            if (clazz == null || size > 0) {
                throw new ClassNotFoundException("broken array type: " + method.getName());
            }
        } else {
            clazz = this.type.getType(cl);
        }
        Object a2 = Array.newInstance(clazz, size);
        for (int i2 = 0; i2 < size; ++i2) {
            Array.set(a2, i2, this.values[i2].getValue(cl, cp, method));
        }
        return a2;
    }

    @Override
    Class<?> getType(ClassLoader cl) throws ClassNotFoundException {
        Object object;
        if (this.type == null) {
            throw new ClassNotFoundException("no array type specified");
        }
        object = Array.newInstance(this.type.getType((ClassLoader)object), 0);
        return object.getClass();
    }

    @Override
    public void renameClass(String oldname, String newname) {
        if (this.type != null) {
            this.type.renameClass(oldname, newname);
        }
        if (this.values != null) {
            MemberValue[] memberValueArray = this.values;
            int n2 = this.values.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                MemberValue memberValue = memberValueArray[i2];
                memberValue.renameClass(oldname, newname);
            }
        }
    }

    @Override
    public void renameClass(Map<String, String> classnames) {
        if (this.type != null) {
            this.type.renameClass(classnames);
        }
        if (this.values != null) {
            MemberValue[] memberValueArray = this.values;
            int n2 = this.values.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                MemberValue memberValue = memberValueArray[i2];
                memberValue.renameClass(classnames);
            }
        }
    }

    public MemberValue getType() {
        return this.type;
    }

    public MemberValue[] getValue() {
        return this.values;
    }

    /*
     * WARNING - void declaration
     */
    public void setValue(MemberValue[] elements) {
        this.values = elements;
        if (elements != null && elements.length > 0) {
            void var1_1;
            this.type = var1_1[0];
        }
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder buf = new StringBuilder();
        buf.append('{');
        if (this.values != null) {
            for (int i2 = 0; i2 < this.values.length; ++i2) {
                buf.append(this.values[i2].toString());
                if (i2 + 1 >= this.values.length) continue;
                buf.append(", ");
            }
        }
        buf.append('}');
        return var1_1.toString();
    }

    @Override
    public void write(AnnotationsWriter writer) throws IOException {
        int num = this.values == null ? 0 : this.values.length;
        writer.arrayValue(num);
        for (int i2 = 0; i2 < num; ++i2) {
            this.values[i2].write(writer);
        }
    }

    @Override
    public void accept(MemberValueVisitor visitor) {
        visitor.visitArrayMemberValue(this);
    }
}

