/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation;

import com.alibaba.ttl.threadpool.agent.internal.javassist.ClassPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtClass;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtMethod;
import com.alibaba.ttl.threadpool.agent.internal.javassist.NotFoundException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ConstPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.Descriptor;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation.AnnotationImpl;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation.AnnotationMemberValue;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation.AnnotationsWriter;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation.ArrayMemberValue;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation.BooleanMemberValue;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation.ByteMemberValue;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation.CharMemberValue;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation.ClassMemberValue;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation.DoubleMemberValue;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation.EnumMemberValue;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation.FloatMemberValue;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation.IntegerMemberValue;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation.LongMemberValue;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation.MemberValue;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation.NoSuchClassError;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation.ShortMemberValue;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.annotation.StringMemberValue;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class Annotation {
    ConstPool pool;
    int typeIndex;
    Map<String, Pair> members;

    /*
     * WARNING - void declaration
     */
    public Annotation(int type, ConstPool cp) {
        void var1_1;
        void var2_2;
        this.pool = var2_2;
        this.typeIndex = var1_1;
        this.members = null;
    }

    /*
     * WARNING - void declaration
     */
    public Annotation(String typeName, ConstPool cp) {
        this(cp.addUtf8Info(Descriptor.of((String)var1_1)), (ConstPool)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Annotation(ConstPool cp, CtClass clazz) throws NotFoundException {
        this(cp.addUtf8Info(Descriptor.of(clazz.getName())), cp);
        void var2_2;
        if (!clazz.isInterface()) {
            throw new RuntimeException("Only interfaces are allowed for Annotation creation.");
        }
        CtMethod[] methods = clazz.getDeclaredMethods();
        if (methods.length > 0) {
            this.members = new LinkedHashMap<String, Pair>();
        }
        for (void m2 : var2_2) {
            this.addMemberValue(m2.getName(), Annotation.createMemberValue(cp, m2.getReturnType()));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static MemberValue createMemberValue(ConstPool cp, CtClass type) throws NotFoundException {
        void var2_4;
        ConstPool constPool;
        void var1_1;
        if (type == CtClass.booleanType) {
            return new BooleanMemberValue(cp);
        }
        if (type == CtClass.byteType) {
            return new ByteMemberValue(cp);
        }
        if (type == CtClass.charType) {
            return new CharMemberValue(cp);
        }
        if (type == CtClass.shortType) {
            return new ShortMemberValue(cp);
        }
        if (type == CtClass.intType) {
            return new IntegerMemberValue(cp);
        }
        if (type == CtClass.longType) {
            return new LongMemberValue(cp);
        }
        if (type == CtClass.floatType) {
            return new FloatMemberValue(cp);
        }
        if (type == CtClass.doubleType) {
            return new DoubleMemberValue(cp);
        }
        if (type.getName().equals("java.lang.Class")) {
            return new ClassMemberValue(cp);
        }
        if (type.getName().equals("java.lang.String")) {
            return new StringMemberValue(cp);
        }
        if (type.isArray()) {
            CtClass arrayType = type.getComponentType();
            MemberValue member = Annotation.createMemberValue(cp, arrayType);
            return new ArrayMemberValue((MemberValue)var1_1, cp);
        }
        if (var1_1.isInterface()) {
            Annotation info = new Annotation(cp, (CtClass)var1_1);
            return new AnnotationMemberValue(info, cp);
        }
        EnumMemberValue emv = new EnumMemberValue(constPool);
        emv.setType(var1_1.getName());
        return var2_4;
    }

    /*
     * WARNING - void declaration
     */
    public void addMemberValue(int nameIndex, MemberValue value) {
        void var3_3;
        void var2_2;
        void var1_1;
        Pair p2 = new Pair();
        new Pair().name = var1_1;
        p2.value = var2_2;
        this.addMemberValue((Pair)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void addMemberValue(String name, MemberValue value) {
        void var3_3;
        void var1_1;
        void var2_2;
        Pair p2 = new Pair();
        new Pair().name = this.pool.addUtf8Info(name);
        p2.value = var2_2;
        if (this.members == null) {
            this.members = new LinkedHashMap<String, Pair>();
        }
        this.members.put((String)var1_1, (Pair)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void addMemberValue(Pair pair) {
        void var1_1;
        void var2_2;
        String name = this.pool.getUtf8Info(pair.name);
        if (this.members == null) {
            this.members = new LinkedHashMap<String, Pair>();
        }
        this.members.put((String)var2_2, (Pair)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder buf = new StringBuilder();
        buf.append('@');
        buf.append(this.getTypeName());
        if (this.members != null) {
            buf.append('(');
            for (String name : this.members.keySet()) {
                void var3_3;
                buf.append(name).append('=').append(this.getMemberValue((String)var3_3)).append(", ");
            }
            StringBuilder stringBuilder = buf;
            stringBuilder.setLength(stringBuilder.length() - 2);
            buf.append(')');
        }
        return var1_1.toString();
    }

    public String getTypeName() {
        return Descriptor.toClassName(this.pool.getUtf8Info(this.typeIndex));
    }

    public Set<String> getMemberNames() {
        if (this.members == null) {
            return null;
        }
        return this.members.keySet();
    }

    /*
     * WARNING - void declaration
     */
    public MemberValue getMemberValue(String name) {
        void var1_1;
        if (this.members == null || this.members.get(name) == null) {
            return null;
        }
        return this.members.get((Object)var1_1).value;
    }

    /*
     * WARNING - void declaration
     */
    public Object toAnnotationType(ClassLoader cl, ClassPool cp) throws ClassNotFoundException, NoSuchClassError {
        Class<?> clazz = MemberValue.loadClass(cl, this.getTypeName());
        try {
            void var2_4;
            return AnnotationImpl.make(cl, clazz, (ClassPool)var2_4, this);
        }
        catch (IllegalArgumentException e2) {
            throw new ClassNotFoundException(clazz.getName(), e2);
        }
        catch (IllegalAccessError e2) {
            void var1_3;
            void var3_5;
            throw new ClassNotFoundException(var3_5.getName(), (Throwable)var1_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void write(AnnotationsWriter writer) throws IOException {
        Iterator<Pair> iterator2;
        String typeName = this.pool.getUtf8Info(this.typeIndex);
        if (this.members == null) {
            writer.annotation(typeName, 0);
            return;
        }
        writer.annotation((String)((Object)iterator2), this.members.size());
        for (Pair pair : this.members.values()) {
            void var3_3;
            writer.memberValuePair(pair.name);
            var3_3.value.write(writer);
        }
    }

    public int hashCode() {
        return this.getTypeName().hashCode() + (this.members == null ? 0 : this.members.hashCode());
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        void var1_1;
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Annotation)) {
            return false;
        }
        Annotation other = (Annotation)obj;
        if (!this.getTypeName().equals(other.getTypeName())) {
            return false;
        }
        Map<String, Pair> otherMembers = other.members;
        if (this.members == otherMembers) {
            return true;
        }
        if (this.members == null) {
            return otherMembers == null;
        }
        if (otherMembers == null) {
            return false;
        }
        return this.members.equals(var1_1);
    }

    static class Pair {
        int name;
        MemberValue value;

        Pair() {
        }
    }
}

