/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.analysis;

import com.alibaba.ttl.threadpool.agent.internal.javassist.CtClass;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtMember;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtMethod;
import com.alibaba.ttl.threadpool.agent.internal.javassist.Modifier;
import com.alibaba.ttl.threadpool.agent.internal.javassist.NotFoundException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.BadBytecode;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.CodeAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.CodeIterator;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ConstPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.Descriptor;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.InstructionPrinter;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.MethodInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.analysis.Analyzer;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.analysis.Frame;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.analysis.Type;
import java.io.PrintStream;

public final class FramePrinter {
    private final PrintStream stream;

    /*
     * WARNING - void declaration
     */
    public FramePrinter(PrintStream stream) {
        void var1_1;
        this.stream = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static void print(CtClass clazz, PrintStream stream) {
        CtClass ctClass;
        void var1_1;
        new FramePrinter((PrintStream)var1_1).print(ctClass);
    }

    public final void print(CtClass clazz) {
        CtMethod[] methods = clazz.getDeclaredMethods();
        for (int i2 = 0; i2 < methods.length; ++i2) {
            this.print(methods[i2]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getMethodString(CtMethod method) {
        try {
            return Modifier.toString(((CtMember)method).getModifiers()) + " " + method.getReturnType().getName() + " " + ((CtMember)method).getName() + Descriptor.toString(((CtMember)method).getSignature()) + ";";
        }
        catch (NotFoundException e2) {
            void var1_2;
            throw new RuntimeException((Throwable)var1_2);
        }
    }

    public final void print(CtMethod method) {
        Frame[] frames;
        this.stream.println("\n" + this.getMethodString(method));
        MethodInfo info = method.getMethodInfo2();
        ConstPool pool = info.getConstPool();
        CodeAttribute code = info.getCodeAttribute();
        if (code == null) {
            return;
        }
        try {
            frames = new Analyzer().analyze(method.getDeclaringClass(), info);
        }
        catch (BadBytecode e2) {
            throw new RuntimeException(e2);
        }
        int spacing = String.valueOf(code.getCodeLength()).length();
        CodeIterator iterator2 = code.iterator();
        while (iterator2.hasNext()) {
            int pos;
            try {
                pos = iterator2.next();
            }
            catch (BadBytecode e3) {
                throw new RuntimeException(e3);
            }
            this.stream.println(pos + ": " + InstructionPrinter.instructionString(iterator2, pos, pool));
            this.addSpacing(spacing + 3);
            Frame frame = frames[pos];
            if (frame == null) {
                this.stream.println("--DEAD CODE--");
                continue;
            }
            this.printStack(frame);
            this.addSpacing(spacing + 3);
            this.printLocals(frame);
        }
    }

    private void printStack(Frame frame) {
        this.stream.print("stack [");
        int top = frame.getTopIndex();
        for (int i2 = 0; i2 <= top; ++i2) {
            if (i2 > 0) {
                this.stream.print(", ");
            }
            Type type = frame.getStack(i2);
            this.stream.print(type);
        }
        this.stream.println("]");
    }

    private void printLocals(Frame frame) {
        this.stream.print("locals [");
        int length = frame.localsLength();
        for (int i2 = 0; i2 < length; ++i2) {
            Type type;
            if (i2 > 0) {
                this.stream.print(", ");
            }
            this.stream.print((type = frame.getLocal(i2)) == null ? "empty" : type.toString());
        }
        this.stream.println("]");
    }

    private void addSpacing(int count) {
        while (count-- > 0) {
            this.stream.print(' ');
        }
    }
}

