/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode;

import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.AttributeInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ByteArray;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ConstPool;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;

public class LineNumberAttribute
extends AttributeInfo {
    public static final String tag = "LineNumberTable";

    /*
     * WARNING - void declaration
     */
    LineNumberAttribute(ConstPool cp, int n2, DataInputStream in) throws IOException {
        super((ConstPool)var1_1, (int)var2_2, (DataInputStream)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private LineNumberAttribute(ConstPool cp, byte[] i2) {
        super((ConstPool)var1_1, tag, (byte[])var2_2);
        void var2_2;
        void var1_1;
    }

    public int tableLength() {
        return ByteArray.readU16bit(this.info, 0);
    }

    /*
     * WARNING - void declaration
     */
    public int startPc(int i2) {
        void var1_1;
        return ByteArray.readU16bit(this.info, (int)((var1_1 << 2) + 2));
    }

    /*
     * WARNING - void declaration
     */
    public int lineNumber(int i2) {
        void var1_1;
        return ByteArray.readU16bit(this.info, (int)((var1_1 << 2) + 4));
    }

    /*
     * WARNING - void declaration
     */
    public int toLineNumber(int pc) {
        void var3_3;
        int n2 = this.tableLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (pc >= this.startPc(i2)) continue;
            if (i2 != 0) break;
            return this.lineNumber(0);
        }
        return this.lineNumber((int)(var3_3 - true));
    }

    public int toStartPc(int line) {
        int n2 = this.tableLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (line != this.lineNumber(i2)) continue;
            return this.startPc(i2);
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public Pc toNearPc(int line) {
        void var1_1;
        void var3_3;
        int n2 = this.tableLength();
        int nearPc = 0;
        int distance = 0;
        if (n2 > 0) {
            distance = this.lineNumber(0) - line;
            nearPc = this.startPc(0);
        }
        for (int i2 = 1; i2 < n2; ++i2) {
            int d2 = this.lineNumber(i2) - line;
            if ((d2 >= 0 || d2 <= distance) && (d2 < 0 || d2 >= distance && distance >= 0)) continue;
            distance = d2;
            nearPc = this.startPc(i2);
        }
        Pc res = new Pc();
        new Pc().index = var3_3;
        res.line = var1_1 + distance;
        return res;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AttributeInfo copy(ConstPool newCp, Map<String, String> classnames) {
        void var1_1;
        byte[] src = this.info;
        int num = this.info.length;
        byte[] dest = new byte[num];
        for (int i2 = 0; i2 < num; ++i2) {
            dest[i2] = src[i2];
        }
        LineNumberAttribute lineNumberAttribute = new LineNumberAttribute((ConstPool)var1_1, dest);
        return lineNumberAttribute;
    }

    void shiftPc(int where, int gapLength, boolean exclusive) {
        int n2 = this.tableLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            int pos = (i2 << 2) + 2;
            int pc = ByteArray.readU16bit(this.info, pos);
            if (pc <= where && (!exclusive || pc != where)) continue;
            ByteArray.write16bit(pc + gapLength, this.info, pos);
        }
    }

    public static class Pc {
        public int index;
        public int line;
    }
}

