/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode;

import com.alibaba.ttl.threadpool.agent.internal.javassist.CtClass;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ClassInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ConstInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ConstInfoPadding;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.Descriptor;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.DoubleInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.DynamicInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.FieldrefInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.FloatInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.IntegerInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.InterfaceMethodrefInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.InvokeDynamicInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.LongInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.LongVector;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.MemberrefInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.MethodHandleInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.MethodTypeInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.MethodrefInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ModuleInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.NameAndTypeInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.PackageInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.StringInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.Utf8Info;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class ConstPool {
    LongVector items;
    int numOfItems;
    int thisClassInfo;
    Map<ConstInfo, ConstInfo> itemsCache;
    public static final int CONST_Class = 7;
    public static final int CONST_Fieldref = 9;
    public static final int CONST_Methodref = 10;
    public static final int CONST_InterfaceMethodref = 11;
    public static final int CONST_String = 8;
    public static final int CONST_Integer = 3;
    public static final int CONST_Float = 4;
    public static final int CONST_Long = 5;
    public static final int CONST_Double = 6;
    public static final int CONST_NameAndType = 12;
    public static final int CONST_Utf8 = 1;
    public static final int CONST_MethodHandle = 15;
    public static final int CONST_MethodType = 16;
    public static final int CONST_Dynamic = 17;
    public static final int CONST_DynamicCallSite = 18;
    public static final int CONST_InvokeDynamic = 18;
    public static final int CONST_Module = 19;
    public static final int CONST_Package = 20;
    public static final CtClass THIS = null;
    public static final int REF_getField = 1;
    public static final int REF_getStatic = 2;
    public static final int REF_putField = 3;
    public static final int REF_putStatic = 4;
    public static final int REF_invokeVirtual = 5;
    public static final int REF_invokeStatic = 6;
    public static final int REF_invokeSpecial = 7;
    public static final int REF_newInvokeSpecial = 8;
    public static final int REF_invokeInterface = 9;

    /*
     * WARNING - void declaration
     */
    public ConstPool(String thisclass) {
        void var1_1;
        this.items = new LongVector();
        this.itemsCache = null;
        this.numOfItems = 0;
        this.addItem0(null);
        this.thisClassInfo = this.addClassInfo((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ConstPool(DataInputStream in) throws IOException {
        void var1_1;
        this.itemsCache = null;
        this.thisClassInfo = 0;
        this.read((DataInputStream)var1_1);
    }

    final void prune() {
        this.itemsCache = null;
    }

    public final int getSize() {
        return this.numOfItems;
    }

    public final String getClassName() {
        ConstPool constPool = this;
        return constPool.getClassInfo(constPool.thisClassInfo);
    }

    public final int getThisClassInfo() {
        return this.thisClassInfo;
    }

    /*
     * WARNING - void declaration
     */
    final void setThisClassInfo(int i2) {
        void var1_1;
        this.thisClassInfo = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    final ConstInfo getItem(int n2) {
        void var1_1;
        return this.items.elementAt((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final int getTag(int index) {
        void var1_1;
        return this.getItem((int)var1_1).getTag();
    }

    /*
     * WARNING - void declaration
     */
    public final String getClassInfo(int index) {
        void var1_2;
        ClassInfo c2 = (ClassInfo)this.getItem(index);
        if (c2 == null) {
            return null;
        }
        return Descriptor.toJavaName(this.getUtf8Info(var1_2.name));
    }

    /*
     * WARNING - void declaration
     */
    public final String getClassInfoByDescriptor(int index) {
        void var1_2;
        ClassInfo c2 = (ClassInfo)this.getItem(index);
        if (c2 == null) {
            return null;
        }
        String className = this.getUtf8Info(c2.name);
        if (className.charAt(0) == '[') {
            return className;
        }
        return Descriptor.of((String)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public final int getNameAndTypeName(int index) {
        void var1_1;
        NameAndTypeInfo nameAndTypeInfo = (NameAndTypeInfo)this.getItem((int)var1_1);
        return nameAndTypeInfo.memberName;
    }

    /*
     * WARNING - void declaration
     */
    public final int getNameAndTypeDescriptor(int index) {
        void var1_1;
        NameAndTypeInfo nameAndTypeInfo = (NameAndTypeInfo)this.getItem((int)var1_1);
        return nameAndTypeInfo.typeDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    public final int getMemberClass(int index) {
        void var1_1;
        MemberrefInfo memberrefInfo = (MemberrefInfo)this.getItem((int)var1_1);
        return memberrefInfo.classIndex;
    }

    /*
     * WARNING - void declaration
     */
    public final int getMemberNameAndType(int index) {
        void var1_1;
        MemberrefInfo memberrefInfo = (MemberrefInfo)this.getItem((int)var1_1);
        return memberrefInfo.nameAndTypeIndex;
    }

    /*
     * WARNING - void declaration
     */
    public final int getFieldrefClass(int index) {
        void var1_1;
        FieldrefInfo fieldrefInfo = (FieldrefInfo)this.getItem((int)var1_1);
        return fieldrefInfo.classIndex;
    }

    /*
     * WARNING - void declaration
     */
    public final String getFieldrefClassName(int index) {
        void var1_2;
        FieldrefInfo f2 = (FieldrefInfo)this.getItem(index);
        if (f2 == null) {
            return null;
        }
        return this.getClassInfo(var1_2.classIndex);
    }

    /*
     * WARNING - void declaration
     */
    public final int getFieldrefNameAndType(int index) {
        void var1_1;
        FieldrefInfo fieldrefInfo = (FieldrefInfo)this.getItem((int)var1_1);
        return fieldrefInfo.nameAndTypeIndex;
    }

    /*
     * WARNING - void declaration
     */
    public final String getFieldrefName(int index) {
        void var1_2;
        FieldrefInfo f2 = (FieldrefInfo)this.getItem(index);
        if (f2 == null) {
            return null;
        }
        NameAndTypeInfo n2 = (NameAndTypeInfo)this.getItem(f2.nameAndTypeIndex);
        if (n2 == null) {
            return null;
        }
        return this.getUtf8Info(var1_2.memberName);
    }

    /*
     * WARNING - void declaration
     */
    public final String getFieldrefType(int index) {
        void var1_2;
        FieldrefInfo f2 = (FieldrefInfo)this.getItem(index);
        if (f2 == null) {
            return null;
        }
        NameAndTypeInfo n2 = (NameAndTypeInfo)this.getItem(f2.nameAndTypeIndex);
        if (n2 == null) {
            return null;
        }
        return this.getUtf8Info(var1_2.typeDescriptor);
    }

    /*
     * WARNING - void declaration
     */
    public final int getMethodrefClass(int index) {
        void var1_1;
        MemberrefInfo memberrefInfo = (MemberrefInfo)this.getItem((int)var1_1);
        return memberrefInfo.classIndex;
    }

    /*
     * WARNING - void declaration
     */
    public final String getMethodrefClassName(int index) {
        void var1_2;
        MemberrefInfo minfo = (MemberrefInfo)this.getItem(index);
        if (minfo == null) {
            return null;
        }
        return this.getClassInfo(var1_2.classIndex);
    }

    /*
     * WARNING - void declaration
     */
    public final int getMethodrefNameAndType(int index) {
        void var1_1;
        MemberrefInfo memberrefInfo = (MemberrefInfo)this.getItem((int)var1_1);
        return memberrefInfo.nameAndTypeIndex;
    }

    /*
     * WARNING - void declaration
     */
    public final String getMethodrefName(int index) {
        void var1_2;
        MemberrefInfo minfo = (MemberrefInfo)this.getItem(index);
        if (minfo == null) {
            return null;
        }
        NameAndTypeInfo n2 = (NameAndTypeInfo)this.getItem(minfo.nameAndTypeIndex);
        if (n2 == null) {
            return null;
        }
        return this.getUtf8Info(var1_2.memberName);
    }

    /*
     * WARNING - void declaration
     */
    public final String getMethodrefType(int index) {
        void var1_2;
        MemberrefInfo minfo = (MemberrefInfo)this.getItem(index);
        if (minfo == null) {
            return null;
        }
        NameAndTypeInfo n2 = (NameAndTypeInfo)this.getItem(minfo.nameAndTypeIndex);
        if (n2 == null) {
            return null;
        }
        return this.getUtf8Info(var1_2.typeDescriptor);
    }

    /*
     * WARNING - void declaration
     */
    public final int getInterfaceMethodrefClass(int index) {
        void var1_1;
        MemberrefInfo memberrefInfo = (MemberrefInfo)this.getItem((int)var1_1);
        return memberrefInfo.classIndex;
    }

    /*
     * WARNING - void declaration
     */
    public final String getInterfaceMethodrefClassName(int index) {
        void var1_2;
        MemberrefInfo minfo = (MemberrefInfo)this.getItem(index);
        return this.getClassInfo(var1_2.classIndex);
    }

    /*
     * WARNING - void declaration
     */
    public final int getInterfaceMethodrefNameAndType(int index) {
        void var1_1;
        MemberrefInfo memberrefInfo = (MemberrefInfo)this.getItem((int)var1_1);
        return memberrefInfo.nameAndTypeIndex;
    }

    /*
     * WARNING - void declaration
     */
    public final String getInterfaceMethodrefName(int index) {
        void var1_2;
        MemberrefInfo minfo = (MemberrefInfo)this.getItem(index);
        if (minfo == null) {
            return null;
        }
        NameAndTypeInfo n2 = (NameAndTypeInfo)this.getItem(minfo.nameAndTypeIndex);
        if (n2 == null) {
            return null;
        }
        return this.getUtf8Info(var1_2.memberName);
    }

    /*
     * WARNING - void declaration
     */
    public final String getInterfaceMethodrefType(int index) {
        void var1_2;
        MemberrefInfo minfo = (MemberrefInfo)this.getItem(index);
        if (minfo == null) {
            return null;
        }
        NameAndTypeInfo n2 = (NameAndTypeInfo)this.getItem(minfo.nameAndTypeIndex);
        if (n2 == null) {
            return null;
        }
        return this.getUtf8Info(var1_2.typeDescriptor);
    }

    /*
     * WARNING - void declaration
     */
    public final Object getLdcValue(int index) {
        void var3_3;
        void var2_2;
        ConstInfo constInfo = this.getItem(index);
        Object value = null;
        if (constInfo instanceof StringInfo) {
            value = this.getStringInfo(index);
        } else if (constInfo instanceof FloatInfo) {
            value = Float.valueOf(this.getFloatInfo(index));
        } else if (constInfo instanceof IntegerInfo) {
            value = this.getIntegerInfo(index);
        } else if (constInfo instanceof LongInfo) {
            value = this.getLongInfo(index);
        } else if (var2_2 instanceof DoubleInfo) {
            void var1_1;
            value = this.getDoubleInfo((int)var1_1);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final int getIntegerInfo(int index) {
        void var1_1;
        IntegerInfo integerInfo = (IntegerInfo)this.getItem((int)var1_1);
        return integerInfo.value;
    }

    /*
     * WARNING - void declaration
     */
    public final float getFloatInfo(int index) {
        void var1_1;
        FloatInfo floatInfo = (FloatInfo)this.getItem((int)var1_1);
        return floatInfo.value;
    }

    /*
     * WARNING - void declaration
     */
    public final long getLongInfo(int index) {
        void var1_1;
        LongInfo longInfo = (LongInfo)this.getItem((int)var1_1);
        return longInfo.value;
    }

    /*
     * WARNING - void declaration
     */
    public final double getDoubleInfo(int index) {
        void var1_1;
        DoubleInfo doubleInfo = (DoubleInfo)this.getItem((int)var1_1);
        return doubleInfo.value;
    }

    /*
     * WARNING - void declaration
     */
    public final String getStringInfo(int index) {
        void var1_2;
        StringInfo si = (StringInfo)this.getItem(index);
        return this.getUtf8Info(var1_2.string);
    }

    /*
     * WARNING - void declaration
     */
    public final String getUtf8Info(int index) {
        void var1_1;
        Utf8Info utf8Info = (Utf8Info)this.getItem((int)var1_1);
        return utf8Info.string;
    }

    /*
     * WARNING - void declaration
     */
    public final int getMethodHandleKind(int index) {
        void var1_1;
        MethodHandleInfo methodHandleInfo = (MethodHandleInfo)this.getItem((int)var1_1);
        return methodHandleInfo.refKind;
    }

    /*
     * WARNING - void declaration
     */
    public final int getMethodHandleIndex(int index) {
        void var1_1;
        MethodHandleInfo methodHandleInfo = (MethodHandleInfo)this.getItem((int)var1_1);
        return methodHandleInfo.refIndex;
    }

    /*
     * WARNING - void declaration
     */
    public final int getMethodTypeInfo(int index) {
        void var1_1;
        MethodTypeInfo methodTypeInfo = (MethodTypeInfo)this.getItem((int)var1_1);
        return methodTypeInfo.descriptor;
    }

    /*
     * WARNING - void declaration
     */
    public final int getInvokeDynamicBootstrap(int index) {
        void var1_1;
        InvokeDynamicInfo invokeDynamicInfo = (InvokeDynamicInfo)this.getItem((int)var1_1);
        return invokeDynamicInfo.bootstrap;
    }

    /*
     * WARNING - void declaration
     */
    public final int getInvokeDynamicNameAndType(int index) {
        void var1_1;
        InvokeDynamicInfo invokeDynamicInfo = (InvokeDynamicInfo)this.getItem((int)var1_1);
        return invokeDynamicInfo.nameAndType;
    }

    /*
     * WARNING - void declaration
     */
    public final String getInvokeDynamicType(int index) {
        void var1_2;
        InvokeDynamicInfo iv = (InvokeDynamicInfo)this.getItem(index);
        if (iv == null) {
            return null;
        }
        NameAndTypeInfo n2 = (NameAndTypeInfo)this.getItem(iv.nameAndType);
        if (n2 == null) {
            return null;
        }
        return this.getUtf8Info(var1_2.typeDescriptor);
    }

    /*
     * WARNING - void declaration
     */
    public final int getDynamicBootstrap(int index) {
        void var1_1;
        DynamicInfo dynamicInfo = (DynamicInfo)this.getItem((int)var1_1);
        return dynamicInfo.bootstrap;
    }

    /*
     * WARNING - void declaration
     */
    public final int getDynamicNameAndType(int index) {
        void var1_1;
        DynamicInfo dynamicInfo = (DynamicInfo)this.getItem((int)var1_1);
        return dynamicInfo.nameAndType;
    }

    /*
     * WARNING - void declaration
     */
    public final String getDynamicType(int index) {
        void var1_2;
        DynamicInfo iv = (DynamicInfo)this.getItem(index);
        if (iv == null) {
            return null;
        }
        NameAndTypeInfo n2 = (NameAndTypeInfo)this.getItem(iv.nameAndType);
        if (n2 == null) {
            return null;
        }
        return this.getUtf8Info(var1_2.typeDescriptor);
    }

    /*
     * WARNING - void declaration
     */
    public final String getModuleInfo(int index) {
        void var1_2;
        ModuleInfo mi = (ModuleInfo)this.getItem(index);
        return this.getUtf8Info(var1_2.name);
    }

    /*
     * WARNING - void declaration
     */
    public final String getPackageInfo(int index) {
        void var1_2;
        PackageInfo mi = (PackageInfo)this.getItem(index);
        return this.getUtf8Info(var1_2.name);
    }

    /*
     * WARNING - void declaration
     */
    public final int isConstructor(String classname, int index) {
        void var2_2;
        void var1_1;
        return this.isMember((String)var1_1, "<init>", (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final int isMember(String classname, String membername, int index) {
        MemberrefInfo minfo = (MemberrefInfo)this.getItem(index);
        if (this.getClassInfo(minfo.classIndex).equals(classname)) {
            void var2_2;
            void var3_4;
            NameAndTypeInfo ntinfo = (NameAndTypeInfo)this.getItem(var3_4.nameAndTypeIndex);
            if (this.getUtf8Info(ntinfo.memberName).equals(var2_2)) {
                void var1_1;
                return var1_1.typeDescriptor;
            }
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public final String eqMember(String membername, String desc, int index) {
        void var2_2;
        void var1_1;
        MemberrefInfo minfo = (MemberrefInfo)this.getItem(index);
        NameAndTypeInfo ntinfo = (NameAndTypeInfo)this.getItem(minfo.nameAndTypeIndex);
        if (this.getUtf8Info(ntinfo.memberName).equals(var1_1) && this.getUtf8Info(ntinfo.typeDescriptor).equals(var2_2)) {
            void var3_4;
            return this.getClassInfo(var3_4.classIndex);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private int addItem0(ConstInfo info) {
        void var1_1;
        this.items.addElement((ConstInfo)var1_1);
        return this.numOfItems++;
    }

    /*
     * WARNING - void declaration
     */
    private int addItem(ConstInfo info) {
        void var1_1;
        ConstInfo found;
        if (this.itemsCache == null) {
            this.itemsCache = ConstPool.makeItemsCache(this.items);
        }
        if ((found = this.itemsCache.get(info)) != null) {
            void var2_2;
            return var2_2.index;
        }
        this.items.addElement(info);
        void v0 = var1_1;
        this.itemsCache.put((ConstInfo)v0, (ConstInfo)v0);
        return this.numOfItems++;
    }

    /*
     * WARNING - void declaration
     */
    public final int copy(int n2, ConstPool dest, Map<String, String> classnames) {
        void var3_4;
        void var2_3;
        void var1_1;
        if (n2 == 0) {
            return 0;
        }
        ConstInfo constInfo = this.getItem((int)var1_1);
        return constInfo.copy(this, (ConstPool)var2_3, (Map<String, String>)var3_4);
    }

    final int addConstInfoPadding() {
        return this.addItem0(new ConstInfoPadding(this.numOfItems));
    }

    /*
     * WARNING - void declaration
     */
    public final int addClassInfo(CtClass c2) {
        void var1_1;
        if (c2 == THIS) {
            return this.thisClassInfo;
        }
        if (!c2.isArray()) {
            return this.addClassInfo(c2.getName());
        }
        return this.addClassInfo(Descriptor.toJvmName((CtClass)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final int addClassInfo(String qname) {
        void var1_2;
        int utf8 = this.addUtf8Info(Descriptor.toJvmName(qname));
        return this.addItem(new ClassInfo((int)var1_2, this.numOfItems));
    }

    /*
     * WARNING - void declaration
     */
    public final int addNameAndTypeInfo(String name, String type) {
        void var2_2;
        void var1_1;
        ConstPool constPool = this;
        return constPool.addNameAndTypeInfo(constPool.addUtf8Info((String)var1_1), this.addUtf8Info((String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final int addNameAndTypeInfo(int name, int type) {
        void var2_2;
        void var1_1;
        return this.addItem(new NameAndTypeInfo((int)var1_1, (int)var2_2, this.numOfItems));
    }

    /*
     * WARNING - void declaration
     */
    public final int addFieldrefInfo(int classInfo, String name, String type) {
        void var2_3;
        void var1_1;
        void var3_4;
        int nt = this.addNameAndTypeInfo(name, (String)var3_4);
        return this.addFieldrefInfo((int)var1_1, (int)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    public final int addFieldrefInfo(int classInfo, int nameAndTypeInfo) {
        void var2_2;
        void var1_1;
        return this.addItem(new FieldrefInfo((int)var1_1, (int)var2_2, this.numOfItems));
    }

    /*
     * WARNING - void declaration
     */
    public final int addMethodrefInfo(int classInfo, String name, String type) {
        void var2_3;
        void var1_1;
        void var3_4;
        int nt = this.addNameAndTypeInfo(name, (String)var3_4);
        return this.addMethodrefInfo((int)var1_1, (int)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    public final int addMethodrefInfo(int classInfo, int nameAndTypeInfo) {
        void var2_2;
        void var1_1;
        return this.addItem(new MethodrefInfo((int)var1_1, (int)var2_2, this.numOfItems));
    }

    /*
     * WARNING - void declaration
     */
    public final int addInterfaceMethodrefInfo(int classInfo, String name, String type) {
        void var2_3;
        void var1_1;
        void var3_4;
        int nt = this.addNameAndTypeInfo(name, (String)var3_4);
        return this.addInterfaceMethodrefInfo((int)var1_1, (int)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    public final int addInterfaceMethodrefInfo(int classInfo, int nameAndTypeInfo) {
        void var2_2;
        void var1_1;
        return this.addItem(new InterfaceMethodrefInfo((int)var1_1, (int)var2_2, this.numOfItems));
    }

    /*
     * WARNING - void declaration
     */
    public final int addStringInfo(String str) {
        void var1_2;
        int utf = this.addUtf8Info(str);
        return this.addItem(new StringInfo((int)var1_2, this.numOfItems));
    }

    /*
     * WARNING - void declaration
     */
    public final int addIntegerInfo(int i2) {
        void var1_1;
        return this.addItem(new IntegerInfo((int)var1_1, this.numOfItems));
    }

    /*
     * WARNING - void declaration
     */
    public final int addFloatInfo(float f2) {
        void var1_1;
        return this.addItem(new FloatInfo((float)var1_1, this.numOfItems));
    }

    /*
     * WARNING - void declaration
     */
    public final int addLongInfo(long l2) {
        void var1_2;
        int i2 = this.addItem(new LongInfo(l2, this.numOfItems));
        if (i2 == this.numOfItems - 1) {
            this.addConstInfoPadding();
        }
        return (int)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public final int addDoubleInfo(double d2) {
        void var1_2;
        int i2 = this.addItem(new DoubleInfo(d2, this.numOfItems));
        if (i2 == this.numOfItems - 1) {
            this.addConstInfoPadding();
        }
        return (int)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public final int addUtf8Info(String utf8) {
        void var1_1;
        return this.addItem(new Utf8Info((String)var1_1, this.numOfItems));
    }

    /*
     * WARNING - void declaration
     */
    public final int addMethodHandleInfo(int kind, int index) {
        void var2_2;
        void var1_1;
        return this.addItem(new MethodHandleInfo((int)var1_1, (int)var2_2, this.numOfItems));
    }

    /*
     * WARNING - void declaration
     */
    public final int addMethodTypeInfo(int desc) {
        void var1_1;
        return this.addItem(new MethodTypeInfo((int)var1_1, this.numOfItems));
    }

    /*
     * WARNING - void declaration
     */
    public final int addInvokeDynamicInfo(int bootstrap, int nameAndType) {
        void var2_2;
        void var1_1;
        return this.addItem(new InvokeDynamicInfo((int)var1_1, (int)var2_2, this.numOfItems));
    }

    /*
     * WARNING - void declaration
     */
    public final int addDynamicInfo(int bootstrap, int nameAndType) {
        void var2_2;
        void var1_1;
        return this.addItem(new DynamicInfo((int)var1_1, (int)var2_2, this.numOfItems));
    }

    /*
     * WARNING - void declaration
     */
    public final int addModuleInfo(int nameIndex) {
        void var1_1;
        return this.addItem(new ModuleInfo((int)var1_1, this.numOfItems));
    }

    /*
     * WARNING - void declaration
     */
    public final int addPackageInfo(int nameIndex) {
        void var1_1;
        return this.addItem(new PackageInfo((int)var1_1, this.numOfItems));
    }

    /*
     * WARNING - void declaration
     */
    public final Set<String> getClassNames() {
        void var1_1;
        HashSet<String> result = new HashSet<String>();
        LongVector v2 = this.items;
        int size = this.numOfItems;
        for (int i2 = 1; i2 < size; ++i2) {
            String className = v2.elementAt(i2).getClassName(this);
            if (className == null) continue;
            result.add(className);
        }
        return var1_1;
    }

    public final void renameClass(String oldName, String newName) {
        LongVector v2 = this.items;
        int size = this.numOfItems;
        for (int i2 = 1; i2 < size; ++i2) {
            ConstInfo constInfo = v2.elementAt(i2);
            constInfo.renameClass(this, oldName, newName, this.itemsCache);
        }
    }

    public final void renameClass(Map<String, String> classnames) {
        LongVector v2 = this.items;
        int size = this.numOfItems;
        for (int i2 = 1; i2 < size; ++i2) {
            ConstInfo constInfo = v2.elementAt(i2);
            constInfo.renameClass(this, classnames, this.itemsCache);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void read(DataInputStream in) throws IOException {
        int n2 = in.readUnsignedShort();
        this.items = new LongVector(n2);
        this.numOfItems = 0;
        this.addItem0(null);
        while (--n2 > 0) {
            void var3_3;
            int tag = this.readOne(in);
            if (tag != 5 && var3_3 != 6) continue;
            this.addConstInfoPadding();
            --n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Map<ConstInfo, ConstInfo> makeItemsCache(LongVector items) {
        void var1_1;
        ConstInfo info;
        HashMap<void, void> cache = new HashMap<void, void>();
        int i2 = 1;
        while ((info = items.elementAt(i2++)) != null) {
            void var3_3;
            void v0 = var3_3;
            cache.put(v0, v0);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private int readOne(DataInputStream in) throws IOException {
        void var2_2;
        void var1_1;
        int tag = in.readUnsignedByte();
        switch (tag) {
            case 1: {
                ConstInfo info = new Utf8Info(in, this.numOfItems);
                break;
            }
            case 3: {
                ConstInfo info;
                info = new IntegerInfo((DataInputStream)((Object)info), this.numOfItems);
                break;
            }
            case 4: {
                ConstInfo info;
                info = new FloatInfo((DataInputStream)((Object)info), this.numOfItems);
                break;
            }
            case 5: {
                ConstInfo info;
                info = new LongInfo((DataInputStream)((Object)info), this.numOfItems);
                break;
            }
            case 6: {
                ConstInfo info;
                info = new DoubleInfo((DataInputStream)((Object)info), this.numOfItems);
                break;
            }
            case 7: {
                ConstInfo info;
                info = new ClassInfo((DataInputStream)((Object)info), this.numOfItems);
                break;
            }
            case 8: {
                ConstInfo info;
                info = new StringInfo((DataInputStream)((Object)info), this.numOfItems);
                break;
            }
            case 9: {
                ConstInfo info;
                info = new FieldrefInfo((DataInputStream)((Object)info), this.numOfItems);
                break;
            }
            case 10: {
                ConstInfo info;
                info = new MethodrefInfo((DataInputStream)((Object)info), this.numOfItems);
                break;
            }
            case 11: {
                ConstInfo info;
                info = new InterfaceMethodrefInfo((DataInputStream)((Object)info), this.numOfItems);
                break;
            }
            case 12: {
                ConstInfo info;
                info = new NameAndTypeInfo((DataInputStream)((Object)info), this.numOfItems);
                break;
            }
            case 15: {
                ConstInfo info;
                info = new MethodHandleInfo((DataInputStream)((Object)info), this.numOfItems);
                break;
            }
            case 16: {
                ConstInfo info;
                info = new MethodTypeInfo((DataInputStream)((Object)info), this.numOfItems);
                break;
            }
            case 17: {
                ConstInfo info;
                info = new DynamicInfo((DataInputStream)((Object)info), this.numOfItems);
                break;
            }
            case 18: {
                ConstInfo info;
                info = new InvokeDynamicInfo((DataInputStream)((Object)info), this.numOfItems);
                break;
            }
            case 19: {
                ConstInfo info;
                info = new ModuleInfo((DataInputStream)((Object)info), this.numOfItems);
                break;
            }
            case 20: {
                ConstInfo info;
                info = new PackageInfo((DataInputStream)((Object)info), this.numOfItems);
                break;
            }
            default: {
                throw new IOException("invalid constant type: " + tag + " at " + this.numOfItems);
            }
        }
        this.addItem0((ConstInfo)var1_1);
        return (int)var2_2;
    }

    public final void write(DataOutputStream out) throws IOException {
        out.writeShort(this.numOfItems);
        LongVector v2 = this.items;
        int size = this.numOfItems;
        for (int i2 = 1; i2 < size; ++i2) {
            v2.elementAt(i2).write(out);
        }
    }

    public final void print() {
        this.print(new PrintWriter(System.out, true));
    }

    public final void print(PrintWriter out) {
        int size = this.numOfItems;
        for (int i2 = 1; i2 < size; ++i2) {
            out.print(i2);
            out.print(" ");
            this.items.elementAt(i2).print(out);
        }
    }
}

