/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode;

import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.BadBytecode;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ByteArray;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.CodeAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ConstPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ExceptionTable;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.LineNumberAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.LocalVariableAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.Opcode;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.StackMap;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.StackMapTable;
import java.util.ArrayList;
import java.util.List;

public class CodeIterator
implements Opcode {
    protected CodeAttribute codeAttr;
    protected byte[] bytecode;
    protected int endPos;
    protected int currentPos;
    protected int mark;
    protected int mark2;
    private static final int[] opcodeLength = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 2, 3, 3, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 0, 0, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 5, 5, 3, 2, 3, 1, 1, 3, 3, 1, 1, 0, 4, 3, 3, 5, 5};

    /*
     * WARNING - void declaration
     */
    protected CodeIterator(CodeAttribute ca) {
        void var1_1;
        this.codeAttr = ca;
        this.bytecode = var1_1.getCode();
        this.begin();
    }

    public void begin() {
        CodeIterator codeIterator = this;
        this.mark2 = 0;
        codeIterator.mark = 0;
        codeIterator.currentPos = 0;
        this.endPos = this.getCodeLength();
    }

    /*
     * WARNING - void declaration
     */
    public void move(int index) {
        void var1_1;
        this.currentPos = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setMark(int index) {
        void var1_1;
        this.mark = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setMark2(int index) {
        void var1_1;
        this.mark2 = var1_1;
    }

    public int getMark() {
        return this.mark;
    }

    public int getMark2() {
        return this.mark2;
    }

    public CodeAttribute get() {
        return this.codeAttr;
    }

    public int getCodeLength() {
        return this.bytecode.length;
    }

    /*
     * WARNING - void declaration
     */
    public int byteAt(int index) {
        void var1_1;
        return this.bytecode[var1_1] & 0xFF;
    }

    /*
     * WARNING - void declaration
     */
    public int signedByteAt(int index) {
        void var1_1;
        return this.bytecode[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public void writeByte(int value, int index) {
        void var1_1;
        this.bytecode[var2_2] = (byte)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public int u16bitAt(int index) {
        void var1_1;
        return ByteArray.readU16bit(this.bytecode, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public int s16bitAt(int index) {
        void var1_1;
        return ByteArray.readS16bit(this.bytecode, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void write16bit(int value, int index) {
        void var2_2;
        ByteArray.write16bit(value, this.bytecode, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public int s32bitAt(int index) {
        void var1_1;
        return ByteArray.read32bit(this.bytecode, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void write32bit(int value, int index) {
        void var2_2;
        ByteArray.write32bit(value, this.bytecode, (int)var2_2);
    }

    public void write(byte[] code, int index) {
        for (byte this.bytecode[index++] : code) {
        }
    }

    public boolean hasNext() {
        return this.currentPos < this.endPos;
    }

    /*
     * WARNING - void declaration
     */
    public int next() throws BadBytecode {
        void var1_1;
        int pos = this.currentPos;
        this.currentPos = CodeIterator.nextOpcode(this.bytecode, pos);
        return (int)var1_1;
    }

    public int lookAhead() {
        return this.currentPos;
    }

    public int skipConstructor() throws BadBytecode {
        return this.skipSuperConstructor0(-1);
    }

    public int skipSuperConstructor() throws BadBytecode {
        return this.skipSuperConstructor0(0);
    }

    public int skipThisConstructor() throws BadBytecode {
        return this.skipSuperConstructor0(1);
    }

    private int skipSuperConstructor0(int skipThis) throws BadBytecode {
        this.begin();
        Object cp = this.codeAttr.getConstPool();
        String thisClassName = this.codeAttr.getDeclaringClass();
        int nested = 0;
        while (this.hasNext()) {
            int mref;
            int index = this.next();
            int c2 = this.byteAt(index);
            if (c2 == 187) {
                ++nested;
                continue;
            }
            if (c2 != 183 || !((ConstPool)cp).getMethodrefName(mref = ByteArray.readU16bit(this.bytecode, index + 1)).equals("<init>") || --nested >= 0) continue;
            if (skipThis < 0) {
                return index;
            }
            if (((String)(cp = ((ConstPool)cp).getMethodrefClassName(mref))).equals(thisClassName) != skipThis > 0) break;
            return index;
        }
        this.begin();
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public int insert(byte[] code) throws BadBytecode {
        void var1_1;
        CodeIterator codeIterator = this;
        return codeIterator.insert0(codeIterator.currentPos, (byte[])var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public void insert(int pos, byte[] code) throws BadBytecode {
        void var2_2;
        void var1_1;
        this.insert0((int)var1_1, (byte[])var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public int insertAt(int pos, byte[] code) throws BadBytecode {
        void var2_2;
        void var1_1;
        return this.insert0((int)var1_1, (byte[])var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public int insertEx(byte[] code) throws BadBytecode {
        void var1_1;
        CodeIterator codeIterator = this;
        return codeIterator.insert0(codeIterator.currentPos, (byte[])var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public void insertEx(int pos, byte[] code) throws BadBytecode {
        void var2_2;
        void var1_1;
        this.insert0((int)var1_1, (byte[])var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    public int insertExAt(int pos, byte[] code) throws BadBytecode {
        void var2_2;
        void var1_1;
        return this.insert0((int)var1_1, (byte[])var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    private int insert0(int pos, byte[] code, boolean exclusive) throws BadBytecode {
        void var1_1;
        int len = code.length;
        if (len <= 0) {
            return pos;
        }
        int p2 = pos = this.insertGapAt((int)pos, (int)len, (boolean)exclusive).position;
        for (int j2 = 0; j2 < len; ++j2) {
            this.bytecode[p2++] = code[j2];
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public int insertGap(int length) throws BadBytecode {
        void var1_1;
        CodeIterator codeIterator = this;
        return codeIterator.insertGapAt((int)codeIterator.currentPos, (int)var1_1, (boolean)false).position;
    }

    /*
     * WARNING - void declaration
     */
    public int insertGap(int pos, int length) throws BadBytecode {
        void var2_2;
        void var1_1;
        return this.insertGapAt((int)var1_1, (int)var2_2, (boolean)false).length;
    }

    /*
     * WARNING - void declaration
     */
    public int insertExGap(int length) throws BadBytecode {
        void var1_1;
        CodeIterator codeIterator = this;
        return codeIterator.insertGapAt((int)codeIterator.currentPos, (int)var1_1, (boolean)true).position;
    }

    /*
     * WARNING - void declaration
     */
    public int insertExGap(int pos, int length) throws BadBytecode {
        void var2_2;
        void var1_1;
        return this.insertGapAt((int)var1_1, (int)var2_2, (boolean)true).length;
    }

    /*
     * WARNING - void declaration
     */
    public Gap insertGapAt(int pos, int length, boolean exclusive) throws BadBytecode {
        void var2_2;
        void var1_1;
        byte[] c2;
        Gap gap = new Gap();
        if (length <= 0) {
            gap.position = pos;
            gap.length = 0;
            return gap;
        }
        if (this.bytecode.length + length > Short.MAX_VALUE) {
            CodeIterator codeIterator = this;
            c2 = codeIterator.insertGapCore0w(codeIterator.bytecode, pos, length, exclusive, this.get().getExceptionTable(), this.codeAttr, gap);
            pos = gap.position;
        } else {
            void var3_3;
            int length2;
            int cur = this.currentPos;
            c2 = CodeIterator.insertGapCore0(this.bytecode, pos, length2, exclusive, this.get().getExceptionTable(), this.codeAttr);
            length2 = c2.length - this.bytecode.length;
            gap.position = pos;
            gap.length = length2;
            if (cur >= pos) {
                this.currentPos = cur + length2;
            }
            if (this.mark > pos || this.mark == pos && exclusive) {
                this.mark += length2;
            }
            if (this.mark2 > pos || this.mark2 == pos && var3_3 != false) {
                this.mark2 += length2;
            }
        }
        this.codeAttr.setCode(c2);
        this.bytecode = c2;
        this.endPos = this.getCodeLength();
        this.updateCursors((int)var1_1, (int)var2_2);
        return gap;
    }

    protected void updateCursors(int pos, int length) {
    }

    /*
     * WARNING - void declaration
     */
    public void insert(ExceptionTable et, int offset) {
        void var2_2;
        void var1_1;
        this.codeAttr.getExceptionTable().add(0, (ExceptionTable)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public int append(byte[] code) {
        void var2_2;
        int size = this.getCodeLength();
        int len = code.length;
        if (len <= 0) {
            return size;
        }
        this.appendGap(len);
        byte[] dest = this.bytecode;
        for (int i2 = 0; i2 < len; ++i2) {
            dest[i2 + size] = code[i2];
        }
        return (int)var2_2;
    }

    public void appendGap(int gapLength) {
        int i2;
        byte[] code = this.bytecode;
        int codeLength = this.bytecode.length;
        byte[] newcode = new byte[codeLength + gapLength];
        for (i2 = 0; i2 < codeLength; ++i2) {
            newcode[i2] = code[i2];
        }
        for (i2 = codeLength; i2 < codeLength + gapLength; ++i2) {
            newcode[i2] = 0;
        }
        this.codeAttr.setCode(newcode);
        this.bytecode = newcode;
        this.endPos = this.getCodeLength();
    }

    /*
     * WARNING - void declaration
     */
    public void append(ExceptionTable et, int offset) {
        void var2_2;
        void var1_1;
        void var3_3;
        ExceptionTable table = this.codeAttr.getExceptionTable();
        table.add(var3_3.size(), (ExceptionTable)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static int nextOpcode(byte[] code, int index) throws BadBytecode {
        void var2_3;
        int opcode;
        block9: {
            try {
                opcode = code[index] & 0xFF;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new BadBytecode("invalid opcode address");
            }
            try {
                int len = opcodeLength[opcode];
                if (len > 0) {
                    return index + len;
                }
                if (opcode != 196) break block9;
                if (code[index + 1] == -124) {
                    return index + 6;
                }
                return index + 4;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        }
        int index2 = (index & 0xFFFFFFFC) + 8;
        if (opcode == 171) {
            int npairs = ByteArray.read32bit(code, index2);
            return index2 + (npairs << 3) + 4;
        }
        if (opcode == 170) {
            void var3_4;
            void var0_1;
            void var1_2;
            int low = ByteArray.read32bit(code, index2);
            int high = ByteArray.read32bit(code, index2 + 4);
            return (int)(var1_2 + (var0_1 - var3_4 + true << 2) + 8);
        }
        throw new BadBytecode((int)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    static byte[] insertGapCore0(byte[] code, int where, int gapLength, boolean exclusive, ExceptionTable etable, CodeAttribute ca) throws BadBytecode {
        if (gapLength <= 0) {
            return code;
        }
        try {
            return CodeIterator.insertGapCore1(code, where, gapLength, exclusive, etable, ca);
        }
        catch (AlignmentException alignmentException) {
            try {
                void var3_3;
                void var2_2;
                void var1_1;
                byte[] byArray;
                return CodeIterator.insertGapCore1(byArray, (int)var1_1, var2_2 + 3 & 0xFFFFFFFC, (boolean)var3_3, etable, ca);
            }
            catch (AlignmentException alignmentException2) {
                throw new RuntimeException("fatal error?");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] insertGapCore1(byte[] code, int where, int gapLength, boolean exclusive, ExceptionTable etable, CodeAttribute ca) throws BadBytecode, AlignmentException {
        Object sm;
        Object smt;
        Object vta;
        Object va;
        int codeLength = code.length;
        byte[] newcode = new byte[codeLength + gapLength];
        CodeIterator.insertGap2(code, where, gapLength, codeLength, newcode, exclusive);
        etable.shiftPc(where, gapLength, exclusive);
        LineNumberAttribute lineNumberAttribute = (LineNumberAttribute)ca.getAttribute("LineNumberTable");
        Object na = lineNumberAttribute;
        if (lineNumberAttribute != null) {
            ((LineNumberAttribute)na).shiftPc(where, gapLength, exclusive);
        }
        if ((va = (LocalVariableAttribute)ca.getAttribute("LocalVariableTable")) != null) {
            ((LocalVariableAttribute)va).shiftPc(where, gapLength, exclusive);
        }
        if ((vta = (LocalVariableAttribute)ca.getAttribute("LocalVariableTypeTable")) != null) {
            ((LocalVariableAttribute)vta).shiftPc(where, gapLength, exclusive);
        }
        if ((smt = (StackMapTable)ca.getAttribute("StackMapTable")) != null) {
            ((StackMapTable)smt).shiftPc(where, gapLength, exclusive);
        }
        if ((sm = (StackMap)ca.getAttribute("StackMap")) != null) {
            void var3_3;
            void var2_2;
            void var1_1;
            Object object;
            ((StackMap)object).shiftPc((int)var1_1, (int)var2_2, (boolean)var3_3);
        }
        return newcode;
    }

    private static void insertGap2(byte[] code, int where, int gapLength, int endPos, byte[] newcode, boolean exclusive) throws BadBytecode, AlignmentException {
        int i2 = 0;
        int j2 = 0;
        while (i2 < endPos) {
            int lowbyte;
            int i22;
            int offset;
            if (i2 == where) {
                int j22 = j2 + gapLength;
                while (j2 < j22) {
                    newcode[j2++] = 0;
                }
            }
            int nextPos = CodeIterator.nextOpcode(code, i2);
            int inst = code[i2] & 0xFF;
            if (153 <= inst && inst <= 168 || inst == 198 || inst == 199) {
                offset = code[i2 + 1] << 8 | code[i2 + 2] & 0xFF;
                offset = CodeIterator.newOffset(i2, offset, where, gapLength, exclusive);
                newcode[j2] = code[i2];
                ByteArray.write16bit(offset, newcode, j2 + 1);
                j2 += 3;
            } else if (offset == 200 || offset == 201) {
                offset = ByteArray.read32bit(code, i2 + 1);
                offset = CodeIterator.newOffset(i2, offset, where, gapLength, exclusive);
                newcode[j2++] = code[i2];
                ByteArray.write32bit(offset, newcode, j2);
                j2 += 4;
            } else if (offset == 170) {
                if (i2 != j2 && (gapLength & 3) != 0) {
                    throw new AlignmentException();
                }
                i22 = (i2 & 0xFFFFFFFC) + 4;
                j2 = CodeIterator.copyGapBytes(newcode, j2, code, i2, i22);
                int n2 = CodeIterator.newOffset(i2, ByteArray.read32bit(code, i22), where, gapLength, exclusive);
                ByteArray.write32bit(n2, newcode, j2);
                lowbyte = ByteArray.read32bit(code, i22 + 4);
                ByteArray.write32bit(lowbyte, newcode, j2 + 4);
                int highbyte = ByteArray.read32bit(code, i22 + 8);
                ByteArray.write32bit(highbyte, newcode, j2 + 8);
                j2 += 12;
                int i0 = i22 + 12;
                i22 = i0 + (highbyte - lowbyte + 1 << 2);
                while (i0 < i22) {
                    lowbyte = CodeIterator.newOffset(i2, ByteArray.read32bit(code, i0), where, gapLength, exclusive);
                    ByteArray.write32bit(lowbyte, newcode, j2);
                    j2 += 4;
                    i0 += 4;
                }
            } else if (i22 == 171) {
                if (i2 != j2 && (gapLength & 3) != 0) {
                    throw new AlignmentException();
                }
                i22 = (i2 & 0xFFFFFFFC) + 4;
                j2 = CodeIterator.copyGapBytes(newcode, j2, code, i2, i22);
                lowbyte = CodeIterator.newOffset(i2, ByteArray.read32bit(code, i22), where, gapLength, exclusive);
                ByteArray.write32bit(lowbyte, newcode, j2);
                int npairs = ByteArray.read32bit(code, i22 + 4);
                ByteArray.write32bit(npairs, newcode, j2 + 4);
                j2 += 8;
                int i0 = i22 + 8;
                i22 = i0 + (npairs << 3);
                while (i0 < i22) {
                    ByteArray.copy32bit(code, i0, newcode, j2);
                    int n3 = CodeIterator.newOffset(i2, ByteArray.read32bit(code, i0 + 4), where, gapLength, exclusive);
                    ByteArray.write32bit(n3, newcode, j2 + 4);
                    j2 += 8;
                    i0 += 8;
                }
            } else {
                while (i2 < nextPos) {
                    newcode[j2++] = code[i2++];
                }
            }
            i2 = nextPos;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static int copyGapBytes(byte[] newcode, int j2, byte[] code, int i2, int iEnd) {
        void var1_1;
        switch (iEnd - i2) {
            case 4: {
                newcode[j2++] = code[i2++];
            }
            case 3: {
                newcode[j2++] = code[i2++];
            }
            case 2: {
                newcode[j2++] = code[i2++];
            }
            case 1: {
                void var3_3;
                void var2_2;
                var0[j2++] = var2_2[var3_3];
            }
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static int newOffset(int i2, int offset, int where, int gapLength, boolean exclusive) {
        void var1_1;
        void var2_2;
        int n2;
        int target = i2 + offset;
        if (i2 < where) {
            if (where < target || exclusive && where == target) {
                offset += gapLength;
            }
        } else if (n2 == where ? target < where : target < where || !exclusive && var2_2 == target) {
            void var3_3;
            offset -= var3_3;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static byte[] changeLdcToLdcW(byte[] code, ExceptionTable etable, CodeAttribute ca, CodeAttribute.LdcEntry ldcs) throws BadBytecode {
        void var1_1;
        void var2_2;
        byte[] byArray;
        Pointers pointers = new Pointers(0, 0, 0, 0, etable, ca);
        List<Branch> jumps = CodeIterator.makeJumpList(code, code.length, pointers);
        while (ldcs != null) {
            CodeIterator.addLdcW(ldcs, jumps);
            ldcs = ldcs.next;
        }
        byArray = CodeIterator.insertGap2w(byArray, 0, 0, false, (List<Branch>)var2_2, (Pointers)var1_1);
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    private static void addLdcW(CodeAttribute.LdcEntry ldcs, List<Branch> jumps) {
        LdcW ldcW;
        void var1_1;
        int where = ldcs.where;
        LdcW ldcw = new LdcW(where, ldcs.index);
        int s2 = jumps.size();
        for (int i2 = 0; i2 < s2; ++i2) {
            if (where >= jumps.get((int)i2).orgPos) continue;
            jumps.add(i2, ldcw);
            return;
        }
        var1_1.add(ldcW);
    }

    /*
     * WARNING - void declaration
     */
    private byte[] insertGapCore0w(byte[] code, int where, int gapLength, boolean exclusive, ExceptionTable etable, CodeAttribute ca, Gap newWhere) throws BadBytecode {
        void var1_1;
        void var3_3;
        void var2_2;
        if (gapLength <= 0) {
            return code;
        }
        Pointers pointers = new Pointers(this.currentPos, this.mark, this.mark2, where, etable, ca);
        List<Branch> jumps = CodeIterator.makeJumpList(code, code.length, pointers);
        byte[] r2 = CodeIterator.insertGap2w(code, where, gapLength, exclusive, jumps, pointers);
        this.currentPos = pointers.cursor;
        this.mark = pointers.mark;
        this.mark2 = pointers.mark2;
        int where2 = pointers.mark0;
        if (where2 == this.currentPos && !exclusive) {
            this.currentPos += gapLength;
        }
        if (exclusive) {
            where2 -= gapLength;
        }
        newWhere.position = var2_2;
        newWhere.length = var3_3;
        return var1_1;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private static byte[] insertGap2w(byte[] code, int where, int gapLength, boolean exclusive, List<Branch> jumps, Pointers ptrs) throws BadBytecode {
        if (gapLength > 0) {
            ptrs.shiftPc(where, gapLength, exclusive);
            for (Object var7_12 : jumps) {
                var7_12.shift(where, gapLength, exclusive);
            }
        }
        unstable = true;
        block1: while (true) {
            if (unstable) {
                unstable = false;
                var7_12 = jumps.iterator();
                block2: while (true) {
                    if (!var7_12.hasNext()) continue block1;
                    b = var7_12.next();
                    if (!b.expanded()) continue;
                    unstable = true;
                    p = b.pos;
                    delta = b.deltaSize();
                    ptrs.shiftPc(p, delta, false);
                    var9_14 = jumps.iterator();
                    while (true) {
                        if (var9_14.hasNext()) ** break;
                        continue block2;
                        var10_15 = var9_14.next();
                        var10_15.shift(p, delta, false);
                    }
                    break;
                }
            }
            for (Branch b : jumps) {
                diff = b.gapChanged();
                if (diff <= 0) continue;
                unstable = true;
                p = b.pos;
                ptrs.shiftPc(p, diff, false);
                for (Branch var10_15 : jumps) {
                    var10_15.shift(p, diff, false);
                }
            }
            if (!unstable) break;
        }
        return CodeIterator.makeExapndedCode(var0, jumps, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static List<Branch> makeJumpList(byte[] code, int endPos, Pointers ptrs) throws BadBytecode {
        void var3_3;
        ArrayList<Branch> jumps = new ArrayList<Branch>();
        int i2 = 0;
        while (i2 < endPos) {
            int defaultbyte;
            void b2;
            int nextPos = CodeIterator.nextOpcode(code, i2);
            int inst = code[i2] & 0xFF;
            if (153 <= inst && inst <= 168 || inst == 198 || inst == 199) {
                int offset = code[i2 + 1] << 8 | code[i2 + 2] & 0xFF;
                Branch16 b3 = inst == 167 || inst == 168 ? new Jump16(i2, offset) : new If16(i2, offset);
                jumps.add(b3);
            } else if (b2 == 200 || b2 == 201) {
                int offset = ByteArray.read32bit(code, i2 + 1);
                jumps.add(new Jump32(i2, offset));
            } else if (b2 == 170) {
                int i22 = (i2 & 0xFFFFFFFC) + 4;
                defaultbyte = ByteArray.read32bit(code, i22);
                int lowbyte = ByteArray.read32bit(code, i22 + 4);
                int highbyte = ByteArray.read32bit(code, i22 + 8);
                int i0 = i22 + 12;
                int size = highbyte - lowbyte + 1;
                int[] offsets = new int[size];
                for (int j2 = 0; j2 < size; ++j2) {
                    offsets[j2] = ByteArray.read32bit(code, i0);
                    i0 += 4;
                }
                jumps.add(new Table(i2, defaultbyte, lowbyte, highbyte, offsets, ptrs));
            } else if (defaultbyte == 171) {
                int i23 = (i2 & 0xFFFFFFFC) + 4;
                defaultbyte = ByteArray.read32bit(code, i23);
                int npairs = ByteArray.read32bit(code, i23 + 4);
                int i0 = i23 + 8;
                int[] matches = new int[npairs];
                int[] offsets = new int[npairs];
                for (int j3 = 0; j3 < npairs; ++j3) {
                    matches[j3] = ByteArray.read32bit(code, i0);
                    offsets[j3] = ByteArray.read32bit(code, i0 + 4);
                    i0 += 8;
                }
                jumps.add(new Lookup(i2, defaultbyte, matches, offsets, ptrs));
            }
            i2 = nextPos;
        }
        return var3_3;
    }

    private static byte[] makeExapndedCode(byte[] code, List<Branch> jumps, int where, int gapLength) throws BadBytecode {
        int bpos;
        Branch b2;
        int n2 = jumps.size();
        int size = code.length + gapLength;
        for (Branch b3 : jumps) {
            size += b3.deltaSize();
        }
        byte[] newcode = new byte[size];
        int src = 0;
        int dest = 0;
        int bindex = 0;
        int len = code.length;
        if (n2 > 0) {
            b2 = jumps.get(0);
            bpos = b2.orgPos;
        } else {
            b2 = null;
            bpos = len;
        }
        while (src < len) {
            if (src == where) {
                int pos2 = dest + gapLength;
                while (dest < pos2) {
                    newcode[dest++] = 0;
                }
            }
            if (src != bpos) {
                newcode[dest++] = code[src++];
                continue;
            }
            int s2 = b2.write(src, code, dest, newcode);
            src += s2;
            dest += s2 + b2.deltaSize();
            if (++bindex < n2) {
                b2 = jumps.get(bindex);
                bpos = b2.orgPos;
                continue;
            }
            b2 = null;
            bpos = len;
        }
        return newcode;
    }

    public static class Gap {
        public int position;
        public int length;
    }

    static class AlignmentException
    extends Exception {
        private static final long serialVersionUID = 1L;

        AlignmentException() {
        }
    }

    static class Pointers {
        int cursor;
        int mark0;
        int mark;
        int mark2;
        ExceptionTable etable;
        LineNumberAttribute line;
        LocalVariableAttribute vars;
        LocalVariableAttribute types;
        StackMapTable stack;
        StackMap stack2;

        /*
         * WARNING - void declaration
         */
        Pointers(int cur, int m2, int m22, int m0, ExceptionTable et, CodeAttribute ca) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.cursor = var1_1;
            this.mark = var2_2;
            this.mark2 = var3_3;
            this.mark0 = m0;
            this.etable = et;
            this.line = (LineNumberAttribute)ca.getAttribute("LineNumberTable");
            this.vars = (LocalVariableAttribute)ca.getAttribute("LocalVariableTable");
            this.types = (LocalVariableAttribute)ca.getAttribute("LocalVariableTypeTable");
            this.stack = (StackMapTable)ca.getAttribute("StackMapTable");
            this.stack2 = (StackMap)ca.getAttribute("StackMap");
        }

        /*
         * WARNING - void declaration
         */
        void shiftPc(int where, int gapLength, boolean exclusive) throws BadBytecode {
            if (where < this.cursor || where == this.cursor && exclusive) {
                this.cursor += gapLength;
            }
            if (where < this.mark || where == this.mark && exclusive) {
                this.mark += gapLength;
            }
            if (where < this.mark2 || where == this.mark2 && exclusive) {
                this.mark2 += gapLength;
            }
            if (where < this.mark0 || where == this.mark0 && exclusive) {
                this.mark0 += gapLength;
            }
            this.etable.shiftPc(where, gapLength, exclusive);
            if (this.line != null) {
                this.line.shiftPc(where, gapLength, exclusive);
            }
            if (this.vars != null) {
                this.vars.shiftPc(where, gapLength, exclusive);
            }
            if (this.types != null) {
                this.types.shiftPc(where, gapLength, exclusive);
            }
            if (this.stack != null) {
                this.stack.shiftPc(where, gapLength, exclusive);
            }
            if (this.stack2 != null) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.stack2.shiftPc((int)var1_1, (int)var2_2, (boolean)var3_3);
            }
        }

        /*
         * WARNING - void declaration
         */
        void shiftForSwitch(int where, int gapLength) throws BadBytecode {
            if (this.stack != null) {
                this.stack.shiftForSwitch(where, gapLength);
            }
            if (this.stack2 != null) {
                void var2_2;
                void var1_1;
                this.stack2.shiftForSwitch((int)var1_1, (int)var2_2);
            }
        }
    }

    static class LdcW
    extends Branch {
        int index;
        boolean state;

        /*
         * WARNING - void declaration
         */
        LdcW(int p2, int i2) {
            super((int)var1_1);
            void var2_2;
            void var1_1;
            this.index = var2_2;
            this.state = true;
        }

        @Override
        boolean expanded() {
            if (this.state) {
                this.state = false;
                return true;
            }
            return false;
        }

        @Override
        int deltaSize() {
            return 1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        int write(int srcPos, byte[] code, int destPos, byte[] newcode) {
            void var3_3;
            newcode[destPos] = 19;
            ByteArray.write16bit(this.index, newcode, (int)(var3_3 + true));
            return 2;
        }
    }

    static abstract class Branch {
        int pos;
        int orgPos;

        /*
         * WARNING - void declaration
         */
        Branch(int p2) {
            void var1_1;
            Branch branch = this;
            branch.pos = branch.orgPos = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        void shift(int where, int gapLength, boolean exclusive) {
            void var3_3;
            void var1_1;
            if (where < this.pos || var1_1 == this.pos && var3_3 != false) {
                void var2_2;
                this.pos += var2_2;
            }
        }

        /*
         * WARNING - void declaration
         */
        static int shiftOffset(int i2, int offset, int where, int gapLength, boolean exclusive) {
            void var1_1;
            block7: {
                void var3_3;
                block9: {
                    void var2_2;
                    int target;
                    block8: {
                        int n2;
                        block6: {
                            target = i2 + offset;
                            if (i2 >= where) break block6;
                            if (where < target || exclusive && where == target) {
                                offset += gapLength;
                            }
                            break block7;
                        }
                        if (n2 != where) break block8;
                        if (target < where && exclusive) break block9;
                        if (where < target && !exclusive) {
                            offset += gapLength;
                        }
                        break block7;
                    }
                    if (target >= where && (exclusive || var2_2 != target)) break block7;
                }
                offset -= var3_3;
            }
            return (int)var1_1;
        }

        boolean expanded() {
            return false;
        }

        int gapChanged() {
            return 0;
        }

        int deltaSize() {
            return 0;
        }

        abstract int write(int var1, byte[] var2, int var3, byte[] var4) throws BadBytecode;
    }

    static class Jump16
    extends Branch16 {
        /*
         * WARNING - void declaration
         */
        Jump16(int p2, int off) {
            super((int)var1_1, (int)var2_2);
            void var2_2;
            void var1_1;
        }

        @Override
        int deltaSize() {
            if (this.state == 2) {
                return 2;
            }
            return 0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        void write32(int src, byte[] code, int dest, byte[] newcode) {
            void var3_3;
            void var1_1;
            void var2_2;
            newcode[dest] = (byte)((var2_2[var1_1] & 0xFF) == 167 ? 200 : 201);
            ByteArray.write32bit(this.offset, newcode, (int)(var3_3 + true));
        }
    }

    static class If16
    extends Branch16 {
        /*
         * WARNING - void declaration
         */
        If16(int p2, int off) {
            super((int)var1_1, (int)var2_2);
            void var2_2;
            void var1_1;
        }

        @Override
        int deltaSize() {
            if (this.state == 2) {
                return 5;
            }
            return 0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        void write32(int src, byte[] code, int dest, byte[] newcode) {
            void var3_3;
            void var1_1;
            void var2_2;
            newcode[dest] = (byte)this.opcode((int)(var2_2[var1_1] & 0xFF));
            newcode[dest + 1] = 0;
            newcode[dest + 2] = 8;
            newcode[dest + 3] = -56;
            ByteArray.write32bit(this.offset - 3, newcode, (int)(var3_3 + 4));
        }

        /*
         * WARNING - void declaration
         */
        int opcode(int op) {
            void var1_1;
            if (op == 198) {
                return 199;
            }
            if (op == 199) {
                return 198;
            }
            if ((op - 153 & 1) == 0) {
                return op + 1;
            }
            return (int)(var1_1 - true);
        }
    }

    static class Jump32
    extends Branch {
        int offset;

        /*
         * WARNING - void declaration
         */
        Jump32(int p2, int off) {
            super((int)var1_1);
            void var2_2;
            void var1_1;
            this.offset = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        void shift(int where, int gapLength, boolean exclusive) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.offset = Jump32.shiftOffset(this.pos, this.offset, where, gapLength, exclusive);
            super.shift((int)var1_1, (int)var2_2, (boolean)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        int write(int src, byte[] code, int dest, byte[] newcode) {
            void var3_3;
            void var1_1;
            void var2_2;
            newcode[dest] = var2_2[var1_1];
            ByteArray.write32bit(this.offset, newcode, (int)(var3_3 + true));
            return 5;
        }
    }

    static class Table
    extends Switcher {
        int low;
        int high;

        /*
         * WARNING - void declaration
         */
        Table(int pos, int defaultByte, int low, int high, int[] offsets, Pointers ptrs) {
            super((int)var1_1, (int)var2_2, offsets, ptrs);
            void var3_3;
            void var2_2;
            void var1_1;
            this.low = var3_3;
            this.high = high;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        int write2(int dest, byte[] newcode) {
            void var3_3;
            ByteArray.write32bit(this.low, newcode, dest);
            ByteArray.write32bit(this.high, newcode, dest + 4);
            int n2 = this.offsets.length;
            dest += 8;
            for (int i2 = 0; i2 < n2; ++i2) {
                ByteArray.write32bit(this.offsets[i2], newcode, dest);
                dest += 4;
            }
            return 8 + 4 * var3_3;
        }

        @Override
        int tableSize() {
            return 8 + 4 * this.offsets.length;
        }
    }

    static class Lookup
    extends Switcher {
        int[] matches;

        /*
         * WARNING - void declaration
         */
        Lookup(int pos, int defaultByte, int[] matches, int[] offsets, Pointers ptrs) {
            super((int)var1_1, (int)var2_2, offsets, ptrs);
            void var3_3;
            void var2_2;
            void var1_1;
            this.matches = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        int write2(int dest, byte[] newcode) {
            void var3_3;
            int n2 = this.matches.length;
            ByteArray.write32bit(n2, newcode, dest);
            dest += 4;
            for (int i2 = 0; i2 < n2; ++i2) {
                ByteArray.write32bit(this.matches[i2], newcode, dest);
                ByteArray.write32bit(this.offsets[i2], newcode, dest + 4);
                dest += 8;
            }
            return 4 + var3_3 * 8;
        }

        @Override
        int tableSize() {
            return 4 + 8 * this.matches.length;
        }
    }

    static abstract class Switcher
    extends Branch {
        int gap;
        int defaultByte;
        int[] offsets;
        Pointers pointers;

        /*
         * WARNING - void declaration
         */
        Switcher(int pos, int defaultByte, int[] offsets, Pointers ptrs) {
            super(pos);
            void var3_3;
            void var2_2;
            void var1_1;
            this.gap = 3 - (var1_1 & 3);
            this.defaultByte = var2_2;
            this.offsets = var3_3;
            this.pointers = ptrs;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        void shift(int where, int gapLength, boolean exclusive) {
            void var3_3;
            void var2_2;
            void var1_1;
            int p2 = this.pos;
            this.defaultByte = Switcher.shiftOffset(p2, this.defaultByte, where, gapLength, exclusive);
            int num = this.offsets.length;
            for (int i2 = 0; i2 < num; ++i2) {
                this.offsets[i2] = Switcher.shiftOffset(p2, this.offsets[i2], where, gapLength, exclusive);
            }
            super.shift((int)var1_1, (int)var2_2, (boolean)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        int gapChanged() {
            int newGap = 3 - (this.pos & 3);
            if (newGap > this.gap) {
                void var2_2;
                void var1_1;
                int diff = newGap - this.gap;
                this.gap = var1_1;
                return (int)var2_2;
            }
            return 0;
        }

        @Override
        int deltaSize() {
            return this.gap - (3 - (this.orgPos & 3));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        int write(int src, byte[] code, int dest, byte[] newcode) throws BadBytecode {
            void var1_1;
            void var2_2;
            int padding = 3 - (this.pos & 3);
            int nops = this.gap - padding;
            int bytecodeSize = 5 + (3 - (this.orgPos & 3)) + this.tableSize();
            if (nops > 0) {
                this.adjustOffsets(bytecodeSize, nops);
            }
            newcode[dest++] = var2_2[src];
            while (padding-- > 0) {
                newcode[dest++] = 0;
            }
            ByteArray.write32bit(this.defaultByte, newcode, dest);
            int size = this.write2(dest + 4, newcode);
            dest += size + 4;
            while (nops-- > 0) {
                newcode[dest++] = 0;
            }
            return 5 + (3 - (this.orgPos & 3)) + var1_1;
        }

        abstract int write2(int var1, byte[] var2);

        abstract int tableSize();

        void adjustOffsets(int size, int nops) throws BadBytecode {
            this.pointers.shiftForSwitch(this.pos + size, nops);
            if (this.defaultByte == size) {
                this.defaultByte -= nops;
            }
            for (int i2 = 0; i2 < this.offsets.length; ++i2) {
                if (this.offsets[i2] != size) continue;
                int n2 = i2;
                this.offsets[n2] = this.offsets[n2] - nops;
            }
        }
    }

    static abstract class Branch16
    extends Branch {
        int offset;
        int state;
        static final int BIT16 = 0;
        static final int EXPAND = 1;
        static final int BIT32 = 2;

        /*
         * WARNING - void declaration
         */
        Branch16(int p2, int off) {
            super((int)var1_1);
            void var2_2;
            void var1_1;
            this.offset = var2_2;
            this.state = 0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        void shift(int where, int gapLength, boolean exclusive) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.offset = Branch16.shiftOffset(this.pos, this.offset, where, gapLength, exclusive);
            super.shift((int)var1_1, (int)var2_2, (boolean)var3_3);
            if (this.state == 0 && (this.offset < Short.MIN_VALUE || Short.MAX_VALUE < this.offset)) {
                this.state = 1;
            }
        }

        @Override
        boolean expanded() {
            if (this.state == 1) {
                this.state = 2;
                return true;
            }
            return false;
        }

        @Override
        abstract int deltaSize();

        abstract void write32(int var1, byte[] var2, int var3, byte[] var4);

        /*
         * WARNING - void declaration
         */
        @Override
        int write(int src, byte[] code, int dest, byte[] newcode) {
            if (this.state == 2) {
                this.write32(src, code, dest, newcode);
            } else {
                void var3_3;
                void var1_1;
                void var2_2;
                newcode[dest] = var2_2[var1_1];
                ByteArray.write16bit(this.offset, newcode, (int)(var3_3 + true));
            }
            return 3;
        }
    }
}

