/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode;

import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.AttributeInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.BadBytecode;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.CodeAnalyzer;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.CodeIterator;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ConstPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ExceptionTable;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.Opcode;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.StackMap;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.StackMapTable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CodeAttribute
extends AttributeInfo
implements Opcode {
    public static final String tag = "Code";
    private int maxStack;
    private int maxLocals;
    private ExceptionTable exceptions;
    private List<AttributeInfo> attributes;

    /*
     * WARNING - void declaration
     */
    public CodeAttribute(ConstPool cp, int stack, int locals, byte[] code, ExceptionTable etable) {
        super((ConstPool)var1_1, tag);
        void var3_3;
        void var2_2;
        void var1_1;
        this.maxStack = var2_2;
        this.maxLocals = var3_3;
        this.info = code;
        this.exceptions = etable;
        this.attributes = new ArrayList<AttributeInfo>();
    }

    /*
     * WARNING - void declaration
     */
    private CodeAttribute(ConstPool cp, CodeAttribute src, Map<String, String> classnames) throws BadBytecode {
        super(cp, tag);
        void var3_3;
        void var1_1;
        void var2_2;
        this.maxStack = src.getMaxStack();
        this.maxLocals = src.getMaxLocals();
        this.exceptions = src.getExceptionTable().copy(cp, classnames);
        this.attributes = new ArrayList<AttributeInfo>();
        List<AttributeInfo> src_attr = src.getAttributes();
        int num = src_attr.size();
        for (int i2 = 0; i2 < num; ++i2) {
            AttributeInfo ai = src_attr.get(i2);
            this.attributes.add(ai.copy(cp, classnames));
        }
        this.info = super.copyCode((ConstPool)var1_1, (Map<String, String>)var3_3, this.exceptions, this);
    }

    CodeAttribute(ConstPool cp, int name_id, DataInputStream in) throws IOException {
        super(cp, name_id, (byte[])null);
        in.readInt();
        this.maxStack = in.readUnsignedShort();
        this.maxLocals = in.readUnsignedShort();
        int code_len = in.readInt();
        this.info = new byte[code_len];
        in.readFully(this.info);
        this.exceptions = new ExceptionTable(cp, in);
        this.attributes = new ArrayList<AttributeInfo>();
        int num = in.readUnsignedShort();
        for (int i2 = 0; i2 < num; ++i2) {
            this.attributes.add(AttributeInfo.read(cp, in));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AttributeInfo copy(ConstPool newCp, Map<String, String> classnames) throws RuntimeCopyException {
        try {
            void var2_2;
            void var1_1;
            return new CodeAttribute((ConstPool)var1_1, this, (Map<String, String>)var2_2);
        }
        catch (BadBytecode badBytecode) {
            throw new RuntimeCopyException("bad bytecode. fatal?");
        }
    }

    @Override
    public int length() {
        return 18 + this.info.length + (this.exceptions.size() << 3) + AttributeInfo.getLength(this.attributes);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void write(DataOutputStream out) throws IOException {
        void var1_1;
        out.writeShort(this.name);
        out.writeInt(((AttributeInfo)this).length() - 6);
        out.writeShort(this.maxStack);
        out.writeShort(this.maxLocals);
        out.writeInt(this.info.length);
        out.write(this.info);
        this.exceptions.write(out);
        out.writeShort(this.attributes.size());
        AttributeInfo.writeAll(this.attributes, (DataOutputStream)var1_1);
    }

    @Override
    public byte[] get() {
        throw new UnsupportedOperationException("CodeAttribute.get()");
    }

    @Override
    public void set(byte[] newinfo) {
        throw new UnsupportedOperationException("CodeAttribute.set()");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void renameClass(String oldname, String newname) {
        void var2_2;
        void var1_1;
        AttributeInfo.renameClass(this.attributes, (String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void renameClass(Map<String, String> classnames) {
        void var1_1;
        AttributeInfo.renameClass(this.attributes, (Map<String, String>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void getRefClasses(Map<String, String> classnames) {
        void var1_1;
        AttributeInfo.getRefClasses(this.attributes, (Map<String, String>)var1_1);
    }

    public String getDeclaringClass() {
        ConstPool constPool = this.getConstPool();
        return constPool.getClassName();
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxStack(int value) {
        void var1_1;
        this.maxStack = var1_1;
    }

    public int computeMaxStack() throws BadBytecode {
        this.maxStack = new CodeAnalyzer(this).computeMaxStack();
        return this.maxStack;
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxLocals(int value) {
        void var1_1;
        this.maxLocals = var1_1;
    }

    public int getCodeLength() {
        return this.info.length;
    }

    public byte[] getCode() {
        return this.info;
    }

    /*
     * WARNING - void declaration
     */
    void setCode(byte[] newinfo) {
        void var1_1;
        super.set((byte[])var1_1);
    }

    public CodeIterator iterator() {
        return new CodeIterator(this);
    }

    public ExceptionTable getExceptionTable() {
        return this.exceptions;
    }

    public List<AttributeInfo> getAttributes() {
        return this.attributes;
    }

    /*
     * WARNING - void declaration
     */
    public AttributeInfo getAttribute(String name) {
        void var1_1;
        return AttributeInfo.lookup(this.attributes, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setAttribute(StackMapTable smt) {
        AttributeInfo.remove(this.attributes, "StackMapTable");
        if (smt != null) {
            void var1_1;
            this.attributes.add((AttributeInfo)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setAttribute(StackMap sm) {
        AttributeInfo.remove(this.attributes, "StackMap");
        if (sm != null) {
            void var1_1;
            this.attributes.add((AttributeInfo)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private byte[] copyCode(ConstPool destCp, Map<String, String> classnames, ExceptionTable etable, CodeAttribute destCa) throws BadBytecode {
        void var3_3;
        void var1_1;
        void var2_2;
        int len = this.getCodeLength();
        byte[] newCode = new byte[len];
        destCa.info = newCode;
        LdcEntry ldc = CodeAttribute.copyCode(this.info, 0, len, this.getConstPool(), newCode, destCp, (Map<String, String>)var2_2);
        return LdcEntry.doit(newCode, (LdcEntry)var1_1, (ExceptionTable)var3_3, destCa);
    }

    /*
     * WARNING - void declaration
     */
    private static LdcEntry copyCode(byte[] code, int beginPos, int endPos, ConstPool srcCp, byte[] newcode, ConstPool destCp, Map<String, String> classnameMap) throws BadBytecode {
        LdcEntry ldcEntry = null;
        int i2 = beginPos;
        while (i2 < endPos) {
            void var1_1;
            byte c2;
            int i22 = CodeIterator.nextOpcode(code, i2);
            newcode[i2] = c2 = code[i2];
            switch (c2 & 0xFF) {
                case 19: 
                case 20: 
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 187: 
                case 189: 
                case 192: 
                case 193: {
                    CodeAttribute.copyConstPoolInfo(i2 + 1, code, srcCp, newcode, destCp, classnameMap);
                    break;
                }
                case 18: {
                    int index = code[i2 + 1] & 0xFF;
                    index = srcCp.copy(index, destCp, classnameMap);
                    if (index < 256) {
                        newcode[i2 + 1] = (byte)index;
                        break;
                    }
                    newcode[i2] = 0;
                    newcode[i2 + 1] = 0;
                    LdcEntry ldc = new LdcEntry();
                    new LdcEntry().where = i2;
                    ldc.index = index;
                    ldc.next = ldcEntry;
                    ldcEntry = ldc;
                    break;
                }
                case 185: {
                    CodeAttribute.copyConstPoolInfo(i2 + 1, code, srcCp, newcode, destCp, classnameMap);
                    newcode[i2 + 3] = code[i2 + 3];
                    newcode[i2 + 4] = code[i2 + 4];
                    break;
                }
                case 186: {
                    CodeAttribute.copyConstPoolInfo(i2 + 1, code, srcCp, newcode, destCp, classnameMap);
                    newcode[i2 + 3] = 0;
                    newcode[i2 + 4] = 0;
                    break;
                }
                case 197: {
                    CodeAttribute.copyConstPoolInfo(i2 + 1, code, srcCp, newcode, destCp, classnameMap);
                    newcode[i2 + 3] = code[i2 + 3];
                    break;
                }
                default: {
                    while (++i2 < i22) {
                        newcode[i2] = code[i2];
                    }
                    break block0;
                }
            }
            i2 = var1_1;
        }
        return ldcEntry;
    }

    /*
     * WARNING - void declaration
     */
    private static void copyConstPoolInfo(int i2, byte[] code, ConstPool srcCp, byte[] newcode, ConstPool destCp, Map<String, String> classnameMap) {
        void var1_2;
        void var2_3;
        int index = (code[i2] & 0xFF) << 8 | code[i2 + 1] & 0xFF;
        index = var2_3.copy(index, destCp, classnameMap);
        newcode[i2] = (byte)(index >> 8);
        var3_4[var0 + 1] = (byte)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public void insertLocalVar(int where, int size) throws BadBytecode {
        void var2_2;
        CodeIterator ci = this.iterator();
        while (ci.hasNext()) {
            CodeAttribute.shiftIndex(ci, where, size);
        }
        CodeAttribute codeAttribute = this;
        codeAttribute.setMaxLocals(codeAttribute.getMaxLocals() + var2_2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static void shiftIndex(CodeIterator ci, int lessThan, int delta) throws BadBytecode {
        void var3_3;
        CodeIterator codeIterator;
        void var2_2;
        void var1_1;
        int var;
        int index = ci.next();
        int opcode = ci.byteAt(index);
        if (opcode < 21) {
            return;
        }
        if (opcode < 79) {
            if (opcode < 26) {
                CodeAttribute.shiftIndex8(ci, index, opcode, lessThan, delta);
                return;
            }
            if (opcode < 46) {
                CodeAttribute.shiftIndex0(ci, index, opcode, lessThan, delta, 26, 21);
                return;
            }
            if (opcode < 54) {
                return;
            }
            if (opcode < 59) {
                CodeAttribute.shiftIndex8(ci, index, opcode, lessThan, delta);
                return;
            }
            CodeAttribute.shiftIndex0(ci, index, opcode, lessThan, delta, 59, 54);
            return;
        }
        if (opcode == 132) {
            var = ci.byteAt(index + 1);
            if (var < lessThan) {
                return;
            }
            if ((var += delta) < 256) {
                ci.writeByte(var, index + 1);
                return;
            }
            byte plus2 = (byte)ci.byteAt(index + 2);
            int pos = ci.insertExGap(3);
            ci.writeByte(196, pos - 3);
            ci.writeByte(132, pos - 2);
            ci.write16bit(var, pos - 1);
            ci.write16bit((int)var1_1, (int)(var2_2 + true));
            return;
        }
        if (var == 169) {
            CodeAttribute.shiftIndex8(ci, index, var, (int)var1_1, (int)var2_2);
            return;
        }
        if (var != 196) return;
        var = ci.u16bitAt(index + 2);
        if (var < var1_1) {
            return;
        }
        codeIterator.write16bit(var += var2_2, (int)(var3_3 + 2));
    }

    /*
     * WARNING - void declaration
     */
    private static void shiftIndex8(CodeIterator ci, int index, int opcode, int lessThan, int delta) throws BadBytecode {
        void var1_1;
        CodeIterator codeIterator;
        void var2_2;
        void var3_3;
        int var = ci.byteAt(index + 1);
        if (var < var3_3) {
            return;
        }
        if ((var += delta) < 256) {
            ci.writeByte(var, index + 1);
            return;
        }
        int pos = ci.insertExGap(2);
        ci.writeByte(196, pos - 2);
        ci.writeByte((int)var2_2, pos - 1);
        codeIterator.write16bit(var, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static void shiftIndex0(CodeIterator ci, int index, int opcode, int lessThan, int delta, int opcode_i_0, int opcode_i) throws BadBytecode {
        void var1_1;
        CodeIterator codeIterator;
        void var2_2;
        int pos;
        void var3_3;
        int var = (opcode - opcode_i_0) % 4;
        if (var < var3_3) {
            return;
        }
        if ((var += delta) < 4) {
            ci.writeByte(opcode + delta, index);
            return;
        }
        opcode = (opcode - opcode_i_0) / 4 + opcode_i;
        if (var < 256) {
            pos = ci.insertExGap(1);
            ci.writeByte(opcode, pos - 1);
            ci.writeByte(var, pos);
            return;
        }
        pos = ci.insertExGap(3);
        ci.writeByte(196, pos - 1);
        ci.writeByte((int)var2_2, pos);
        codeIterator.write16bit(var, (int)(var1_1 + true));
    }

    public static class RuntimeCopyException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        /*
         * WARNING - void declaration
         */
        public RuntimeCopyException(String s2) {
            super((String)var1_1);
            void var1_1;
        }
    }

    static class LdcEntry {
        LdcEntry next;
        int where;
        int index;

        LdcEntry() {
        }

        /*
         * WARNING - void declaration
         */
        static byte[] doit(byte[] code, LdcEntry ldc, ExceptionTable etable, CodeAttribute ca) throws BadBytecode {
            byte[] byArray;
            if (ldc != null) {
                void var1_1;
                void var3_3;
                void var2_2;
                code = CodeIterator.changeLdcToLdcW(code, (ExceptionTable)var2_2, (CodeAttribute)var3_3, (LdcEntry)var1_1);
            }
            return byArray;
        }
    }
}

