/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode;

import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.BadBytecode;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.CodeAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.CodeIterator;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ConstPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.Descriptor;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ExceptionTable;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.Opcode;

class CodeAnalyzer
implements Opcode {
    private ConstPool constPool;
    private CodeAttribute codeAttr;

    /*
     * WARNING - void declaration
     */
    public CodeAnalyzer(CodeAttribute ca) {
        void var1_1;
        this.codeAttr = ca;
        this.constPool = var1_1.getConstPool();
    }

    public int computeMaxStack() throws BadBytecode {
        boolean repeat;
        CodeIterator ci = this.codeAttr.iterator();
        int length = ci.getCodeLength();
        int[] stack = new int[length];
        this.constPool = this.codeAttr.getConstPool();
        this.initStack(stack, this.codeAttr);
        do {
            repeat = false;
            for (int i2 = 0; i2 < length; ++i2) {
                if (stack[i2] >= 0) continue;
                repeat = true;
                this.visitBytecode(ci, stack, i2);
            }
        } while (repeat);
        int maxStack = 1;
        for (int i3 = 0; i3 < length; ++i3) {
            if (stack[i3] <= maxStack) continue;
            maxStack = stack[i3];
        }
        return maxStack - 1;
    }

    private void initStack(int[] stack, CodeAttribute ca) {
        stack[0] = -1;
        ExceptionTable et = ca.getExceptionTable();
        if (et != null) {
            int size = et.size();
            for (int i2 = 0; i2 < size; ++i2) {
                stack[et.handlerPc((int)i2)] = -2;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void visitBytecode(CodeIterator ci, int[] stack, int index) throws BadBytecode {
        int codeLength = stack.length;
        ci.move(index);
        int stackDepth = -stack[index];
        int[] nArray = new int[1];
        int[] jsrDepth = nArray;
        nArray[0] = -1;
        while (ci.hasNext()) {
            void var3_3;
            index = ci.next();
            stack[index] = stackDepth;
            int op = ci.byteAt(index);
            stackDepth = this.visitInst(op, ci, index, stackDepth);
            if (stackDepth <= 0) {
                throw new BadBytecode("stack underflow at " + index);
            }
            if (this.processBranch(op, ci, (int)var3_3, codeLength, stack, stackDepth, jsrDepth) || CodeAnalyzer.isEnd(op)) break;
            if (op != 168 && op != 201) continue;
            --stackDepth;
        }
    }

    private boolean processBranch(int opcode, CodeIterator ci, int index, int codeLength, int[] stack, int stackDepth, int[] jsrDepth) throws BadBytecode {
        if (153 <= opcode && opcode <= 166 || opcode == 198 || opcode == 199) {
            int target = index + ci.s16bitAt(index + 1);
            this.checkTarget(index, target, codeLength, stack, stackDepth);
        } else {
            switch (opcode) {
                case 167: {
                    int target = index + ci.s16bitAt(index + 1);
                    this.checkTarget(index, target, codeLength, stack, stackDepth);
                    return true;
                }
                case 200: {
                    int target = index + ci.s32bitAt(index + 1);
                    this.checkTarget(index, target, codeLength, stack, stackDepth);
                    return true;
                }
                case 168: 
                case 201: {
                    int target = opcode == 168 ? index + ci.s16bitAt(index + 1) : index + ci.s32bitAt(index + 1);
                    this.checkTarget(index, target, codeLength, stack, stackDepth);
                    if (jsrDepth[0] < 0) {
                        jsrDepth[0] = stackDepth;
                        return false;
                    }
                    if (stackDepth == jsrDepth[0]) {
                        return false;
                    }
                    throw new BadBytecode("sorry, cannot compute this data flow due to JSR: " + stackDepth + "," + jsrDepth[0]);
                }
                case 169: {
                    if (jsrDepth[0] < 0) {
                        jsrDepth[0] = stackDepth + 1;
                        return false;
                    }
                    if (stackDepth + 1 == jsrDepth[0]) {
                        return true;
                    }
                    throw new BadBytecode("sorry, cannot compute this data flow due to RET: " + stackDepth + "," + jsrDepth[0]);
                }
                case 170: 
                case 171: {
                    int index2 = (index & 0xFFFFFFFC) + 4;
                    int target = index + ci.s32bitAt(index2);
                    this.checkTarget(index, target, codeLength, stack, stackDepth);
                    if (opcode == 171) {
                        int npairs = ci.s32bitAt(index2 + 4);
                        index2 += 12;
                        for (int i2 = 0; i2 < npairs; ++i2) {
                            target = index + ci.s32bitAt(index2);
                            this.checkTarget(index, target, codeLength, stack, stackDepth);
                            index2 += 8;
                        }
                    } else {
                        int low = ci.s32bitAt(index2 + 4);
                        int i2 = ci.s32bitAt(index2 + 8);
                        int n2 = i2 - low + 1;
                        index2 += 12;
                        for (i2 = 0; i2 < n2; ++i2) {
                            target = index + ci.s32bitAt(index2);
                            this.checkTarget(index, target, codeLength, stack, stackDepth);
                            index2 += 4;
                        }
                    }
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void checkTarget(int opIndex, int target, int codeLength, int[] stack, int stackDepth) throws BadBytecode {
        if (target < 0 || codeLength <= target) {
            throw new BadBytecode("bad branch offset at " + opIndex);
        }
        int d2 = stack[target];
        if (d2 == 0) {
            stack[var2_2] = -stackDepth;
            return;
        }
        if (d2 != stackDepth && d2 != -stackDepth) {
            void var1_1;
            void var3_3;
            throw new BadBytecode("verification error (" + stackDepth + "," + (int)var3_3 + ") at " + (int)var1_1);
        }
    }

    private static boolean isEnd(int opcode) {
        int n2;
        return 172 <= opcode && opcode <= 177 || n2 == 191;
    }

    /*
     * WARNING - void declaration
     */
    private int visitInst(int op, CodeIterator ci, int index, int stack) throws BadBytecode {
        switch (op) {
            case 180: {
                stack += this.getFieldSize(ci, index) - 1;
                break;
            }
            case 181: {
                stack -= this.getFieldSize(ci, index) + 1;
                break;
            }
            case 178: {
                stack += this.getFieldSize(ci, index);
                break;
            }
            case 179: {
                stack -= this.getFieldSize(ci, index);
                break;
            }
            case 182: 
            case 183: {
                String desc = this.constPool.getMethodrefType(ci.u16bitAt(index + 1));
                stack += Descriptor.dataSize(desc) - 1;
                break;
            }
            case 184: {
                String desc = this.constPool.getMethodrefType(ci.u16bitAt(index + 1));
                stack += Descriptor.dataSize(desc);
                break;
            }
            case 185: {
                String desc = this.constPool.getInterfaceMethodrefType(ci.u16bitAt(index + 1));
                stack += Descriptor.dataSize(desc) - 1;
                break;
            }
            case 186: {
                void var1_5;
                String desc = this.constPool.getInvokeDynamicType(ci.u16bitAt(index + 1));
                stack += Descriptor.dataSize((String)var1_5);
                break;
            }
            case 191: {
                stack = 1;
                break;
            }
            case 197: {
                stack += 1 - ci.byteAt(index + 3);
                break;
            }
            case 196: {
                void var3_7;
                void var2_6;
                int n2 = var2_6.byteAt((int)(var3_7 + true));
            }
            default: {
                int n2;
                stack += STACK_GROW[n2];
            }
        }
        return stack;
    }

    /*
     * WARNING - void declaration
     */
    private int getFieldSize(CodeIterator ci, int index) {
        void var2_2;
        String string;
        string = this.constPool.getFieldrefType(((CodeIterator)((Object)string)).u16bitAt((int)(var2_2 + true)));
        return Descriptor.dataSize(string);
    }
}

