/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode;

import com.alibaba.ttl.threadpool.agent.internal.javassist.CannotCompileException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.AttributeInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.BadBytecode;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ConstPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.Descriptor;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.DuplicateMemberException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.FieldInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.InnerClassesAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.MethodInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.SourceFileAttribute;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public final class ClassFile {
    int major;
    int minor;
    ConstPool constPool;
    int thisClass;
    int accessFlags;
    int superClass;
    int[] interfaces;
    List<FieldInfo> fields;
    List<MethodInfo> methods;
    List<AttributeInfo> attributes;
    String thisclassname;
    String[] cachedInterfaces;
    String cachedSuperclass;
    public static final int JAVA_1 = 45;
    public static final int JAVA_2 = 46;
    public static final int JAVA_3 = 47;
    public static final int JAVA_4 = 48;
    public static final int JAVA_5 = 49;
    public static final int JAVA_6 = 50;
    public static final int JAVA_7 = 51;
    public static final int JAVA_8 = 52;
    public static final int JAVA_9 = 53;
    public static final int JAVA_10 = 54;
    public static final int JAVA_11 = 55;
    public static final int MAJOR_VERSION;

    /*
     * WARNING - void declaration
     */
    public ClassFile(DataInputStream in) throws IOException {
        void var1_1;
        this.read((DataInputStream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ClassFile(boolean isInterface, String classname, String superclass) {
        void var2_2;
        void var3_3;
        void var1_1;
        this.major = MAJOR_VERSION;
        this.minor = 0;
        this.constPool = new ConstPool(classname);
        this.thisClass = this.constPool.getThisClassInfo();
        this.accessFlags = var1_1 != false ? 1536 : 32;
        this.initSuperclass((String)var3_3);
        this.interfaces = null;
        this.fields = new ArrayList<FieldInfo>();
        this.methods = new ArrayList<MethodInfo>();
        this.thisclassname = var2_2;
        this.attributes = new ArrayList<AttributeInfo>();
        this.attributes.add(new SourceFileAttribute(this.constPool, ClassFile.getSourcefileName(this.thisclassname)));
    }

    /*
     * WARNING - void declaration
     */
    private void initSuperclass(String superclass) {
        if (superclass != null) {
            void var1_1;
            this.superClass = this.constPool.addClassInfo(superclass);
            this.cachedSuperclass = var1_1;
            return;
        }
        this.superClass = this.constPool.addClassInfo("java.lang.Object");
        this.cachedSuperclass = "java.lang.Object";
    }

    private static String getSourcefileName(String qname) {
        String string;
        return string.replaceAll("^.*\\.", "") + ".java";
    }

    /*
     * WARNING - void declaration
     */
    public final void compact() {
        void var1_1;
        ConstPool cp = this.compact0();
        for (MethodInfo object : this.methods) {
            object.compact(cp);
        }
        for (FieldInfo fieldInfo : this.fields) {
            fieldInfo.compact(cp);
        }
        this.attributes = AttributeInfo.copyAll(this.attributes, cp);
        this.constPool = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private ConstPool compact0() {
        void var1_1;
        ConstPool cp = new ConstPool(this.thisclassname);
        this.thisClass = cp.getThisClassInfo();
        String string = this.getSuperclass();
        if (string != null) {
            this.superClass = cp.addClassInfo(this.getSuperclass());
        }
        if (this.interfaces != null) {
            for (int i2 = 0; i2 < this.interfaces.length; ++i2) {
                this.interfaces[i2] = cp.addClassInfo(this.constPool.getClassInfo(this.interfaces[i2]));
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void prune() {
        void var1_1;
        void var2_2;
        AttributeInfo signature;
        AttributeInfo visibleAnnotations;
        ConstPool cp = this.compact0();
        ArrayList<Object> newAttributes = new ArrayList<Object>();
        AttributeInfo invisibleAnnotations = this.getAttribute("RuntimeInvisibleAnnotations");
        if (invisibleAnnotations != null) {
            invisibleAnnotations = invisibleAnnotations.copy(cp, null);
            newAttributes.add(invisibleAnnotations);
        }
        if ((visibleAnnotations = this.getAttribute("RuntimeVisibleAnnotations")) != null) {
            visibleAnnotations = visibleAnnotations.copy(cp, null);
            newAttributes.add(visibleAnnotations);
        }
        if ((signature = this.getAttribute("Signature")) != null) {
            Iterator<Object> iterator2;
            signature = signature.copy(cp, null);
            newAttributes.add(iterator2);
        }
        for (MethodInfo object : this.methods) {
            object.prune(cp);
        }
        for (FieldInfo fieldInfo : this.fields) {
            fieldInfo.prune(cp);
        }
        this.attributes = var2_2;
        this.constPool = var1_1;
    }

    public final ConstPool getConstPool() {
        return this.constPool;
    }

    public final boolean isInterface() {
        return (this.accessFlags & 0x200) != 0;
    }

    public final boolean isFinal() {
        return (this.accessFlags & 0x10) != 0;
    }

    public final boolean isAbstract() {
        return (this.accessFlags & 0x400) != 0;
    }

    public final int getAccessFlags() {
        return this.accessFlags;
    }

    /*
     * WARNING - void declaration
     */
    public final void setAccessFlags(int acc) {
        void var1_1;
        if ((acc & 0x200) == 0) {
            acc |= 0x20;
        }
        this.accessFlags = var1_1;
    }

    public final int getInnerAccessFlags() {
        InnerClassesAttribute ica = (InnerClassesAttribute)this.getAttribute("InnerClasses");
        if (ica == null) {
            return -1;
        }
        String name = this.getName();
        int n2 = ica.tableLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!name.equals(ica.innerClass(i2))) continue;
            return ica.accessFlags(i2);
        }
        return -1;
    }

    public final String getName() {
        return this.thisclassname;
    }

    /*
     * WARNING - void declaration
     */
    public final void setName(String name) {
        void var1_1;
        ClassFile classFile = this;
        classFile.renameClass(classFile.thisclassname, (String)var1_1);
    }

    public final String getSuperclass() {
        if (this.cachedSuperclass == null) {
            this.cachedSuperclass = this.constPool.getClassInfo(this.superClass);
        }
        return this.cachedSuperclass;
    }

    public final int getSuperclassId() {
        return this.superClass;
    }

    /*
     * WARNING - void declaration
     */
    public final void setSuperclass(String superclass) throws CannotCompileException {
        void var1_1;
        if (superclass == null) {
            superclass = "java.lang.Object";
        }
        try {
            this.superClass = this.constPool.addClassInfo(superclass);
            for (MethodInfo methodInfo : this.methods) {
                methodInfo.setSuperclass(superclass);
            }
        }
        catch (BadBytecode e2) {
            void var2_3;
            throw new CannotCompileException((Throwable)var2_3);
        }
        this.cachedSuperclass = var1_1;
    }

    public final void renameClass(String oldname, String newname) {
        String desc;
        if (oldname.equals(newname)) {
            return;
        }
        if (oldname.equals(this.thisclassname)) {
            this.thisclassname = newname;
        }
        oldname = Descriptor.toJvmName(oldname);
        newname = Descriptor.toJvmName(newname);
        this.constPool.renameClass(oldname, newname);
        AttributeInfo.renameClass(this.attributes, oldname, newname);
        for (MethodInfo minfo : this.methods) {
            desc = minfo.getDescriptor();
            minfo.setDescriptor(Descriptor.rename(desc, oldname, newname));
            AttributeInfo.renameClass(minfo.getAttributes(), oldname, newname);
        }
        for (FieldInfo finfo : this.fields) {
            desc = finfo.getDescriptor();
            finfo.setDescriptor(Descriptor.rename(desc, oldname, newname));
            AttributeInfo.renameClass(finfo.getAttributes(), oldname, newname);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void renameClass(Map<String, String> classnames) {
        String desc;
        String jvmNewThisName = classnames.get(Descriptor.toJvmName(this.thisclassname));
        if (jvmNewThisName != null) {
            Iterator<Object> iterator2;
            this.thisclassname = Descriptor.toJavaName((String)((Object)iterator2));
        }
        this.constPool.renameClass(classnames);
        AttributeInfo.renameClass(this.attributes, classnames);
        for (MethodInfo minfo : this.methods) {
            desc = minfo.getDescriptor();
            minfo.setDescriptor(Descriptor.rename(desc, classnames));
            AttributeInfo.renameClass(minfo.getAttributes(), classnames);
        }
        for (FieldInfo finfo : this.fields) {
            void var3_3;
            desc = finfo.getDescriptor();
            finfo.setDescriptor(Descriptor.rename(desc, classnames));
            AttributeInfo.renameClass(var3_3.getAttributes(), classnames);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void getRefClasses(Map<String, String> classnames) {
        String string;
        this.constPool.renameClass(classnames);
        AttributeInfo.getRefClasses(this.attributes, classnames);
        for (MethodInfo minfo : this.methods) {
            string = minfo.getDescriptor();
            Descriptor.rename(string, classnames);
            AttributeInfo.getRefClasses(minfo.getAttributes(), classnames);
        }
        for (FieldInfo finfo : this.fields) {
            void var3_3;
            string = finfo.getDescriptor();
            Descriptor.rename(string, classnames);
            AttributeInfo.getRefClasses(var3_3.getAttributes(), classnames);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final String[] getInterfaces() {
        void var1_1;
        if (this.cachedInterfaces != null) {
            return this.cachedInterfaces;
        }
        if (this.interfaces == null) {
            String[] rtn = new String[]{};
        } else {
            String[] list = new String[this.interfaces.length];
            for (int i2 = 0; i2 < this.interfaces.length; ++i2) {
                list[i2] = this.constPool.getClassInfo(this.interfaces[i2]);
            }
        }
        this.cachedInterfaces = var1_1;
        return var1_1;
    }

    public final void setInterfaces(String[] nameList) {
        this.cachedInterfaces = null;
        if (nameList != null) {
            this.interfaces = new int[nameList.length];
            for (int i2 = 0; i2 < nameList.length; ++i2) {
                this.interfaces[i2] = this.constPool.addClassInfo(nameList[i2]);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void addInterface(String name) {
        void var3_4;
        void var1_2;
        this.cachedInterfaces = null;
        int info = this.constPool.addClassInfo(name);
        if (this.interfaces == null) {
            this.interfaces = new int[1];
            this.interfaces[0] = info;
            return;
        }
        int n2 = this.interfaces.length;
        int[] newarray = new int[n2 + 1];
        System.arraycopy(this.interfaces, 0, newarray, 0, n2);
        newarray[var2_3] = var1_2;
        this.interfaces = var3_4;
    }

    public final List<FieldInfo> getFields() {
        return this.fields;
    }

    /*
     * WARNING - void declaration
     */
    public final void addField(FieldInfo finfo) throws DuplicateMemberException {
        void var1_1;
        this.testExistingField(finfo.getName(), finfo.getDescriptor());
        this.fields.add((FieldInfo)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void addField2(FieldInfo finfo) {
        void var1_1;
        this.fields.add((FieldInfo)var1_1);
    }

    private void testExistingField(String name, String descriptor) throws DuplicateMemberException {
        for (FieldInfo fieldInfo : this.fields) {
            if (!fieldInfo.getName().equals(name)) continue;
            throw new DuplicateMemberException("duplicate field: " + name);
        }
    }

    public final List<MethodInfo> getMethods() {
        return this.methods;
    }

    /*
     * WARNING - void declaration
     */
    public final MethodInfo getMethod(String name) {
        for (MethodInfo minfo : this.methods) {
            void var3_3;
            if (!minfo.getName().equals(name)) continue;
            return var3_3;
        }
        return null;
    }

    public final MethodInfo getStaticInitializer() {
        return this.getMethod("<clinit>");
    }

    /*
     * WARNING - void declaration
     */
    public final void addMethod(MethodInfo minfo) throws DuplicateMemberException {
        void var1_1;
        this.testExistingMethod(minfo);
        this.methods.add((MethodInfo)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void addMethod2(MethodInfo minfo) {
        void var1_1;
        this.methods.add((MethodInfo)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void testExistingMethod(MethodInfo newMinfo) throws DuplicateMemberException {
        String name = newMinfo.getName();
        String descriptor = newMinfo.getDescriptor();
        ListIterator<MethodInfo> it = this.methods.listIterator(0);
        while (it.hasNext()) {
            void var2_2;
            if (!ClassFile.isDuplicated(newMinfo, name, descriptor, it.next(), it)) continue;
            throw new DuplicateMemberException("duplicate method: " + (String)var2_2 + " in " + this.getName());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isDuplicated(MethodInfo newMethod, String newName, String newDesc, MethodInfo minfo, ListIterator<MethodInfo> it) {
        void var2_2;
        String string;
        void var1_1;
        if (!minfo.getName().equals(var1_1)) {
            return false;
        }
        String desc = minfo.getDescriptor();
        if (!Descriptor.eqParamTypes(desc, newDesc)) {
            return false;
        }
        if (string.equals(var2_2)) {
            void var3_3;
            if (ClassFile.notBridgeMethod((MethodInfo)var3_3)) {
                return true;
            }
            it.remove();
            return false;
        }
        return false;
    }

    private static boolean notBridgeMethod(MethodInfo minfo) {
        return (minfo.getAccessFlags() & 0x40) == 0;
    }

    public final List<AttributeInfo> getAttributes() {
        return this.attributes;
    }

    /*
     * WARNING - void declaration
     */
    public final AttributeInfo getAttribute(String name) {
        for (AttributeInfo ai : this.attributes) {
            void var3_3;
            if (!ai.getName().equals(name)) continue;
            return var3_3;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final AttributeInfo removeAttribute(String name) {
        void var1_1;
        return AttributeInfo.remove(this.attributes, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void addAttribute(AttributeInfo info) {
        void var1_1;
        AttributeInfo.remove(this.attributes, info.getName());
        this.attributes.add((AttributeInfo)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final String getSourceFile() {
        void var1_1;
        SourceFileAttribute sf = (SourceFileAttribute)this.getAttribute("SourceFile");
        if (sf == null) {
            return null;
        }
        return var1_1.getFileName();
    }

    private void read(DataInputStream in) throws IOException {
        int i2;
        int magic = in.readInt();
        if (magic != -889275714) {
            throw new IOException("bad magic number: " + Integer.toHexString(magic));
        }
        this.minor = in.readUnsignedShort();
        this.major = in.readUnsignedShort();
        this.constPool = new ConstPool(in);
        this.accessFlags = in.readUnsignedShort();
        this.thisClass = in.readUnsignedShort();
        this.constPool.setThisClassInfo(this.thisClass);
        this.superClass = in.readUnsignedShort();
        int n2 = in.readUnsignedShort();
        if (n2 == 0) {
            this.interfaces = null;
        } else {
            this.interfaces = new int[n2];
            for (i2 = 0; i2 < n2; ++i2) {
                this.interfaces[i2] = in.readUnsignedShort();
            }
        }
        ConstPool cp = this.constPool;
        n2 = in.readUnsignedShort();
        this.fields = new ArrayList<FieldInfo>();
        for (i2 = 0; i2 < n2; ++i2) {
            this.addField2(new FieldInfo(cp, in));
        }
        n2 = in.readUnsignedShort();
        this.methods = new ArrayList<MethodInfo>();
        for (i2 = 0; i2 < n2; ++i2) {
            this.addMethod2(new MethodInfo(cp, in));
        }
        this.attributes = new ArrayList<AttributeInfo>();
        n2 = in.readUnsignedShort();
        for (i2 = 0; i2 < n2; ++i2) {
            this.addAttribute(AttributeInfo.read(cp, in));
        }
        this.thisclassname = this.constPool.getClassInfo(this.thisClass);
    }

    /*
     * WARNING - void declaration
     */
    public final void write(DataOutputStream out) throws IOException {
        void var1_1;
        int i2;
        out.writeInt(-889275714);
        out.writeShort(this.minor);
        out.writeShort(this.major);
        this.constPool.write(out);
        out.writeShort(this.accessFlags);
        out.writeShort(this.thisClass);
        out.writeShort(this.superClass);
        int n2 = this.interfaces == null ? 0 : this.interfaces.length;
        out.writeShort(n2);
        for (i2 = 0; i2 < n2; ++i2) {
            out.writeShort(this.interfaces[i2]);
        }
        n2 = this.fields.size();
        out.writeShort(n2);
        for (i2 = 0; i2 < n2; ++i2) {
            FieldInfo fieldInfo = this.fields.get(i2);
            fieldInfo.write(out);
        }
        out.writeShort(this.methods.size());
        for (MethodInfo methodInfo : this.methods) {
            methodInfo.write(out);
        }
        out.writeShort(this.attributes.size());
        AttributeInfo.writeAll(this.attributes, (DataOutputStream)var1_1);
    }

    public final int getMajorVersion() {
        return this.major;
    }

    /*
     * WARNING - void declaration
     */
    public final void setMajorVersion(int major) {
        void var1_1;
        this.major = var1_1;
    }

    public final int getMinorVersion() {
        return this.minor;
    }

    /*
     * WARNING - void declaration
     */
    public final void setMinorVersion(int minor) {
        void var1_1;
        this.minor = var1_1;
    }

    public final void setVersionToJava5() {
        this.major = 49;
        this.minor = 0;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        int ver = 47;
        try {
            Class.forName("java.lang.StringBuilder");
            ver = 49;
            Class.forName("java.util.zip.DeflaterInputStream");
            ver = 50;
            Class.forName("java.lang.invoke.CallSite", false, ClassLoader.getSystemClassLoader());
            ver = 51;
            Class.forName("java.util.function.Function");
            ver = 52;
            Class.forName("java.lang.Module");
            ver = 53;
            List.class.getMethod("copyOf", Collection.class);
            ver = 54;
            Class.forName("java.util.Optional").getMethod("isEmpty", new Class[0]);
            ver = 55;
        }
        catch (Throwable throwable) {}
        MAJOR_VERSION = var0;
    }
}

