/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode;

import java.io.IOException;
import java.io.OutputStream;

final class ByteStream
extends OutputStream {
    private byte[] buf;
    private int count;

    public ByteStream() {
        this(32);
    }

    /*
     * WARNING - void declaration
     */
    public ByteStream(int size) {
        void var1_1;
        this.buf = new byte[var1_1];
        this.count = 0;
    }

    public final int getPos() {
        return this.count;
    }

    public final int size() {
        return this.count;
    }

    /*
     * WARNING - void declaration
     */
    public final void writeBlank(int len) {
        void var1_1;
        this.enlarge(len);
        this.count += var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void write(byte[] data) {
        void var1_1;
        this.write(data, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void write(byte[] data, int off, int len) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.enlarge(len);
        System.arraycopy(var1_1, (int)var2_2, this.buf, this.count, len);
        this.count += var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void write(int b2) {
        void var2_2;
        void var1_1;
        this.enlarge(1);
        int oldCount = this.count;
        this.buf[oldCount] = (byte)var1_1;
        this.count = var2_2 + true;
    }

    /*
     * WARNING - void declaration
     */
    public final void writeShort(int s2) {
        void var2_2;
        void var1_1;
        this.enlarge(2);
        int oldCount = this.count;
        this.buf[oldCount] = (byte)(s2 >>> 8);
        this.buf[oldCount + 1] = (byte)var1_1;
        this.count = var2_2 + 2;
    }

    /*
     * WARNING - void declaration
     */
    public final void writeInt(int i2) {
        void var2_2;
        void var1_1;
        this.enlarge(4);
        int oldCount = this.count;
        this.buf[oldCount] = (byte)(i2 >>> 24);
        this.buf[oldCount + 1] = (byte)(i2 >>> 16);
        this.buf[oldCount + 2] = (byte)(i2 >>> 8);
        this.buf[oldCount + 3] = (byte)var1_1;
        this.count = var2_2 + 4;
    }

    /*
     * WARNING - void declaration
     */
    public final void writeLong(long i2) {
        void var3_2;
        void var1_1;
        this.enlarge(8);
        int oldCount = this.count;
        this.buf[oldCount] = (byte)(i2 >>> 56);
        this.buf[oldCount + 1] = (byte)(i2 >>> 48);
        this.buf[oldCount + 2] = (byte)(i2 >>> 40);
        this.buf[oldCount + 3] = (byte)(i2 >>> 32);
        this.buf[oldCount + 4] = (byte)(i2 >>> 24);
        this.buf[oldCount + 5] = (byte)(i2 >>> 16);
        this.buf[oldCount + 6] = (byte)(i2 >>> 8);
        this.buf[oldCount + 7] = (byte)var1_1;
        this.count = var3_2 + 8;
    }

    /*
     * WARNING - void declaration
     */
    public final void writeFloat(float v2) {
        void var1_1;
        this.writeInt(Float.floatToIntBits((float)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final void writeDouble(double v2) {
        void var1_1;
        this.writeLong(Double.doubleToLongBits((double)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final void writeUTF(String s2) {
        void var3_3;
        int sLen = s2.length();
        int pos = this.count;
        this.enlarge(sLen + 2);
        byte[] buffer = this.buf;
        this.buf[pos++] = (byte)(sLen >>> 8);
        buffer[pos++] = (byte)sLen;
        for (int i2 = 0; i2 < sLen; ++i2) {
            char c2 = s2.charAt(i2);
            if (c2 <= '\u0000' || c2 > '\u007f') {
                this.writeUTF2(s2, sLen, i2);
                return;
            }
            buffer[pos++] = (byte)c2;
        }
        this.count = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private void writeUTF2(String s2, int sLen, int offset) {
        void j2;
        int size = sLen;
        for (int i2 = offset; i2 < sLen; ++i2) {
            char c2 = s2.charAt(i2);
            if (c2 > '\u07ff') {
                size += 2;
                continue;
            }
            if (c2 != '\u0000' && c2 <= '\u007f') continue;
            ++size;
        }
        if (size > 65535) {
            throw new RuntimeException("encoded string too long: " + sLen + size + " bytes");
        }
        this.enlarge(size + 2);
        int pos = this.count;
        byte[] buffer = this.buf;
        this.buf[pos] = (byte)(size >>> 8);
        buffer[pos + 1] = (byte)size;
        pos += offset + 2;
        while (j2 < sLen) {
            char c3 = s2.charAt((int)j2);
            if (c3 > '\u0000' && c3 <= '\u007f') {
                buffer[pos++] = (byte)c3;
            } else if (c3 > '\u07ff') {
                buffer[pos] = (byte)(0xE0 | c3 >> 12 & 0xF);
                buffer[pos + 1] = (byte)(0x80 | c3 >> 6 & 0x3F);
                buffer[pos + 2] = (byte)(0x80 | c3 & 0x3F);
                pos += 3;
            } else {
                buffer[pos] = (byte)(0xC0 | c3 >> 6 & 0x1F);
                buffer[pos + 1] = (byte)(0x80 | c3 & 0x3F);
                pos += 2;
            }
            ++j2;
        }
        this.count = pos;
    }

    /*
     * WARNING - void declaration
     */
    public final void write(int pos, int value) {
        void var2_2;
        this.buf[var1_1] = (byte)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final void writeShort(int pos, int value) {
        void var2_2;
        this.buf[pos] = (byte)(value >>> 8);
        this.buf[var1_1 + true] = (byte)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final void writeInt(int pos, int value) {
        void var2_2;
        this.buf[pos] = (byte)(value >>> 24);
        this.buf[pos + 1] = (byte)(value >>> 16);
        this.buf[pos + 2] = (byte)(value >>> 8);
        this.buf[var1_1 + 3] = (byte)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final byte[] toByteArray() {
        void var1_1;
        byte[] buf2 = new byte[this.count];
        System.arraycopy(this.buf, 0, buf2, 0, this.count);
        return var1_1;
    }

    public final void writeTo(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.count);
    }

    /*
     * WARNING - void declaration
     */
    public final void enlarge(int delta) {
        int newCount = this.count + delta;
        if (newCount > this.buf.length) {
            void var1_2;
            int n2;
            int newLen = this.buf.length << 1;
            byte[] newBuf = new byte[newLen > newCount ? n2 : newCount];
            System.arraycopy(this.buf, 0, newBuf, 0, this.count);
            this.buf = var1_2;
        }
    }
}

