/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode;

import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.AnnotationDefaultAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.AnnotationsAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.BootstrapMethodsAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.CodeAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ConstPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ConstantAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.DeprecatedAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.EnclosingMethodAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ExceptionsAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.InnerClassesAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.LineNumberAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.LocalVariableAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.LocalVariableTypeAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.MethodParametersAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.NestHostAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.NestMembersAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ParameterAnnotationsAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.SignatureAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.SourceFileAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.StackMap;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.StackMapTable;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.SyntheticAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.TypeAnnotationsAttribute;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AttributeInfo {
    protected ConstPool constPool;
    int name;
    byte[] info;

    /*
     * WARNING - void declaration
     */
    protected AttributeInfo(ConstPool cp, int attrname, byte[] attrinfo) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.constPool = var1_1;
        this.name = var2_2;
        this.info = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    protected AttributeInfo(ConstPool cp, String attrname) {
        this((ConstPool)var1_1, (String)var2_2, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public AttributeInfo(ConstPool cp, String attrname, byte[] attrinfo) {
        void var3_3;
        void var2_2;
        void var1_1;
        void v0 = var1_1;
        this((ConstPool)v0, v0.addUtf8Info((String)var2_2), (byte[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected AttributeInfo(ConstPool cp, int n2, DataInputStream in) throws IOException {
        void var1_2;
        void var2_3;
        this.constPool = cp;
        this.name = var2_3;
        int len = in.readInt();
        this.info = new byte[len];
        if (var1_2 > 0) {
            void var3_4;
            var3_4.readFully(this.info);
        }
    }

    /*
     * WARNING - void declaration
     */
    static AttributeInfo read(ConstPool cp, DataInputStream in) throws IOException {
        void var1_1;
        void var2_2;
        ConstPool constPool;
        int name = in.readUnsignedShort();
        String nameStr = cp.getUtf8Info(name);
        char first = nameStr.charAt(0);
        if (first < 'E') {
            if (nameStr.equals("AnnotationDefault")) {
                return new AnnotationDefaultAttribute(cp, name, in);
            }
            if (nameStr.equals("BootstrapMethods")) {
                return new BootstrapMethodsAttribute(cp, name, in);
            }
            if (nameStr.equals("Code")) {
                return new CodeAttribute(cp, name, in);
            }
            if (nameStr.equals("ConstantValue")) {
                return new ConstantAttribute(cp, name, in);
            }
            if (nameStr.equals("Deprecated")) {
                return new DeprecatedAttribute(cp, name, in);
            }
        }
        if (first < 'M') {
            if (nameStr.equals("EnclosingMethod")) {
                return new EnclosingMethodAttribute(cp, name, in);
            }
            if (nameStr.equals("Exceptions")) {
                return new ExceptionsAttribute(cp, name, in);
            }
            if (nameStr.equals("InnerClasses")) {
                return new InnerClassesAttribute(cp, name, in);
            }
            if (nameStr.equals("LineNumberTable")) {
                return new LineNumberAttribute(cp, name, in);
            }
            if (nameStr.equals("LocalVariableTable")) {
                return new LocalVariableAttribute(cp, name, in);
            }
            if (nameStr.equals("LocalVariableTypeTable")) {
                return new LocalVariableTypeAttribute(cp, name, in);
            }
        }
        if (first < 'S') {
            if (nameStr.equals("MethodParameters")) {
                return new MethodParametersAttribute(cp, name, in);
            }
            if (nameStr.equals("NestHost")) {
                return new NestHostAttribute(cp, name, in);
            }
            if (nameStr.equals("NestMembers")) {
                return new NestMembersAttribute(cp, name, in);
            }
            if (nameStr.equals("RuntimeVisibleAnnotations") || nameStr.equals("RuntimeInvisibleAnnotations")) {
                return new AnnotationsAttribute(cp, name, in);
            }
            if (nameStr.equals("RuntimeVisibleParameterAnnotations") || nameStr.equals("RuntimeInvisibleParameterAnnotations")) {
                return new ParameterAnnotationsAttribute(cp, name, in);
            }
            if (nameStr.equals("RuntimeVisibleTypeAnnotations") || nameStr.equals("RuntimeInvisibleTypeAnnotations")) {
                return new TypeAnnotationsAttribute(cp, name, in);
            }
        }
        if (first >= 'S') {
            void var3_3;
            if (nameStr.equals("Signature")) {
                return new SignatureAttribute(cp, name, in);
            }
            if (nameStr.equals("SourceFile")) {
                return new SourceFileAttribute(cp, name, in);
            }
            if (nameStr.equals("Synthetic")) {
                return new SyntheticAttribute(cp, name, in);
            }
            if (nameStr.equals("StackMap")) {
                return new StackMap(cp, name, in);
            }
            if (var3_3.equals("StackMapTable")) {
                return new StackMapTable(cp, name, in);
            }
        }
        return new AttributeInfo(constPool, (int)var2_2, (DataInputStream)var1_1);
    }

    public String getName() {
        return this.constPool.getUtf8Info(this.name);
    }

    public ConstPool getConstPool() {
        return this.constPool;
    }

    public int length() {
        return this.info.length + 6;
    }

    public byte[] get() {
        return this.info;
    }

    /*
     * WARNING - void declaration
     */
    public void set(byte[] newinfo) {
        void var1_1;
        this.info = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public AttributeInfo copy(ConstPool newCp, Map<String, String> classnames) {
        void var1_1;
        return new AttributeInfo((ConstPool)var1_1, this.getName(), Arrays.copyOf(this.info, this.info.length));
    }

    /*
     * WARNING - void declaration
     */
    void write(DataOutputStream out) throws IOException {
        out.writeShort(this.name);
        out.writeInt(this.info.length);
        if (this.info.length > 0) {
            void var1_1;
            var1_1.write(this.info);
        }
    }

    /*
     * WARNING - void declaration
     */
    static int getLength(List<AttributeInfo> attributes) {
        void var1_1;
        Iterator<AttributeInfo> iterator2;
        int size = 0;
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            void var2_2;
            AttributeInfo attr = (AttributeInfo)iterator2.next();
            size += var2_2.length();
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static AttributeInfo lookup(List<AttributeInfo> attributes, String name) {
        Iterator<AttributeInfo> iterator2;
        if (attributes == null) {
            return null;
        }
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            void var2_2;
            AttributeInfo ai = (AttributeInfo)iterator2.next();
            if (!ai.getName().equals(name)) continue;
            return var2_2;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    static synchronized AttributeInfo remove(List<AttributeInfo> attributes, String name) {
        if (attributes == null) {
            return null;
        }
        for (AttributeInfo ai : attributes) {
            void var3_3;
            if (!ai.getName().equals(name) || !attributes.remove(ai)) continue;
            return var3_3;
        }
        return null;
    }

    static void writeAll(List<AttributeInfo> attributes, DataOutputStream out) throws IOException {
        Iterator<AttributeInfo> iterator2;
        if (attributes == null) {
            return;
        }
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            AttributeInfo attributeInfo = (AttributeInfo)iterator2.next();
            attributeInfo.write(out);
        }
    }

    /*
     * WARNING - void declaration
     */
    static List<AttributeInfo> copyAll(List<AttributeInfo> attributes, ConstPool cp) {
        void var2_2;
        Iterator<AttributeInfo> iterator2;
        if (attributes == null) {
            return null;
        }
        ArrayList<AttributeInfo> newList = new ArrayList<AttributeInfo>();
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            void var3_3;
            AttributeInfo attr = (AttributeInfo)iterator2.next();
            newList.add(var3_3.copy(cp, null));
        }
        return var2_2;
    }

    void renameClass(String oldname, String newname) {
    }

    void renameClass(Map<String, String> classnames) {
    }

    static void renameClass(List<AttributeInfo> attributes, String oldname, String newname) {
        Iterator<AttributeInfo> iterator2;
        if (attributes == null) {
            return;
        }
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            AttributeInfo attributeInfo = (AttributeInfo)iterator2.next();
            attributeInfo.renameClass(oldname, newname);
        }
    }

    static void renameClass(List<AttributeInfo> attributes, Map<String, String> classnames) {
        Iterator<AttributeInfo> iterator2;
        if (attributes == null) {
            return;
        }
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            AttributeInfo attributeInfo = (AttributeInfo)iterator2.next();
            attributeInfo.renameClass(classnames);
        }
    }

    void getRefClasses(Map<String, String> classnames) {
    }

    static void getRefClasses(List<AttributeInfo> attributes, Map<String, String> classnames) {
        Iterator<AttributeInfo> iterator2;
        if (attributes == null) {
            return;
        }
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            AttributeInfo attributeInfo = (AttributeInfo)iterator2.next();
            attributeInfo.getRefClasses(classnames);
        }
    }
}

